/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudformation.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a Hook invocation, its status, and the reason for its status.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class HookResultSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<HookResultSummary.Builder, HookResultSummary> {
    private static final SdkField<String> INVOCATION_POINT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InvocationPoint").getter(getter(HookResultSummary::invocationPointAsString))
            .setter(setter(Builder::invocationPoint))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InvocationPoint").build()).build();

    private static final SdkField<String> FAILURE_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FailureMode").getter(getter(HookResultSummary::failureModeAsString))
            .setter(setter(Builder::failureMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureMode").build()).build();

    private static final SdkField<String> TYPE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TypeName").getter(getter(HookResultSummary::typeName)).setter(setter(Builder::typeName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TypeName").build()).build();

    private static final SdkField<String> TYPE_VERSION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TypeVersionId").getter(getter(HookResultSummary::typeVersionId)).setter(setter(Builder::typeVersionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TypeVersionId").build()).build();

    private static final SdkField<String> TYPE_CONFIGURATION_VERSION_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("TypeConfigurationVersionId")
            .getter(getter(HookResultSummary::typeConfigurationVersionId))
            .setter(setter(Builder::typeConfigurationVersionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TypeConfigurationVersionId").build())
            .build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(HookResultSummary::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> HOOK_STATUS_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("HookStatusReason").getter(getter(HookResultSummary::hookStatusReason))
            .setter(setter(Builder::hookStatusReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HookStatusReason").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INVOCATION_POINT_FIELD,
            FAILURE_MODE_FIELD, TYPE_NAME_FIELD, TYPE_VERSION_ID_FIELD, TYPE_CONFIGURATION_VERSION_ID_FIELD, STATUS_FIELD,
            HOOK_STATUS_REASON_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("InvocationPoint", INVOCATION_POINT_FIELD);
                    put("FailureMode", FAILURE_MODE_FIELD);
                    put("TypeName", TYPE_NAME_FIELD);
                    put("TypeVersionId", TYPE_VERSION_ID_FIELD);
                    put("TypeConfigurationVersionId", TYPE_CONFIGURATION_VERSION_ID_FIELD);
                    put("Status", STATUS_FIELD);
                    put("HookStatusReason", HOOK_STATUS_REASON_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final String invocationPoint;

    private final String failureMode;

    private final String typeName;

    private final String typeVersionId;

    private final String typeConfigurationVersionId;

    private final String status;

    private final String hookStatusReason;

    private HookResultSummary(BuilderImpl builder) {
        this.invocationPoint = builder.invocationPoint;
        this.failureMode = builder.failureMode;
        this.typeName = builder.typeName;
        this.typeVersionId = builder.typeVersionId;
        this.typeConfigurationVersionId = builder.typeConfigurationVersionId;
        this.status = builder.status;
        this.hookStatusReason = builder.hookStatusReason;
    }

    /**
     * <p>
     * The exact point in the provisioning logic where the Hook runs.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #invocationPoint}
     * will return {@link HookInvocationPoint#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #invocationPointAsString}.
     * </p>
     * 
     * @return The exact point in the provisioning logic where the Hook runs.
     * @see HookInvocationPoint
     */
    public final HookInvocationPoint invocationPoint() {
        return HookInvocationPoint.fromValue(invocationPoint);
    }

    /**
     * <p>
     * The exact point in the provisioning logic where the Hook runs.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #invocationPoint}
     * will return {@link HookInvocationPoint#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #invocationPointAsString}.
     * </p>
     * 
     * @return The exact point in the provisioning logic where the Hook runs.
     * @see HookInvocationPoint
     */
    public final String invocationPointAsString() {
        return invocationPoint;
    }

    /**
     * <p>
     * The failure mode of the invocation. The following are potential modes:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>FAIL</code>: If the hook invocation returns a failure, then the requested target operation should fail.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>WARN</code>: If the hook invocation returns a failure, then the requested target operation should warn.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #failureMode} will
     * return {@link HookFailureMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #failureModeAsString}.
     * </p>
     * 
     * @return The failure mode of the invocation. The following are potential modes:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>FAIL</code>: If the hook invocation returns a failure, then the requested target operation should
     *         fail.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>WARN</code>: If the hook invocation returns a failure, then the requested target operation should
     *         warn.
     *         </p>
     *         </li>
     * @see HookFailureMode
     */
    public final HookFailureMode failureMode() {
        return HookFailureMode.fromValue(failureMode);
    }

    /**
     * <p>
     * The failure mode of the invocation. The following are potential modes:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>FAIL</code>: If the hook invocation returns a failure, then the requested target operation should fail.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>WARN</code>: If the hook invocation returns a failure, then the requested target operation should warn.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #failureMode} will
     * return {@link HookFailureMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #failureModeAsString}.
     * </p>
     * 
     * @return The failure mode of the invocation. The following are potential modes:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>FAIL</code>: If the hook invocation returns a failure, then the requested target operation should
     *         fail.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>WARN</code>: If the hook invocation returns a failure, then the requested target operation should
     *         warn.
     *         </p>
     *         </li>
     * @see HookFailureMode
     */
    public final String failureModeAsString() {
        return failureMode;
    }

    /**
     * <p>
     * The type name of the Hook being invoked.
     * </p>
     * 
     * @return The type name of the Hook being invoked.
     */
    public final String typeName() {
        return typeName;
    }

    /**
     * <p>
     * The version of the Hook being invoked.
     * </p>
     * 
     * @return The version of the Hook being invoked.
     */
    public final String typeVersionId() {
        return typeVersionId;
    }

    /**
     * <p>
     * The version of the Hook type configuration.
     * </p>
     * 
     * @return The version of the Hook type configuration.
     */
    public final String typeConfigurationVersionId() {
        return typeConfigurationVersionId;
    }

    /**
     * <p>
     * The state of the Hook invocation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link HookStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The state of the Hook invocation.
     * @see HookStatus
     */
    public final HookStatus status() {
        return HookStatus.fromValue(status);
    }

    /**
     * <p>
     * The state of the Hook invocation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link HookStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The state of the Hook invocation.
     * @see HookStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * A description of the Hook results status. For example, if the Hook result is in a <code>FAILED</code> state, this
     * may contain additional information for the <code>FAILED</code> state.
     * </p>
     * 
     * @return A description of the Hook results status. For example, if the Hook result is in a <code>FAILED</code>
     *         state, this may contain additional information for the <code>FAILED</code> state.
     */
    public final String hookStatusReason() {
        return hookStatusReason;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(invocationPointAsString());
        hashCode = 31 * hashCode + Objects.hashCode(failureModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(typeName());
        hashCode = 31 * hashCode + Objects.hashCode(typeVersionId());
        hashCode = 31 * hashCode + Objects.hashCode(typeConfigurationVersionId());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hookStatusReason());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HookResultSummary)) {
            return false;
        }
        HookResultSummary other = (HookResultSummary) obj;
        return Objects.equals(invocationPointAsString(), other.invocationPointAsString())
                && Objects.equals(failureModeAsString(), other.failureModeAsString())
                && Objects.equals(typeName(), other.typeName()) && Objects.equals(typeVersionId(), other.typeVersionId())
                && Objects.equals(typeConfigurationVersionId(), other.typeConfigurationVersionId())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(hookStatusReason(), other.hookStatusReason());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("HookResultSummary").add("InvocationPoint", invocationPointAsString())
                .add("FailureMode", failureModeAsString()).add("TypeName", typeName()).add("TypeVersionId", typeVersionId())
                .add("TypeConfigurationVersionId", typeConfigurationVersionId()).add("Status", statusAsString())
                .add("HookStatusReason", hookStatusReason()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InvocationPoint":
            return Optional.ofNullable(clazz.cast(invocationPointAsString()));
        case "FailureMode":
            return Optional.ofNullable(clazz.cast(failureModeAsString()));
        case "TypeName":
            return Optional.ofNullable(clazz.cast(typeName()));
        case "TypeVersionId":
            return Optional.ofNullable(clazz.cast(typeVersionId()));
        case "TypeConfigurationVersionId":
            return Optional.ofNullable(clazz.cast(typeConfigurationVersionId()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "HookStatusReason":
            return Optional.ofNullable(clazz.cast(hookStatusReason()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<HookResultSummary, T> g) {
        return obj -> g.apply((HookResultSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, HookResultSummary> {
        /**
         * <p>
         * The exact point in the provisioning logic where the Hook runs.
         * </p>
         * 
         * @param invocationPoint
         *        The exact point in the provisioning logic where the Hook runs.
         * @see HookInvocationPoint
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HookInvocationPoint
         */
        Builder invocationPoint(String invocationPoint);

        /**
         * <p>
         * The exact point in the provisioning logic where the Hook runs.
         * </p>
         * 
         * @param invocationPoint
         *        The exact point in the provisioning logic where the Hook runs.
         * @see HookInvocationPoint
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HookInvocationPoint
         */
        Builder invocationPoint(HookInvocationPoint invocationPoint);

        /**
         * <p>
         * The failure mode of the invocation. The following are potential modes:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>FAIL</code>: If the hook invocation returns a failure, then the requested target operation should fail.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>WARN</code>: If the hook invocation returns a failure, then the requested target operation should warn.
         * </p>
         * </li>
         * </ul>
         * 
         * @param failureMode
         *        The failure mode of the invocation. The following are potential modes:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>FAIL</code>: If the hook invocation returns a failure, then the requested target operation
         *        should fail.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>WARN</code>: If the hook invocation returns a failure, then the requested target operation
         *        should warn.
         *        </p>
         *        </li>
         * @see HookFailureMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HookFailureMode
         */
        Builder failureMode(String failureMode);

        /**
         * <p>
         * The failure mode of the invocation. The following are potential modes:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>FAIL</code>: If the hook invocation returns a failure, then the requested target operation should fail.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>WARN</code>: If the hook invocation returns a failure, then the requested target operation should warn.
         * </p>
         * </li>
         * </ul>
         * 
         * @param failureMode
         *        The failure mode of the invocation. The following are potential modes:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>FAIL</code>: If the hook invocation returns a failure, then the requested target operation
         *        should fail.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>WARN</code>: If the hook invocation returns a failure, then the requested target operation
         *        should warn.
         *        </p>
         *        </li>
         * @see HookFailureMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HookFailureMode
         */
        Builder failureMode(HookFailureMode failureMode);

        /**
         * <p>
         * The type name of the Hook being invoked.
         * </p>
         * 
         * @param typeName
         *        The type name of the Hook being invoked.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder typeName(String typeName);

        /**
         * <p>
         * The version of the Hook being invoked.
         * </p>
         * 
         * @param typeVersionId
         *        The version of the Hook being invoked.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder typeVersionId(String typeVersionId);

        /**
         * <p>
         * The version of the Hook type configuration.
         * </p>
         * 
         * @param typeConfigurationVersionId
         *        The version of the Hook type configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder typeConfigurationVersionId(String typeConfigurationVersionId);

        /**
         * <p>
         * The state of the Hook invocation.
         * </p>
         * 
         * @param status
         *        The state of the Hook invocation.
         * @see HookStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HookStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The state of the Hook invocation.
         * </p>
         * 
         * @param status
         *        The state of the Hook invocation.
         * @see HookStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HookStatus
         */
        Builder status(HookStatus status);

        /**
         * <p>
         * A description of the Hook results status. For example, if the Hook result is in a <code>FAILED</code> state,
         * this may contain additional information for the <code>FAILED</code> state.
         * </p>
         * 
         * @param hookStatusReason
         *        A description of the Hook results status. For example, if the Hook result is in a <code>FAILED</code>
         *        state, this may contain additional information for the <code>FAILED</code> state.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hookStatusReason(String hookStatusReason);
    }

    static final class BuilderImpl implements Builder {
        private String invocationPoint;

        private String failureMode;

        private String typeName;

        private String typeVersionId;

        private String typeConfigurationVersionId;

        private String status;

        private String hookStatusReason;

        private BuilderImpl() {
        }

        private BuilderImpl(HookResultSummary model) {
            invocationPoint(model.invocationPoint);
            failureMode(model.failureMode);
            typeName(model.typeName);
            typeVersionId(model.typeVersionId);
            typeConfigurationVersionId(model.typeConfigurationVersionId);
            status(model.status);
            hookStatusReason(model.hookStatusReason);
        }

        public final String getInvocationPoint() {
            return invocationPoint;
        }

        public final void setInvocationPoint(String invocationPoint) {
            this.invocationPoint = invocationPoint;
        }

        @Override
        public final Builder invocationPoint(String invocationPoint) {
            this.invocationPoint = invocationPoint;
            return this;
        }

        @Override
        public final Builder invocationPoint(HookInvocationPoint invocationPoint) {
            this.invocationPoint(invocationPoint == null ? null : invocationPoint.toString());
            return this;
        }

        public final String getFailureMode() {
            return failureMode;
        }

        public final void setFailureMode(String failureMode) {
            this.failureMode = failureMode;
        }

        @Override
        public final Builder failureMode(String failureMode) {
            this.failureMode = failureMode;
            return this;
        }

        @Override
        public final Builder failureMode(HookFailureMode failureMode) {
            this.failureMode(failureMode == null ? null : failureMode.toString());
            return this;
        }

        public final String getTypeName() {
            return typeName;
        }

        public final void setTypeName(String typeName) {
            this.typeName = typeName;
        }

        @Override
        public final Builder typeName(String typeName) {
            this.typeName = typeName;
            return this;
        }

        public final String getTypeVersionId() {
            return typeVersionId;
        }

        public final void setTypeVersionId(String typeVersionId) {
            this.typeVersionId = typeVersionId;
        }

        @Override
        public final Builder typeVersionId(String typeVersionId) {
            this.typeVersionId = typeVersionId;
            return this;
        }

        public final String getTypeConfigurationVersionId() {
            return typeConfigurationVersionId;
        }

        public final void setTypeConfigurationVersionId(String typeConfigurationVersionId) {
            this.typeConfigurationVersionId = typeConfigurationVersionId;
        }

        @Override
        public final Builder typeConfigurationVersionId(String typeConfigurationVersionId) {
            this.typeConfigurationVersionId = typeConfigurationVersionId;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(HookStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getHookStatusReason() {
            return hookStatusReason;
        }

        public final void setHookStatusReason(String hookStatusReason) {
            this.hookStatusReason = hookStatusReason;
        }

        @Override
        public final Builder hookStatusReason(String hookStatusReason) {
            this.hookStatusReason = hookStatusReason;
            return this;
        }

        @Override
        public HookResultSummary build() {
            return new HookResultSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
