/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cloudformation.model.SupportedMajorVersionsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RequiredActivatedType
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RequiredActivatedType> {
    private static final SdkField<String> TYPE_NAME_ALIAS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TypeNameAlias").getter(RequiredActivatedType.getter(RequiredActivatedType::typeNameAlias)).setter(RequiredActivatedType.setter(Builder::typeNameAlias)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TypeNameAlias").build()}).build();
    private static final SdkField<String> ORIGINAL_TYPE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OriginalTypeName").getter(RequiredActivatedType.getter(RequiredActivatedType::originalTypeName)).setter(RequiredActivatedType.setter(Builder::originalTypeName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OriginalTypeName").build()}).build();
    private static final SdkField<String> PUBLISHER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PublisherId").getter(RequiredActivatedType.getter(RequiredActivatedType::publisherId)).setter(RequiredActivatedType.setter(Builder::publisherId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PublisherId").build()}).build();
    private static final SdkField<List<Integer>> SUPPORTED_MAJOR_VERSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SupportedMajorVersions").getter(RequiredActivatedType.getter(RequiredActivatedType::supportedMajorVersions)).setter(RequiredActivatedType.setter(Builder::supportedMajorVersions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SupportedMajorVersions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.INTEGER).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_NAME_ALIAS_FIELD, ORIGINAL_TYPE_NAME_FIELD, PUBLISHER_ID_FIELD, SUPPORTED_MAJOR_VERSIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("TypeNameAlias", TYPE_NAME_ALIAS_FIELD);
            this.put("OriginalTypeName", ORIGINAL_TYPE_NAME_FIELD);
            this.put("PublisherId", PUBLISHER_ID_FIELD);
            this.put("SupportedMajorVersions", SUPPORTED_MAJOR_VERSIONS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String typeNameAlias;
    private final String originalTypeName;
    private final String publisherId;
    private final List<Integer> supportedMajorVersions;

    private RequiredActivatedType(BuilderImpl builder) {
        this.typeNameAlias = builder.typeNameAlias;
        this.originalTypeName = builder.originalTypeName;
        this.publisherId = builder.publisherId;
        this.supportedMajorVersions = builder.supportedMajorVersions;
    }

    public final String typeNameAlias() {
        return this.typeNameAlias;
    }

    public final String originalTypeName() {
        return this.originalTypeName;
    }

    public final String publisherId() {
        return this.publisherId;
    }

    public final boolean hasSupportedMajorVersions() {
        return this.supportedMajorVersions != null && !(this.supportedMajorVersions instanceof SdkAutoConstructList);
    }

    public final List<Integer> supportedMajorVersions() {
        return this.supportedMajorVersions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.typeNameAlias());
        hashCode = 31 * hashCode + Objects.hashCode(this.originalTypeName());
        hashCode = 31 * hashCode + Objects.hashCode(this.publisherId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSupportedMajorVersions() ? this.supportedMajorVersions() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RequiredActivatedType)) {
            return false;
        }
        RequiredActivatedType other = (RequiredActivatedType)obj;
        return Objects.equals(this.typeNameAlias(), other.typeNameAlias()) && Objects.equals(this.originalTypeName(), other.originalTypeName()) && Objects.equals(this.publisherId(), other.publisherId()) && this.hasSupportedMajorVersions() == other.hasSupportedMajorVersions() && Objects.equals(this.supportedMajorVersions(), other.supportedMajorVersions());
    }

    public final String toString() {
        return ToString.builder((String)"RequiredActivatedType").add("TypeNameAlias", (Object)this.typeNameAlias()).add("OriginalTypeName", (Object)this.originalTypeName()).add("PublisherId", (Object)this.publisherId()).add("SupportedMajorVersions", this.hasSupportedMajorVersions() ? this.supportedMajorVersions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TypeNameAlias": {
                return Optional.ofNullable(clazz.cast(this.typeNameAlias()));
            }
            case "OriginalTypeName": {
                return Optional.ofNullable(clazz.cast(this.originalTypeName()));
            }
            case "PublisherId": {
                return Optional.ofNullable(clazz.cast(this.publisherId()));
            }
            case "SupportedMajorVersions": {
                return Optional.ofNullable(clazz.cast(this.supportedMajorVersions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<RequiredActivatedType, T> g) {
        return obj -> g.apply((RequiredActivatedType)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String typeNameAlias;
        private String originalTypeName;
        private String publisherId;
        private List<Integer> supportedMajorVersions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RequiredActivatedType model) {
            this.typeNameAlias(model.typeNameAlias);
            this.originalTypeName(model.originalTypeName);
            this.publisherId(model.publisherId);
            this.supportedMajorVersions(model.supportedMajorVersions);
        }

        public final String getTypeNameAlias() {
            return this.typeNameAlias;
        }

        public final void setTypeNameAlias(String typeNameAlias) {
            this.typeNameAlias = typeNameAlias;
        }

        @Override
        public final Builder typeNameAlias(String typeNameAlias) {
            this.typeNameAlias = typeNameAlias;
            return this;
        }

        public final String getOriginalTypeName() {
            return this.originalTypeName;
        }

        public final void setOriginalTypeName(String originalTypeName) {
            this.originalTypeName = originalTypeName;
        }

        @Override
        public final Builder originalTypeName(String originalTypeName) {
            this.originalTypeName = originalTypeName;
            return this;
        }

        public final String getPublisherId() {
            return this.publisherId;
        }

        public final void setPublisherId(String publisherId) {
            this.publisherId = publisherId;
        }

        @Override
        public final Builder publisherId(String publisherId) {
            this.publisherId = publisherId;
            return this;
        }

        public final Collection<Integer> getSupportedMajorVersions() {
            if (this.supportedMajorVersions instanceof SdkAutoConstructList) {
                return null;
            }
            return this.supportedMajorVersions;
        }

        public final void setSupportedMajorVersions(Collection<Integer> supportedMajorVersions) {
            this.supportedMajorVersions = SupportedMajorVersionsCopier.copy(supportedMajorVersions);
        }

        @Override
        public final Builder supportedMajorVersions(Collection<Integer> supportedMajorVersions) {
            this.supportedMajorVersions = SupportedMajorVersionsCopier.copy(supportedMajorVersions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedMajorVersions(Integer ... supportedMajorVersions) {
            this.supportedMajorVersions(Arrays.asList(supportedMajorVersions));
            return this;
        }

        public RequiredActivatedType build() {
            return new RequiredActivatedType(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RequiredActivatedType> {
        public Builder typeNameAlias(String var1);

        public Builder originalTypeName(String var1);

        public Builder publisherId(String var1);

        public Builder supportedMajorVersions(Collection<Integer> var1);

        public Builder supportedMajorVersions(Integer ... var1);
    }
}

