/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudformation.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListResourceScanRelatedResourcesRequest extends CloudFormationRequest implements
        ToCopyableBuilder<ListResourceScanRelatedResourcesRequest.Builder, ListResourceScanRelatedResourcesRequest> {
    private static final SdkField<String> RESOURCE_SCAN_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceScanId").getter(getter(ListResourceScanRelatedResourcesRequest::resourceScanId))
            .setter(setter(Builder::resourceScanId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceScanId").build()).build();

    private static final SdkField<List<ScannedResourceIdentifier>> RESOURCES_FIELD = SdkField
            .<List<ScannedResourceIdentifier>> builder(MarshallingType.LIST)
            .memberName("Resources")
            .getter(getter(ListResourceScanRelatedResourcesRequest::resources))
            .setter(setter(Builder::resources))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Resources").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ScannedResourceIdentifier> builder(MarshallingType.SDK_POJO)
                                            .constructor(ScannedResourceIdentifier::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListResourceScanRelatedResourcesRequest::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(ListResourceScanRelatedResourcesRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_SCAN_ID_FIELD,
            RESOURCES_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("ResourceScanId", RESOURCE_SCAN_ID_FIELD);
                    put("Resources", RESOURCES_FIELD);
                    put("NextToken", NEXT_TOKEN_FIELD);
                    put("MaxResults", MAX_RESULTS_FIELD);
                }
            });

    private final String resourceScanId;

    private final List<ScannedResourceIdentifier> resources;

    private final String nextToken;

    private final Integer maxResults;

    private ListResourceScanRelatedResourcesRequest(BuilderImpl builder) {
        super(builder);
        this.resourceScanId = builder.resourceScanId;
        this.resources = builder.resources;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the resource scan.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the resource scan.
     */
    public final String resourceScanId() {
        return resourceScanId;
    }

    /**
     * For responses, this returns true if the service returned a value for the Resources property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasResources() {
        return resources != null && !(resources instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of resources for which you want to get the related resources. Up to 100 resources can be provided.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasResources} method.
     * </p>
     * 
     * @return The list of resources for which you want to get the related resources. Up to 100 resources can be
     *         provided.
     */
    public final List<ScannedResourceIdentifier> resources() {
        return resources;
    }

    /**
     * <p>
     * A string that identifies the next page of resource scan results.
     * </p>
     * 
     * @return A string that identifies the next page of resource scan results.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * If the number of available results exceeds this maximum, the response includes a <code>NextToken</code> value
     * that you can use for the <code>NextToken</code> parameter to get the next set of results. By default the
     * <code>ListResourceScanRelatedResources</code> API action will return up to 100 results in each response. The
     * maximum value is 100.
     * </p>
     * 
     * @return If the number of available results exceeds this maximum, the response includes a <code>NextToken</code>
     *         value that you can use for the <code>NextToken</code> parameter to get the next set of results. By
     *         default the <code>ListResourceScanRelatedResources</code> API action will return up to 100 results in
     *         each response. The maximum value is 100.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(resourceScanId());
        hashCode = 31 * hashCode + Objects.hashCode(hasResources() ? resources() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListResourceScanRelatedResourcesRequest)) {
            return false;
        }
        ListResourceScanRelatedResourcesRequest other = (ListResourceScanRelatedResourcesRequest) obj;
        return Objects.equals(resourceScanId(), other.resourceScanId()) && hasResources() == other.hasResources()
                && Objects.equals(resources(), other.resources()) && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(maxResults(), other.maxResults());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListResourceScanRelatedResourcesRequest").add("ResourceScanId", resourceScanId())
                .add("Resources", hasResources() ? resources() : null).add("NextToken", nextToken())
                .add("MaxResults", maxResults()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ResourceScanId":
            return Optional.ofNullable(clazz.cast(resourceScanId()));
        case "Resources":
            return Optional.ofNullable(clazz.cast(resources()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListResourceScanRelatedResourcesRequest, T> g) {
        return obj -> g.apply((ListResourceScanRelatedResourcesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudFormationRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, ListResourceScanRelatedResourcesRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the resource scan.
         * </p>
         * 
         * @param resourceScanId
         *        The Amazon Resource Name (ARN) of the resource scan.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceScanId(String resourceScanId);

        /**
         * <p>
         * The list of resources for which you want to get the related resources. Up to 100 resources can be provided.
         * </p>
         * 
         * @param resources
         *        The list of resources for which you want to get the related resources. Up to 100 resources can be
         *        provided.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resources(Collection<ScannedResourceIdentifier> resources);

        /**
         * <p>
         * The list of resources for which you want to get the related resources. Up to 100 resources can be provided.
         * </p>
         * 
         * @param resources
         *        The list of resources for which you want to get the related resources. Up to 100 resources can be
         *        provided.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resources(ScannedResourceIdentifier... resources);

        /**
         * <p>
         * The list of resources for which you want to get the related resources. Up to 100 resources can be provided.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.cloudformation.model.ScannedResourceIdentifier.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.cloudformation.model.ScannedResourceIdentifier#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.cloudformation.model.ScannedResourceIdentifier.Builder#build()} is
         * called immediately and its result is passed to {@link #resources(List<ScannedResourceIdentifier>)}.
         * 
         * @param resources
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.cloudformation.model.ScannedResourceIdentifier.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resources(java.util.Collection<ScannedResourceIdentifier>)
         */
        Builder resources(Consumer<ScannedResourceIdentifier.Builder>... resources);

        /**
         * <p>
         * A string that identifies the next page of resource scan results.
         * </p>
         * 
         * @param nextToken
         *        A string that identifies the next page of resource scan results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * If the number of available results exceeds this maximum, the response includes a <code>NextToken</code> value
         * that you can use for the <code>NextToken</code> parameter to get the next set of results. By default the
         * <code>ListResourceScanRelatedResources</code> API action will return up to 100 results in each response. The
         * maximum value is 100.
         * </p>
         * 
         * @param maxResults
         *        If the number of available results exceeds this maximum, the response includes a
         *        <code>NextToken</code> value that you can use for the <code>NextToken</code> parameter to get the next
         *        set of results. By default the <code>ListResourceScanRelatedResources</code> API action will return up
         *        to 100 results in each response. The maximum value is 100.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CloudFormationRequest.BuilderImpl implements Builder {
        private String resourceScanId;

        private List<ScannedResourceIdentifier> resources = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(ListResourceScanRelatedResourcesRequest model) {
            super(model);
            resourceScanId(model.resourceScanId);
            resources(model.resources);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
        }

        public final String getResourceScanId() {
            return resourceScanId;
        }

        public final void setResourceScanId(String resourceScanId) {
            this.resourceScanId = resourceScanId;
        }

        @Override
        public final Builder resourceScanId(String resourceScanId) {
            this.resourceScanId = resourceScanId;
            return this;
        }

        public final List<ScannedResourceIdentifier.Builder> getResources() {
            List<ScannedResourceIdentifier.Builder> result = ScannedResourceIdentifiersCopier.copyToBuilder(this.resources);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setResources(Collection<ScannedResourceIdentifier.BuilderImpl> resources) {
            this.resources = ScannedResourceIdentifiersCopier.copyFromBuilder(resources);
        }

        @Override
        public final Builder resources(Collection<ScannedResourceIdentifier> resources) {
            this.resources = ScannedResourceIdentifiersCopier.copy(resources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resources(ScannedResourceIdentifier... resources) {
            resources(Arrays.asList(resources));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resources(Consumer<ScannedResourceIdentifier.Builder>... resources) {
            resources(Stream.of(resources).map(c -> ScannedResourceIdentifier.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListResourceScanRelatedResourcesRequest build() {
            return new ListResourceScanRelatedResourcesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
