/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudformation.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The structure that contains information about a specified operation's results for a given account in a given Region.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class StackSetOperationResultSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<StackSetOperationResultSummary.Builder, StackSetOperationResultSummary> {
    private static final SdkField<String> ACCOUNT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Account")
            .getter(getter(StackSetOperationResultSummary::account)).setter(setter(Builder::account))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Account").build()).build();

    private static final SdkField<String> REGION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Region")
            .getter(getter(StackSetOperationResultSummary::region)).setter(setter(Builder::region))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Region").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(StackSetOperationResultSummary::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> STATUS_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StatusReason").getter(getter(StackSetOperationResultSummary::statusReason))
            .setter(setter(Builder::statusReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusReason").build()).build();

    private static final SdkField<AccountGateResult> ACCOUNT_GATE_RESULT_FIELD = SdkField
            .<AccountGateResult> builder(MarshallingType.SDK_POJO).memberName("AccountGateResult")
            .getter(getter(StackSetOperationResultSummary::accountGateResult)).setter(setter(Builder::accountGateResult))
            .constructor(AccountGateResult::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountGateResult").build()).build();

    private static final SdkField<String> ORGANIZATIONAL_UNIT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OrganizationalUnitId").getter(getter(StackSetOperationResultSummary::organizationalUnitId))
            .setter(setter(Builder::organizationalUnitId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrganizationalUnitId").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_FIELD, REGION_FIELD,
            STATUS_FIELD, STATUS_REASON_FIELD, ACCOUNT_GATE_RESULT_FIELD, ORGANIZATIONAL_UNIT_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("Account", ACCOUNT_FIELD);
                    put("Region", REGION_FIELD);
                    put("Status", STATUS_FIELD);
                    put("StatusReason", STATUS_REASON_FIELD);
                    put("AccountGateResult", ACCOUNT_GATE_RESULT_FIELD);
                    put("OrganizationalUnitId", ORGANIZATIONAL_UNIT_ID_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final String account;

    private final String region;

    private final String status;

    private final String statusReason;

    private final AccountGateResult accountGateResult;

    private final String organizationalUnitId;

    private StackSetOperationResultSummary(BuilderImpl builder) {
        this.account = builder.account;
        this.region = builder.region;
        this.status = builder.status;
        this.statusReason = builder.statusReason;
        this.accountGateResult = builder.accountGateResult;
        this.organizationalUnitId = builder.organizationalUnitId;
    }

    /**
     * <p>
     * [Self-managed permissions] The name of the Amazon Web Services account for this operation result.
     * </p>
     * 
     * @return [Self-managed permissions] The name of the Amazon Web Services account for this operation result.
     */
    public final String account() {
        return account;
    }

    /**
     * <p>
     * The name of the Amazon Web Services Region for this operation result.
     * </p>
     * 
     * @return The name of the Amazon Web Services Region for this operation result.
     */
    public final String region() {
        return region;
    }

    /**
     * <p>
     * The result status of the stack set operation for the given account in the given Region.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>CANCELLED</code>: The operation in the specified account and Region has been canceled. This is either
     * because a user has stopped the stack set operation, or because the failure tolerance of the stack set operation
     * has been exceeded.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>FAILED</code>: The operation in the specified account and Region failed.
     * </p>
     * <p>
     * If the stack set operation fails in enough accounts within a Region, the failure tolerance for the stack set
     * operation as a whole might be exceeded.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>RUNNING</code>: The operation in the specified account and Region is currently in progress.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>PENDING</code>: The operation in the specified account and Region has yet to start.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SUCCEEDED</code>: The operation in the specified account and Region completed successfully.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link StackSetOperationResultStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return The result status of the stack set operation for the given account in the given Region.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>CANCELLED</code>: The operation in the specified account and Region has been canceled. This is
     *         either because a user has stopped the stack set operation, or because the failure tolerance of the stack
     *         set operation has been exceeded.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>FAILED</code>: The operation in the specified account and Region failed.
     *         </p>
     *         <p>
     *         If the stack set operation fails in enough accounts within a Region, the failure tolerance for the stack
     *         set operation as a whole might be exceeded.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>RUNNING</code>: The operation in the specified account and Region is currently in progress.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>PENDING</code>: The operation in the specified account and Region has yet to start.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SUCCEEDED</code>: The operation in the specified account and Region completed successfully.
     *         </p>
     *         </li>
     * @see StackSetOperationResultStatus
     */
    public final StackSetOperationResultStatus status() {
        return StackSetOperationResultStatus.fromValue(status);
    }

    /**
     * <p>
     * The result status of the stack set operation for the given account in the given Region.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>CANCELLED</code>: The operation in the specified account and Region has been canceled. This is either
     * because a user has stopped the stack set operation, or because the failure tolerance of the stack set operation
     * has been exceeded.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>FAILED</code>: The operation in the specified account and Region failed.
     * </p>
     * <p>
     * If the stack set operation fails in enough accounts within a Region, the failure tolerance for the stack set
     * operation as a whole might be exceeded.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>RUNNING</code>: The operation in the specified account and Region is currently in progress.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>PENDING</code>: The operation in the specified account and Region has yet to start.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SUCCEEDED</code>: The operation in the specified account and Region completed successfully.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link StackSetOperationResultStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return The result status of the stack set operation for the given account in the given Region.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>CANCELLED</code>: The operation in the specified account and Region has been canceled. This is
     *         either because a user has stopped the stack set operation, or because the failure tolerance of the stack
     *         set operation has been exceeded.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>FAILED</code>: The operation in the specified account and Region failed.
     *         </p>
     *         <p>
     *         If the stack set operation fails in enough accounts within a Region, the failure tolerance for the stack
     *         set operation as a whole might be exceeded.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>RUNNING</code>: The operation in the specified account and Region is currently in progress.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>PENDING</code>: The operation in the specified account and Region has yet to start.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SUCCEEDED</code>: The operation in the specified account and Region completed successfully.
     *         </p>
     *         </li>
     * @see StackSetOperationResultStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The reason for the assigned result status.
     * </p>
     * 
     * @return The reason for the assigned result status.
     */
    public final String statusReason() {
        return statusReason;
    }

    /**
     * <p>
     * The results of the account gate function CloudFormation invokes, if present, before proceeding with stack set
     * operations in an account.
     * </p>
     * 
     * @return The results of the account gate function CloudFormation invokes, if present, before proceeding with stack
     *         set operations in an account.
     */
    public final AccountGateResult accountGateResult() {
        return accountGateResult;
    }

    /**
     * <p>
     * [Service-managed permissions] The organization root ID or organizational unit (OU) IDs that you specified for <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_DeploymentTargets.html">
     * DeploymentTargets</a>.
     * </p>
     * 
     * @return [Service-managed permissions] The organization root ID or organizational unit (OU) IDs that you specified
     *         for <a
     *         href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_DeploymentTargets.html"
     *         >DeploymentTargets</a>.
     */
    public final String organizationalUnitId() {
        return organizationalUnitId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(account());
        hashCode = 31 * hashCode + Objects.hashCode(region());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusReason());
        hashCode = 31 * hashCode + Objects.hashCode(accountGateResult());
        hashCode = 31 * hashCode + Objects.hashCode(organizationalUnitId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StackSetOperationResultSummary)) {
            return false;
        }
        StackSetOperationResultSummary other = (StackSetOperationResultSummary) obj;
        return Objects.equals(account(), other.account()) && Objects.equals(region(), other.region())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(statusReason(), other.statusReason())
                && Objects.equals(accountGateResult(), other.accountGateResult())
                && Objects.equals(organizationalUnitId(), other.organizationalUnitId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StackSetOperationResultSummary").add("Account", account()).add("Region", region())
                .add("Status", statusAsString()).add("StatusReason", statusReason())
                .add("AccountGateResult", accountGateResult()).add("OrganizationalUnitId", organizationalUnitId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Account":
            return Optional.ofNullable(clazz.cast(account()));
        case "Region":
            return Optional.ofNullable(clazz.cast(region()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "StatusReason":
            return Optional.ofNullable(clazz.cast(statusReason()));
        case "AccountGateResult":
            return Optional.ofNullable(clazz.cast(accountGateResult()));
        case "OrganizationalUnitId":
            return Optional.ofNullable(clazz.cast(organizationalUnitId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<StackSetOperationResultSummary, T> g) {
        return obj -> g.apply((StackSetOperationResultSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, StackSetOperationResultSummary> {
        /**
         * <p>
         * [Self-managed permissions] The name of the Amazon Web Services account for this operation result.
         * </p>
         * 
         * @param account
         *        [Self-managed permissions] The name of the Amazon Web Services account for this operation result.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder account(String account);

        /**
         * <p>
         * The name of the Amazon Web Services Region for this operation result.
         * </p>
         * 
         * @param region
         *        The name of the Amazon Web Services Region for this operation result.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder region(String region);

        /**
         * <p>
         * The result status of the stack set operation for the given account in the given Region.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>CANCELLED</code>: The operation in the specified account and Region has been canceled. This is either
         * because a user has stopped the stack set operation, or because the failure tolerance of the stack set
         * operation has been exceeded.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>FAILED</code>: The operation in the specified account and Region failed.
         * </p>
         * <p>
         * If the stack set operation fails in enough accounts within a Region, the failure tolerance for the stack set
         * operation as a whole might be exceeded.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>RUNNING</code>: The operation in the specified account and Region is currently in progress.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>PENDING</code>: The operation in the specified account and Region has yet to start.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SUCCEEDED</code>: The operation in the specified account and Region completed successfully.
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The result status of the stack set operation for the given account in the given Region.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>CANCELLED</code>: The operation in the specified account and Region has been canceled. This is
         *        either because a user has stopped the stack set operation, or because the failure tolerance of the
         *        stack set operation has been exceeded.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>FAILED</code>: The operation in the specified account and Region failed.
         *        </p>
         *        <p>
         *        If the stack set operation fails in enough accounts within a Region, the failure tolerance for the
         *        stack set operation as a whole might be exceeded.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>RUNNING</code>: The operation in the specified account and Region is currently in progress.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>PENDING</code>: The operation in the specified account and Region has yet to start.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SUCCEEDED</code>: The operation in the specified account and Region completed successfully.
         *        </p>
         *        </li>
         * @see StackSetOperationResultStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StackSetOperationResultStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The result status of the stack set operation for the given account in the given Region.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>CANCELLED</code>: The operation in the specified account and Region has been canceled. This is either
         * because a user has stopped the stack set operation, or because the failure tolerance of the stack set
         * operation has been exceeded.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>FAILED</code>: The operation in the specified account and Region failed.
         * </p>
         * <p>
         * If the stack set operation fails in enough accounts within a Region, the failure tolerance for the stack set
         * operation as a whole might be exceeded.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>RUNNING</code>: The operation in the specified account and Region is currently in progress.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>PENDING</code>: The operation in the specified account and Region has yet to start.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SUCCEEDED</code>: The operation in the specified account and Region completed successfully.
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The result status of the stack set operation for the given account in the given Region.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>CANCELLED</code>: The operation in the specified account and Region has been canceled. This is
         *        either because a user has stopped the stack set operation, or because the failure tolerance of the
         *        stack set operation has been exceeded.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>FAILED</code>: The operation in the specified account and Region failed.
         *        </p>
         *        <p>
         *        If the stack set operation fails in enough accounts within a Region, the failure tolerance for the
         *        stack set operation as a whole might be exceeded.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>RUNNING</code>: The operation in the specified account and Region is currently in progress.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>PENDING</code>: The operation in the specified account and Region has yet to start.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SUCCEEDED</code>: The operation in the specified account and Region completed successfully.
         *        </p>
         *        </li>
         * @see StackSetOperationResultStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StackSetOperationResultStatus
         */
        Builder status(StackSetOperationResultStatus status);

        /**
         * <p>
         * The reason for the assigned result status.
         * </p>
         * 
         * @param statusReason
         *        The reason for the assigned result status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusReason(String statusReason);

        /**
         * <p>
         * The results of the account gate function CloudFormation invokes, if present, before proceeding with stack set
         * operations in an account.
         * </p>
         * 
         * @param accountGateResult
         *        The results of the account gate function CloudFormation invokes, if present, before proceeding with
         *        stack set operations in an account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountGateResult(AccountGateResult accountGateResult);

        /**
         * <p>
         * The results of the account gate function CloudFormation invokes, if present, before proceeding with stack set
         * operations in an account.
         * </p>
         * This is a convenience method that creates an instance of the {@link AccountGateResult.Builder} avoiding the
         * need to create one manually via {@link AccountGateResult#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AccountGateResult.Builder#build()} is called immediately and its
         * result is passed to {@link #accountGateResult(AccountGateResult)}.
         * 
         * @param accountGateResult
         *        a consumer that will call methods on {@link AccountGateResult.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #accountGateResult(AccountGateResult)
         */
        default Builder accountGateResult(Consumer<AccountGateResult.Builder> accountGateResult) {
            return accountGateResult(AccountGateResult.builder().applyMutation(accountGateResult).build());
        }

        /**
         * <p>
         * [Service-managed permissions] The organization root ID or organizational unit (OU) IDs that you specified for
         * <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_DeploymentTargets.html">
         * DeploymentTargets</a>.
         * </p>
         * 
         * @param organizationalUnitId
         *        [Service-managed permissions] The organization root ID or organizational unit (OU) IDs that you
         *        specified for <a
         *        href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_DeploymentTargets.html"
         *        >DeploymentTargets</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder organizationalUnitId(String organizationalUnitId);
    }

    static final class BuilderImpl implements Builder {
        private String account;

        private String region;

        private String status;

        private String statusReason;

        private AccountGateResult accountGateResult;

        private String organizationalUnitId;

        private BuilderImpl() {
        }

        private BuilderImpl(StackSetOperationResultSummary model) {
            account(model.account);
            region(model.region);
            status(model.status);
            statusReason(model.statusReason);
            accountGateResult(model.accountGateResult);
            organizationalUnitId(model.organizationalUnitId);
        }

        public final String getAccount() {
            return account;
        }

        public final void setAccount(String account) {
            this.account = account;
        }

        @Override
        public final Builder account(String account) {
            this.account = account;
            return this;
        }

        public final String getRegion() {
            return region;
        }

        public final void setRegion(String region) {
            this.region = region;
        }

        @Override
        public final Builder region(String region) {
            this.region = region;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(StackSetOperationResultStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusReason() {
            return statusReason;
        }

        public final void setStatusReason(String statusReason) {
            this.statusReason = statusReason;
        }

        @Override
        public final Builder statusReason(String statusReason) {
            this.statusReason = statusReason;
            return this;
        }

        public final AccountGateResult.Builder getAccountGateResult() {
            return accountGateResult != null ? accountGateResult.toBuilder() : null;
        }

        public final void setAccountGateResult(AccountGateResult.BuilderImpl accountGateResult) {
            this.accountGateResult = accountGateResult != null ? accountGateResult.build() : null;
        }

        @Override
        public final Builder accountGateResult(AccountGateResult accountGateResult) {
            this.accountGateResult = accountGateResult;
            return this;
        }

        public final String getOrganizationalUnitId() {
            return organizationalUnitId;
        }

        public final void setOrganizationalUnitId(String organizationalUnitId) {
            this.organizationalUnitId = organizationalUnitId;
        }

        @Override
        public final Builder organizationalUnitId(String organizationalUnitId) {
            this.organizationalUnitId = organizationalUnitId;
            return this;
        }

        @Override
        public StackSetOperationResultSummary build() {
            return new StackSetOperationResultSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
