/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudformation.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeGeneratedTemplateResponse extends CloudFormationResponse implements
        ToCopyableBuilder<DescribeGeneratedTemplateResponse.Builder, DescribeGeneratedTemplateResponse> {
    private static final SdkField<String> GENERATED_TEMPLATE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GeneratedTemplateId").getter(getter(DescribeGeneratedTemplateResponse::generatedTemplateId))
            .setter(setter(Builder::generatedTemplateId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GeneratedTemplateId").build())
            .build();

    private static final SdkField<String> GENERATED_TEMPLATE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GeneratedTemplateName").getter(getter(DescribeGeneratedTemplateResponse::generatedTemplateName))
            .setter(setter(Builder::generatedTemplateName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GeneratedTemplateName").build())
            .build();

    private static final SdkField<List<ResourceDetail>> RESOURCES_FIELD = SdkField
            .<List<ResourceDetail>> builder(MarshallingType.LIST)
            .memberName("Resources")
            .getter(getter(DescribeGeneratedTemplateResponse::resources))
            .setter(setter(Builder::resources))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Resources").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ResourceDetail> builder(MarshallingType.SDK_POJO)
                                            .constructor(ResourceDetail::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(DescribeGeneratedTemplateResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> STATUS_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StatusReason").getter(getter(DescribeGeneratedTemplateResponse::statusReason))
            .setter(setter(Builder::statusReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusReason").build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTime").getter(getter(DescribeGeneratedTemplateResponse::creationTime))
            .setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()).build();

    private static final SdkField<Instant> LAST_UPDATED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastUpdatedTime").getter(getter(DescribeGeneratedTemplateResponse::lastUpdatedTime))
            .setter(setter(Builder::lastUpdatedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdatedTime").build()).build();

    private static final SdkField<TemplateProgress> PROGRESS_FIELD = SdkField
            .<TemplateProgress> builder(MarshallingType.SDK_POJO).memberName("Progress")
            .getter(getter(DescribeGeneratedTemplateResponse::progress)).setter(setter(Builder::progress))
            .constructor(TemplateProgress::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Progress").build()).build();

    private static final SdkField<String> STACK_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StackId").getter(getter(DescribeGeneratedTemplateResponse::stackId)).setter(setter(Builder::stackId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StackId").build()).build();

    private static final SdkField<TemplateConfiguration> TEMPLATE_CONFIGURATION_FIELD = SdkField
            .<TemplateConfiguration> builder(MarshallingType.SDK_POJO).memberName("TemplateConfiguration")
            .getter(getter(DescribeGeneratedTemplateResponse::templateConfiguration))
            .setter(setter(Builder::templateConfiguration)).constructor(TemplateConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TemplateConfiguration").build())
            .build();

    private static final SdkField<Integer> TOTAL_WARNINGS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("TotalWarnings").getter(getter(DescribeGeneratedTemplateResponse::totalWarnings))
            .setter(setter(Builder::totalWarnings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalWarnings").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GENERATED_TEMPLATE_ID_FIELD,
            GENERATED_TEMPLATE_NAME_FIELD, RESOURCES_FIELD, STATUS_FIELD, STATUS_REASON_FIELD, CREATION_TIME_FIELD,
            LAST_UPDATED_TIME_FIELD, PROGRESS_FIELD, STACK_ID_FIELD, TEMPLATE_CONFIGURATION_FIELD, TOTAL_WARNINGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("GeneratedTemplateId", GENERATED_TEMPLATE_ID_FIELD);
                    put("GeneratedTemplateName", GENERATED_TEMPLATE_NAME_FIELD);
                    put("Resources", RESOURCES_FIELD);
                    put("Status", STATUS_FIELD);
                    put("StatusReason", STATUS_REASON_FIELD);
                    put("CreationTime", CREATION_TIME_FIELD);
                    put("LastUpdatedTime", LAST_UPDATED_TIME_FIELD);
                    put("Progress", PROGRESS_FIELD);
                    put("StackId", STACK_ID_FIELD);
                    put("TemplateConfiguration", TEMPLATE_CONFIGURATION_FIELD);
                    put("TotalWarnings", TOTAL_WARNINGS_FIELD);
                }
            });

    private final String generatedTemplateId;

    private final String generatedTemplateName;

    private final List<ResourceDetail> resources;

    private final String status;

    private final String statusReason;

    private final Instant creationTime;

    private final Instant lastUpdatedTime;

    private final TemplateProgress progress;

    private final String stackId;

    private final TemplateConfiguration templateConfiguration;

    private final Integer totalWarnings;

    private DescribeGeneratedTemplateResponse(BuilderImpl builder) {
        super(builder);
        this.generatedTemplateId = builder.generatedTemplateId;
        this.generatedTemplateName = builder.generatedTemplateName;
        this.resources = builder.resources;
        this.status = builder.status;
        this.statusReason = builder.statusReason;
        this.creationTime = builder.creationTime;
        this.lastUpdatedTime = builder.lastUpdatedTime;
        this.progress = builder.progress;
        this.stackId = builder.stackId;
        this.templateConfiguration = builder.templateConfiguration;
        this.totalWarnings = builder.totalWarnings;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the generated template. The format is
     * <code>arn:${Partition}:cloudformation:${Region}:${Account}:generatedtemplate/${Id}</code>. For example,
     * <code>arn:aws:cloudformation:<i>us-east-1</i>:<i>123456789012</i>:generatedtemplate/<i>2e8465c1-9a80-43ea-a3a3-4f2d692fe6dc</i> </code>
     * .
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the generated template. The format is
     *         <code>arn:${Partition}:cloudformation:${Region}:${Account}:generatedtemplate/${Id}</code>. For example,
     *         <code>arn:aws:cloudformation:<i>us-east-1</i>:<i>123456789012</i>:generatedtemplate/<i>2e8465c1-9a80-43ea-a3a3-4f2d692fe6dc</i> </code>
     *         .
     */
    public final String generatedTemplateId() {
        return generatedTemplateId;
    }

    /**
     * <p>
     * The name of the generated template.
     * </p>
     * 
     * @return The name of the generated template.
     */
    public final String generatedTemplateName() {
        return generatedTemplateName;
    }

    /**
     * For responses, this returns true if the service returned a value for the Resources property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasResources() {
        return resources != null && !(resources instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of objects describing the details of the resources in the template generation.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasResources} method.
     * </p>
     * 
     * @return A list of objects describing the details of the resources in the template generation.
     */
    public final List<ResourceDetail> resources() {
        return resources;
    }

    /**
     * <p>
     * The status of the template generation. Supported values are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>CreatePending</code> - the creation of the template is pending.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CreateInProgress</code> - the creation of the template is in progress.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DeletePending</code> - the deletion of the template is pending.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DeleteInProgress</code> - the deletion of the template is in progress.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>UpdatePending</code> - the update of the template is pending.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>UpdateInProgress</code> - the update of the template is in progress.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Failed</code> - the template operation failed.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Complete</code> - the template operation is complete.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link GeneratedTemplateStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the template generation. Supported values are:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>CreatePending</code> - the creation of the template is pending.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CreateInProgress</code> - the creation of the template is in progress.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DeletePending</code> - the deletion of the template is pending.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DeleteInProgress</code> - the deletion of the template is in progress.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>UpdatePending</code> - the update of the template is pending.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>UpdateInProgress</code> - the update of the template is in progress.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Failed</code> - the template operation failed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Complete</code> - the template operation is complete.
     *         </p>
     *         </li>
     * @see GeneratedTemplateStatus
     */
    public final GeneratedTemplateStatus status() {
        return GeneratedTemplateStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the template generation. Supported values are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>CreatePending</code> - the creation of the template is pending.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CreateInProgress</code> - the creation of the template is in progress.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DeletePending</code> - the deletion of the template is pending.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DeleteInProgress</code> - the deletion of the template is in progress.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>UpdatePending</code> - the update of the template is pending.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>UpdateInProgress</code> - the update of the template is in progress.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Failed</code> - the template operation failed.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Complete</code> - the template operation is complete.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link GeneratedTemplateStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the template generation. Supported values are:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>CreatePending</code> - the creation of the template is pending.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CreateInProgress</code> - the creation of the template is in progress.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DeletePending</code> - the deletion of the template is pending.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DeleteInProgress</code> - the deletion of the template is in progress.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>UpdatePending</code> - the update of the template is pending.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>UpdateInProgress</code> - the update of the template is in progress.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Failed</code> - the template operation failed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Complete</code> - the template operation is complete.
     *         </p>
     *         </li>
     * @see GeneratedTemplateStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The reason for the current template generation status. This will provide more details if a failure happened.
     * </p>
     * 
     * @return The reason for the current template generation status. This will provide more details if a failure
     *         happened.
     */
    public final String statusReason() {
        return statusReason;
    }

    /**
     * <p>
     * The time the generated template was created.
     * </p>
     * 
     * @return The time the generated template was created.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * The time the generated template was last updated.
     * </p>
     * 
     * @return The time the generated template was last updated.
     */
    public final Instant lastUpdatedTime() {
        return lastUpdatedTime;
    }

    /**
     * <p>
     * An object describing the progress of the template generation.
     * </p>
     * 
     * @return An object describing the progress of the template generation.
     */
    public final TemplateProgress progress() {
        return progress;
    }

    /**
     * <p>
     * The stack ARN of the base stack if a base stack was provided when generating the template.
     * </p>
     * 
     * @return The stack ARN of the base stack if a base stack was provided when generating the template.
     */
    public final String stackId() {
        return stackId;
    }

    /**
     * <p>
     * The configuration details of the generated template, including the <code>DeletionPolicy</code> and
     * <code>UpdateReplacePolicy</code>.
     * </p>
     * 
     * @return The configuration details of the generated template, including the <code>DeletionPolicy</code> and
     *         <code>UpdateReplacePolicy</code>.
     */
    public final TemplateConfiguration templateConfiguration() {
        return templateConfiguration;
    }

    /**
     * <p>
     * The number of warnings generated for this template. The warnings are found in the details of each of the
     * resources in the template.
     * </p>
     * 
     * @return The number of warnings generated for this template. The warnings are found in the details of each of the
     *         resources in the template.
     */
    public final Integer totalWarnings() {
        return totalWarnings;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(generatedTemplateId());
        hashCode = 31 * hashCode + Objects.hashCode(generatedTemplateName());
        hashCode = 31 * hashCode + Objects.hashCode(hasResources() ? resources() : null);
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusReason());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedTime());
        hashCode = 31 * hashCode + Objects.hashCode(progress());
        hashCode = 31 * hashCode + Objects.hashCode(stackId());
        hashCode = 31 * hashCode + Objects.hashCode(templateConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(totalWarnings());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeGeneratedTemplateResponse)) {
            return false;
        }
        DescribeGeneratedTemplateResponse other = (DescribeGeneratedTemplateResponse) obj;
        return Objects.equals(generatedTemplateId(), other.generatedTemplateId())
                && Objects.equals(generatedTemplateName(), other.generatedTemplateName())
                && hasResources() == other.hasResources() && Objects.equals(resources(), other.resources())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(statusReason(), other.statusReason()) && Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(lastUpdatedTime(), other.lastUpdatedTime()) && Objects.equals(progress(), other.progress())
                && Objects.equals(stackId(), other.stackId())
                && Objects.equals(templateConfiguration(), other.templateConfiguration())
                && Objects.equals(totalWarnings(), other.totalWarnings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeGeneratedTemplateResponse").add("GeneratedTemplateId", generatedTemplateId())
                .add("GeneratedTemplateName", generatedTemplateName()).add("Resources", hasResources() ? resources() : null)
                .add("Status", statusAsString()).add("StatusReason", statusReason()).add("CreationTime", creationTime())
                .add("LastUpdatedTime", lastUpdatedTime()).add("Progress", progress()).add("StackId", stackId())
                .add("TemplateConfiguration", templateConfiguration()).add("TotalWarnings", totalWarnings()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "GeneratedTemplateId":
            return Optional.ofNullable(clazz.cast(generatedTemplateId()));
        case "GeneratedTemplateName":
            return Optional.ofNullable(clazz.cast(generatedTemplateName()));
        case "Resources":
            return Optional.ofNullable(clazz.cast(resources()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "StatusReason":
            return Optional.ofNullable(clazz.cast(statusReason()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "LastUpdatedTime":
            return Optional.ofNullable(clazz.cast(lastUpdatedTime()));
        case "Progress":
            return Optional.ofNullable(clazz.cast(progress()));
        case "StackId":
            return Optional.ofNullable(clazz.cast(stackId()));
        case "TemplateConfiguration":
            return Optional.ofNullable(clazz.cast(templateConfiguration()));
        case "TotalWarnings":
            return Optional.ofNullable(clazz.cast(totalWarnings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DescribeGeneratedTemplateResponse, T> g) {
        return obj -> g.apply((DescribeGeneratedTemplateResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudFormationResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeGeneratedTemplateResponse> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the generated template. The format is
         * <code>arn:${Partition}:cloudformation:${Region}:${Account}:generatedtemplate/${Id}</code>. For example,
         * <code>arn:aws:cloudformation:<i>us-east-1</i>:<i>123456789012</i>:generatedtemplate/<i>2e8465c1-9a80-43ea-a3a3-4f2d692fe6dc</i> </code>
         * .
         * </p>
         * 
         * @param generatedTemplateId
         *        The Amazon Resource Name (ARN) of the generated template. The format is
         *        <code>arn:${Partition}:cloudformation:${Region}:${Account}:generatedtemplate/${Id}</code>. For
         *        example,
         *        <code>arn:aws:cloudformation:<i>us-east-1</i>:<i>123456789012</i>:generatedtemplate/<i>2e8465c1-9a80-43ea-a3a3-4f2d692fe6dc</i> </code>
         *        .
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder generatedTemplateId(String generatedTemplateId);

        /**
         * <p>
         * The name of the generated template.
         * </p>
         * 
         * @param generatedTemplateName
         *        The name of the generated template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder generatedTemplateName(String generatedTemplateName);

        /**
         * <p>
         * A list of objects describing the details of the resources in the template generation.
         * </p>
         * 
         * @param resources
         *        A list of objects describing the details of the resources in the template generation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resources(Collection<ResourceDetail> resources);

        /**
         * <p>
         * A list of objects describing the details of the resources in the template generation.
         * </p>
         * 
         * @param resources
         *        A list of objects describing the details of the resources in the template generation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resources(ResourceDetail... resources);

        /**
         * <p>
         * A list of objects describing the details of the resources in the template generation.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.cloudformation.model.ResourceDetail.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.cloudformation.model.ResourceDetail#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.cloudformation.model.ResourceDetail.Builder#build()} is called
         * immediately and its result is passed to {@link #resources(List<ResourceDetail>)}.
         * 
         * @param resources
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.cloudformation.model.ResourceDetail.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resources(java.util.Collection<ResourceDetail>)
         */
        Builder resources(Consumer<ResourceDetail.Builder>... resources);

        /**
         * <p>
         * The status of the template generation. Supported values are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>CreatePending</code> - the creation of the template is pending.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CreateInProgress</code> - the creation of the template is in progress.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DeletePending</code> - the deletion of the template is pending.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DeleteInProgress</code> - the deletion of the template is in progress.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>UpdatePending</code> - the update of the template is pending.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>UpdateInProgress</code> - the update of the template is in progress.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Failed</code> - the template operation failed.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Complete</code> - the template operation is complete.
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The status of the template generation. Supported values are:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>CreatePending</code> - the creation of the template is pending.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CreateInProgress</code> - the creation of the template is in progress.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DeletePending</code> - the deletion of the template is pending.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DeleteInProgress</code> - the deletion of the template is in progress.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>UpdatePending</code> - the update of the template is pending.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>UpdateInProgress</code> - the update of the template is in progress.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Failed</code> - the template operation failed.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Complete</code> - the template operation is complete.
         *        </p>
         *        </li>
         * @see GeneratedTemplateStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GeneratedTemplateStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the template generation. Supported values are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>CreatePending</code> - the creation of the template is pending.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CreateInProgress</code> - the creation of the template is in progress.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DeletePending</code> - the deletion of the template is pending.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DeleteInProgress</code> - the deletion of the template is in progress.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>UpdatePending</code> - the update of the template is pending.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>UpdateInProgress</code> - the update of the template is in progress.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Failed</code> - the template operation failed.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Complete</code> - the template operation is complete.
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The status of the template generation. Supported values are:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>CreatePending</code> - the creation of the template is pending.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CreateInProgress</code> - the creation of the template is in progress.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DeletePending</code> - the deletion of the template is pending.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DeleteInProgress</code> - the deletion of the template is in progress.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>UpdatePending</code> - the update of the template is pending.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>UpdateInProgress</code> - the update of the template is in progress.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Failed</code> - the template operation failed.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Complete</code> - the template operation is complete.
         *        </p>
         *        </li>
         * @see GeneratedTemplateStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GeneratedTemplateStatus
         */
        Builder status(GeneratedTemplateStatus status);

        /**
         * <p>
         * The reason for the current template generation status. This will provide more details if a failure happened.
         * </p>
         * 
         * @param statusReason
         *        The reason for the current template generation status. This will provide more details if a failure
         *        happened.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusReason(String statusReason);

        /**
         * <p>
         * The time the generated template was created.
         * </p>
         * 
         * @param creationTime
         *        The time the generated template was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * The time the generated template was last updated.
         * </p>
         * 
         * @param lastUpdatedTime
         *        The time the generated template was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedTime(Instant lastUpdatedTime);

        /**
         * <p>
         * An object describing the progress of the template generation.
         * </p>
         * 
         * @param progress
         *        An object describing the progress of the template generation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder progress(TemplateProgress progress);

        /**
         * <p>
         * An object describing the progress of the template generation.
         * </p>
         * This is a convenience method that creates an instance of the {@link TemplateProgress.Builder} avoiding the
         * need to create one manually via {@link TemplateProgress#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TemplateProgress.Builder#build()} is called immediately and its
         * result is passed to {@link #progress(TemplateProgress)}.
         * 
         * @param progress
         *        a consumer that will call methods on {@link TemplateProgress.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #progress(TemplateProgress)
         */
        default Builder progress(Consumer<TemplateProgress.Builder> progress) {
            return progress(TemplateProgress.builder().applyMutation(progress).build());
        }

        /**
         * <p>
         * The stack ARN of the base stack if a base stack was provided when generating the template.
         * </p>
         * 
         * @param stackId
         *        The stack ARN of the base stack if a base stack was provided when generating the template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stackId(String stackId);

        /**
         * <p>
         * The configuration details of the generated template, including the <code>DeletionPolicy</code> and
         * <code>UpdateReplacePolicy</code>.
         * </p>
         * 
         * @param templateConfiguration
         *        The configuration details of the generated template, including the <code>DeletionPolicy</code> and
         *        <code>UpdateReplacePolicy</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder templateConfiguration(TemplateConfiguration templateConfiguration);

        /**
         * <p>
         * The configuration details of the generated template, including the <code>DeletionPolicy</code> and
         * <code>UpdateReplacePolicy</code>.
         * </p>
         * This is a convenience method that creates an instance of the {@link TemplateConfiguration.Builder} avoiding
         * the need to create one manually via {@link TemplateConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TemplateConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #templateConfiguration(TemplateConfiguration)}.
         * 
         * @param templateConfiguration
         *        a consumer that will call methods on {@link TemplateConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #templateConfiguration(TemplateConfiguration)
         */
        default Builder templateConfiguration(Consumer<TemplateConfiguration.Builder> templateConfiguration) {
            return templateConfiguration(TemplateConfiguration.builder().applyMutation(templateConfiguration).build());
        }

        /**
         * <p>
         * The number of warnings generated for this template. The warnings are found in the details of each of the
         * resources in the template.
         * </p>
         * 
         * @param totalWarnings
         *        The number of warnings generated for this template. The warnings are found in the details of each of
         *        the resources in the template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder totalWarnings(Integer totalWarnings);
    }

    static final class BuilderImpl extends CloudFormationResponse.BuilderImpl implements Builder {
        private String generatedTemplateId;

        private String generatedTemplateName;

        private List<ResourceDetail> resources = DefaultSdkAutoConstructList.getInstance();

        private String status;

        private String statusReason;

        private Instant creationTime;

        private Instant lastUpdatedTime;

        private TemplateProgress progress;

        private String stackId;

        private TemplateConfiguration templateConfiguration;

        private Integer totalWarnings;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeGeneratedTemplateResponse model) {
            super(model);
            generatedTemplateId(model.generatedTemplateId);
            generatedTemplateName(model.generatedTemplateName);
            resources(model.resources);
            status(model.status);
            statusReason(model.statusReason);
            creationTime(model.creationTime);
            lastUpdatedTime(model.lastUpdatedTime);
            progress(model.progress);
            stackId(model.stackId);
            templateConfiguration(model.templateConfiguration);
            totalWarnings(model.totalWarnings);
        }

        public final String getGeneratedTemplateId() {
            return generatedTemplateId;
        }

        public final void setGeneratedTemplateId(String generatedTemplateId) {
            this.generatedTemplateId = generatedTemplateId;
        }

        @Override
        public final Builder generatedTemplateId(String generatedTemplateId) {
            this.generatedTemplateId = generatedTemplateId;
            return this;
        }

        public final String getGeneratedTemplateName() {
            return generatedTemplateName;
        }

        public final void setGeneratedTemplateName(String generatedTemplateName) {
            this.generatedTemplateName = generatedTemplateName;
        }

        @Override
        public final Builder generatedTemplateName(String generatedTemplateName) {
            this.generatedTemplateName = generatedTemplateName;
            return this;
        }

        public final List<ResourceDetail.Builder> getResources() {
            List<ResourceDetail.Builder> result = ResourceDetailsCopier.copyToBuilder(this.resources);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setResources(Collection<ResourceDetail.BuilderImpl> resources) {
            this.resources = ResourceDetailsCopier.copyFromBuilder(resources);
        }

        @Override
        public final Builder resources(Collection<ResourceDetail> resources) {
            this.resources = ResourceDetailsCopier.copy(resources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resources(ResourceDetail... resources) {
            resources(Arrays.asList(resources));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resources(Consumer<ResourceDetail.Builder>... resources) {
            resources(Stream.of(resources).map(c -> ResourceDetail.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(GeneratedTemplateStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusReason() {
            return statusReason;
        }

        public final void setStatusReason(String statusReason) {
            this.statusReason = statusReason;
        }

        @Override
        public final Builder statusReason(String statusReason) {
            this.statusReason = statusReason;
            return this;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Instant getLastUpdatedTime() {
            return lastUpdatedTime;
        }

        public final void setLastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
        }

        @Override
        public final Builder lastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
            return this;
        }

        public final TemplateProgress.Builder getProgress() {
            return progress != null ? progress.toBuilder() : null;
        }

        public final void setProgress(TemplateProgress.BuilderImpl progress) {
            this.progress = progress != null ? progress.build() : null;
        }

        @Override
        public final Builder progress(TemplateProgress progress) {
            this.progress = progress;
            return this;
        }

        public final String getStackId() {
            return stackId;
        }

        public final void setStackId(String stackId) {
            this.stackId = stackId;
        }

        @Override
        public final Builder stackId(String stackId) {
            this.stackId = stackId;
            return this;
        }

        public final TemplateConfiguration.Builder getTemplateConfiguration() {
            return templateConfiguration != null ? templateConfiguration.toBuilder() : null;
        }

        public final void setTemplateConfiguration(TemplateConfiguration.BuilderImpl templateConfiguration) {
            this.templateConfiguration = templateConfiguration != null ? templateConfiguration.build() : null;
        }

        @Override
        public final Builder templateConfiguration(TemplateConfiguration templateConfiguration) {
            this.templateConfiguration = templateConfiguration;
            return this;
        }

        public final Integer getTotalWarnings() {
            return totalWarnings;
        }

        public final void setTotalWarnings(Integer totalWarnings) {
            this.totalWarnings = totalWarnings;
        }

        @Override
        public final Builder totalWarnings(Integer totalWarnings) {
            this.totalWarnings = totalWarnings;
            return this;
        }

        @Override
        public DescribeGeneratedTemplateResponse build() {
            return new DescribeGeneratedTemplateResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
