/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudformation.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The <code>Change</code> structure describes the changes CloudFormation will perform if you execute the change set.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Change implements SdkPojo, Serializable, ToCopyableBuilder<Change.Builder, Change> {
    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(Change::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final SdkField<Integer> HOOK_INVOCATION_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("HookInvocationCount").getter(getter(Change::hookInvocationCount))
            .setter(setter(Builder::hookInvocationCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HookInvocationCount").build())
            .build();

    private static final SdkField<ResourceChange> RESOURCE_CHANGE_FIELD = SdkField
            .<ResourceChange> builder(MarshallingType.SDK_POJO).memberName("ResourceChange")
            .getter(getter(Change::resourceChange)).setter(setter(Builder::resourceChange)).constructor(ResourceChange::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceChange").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD,
            HOOK_INVOCATION_COUNT_FIELD, RESOURCE_CHANGE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("Type", TYPE_FIELD);
                    put("HookInvocationCount", HOOK_INVOCATION_COUNT_FIELD);
                    put("ResourceChange", RESOURCE_CHANGE_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final String type;

    private final Integer hookInvocationCount;

    private final ResourceChange resourceChange;

    private Change(BuilderImpl builder) {
        this.type = builder.type;
        this.hookInvocationCount = builder.hookInvocationCount;
        this.resourceChange = builder.resourceChange;
    }

    /**
     * <p>
     * The type of entity that CloudFormation changes.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>Resource</code> This change is for a resource.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link ChangeType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of entity that CloudFormation changes.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>Resource</code> This change is for a resource.
     *         </p>
     *         </li>
     * @see ChangeType
     */
    public final ChangeType type() {
        return ChangeType.fromValue(type);
    }

    /**
     * <p>
     * The type of entity that CloudFormation changes.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>Resource</code> This change is for a resource.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link ChangeType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of entity that CloudFormation changes.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>Resource</code> This change is for a resource.
     *         </p>
     *         </li>
     * @see ChangeType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * Is either <code>null</code>, if no hooks invoke for the resource, or contains the number of hooks that will
     * invoke for the resource.
     * </p>
     * 
     * @return Is either <code>null</code>, if no hooks invoke for the resource, or contains the number of hooks that
     *         will invoke for the resource.
     */
    public final Integer hookInvocationCount() {
        return hookInvocationCount;
    }

    /**
     * <p>
     * A <code>ResourceChange</code> structure that describes the resource and action that CloudFormation will perform.
     * </p>
     * 
     * @return A <code>ResourceChange</code> structure that describes the resource and action that CloudFormation will
     *         perform.
     */
    public final ResourceChange resourceChange() {
        return resourceChange;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hookInvocationCount());
        hashCode = 31 * hashCode + Objects.hashCode(resourceChange());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Change)) {
            return false;
        }
        Change other = (Change) obj;
        return Objects.equals(typeAsString(), other.typeAsString())
                && Objects.equals(hookInvocationCount(), other.hookInvocationCount())
                && Objects.equals(resourceChange(), other.resourceChange());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Change").add("Type", typeAsString()).add("HookInvocationCount", hookInvocationCount())
                .add("ResourceChange", resourceChange()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "HookInvocationCount":
            return Optional.ofNullable(clazz.cast(hookInvocationCount()));
        case "ResourceChange":
            return Optional.ofNullable(clazz.cast(resourceChange()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<Change, T> g) {
        return obj -> g.apply((Change) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Change> {
        /**
         * <p>
         * The type of entity that CloudFormation changes.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>Resource</code> This change is for a resource.
         * </p>
         * </li>
         * </ul>
         * 
         * @param type
         *        The type of entity that CloudFormation changes.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>Resource</code> This change is for a resource.
         *        </p>
         *        </li>
         * @see ChangeType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ChangeType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of entity that CloudFormation changes.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>Resource</code> This change is for a resource.
         * </p>
         * </li>
         * </ul>
         * 
         * @param type
         *        The type of entity that CloudFormation changes.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>Resource</code> This change is for a resource.
         *        </p>
         *        </li>
         * @see ChangeType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ChangeType
         */
        Builder type(ChangeType type);

        /**
         * <p>
         * Is either <code>null</code>, if no hooks invoke for the resource, or contains the number of hooks that will
         * invoke for the resource.
         * </p>
         * 
         * @param hookInvocationCount
         *        Is either <code>null</code>, if no hooks invoke for the resource, or contains the number of hooks that
         *        will invoke for the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hookInvocationCount(Integer hookInvocationCount);

        /**
         * <p>
         * A <code>ResourceChange</code> structure that describes the resource and action that CloudFormation will
         * perform.
         * </p>
         * 
         * @param resourceChange
         *        A <code>ResourceChange</code> structure that describes the resource and action that CloudFormation
         *        will perform.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceChange(ResourceChange resourceChange);

        /**
         * <p>
         * A <code>ResourceChange</code> structure that describes the resource and action that CloudFormation will
         * perform.
         * </p>
         * This is a convenience method that creates an instance of the {@link ResourceChange.Builder} avoiding the need
         * to create one manually via {@link ResourceChange#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ResourceChange.Builder#build()} is called immediately and its
         * result is passed to {@link #resourceChange(ResourceChange)}.
         * 
         * @param resourceChange
         *        a consumer that will call methods on {@link ResourceChange.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resourceChange(ResourceChange)
         */
        default Builder resourceChange(Consumer<ResourceChange.Builder> resourceChange) {
            return resourceChange(ResourceChange.builder().applyMutation(resourceChange).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String type;

        private Integer hookInvocationCount;

        private ResourceChange resourceChange;

        private BuilderImpl() {
        }

        private BuilderImpl(Change model) {
            type(model.type);
            hookInvocationCount(model.hookInvocationCount);
            resourceChange(model.resourceChange);
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(ChangeType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final Integer getHookInvocationCount() {
            return hookInvocationCount;
        }

        public final void setHookInvocationCount(Integer hookInvocationCount) {
            this.hookInvocationCount = hookInvocationCount;
        }

        @Override
        public final Builder hookInvocationCount(Integer hookInvocationCount) {
            this.hookInvocationCount = hookInvocationCount;
            return this;
        }

        public final ResourceChange.Builder getResourceChange() {
            return resourceChange != null ? resourceChange.toBuilder() : null;
        }

        public final void setResourceChange(ResourceChange.BuilderImpl resourceChange) {
            this.resourceChange = resourceChange != null ? resourceChange.build() : null;
        }

        @Override
        public final Builder resourceChange(ResourceChange resourceChange) {
            this.resourceChange = resourceChange;
            return this;
        }

        @Override
        public Change build() {
            return new Change(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
