/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudformation.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateGeneratedTemplateRequest extends CloudFormationRequest implements
        ToCopyableBuilder<UpdateGeneratedTemplateRequest.Builder, UpdateGeneratedTemplateRequest> {
    private static final SdkField<String> GENERATED_TEMPLATE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GeneratedTemplateName").getter(getter(UpdateGeneratedTemplateRequest::generatedTemplateName))
            .setter(setter(Builder::generatedTemplateName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GeneratedTemplateName").build())
            .build();

    private static final SdkField<String> NEW_GENERATED_TEMPLATE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NewGeneratedTemplateName").getter(getter(UpdateGeneratedTemplateRequest::newGeneratedTemplateName))
            .setter(setter(Builder::newGeneratedTemplateName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NewGeneratedTemplateName").build())
            .build();

    private static final SdkField<List<ResourceDefinition>> ADD_RESOURCES_FIELD = SdkField
            .<List<ResourceDefinition>> builder(MarshallingType.LIST)
            .memberName("AddResources")
            .getter(getter(UpdateGeneratedTemplateRequest::addResources))
            .setter(setter(Builder::addResources))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AddResources").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ResourceDefinition> builder(MarshallingType.SDK_POJO)
                                            .constructor(ResourceDefinition::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> REMOVE_RESOURCES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("RemoveResources")
            .getter(getter(UpdateGeneratedTemplateRequest::removeResources))
            .setter(setter(Builder::removeResources))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RemoveResources").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Boolean> REFRESH_ALL_RESOURCES_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("RefreshAllResources").getter(getter(UpdateGeneratedTemplateRequest::refreshAllResources))
            .setter(setter(Builder::refreshAllResources))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RefreshAllResources").build())
            .build();

    private static final SdkField<TemplateConfiguration> TEMPLATE_CONFIGURATION_FIELD = SdkField
            .<TemplateConfiguration> builder(MarshallingType.SDK_POJO).memberName("TemplateConfiguration")
            .getter(getter(UpdateGeneratedTemplateRequest::templateConfiguration)).setter(setter(Builder::templateConfiguration))
            .constructor(TemplateConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TemplateConfiguration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GENERATED_TEMPLATE_NAME_FIELD,
            NEW_GENERATED_TEMPLATE_NAME_FIELD, ADD_RESOURCES_FIELD, REMOVE_RESOURCES_FIELD, REFRESH_ALL_RESOURCES_FIELD,
            TEMPLATE_CONFIGURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String generatedTemplateName;

    private final String newGeneratedTemplateName;

    private final List<ResourceDefinition> addResources;

    private final List<String> removeResources;

    private final Boolean refreshAllResources;

    private final TemplateConfiguration templateConfiguration;

    private UpdateGeneratedTemplateRequest(BuilderImpl builder) {
        super(builder);
        this.generatedTemplateName = builder.generatedTemplateName;
        this.newGeneratedTemplateName = builder.newGeneratedTemplateName;
        this.addResources = builder.addResources;
        this.removeResources = builder.removeResources;
        this.refreshAllResources = builder.refreshAllResources;
        this.templateConfiguration = builder.templateConfiguration;
    }

    /**
     * <p>
     * The name or Amazon Resource Name (ARN) of a generated template.
     * </p>
     * 
     * @return The name or Amazon Resource Name (ARN) of a generated template.
     */
    public final String generatedTemplateName() {
        return generatedTemplateName;
    }

    /**
     * <p>
     * An optional new name to assign to the generated template.
     * </p>
     * 
     * @return An optional new name to assign to the generated template.
     */
    public final String newGeneratedTemplateName() {
        return newGeneratedTemplateName;
    }

    /**
     * For responses, this returns true if the service returned a value for the AddResources property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAddResources() {
        return addResources != null && !(addResources instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An optional list of resources to be added to the generated template.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAddResources} method.
     * </p>
     * 
     * @return An optional list of resources to be added to the generated template.
     */
    public final List<ResourceDefinition> addResources() {
        return addResources;
    }

    /**
     * For responses, this returns true if the service returned a value for the RemoveResources property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasRemoveResources() {
        return removeResources != null && !(removeResources instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of logical ids for resources to remove from the generated template.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRemoveResources} method.
     * </p>
     * 
     * @return A list of logical ids for resources to remove from the generated template.
     */
    public final List<String> removeResources() {
        return removeResources;
    }

    /**
     * <p>
     * If <code>true</code>, update the resource properties in the generated template with their current live state.
     * This feature is useful when the resource properties in your generated a template does not reflect the live state
     * of the resource properties. This happens when a user update the resource properties after generating a template.
     * </p>
     * 
     * @return If <code>true</code>, update the resource properties in the generated template with their current live
     *         state. This feature is useful when the resource properties in your generated a template does not reflect
     *         the live state of the resource properties. This happens when a user update the resource properties after
     *         generating a template.
     */
    public final Boolean refreshAllResources() {
        return refreshAllResources;
    }

    /**
     * <p>
     * The configuration details of the generated template, including the <code>DeletionPolicy</code> and
     * <code>UpdateReplacePolicy</code>.
     * </p>
     * 
     * @return The configuration details of the generated template, including the <code>DeletionPolicy</code> and
     *         <code>UpdateReplacePolicy</code>.
     */
    public final TemplateConfiguration templateConfiguration() {
        return templateConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(generatedTemplateName());
        hashCode = 31 * hashCode + Objects.hashCode(newGeneratedTemplateName());
        hashCode = 31 * hashCode + Objects.hashCode(hasAddResources() ? addResources() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasRemoveResources() ? removeResources() : null);
        hashCode = 31 * hashCode + Objects.hashCode(refreshAllResources());
        hashCode = 31 * hashCode + Objects.hashCode(templateConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateGeneratedTemplateRequest)) {
            return false;
        }
        UpdateGeneratedTemplateRequest other = (UpdateGeneratedTemplateRequest) obj;
        return Objects.equals(generatedTemplateName(), other.generatedTemplateName())
                && Objects.equals(newGeneratedTemplateName(), other.newGeneratedTemplateName())
                && hasAddResources() == other.hasAddResources() && Objects.equals(addResources(), other.addResources())
                && hasRemoveResources() == other.hasRemoveResources()
                && Objects.equals(removeResources(), other.removeResources())
                && Objects.equals(refreshAllResources(), other.refreshAllResources())
                && Objects.equals(templateConfiguration(), other.templateConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateGeneratedTemplateRequest").add("GeneratedTemplateName", generatedTemplateName())
                .add("NewGeneratedTemplateName", newGeneratedTemplateName())
                .add("AddResources", hasAddResources() ? addResources() : null)
                .add("RemoveResources", hasRemoveResources() ? removeResources() : null)
                .add("RefreshAllResources", refreshAllResources()).add("TemplateConfiguration", templateConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "GeneratedTemplateName":
            return Optional.ofNullable(clazz.cast(generatedTemplateName()));
        case "NewGeneratedTemplateName":
            return Optional.ofNullable(clazz.cast(newGeneratedTemplateName()));
        case "AddResources":
            return Optional.ofNullable(clazz.cast(addResources()));
        case "RemoveResources":
            return Optional.ofNullable(clazz.cast(removeResources()));
        case "RefreshAllResources":
            return Optional.ofNullable(clazz.cast(refreshAllResources()));
        case "TemplateConfiguration":
            return Optional.ofNullable(clazz.cast(templateConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("GeneratedTemplateName", GENERATED_TEMPLATE_NAME_FIELD);
        map.put("NewGeneratedTemplateName", NEW_GENERATED_TEMPLATE_NAME_FIELD);
        map.put("AddResources", ADD_RESOURCES_FIELD);
        map.put("RemoveResources", REMOVE_RESOURCES_FIELD);
        map.put("RefreshAllResources", REFRESH_ALL_RESOURCES_FIELD);
        map.put("TemplateConfiguration", TEMPLATE_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateGeneratedTemplateRequest, T> g) {
        return obj -> g.apply((UpdateGeneratedTemplateRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudFormationRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateGeneratedTemplateRequest> {
        /**
         * <p>
         * The name or Amazon Resource Name (ARN) of a generated template.
         * </p>
         * 
         * @param generatedTemplateName
         *        The name or Amazon Resource Name (ARN) of a generated template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder generatedTemplateName(String generatedTemplateName);

        /**
         * <p>
         * An optional new name to assign to the generated template.
         * </p>
         * 
         * @param newGeneratedTemplateName
         *        An optional new name to assign to the generated template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder newGeneratedTemplateName(String newGeneratedTemplateName);

        /**
         * <p>
         * An optional list of resources to be added to the generated template.
         * </p>
         * 
         * @param addResources
         *        An optional list of resources to be added to the generated template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder addResources(Collection<ResourceDefinition> addResources);

        /**
         * <p>
         * An optional list of resources to be added to the generated template.
         * </p>
         * 
         * @param addResources
         *        An optional list of resources to be added to the generated template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder addResources(ResourceDefinition... addResources);

        /**
         * <p>
         * An optional list of resources to be added to the generated template.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.cloudformation.model.ResourceDefinition.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.cloudformation.model.ResourceDefinition#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.cloudformation.model.ResourceDefinition.Builder#build()} is called
         * immediately and its result is passed to {@link #addResources(List<ResourceDefinition>)}.
         * 
         * @param addResources
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.cloudformation.model.ResourceDefinition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #addResources(java.util.Collection<ResourceDefinition>)
         */
        Builder addResources(Consumer<ResourceDefinition.Builder>... addResources);

        /**
         * <p>
         * A list of logical ids for resources to remove from the generated template.
         * </p>
         * 
         * @param removeResources
         *        A list of logical ids for resources to remove from the generated template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder removeResources(Collection<String> removeResources);

        /**
         * <p>
         * A list of logical ids for resources to remove from the generated template.
         * </p>
         * 
         * @param removeResources
         *        A list of logical ids for resources to remove from the generated template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder removeResources(String... removeResources);

        /**
         * <p>
         * If <code>true</code>, update the resource properties in the generated template with their current live state.
         * This feature is useful when the resource properties in your generated a template does not reflect the live
         * state of the resource properties. This happens when a user update the resource properties after generating a
         * template.
         * </p>
         * 
         * @param refreshAllResources
         *        If <code>true</code>, update the resource properties in the generated template with their current live
         *        state. This feature is useful when the resource properties in your generated a template does not
         *        reflect the live state of the resource properties. This happens when a user update the resource
         *        properties after generating a template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder refreshAllResources(Boolean refreshAllResources);

        /**
         * <p>
         * The configuration details of the generated template, including the <code>DeletionPolicy</code> and
         * <code>UpdateReplacePolicy</code>.
         * </p>
         * 
         * @param templateConfiguration
         *        The configuration details of the generated template, including the <code>DeletionPolicy</code> and
         *        <code>UpdateReplacePolicy</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder templateConfiguration(TemplateConfiguration templateConfiguration);

        /**
         * <p>
         * The configuration details of the generated template, including the <code>DeletionPolicy</code> and
         * <code>UpdateReplacePolicy</code>.
         * </p>
         * This is a convenience method that creates an instance of the {@link TemplateConfiguration.Builder} avoiding
         * the need to create one manually via {@link TemplateConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TemplateConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #templateConfiguration(TemplateConfiguration)}.
         * 
         * @param templateConfiguration
         *        a consumer that will call methods on {@link TemplateConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #templateConfiguration(TemplateConfiguration)
         */
        default Builder templateConfiguration(Consumer<TemplateConfiguration.Builder> templateConfiguration) {
            return templateConfiguration(TemplateConfiguration.builder().applyMutation(templateConfiguration).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CloudFormationRequest.BuilderImpl implements Builder {
        private String generatedTemplateName;

        private String newGeneratedTemplateName;

        private List<ResourceDefinition> addResources = DefaultSdkAutoConstructList.getInstance();

        private List<String> removeResources = DefaultSdkAutoConstructList.getInstance();

        private Boolean refreshAllResources;

        private TemplateConfiguration templateConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateGeneratedTemplateRequest model) {
            super(model);
            generatedTemplateName(model.generatedTemplateName);
            newGeneratedTemplateName(model.newGeneratedTemplateName);
            addResources(model.addResources);
            removeResources(model.removeResources);
            refreshAllResources(model.refreshAllResources);
            templateConfiguration(model.templateConfiguration);
        }

        public final String getGeneratedTemplateName() {
            return generatedTemplateName;
        }

        public final void setGeneratedTemplateName(String generatedTemplateName) {
            this.generatedTemplateName = generatedTemplateName;
        }

        @Override
        public final Builder generatedTemplateName(String generatedTemplateName) {
            this.generatedTemplateName = generatedTemplateName;
            return this;
        }

        public final String getNewGeneratedTemplateName() {
            return newGeneratedTemplateName;
        }

        public final void setNewGeneratedTemplateName(String newGeneratedTemplateName) {
            this.newGeneratedTemplateName = newGeneratedTemplateName;
        }

        @Override
        public final Builder newGeneratedTemplateName(String newGeneratedTemplateName) {
            this.newGeneratedTemplateName = newGeneratedTemplateName;
            return this;
        }

        public final List<ResourceDefinition.Builder> getAddResources() {
            List<ResourceDefinition.Builder> result = ResourceDefinitionsCopier.copyToBuilder(this.addResources);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAddResources(Collection<ResourceDefinition.BuilderImpl> addResources) {
            this.addResources = ResourceDefinitionsCopier.copyFromBuilder(addResources);
        }

        @Override
        public final Builder addResources(Collection<ResourceDefinition> addResources) {
            this.addResources = ResourceDefinitionsCopier.copy(addResources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder addResources(ResourceDefinition... addResources) {
            addResources(Arrays.asList(addResources));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder addResources(Consumer<ResourceDefinition.Builder>... addResources) {
            addResources(Stream.of(addResources).map(c -> ResourceDefinition.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getRemoveResources() {
            if (removeResources instanceof SdkAutoConstructList) {
                return null;
            }
            return removeResources;
        }

        public final void setRemoveResources(Collection<String> removeResources) {
            this.removeResources = JazzLogicalResourceIdsCopier.copy(removeResources);
        }

        @Override
        public final Builder removeResources(Collection<String> removeResources) {
            this.removeResources = JazzLogicalResourceIdsCopier.copy(removeResources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder removeResources(String... removeResources) {
            removeResources(Arrays.asList(removeResources));
            return this;
        }

        public final Boolean getRefreshAllResources() {
            return refreshAllResources;
        }

        public final void setRefreshAllResources(Boolean refreshAllResources) {
            this.refreshAllResources = refreshAllResources;
        }

        @Override
        public final Builder refreshAllResources(Boolean refreshAllResources) {
            this.refreshAllResources = refreshAllResources;
            return this;
        }

        public final TemplateConfiguration.Builder getTemplateConfiguration() {
            return templateConfiguration != null ? templateConfiguration.toBuilder() : null;
        }

        public final void setTemplateConfiguration(TemplateConfiguration.BuilderImpl templateConfiguration) {
            this.templateConfiguration = templateConfiguration != null ? templateConfiguration.build() : null;
        }

        @Override
        public final Builder templateConfiguration(TemplateConfiguration templateConfiguration) {
            this.templateConfiguration = templateConfiguration;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateGeneratedTemplateRequest build() {
            return new UpdateGeneratedTemplateRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
