/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudformation.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The Stack data type.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Stack implements SdkPojo, Serializable, ToCopyableBuilder<Stack.Builder, Stack> {
    private static final SdkField<String> STACK_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StackId").getter(getter(Stack::stackId)).setter(setter(Builder::stackId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StackId").build()).build();

    private static final SdkField<String> STACK_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StackName").getter(getter(Stack::stackName)).setter(setter(Builder::stackName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StackName").build()).build();

    private static final SdkField<String> CHANGE_SET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ChangeSetId").getter(getter(Stack::changeSetId)).setter(setter(Builder::changeSetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChangeSetId").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(Stack::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<List<Parameter>> PARAMETERS_FIELD = SdkField
            .<List<Parameter>> builder(MarshallingType.LIST)
            .memberName("Parameters")
            .getter(getter(Stack::parameters))
            .setter(setter(Builder::parameters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Parameters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Parameter> builder(MarshallingType.SDK_POJO)
                                            .constructor(Parameter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTime").getter(getter(Stack::creationTime)).setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()).build();

    private static final SdkField<Instant> DELETION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("DeletionTime").getter(getter(Stack::deletionTime)).setter(setter(Builder::deletionTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeletionTime").build()).build();

    private static final SdkField<Instant> LAST_UPDATED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastUpdatedTime").getter(getter(Stack::lastUpdatedTime)).setter(setter(Builder::lastUpdatedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdatedTime").build()).build();

    private static final SdkField<RollbackConfiguration> ROLLBACK_CONFIGURATION_FIELD = SdkField
            .<RollbackConfiguration> builder(MarshallingType.SDK_POJO).memberName("RollbackConfiguration")
            .getter(getter(Stack::rollbackConfiguration)).setter(setter(Builder::rollbackConfiguration))
            .constructor(RollbackConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RollbackConfiguration").build())
            .build();

    private static final SdkField<String> STACK_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StackStatus").getter(getter(Stack::stackStatusAsString)).setter(setter(Builder::stackStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StackStatus").build()).build();

    private static final SdkField<String> STACK_STATUS_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StackStatusReason").getter(getter(Stack::stackStatusReason)).setter(setter(Builder::stackStatusReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StackStatusReason").build()).build();

    private static final SdkField<Boolean> DISABLE_ROLLBACK_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("DisableRollback").getter(getter(Stack::disableRollback)).setter(setter(Builder::disableRollback))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisableRollback").build()).build();

    private static final SdkField<List<String>> NOTIFICATION_AR_NS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("NotificationARNs")
            .getter(getter(Stack::notificationARNs))
            .setter(setter(Builder::notificationARNs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NotificationARNs").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Integer> TIMEOUT_IN_MINUTES_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("TimeoutInMinutes").getter(getter(Stack::timeoutInMinutes)).setter(setter(Builder::timeoutInMinutes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimeoutInMinutes").build()).build();

    private static final SdkField<List<String>> CAPABILITIES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Capabilities")
            .getter(getter(Stack::capabilitiesAsStrings))
            .setter(setter(Builder::capabilitiesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Capabilities").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<Output>> OUTPUTS_FIELD = SdkField
            .<List<Output>> builder(MarshallingType.LIST)
            .memberName("Outputs")
            .getter(getter(Stack::outputs))
            .setter(setter(Builder::outputs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Outputs").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Output> builder(MarshallingType.SDK_POJO)
                                            .constructor(Output::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RoleARN").getter(getter(Stack::roleARN)).setter(setter(Builder::roleARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleARN").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(Stack::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Boolean> ENABLE_TERMINATION_PROTECTION_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("EnableTerminationProtection")
            .getter(getter(Stack::enableTerminationProtection))
            .setter(setter(Builder::enableTerminationProtection))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnableTerminationProtection")
                    .build()).build();

    private static final SdkField<String> PARENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ParentId").getter(getter(Stack::parentId)).setter(setter(Builder::parentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParentId").build()).build();

    private static final SdkField<String> ROOT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("RootId")
            .getter(getter(Stack::rootId)).setter(setter(Builder::rootId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RootId").build()).build();

    private static final SdkField<StackDriftInformation> DRIFT_INFORMATION_FIELD = SdkField
            .<StackDriftInformation> builder(MarshallingType.SDK_POJO).memberName("DriftInformation")
            .getter(getter(Stack::driftInformation)).setter(setter(Builder::driftInformation))
            .constructor(StackDriftInformation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DriftInformation").build()).build();

    private static final SdkField<Boolean> RETAIN_EXCEPT_ON_CREATE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("RetainExceptOnCreate").getter(getter(Stack::retainExceptOnCreate))
            .setter(setter(Builder::retainExceptOnCreate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RetainExceptOnCreate").build())
            .build();

    private static final SdkField<String> DELETION_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DeletionMode").getter(getter(Stack::deletionModeAsString)).setter(setter(Builder::deletionMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeletionMode").build()).build();

    private static final SdkField<String> DETAILED_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DetailedStatus").getter(getter(Stack::detailedStatusAsString)).setter(setter(Builder::detailedStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DetailedStatus").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STACK_ID_FIELD,
            STACK_NAME_FIELD, CHANGE_SET_ID_FIELD, DESCRIPTION_FIELD, PARAMETERS_FIELD, CREATION_TIME_FIELD, DELETION_TIME_FIELD,
            LAST_UPDATED_TIME_FIELD, ROLLBACK_CONFIGURATION_FIELD, STACK_STATUS_FIELD, STACK_STATUS_REASON_FIELD,
            DISABLE_ROLLBACK_FIELD, NOTIFICATION_AR_NS_FIELD, TIMEOUT_IN_MINUTES_FIELD, CAPABILITIES_FIELD, OUTPUTS_FIELD,
            ROLE_ARN_FIELD, TAGS_FIELD, ENABLE_TERMINATION_PROTECTION_FIELD, PARENT_ID_FIELD, ROOT_ID_FIELD,
            DRIFT_INFORMATION_FIELD, RETAIN_EXCEPT_ON_CREATE_FIELD, DELETION_MODE_FIELD, DETAILED_STATUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String stackId;

    private final String stackName;

    private final String changeSetId;

    private final String description;

    private final List<Parameter> parameters;

    private final Instant creationTime;

    private final Instant deletionTime;

    private final Instant lastUpdatedTime;

    private final RollbackConfiguration rollbackConfiguration;

    private final String stackStatus;

    private final String stackStatusReason;

    private final Boolean disableRollback;

    private final List<String> notificationARNs;

    private final Integer timeoutInMinutes;

    private final List<String> capabilities;

    private final List<Output> outputs;

    private final String roleARN;

    private final List<Tag> tags;

    private final Boolean enableTerminationProtection;

    private final String parentId;

    private final String rootId;

    private final StackDriftInformation driftInformation;

    private final Boolean retainExceptOnCreate;

    private final String deletionMode;

    private final String detailedStatus;

    private Stack(BuilderImpl builder) {
        this.stackId = builder.stackId;
        this.stackName = builder.stackName;
        this.changeSetId = builder.changeSetId;
        this.description = builder.description;
        this.parameters = builder.parameters;
        this.creationTime = builder.creationTime;
        this.deletionTime = builder.deletionTime;
        this.lastUpdatedTime = builder.lastUpdatedTime;
        this.rollbackConfiguration = builder.rollbackConfiguration;
        this.stackStatus = builder.stackStatus;
        this.stackStatusReason = builder.stackStatusReason;
        this.disableRollback = builder.disableRollback;
        this.notificationARNs = builder.notificationARNs;
        this.timeoutInMinutes = builder.timeoutInMinutes;
        this.capabilities = builder.capabilities;
        this.outputs = builder.outputs;
        this.roleARN = builder.roleARN;
        this.tags = builder.tags;
        this.enableTerminationProtection = builder.enableTerminationProtection;
        this.parentId = builder.parentId;
        this.rootId = builder.rootId;
        this.driftInformation = builder.driftInformation;
        this.retainExceptOnCreate = builder.retainExceptOnCreate;
        this.deletionMode = builder.deletionMode;
        this.detailedStatus = builder.detailedStatus;
    }

    /**
     * <p>
     * Unique identifier of the stack.
     * </p>
     * 
     * @return Unique identifier of the stack.
     */
    public final String stackId() {
        return stackId;
    }

    /**
     * <p>
     * The name associated with the stack.
     * </p>
     * 
     * @return The name associated with the stack.
     */
    public final String stackName() {
        return stackName;
    }

    /**
     * <p>
     * The unique ID of the change set.
     * </p>
     * 
     * @return The unique ID of the change set.
     */
    public final String changeSetId() {
        return changeSetId;
    }

    /**
     * <p>
     * A user-defined description associated with the stack.
     * </p>
     * 
     * @return A user-defined description associated with the stack.
     */
    public final String description() {
        return description;
    }

    /**
     * For responses, this returns true if the service returned a value for the Parameters property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasParameters() {
        return parameters != null && !(parameters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of <code>Parameter</code> structures.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasParameters} method.
     * </p>
     * 
     * @return A list of <code>Parameter</code> structures.
     */
    public final List<Parameter> parameters() {
        return parameters;
    }

    /**
     * <p>
     * The time at which the stack was created.
     * </p>
     * 
     * @return The time at which the stack was created.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * The time the stack was deleted.
     * </p>
     * 
     * @return The time the stack was deleted.
     */
    public final Instant deletionTime() {
        return deletionTime;
    }

    /**
     * <p>
     * The time the stack was last updated. This field will only be returned if the stack has been updated at least
     * once.
     * </p>
     * 
     * @return The time the stack was last updated. This field will only be returned if the stack has been updated at
     *         least once.
     */
    public final Instant lastUpdatedTime() {
        return lastUpdatedTime;
    }

    /**
     * <p>
     * The rollback triggers for CloudFormation to monitor during stack creation and updating operations, and for the
     * specified monitoring period afterwards.
     * </p>
     * 
     * @return The rollback triggers for CloudFormation to monitor during stack creation and updating operations, and
     *         for the specified monitoring period afterwards.
     */
    public final RollbackConfiguration rollbackConfiguration() {
        return rollbackConfiguration;
    }

    /**
     * <p>
     * Current status of the stack.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #stackStatus} will
     * return {@link StackStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stackStatusAsString}.
     * </p>
     * 
     * @return Current status of the stack.
     * @see StackStatus
     */
    public final StackStatus stackStatus() {
        return StackStatus.fromValue(stackStatus);
    }

    /**
     * <p>
     * Current status of the stack.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #stackStatus} will
     * return {@link StackStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stackStatusAsString}.
     * </p>
     * 
     * @return Current status of the stack.
     * @see StackStatus
     */
    public final String stackStatusAsString() {
        return stackStatus;
    }

    /**
     * <p>
     * Success/failure message associated with the stack status.
     * </p>
     * 
     * @return Success/failure message associated with the stack status.
     */
    public final String stackStatusReason() {
        return stackStatusReason;
    }

    /**
     * <p>
     * Boolean to enable or disable rollback on stack creation failures:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>true</code>: disable rollback.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>false</code>: enable rollback.
     * </p>
     * </li>
     * </ul>
     * 
     * @return Boolean to enable or disable rollback on stack creation failures:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>true</code>: disable rollback.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>false</code>: enable rollback.
     *         </p>
     *         </li>
     */
    public final Boolean disableRollback() {
        return disableRollback;
    }

    /**
     * For responses, this returns true if the service returned a value for the NotificationARNs property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasNotificationARNs() {
        return notificationARNs != null && !(notificationARNs instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Amazon SNS topic Amazon Resource Names (ARNs) to which stack related events are published.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasNotificationARNs} method.
     * </p>
     * 
     * @return Amazon SNS topic Amazon Resource Names (ARNs) to which stack related events are published.
     */
    public final List<String> notificationARNs() {
        return notificationARNs;
    }

    /**
     * <p>
     * The amount of time within which stack creation should complete.
     * </p>
     * 
     * @return The amount of time within which stack creation should complete.
     */
    public final Integer timeoutInMinutes() {
        return timeoutInMinutes;
    }

    /**
     * <p>
     * The capabilities allowed in the stack.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCapabilities} method.
     * </p>
     * 
     * @return The capabilities allowed in the stack.
     */
    public final List<Capability> capabilities() {
        return CapabilitiesCopier.copyStringToEnum(capabilities);
    }

    /**
     * For responses, this returns true if the service returned a value for the Capabilities property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasCapabilities() {
        return capabilities != null && !(capabilities instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The capabilities allowed in the stack.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCapabilities} method.
     * </p>
     * 
     * @return The capabilities allowed in the stack.
     */
    public final List<String> capabilitiesAsStrings() {
        return capabilities;
    }

    /**
     * For responses, this returns true if the service returned a value for the Outputs property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasOutputs() {
        return outputs != null && !(outputs instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of output structures.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasOutputs} method.
     * </p>
     * 
     * @return A list of output structures.
     */
    public final List<Output> outputs() {
        return outputs;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of an IAM role that's associated with the stack. During a stack operation,
     * CloudFormation uses this role's credentials to make calls on your behalf.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of an IAM role that's associated with the stack. During a stack operation,
     *         CloudFormation uses this role's credentials to make calls on your behalf.
     */
    public final String roleARN() {
        return roleARN;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of <code>Tag</code>s that specify information about the stack.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return A list of <code>Tag</code>s that specify information about the stack.
     */
    public final List<Tag> tags() {
        return tags;
    }

    /**
     * <p>
     * Whether termination protection is enabled for the stack.
     * </p>
     * <p>
     * For <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-nested-stacks.html">nested
     * stacks</a>, termination protection is set on the root stack and can't be changed directly on the nested stack.
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-protect-stacks.html">Protect a
     * CloudFormation stack from being deleted</a> in the <i>CloudFormation User Guide</i>.
     * </p>
     * 
     * @return Whether termination protection is enabled for the stack.</p>
     *         <p>
     *         For <a
     *         href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-nested-stacks.html">nested
     *         stacks</a>, termination protection is set on the root stack and can't be changed directly on the nested
     *         stack. For more information, see <a
     *         href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-protect-stacks.html"
     *         >Protect a CloudFormation stack from being deleted</a> in the <i>CloudFormation User Guide</i>.
     */
    public final Boolean enableTerminationProtection() {
        return enableTerminationProtection;
    }

    /**
     * <p>
     * For nested stacks--stacks created as resources for another stack--the stack ID of the direct parent of this
     * stack. For the first level of nested stacks, the root stack is also the parent stack.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-nested-stacks.html">Embed stacks
     * within other stacks using nested stacks</a> in the <i>CloudFormation User Guide</i>.
     * </p>
     * 
     * @return For nested stacks--stacks created as resources for another stack--the stack ID of the direct parent of
     *         this stack. For the first level of nested stacks, the root stack is also the parent stack.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-nested-stacks.html">Embed
     *         stacks within other stacks using nested stacks</a> in the <i>CloudFormation User Guide</i>.
     */
    public final String parentId() {
        return parentId;
    }

    /**
     * <p>
     * For nested stacks--stacks created as resources for another stack--the stack ID of the top-level stack to which
     * the nested stack ultimately belongs.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-nested-stacks.html">Embed stacks
     * within other stacks using nested stacks</a> in the <i>CloudFormation User Guide</i>.
     * </p>
     * 
     * @return For nested stacks--stacks created as resources for another stack--the stack ID of the top-level stack to
     *         which the nested stack ultimately belongs.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-nested-stacks.html">Embed
     *         stacks within other stacks using nested stacks</a> in the <i>CloudFormation User Guide</i>.
     */
    public final String rootId() {
        return rootId;
    }

    /**
     * <p>
     * Information about whether a stack's actual configuration differs, or has <i>drifted</i>, from its expected
     * configuration, as defined in the stack template and any values specified as template parameters. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-stack-drift.html">Detect unmanaged
     * configuration changes to stacks and resources with drift detection</a>.
     * </p>
     * 
     * @return Information about whether a stack's actual configuration differs, or has <i>drifted</i>, from its
     *         expected configuration, as defined in the stack template and any values specified as template parameters.
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-stack-drift.html">Detect
     *         unmanaged configuration changes to stacks and resources with drift detection</a>.
     */
    public final StackDriftInformation driftInformation() {
        return driftInformation;
    }

    /**
     * <p>
     * When set to <code>true</code>, newly created resources are deleted when the operation rolls back. This includes
     * newly created resources marked with a deletion policy of <code>Retain</code>.
     * </p>
     * <p>
     * Default: <code>false</code>
     * </p>
     * 
     * @return When set to <code>true</code>, newly created resources are deleted when the operation rolls back. This
     *         includes newly created resources marked with a deletion policy of <code>Retain</code>.</p>
     *         <p>
     *         Default: <code>false</code>
     */
    public final Boolean retainExceptOnCreate() {
        return retainExceptOnCreate;
    }

    /**
     * <p>
     * Specifies the deletion mode for the stack. Possible values are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>STANDARD</code> - Use the standard behavior. Specifying this value is the same as not specifying this
     * parameter.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>FORCE_DELETE_STACK</code> - Delete the stack if it's stuck in a <code>DELETE_FAILED</code> state due to
     * resource deletion failure.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #deletionMode} will
     * return {@link DeletionMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #deletionModeAsString}.
     * </p>
     * 
     * @return Specifies the deletion mode for the stack. Possible values are:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>STANDARD</code> - Use the standard behavior. Specifying this value is the same as not specifying
     *         this parameter.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>FORCE_DELETE_STACK</code> - Delete the stack if it's stuck in a <code>DELETE_FAILED</code> state
     *         due to resource deletion failure.
     *         </p>
     *         </li>
     * @see DeletionMode
     */
    public final DeletionMode deletionMode() {
        return DeletionMode.fromValue(deletionMode);
    }

    /**
     * <p>
     * Specifies the deletion mode for the stack. Possible values are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>STANDARD</code> - Use the standard behavior. Specifying this value is the same as not specifying this
     * parameter.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>FORCE_DELETE_STACK</code> - Delete the stack if it's stuck in a <code>DELETE_FAILED</code> state due to
     * resource deletion failure.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #deletionMode} will
     * return {@link DeletionMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #deletionModeAsString}.
     * </p>
     * 
     * @return Specifies the deletion mode for the stack. Possible values are:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>STANDARD</code> - Use the standard behavior. Specifying this value is the same as not specifying
     *         this parameter.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>FORCE_DELETE_STACK</code> - Delete the stack if it's stuck in a <code>DELETE_FAILED</code> state
     *         due to resource deletion failure.
     *         </p>
     *         </li>
     * @see DeletionMode
     */
    public final String deletionModeAsString() {
        return deletionMode;
    }

    /**
     * <p>
     * The detailed status of the resource or stack. If <code>CONFIGURATION_COMPLETE</code> is present, the resource or
     * resource configuration phase has completed and the stabilization of the resources is in progress. The stack sets
     * <code>CONFIGURATION_COMPLETE</code> when all of the resources in the stack have reached that event. For more
     * information, see <a href=
     * "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stack-resource-configuration-complete.html"
     * >Understand CloudFormation stack creation events</a> in the <i>CloudFormation User Guide</i>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #detailedStatus}
     * will return {@link DetailedStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #detailedStatusAsString}.
     * </p>
     * 
     * @return The detailed status of the resource or stack. If <code>CONFIGURATION_COMPLETE</code> is present, the
     *         resource or resource configuration phase has completed and the stabilization of the resources is in
     *         progress. The stack sets <code>CONFIGURATION_COMPLETE</code> when all of the resources in the stack have
     *         reached that event. For more information, see <a href=
     *         "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stack-resource-configuration-complete.html"
     *         >Understand CloudFormation stack creation events</a> in the <i>CloudFormation User Guide</i>.
     * @see DetailedStatus
     */
    public final DetailedStatus detailedStatus() {
        return DetailedStatus.fromValue(detailedStatus);
    }

    /**
     * <p>
     * The detailed status of the resource or stack. If <code>CONFIGURATION_COMPLETE</code> is present, the resource or
     * resource configuration phase has completed and the stabilization of the resources is in progress. The stack sets
     * <code>CONFIGURATION_COMPLETE</code> when all of the resources in the stack have reached that event. For more
     * information, see <a href=
     * "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stack-resource-configuration-complete.html"
     * >Understand CloudFormation stack creation events</a> in the <i>CloudFormation User Guide</i>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #detailedStatus}
     * will return {@link DetailedStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #detailedStatusAsString}.
     * </p>
     * 
     * @return The detailed status of the resource or stack. If <code>CONFIGURATION_COMPLETE</code> is present, the
     *         resource or resource configuration phase has completed and the stabilization of the resources is in
     *         progress. The stack sets <code>CONFIGURATION_COMPLETE</code> when all of the resources in the stack have
     *         reached that event. For more information, see <a href=
     *         "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stack-resource-configuration-complete.html"
     *         >Understand CloudFormation stack creation events</a> in the <i>CloudFormation User Guide</i>.
     * @see DetailedStatus
     */
    public final String detailedStatusAsString() {
        return detailedStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(stackId());
        hashCode = 31 * hashCode + Objects.hashCode(stackName());
        hashCode = 31 * hashCode + Objects.hashCode(changeSetId());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(hasParameters() ? parameters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(deletionTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedTime());
        hashCode = 31 * hashCode + Objects.hashCode(rollbackConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(stackStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(stackStatusReason());
        hashCode = 31 * hashCode + Objects.hashCode(disableRollback());
        hashCode = 31 * hashCode + Objects.hashCode(hasNotificationARNs() ? notificationARNs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(timeoutInMinutes());
        hashCode = 31 * hashCode + Objects.hashCode(hasCapabilities() ? capabilitiesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasOutputs() ? outputs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(roleARN());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(enableTerminationProtection());
        hashCode = 31 * hashCode + Objects.hashCode(parentId());
        hashCode = 31 * hashCode + Objects.hashCode(rootId());
        hashCode = 31 * hashCode + Objects.hashCode(driftInformation());
        hashCode = 31 * hashCode + Objects.hashCode(retainExceptOnCreate());
        hashCode = 31 * hashCode + Objects.hashCode(deletionModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(detailedStatusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Stack)) {
            return false;
        }
        Stack other = (Stack) obj;
        return Objects.equals(stackId(), other.stackId()) && Objects.equals(stackName(), other.stackName())
                && Objects.equals(changeSetId(), other.changeSetId()) && Objects.equals(description(), other.description())
                && hasParameters() == other.hasParameters() && Objects.equals(parameters(), other.parameters())
                && Objects.equals(creationTime(), other.creationTime()) && Objects.equals(deletionTime(), other.deletionTime())
                && Objects.equals(lastUpdatedTime(), other.lastUpdatedTime())
                && Objects.equals(rollbackConfiguration(), other.rollbackConfiguration())
                && Objects.equals(stackStatusAsString(), other.stackStatusAsString())
                && Objects.equals(stackStatusReason(), other.stackStatusReason())
                && Objects.equals(disableRollback(), other.disableRollback())
                && hasNotificationARNs() == other.hasNotificationARNs()
                && Objects.equals(notificationARNs(), other.notificationARNs())
                && Objects.equals(timeoutInMinutes(), other.timeoutInMinutes()) && hasCapabilities() == other.hasCapabilities()
                && Objects.equals(capabilitiesAsStrings(), other.capabilitiesAsStrings()) && hasOutputs() == other.hasOutputs()
                && Objects.equals(outputs(), other.outputs()) && Objects.equals(roleARN(), other.roleARN())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags())
                && Objects.equals(enableTerminationProtection(), other.enableTerminationProtection())
                && Objects.equals(parentId(), other.parentId()) && Objects.equals(rootId(), other.rootId())
                && Objects.equals(driftInformation(), other.driftInformation())
                && Objects.equals(retainExceptOnCreate(), other.retainExceptOnCreate())
                && Objects.equals(deletionModeAsString(), other.deletionModeAsString())
                && Objects.equals(detailedStatusAsString(), other.detailedStatusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Stack").add("StackId", stackId()).add("StackName", stackName())
                .add("ChangeSetId", changeSetId()).add("Description", description())
                .add("Parameters", hasParameters() ? parameters() : null).add("CreationTime", creationTime())
                .add("DeletionTime", deletionTime()).add("LastUpdatedTime", lastUpdatedTime())
                .add("RollbackConfiguration", rollbackConfiguration()).add("StackStatus", stackStatusAsString())
                .add("StackStatusReason", stackStatusReason()).add("DisableRollback", disableRollback())
                .add("NotificationARNs", hasNotificationARNs() ? notificationARNs() : null)
                .add("TimeoutInMinutes", timeoutInMinutes())
                .add("Capabilities", hasCapabilities() ? capabilitiesAsStrings() : null)
                .add("Outputs", hasOutputs() ? outputs() : null).add("RoleARN", roleARN()).add("Tags", hasTags() ? tags() : null)
                .add("EnableTerminationProtection", enableTerminationProtection()).add("ParentId", parentId())
                .add("RootId", rootId()).add("DriftInformation", driftInformation())
                .add("RetainExceptOnCreate", retainExceptOnCreate()).add("DeletionMode", deletionModeAsString())
                .add("DetailedStatus", detailedStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StackId":
            return Optional.ofNullable(clazz.cast(stackId()));
        case "StackName":
            return Optional.ofNullable(clazz.cast(stackName()));
        case "ChangeSetId":
            return Optional.ofNullable(clazz.cast(changeSetId()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "Parameters":
            return Optional.ofNullable(clazz.cast(parameters()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "DeletionTime":
            return Optional.ofNullable(clazz.cast(deletionTime()));
        case "LastUpdatedTime":
            return Optional.ofNullable(clazz.cast(lastUpdatedTime()));
        case "RollbackConfiguration":
            return Optional.ofNullable(clazz.cast(rollbackConfiguration()));
        case "StackStatus":
            return Optional.ofNullable(clazz.cast(stackStatusAsString()));
        case "StackStatusReason":
            return Optional.ofNullable(clazz.cast(stackStatusReason()));
        case "DisableRollback":
            return Optional.ofNullable(clazz.cast(disableRollback()));
        case "NotificationARNs":
            return Optional.ofNullable(clazz.cast(notificationARNs()));
        case "TimeoutInMinutes":
            return Optional.ofNullable(clazz.cast(timeoutInMinutes()));
        case "Capabilities":
            return Optional.ofNullable(clazz.cast(capabilitiesAsStrings()));
        case "Outputs":
            return Optional.ofNullable(clazz.cast(outputs()));
        case "RoleARN":
            return Optional.ofNullable(clazz.cast(roleARN()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "EnableTerminationProtection":
            return Optional.ofNullable(clazz.cast(enableTerminationProtection()));
        case "ParentId":
            return Optional.ofNullable(clazz.cast(parentId()));
        case "RootId":
            return Optional.ofNullable(clazz.cast(rootId()));
        case "DriftInformation":
            return Optional.ofNullable(clazz.cast(driftInformation()));
        case "RetainExceptOnCreate":
            return Optional.ofNullable(clazz.cast(retainExceptOnCreate()));
        case "DeletionMode":
            return Optional.ofNullable(clazz.cast(deletionModeAsString()));
        case "DetailedStatus":
            return Optional.ofNullable(clazz.cast(detailedStatusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("StackId", STACK_ID_FIELD);
        map.put("StackName", STACK_NAME_FIELD);
        map.put("ChangeSetId", CHANGE_SET_ID_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("Parameters", PARAMETERS_FIELD);
        map.put("CreationTime", CREATION_TIME_FIELD);
        map.put("DeletionTime", DELETION_TIME_FIELD);
        map.put("LastUpdatedTime", LAST_UPDATED_TIME_FIELD);
        map.put("RollbackConfiguration", ROLLBACK_CONFIGURATION_FIELD);
        map.put("StackStatus", STACK_STATUS_FIELD);
        map.put("StackStatusReason", STACK_STATUS_REASON_FIELD);
        map.put("DisableRollback", DISABLE_ROLLBACK_FIELD);
        map.put("NotificationARNs", NOTIFICATION_AR_NS_FIELD);
        map.put("TimeoutInMinutes", TIMEOUT_IN_MINUTES_FIELD);
        map.put("Capabilities", CAPABILITIES_FIELD);
        map.put("Outputs", OUTPUTS_FIELD);
        map.put("RoleARN", ROLE_ARN_FIELD);
        map.put("Tags", TAGS_FIELD);
        map.put("EnableTerminationProtection", ENABLE_TERMINATION_PROTECTION_FIELD);
        map.put("ParentId", PARENT_ID_FIELD);
        map.put("RootId", ROOT_ID_FIELD);
        map.put("DriftInformation", DRIFT_INFORMATION_FIELD);
        map.put("RetainExceptOnCreate", RETAIN_EXCEPT_ON_CREATE_FIELD);
        map.put("DeletionMode", DELETION_MODE_FIELD);
        map.put("DetailedStatus", DETAILED_STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Stack, T> g) {
        return obj -> g.apply((Stack) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Stack> {
        /**
         * <p>
         * Unique identifier of the stack.
         * </p>
         * 
         * @param stackId
         *        Unique identifier of the stack.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stackId(String stackId);

        /**
         * <p>
         * The name associated with the stack.
         * </p>
         * 
         * @param stackName
         *        The name associated with the stack.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stackName(String stackName);

        /**
         * <p>
         * The unique ID of the change set.
         * </p>
         * 
         * @param changeSetId
         *        The unique ID of the change set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder changeSetId(String changeSetId);

        /**
         * <p>
         * A user-defined description associated with the stack.
         * </p>
         * 
         * @param description
         *        A user-defined description associated with the stack.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * A list of <code>Parameter</code> structures.
         * </p>
         * 
         * @param parameters
         *        A list of <code>Parameter</code> structures.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameters(Collection<Parameter> parameters);

        /**
         * <p>
         * A list of <code>Parameter</code> structures.
         * </p>
         * 
         * @param parameters
         *        A list of <code>Parameter</code> structures.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameters(Parameter... parameters);

        /**
         * <p>
         * A list of <code>Parameter</code> structures.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.cloudformation.model.Parameter.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.cloudformation.model.Parameter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.cloudformation.model.Parameter.Builder#build()} is called immediately
         * and its result is passed to {@link #parameters(List<Parameter>)}.
         * 
         * @param parameters
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.cloudformation.model.Parameter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #parameters(java.util.Collection<Parameter>)
         */
        Builder parameters(Consumer<Parameter.Builder>... parameters);

        /**
         * <p>
         * The time at which the stack was created.
         * </p>
         * 
         * @param creationTime
         *        The time at which the stack was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * The time the stack was deleted.
         * </p>
         * 
         * @param deletionTime
         *        The time the stack was deleted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deletionTime(Instant deletionTime);

        /**
         * <p>
         * The time the stack was last updated. This field will only be returned if the stack has been updated at least
         * once.
         * </p>
         * 
         * @param lastUpdatedTime
         *        The time the stack was last updated. This field will only be returned if the stack has been updated at
         *        least once.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedTime(Instant lastUpdatedTime);

        /**
         * <p>
         * The rollback triggers for CloudFormation to monitor during stack creation and updating operations, and for
         * the specified monitoring period afterwards.
         * </p>
         * 
         * @param rollbackConfiguration
         *        The rollback triggers for CloudFormation to monitor during stack creation and updating operations, and
         *        for the specified monitoring period afterwards.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rollbackConfiguration(RollbackConfiguration rollbackConfiguration);

        /**
         * <p>
         * The rollback triggers for CloudFormation to monitor during stack creation and updating operations, and for
         * the specified monitoring period afterwards.
         * </p>
         * This is a convenience method that creates an instance of the {@link RollbackConfiguration.Builder} avoiding
         * the need to create one manually via {@link RollbackConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RollbackConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #rollbackConfiguration(RollbackConfiguration)}.
         * 
         * @param rollbackConfiguration
         *        a consumer that will call methods on {@link RollbackConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #rollbackConfiguration(RollbackConfiguration)
         */
        default Builder rollbackConfiguration(Consumer<RollbackConfiguration.Builder> rollbackConfiguration) {
            return rollbackConfiguration(RollbackConfiguration.builder().applyMutation(rollbackConfiguration).build());
        }

        /**
         * <p>
         * Current status of the stack.
         * </p>
         * 
         * @param stackStatus
         *        Current status of the stack.
         * @see StackStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StackStatus
         */
        Builder stackStatus(String stackStatus);

        /**
         * <p>
         * Current status of the stack.
         * </p>
         * 
         * @param stackStatus
         *        Current status of the stack.
         * @see StackStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StackStatus
         */
        Builder stackStatus(StackStatus stackStatus);

        /**
         * <p>
         * Success/failure message associated with the stack status.
         * </p>
         * 
         * @param stackStatusReason
         *        Success/failure message associated with the stack status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stackStatusReason(String stackStatusReason);

        /**
         * <p>
         * Boolean to enable or disable rollback on stack creation failures:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>true</code>: disable rollback.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>false</code>: enable rollback.
         * </p>
         * </li>
         * </ul>
         * 
         * @param disableRollback
         *        Boolean to enable or disable rollback on stack creation failures:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>true</code>: disable rollback.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>false</code>: enable rollback.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder disableRollback(Boolean disableRollback);

        /**
         * <p>
         * Amazon SNS topic Amazon Resource Names (ARNs) to which stack related events are published.
         * </p>
         * 
         * @param notificationARNs
         *        Amazon SNS topic Amazon Resource Names (ARNs) to which stack related events are published.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notificationARNs(Collection<String> notificationARNs);

        /**
         * <p>
         * Amazon SNS topic Amazon Resource Names (ARNs) to which stack related events are published.
         * </p>
         * 
         * @param notificationARNs
         *        Amazon SNS topic Amazon Resource Names (ARNs) to which stack related events are published.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notificationARNs(String... notificationARNs);

        /**
         * <p>
         * The amount of time within which stack creation should complete.
         * </p>
         * 
         * @param timeoutInMinutes
         *        The amount of time within which stack creation should complete.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timeoutInMinutes(Integer timeoutInMinutes);

        /**
         * <p>
         * The capabilities allowed in the stack.
         * </p>
         * 
         * @param capabilities
         *        The capabilities allowed in the stack.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capabilitiesWithStrings(Collection<String> capabilities);

        /**
         * <p>
         * The capabilities allowed in the stack.
         * </p>
         * 
         * @param capabilities
         *        The capabilities allowed in the stack.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capabilitiesWithStrings(String... capabilities);

        /**
         * <p>
         * The capabilities allowed in the stack.
         * </p>
         * 
         * @param capabilities
         *        The capabilities allowed in the stack.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capabilities(Collection<Capability> capabilities);

        /**
         * <p>
         * The capabilities allowed in the stack.
         * </p>
         * 
         * @param capabilities
         *        The capabilities allowed in the stack.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capabilities(Capability... capabilities);

        /**
         * <p>
         * A list of output structures.
         * </p>
         * 
         * @param outputs
         *        A list of output structures.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputs(Collection<Output> outputs);

        /**
         * <p>
         * A list of output structures.
         * </p>
         * 
         * @param outputs
         *        A list of output structures.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputs(Output... outputs);

        /**
         * <p>
         * A list of output structures.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.cloudformation.model.Output.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.cloudformation.model.Output#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.cloudformation.model.Output.Builder#build()} is called immediately and
         * its result is passed to {@link #outputs(List<Output>)}.
         * 
         * @param outputs
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.cloudformation.model.Output.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #outputs(java.util.Collection<Output>)
         */
        Builder outputs(Consumer<Output.Builder>... outputs);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of an IAM role that's associated with the stack. During a stack operation,
         * CloudFormation uses this role's credentials to make calls on your behalf.
         * </p>
         * 
         * @param roleARN
         *        The Amazon Resource Name (ARN) of an IAM role that's associated with the stack. During a stack
         *        operation, CloudFormation uses this role's credentials to make calls on your behalf.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleARN(String roleARN);

        /**
         * <p>
         * A list of <code>Tag</code>s that specify information about the stack.
         * </p>
         * 
         * @param tags
         *        A list of <code>Tag</code>s that specify information about the stack.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * A list of <code>Tag</code>s that specify information about the stack.
         * </p>
         * 
         * @param tags
         *        A list of <code>Tag</code>s that specify information about the stack.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * A list of <code>Tag</code>s that specify information about the stack.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.cloudformation.model.Tag.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.cloudformation.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.cloudformation.model.Tag.Builder#build()} is called immediately and
         * its result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.cloudformation.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        /**
         * <p>
         * Whether termination protection is enabled for the stack.
         * </p>
         * <p>
         * For <a
         * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-nested-stacks.html">nested
         * stacks</a>, termination protection is set on the root stack and can't be changed directly on the nested
         * stack. For more information, see <a
         * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-protect-stacks.html">Protect a
         * CloudFormation stack from being deleted</a> in the <i>CloudFormation User Guide</i>.
         * </p>
         * 
         * @param enableTerminationProtection
         *        Whether termination protection is enabled for the stack.</p>
         *        <p>
         *        For <a
         *        href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-nested-stacks.html"
         *        >nested stacks</a>, termination protection is set on the root stack and can't be changed directly on
         *        the nested stack. For more information, see <a
         *        href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-protect-stacks.html"
         *        >Protect a CloudFormation stack from being deleted</a> in the <i>CloudFormation User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enableTerminationProtection(Boolean enableTerminationProtection);

        /**
         * <p>
         * For nested stacks--stacks created as resources for another stack--the stack ID of the direct parent of this
         * stack. For the first level of nested stacks, the root stack is also the parent stack.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-nested-stacks.html">Embed
         * stacks within other stacks using nested stacks</a> in the <i>CloudFormation User Guide</i>.
         * </p>
         * 
         * @param parentId
         *        For nested stacks--stacks created as resources for another stack--the stack ID of the direct parent of
         *        this stack. For the first level of nested stacks, the root stack is also the parent stack.</p>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-nested-stacks.html"
         *        >Embed stacks within other stacks using nested stacks</a> in the <i>CloudFormation User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parentId(String parentId);

        /**
         * <p>
         * For nested stacks--stacks created as resources for another stack--the stack ID of the top-level stack to
         * which the nested stack ultimately belongs.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-nested-stacks.html">Embed
         * stacks within other stacks using nested stacks</a> in the <i>CloudFormation User Guide</i>.
         * </p>
         * 
         * @param rootId
         *        For nested stacks--stacks created as resources for another stack--the stack ID of the top-level stack
         *        to which the nested stack ultimately belongs.</p>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-nested-stacks.html"
         *        >Embed stacks within other stacks using nested stacks</a> in the <i>CloudFormation User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rootId(String rootId);

        /**
         * <p>
         * Information about whether a stack's actual configuration differs, or has <i>drifted</i>, from its expected
         * configuration, as defined in the stack template and any values specified as template parameters. For more
         * information, see <a
         * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-stack-drift.html">Detect
         * unmanaged configuration changes to stacks and resources with drift detection</a>.
         * </p>
         * 
         * @param driftInformation
         *        Information about whether a stack's actual configuration differs, or has <i>drifted</i>, from its
         *        expected configuration, as defined in the stack template and any values specified as template
         *        parameters. For more information, see <a
         *        href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-stack-drift.html"
         *        >Detect unmanaged configuration changes to stacks and resources with drift detection</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder driftInformation(StackDriftInformation driftInformation);

        /**
         * <p>
         * Information about whether a stack's actual configuration differs, or has <i>drifted</i>, from its expected
         * configuration, as defined in the stack template and any values specified as template parameters. For more
         * information, see <a
         * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-stack-drift.html">Detect
         * unmanaged configuration changes to stacks and resources with drift detection</a>.
         * </p>
         * This is a convenience method that creates an instance of the {@link StackDriftInformation.Builder} avoiding
         * the need to create one manually via {@link StackDriftInformation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link StackDriftInformation.Builder#build()} is called immediately and
         * its result is passed to {@link #driftInformation(StackDriftInformation)}.
         * 
         * @param driftInformation
         *        a consumer that will call methods on {@link StackDriftInformation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #driftInformation(StackDriftInformation)
         */
        default Builder driftInformation(Consumer<StackDriftInformation.Builder> driftInformation) {
            return driftInformation(StackDriftInformation.builder().applyMutation(driftInformation).build());
        }

        /**
         * <p>
         * When set to <code>true</code>, newly created resources are deleted when the operation rolls back. This
         * includes newly created resources marked with a deletion policy of <code>Retain</code>.
         * </p>
         * <p>
         * Default: <code>false</code>
         * </p>
         * 
         * @param retainExceptOnCreate
         *        When set to <code>true</code>, newly created resources are deleted when the operation rolls back. This
         *        includes newly created resources marked with a deletion policy of <code>Retain</code>.</p>
         *        <p>
         *        Default: <code>false</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder retainExceptOnCreate(Boolean retainExceptOnCreate);

        /**
         * <p>
         * Specifies the deletion mode for the stack. Possible values are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>STANDARD</code> - Use the standard behavior. Specifying this value is the same as not specifying this
         * parameter.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>FORCE_DELETE_STACK</code> - Delete the stack if it's stuck in a <code>DELETE_FAILED</code> state due to
         * resource deletion failure.
         * </p>
         * </li>
         * </ul>
         * 
         * @param deletionMode
         *        Specifies the deletion mode for the stack. Possible values are:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>STANDARD</code> - Use the standard behavior. Specifying this value is the same as not specifying
         *        this parameter.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>FORCE_DELETE_STACK</code> - Delete the stack if it's stuck in a <code>DELETE_FAILED</code> state
         *        due to resource deletion failure.
         *        </p>
         *        </li>
         * @see DeletionMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeletionMode
         */
        Builder deletionMode(String deletionMode);

        /**
         * <p>
         * Specifies the deletion mode for the stack. Possible values are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>STANDARD</code> - Use the standard behavior. Specifying this value is the same as not specifying this
         * parameter.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>FORCE_DELETE_STACK</code> - Delete the stack if it's stuck in a <code>DELETE_FAILED</code> state due to
         * resource deletion failure.
         * </p>
         * </li>
         * </ul>
         * 
         * @param deletionMode
         *        Specifies the deletion mode for the stack. Possible values are:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>STANDARD</code> - Use the standard behavior. Specifying this value is the same as not specifying
         *        this parameter.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>FORCE_DELETE_STACK</code> - Delete the stack if it's stuck in a <code>DELETE_FAILED</code> state
         *        due to resource deletion failure.
         *        </p>
         *        </li>
         * @see DeletionMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeletionMode
         */
        Builder deletionMode(DeletionMode deletionMode);

        /**
         * <p>
         * The detailed status of the resource or stack. If <code>CONFIGURATION_COMPLETE</code> is present, the resource
         * or resource configuration phase has completed and the stabilization of the resources is in progress. The
         * stack sets <code>CONFIGURATION_COMPLETE</code> when all of the resources in the stack have reached that
         * event. For more information, see <a href=
         * "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stack-resource-configuration-complete.html"
         * >Understand CloudFormation stack creation events</a> in the <i>CloudFormation User Guide</i>.
         * </p>
         * 
         * @param detailedStatus
         *        The detailed status of the resource or stack. If <code>CONFIGURATION_COMPLETE</code> is present, the
         *        resource or resource configuration phase has completed and the stabilization of the resources is in
         *        progress. The stack sets <code>CONFIGURATION_COMPLETE</code> when all of the resources in the stack
         *        have reached that event. For more information, see <a href=
         *        "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stack-resource-configuration-complete.html"
         *        >Understand CloudFormation stack creation events</a> in the <i>CloudFormation User Guide</i>.
         * @see DetailedStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DetailedStatus
         */
        Builder detailedStatus(String detailedStatus);

        /**
         * <p>
         * The detailed status of the resource or stack. If <code>CONFIGURATION_COMPLETE</code> is present, the resource
         * or resource configuration phase has completed and the stabilization of the resources is in progress. The
         * stack sets <code>CONFIGURATION_COMPLETE</code> when all of the resources in the stack have reached that
         * event. For more information, see <a href=
         * "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stack-resource-configuration-complete.html"
         * >Understand CloudFormation stack creation events</a> in the <i>CloudFormation User Guide</i>.
         * </p>
         * 
         * @param detailedStatus
         *        The detailed status of the resource or stack. If <code>CONFIGURATION_COMPLETE</code> is present, the
         *        resource or resource configuration phase has completed and the stabilization of the resources is in
         *        progress. The stack sets <code>CONFIGURATION_COMPLETE</code> when all of the resources in the stack
         *        have reached that event. For more information, see <a href=
         *        "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stack-resource-configuration-complete.html"
         *        >Understand CloudFormation stack creation events</a> in the <i>CloudFormation User Guide</i>.
         * @see DetailedStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DetailedStatus
         */
        Builder detailedStatus(DetailedStatus detailedStatus);
    }

    static final class BuilderImpl implements Builder {
        private String stackId;

        private String stackName;

        private String changeSetId;

        private String description;

        private List<Parameter> parameters = DefaultSdkAutoConstructList.getInstance();

        private Instant creationTime;

        private Instant deletionTime;

        private Instant lastUpdatedTime;

        private RollbackConfiguration rollbackConfiguration;

        private String stackStatus;

        private String stackStatusReason;

        private Boolean disableRollback;

        private List<String> notificationARNs = DefaultSdkAutoConstructList.getInstance();

        private Integer timeoutInMinutes;

        private List<String> capabilities = DefaultSdkAutoConstructList.getInstance();

        private List<Output> outputs = DefaultSdkAutoConstructList.getInstance();

        private String roleARN;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private Boolean enableTerminationProtection;

        private String parentId;

        private String rootId;

        private StackDriftInformation driftInformation;

        private Boolean retainExceptOnCreate;

        private String deletionMode;

        private String detailedStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(Stack model) {
            stackId(model.stackId);
            stackName(model.stackName);
            changeSetId(model.changeSetId);
            description(model.description);
            parameters(model.parameters);
            creationTime(model.creationTime);
            deletionTime(model.deletionTime);
            lastUpdatedTime(model.lastUpdatedTime);
            rollbackConfiguration(model.rollbackConfiguration);
            stackStatus(model.stackStatus);
            stackStatusReason(model.stackStatusReason);
            disableRollback(model.disableRollback);
            notificationARNs(model.notificationARNs);
            timeoutInMinutes(model.timeoutInMinutes);
            capabilitiesWithStrings(model.capabilities);
            outputs(model.outputs);
            roleARN(model.roleARN);
            tags(model.tags);
            enableTerminationProtection(model.enableTerminationProtection);
            parentId(model.parentId);
            rootId(model.rootId);
            driftInformation(model.driftInformation);
            retainExceptOnCreate(model.retainExceptOnCreate);
            deletionMode(model.deletionMode);
            detailedStatus(model.detailedStatus);
        }

        public final String getStackId() {
            return stackId;
        }

        public final void setStackId(String stackId) {
            this.stackId = stackId;
        }

        @Override
        public final Builder stackId(String stackId) {
            this.stackId = stackId;
            return this;
        }

        public final String getStackName() {
            return stackName;
        }

        public final void setStackName(String stackName) {
            this.stackName = stackName;
        }

        @Override
        public final Builder stackName(String stackName) {
            this.stackName = stackName;
            return this;
        }

        public final String getChangeSetId() {
            return changeSetId;
        }

        public final void setChangeSetId(String changeSetId) {
            this.changeSetId = changeSetId;
        }

        @Override
        public final Builder changeSetId(String changeSetId) {
            this.changeSetId = changeSetId;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final List<Parameter.Builder> getParameters() {
            List<Parameter.Builder> result = ParametersCopier.copyToBuilder(this.parameters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setParameters(Collection<Parameter.BuilderImpl> parameters) {
            this.parameters = ParametersCopier.copyFromBuilder(parameters);
        }

        @Override
        public final Builder parameters(Collection<Parameter> parameters) {
            this.parameters = ParametersCopier.copy(parameters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameters(Parameter... parameters) {
            parameters(Arrays.asList(parameters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameters(Consumer<Parameter.Builder>... parameters) {
            parameters(Stream.of(parameters).map(c -> Parameter.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Instant getDeletionTime() {
            return deletionTime;
        }

        public final void setDeletionTime(Instant deletionTime) {
            this.deletionTime = deletionTime;
        }

        @Override
        public final Builder deletionTime(Instant deletionTime) {
            this.deletionTime = deletionTime;
            return this;
        }

        public final Instant getLastUpdatedTime() {
            return lastUpdatedTime;
        }

        public final void setLastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
        }

        @Override
        public final Builder lastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
            return this;
        }

        public final RollbackConfiguration.Builder getRollbackConfiguration() {
            return rollbackConfiguration != null ? rollbackConfiguration.toBuilder() : null;
        }

        public final void setRollbackConfiguration(RollbackConfiguration.BuilderImpl rollbackConfiguration) {
            this.rollbackConfiguration = rollbackConfiguration != null ? rollbackConfiguration.build() : null;
        }

        @Override
        public final Builder rollbackConfiguration(RollbackConfiguration rollbackConfiguration) {
            this.rollbackConfiguration = rollbackConfiguration;
            return this;
        }

        public final String getStackStatus() {
            return stackStatus;
        }

        public final void setStackStatus(String stackStatus) {
            this.stackStatus = stackStatus;
        }

        @Override
        public final Builder stackStatus(String stackStatus) {
            this.stackStatus = stackStatus;
            return this;
        }

        @Override
        public final Builder stackStatus(StackStatus stackStatus) {
            this.stackStatus(stackStatus == null ? null : stackStatus.toString());
            return this;
        }

        public final String getStackStatusReason() {
            return stackStatusReason;
        }

        public final void setStackStatusReason(String stackStatusReason) {
            this.stackStatusReason = stackStatusReason;
        }

        @Override
        public final Builder stackStatusReason(String stackStatusReason) {
            this.stackStatusReason = stackStatusReason;
            return this;
        }

        public final Boolean getDisableRollback() {
            return disableRollback;
        }

        public final void setDisableRollback(Boolean disableRollback) {
            this.disableRollback = disableRollback;
        }

        @Override
        public final Builder disableRollback(Boolean disableRollback) {
            this.disableRollback = disableRollback;
            return this;
        }

        public final Collection<String> getNotificationARNs() {
            if (notificationARNs instanceof SdkAutoConstructList) {
                return null;
            }
            return notificationARNs;
        }

        public final void setNotificationARNs(Collection<String> notificationARNs) {
            this.notificationARNs = NotificationARNsCopier.copy(notificationARNs);
        }

        @Override
        public final Builder notificationARNs(Collection<String> notificationARNs) {
            this.notificationARNs = NotificationARNsCopier.copy(notificationARNs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder notificationARNs(String... notificationARNs) {
            notificationARNs(Arrays.asList(notificationARNs));
            return this;
        }

        public final Integer getTimeoutInMinutes() {
            return timeoutInMinutes;
        }

        public final void setTimeoutInMinutes(Integer timeoutInMinutes) {
            this.timeoutInMinutes = timeoutInMinutes;
        }

        @Override
        public final Builder timeoutInMinutes(Integer timeoutInMinutes) {
            this.timeoutInMinutes = timeoutInMinutes;
            return this;
        }

        public final Collection<String> getCapabilities() {
            if (capabilities instanceof SdkAutoConstructList) {
                return null;
            }
            return capabilities;
        }

        public final void setCapabilities(Collection<String> capabilities) {
            this.capabilities = CapabilitiesCopier.copy(capabilities);
        }

        @Override
        public final Builder capabilitiesWithStrings(Collection<String> capabilities) {
            this.capabilities = CapabilitiesCopier.copy(capabilities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder capabilitiesWithStrings(String... capabilities) {
            capabilitiesWithStrings(Arrays.asList(capabilities));
            return this;
        }

        @Override
        public final Builder capabilities(Collection<Capability> capabilities) {
            this.capabilities = CapabilitiesCopier.copyEnumToString(capabilities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder capabilities(Capability... capabilities) {
            capabilities(Arrays.asList(capabilities));
            return this;
        }

        public final List<Output.Builder> getOutputs() {
            List<Output.Builder> result = OutputsCopier.copyToBuilder(this.outputs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOutputs(Collection<Output.BuilderImpl> outputs) {
            this.outputs = OutputsCopier.copyFromBuilder(outputs);
        }

        @Override
        public final Builder outputs(Collection<Output> outputs) {
            this.outputs = OutputsCopier.copy(outputs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outputs(Output... outputs) {
            outputs(Arrays.asList(outputs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outputs(Consumer<Output.Builder>... outputs) {
            outputs(Stream.of(outputs).map(c -> Output.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getRoleARN() {
            return roleARN;
        }

        public final void setRoleARN(String roleARN) {
            this.roleARN = roleARN;
        }

        @Override
        public final Builder roleARN(String roleARN) {
            this.roleARN = roleARN;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagsCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagsCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Boolean getEnableTerminationProtection() {
            return enableTerminationProtection;
        }

        public final void setEnableTerminationProtection(Boolean enableTerminationProtection) {
            this.enableTerminationProtection = enableTerminationProtection;
        }

        @Override
        public final Builder enableTerminationProtection(Boolean enableTerminationProtection) {
            this.enableTerminationProtection = enableTerminationProtection;
            return this;
        }

        public final String getParentId() {
            return parentId;
        }

        public final void setParentId(String parentId) {
            this.parentId = parentId;
        }

        @Override
        public final Builder parentId(String parentId) {
            this.parentId = parentId;
            return this;
        }

        public final String getRootId() {
            return rootId;
        }

        public final void setRootId(String rootId) {
            this.rootId = rootId;
        }

        @Override
        public final Builder rootId(String rootId) {
            this.rootId = rootId;
            return this;
        }

        public final StackDriftInformation.Builder getDriftInformation() {
            return driftInformation != null ? driftInformation.toBuilder() : null;
        }

        public final void setDriftInformation(StackDriftInformation.BuilderImpl driftInformation) {
            this.driftInformation = driftInformation != null ? driftInformation.build() : null;
        }

        @Override
        public final Builder driftInformation(StackDriftInformation driftInformation) {
            this.driftInformation = driftInformation;
            return this;
        }

        public final Boolean getRetainExceptOnCreate() {
            return retainExceptOnCreate;
        }

        public final void setRetainExceptOnCreate(Boolean retainExceptOnCreate) {
            this.retainExceptOnCreate = retainExceptOnCreate;
        }

        @Override
        public final Builder retainExceptOnCreate(Boolean retainExceptOnCreate) {
            this.retainExceptOnCreate = retainExceptOnCreate;
            return this;
        }

        public final String getDeletionMode() {
            return deletionMode;
        }

        public final void setDeletionMode(String deletionMode) {
            this.deletionMode = deletionMode;
        }

        @Override
        public final Builder deletionMode(String deletionMode) {
            this.deletionMode = deletionMode;
            return this;
        }

        @Override
        public final Builder deletionMode(DeletionMode deletionMode) {
            this.deletionMode(deletionMode == null ? null : deletionMode.toString());
            return this;
        }

        public final String getDetailedStatus() {
            return detailedStatus;
        }

        public final void setDetailedStatus(String detailedStatus) {
            this.detailedStatus = detailedStatus;
        }

        @Override
        public final Builder detailedStatus(String detailedStatus) {
            this.detailedStatus = detailedStatus;
            return this;
        }

        @Override
        public final Builder detailedStatus(DetailedStatus detailedStatus) {
            this.detailedStatus(detailedStatus == null ? null : detailedStatus.toString());
            return this;
        }

        @Override
        public Stack build() {
            return new Stack(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
