/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudformation.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies <code>RESOURCE</code> type target details for activated hooks.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ChangeSetHookResourceTargetDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<ChangeSetHookResourceTargetDetails.Builder, ChangeSetHookResourceTargetDetails> {
    private static final SdkField<String> LOGICAL_RESOURCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LogicalResourceId").getter(getter(ChangeSetHookResourceTargetDetails::logicalResourceId))
            .setter(setter(Builder::logicalResourceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogicalResourceId").build()).build();

    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceType").getter(getter(ChangeSetHookResourceTargetDetails::resourceType))
            .setter(setter(Builder::resourceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceType").build()).build();

    private static final SdkField<String> RESOURCE_ACTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceAction").getter(getter(ChangeSetHookResourceTargetDetails::resourceActionAsString))
            .setter(setter(Builder::resourceAction))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceAction").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOGICAL_RESOURCE_ID_FIELD,
            RESOURCE_TYPE_FIELD, RESOURCE_ACTION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String logicalResourceId;

    private final String resourceType;

    private final String resourceAction;

    private ChangeSetHookResourceTargetDetails(BuilderImpl builder) {
        this.logicalResourceId = builder.logicalResourceId;
        this.resourceType = builder.resourceType;
        this.resourceAction = builder.resourceAction;
    }

    /**
     * <p>
     * The resource's logical ID, which is defined in the stack's template.
     * </p>
     * 
     * @return The resource's logical ID, which is defined in the stack's template.
     */
    public final String logicalResourceId() {
        return logicalResourceId;
    }

    /**
     * <p>
     * The type of CloudFormation resource, such as <code>AWS::S3::Bucket</code>.
     * </p>
     * 
     * @return The type of CloudFormation resource, such as <code>AWS::S3::Bucket</code>.
     */
    public final String resourceType() {
        return resourceType;
    }

    /**
     * <p>
     * Specifies the action of the resource.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resourceAction}
     * will return {@link ChangeAction#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #resourceActionAsString}.
     * </p>
     * 
     * @return Specifies the action of the resource.
     * @see ChangeAction
     */
    public final ChangeAction resourceAction() {
        return ChangeAction.fromValue(resourceAction);
    }

    /**
     * <p>
     * Specifies the action of the resource.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resourceAction}
     * will return {@link ChangeAction#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #resourceActionAsString}.
     * </p>
     * 
     * @return Specifies the action of the resource.
     * @see ChangeAction
     */
    public final String resourceActionAsString() {
        return resourceAction;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(logicalResourceId());
        hashCode = 31 * hashCode + Objects.hashCode(resourceType());
        hashCode = 31 * hashCode + Objects.hashCode(resourceActionAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ChangeSetHookResourceTargetDetails)) {
            return false;
        }
        ChangeSetHookResourceTargetDetails other = (ChangeSetHookResourceTargetDetails) obj;
        return Objects.equals(logicalResourceId(), other.logicalResourceId())
                && Objects.equals(resourceType(), other.resourceType())
                && Objects.equals(resourceActionAsString(), other.resourceActionAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ChangeSetHookResourceTargetDetails").add("LogicalResourceId", logicalResourceId())
                .add("ResourceType", resourceType()).add("ResourceAction", resourceActionAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LogicalResourceId":
            return Optional.ofNullable(clazz.cast(logicalResourceId()));
        case "ResourceType":
            return Optional.ofNullable(clazz.cast(resourceType()));
        case "ResourceAction":
            return Optional.ofNullable(clazz.cast(resourceActionAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("LogicalResourceId", LOGICAL_RESOURCE_ID_FIELD);
        map.put("ResourceType", RESOURCE_TYPE_FIELD);
        map.put("ResourceAction", RESOURCE_ACTION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ChangeSetHookResourceTargetDetails, T> g) {
        return obj -> g.apply((ChangeSetHookResourceTargetDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ChangeSetHookResourceTargetDetails> {
        /**
         * <p>
         * The resource's logical ID, which is defined in the stack's template.
         * </p>
         * 
         * @param logicalResourceId
         *        The resource's logical ID, which is defined in the stack's template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logicalResourceId(String logicalResourceId);

        /**
         * <p>
         * The type of CloudFormation resource, such as <code>AWS::S3::Bucket</code>.
         * </p>
         * 
         * @param resourceType
         *        The type of CloudFormation resource, such as <code>AWS::S3::Bucket</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceType(String resourceType);

        /**
         * <p>
         * Specifies the action of the resource.
         * </p>
         * 
         * @param resourceAction
         *        Specifies the action of the resource.
         * @see ChangeAction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ChangeAction
         */
        Builder resourceAction(String resourceAction);

        /**
         * <p>
         * Specifies the action of the resource.
         * </p>
         * 
         * @param resourceAction
         *        Specifies the action of the resource.
         * @see ChangeAction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ChangeAction
         */
        Builder resourceAction(ChangeAction resourceAction);
    }

    static final class BuilderImpl implements Builder {
        private String logicalResourceId;

        private String resourceType;

        private String resourceAction;

        private BuilderImpl() {
        }

        private BuilderImpl(ChangeSetHookResourceTargetDetails model) {
            logicalResourceId(model.logicalResourceId);
            resourceType(model.resourceType);
            resourceAction(model.resourceAction);
        }

        public final String getLogicalResourceId() {
            return logicalResourceId;
        }

        public final void setLogicalResourceId(String logicalResourceId) {
            this.logicalResourceId = logicalResourceId;
        }

        @Override
        public final Builder logicalResourceId(String logicalResourceId) {
            this.logicalResourceId = logicalResourceId;
            return this;
        }

        public final String getResourceType() {
            return resourceType;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        public final String getResourceAction() {
            return resourceAction;
        }

        public final void setResourceAction(String resourceAction) {
            this.resourceAction = resourceAction;
        }

        @Override
        public final Builder resourceAction(String resourceAction) {
            this.resourceAction = resourceAction;
            return this;
        }

        @Override
        public final Builder resourceAction(ChangeAction resourceAction) {
            this.resourceAction(resourceAction == null ? null : resourceAction.toString());
            return this;
        }

        @Override
        public ChangeSetHookResourceTargetDetails build() {
            return new ChangeSetHookResourceTargetDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
