/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudformation.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The input for the <a>ExecuteChangeSet</a> action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ExecuteChangeSetRequest extends CloudFormationRequest implements
        ToCopyableBuilder<ExecuteChangeSetRequest.Builder, ExecuteChangeSetRequest> {
    private static final SdkField<String> CHANGE_SET_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ChangeSetName").getter(getter(ExecuteChangeSetRequest::changeSetName))
            .setter(setter(Builder::changeSetName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChangeSetName").build()).build();

    private static final SdkField<String> STACK_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StackName").getter(getter(ExecuteChangeSetRequest::stackName)).setter(setter(Builder::stackName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StackName").build()).build();

    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ClientRequestToken").getter(getter(ExecuteChangeSetRequest::clientRequestToken))
            .setter(setter(Builder::clientRequestToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientRequestToken").build())
            .build();

    private static final SdkField<Boolean> DISABLE_ROLLBACK_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("DisableRollback").getter(getter(ExecuteChangeSetRequest::disableRollback))
            .setter(setter(Builder::disableRollback))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisableRollback").build()).build();

    private static final SdkField<Boolean> RETAIN_EXCEPT_ON_CREATE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("RetainExceptOnCreate").getter(getter(ExecuteChangeSetRequest::retainExceptOnCreate))
            .setter(setter(Builder::retainExceptOnCreate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RetainExceptOnCreate").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHANGE_SET_NAME_FIELD,
            STACK_NAME_FIELD, CLIENT_REQUEST_TOKEN_FIELD, DISABLE_ROLLBACK_FIELD, RETAIN_EXCEPT_ON_CREATE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String changeSetName;

    private final String stackName;

    private final String clientRequestToken;

    private final Boolean disableRollback;

    private final Boolean retainExceptOnCreate;

    private ExecuteChangeSetRequest(BuilderImpl builder) {
        super(builder);
        this.changeSetName = builder.changeSetName;
        this.stackName = builder.stackName;
        this.clientRequestToken = builder.clientRequestToken;
        this.disableRollback = builder.disableRollback;
        this.retainExceptOnCreate = builder.retainExceptOnCreate;
    }

    /**
     * <p>
     * The name or Amazon Resource Name (ARN) of the change set that you want use to update the specified stack.
     * </p>
     * 
     * @return The name or Amazon Resource Name (ARN) of the change set that you want use to update the specified stack.
     */
    public final String changeSetName() {
        return changeSetName;
    }

    /**
     * <p>
     * If you specified the name of a change set, specify the stack name or Amazon Resource Name (ARN) that's associated
     * with the change set you want to execute.
     * </p>
     * 
     * @return If you specified the name of a change set, specify the stack name or Amazon Resource Name (ARN) that's
     *         associated with the change set you want to execute.
     */
    public final String stackName() {
        return stackName;
    }

    /**
     * <p>
     * A unique identifier for this <code>ExecuteChangeSet</code> request. Specify this token if you plan to retry
     * requests so that CloudFormation knows that you're not attempting to execute a change set to update a stack with
     * the same name. You might retry <code>ExecuteChangeSet</code> requests to ensure that CloudFormation successfully
     * received them.
     * </p>
     * 
     * @return A unique identifier for this <code>ExecuteChangeSet</code> request. Specify this token if you plan to
     *         retry requests so that CloudFormation knows that you're not attempting to execute a change set to update
     *         a stack with the same name. You might retry <code>ExecuteChangeSet</code> requests to ensure that
     *         CloudFormation successfully received them.
     */
    public final String clientRequestToken() {
        return clientRequestToken;
    }

    /**
     * <p>
     * Preserves the state of previously provisioned resources when an operation fails. This parameter can't be
     * specified when the <code>OnStackFailure</code> parameter to the <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_CreateChangeSet.html"
     * >CreateChangeSet</a> API operation was specified.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>True</code> - if the stack creation fails, do nothing. This is equivalent to specifying
     * <code>DO_NOTHING</code> for the <code>OnStackFailure</code> parameter to the <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_CreateChangeSet.html"
     * >CreateChangeSet</a> API operation.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>False</code> - if the stack creation fails, roll back the stack. This is equivalent to specifying
     * <code>ROLLBACK</code> for the <code>OnStackFailure</code> parameter to the <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_CreateChangeSet.html"
     * >CreateChangeSet</a> API operation.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Default: <code>True</code>
     * </p>
     * 
     * @return Preserves the state of previously provisioned resources when an operation fails. This parameter can't be
     *         specified when the <code>OnStackFailure</code> parameter to the <a
     *         href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_CreateChangeSet.html"
     *         >CreateChangeSet</a> API operation was specified.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>True</code> - if the stack creation fails, do nothing. This is equivalent to specifying
     *         <code>DO_NOTHING</code> for the <code>OnStackFailure</code> parameter to the <a
     *         href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_CreateChangeSet.html"
     *         >CreateChangeSet</a> API operation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>False</code> - if the stack creation fails, roll back the stack. This is equivalent to specifying
     *         <code>ROLLBACK</code> for the <code>OnStackFailure</code> parameter to the <a
     *         href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_CreateChangeSet.html"
     *         >CreateChangeSet</a> API operation.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         Default: <code>True</code>
     */
    public final Boolean disableRollback() {
        return disableRollback;
    }

    /**
     * <p>
     * When set to <code>true</code>, newly created resources are deleted when the operation rolls back. This includes
     * newly created resources marked with a deletion policy of <code>Retain</code>.
     * </p>
     * <p>
     * Default: <code>false</code>
     * </p>
     * 
     * @return When set to <code>true</code>, newly created resources are deleted when the operation rolls back. This
     *         includes newly created resources marked with a deletion policy of <code>Retain</code>.</p>
     *         <p>
     *         Default: <code>false</code>
     */
    public final Boolean retainExceptOnCreate() {
        return retainExceptOnCreate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(changeSetName());
        hashCode = 31 * hashCode + Objects.hashCode(stackName());
        hashCode = 31 * hashCode + Objects.hashCode(clientRequestToken());
        hashCode = 31 * hashCode + Objects.hashCode(disableRollback());
        hashCode = 31 * hashCode + Objects.hashCode(retainExceptOnCreate());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExecuteChangeSetRequest)) {
            return false;
        }
        ExecuteChangeSetRequest other = (ExecuteChangeSetRequest) obj;
        return Objects.equals(changeSetName(), other.changeSetName()) && Objects.equals(stackName(), other.stackName())
                && Objects.equals(clientRequestToken(), other.clientRequestToken())
                && Objects.equals(disableRollback(), other.disableRollback())
                && Objects.equals(retainExceptOnCreate(), other.retainExceptOnCreate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ExecuteChangeSetRequest").add("ChangeSetName", changeSetName()).add("StackName", stackName())
                .add("ClientRequestToken", clientRequestToken()).add("DisableRollback", disableRollback())
                .add("RetainExceptOnCreate", retainExceptOnCreate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ChangeSetName":
            return Optional.ofNullable(clazz.cast(changeSetName()));
        case "StackName":
            return Optional.ofNullable(clazz.cast(stackName()));
        case "ClientRequestToken":
            return Optional.ofNullable(clazz.cast(clientRequestToken()));
        case "DisableRollback":
            return Optional.ofNullable(clazz.cast(disableRollback()));
        case "RetainExceptOnCreate":
            return Optional.ofNullable(clazz.cast(retainExceptOnCreate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ChangeSetName", CHANGE_SET_NAME_FIELD);
        map.put("StackName", STACK_NAME_FIELD);
        map.put("ClientRequestToken", CLIENT_REQUEST_TOKEN_FIELD);
        map.put("DisableRollback", DISABLE_ROLLBACK_FIELD);
        map.put("RetainExceptOnCreate", RETAIN_EXCEPT_ON_CREATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ExecuteChangeSetRequest, T> g) {
        return obj -> g.apply((ExecuteChangeSetRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudFormationRequest.Builder, SdkPojo, CopyableBuilder<Builder, ExecuteChangeSetRequest> {
        /**
         * <p>
         * The name or Amazon Resource Name (ARN) of the change set that you want use to update the specified stack.
         * </p>
         * 
         * @param changeSetName
         *        The name or Amazon Resource Name (ARN) of the change set that you want use to update the specified
         *        stack.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder changeSetName(String changeSetName);

        /**
         * <p>
         * If you specified the name of a change set, specify the stack name or Amazon Resource Name (ARN) that's
         * associated with the change set you want to execute.
         * </p>
         * 
         * @param stackName
         *        If you specified the name of a change set, specify the stack name or Amazon Resource Name (ARN) that's
         *        associated with the change set you want to execute.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stackName(String stackName);

        /**
         * <p>
         * A unique identifier for this <code>ExecuteChangeSet</code> request. Specify this token if you plan to retry
         * requests so that CloudFormation knows that you're not attempting to execute a change set to update a stack
         * with the same name. You might retry <code>ExecuteChangeSet</code> requests to ensure that CloudFormation
         * successfully received them.
         * </p>
         * 
         * @param clientRequestToken
         *        A unique identifier for this <code>ExecuteChangeSet</code> request. Specify this token if you plan to
         *        retry requests so that CloudFormation knows that you're not attempting to execute a change set to
         *        update a stack with the same name. You might retry <code>ExecuteChangeSet</code> requests to ensure
         *        that CloudFormation successfully received them.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientRequestToken(String clientRequestToken);

        /**
         * <p>
         * Preserves the state of previously provisioned resources when an operation fails. This parameter can't be
         * specified when the <code>OnStackFailure</code> parameter to the <a
         * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_CreateChangeSet.html"
         * >CreateChangeSet</a> API operation was specified.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>True</code> - if the stack creation fails, do nothing. This is equivalent to specifying
         * <code>DO_NOTHING</code> for the <code>OnStackFailure</code> parameter to the <a
         * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_CreateChangeSet.html"
         * >CreateChangeSet</a> API operation.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>False</code> - if the stack creation fails, roll back the stack. This is equivalent to specifying
         * <code>ROLLBACK</code> for the <code>OnStackFailure</code> parameter to the <a
         * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_CreateChangeSet.html"
         * >CreateChangeSet</a> API operation.
         * </p>
         * </li>
         * </ul>
         * <p>
         * Default: <code>True</code>
         * </p>
         * 
         * @param disableRollback
         *        Preserves the state of previously provisioned resources when an operation fails. This parameter can't
         *        be specified when the <code>OnStackFailure</code> parameter to the <a
         *        href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_CreateChangeSet.html"
         *        >CreateChangeSet</a> API operation was specified.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>True</code> - if the stack creation fails, do nothing. This is equivalent to specifying
         *        <code>DO_NOTHING</code> for the <code>OnStackFailure</code> parameter to the <a
         *        href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_CreateChangeSet.html"
         *        >CreateChangeSet</a> API operation.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>False</code> - if the stack creation fails, roll back the stack. This is equivalent to
         *        specifying <code>ROLLBACK</code> for the <code>OnStackFailure</code> parameter to the <a
         *        href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_CreateChangeSet.html"
         *        >CreateChangeSet</a> API operation.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        Default: <code>True</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder disableRollback(Boolean disableRollback);

        /**
         * <p>
         * When set to <code>true</code>, newly created resources are deleted when the operation rolls back. This
         * includes newly created resources marked with a deletion policy of <code>Retain</code>.
         * </p>
         * <p>
         * Default: <code>false</code>
         * </p>
         * 
         * @param retainExceptOnCreate
         *        When set to <code>true</code>, newly created resources are deleted when the operation rolls back. This
         *        includes newly created resources marked with a deletion policy of <code>Retain</code>.</p>
         *        <p>
         *        Default: <code>false</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder retainExceptOnCreate(Boolean retainExceptOnCreate);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CloudFormationRequest.BuilderImpl implements Builder {
        private String changeSetName;

        private String stackName;

        private String clientRequestToken;

        private Boolean disableRollback;

        private Boolean retainExceptOnCreate;

        private BuilderImpl() {
        }

        private BuilderImpl(ExecuteChangeSetRequest model) {
            super(model);
            changeSetName(model.changeSetName);
            stackName(model.stackName);
            clientRequestToken(model.clientRequestToken);
            disableRollback(model.disableRollback);
            retainExceptOnCreate(model.retainExceptOnCreate);
        }

        public final String getChangeSetName() {
            return changeSetName;
        }

        public final void setChangeSetName(String changeSetName) {
            this.changeSetName = changeSetName;
        }

        @Override
        public final Builder changeSetName(String changeSetName) {
            this.changeSetName = changeSetName;
            return this;
        }

        public final String getStackName() {
            return stackName;
        }

        public final void setStackName(String stackName) {
            this.stackName = stackName;
        }

        @Override
        public final Builder stackName(String stackName) {
            this.stackName = stackName;
            return this;
        }

        public final String getClientRequestToken() {
            return clientRequestToken;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        public final Boolean getDisableRollback() {
            return disableRollback;
        }

        public final void setDisableRollback(Boolean disableRollback) {
            this.disableRollback = disableRollback;
        }

        @Override
        public final Builder disableRollback(Boolean disableRollback) {
            this.disableRollback = disableRollback;
            return this;
        }

        public final Boolean getRetainExceptOnCreate() {
            return retainExceptOnCreate;
        }

        public final void setRetainExceptOnCreate(Boolean retainExceptOnCreate) {
            this.retainExceptOnCreate = retainExceptOnCreate;
        }

        @Override
        public final Builder retainExceptOnCreate(Boolean retainExceptOnCreate) {
            this.retainExceptOnCreate = retainExceptOnCreate;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ExecuteChangeSetRequest build() {
            return new ExecuteChangeSetRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
