/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudformation.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The input for an <a>UpdateStack</a> action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateStackRequest extends CloudFormationRequest implements
        ToCopyableBuilder<UpdateStackRequest.Builder, UpdateStackRequest> {
    private static final SdkField<String> STACK_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StackName").getter(getter(UpdateStackRequest::stackName)).setter(setter(Builder::stackName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StackName").build()).build();

    private static final SdkField<String> TEMPLATE_BODY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TemplateBody").getter(getter(UpdateStackRequest::templateBody)).setter(setter(Builder::templateBody))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TemplateBody").build()).build();

    private static final SdkField<String> TEMPLATE_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TemplateURL").getter(getter(UpdateStackRequest::templateURL)).setter(setter(Builder::templateURL))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TemplateURL").build()).build();

    private static final SdkField<Boolean> USE_PREVIOUS_TEMPLATE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("UsePreviousTemplate").getter(getter(UpdateStackRequest::usePreviousTemplate))
            .setter(setter(Builder::usePreviousTemplate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UsePreviousTemplate").build())
            .build();

    private static final SdkField<String> STACK_POLICY_DURING_UPDATE_BODY_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("StackPolicyDuringUpdateBody")
            .getter(getter(UpdateStackRequest::stackPolicyDuringUpdateBody))
            .setter(setter(Builder::stackPolicyDuringUpdateBody))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StackPolicyDuringUpdateBody")
                    .build()).build();

    private static final SdkField<String> STACK_POLICY_DURING_UPDATE_URL_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("StackPolicyDuringUpdateURL")
            .getter(getter(UpdateStackRequest::stackPolicyDuringUpdateURL))
            .setter(setter(Builder::stackPolicyDuringUpdateURL))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StackPolicyDuringUpdateURL").build())
            .build();

    private static final SdkField<List<Parameter>> PARAMETERS_FIELD = SdkField
            .<List<Parameter>> builder(MarshallingType.LIST)
            .memberName("Parameters")
            .getter(getter(UpdateStackRequest::parameters))
            .setter(setter(Builder::parameters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Parameters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Parameter> builder(MarshallingType.SDK_POJO)
                                            .constructor(Parameter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> CAPABILITIES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Capabilities")
            .getter(getter(UpdateStackRequest::capabilitiesAsStrings))
            .setter(setter(Builder::capabilitiesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Capabilities").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> RESOURCE_TYPES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ResourceTypes")
            .getter(getter(UpdateStackRequest::resourceTypes))
            .setter(setter(Builder::resourceTypes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceTypes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RoleARN").getter(getter(UpdateStackRequest::roleARN)).setter(setter(Builder::roleARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleARN").build()).build();

    private static final SdkField<RollbackConfiguration> ROLLBACK_CONFIGURATION_FIELD = SdkField
            .<RollbackConfiguration> builder(MarshallingType.SDK_POJO).memberName("RollbackConfiguration")
            .getter(getter(UpdateStackRequest::rollbackConfiguration)).setter(setter(Builder::rollbackConfiguration))
            .constructor(RollbackConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RollbackConfiguration").build())
            .build();

    private static final SdkField<String> STACK_POLICY_BODY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StackPolicyBody").getter(getter(UpdateStackRequest::stackPolicyBody))
            .setter(setter(Builder::stackPolicyBody))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StackPolicyBody").build()).build();

    private static final SdkField<String> STACK_POLICY_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StackPolicyURL").getter(getter(UpdateStackRequest::stackPolicyURL))
            .setter(setter(Builder::stackPolicyURL))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StackPolicyURL").build()).build();

    private static final SdkField<List<String>> NOTIFICATION_AR_NS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("NotificationARNs")
            .getter(getter(UpdateStackRequest::notificationARNs))
            .setter(setter(Builder::notificationARNs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NotificationARNs").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(UpdateStackRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Boolean> DISABLE_ROLLBACK_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("DisableRollback").getter(getter(UpdateStackRequest::disableRollback))
            .setter(setter(Builder::disableRollback))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisableRollback").build()).build();

    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ClientRequestToken").getter(getter(UpdateStackRequest::clientRequestToken))
            .setter(setter(Builder::clientRequestToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientRequestToken").build())
            .build();

    private static final SdkField<Boolean> RETAIN_EXCEPT_ON_CREATE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("RetainExceptOnCreate").getter(getter(UpdateStackRequest::retainExceptOnCreate))
            .setter(setter(Builder::retainExceptOnCreate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RetainExceptOnCreate").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STACK_NAME_FIELD,
            TEMPLATE_BODY_FIELD, TEMPLATE_URL_FIELD, USE_PREVIOUS_TEMPLATE_FIELD, STACK_POLICY_DURING_UPDATE_BODY_FIELD,
            STACK_POLICY_DURING_UPDATE_URL_FIELD, PARAMETERS_FIELD, CAPABILITIES_FIELD, RESOURCE_TYPES_FIELD, ROLE_ARN_FIELD,
            ROLLBACK_CONFIGURATION_FIELD, STACK_POLICY_BODY_FIELD, STACK_POLICY_URL_FIELD, NOTIFICATION_AR_NS_FIELD, TAGS_FIELD,
            DISABLE_ROLLBACK_FIELD, CLIENT_REQUEST_TOKEN_FIELD, RETAIN_EXCEPT_ON_CREATE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String stackName;

    private final String templateBody;

    private final String templateURL;

    private final Boolean usePreviousTemplate;

    private final String stackPolicyDuringUpdateBody;

    private final String stackPolicyDuringUpdateURL;

    private final List<Parameter> parameters;

    private final List<String> capabilities;

    private final List<String> resourceTypes;

    private final String roleARN;

    private final RollbackConfiguration rollbackConfiguration;

    private final String stackPolicyBody;

    private final String stackPolicyURL;

    private final List<String> notificationARNs;

    private final List<Tag> tags;

    private final Boolean disableRollback;

    private final String clientRequestToken;

    private final Boolean retainExceptOnCreate;

    private UpdateStackRequest(BuilderImpl builder) {
        super(builder);
        this.stackName = builder.stackName;
        this.templateBody = builder.templateBody;
        this.templateURL = builder.templateURL;
        this.usePreviousTemplate = builder.usePreviousTemplate;
        this.stackPolicyDuringUpdateBody = builder.stackPolicyDuringUpdateBody;
        this.stackPolicyDuringUpdateURL = builder.stackPolicyDuringUpdateURL;
        this.parameters = builder.parameters;
        this.capabilities = builder.capabilities;
        this.resourceTypes = builder.resourceTypes;
        this.roleARN = builder.roleARN;
        this.rollbackConfiguration = builder.rollbackConfiguration;
        this.stackPolicyBody = builder.stackPolicyBody;
        this.stackPolicyURL = builder.stackPolicyURL;
        this.notificationARNs = builder.notificationARNs;
        this.tags = builder.tags;
        this.disableRollback = builder.disableRollback;
        this.clientRequestToken = builder.clientRequestToken;
        this.retainExceptOnCreate = builder.retainExceptOnCreate;
    }

    /**
     * <p>
     * The name or unique stack ID of the stack to update.
     * </p>
     * 
     * @return The name or unique stack ID of the stack to update.
     */
    public final String stackName() {
        return stackName;
    }

    /**
     * <p>
     * Structure containing the template body with a minimum length of 1 byte and a maximum length of 51,200 bytes.
     * </p>
     * <p>
     * Conditional: You must specify only one of the following parameters: <code>TemplateBody</code>,
     * <code>TemplateURL</code>, or set the <code>UsePreviousTemplate</code> to <code>true</code>.
     * </p>
     * 
     * @return Structure containing the template body with a minimum length of 1 byte and a maximum length of 51,200
     *         bytes.</p>
     *         <p>
     *         Conditional: You must specify only one of the following parameters: <code>TemplateBody</code>,
     *         <code>TemplateURL</code>, or set the <code>UsePreviousTemplate</code> to <code>true</code>.
     */
    public final String templateBody() {
        return templateBody;
    }

    /**
     * <p>
     * Location of file containing the template body. The URL must point to a template that's located in an Amazon S3
     * bucket or a Systems Manager document. The location for an Amazon S3 bucket must start with <code>https://</code>.
     * </p>
     * <p>
     * Conditional: You must specify only one of the following parameters: <code>TemplateBody</code>,
     * <code>TemplateURL</code>, or set the <code>UsePreviousTemplate</code> to <code>true</code>.
     * </p>
     * 
     * @return Location of file containing the template body. The URL must point to a template that's located in an
     *         Amazon S3 bucket or a Systems Manager document. The location for an Amazon S3 bucket must start with
     *         <code>https://</code>.</p>
     *         <p>
     *         Conditional: You must specify only one of the following parameters: <code>TemplateBody</code>,
     *         <code>TemplateURL</code>, or set the <code>UsePreviousTemplate</code> to <code>true</code>.
     */
    public final String templateURL() {
        return templateURL;
    }

    /**
     * <p>
     * Reuse the existing template that is associated with the stack that you are updating.
     * </p>
     * <p>
     * Conditional: You must specify only one of the following parameters: <code>TemplateBody</code>,
     * <code>TemplateURL</code>, or set the <code>UsePreviousTemplate</code> to <code>true</code>.
     * </p>
     * 
     * @return Reuse the existing template that is associated with the stack that you are updating.</p>
     *         <p>
     *         Conditional: You must specify only one of the following parameters: <code>TemplateBody</code>,
     *         <code>TemplateURL</code>, or set the <code>UsePreviousTemplate</code> to <code>true</code>.
     */
    public final Boolean usePreviousTemplate() {
        return usePreviousTemplate;
    }

    /**
     * <p>
     * Structure containing the temporary overriding stack policy body. You can specify either the
     * <code>StackPolicyDuringUpdateBody</code> or the <code>StackPolicyDuringUpdateURL</code> parameter, but not both.
     * </p>
     * <p>
     * If you want to update protected resources, specify a temporary overriding stack policy during this update. If you
     * don't specify a stack policy, the current policy that is associated with the stack will be used.
     * </p>
     * 
     * @return Structure containing the temporary overriding stack policy body. You can specify either the
     *         <code>StackPolicyDuringUpdateBody</code> or the <code>StackPolicyDuringUpdateURL</code> parameter, but
     *         not both.</p>
     *         <p>
     *         If you want to update protected resources, specify a temporary overriding stack policy during this
     *         update. If you don't specify a stack policy, the current policy that is associated with the stack will be
     *         used.
     */
    public final String stackPolicyDuringUpdateBody() {
        return stackPolicyDuringUpdateBody;
    }

    /**
     * <p>
     * Location of a file containing the temporary overriding stack policy. The URL must point to a policy (max size:
     * 16KB) located in an S3 bucket in the same Region as the stack. The location for an Amazon S3 bucket must start
     * with <code>https://</code>. You can specify either the <code>StackPolicyDuringUpdateBody</code> or the
     * <code>StackPolicyDuringUpdateURL</code> parameter, but not both.
     * </p>
     * <p>
     * If you want to update protected resources, specify a temporary overriding stack policy during this update. If you
     * don't specify a stack policy, the current policy that is associated with the stack will be used.
     * </p>
     * 
     * @return Location of a file containing the temporary overriding stack policy. The URL must point to a policy (max
     *         size: 16KB) located in an S3 bucket in the same Region as the stack. The location for an Amazon S3 bucket
     *         must start with <code>https://</code>. You can specify either the
     *         <code>StackPolicyDuringUpdateBody</code> or the <code>StackPolicyDuringUpdateURL</code> parameter, but
     *         not both.</p>
     *         <p>
     *         If you want to update protected resources, specify a temporary overriding stack policy during this
     *         update. If you don't specify a stack policy, the current policy that is associated with the stack will be
     *         used.
     */
    public final String stackPolicyDuringUpdateURL() {
        return stackPolicyDuringUpdateURL;
    }

    /**
     * For responses, this returns true if the service returned a value for the Parameters property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasParameters() {
        return parameters != null && !(parameters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of <code>Parameter</code> structures that specify input parameters for the stack. For more information,
     * see the <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_Parameter.html">Parameter</a> data
     * type.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasParameters} method.
     * </p>
     * 
     * @return A list of <code>Parameter</code> structures that specify input parameters for the stack. For more
     *         information, see the <a
     *         href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_Parameter.html">Parameter</a>
     *         data type.
     */
    public final List<Parameter> parameters() {
        return parameters;
    }

    /**
     * <p>
     * In some cases, you must explicitly acknowledge that your stack template contains certain capabilities in order
     * for CloudFormation to update the stack.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>CAPABILITY_IAM</code> and <code>CAPABILITY_NAMED_IAM</code>
     * </p>
     * <p>
     * Some stack templates might include resources that can affect permissions in your Amazon Web Services account, for
     * example, by creating new IAM users. For those stacks, you must explicitly acknowledge this by specifying one of
     * these capabilities.
     * </p>
     * <p>
     * The following IAM resources require you to specify either the <code>CAPABILITY_IAM</code> or
     * <code>CAPABILITY_NAMED_IAM</code> capability.
     * </p>
     * <ul>
     * <li>
     * <p>
     * If you have IAM resources, you can specify either capability.
     * </p>
     * </li>
     * <li>
     * <p>
     * If you have IAM resources with custom names, you <i>must</i> specify <code>CAPABILITY_NAMED_IAM</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * If you don't specify either of these capabilities, CloudFormation returns an
     * <code>InsufficientCapabilities</code> error.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If your stack template contains these resources, we suggest that you review all permissions associated with them
     * and edit their permissions if necessary.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-accesskey.html">
     * AWS::IAM::AccessKey</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-group.html">
     * AWS::IAM::Group</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-instanceprofile.html">AWS
     * ::IAM::InstanceProfile</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-policy.html">AWS::IAM::
     * Policy</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-role.html">
     * AWS::IAM::Role</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-user.html">
     * AWS::IAM::User</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-usertogroupaddition.html"
     * >AWS::IAM::UserToGroupAddition</a>
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information, see <a href=
     * "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html#using-iam-capabilities"
     * >Acknowledging IAM resources in CloudFormation templates</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CAPABILITY_AUTO_EXPAND</code>
     * </p>
     * <p>
     * Some template contain macros. Macros perform custom processing on templates; this can include simple actions like
     * find-and-replace operations, all the way to extensive transformations of entire templates. Because of this, users
     * typically create a change set from the processed template, so that they can review the changes resulting from the
     * macros before actually updating the stack. If your stack template contains one or more macros, and you choose to
     * update a stack directly from the processed template, without first reviewing the resulting changes in a change
     * set, you must acknowledge this capability. This includes the <a href=
     * "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/create-reusable-transform-function-snippets-and-add-to-your-template-with-aws-include-transform.html"
     * >AWS::Include</a> and <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/transform-aws-serverless.html"
     * >AWS::Serverless</a> transforms, which are macros hosted by CloudFormation.
     * </p>
     * <p>
     * If you want to update a stack from a stack template that contains macros <i>and</i> nested stacks, you must
     * update the stack directly from the template using this capability.
     * </p>
     * <important>
     * <p>
     * You should only update stacks directly from a stack template that contains macros if you know what processing the
     * macro performs.
     * </p>
     * <p>
     * Each macro relies on an underlying Lambda service function for processing stack templates. Be aware that the
     * Lambda function owner can update the function operation without CloudFormation being notified.
     * </p>
     * </important>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-macros.html">Perform custom
     * processing on CloudFormation templates with template macros</a>.
     * </p>
     * </li>
     * </ul>
     * <note>
     * <p>
     * Only one of the <code>Capabilities</code> and <code>ResourceType</code> parameters can be specified.
     * </p>
     * </note>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCapabilities} method.
     * </p>
     * 
     * @return In some cases, you must explicitly acknowledge that your stack template contains certain capabilities in
     *         order for CloudFormation to update the stack.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>CAPABILITY_IAM</code> and <code>CAPABILITY_NAMED_IAM</code>
     *         </p>
     *         <p>
     *         Some stack templates might include resources that can affect permissions in your Amazon Web Services
     *         account, for example, by creating new IAM users. For those stacks, you must explicitly acknowledge this
     *         by specifying one of these capabilities.
     *         </p>
     *         <p>
     *         The following IAM resources require you to specify either the <code>CAPABILITY_IAM</code> or
     *         <code>CAPABILITY_NAMED_IAM</code> capability.
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         If you have IAM resources, you can specify either capability.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         If you have IAM resources with custom names, you <i>must</i> specify <code>CAPABILITY_NAMED_IAM</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         If you don't specify either of these capabilities, CloudFormation returns an
     *         <code>InsufficientCapabilities</code> error.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         If your stack template contains these resources, we suggest that you review all permissions associated
     *         with them and edit their permissions if necessary.
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-accesskey.html">
     *         AWS::IAM::AccessKey</a>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-group.html">
     *         AWS::IAM::Group</a>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <a href=
     *         "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-instanceprofile.html"
     *         >AWS::IAM::InstanceProfile</a>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-policy.html">AWS
     *         ::IAM::Policy</a>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-role.html">
     *         AWS::IAM::Role</a>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-user.html">
     *         AWS::IAM::User</a>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <a href=
     *         "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-usertogroupaddition.html"
     *         >AWS::IAM::UserToGroupAddition</a>
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For more information, see <a href=
     *         "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html#using-iam-capabilities"
     *         >Acknowledging IAM resources in CloudFormation templates</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CAPABILITY_AUTO_EXPAND</code>
     *         </p>
     *         <p>
     *         Some template contain macros. Macros perform custom processing on templates; this can include simple
     *         actions like find-and-replace operations, all the way to extensive transformations of entire templates.
     *         Because of this, users typically create a change set from the processed template, so that they can review
     *         the changes resulting from the macros before actually updating the stack. If your stack template contains
     *         one or more macros, and you choose to update a stack directly from the processed template, without first
     *         reviewing the resulting changes in a change set, you must acknowledge this capability. This includes the
     *         <a href=
     *         "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/create-reusable-transform-function-snippets-and-add-to-your-template-with-aws-include-transform.html"
     *         >AWS::Include</a> and <a
     *         href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/transform-aws-serverless.html"
     *         >AWS::Serverless</a> transforms, which are macros hosted by CloudFormation.
     *         </p>
     *         <p>
     *         If you want to update a stack from a stack template that contains macros <i>and</i> nested stacks, you
     *         must update the stack directly from the template using this capability.
     *         </p>
     *         <important>
     *         <p>
     *         You should only update stacks directly from a stack template that contains macros if you know what
     *         processing the macro performs.
     *         </p>
     *         <p>
     *         Each macro relies on an underlying Lambda service function for processing stack templates. Be aware that
     *         the Lambda function owner can update the function operation without CloudFormation being notified.
     *         </p>
     *         </important>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-macros.html">Perform custom
     *         processing on CloudFormation templates with template macros</a>.
     *         </p>
     *         </li>
     *         </ul>
     *         <note>
     *         <p>
     *         Only one of the <code>Capabilities</code> and <code>ResourceType</code> parameters can be specified.
     *         </p>
     */
    public final List<Capability> capabilities() {
        return CapabilitiesCopier.copyStringToEnum(capabilities);
    }

    /**
     * For responses, this returns true if the service returned a value for the Capabilities property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasCapabilities() {
        return capabilities != null && !(capabilities instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * In some cases, you must explicitly acknowledge that your stack template contains certain capabilities in order
     * for CloudFormation to update the stack.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>CAPABILITY_IAM</code> and <code>CAPABILITY_NAMED_IAM</code>
     * </p>
     * <p>
     * Some stack templates might include resources that can affect permissions in your Amazon Web Services account, for
     * example, by creating new IAM users. For those stacks, you must explicitly acknowledge this by specifying one of
     * these capabilities.
     * </p>
     * <p>
     * The following IAM resources require you to specify either the <code>CAPABILITY_IAM</code> or
     * <code>CAPABILITY_NAMED_IAM</code> capability.
     * </p>
     * <ul>
     * <li>
     * <p>
     * If you have IAM resources, you can specify either capability.
     * </p>
     * </li>
     * <li>
     * <p>
     * If you have IAM resources with custom names, you <i>must</i> specify <code>CAPABILITY_NAMED_IAM</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * If you don't specify either of these capabilities, CloudFormation returns an
     * <code>InsufficientCapabilities</code> error.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If your stack template contains these resources, we suggest that you review all permissions associated with them
     * and edit their permissions if necessary.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-accesskey.html">
     * AWS::IAM::AccessKey</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-group.html">
     * AWS::IAM::Group</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-instanceprofile.html">AWS
     * ::IAM::InstanceProfile</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-policy.html">AWS::IAM::
     * Policy</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-role.html">
     * AWS::IAM::Role</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-user.html">
     * AWS::IAM::User</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-usertogroupaddition.html"
     * >AWS::IAM::UserToGroupAddition</a>
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information, see <a href=
     * "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html#using-iam-capabilities"
     * >Acknowledging IAM resources in CloudFormation templates</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CAPABILITY_AUTO_EXPAND</code>
     * </p>
     * <p>
     * Some template contain macros. Macros perform custom processing on templates; this can include simple actions like
     * find-and-replace operations, all the way to extensive transformations of entire templates. Because of this, users
     * typically create a change set from the processed template, so that they can review the changes resulting from the
     * macros before actually updating the stack. If your stack template contains one or more macros, and you choose to
     * update a stack directly from the processed template, without first reviewing the resulting changes in a change
     * set, you must acknowledge this capability. This includes the <a href=
     * "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/create-reusable-transform-function-snippets-and-add-to-your-template-with-aws-include-transform.html"
     * >AWS::Include</a> and <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/transform-aws-serverless.html"
     * >AWS::Serverless</a> transforms, which are macros hosted by CloudFormation.
     * </p>
     * <p>
     * If you want to update a stack from a stack template that contains macros <i>and</i> nested stacks, you must
     * update the stack directly from the template using this capability.
     * </p>
     * <important>
     * <p>
     * You should only update stacks directly from a stack template that contains macros if you know what processing the
     * macro performs.
     * </p>
     * <p>
     * Each macro relies on an underlying Lambda service function for processing stack templates. Be aware that the
     * Lambda function owner can update the function operation without CloudFormation being notified.
     * </p>
     * </important>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-macros.html">Perform custom
     * processing on CloudFormation templates with template macros</a>.
     * </p>
     * </li>
     * </ul>
     * <note>
     * <p>
     * Only one of the <code>Capabilities</code> and <code>ResourceType</code> parameters can be specified.
     * </p>
     * </note>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCapabilities} method.
     * </p>
     * 
     * @return In some cases, you must explicitly acknowledge that your stack template contains certain capabilities in
     *         order for CloudFormation to update the stack.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>CAPABILITY_IAM</code> and <code>CAPABILITY_NAMED_IAM</code>
     *         </p>
     *         <p>
     *         Some stack templates might include resources that can affect permissions in your Amazon Web Services
     *         account, for example, by creating new IAM users. For those stacks, you must explicitly acknowledge this
     *         by specifying one of these capabilities.
     *         </p>
     *         <p>
     *         The following IAM resources require you to specify either the <code>CAPABILITY_IAM</code> or
     *         <code>CAPABILITY_NAMED_IAM</code> capability.
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         If you have IAM resources, you can specify either capability.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         If you have IAM resources with custom names, you <i>must</i> specify <code>CAPABILITY_NAMED_IAM</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         If you don't specify either of these capabilities, CloudFormation returns an
     *         <code>InsufficientCapabilities</code> error.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         If your stack template contains these resources, we suggest that you review all permissions associated
     *         with them and edit their permissions if necessary.
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-accesskey.html">
     *         AWS::IAM::AccessKey</a>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-group.html">
     *         AWS::IAM::Group</a>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <a href=
     *         "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-instanceprofile.html"
     *         >AWS::IAM::InstanceProfile</a>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-policy.html">AWS
     *         ::IAM::Policy</a>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-role.html">
     *         AWS::IAM::Role</a>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-user.html">
     *         AWS::IAM::User</a>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <a href=
     *         "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-usertogroupaddition.html"
     *         >AWS::IAM::UserToGroupAddition</a>
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For more information, see <a href=
     *         "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html#using-iam-capabilities"
     *         >Acknowledging IAM resources in CloudFormation templates</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CAPABILITY_AUTO_EXPAND</code>
     *         </p>
     *         <p>
     *         Some template contain macros. Macros perform custom processing on templates; this can include simple
     *         actions like find-and-replace operations, all the way to extensive transformations of entire templates.
     *         Because of this, users typically create a change set from the processed template, so that they can review
     *         the changes resulting from the macros before actually updating the stack. If your stack template contains
     *         one or more macros, and you choose to update a stack directly from the processed template, without first
     *         reviewing the resulting changes in a change set, you must acknowledge this capability. This includes the
     *         <a href=
     *         "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/create-reusable-transform-function-snippets-and-add-to-your-template-with-aws-include-transform.html"
     *         >AWS::Include</a> and <a
     *         href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/transform-aws-serverless.html"
     *         >AWS::Serverless</a> transforms, which are macros hosted by CloudFormation.
     *         </p>
     *         <p>
     *         If you want to update a stack from a stack template that contains macros <i>and</i> nested stacks, you
     *         must update the stack directly from the template using this capability.
     *         </p>
     *         <important>
     *         <p>
     *         You should only update stacks directly from a stack template that contains macros if you know what
     *         processing the macro performs.
     *         </p>
     *         <p>
     *         Each macro relies on an underlying Lambda service function for processing stack templates. Be aware that
     *         the Lambda function owner can update the function operation without CloudFormation being notified.
     *         </p>
     *         </important>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-macros.html">Perform custom
     *         processing on CloudFormation templates with template macros</a>.
     *         </p>
     *         </li>
     *         </ul>
     *         <note>
     *         <p>
     *         Only one of the <code>Capabilities</code> and <code>ResourceType</code> parameters can be specified.
     *         </p>
     */
    public final List<String> capabilitiesAsStrings() {
        return capabilities;
    }

    /**
     * For responses, this returns true if the service returned a value for the ResourceTypes property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasResourceTypes() {
        return resourceTypes != null && !(resourceTypes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The template resource types that you have permissions to work with for this update stack action, such as
     * <code>AWS::EC2::Instance</code>, <code>AWS::EC2::*</code>, or <code>Custom::MyCustomInstance</code>.
     * </p>
     * <p>
     * If the list of resource types doesn't include a resource that you're updating, the stack update fails. By
     * default, CloudFormation grants permissions to all resource types. IAM uses this parameter for
     * CloudFormation-specific condition keys in IAM policies. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html">Control access with
     * Identity and Access Management</a>.
     * </p>
     * <note>
     * <p>
     * Only one of the <code>Capabilities</code> and <code>ResourceType</code> parameters can be specified.
     * </p>
     * </note>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasResourceTypes} method.
     * </p>
     * 
     * @return The template resource types that you have permissions to work with for this update stack action, such as
     *         <code>AWS::EC2::Instance</code>, <code>AWS::EC2::*</code>, or <code>Custom::MyCustomInstance</code>.</p>
     *         <p>
     *         If the list of resource types doesn't include a resource that you're updating, the stack update fails. By
     *         default, CloudFormation grants permissions to all resource types. IAM uses this parameter for
     *         CloudFormation-specific condition keys in IAM policies. For more information, see <a
     *         href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html">Control
     *         access with Identity and Access Management</a>.
     *         </p>
     *         <note>
     *         <p>
     *         Only one of the <code>Capabilities</code> and <code>ResourceType</code> parameters can be specified.
     *         </p>
     */
    public final List<String> resourceTypes() {
        return resourceTypes;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of an IAM role that CloudFormation assumes to update the stack. CloudFormation
     * uses the role's credentials to make calls on your behalf. CloudFormation always uses this role for all future
     * operations on the stack. Provided that users have permission to operate on the stack, CloudFormation uses this
     * role even if the users don't have permission to pass it. Ensure that the role grants least privilege.
     * </p>
     * <p>
     * If you don't specify a value, CloudFormation uses the role that was previously associated with the stack. If no
     * role is available, CloudFormation uses a temporary session that is generated from your user credentials.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of an IAM role that CloudFormation assumes to update the stack.
     *         CloudFormation uses the role's credentials to make calls on your behalf. CloudFormation always uses this
     *         role for all future operations on the stack. Provided that users have permission to operate on the stack,
     *         CloudFormation uses this role even if the users don't have permission to pass it. Ensure that the role
     *         grants least privilege.</p>
     *         <p>
     *         If you don't specify a value, CloudFormation uses the role that was previously associated with the stack.
     *         If no role is available, CloudFormation uses a temporary session that is generated from your user
     *         credentials.
     */
    public final String roleARN() {
        return roleARN;
    }

    /**
     * <p>
     * The rollback triggers for CloudFormation to monitor during stack creation and updating operations, and for the
     * specified monitoring period afterwards.
     * </p>
     * 
     * @return The rollback triggers for CloudFormation to monitor during stack creation and updating operations, and
     *         for the specified monitoring period afterwards.
     */
    public final RollbackConfiguration rollbackConfiguration() {
        return rollbackConfiguration;
    }

    /**
     * <p>
     * Structure containing a new stack policy body. You can specify either the <code>StackPolicyBody</code> or the
     * <code>StackPolicyURL</code> parameter, but not both.
     * </p>
     * <p>
     * You might update the stack policy, for example, in order to protect a new resource that you created during a
     * stack update. If you don't specify a stack policy, the current policy that is associated with the stack is
     * unchanged.
     * </p>
     * 
     * @return Structure containing a new stack policy body. You can specify either the <code>StackPolicyBody</code> or
     *         the <code>StackPolicyURL</code> parameter, but not both.</p>
     *         <p>
     *         You might update the stack policy, for example, in order to protect a new resource that you created
     *         during a stack update. If you don't specify a stack policy, the current policy that is associated with
     *         the stack is unchanged.
     */
    public final String stackPolicyBody() {
        return stackPolicyBody;
    }

    /**
     * <p>
     * Location of a file containing the updated stack policy. The URL must point to a policy (max size: 16KB) located
     * in an S3 bucket in the same Region as the stack. The location for an Amazon S3 bucket must start with
     * <code>https://</code>. You can specify either the <code>StackPolicyBody</code> or the <code>StackPolicyURL</code>
     * parameter, but not both.
     * </p>
     * <p>
     * You might update the stack policy, for example, in order to protect a new resource that you created during a
     * stack update. If you don't specify a stack policy, the current policy that is associated with the stack is
     * unchanged.
     * </p>
     * 
     * @return Location of a file containing the updated stack policy. The URL must point to a policy (max size: 16KB)
     *         located in an S3 bucket in the same Region as the stack. The location for an Amazon S3 bucket must start
     *         with <code>https://</code>. You can specify either the <code>StackPolicyBody</code> or the
     *         <code>StackPolicyURL</code> parameter, but not both.</p>
     *         <p>
     *         You might update the stack policy, for example, in order to protect a new resource that you created
     *         during a stack update. If you don't specify a stack policy, the current policy that is associated with
     *         the stack is unchanged.
     */
    public final String stackPolicyURL() {
        return stackPolicyURL;
    }

    /**
     * For responses, this returns true if the service returned a value for the NotificationARNs property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasNotificationARNs() {
        return notificationARNs != null && !(notificationARNs instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Amazon Simple Notification Service topic Amazon Resource Names (ARNs) that CloudFormation associates with the
     * stack. Specify an empty list to remove all notification topics.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasNotificationARNs} method.
     * </p>
     * 
     * @return Amazon Simple Notification Service topic Amazon Resource Names (ARNs) that CloudFormation associates with
     *         the stack. Specify an empty list to remove all notification topics.
     */
    public final List<String> notificationARNs() {
        return notificationARNs;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Key-value pairs to associate with this stack. CloudFormation also propagates these tags to supported resources in
     * the stack. You can specify a maximum number of 50 tags.
     * </p>
     * <p>
     * If you don't specify this parameter, CloudFormation doesn't modify the stack's tags. If you specify an empty
     * value, CloudFormation removes all associated tags.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return Key-value pairs to associate with this stack. CloudFormation also propagates these tags to supported
     *         resources in the stack. You can specify a maximum number of 50 tags.</p>
     *         <p>
     *         If you don't specify this parameter, CloudFormation doesn't modify the stack's tags. If you specify an
     *         empty value, CloudFormation removes all associated tags.
     */
    public final List<Tag> tags() {
        return tags;
    }

    /**
     * <p>
     * Preserve the state of previously provisioned resources when an operation fails.
     * </p>
     * <p>
     * Default: <code>False</code>
     * </p>
     * 
     * @return Preserve the state of previously provisioned resources when an operation fails.</p>
     *         <p>
     *         Default: <code>False</code>
     */
    public final Boolean disableRollback() {
        return disableRollback;
    }

    /**
     * <p>
     * A unique identifier for this <code>UpdateStack</code> request. Specify this token if you plan to retry requests
     * so that CloudFormation knows that you're not attempting to update a stack with the same name. You might retry
     * <code>UpdateStack</code> requests to ensure that CloudFormation successfully received them.
     * </p>
     * <p>
     * All events triggered by a given stack operation are assigned the same client request token, which you can use to
     * track operations. For example, if you execute a <code>CreateStack</code> operation with the token
     * <code>token1</code>, then all the <code>StackEvents</code> generated by that operation will have
     * <code>ClientRequestToken</code> set as <code>token1</code>.
     * </p>
     * <p>
     * In the console, stack operations display the client request token on the Events tab. Stack operations that are
     * initiated from the console use the token format <i>Console-StackOperation-ID</i>, which helps you easily identify
     * the stack operation . For example, if you create a stack using the console, each stack event would be assigned
     * the same token in the following format: <code>Console-CreateStack-7f59c3cf-00d2-40c7-b2ff-e75db0987002</code>.
     * </p>
     * 
     * @return A unique identifier for this <code>UpdateStack</code> request. Specify this token if you plan to retry
     *         requests so that CloudFormation knows that you're not attempting to update a stack with the same name.
     *         You might retry <code>UpdateStack</code> requests to ensure that CloudFormation successfully received
     *         them.</p>
     *         <p>
     *         All events triggered by a given stack operation are assigned the same client request token, which you can
     *         use to track operations. For example, if you execute a <code>CreateStack</code> operation with the token
     *         <code>token1</code>, then all the <code>StackEvents</code> generated by that operation will have
     *         <code>ClientRequestToken</code> set as <code>token1</code>.
     *         </p>
     *         <p>
     *         In the console, stack operations display the client request token on the Events tab. Stack operations
     *         that are initiated from the console use the token format <i>Console-StackOperation-ID</i>, which helps
     *         you easily identify the stack operation . For example, if you create a stack using the console, each
     *         stack event would be assigned the same token in the following format:
     *         <code>Console-CreateStack-7f59c3cf-00d2-40c7-b2ff-e75db0987002</code>.
     */
    public final String clientRequestToken() {
        return clientRequestToken;
    }

    /**
     * <p>
     * When set to <code>true</code>, newly created resources are deleted when the operation rolls back. This includes
     * newly created resources marked with a deletion policy of <code>Retain</code>.
     * </p>
     * <p>
     * Default: <code>false</code>
     * </p>
     * 
     * @return When set to <code>true</code>, newly created resources are deleted when the operation rolls back. This
     *         includes newly created resources marked with a deletion policy of <code>Retain</code>.</p>
     *         <p>
     *         Default: <code>false</code>
     */
    public final Boolean retainExceptOnCreate() {
        return retainExceptOnCreate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(stackName());
        hashCode = 31 * hashCode + Objects.hashCode(templateBody());
        hashCode = 31 * hashCode + Objects.hashCode(templateURL());
        hashCode = 31 * hashCode + Objects.hashCode(usePreviousTemplate());
        hashCode = 31 * hashCode + Objects.hashCode(stackPolicyDuringUpdateBody());
        hashCode = 31 * hashCode + Objects.hashCode(stackPolicyDuringUpdateURL());
        hashCode = 31 * hashCode + Objects.hashCode(hasParameters() ? parameters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasCapabilities() ? capabilitiesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasResourceTypes() ? resourceTypes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(roleARN());
        hashCode = 31 * hashCode + Objects.hashCode(rollbackConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(stackPolicyBody());
        hashCode = 31 * hashCode + Objects.hashCode(stackPolicyURL());
        hashCode = 31 * hashCode + Objects.hashCode(hasNotificationARNs() ? notificationARNs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(disableRollback());
        hashCode = 31 * hashCode + Objects.hashCode(clientRequestToken());
        hashCode = 31 * hashCode + Objects.hashCode(retainExceptOnCreate());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateStackRequest)) {
            return false;
        }
        UpdateStackRequest other = (UpdateStackRequest) obj;
        return Objects.equals(stackName(), other.stackName()) && Objects.equals(templateBody(), other.templateBody())
                && Objects.equals(templateURL(), other.templateURL())
                && Objects.equals(usePreviousTemplate(), other.usePreviousTemplate())
                && Objects.equals(stackPolicyDuringUpdateBody(), other.stackPolicyDuringUpdateBody())
                && Objects.equals(stackPolicyDuringUpdateURL(), other.stackPolicyDuringUpdateURL())
                && hasParameters() == other.hasParameters() && Objects.equals(parameters(), other.parameters())
                && hasCapabilities() == other.hasCapabilities()
                && Objects.equals(capabilitiesAsStrings(), other.capabilitiesAsStrings())
                && hasResourceTypes() == other.hasResourceTypes() && Objects.equals(resourceTypes(), other.resourceTypes())
                && Objects.equals(roleARN(), other.roleARN())
                && Objects.equals(rollbackConfiguration(), other.rollbackConfiguration())
                && Objects.equals(stackPolicyBody(), other.stackPolicyBody())
                && Objects.equals(stackPolicyURL(), other.stackPolicyURL())
                && hasNotificationARNs() == other.hasNotificationARNs()
                && Objects.equals(notificationARNs(), other.notificationARNs()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags()) && Objects.equals(disableRollback(), other.disableRollback())
                && Objects.equals(clientRequestToken(), other.clientRequestToken())
                && Objects.equals(retainExceptOnCreate(), other.retainExceptOnCreate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateStackRequest").add("StackName", stackName()).add("TemplateBody", templateBody())
                .add("TemplateURL", templateURL()).add("UsePreviousTemplate", usePreviousTemplate())
                .add("StackPolicyDuringUpdateBody", stackPolicyDuringUpdateBody())
                .add("StackPolicyDuringUpdateURL", stackPolicyDuringUpdateURL())
                .add("Parameters", hasParameters() ? parameters() : null)
                .add("Capabilities", hasCapabilities() ? capabilitiesAsStrings() : null)
                .add("ResourceTypes", hasResourceTypes() ? resourceTypes() : null).add("RoleARN", roleARN())
                .add("RollbackConfiguration", rollbackConfiguration()).add("StackPolicyBody", stackPolicyBody())
                .add("StackPolicyURL", stackPolicyURL())
                .add("NotificationARNs", hasNotificationARNs() ? notificationARNs() : null)
                .add("Tags", hasTags() ? tags() : null).add("DisableRollback", disableRollback())
                .add("ClientRequestToken", clientRequestToken()).add("RetainExceptOnCreate", retainExceptOnCreate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StackName":
            return Optional.ofNullable(clazz.cast(stackName()));
        case "TemplateBody":
            return Optional.ofNullable(clazz.cast(templateBody()));
        case "TemplateURL":
            return Optional.ofNullable(clazz.cast(templateURL()));
        case "UsePreviousTemplate":
            return Optional.ofNullable(clazz.cast(usePreviousTemplate()));
        case "StackPolicyDuringUpdateBody":
            return Optional.ofNullable(clazz.cast(stackPolicyDuringUpdateBody()));
        case "StackPolicyDuringUpdateURL":
            return Optional.ofNullable(clazz.cast(stackPolicyDuringUpdateURL()));
        case "Parameters":
            return Optional.ofNullable(clazz.cast(parameters()));
        case "Capabilities":
            return Optional.ofNullable(clazz.cast(capabilitiesAsStrings()));
        case "ResourceTypes":
            return Optional.ofNullable(clazz.cast(resourceTypes()));
        case "RoleARN":
            return Optional.ofNullable(clazz.cast(roleARN()));
        case "RollbackConfiguration":
            return Optional.ofNullable(clazz.cast(rollbackConfiguration()));
        case "StackPolicyBody":
            return Optional.ofNullable(clazz.cast(stackPolicyBody()));
        case "StackPolicyURL":
            return Optional.ofNullable(clazz.cast(stackPolicyURL()));
        case "NotificationARNs":
            return Optional.ofNullable(clazz.cast(notificationARNs()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "DisableRollback":
            return Optional.ofNullable(clazz.cast(disableRollback()));
        case "ClientRequestToken":
            return Optional.ofNullable(clazz.cast(clientRequestToken()));
        case "RetainExceptOnCreate":
            return Optional.ofNullable(clazz.cast(retainExceptOnCreate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("StackName", STACK_NAME_FIELD);
        map.put("TemplateBody", TEMPLATE_BODY_FIELD);
        map.put("TemplateURL", TEMPLATE_URL_FIELD);
        map.put("UsePreviousTemplate", USE_PREVIOUS_TEMPLATE_FIELD);
        map.put("StackPolicyDuringUpdateBody", STACK_POLICY_DURING_UPDATE_BODY_FIELD);
        map.put("StackPolicyDuringUpdateURL", STACK_POLICY_DURING_UPDATE_URL_FIELD);
        map.put("Parameters", PARAMETERS_FIELD);
        map.put("Capabilities", CAPABILITIES_FIELD);
        map.put("ResourceTypes", RESOURCE_TYPES_FIELD);
        map.put("RoleARN", ROLE_ARN_FIELD);
        map.put("RollbackConfiguration", ROLLBACK_CONFIGURATION_FIELD);
        map.put("StackPolicyBody", STACK_POLICY_BODY_FIELD);
        map.put("StackPolicyURL", STACK_POLICY_URL_FIELD);
        map.put("NotificationARNs", NOTIFICATION_AR_NS_FIELD);
        map.put("Tags", TAGS_FIELD);
        map.put("DisableRollback", DISABLE_ROLLBACK_FIELD);
        map.put("ClientRequestToken", CLIENT_REQUEST_TOKEN_FIELD);
        map.put("RetainExceptOnCreate", RETAIN_EXCEPT_ON_CREATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateStackRequest, T> g) {
        return obj -> g.apply((UpdateStackRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudFormationRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateStackRequest> {
        /**
         * <p>
         * The name or unique stack ID of the stack to update.
         * </p>
         * 
         * @param stackName
         *        The name or unique stack ID of the stack to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stackName(String stackName);

        /**
         * <p>
         * Structure containing the template body with a minimum length of 1 byte and a maximum length of 51,200 bytes.
         * </p>
         * <p>
         * Conditional: You must specify only one of the following parameters: <code>TemplateBody</code>,
         * <code>TemplateURL</code>, or set the <code>UsePreviousTemplate</code> to <code>true</code>.
         * </p>
         * 
         * @param templateBody
         *        Structure containing the template body with a minimum length of 1 byte and a maximum length of 51,200
         *        bytes.</p>
         *        <p>
         *        Conditional: You must specify only one of the following parameters: <code>TemplateBody</code>,
         *        <code>TemplateURL</code>, or set the <code>UsePreviousTemplate</code> to <code>true</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder templateBody(String templateBody);

        /**
         * <p>
         * Location of file containing the template body. The URL must point to a template that's located in an Amazon
         * S3 bucket or a Systems Manager document. The location for an Amazon S3 bucket must start with
         * <code>https://</code>.
         * </p>
         * <p>
         * Conditional: You must specify only one of the following parameters: <code>TemplateBody</code>,
         * <code>TemplateURL</code>, or set the <code>UsePreviousTemplate</code> to <code>true</code>.
         * </p>
         * 
         * @param templateURL
         *        Location of file containing the template body. The URL must point to a template that's located in an
         *        Amazon S3 bucket or a Systems Manager document. The location for an Amazon S3 bucket must start with
         *        <code>https://</code>.</p>
         *        <p>
         *        Conditional: You must specify only one of the following parameters: <code>TemplateBody</code>,
         *        <code>TemplateURL</code>, or set the <code>UsePreviousTemplate</code> to <code>true</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder templateURL(String templateURL);

        /**
         * <p>
         * Reuse the existing template that is associated with the stack that you are updating.
         * </p>
         * <p>
         * Conditional: You must specify only one of the following parameters: <code>TemplateBody</code>,
         * <code>TemplateURL</code>, or set the <code>UsePreviousTemplate</code> to <code>true</code>.
         * </p>
         * 
         * @param usePreviousTemplate
         *        Reuse the existing template that is associated with the stack that you are updating.</p>
         *        <p>
         *        Conditional: You must specify only one of the following parameters: <code>TemplateBody</code>,
         *        <code>TemplateURL</code>, or set the <code>UsePreviousTemplate</code> to <code>true</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder usePreviousTemplate(Boolean usePreviousTemplate);

        /**
         * <p>
         * Structure containing the temporary overriding stack policy body. You can specify either the
         * <code>StackPolicyDuringUpdateBody</code> or the <code>StackPolicyDuringUpdateURL</code> parameter, but not
         * both.
         * </p>
         * <p>
         * If you want to update protected resources, specify a temporary overriding stack policy during this update. If
         * you don't specify a stack policy, the current policy that is associated with the stack will be used.
         * </p>
         * 
         * @param stackPolicyDuringUpdateBody
         *        Structure containing the temporary overriding stack policy body. You can specify either the
         *        <code>StackPolicyDuringUpdateBody</code> or the <code>StackPolicyDuringUpdateURL</code> parameter, but
         *        not both.</p>
         *        <p>
         *        If you want to update protected resources, specify a temporary overriding stack policy during this
         *        update. If you don't specify a stack policy, the current policy that is associated with the stack will
         *        be used.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stackPolicyDuringUpdateBody(String stackPolicyDuringUpdateBody);

        /**
         * <p>
         * Location of a file containing the temporary overriding stack policy. The URL must point to a policy (max
         * size: 16KB) located in an S3 bucket in the same Region as the stack. The location for an Amazon S3 bucket
         * must start with <code>https://</code>. You can specify either the <code>StackPolicyDuringUpdateBody</code> or
         * the <code>StackPolicyDuringUpdateURL</code> parameter, but not both.
         * </p>
         * <p>
         * If you want to update protected resources, specify a temporary overriding stack policy during this update. If
         * you don't specify a stack policy, the current policy that is associated with the stack will be used.
         * </p>
         * 
         * @param stackPolicyDuringUpdateURL
         *        Location of a file containing the temporary overriding stack policy. The URL must point to a policy
         *        (max size: 16KB) located in an S3 bucket in the same Region as the stack. The location for an Amazon
         *        S3 bucket must start with <code>https://</code>. You can specify either the
         *        <code>StackPolicyDuringUpdateBody</code> or the <code>StackPolicyDuringUpdateURL</code> parameter, but
         *        not both.</p>
         *        <p>
         *        If you want to update protected resources, specify a temporary overriding stack policy during this
         *        update. If you don't specify a stack policy, the current policy that is associated with the stack will
         *        be used.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stackPolicyDuringUpdateURL(String stackPolicyDuringUpdateURL);

        /**
         * <p>
         * A list of <code>Parameter</code> structures that specify input parameters for the stack. For more
         * information, see the <a
         * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_Parameter.html">Parameter</a>
         * data type.
         * </p>
         * 
         * @param parameters
         *        A list of <code>Parameter</code> structures that specify input parameters for the stack. For more
         *        information, see the <a
         *        href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_Parameter.html"
         *        >Parameter</a> data type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameters(Collection<Parameter> parameters);

        /**
         * <p>
         * A list of <code>Parameter</code> structures that specify input parameters for the stack. For more
         * information, see the <a
         * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_Parameter.html">Parameter</a>
         * data type.
         * </p>
         * 
         * @param parameters
         *        A list of <code>Parameter</code> structures that specify input parameters for the stack. For more
         *        information, see the <a
         *        href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_Parameter.html"
         *        >Parameter</a> data type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameters(Parameter... parameters);

        /**
         * <p>
         * A list of <code>Parameter</code> structures that specify input parameters for the stack. For more
         * information, see the <a
         * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_Parameter.html">Parameter</a>
         * data type.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.cloudformation.model.Parameter.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.cloudformation.model.Parameter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.cloudformation.model.Parameter.Builder#build()} is called immediately
         * and its result is passed to {@link #parameters(List<Parameter>)}.
         * 
         * @param parameters
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.cloudformation.model.Parameter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #parameters(java.util.Collection<Parameter>)
         */
        Builder parameters(Consumer<Parameter.Builder>... parameters);

        /**
         * <p>
         * In some cases, you must explicitly acknowledge that your stack template contains certain capabilities in
         * order for CloudFormation to update the stack.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>CAPABILITY_IAM</code> and <code>CAPABILITY_NAMED_IAM</code>
         * </p>
         * <p>
         * Some stack templates might include resources that can affect permissions in your Amazon Web Services account,
         * for example, by creating new IAM users. For those stacks, you must explicitly acknowledge this by specifying
         * one of these capabilities.
         * </p>
         * <p>
         * The following IAM resources require you to specify either the <code>CAPABILITY_IAM</code> or
         * <code>CAPABILITY_NAMED_IAM</code> capability.
         * </p>
         * <ul>
         * <li>
         * <p>
         * If you have IAM resources, you can specify either capability.
         * </p>
         * </li>
         * <li>
         * <p>
         * If you have IAM resources with custom names, you <i>must</i> specify <code>CAPABILITY_NAMED_IAM</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * If you don't specify either of these capabilities, CloudFormation returns an
         * <code>InsufficientCapabilities</code> error.
         * </p>
         * </li>
         * </ul>
         * <p>
         * If your stack template contains these resources, we suggest that you review all permissions associated with
         * them and edit their permissions if necessary.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-accesskey.html">
         * AWS::IAM::AccessKey</a>
         * </p>
         * </li>
         * <li>
         * <p>
         * <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-group.html">
         * AWS::IAM::Group</a>
         * </p>
         * </li>
         * <li>
         * <p>
         * <a
         * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-instanceprofile.html"
         * >AWS::IAM::InstanceProfile</a>
         * </p>
         * </li>
         * <li>
         * <p>
         * <a
         * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-policy.html">AWS::IAM
         * ::Policy</a>
         * </p>
         * </li>
         * <li>
         * <p>
         * <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-role.html">
         * AWS::IAM::Role</a>
         * </p>
         * </li>
         * <li>
         * <p>
         * <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-user.html">
         * AWS::IAM::User</a>
         * </p>
         * </li>
         * <li>
         * <p>
         * <a href=
         * "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-usertogroupaddition.html"
         * >AWS::IAM::UserToGroupAddition</a>
         * </p>
         * </li>
         * </ul>
         * <p>
         * For more information, see <a href=
         * "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html#using-iam-capabilities"
         * >Acknowledging IAM resources in CloudFormation templates</a>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CAPABILITY_AUTO_EXPAND</code>
         * </p>
         * <p>
         * Some template contain macros. Macros perform custom processing on templates; this can include simple actions
         * like find-and-replace operations, all the way to extensive transformations of entire templates. Because of
         * this, users typically create a change set from the processed template, so that they can review the changes
         * resulting from the macros before actually updating the stack. If your stack template contains one or more
         * macros, and you choose to update a stack directly from the processed template, without first reviewing the
         * resulting changes in a change set, you must acknowledge this capability. This includes the <a href=
         * "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/create-reusable-transform-function-snippets-and-add-to-your-template-with-aws-include-transform.html"
         * >AWS::Include</a> and <a
         * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/transform-aws-serverless.html"
         * >AWS::Serverless</a> transforms, which are macros hosted by CloudFormation.
         * </p>
         * <p>
         * If you want to update a stack from a stack template that contains macros <i>and</i> nested stacks, you must
         * update the stack directly from the template using this capability.
         * </p>
         * <important>
         * <p>
         * You should only update stacks directly from a stack template that contains macros if you know what processing
         * the macro performs.
         * </p>
         * <p>
         * Each macro relies on an underlying Lambda service function for processing stack templates. Be aware that the
         * Lambda function owner can update the function operation without CloudFormation being notified.
         * </p>
         * </important>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-macros.html">Perform custom
         * processing on CloudFormation templates with template macros</a>.
         * </p>
         * </li>
         * </ul>
         * <note>
         * <p>
         * Only one of the <code>Capabilities</code> and <code>ResourceType</code> parameters can be specified.
         * </p>
         * </note>
         * 
         * @param capabilities
         *        In some cases, you must explicitly acknowledge that your stack template contains certain capabilities
         *        in order for CloudFormation to update the stack.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>CAPABILITY_IAM</code> and <code>CAPABILITY_NAMED_IAM</code>
         *        </p>
         *        <p>
         *        Some stack templates might include resources that can affect permissions in your Amazon Web Services
         *        account, for example, by creating new IAM users. For those stacks, you must explicitly acknowledge
         *        this by specifying one of these capabilities.
         *        </p>
         *        <p>
         *        The following IAM resources require you to specify either the <code>CAPABILITY_IAM</code> or
         *        <code>CAPABILITY_NAMED_IAM</code> capability.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        If you have IAM resources, you can specify either capability.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If you have IAM resources with custom names, you <i>must</i> specify <code>CAPABILITY_NAMED_IAM</code>
         *        .
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If you don't specify either of these capabilities, CloudFormation returns an
         *        <code>InsufficientCapabilities</code> error.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        If your stack template contains these resources, we suggest that you review all permissions associated
         *        with them and edit their permissions if necessary.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <a href=
         *        "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-accesskey.html">
         *        AWS::IAM::AccessKey</a>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-group.html">
         *        AWS::IAM::Group</a>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <a href=
         *        "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-instanceprofile.html"
         *        >AWS::IAM::InstanceProfile</a>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-policy.html">
         *        AWS::IAM::Policy</a>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-role.html">
         *        AWS::IAM::Role</a>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-user.html">
         *        AWS::IAM::User</a>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <a href=
         *        "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-usertogroupaddition.html"
         *        >AWS::IAM::UserToGroupAddition</a>
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        For more information, see <a href=
         *        "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html#using-iam-capabilities"
         *        >Acknowledging IAM resources in CloudFormation templates</a>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CAPABILITY_AUTO_EXPAND</code>
         *        </p>
         *        <p>
         *        Some template contain macros. Macros perform custom processing on templates; this can include simple
         *        actions like find-and-replace operations, all the way to extensive transformations of entire
         *        templates. Because of this, users typically create a change set from the processed template, so that
         *        they can review the changes resulting from the macros before actually updating the stack. If your
         *        stack template contains one or more macros, and you choose to update a stack directly from the
         *        processed template, without first reviewing the resulting changes in a change set, you must
         *        acknowledge this capability. This includes the <a href=
         *        "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/create-reusable-transform-function-snippets-and-add-to-your-template-with-aws-include-transform.html"
         *        >AWS::Include</a> and <a
         *        href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/transform-aws-serverless.html"
         *        >AWS::Serverless</a> transforms, which are macros hosted by CloudFormation.
         *        </p>
         *        <p>
         *        If you want to update a stack from a stack template that contains macros <i>and</i> nested stacks, you
         *        must update the stack directly from the template using this capability.
         *        </p>
         *        <important>
         *        <p>
         *        You should only update stacks directly from a stack template that contains macros if you know what
         *        processing the macro performs.
         *        </p>
         *        <p>
         *        Each macro relies on an underlying Lambda service function for processing stack templates. Be aware
         *        that the Lambda function owner can update the function operation without CloudFormation being
         *        notified.
         *        </p>
         *        </important>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-macros.html">Perform
         *        custom processing on CloudFormation templates with template macros</a>.
         *        </p>
         *        </li>
         *        </ul>
         *        <note>
         *        <p>
         *        Only one of the <code>Capabilities</code> and <code>ResourceType</code> parameters can be specified.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capabilitiesWithStrings(Collection<String> capabilities);

        /**
         * <p>
         * In some cases, you must explicitly acknowledge that your stack template contains certain capabilities in
         * order for CloudFormation to update the stack.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>CAPABILITY_IAM</code> and <code>CAPABILITY_NAMED_IAM</code>
         * </p>
         * <p>
         * Some stack templates might include resources that can affect permissions in your Amazon Web Services account,
         * for example, by creating new IAM users. For those stacks, you must explicitly acknowledge this by specifying
         * one of these capabilities.
         * </p>
         * <p>
         * The following IAM resources require you to specify either the <code>CAPABILITY_IAM</code> or
         * <code>CAPABILITY_NAMED_IAM</code> capability.
         * </p>
         * <ul>
         * <li>
         * <p>
         * If you have IAM resources, you can specify either capability.
         * </p>
         * </li>
         * <li>
         * <p>
         * If you have IAM resources with custom names, you <i>must</i> specify <code>CAPABILITY_NAMED_IAM</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * If you don't specify either of these capabilities, CloudFormation returns an
         * <code>InsufficientCapabilities</code> error.
         * </p>
         * </li>
         * </ul>
         * <p>
         * If your stack template contains these resources, we suggest that you review all permissions associated with
         * them and edit their permissions if necessary.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-accesskey.html">
         * AWS::IAM::AccessKey</a>
         * </p>
         * </li>
         * <li>
         * <p>
         * <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-group.html">
         * AWS::IAM::Group</a>
         * </p>
         * </li>
         * <li>
         * <p>
         * <a
         * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-instanceprofile.html"
         * >AWS::IAM::InstanceProfile</a>
         * </p>
         * </li>
         * <li>
         * <p>
         * <a
         * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-policy.html">AWS::IAM
         * ::Policy</a>
         * </p>
         * </li>
         * <li>
         * <p>
         * <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-role.html">
         * AWS::IAM::Role</a>
         * </p>
         * </li>
         * <li>
         * <p>
         * <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-user.html">
         * AWS::IAM::User</a>
         * </p>
         * </li>
         * <li>
         * <p>
         * <a href=
         * "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-usertogroupaddition.html"
         * >AWS::IAM::UserToGroupAddition</a>
         * </p>
         * </li>
         * </ul>
         * <p>
         * For more information, see <a href=
         * "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html#using-iam-capabilities"
         * >Acknowledging IAM resources in CloudFormation templates</a>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CAPABILITY_AUTO_EXPAND</code>
         * </p>
         * <p>
         * Some template contain macros. Macros perform custom processing on templates; this can include simple actions
         * like find-and-replace operations, all the way to extensive transformations of entire templates. Because of
         * this, users typically create a change set from the processed template, so that they can review the changes
         * resulting from the macros before actually updating the stack. If your stack template contains one or more
         * macros, and you choose to update a stack directly from the processed template, without first reviewing the
         * resulting changes in a change set, you must acknowledge this capability. This includes the <a href=
         * "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/create-reusable-transform-function-snippets-and-add-to-your-template-with-aws-include-transform.html"
         * >AWS::Include</a> and <a
         * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/transform-aws-serverless.html"
         * >AWS::Serverless</a> transforms, which are macros hosted by CloudFormation.
         * </p>
         * <p>
         * If you want to update a stack from a stack template that contains macros <i>and</i> nested stacks, you must
         * update the stack directly from the template using this capability.
         * </p>
         * <important>
         * <p>
         * You should only update stacks directly from a stack template that contains macros if you know what processing
         * the macro performs.
         * </p>
         * <p>
         * Each macro relies on an underlying Lambda service function for processing stack templates. Be aware that the
         * Lambda function owner can update the function operation without CloudFormation being notified.
         * </p>
         * </important>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-macros.html">Perform custom
         * processing on CloudFormation templates with template macros</a>.
         * </p>
         * </li>
         * </ul>
         * <note>
         * <p>
         * Only one of the <code>Capabilities</code> and <code>ResourceType</code> parameters can be specified.
         * </p>
         * </note>
         * 
         * @param capabilities
         *        In some cases, you must explicitly acknowledge that your stack template contains certain capabilities
         *        in order for CloudFormation to update the stack.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>CAPABILITY_IAM</code> and <code>CAPABILITY_NAMED_IAM</code>
         *        </p>
         *        <p>
         *        Some stack templates might include resources that can affect permissions in your Amazon Web Services
         *        account, for example, by creating new IAM users. For those stacks, you must explicitly acknowledge
         *        this by specifying one of these capabilities.
         *        </p>
         *        <p>
         *        The following IAM resources require you to specify either the <code>CAPABILITY_IAM</code> or
         *        <code>CAPABILITY_NAMED_IAM</code> capability.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        If you have IAM resources, you can specify either capability.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If you have IAM resources with custom names, you <i>must</i> specify <code>CAPABILITY_NAMED_IAM</code>
         *        .
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If you don't specify either of these capabilities, CloudFormation returns an
         *        <code>InsufficientCapabilities</code> error.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        If your stack template contains these resources, we suggest that you review all permissions associated
         *        with them and edit their permissions if necessary.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <a href=
         *        "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-accesskey.html">
         *        AWS::IAM::AccessKey</a>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-group.html">
         *        AWS::IAM::Group</a>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <a href=
         *        "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-instanceprofile.html"
         *        >AWS::IAM::InstanceProfile</a>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-policy.html">
         *        AWS::IAM::Policy</a>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-role.html">
         *        AWS::IAM::Role</a>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-user.html">
         *        AWS::IAM::User</a>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <a href=
         *        "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-usertogroupaddition.html"
         *        >AWS::IAM::UserToGroupAddition</a>
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        For more information, see <a href=
         *        "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html#using-iam-capabilities"
         *        >Acknowledging IAM resources in CloudFormation templates</a>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CAPABILITY_AUTO_EXPAND</code>
         *        </p>
         *        <p>
         *        Some template contain macros. Macros perform custom processing on templates; this can include simple
         *        actions like find-and-replace operations, all the way to extensive transformations of entire
         *        templates. Because of this, users typically create a change set from the processed template, so that
         *        they can review the changes resulting from the macros before actually updating the stack. If your
         *        stack template contains one or more macros, and you choose to update a stack directly from the
         *        processed template, without first reviewing the resulting changes in a change set, you must
         *        acknowledge this capability. This includes the <a href=
         *        "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/create-reusable-transform-function-snippets-and-add-to-your-template-with-aws-include-transform.html"
         *        >AWS::Include</a> and <a
         *        href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/transform-aws-serverless.html"
         *        >AWS::Serverless</a> transforms, which are macros hosted by CloudFormation.
         *        </p>
         *        <p>
         *        If you want to update a stack from a stack template that contains macros <i>and</i> nested stacks, you
         *        must update the stack directly from the template using this capability.
         *        </p>
         *        <important>
         *        <p>
         *        You should only update stacks directly from a stack template that contains macros if you know what
         *        processing the macro performs.
         *        </p>
         *        <p>
         *        Each macro relies on an underlying Lambda service function for processing stack templates. Be aware
         *        that the Lambda function owner can update the function operation without CloudFormation being
         *        notified.
         *        </p>
         *        </important>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-macros.html">Perform
         *        custom processing on CloudFormation templates with template macros</a>.
         *        </p>
         *        </li>
         *        </ul>
         *        <note>
         *        <p>
         *        Only one of the <code>Capabilities</code> and <code>ResourceType</code> parameters can be specified.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capabilitiesWithStrings(String... capabilities);

        /**
         * <p>
         * In some cases, you must explicitly acknowledge that your stack template contains certain capabilities in
         * order for CloudFormation to update the stack.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>CAPABILITY_IAM</code> and <code>CAPABILITY_NAMED_IAM</code>
         * </p>
         * <p>
         * Some stack templates might include resources that can affect permissions in your Amazon Web Services account,
         * for example, by creating new IAM users. For those stacks, you must explicitly acknowledge this by specifying
         * one of these capabilities.
         * </p>
         * <p>
         * The following IAM resources require you to specify either the <code>CAPABILITY_IAM</code> or
         * <code>CAPABILITY_NAMED_IAM</code> capability.
         * </p>
         * <ul>
         * <li>
         * <p>
         * If you have IAM resources, you can specify either capability.
         * </p>
         * </li>
         * <li>
         * <p>
         * If you have IAM resources with custom names, you <i>must</i> specify <code>CAPABILITY_NAMED_IAM</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * If you don't specify either of these capabilities, CloudFormation returns an
         * <code>InsufficientCapabilities</code> error.
         * </p>
         * </li>
         * </ul>
         * <p>
         * If your stack template contains these resources, we suggest that you review all permissions associated with
         * them and edit their permissions if necessary.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-accesskey.html">
         * AWS::IAM::AccessKey</a>
         * </p>
         * </li>
         * <li>
         * <p>
         * <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-group.html">
         * AWS::IAM::Group</a>
         * </p>
         * </li>
         * <li>
         * <p>
         * <a
         * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-instanceprofile.html"
         * >AWS::IAM::InstanceProfile</a>
         * </p>
         * </li>
         * <li>
         * <p>
         * <a
         * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-policy.html">AWS::IAM
         * ::Policy</a>
         * </p>
         * </li>
         * <li>
         * <p>
         * <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-role.html">
         * AWS::IAM::Role</a>
         * </p>
         * </li>
         * <li>
         * <p>
         * <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-user.html">
         * AWS::IAM::User</a>
         * </p>
         * </li>
         * <li>
         * <p>
         * <a href=
         * "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-usertogroupaddition.html"
         * >AWS::IAM::UserToGroupAddition</a>
         * </p>
         * </li>
         * </ul>
         * <p>
         * For more information, see <a href=
         * "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html#using-iam-capabilities"
         * >Acknowledging IAM resources in CloudFormation templates</a>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CAPABILITY_AUTO_EXPAND</code>
         * </p>
         * <p>
         * Some template contain macros. Macros perform custom processing on templates; this can include simple actions
         * like find-and-replace operations, all the way to extensive transformations of entire templates. Because of
         * this, users typically create a change set from the processed template, so that they can review the changes
         * resulting from the macros before actually updating the stack. If your stack template contains one or more
         * macros, and you choose to update a stack directly from the processed template, without first reviewing the
         * resulting changes in a change set, you must acknowledge this capability. This includes the <a href=
         * "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/create-reusable-transform-function-snippets-and-add-to-your-template-with-aws-include-transform.html"
         * >AWS::Include</a> and <a
         * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/transform-aws-serverless.html"
         * >AWS::Serverless</a> transforms, which are macros hosted by CloudFormation.
         * </p>
         * <p>
         * If you want to update a stack from a stack template that contains macros <i>and</i> nested stacks, you must
         * update the stack directly from the template using this capability.
         * </p>
         * <important>
         * <p>
         * You should only update stacks directly from a stack template that contains macros if you know what processing
         * the macro performs.
         * </p>
         * <p>
         * Each macro relies on an underlying Lambda service function for processing stack templates. Be aware that the
         * Lambda function owner can update the function operation without CloudFormation being notified.
         * </p>
         * </important>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-macros.html">Perform custom
         * processing on CloudFormation templates with template macros</a>.
         * </p>
         * </li>
         * </ul>
         * <note>
         * <p>
         * Only one of the <code>Capabilities</code> and <code>ResourceType</code> parameters can be specified.
         * </p>
         * </note>
         * 
         * @param capabilities
         *        In some cases, you must explicitly acknowledge that your stack template contains certain capabilities
         *        in order for CloudFormation to update the stack.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>CAPABILITY_IAM</code> and <code>CAPABILITY_NAMED_IAM</code>
         *        </p>
         *        <p>
         *        Some stack templates might include resources that can affect permissions in your Amazon Web Services
         *        account, for example, by creating new IAM users. For those stacks, you must explicitly acknowledge
         *        this by specifying one of these capabilities.
         *        </p>
         *        <p>
         *        The following IAM resources require you to specify either the <code>CAPABILITY_IAM</code> or
         *        <code>CAPABILITY_NAMED_IAM</code> capability.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        If you have IAM resources, you can specify either capability.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If you have IAM resources with custom names, you <i>must</i> specify <code>CAPABILITY_NAMED_IAM</code>
         *        .
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If you don't specify either of these capabilities, CloudFormation returns an
         *        <code>InsufficientCapabilities</code> error.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        If your stack template contains these resources, we suggest that you review all permissions associated
         *        with them and edit their permissions if necessary.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <a href=
         *        "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-accesskey.html">
         *        AWS::IAM::AccessKey</a>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-group.html">
         *        AWS::IAM::Group</a>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <a href=
         *        "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-instanceprofile.html"
         *        >AWS::IAM::InstanceProfile</a>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-policy.html">
         *        AWS::IAM::Policy</a>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-role.html">
         *        AWS::IAM::Role</a>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-user.html">
         *        AWS::IAM::User</a>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <a href=
         *        "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-usertogroupaddition.html"
         *        >AWS::IAM::UserToGroupAddition</a>
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        For more information, see <a href=
         *        "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html#using-iam-capabilities"
         *        >Acknowledging IAM resources in CloudFormation templates</a>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CAPABILITY_AUTO_EXPAND</code>
         *        </p>
         *        <p>
         *        Some template contain macros. Macros perform custom processing on templates; this can include simple
         *        actions like find-and-replace operations, all the way to extensive transformations of entire
         *        templates. Because of this, users typically create a change set from the processed template, so that
         *        they can review the changes resulting from the macros before actually updating the stack. If your
         *        stack template contains one or more macros, and you choose to update a stack directly from the
         *        processed template, without first reviewing the resulting changes in a change set, you must
         *        acknowledge this capability. This includes the <a href=
         *        "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/create-reusable-transform-function-snippets-and-add-to-your-template-with-aws-include-transform.html"
         *        >AWS::Include</a> and <a
         *        href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/transform-aws-serverless.html"
         *        >AWS::Serverless</a> transforms, which are macros hosted by CloudFormation.
         *        </p>
         *        <p>
         *        If you want to update a stack from a stack template that contains macros <i>and</i> nested stacks, you
         *        must update the stack directly from the template using this capability.
         *        </p>
         *        <important>
         *        <p>
         *        You should only update stacks directly from a stack template that contains macros if you know what
         *        processing the macro performs.
         *        </p>
         *        <p>
         *        Each macro relies on an underlying Lambda service function for processing stack templates. Be aware
         *        that the Lambda function owner can update the function operation without CloudFormation being
         *        notified.
         *        </p>
         *        </important>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-macros.html">Perform
         *        custom processing on CloudFormation templates with template macros</a>.
         *        </p>
         *        </li>
         *        </ul>
         *        <note>
         *        <p>
         *        Only one of the <code>Capabilities</code> and <code>ResourceType</code> parameters can be specified.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capabilities(Collection<Capability> capabilities);

        /**
         * <p>
         * In some cases, you must explicitly acknowledge that your stack template contains certain capabilities in
         * order for CloudFormation to update the stack.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>CAPABILITY_IAM</code> and <code>CAPABILITY_NAMED_IAM</code>
         * </p>
         * <p>
         * Some stack templates might include resources that can affect permissions in your Amazon Web Services account,
         * for example, by creating new IAM users. For those stacks, you must explicitly acknowledge this by specifying
         * one of these capabilities.
         * </p>
         * <p>
         * The following IAM resources require you to specify either the <code>CAPABILITY_IAM</code> or
         * <code>CAPABILITY_NAMED_IAM</code> capability.
         * </p>
         * <ul>
         * <li>
         * <p>
         * If you have IAM resources, you can specify either capability.
         * </p>
         * </li>
         * <li>
         * <p>
         * If you have IAM resources with custom names, you <i>must</i> specify <code>CAPABILITY_NAMED_IAM</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * If you don't specify either of these capabilities, CloudFormation returns an
         * <code>InsufficientCapabilities</code> error.
         * </p>
         * </li>
         * </ul>
         * <p>
         * If your stack template contains these resources, we suggest that you review all permissions associated with
         * them and edit their permissions if necessary.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-accesskey.html">
         * AWS::IAM::AccessKey</a>
         * </p>
         * </li>
         * <li>
         * <p>
         * <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-group.html">
         * AWS::IAM::Group</a>
         * </p>
         * </li>
         * <li>
         * <p>
         * <a
         * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-instanceprofile.html"
         * >AWS::IAM::InstanceProfile</a>
         * </p>
         * </li>
         * <li>
         * <p>
         * <a
         * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-policy.html">AWS::IAM
         * ::Policy</a>
         * </p>
         * </li>
         * <li>
         * <p>
         * <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-role.html">
         * AWS::IAM::Role</a>
         * </p>
         * </li>
         * <li>
         * <p>
         * <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-user.html">
         * AWS::IAM::User</a>
         * </p>
         * </li>
         * <li>
         * <p>
         * <a href=
         * "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-usertogroupaddition.html"
         * >AWS::IAM::UserToGroupAddition</a>
         * </p>
         * </li>
         * </ul>
         * <p>
         * For more information, see <a href=
         * "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html#using-iam-capabilities"
         * >Acknowledging IAM resources in CloudFormation templates</a>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CAPABILITY_AUTO_EXPAND</code>
         * </p>
         * <p>
         * Some template contain macros. Macros perform custom processing on templates; this can include simple actions
         * like find-and-replace operations, all the way to extensive transformations of entire templates. Because of
         * this, users typically create a change set from the processed template, so that they can review the changes
         * resulting from the macros before actually updating the stack. If your stack template contains one or more
         * macros, and you choose to update a stack directly from the processed template, without first reviewing the
         * resulting changes in a change set, you must acknowledge this capability. This includes the <a href=
         * "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/create-reusable-transform-function-snippets-and-add-to-your-template-with-aws-include-transform.html"
         * >AWS::Include</a> and <a
         * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/transform-aws-serverless.html"
         * >AWS::Serverless</a> transforms, which are macros hosted by CloudFormation.
         * </p>
         * <p>
         * If you want to update a stack from a stack template that contains macros <i>and</i> nested stacks, you must
         * update the stack directly from the template using this capability.
         * </p>
         * <important>
         * <p>
         * You should only update stacks directly from a stack template that contains macros if you know what processing
         * the macro performs.
         * </p>
         * <p>
         * Each macro relies on an underlying Lambda service function for processing stack templates. Be aware that the
         * Lambda function owner can update the function operation without CloudFormation being notified.
         * </p>
         * </important>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-macros.html">Perform custom
         * processing on CloudFormation templates with template macros</a>.
         * </p>
         * </li>
         * </ul>
         * <note>
         * <p>
         * Only one of the <code>Capabilities</code> and <code>ResourceType</code> parameters can be specified.
         * </p>
         * </note>
         * 
         * @param capabilities
         *        In some cases, you must explicitly acknowledge that your stack template contains certain capabilities
         *        in order for CloudFormation to update the stack.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>CAPABILITY_IAM</code> and <code>CAPABILITY_NAMED_IAM</code>
         *        </p>
         *        <p>
         *        Some stack templates might include resources that can affect permissions in your Amazon Web Services
         *        account, for example, by creating new IAM users. For those stacks, you must explicitly acknowledge
         *        this by specifying one of these capabilities.
         *        </p>
         *        <p>
         *        The following IAM resources require you to specify either the <code>CAPABILITY_IAM</code> or
         *        <code>CAPABILITY_NAMED_IAM</code> capability.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        If you have IAM resources, you can specify either capability.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If you have IAM resources with custom names, you <i>must</i> specify <code>CAPABILITY_NAMED_IAM</code>
         *        .
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If you don't specify either of these capabilities, CloudFormation returns an
         *        <code>InsufficientCapabilities</code> error.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        If your stack template contains these resources, we suggest that you review all permissions associated
         *        with them and edit their permissions if necessary.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <a href=
         *        "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-accesskey.html">
         *        AWS::IAM::AccessKey</a>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-group.html">
         *        AWS::IAM::Group</a>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <a href=
         *        "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-instanceprofile.html"
         *        >AWS::IAM::InstanceProfile</a>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-policy.html">
         *        AWS::IAM::Policy</a>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-role.html">
         *        AWS::IAM::Role</a>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-user.html">
         *        AWS::IAM::User</a>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <a href=
         *        "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-usertogroupaddition.html"
         *        >AWS::IAM::UserToGroupAddition</a>
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        For more information, see <a href=
         *        "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html#using-iam-capabilities"
         *        >Acknowledging IAM resources in CloudFormation templates</a>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CAPABILITY_AUTO_EXPAND</code>
         *        </p>
         *        <p>
         *        Some template contain macros. Macros perform custom processing on templates; this can include simple
         *        actions like find-and-replace operations, all the way to extensive transformations of entire
         *        templates. Because of this, users typically create a change set from the processed template, so that
         *        they can review the changes resulting from the macros before actually updating the stack. If your
         *        stack template contains one or more macros, and you choose to update a stack directly from the
         *        processed template, without first reviewing the resulting changes in a change set, you must
         *        acknowledge this capability. This includes the <a href=
         *        "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/create-reusable-transform-function-snippets-and-add-to-your-template-with-aws-include-transform.html"
         *        >AWS::Include</a> and <a
         *        href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/transform-aws-serverless.html"
         *        >AWS::Serverless</a> transforms, which are macros hosted by CloudFormation.
         *        </p>
         *        <p>
         *        If you want to update a stack from a stack template that contains macros <i>and</i> nested stacks, you
         *        must update the stack directly from the template using this capability.
         *        </p>
         *        <important>
         *        <p>
         *        You should only update stacks directly from a stack template that contains macros if you know what
         *        processing the macro performs.
         *        </p>
         *        <p>
         *        Each macro relies on an underlying Lambda service function for processing stack templates. Be aware
         *        that the Lambda function owner can update the function operation without CloudFormation being
         *        notified.
         *        </p>
         *        </important>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-macros.html">Perform
         *        custom processing on CloudFormation templates with template macros</a>.
         *        </p>
         *        </li>
         *        </ul>
         *        <note>
         *        <p>
         *        Only one of the <code>Capabilities</code> and <code>ResourceType</code> parameters can be specified.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capabilities(Capability... capabilities);

        /**
         * <p>
         * The template resource types that you have permissions to work with for this update stack action, such as
         * <code>AWS::EC2::Instance</code>, <code>AWS::EC2::*</code>, or <code>Custom::MyCustomInstance</code>.
         * </p>
         * <p>
         * If the list of resource types doesn't include a resource that you're updating, the stack update fails. By
         * default, CloudFormation grants permissions to all resource types. IAM uses this parameter for
         * CloudFormation-specific condition keys in IAM policies. For more information, see <a
         * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html">Control access
         * with Identity and Access Management</a>.
         * </p>
         * <note>
         * <p>
         * Only one of the <code>Capabilities</code> and <code>ResourceType</code> parameters can be specified.
         * </p>
         * </note>
         * 
         * @param resourceTypes
         *        The template resource types that you have permissions to work with for this update stack action, such
         *        as <code>AWS::EC2::Instance</code>, <code>AWS::EC2::*</code>, or <code>Custom::MyCustomInstance</code>
         *        .</p>
         *        <p>
         *        If the list of resource types doesn't include a resource that you're updating, the stack update fails.
         *        By default, CloudFormation grants permissions to all resource types. IAM uses this parameter for
         *        CloudFormation-specific condition keys in IAM policies. For more information, see <a
         *        href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html">Control
         *        access with Identity and Access Management</a>.
         *        </p>
         *        <note>
         *        <p>
         *        Only one of the <code>Capabilities</code> and <code>ResourceType</code> parameters can be specified.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceTypes(Collection<String> resourceTypes);

        /**
         * <p>
         * The template resource types that you have permissions to work with for this update stack action, such as
         * <code>AWS::EC2::Instance</code>, <code>AWS::EC2::*</code>, or <code>Custom::MyCustomInstance</code>.
         * </p>
         * <p>
         * If the list of resource types doesn't include a resource that you're updating, the stack update fails. By
         * default, CloudFormation grants permissions to all resource types. IAM uses this parameter for
         * CloudFormation-specific condition keys in IAM policies. For more information, see <a
         * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html">Control access
         * with Identity and Access Management</a>.
         * </p>
         * <note>
         * <p>
         * Only one of the <code>Capabilities</code> and <code>ResourceType</code> parameters can be specified.
         * </p>
         * </note>
         * 
         * @param resourceTypes
         *        The template resource types that you have permissions to work with for this update stack action, such
         *        as <code>AWS::EC2::Instance</code>, <code>AWS::EC2::*</code>, or <code>Custom::MyCustomInstance</code>
         *        .</p>
         *        <p>
         *        If the list of resource types doesn't include a resource that you're updating, the stack update fails.
         *        By default, CloudFormation grants permissions to all resource types. IAM uses this parameter for
         *        CloudFormation-specific condition keys in IAM policies. For more information, see <a
         *        href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html">Control
         *        access with Identity and Access Management</a>.
         *        </p>
         *        <note>
         *        <p>
         *        Only one of the <code>Capabilities</code> and <code>ResourceType</code> parameters can be specified.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceTypes(String... resourceTypes);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of an IAM role that CloudFormation assumes to update the stack. CloudFormation
         * uses the role's credentials to make calls on your behalf. CloudFormation always uses this role for all future
         * operations on the stack. Provided that users have permission to operate on the stack, CloudFormation uses
         * this role even if the users don't have permission to pass it. Ensure that the role grants least privilege.
         * </p>
         * <p>
         * If you don't specify a value, CloudFormation uses the role that was previously associated with the stack. If
         * no role is available, CloudFormation uses a temporary session that is generated from your user credentials.
         * </p>
         * 
         * @param roleARN
         *        The Amazon Resource Name (ARN) of an IAM role that CloudFormation assumes to update the stack.
         *        CloudFormation uses the role's credentials to make calls on your behalf. CloudFormation always uses
         *        this role for all future operations on the stack. Provided that users have permission to operate on
         *        the stack, CloudFormation uses this role even if the users don't have permission to pass it. Ensure
         *        that the role grants least privilege.</p>
         *        <p>
         *        If you don't specify a value, CloudFormation uses the role that was previously associated with the
         *        stack. If no role is available, CloudFormation uses a temporary session that is generated from your
         *        user credentials.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleARN(String roleARN);

        /**
         * <p>
         * The rollback triggers for CloudFormation to monitor during stack creation and updating operations, and for
         * the specified monitoring period afterwards.
         * </p>
         * 
         * @param rollbackConfiguration
         *        The rollback triggers for CloudFormation to monitor during stack creation and updating operations, and
         *        for the specified monitoring period afterwards.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rollbackConfiguration(RollbackConfiguration rollbackConfiguration);

        /**
         * <p>
         * The rollback triggers for CloudFormation to monitor during stack creation and updating operations, and for
         * the specified monitoring period afterwards.
         * </p>
         * This is a convenience method that creates an instance of the {@link RollbackConfiguration.Builder} avoiding
         * the need to create one manually via {@link RollbackConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RollbackConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #rollbackConfiguration(RollbackConfiguration)}.
         * 
         * @param rollbackConfiguration
         *        a consumer that will call methods on {@link RollbackConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #rollbackConfiguration(RollbackConfiguration)
         */
        default Builder rollbackConfiguration(Consumer<RollbackConfiguration.Builder> rollbackConfiguration) {
            return rollbackConfiguration(RollbackConfiguration.builder().applyMutation(rollbackConfiguration).build());
        }

        /**
         * <p>
         * Structure containing a new stack policy body. You can specify either the <code>StackPolicyBody</code> or the
         * <code>StackPolicyURL</code> parameter, but not both.
         * </p>
         * <p>
         * You might update the stack policy, for example, in order to protect a new resource that you created during a
         * stack update. If you don't specify a stack policy, the current policy that is associated with the stack is
         * unchanged.
         * </p>
         * 
         * @param stackPolicyBody
         *        Structure containing a new stack policy body. You can specify either the <code>StackPolicyBody</code>
         *        or the <code>StackPolicyURL</code> parameter, but not both.</p>
         *        <p>
         *        You might update the stack policy, for example, in order to protect a new resource that you created
         *        during a stack update. If you don't specify a stack policy, the current policy that is associated with
         *        the stack is unchanged.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stackPolicyBody(String stackPolicyBody);

        /**
         * <p>
         * Location of a file containing the updated stack policy. The URL must point to a policy (max size: 16KB)
         * located in an S3 bucket in the same Region as the stack. The location for an Amazon S3 bucket must start with
         * <code>https://</code>. You can specify either the <code>StackPolicyBody</code> or the
         * <code>StackPolicyURL</code> parameter, but not both.
         * </p>
         * <p>
         * You might update the stack policy, for example, in order to protect a new resource that you created during a
         * stack update. If you don't specify a stack policy, the current policy that is associated with the stack is
         * unchanged.
         * </p>
         * 
         * @param stackPolicyURL
         *        Location of a file containing the updated stack policy. The URL must point to a policy (max size:
         *        16KB) located in an S3 bucket in the same Region as the stack. The location for an Amazon S3 bucket
         *        must start with <code>https://</code>. You can specify either the <code>StackPolicyBody</code> or the
         *        <code>StackPolicyURL</code> parameter, but not both.</p>
         *        <p>
         *        You might update the stack policy, for example, in order to protect a new resource that you created
         *        during a stack update. If you don't specify a stack policy, the current policy that is associated with
         *        the stack is unchanged.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stackPolicyURL(String stackPolicyURL);

        /**
         * <p>
         * Amazon Simple Notification Service topic Amazon Resource Names (ARNs) that CloudFormation associates with the
         * stack. Specify an empty list to remove all notification topics.
         * </p>
         * 
         * @param notificationARNs
         *        Amazon Simple Notification Service topic Amazon Resource Names (ARNs) that CloudFormation associates
         *        with the stack. Specify an empty list to remove all notification topics.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notificationARNs(Collection<String> notificationARNs);

        /**
         * <p>
         * Amazon Simple Notification Service topic Amazon Resource Names (ARNs) that CloudFormation associates with the
         * stack. Specify an empty list to remove all notification topics.
         * </p>
         * 
         * @param notificationARNs
         *        Amazon Simple Notification Service topic Amazon Resource Names (ARNs) that CloudFormation associates
         *        with the stack. Specify an empty list to remove all notification topics.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notificationARNs(String... notificationARNs);

        /**
         * <p>
         * Key-value pairs to associate with this stack. CloudFormation also propagates these tags to supported
         * resources in the stack. You can specify a maximum number of 50 tags.
         * </p>
         * <p>
         * If you don't specify this parameter, CloudFormation doesn't modify the stack's tags. If you specify an empty
         * value, CloudFormation removes all associated tags.
         * </p>
         * 
         * @param tags
         *        Key-value pairs to associate with this stack. CloudFormation also propagates these tags to supported
         *        resources in the stack. You can specify a maximum number of 50 tags.</p>
         *        <p>
         *        If you don't specify this parameter, CloudFormation doesn't modify the stack's tags. If you specify an
         *        empty value, CloudFormation removes all associated tags.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * Key-value pairs to associate with this stack. CloudFormation also propagates these tags to supported
         * resources in the stack. You can specify a maximum number of 50 tags.
         * </p>
         * <p>
         * If you don't specify this parameter, CloudFormation doesn't modify the stack's tags. If you specify an empty
         * value, CloudFormation removes all associated tags.
         * </p>
         * 
         * @param tags
         *        Key-value pairs to associate with this stack. CloudFormation also propagates these tags to supported
         *        resources in the stack. You can specify a maximum number of 50 tags.</p>
         *        <p>
         *        If you don't specify this parameter, CloudFormation doesn't modify the stack's tags. If you specify an
         *        empty value, CloudFormation removes all associated tags.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * Key-value pairs to associate with this stack. CloudFormation also propagates these tags to supported
         * resources in the stack. You can specify a maximum number of 50 tags.
         * </p>
         * <p>
         * If you don't specify this parameter, CloudFormation doesn't modify the stack's tags. If you specify an empty
         * value, CloudFormation removes all associated tags.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.cloudformation.model.Tag.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.cloudformation.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.cloudformation.model.Tag.Builder#build()} is called immediately and
         * its result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.cloudformation.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        /**
         * <p>
         * Preserve the state of previously provisioned resources when an operation fails.
         * </p>
         * <p>
         * Default: <code>False</code>
         * </p>
         * 
         * @param disableRollback
         *        Preserve the state of previously provisioned resources when an operation fails.</p>
         *        <p>
         *        Default: <code>False</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder disableRollback(Boolean disableRollback);

        /**
         * <p>
         * A unique identifier for this <code>UpdateStack</code> request. Specify this token if you plan to retry
         * requests so that CloudFormation knows that you're not attempting to update a stack with the same name. You
         * might retry <code>UpdateStack</code> requests to ensure that CloudFormation successfully received them.
         * </p>
         * <p>
         * All events triggered by a given stack operation are assigned the same client request token, which you can use
         * to track operations. For example, if you execute a <code>CreateStack</code> operation with the token
         * <code>token1</code>, then all the <code>StackEvents</code> generated by that operation will have
         * <code>ClientRequestToken</code> set as <code>token1</code>.
         * </p>
         * <p>
         * In the console, stack operations display the client request token on the Events tab. Stack operations that
         * are initiated from the console use the token format <i>Console-StackOperation-ID</i>, which helps you easily
         * identify the stack operation . For example, if you create a stack using the console, each stack event would
         * be assigned the same token in the following format:
         * <code>Console-CreateStack-7f59c3cf-00d2-40c7-b2ff-e75db0987002</code>.
         * </p>
         * 
         * @param clientRequestToken
         *        A unique identifier for this <code>UpdateStack</code> request. Specify this token if you plan to retry
         *        requests so that CloudFormation knows that you're not attempting to update a stack with the same name.
         *        You might retry <code>UpdateStack</code> requests to ensure that CloudFormation successfully received
         *        them.</p>
         *        <p>
         *        All events triggered by a given stack operation are assigned the same client request token, which you
         *        can use to track operations. For example, if you execute a <code>CreateStack</code> operation with the
         *        token <code>token1</code>, then all the <code>StackEvents</code> generated by that operation will have
         *        <code>ClientRequestToken</code> set as <code>token1</code>.
         *        </p>
         *        <p>
         *        In the console, stack operations display the client request token on the Events tab. Stack operations
         *        that are initiated from the console use the token format <i>Console-StackOperation-ID</i>, which helps
         *        you easily identify the stack operation . For example, if you create a stack using the console, each
         *        stack event would be assigned the same token in the following format:
         *        <code>Console-CreateStack-7f59c3cf-00d2-40c7-b2ff-e75db0987002</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientRequestToken(String clientRequestToken);

        /**
         * <p>
         * When set to <code>true</code>, newly created resources are deleted when the operation rolls back. This
         * includes newly created resources marked with a deletion policy of <code>Retain</code>.
         * </p>
         * <p>
         * Default: <code>false</code>
         * </p>
         * 
         * @param retainExceptOnCreate
         *        When set to <code>true</code>, newly created resources are deleted when the operation rolls back. This
         *        includes newly created resources marked with a deletion policy of <code>Retain</code>.</p>
         *        <p>
         *        Default: <code>false</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder retainExceptOnCreate(Boolean retainExceptOnCreate);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CloudFormationRequest.BuilderImpl implements Builder {
        private String stackName;

        private String templateBody;

        private String templateURL;

        private Boolean usePreviousTemplate;

        private String stackPolicyDuringUpdateBody;

        private String stackPolicyDuringUpdateURL;

        private List<Parameter> parameters = DefaultSdkAutoConstructList.getInstance();

        private List<String> capabilities = DefaultSdkAutoConstructList.getInstance();

        private List<String> resourceTypes = DefaultSdkAutoConstructList.getInstance();

        private String roleARN;

        private RollbackConfiguration rollbackConfiguration;

        private String stackPolicyBody;

        private String stackPolicyURL;

        private List<String> notificationARNs = DefaultSdkAutoConstructList.getInstance();

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private Boolean disableRollback;

        private String clientRequestToken;

        private Boolean retainExceptOnCreate;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateStackRequest model) {
            super(model);
            stackName(model.stackName);
            templateBody(model.templateBody);
            templateURL(model.templateURL);
            usePreviousTemplate(model.usePreviousTemplate);
            stackPolicyDuringUpdateBody(model.stackPolicyDuringUpdateBody);
            stackPolicyDuringUpdateURL(model.stackPolicyDuringUpdateURL);
            parameters(model.parameters);
            capabilitiesWithStrings(model.capabilities);
            resourceTypes(model.resourceTypes);
            roleARN(model.roleARN);
            rollbackConfiguration(model.rollbackConfiguration);
            stackPolicyBody(model.stackPolicyBody);
            stackPolicyURL(model.stackPolicyURL);
            notificationARNs(model.notificationARNs);
            tags(model.tags);
            disableRollback(model.disableRollback);
            clientRequestToken(model.clientRequestToken);
            retainExceptOnCreate(model.retainExceptOnCreate);
        }

        public final String getStackName() {
            return stackName;
        }

        public final void setStackName(String stackName) {
            this.stackName = stackName;
        }

        @Override
        public final Builder stackName(String stackName) {
            this.stackName = stackName;
            return this;
        }

        public final String getTemplateBody() {
            return templateBody;
        }

        public final void setTemplateBody(String templateBody) {
            this.templateBody = templateBody;
        }

        @Override
        public final Builder templateBody(String templateBody) {
            this.templateBody = templateBody;
            return this;
        }

        public final String getTemplateURL() {
            return templateURL;
        }

        public final void setTemplateURL(String templateURL) {
            this.templateURL = templateURL;
        }

        @Override
        public final Builder templateURL(String templateURL) {
            this.templateURL = templateURL;
            return this;
        }

        public final Boolean getUsePreviousTemplate() {
            return usePreviousTemplate;
        }

        public final void setUsePreviousTemplate(Boolean usePreviousTemplate) {
            this.usePreviousTemplate = usePreviousTemplate;
        }

        @Override
        public final Builder usePreviousTemplate(Boolean usePreviousTemplate) {
            this.usePreviousTemplate = usePreviousTemplate;
            return this;
        }

        public final String getStackPolicyDuringUpdateBody() {
            return stackPolicyDuringUpdateBody;
        }

        public final void setStackPolicyDuringUpdateBody(String stackPolicyDuringUpdateBody) {
            this.stackPolicyDuringUpdateBody = stackPolicyDuringUpdateBody;
        }

        @Override
        public final Builder stackPolicyDuringUpdateBody(String stackPolicyDuringUpdateBody) {
            this.stackPolicyDuringUpdateBody = stackPolicyDuringUpdateBody;
            return this;
        }

        public final String getStackPolicyDuringUpdateURL() {
            return stackPolicyDuringUpdateURL;
        }

        public final void setStackPolicyDuringUpdateURL(String stackPolicyDuringUpdateURL) {
            this.stackPolicyDuringUpdateURL = stackPolicyDuringUpdateURL;
        }

        @Override
        public final Builder stackPolicyDuringUpdateURL(String stackPolicyDuringUpdateURL) {
            this.stackPolicyDuringUpdateURL = stackPolicyDuringUpdateURL;
            return this;
        }

        public final List<Parameter.Builder> getParameters() {
            List<Parameter.Builder> result = ParametersCopier.copyToBuilder(this.parameters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setParameters(Collection<Parameter.BuilderImpl> parameters) {
            this.parameters = ParametersCopier.copyFromBuilder(parameters);
        }

        @Override
        public final Builder parameters(Collection<Parameter> parameters) {
            this.parameters = ParametersCopier.copy(parameters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameters(Parameter... parameters) {
            parameters(Arrays.asList(parameters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameters(Consumer<Parameter.Builder>... parameters) {
            parameters(Stream.of(parameters).map(c -> Parameter.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getCapabilities() {
            if (capabilities instanceof SdkAutoConstructList) {
                return null;
            }
            return capabilities;
        }

        public final void setCapabilities(Collection<String> capabilities) {
            this.capabilities = CapabilitiesCopier.copy(capabilities);
        }

        @Override
        public final Builder capabilitiesWithStrings(Collection<String> capabilities) {
            this.capabilities = CapabilitiesCopier.copy(capabilities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder capabilitiesWithStrings(String... capabilities) {
            capabilitiesWithStrings(Arrays.asList(capabilities));
            return this;
        }

        @Override
        public final Builder capabilities(Collection<Capability> capabilities) {
            this.capabilities = CapabilitiesCopier.copyEnumToString(capabilities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder capabilities(Capability... capabilities) {
            capabilities(Arrays.asList(capabilities));
            return this;
        }

        public final Collection<String> getResourceTypes() {
            if (resourceTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return resourceTypes;
        }

        public final void setResourceTypes(Collection<String> resourceTypes) {
            this.resourceTypes = ResourceTypesCopier.copy(resourceTypes);
        }

        @Override
        public final Builder resourceTypes(Collection<String> resourceTypes) {
            this.resourceTypes = ResourceTypesCopier.copy(resourceTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceTypes(String... resourceTypes) {
            resourceTypes(Arrays.asList(resourceTypes));
            return this;
        }

        public final String getRoleARN() {
            return roleARN;
        }

        public final void setRoleARN(String roleARN) {
            this.roleARN = roleARN;
        }

        @Override
        public final Builder roleARN(String roleARN) {
            this.roleARN = roleARN;
            return this;
        }

        public final RollbackConfiguration.Builder getRollbackConfiguration() {
            return rollbackConfiguration != null ? rollbackConfiguration.toBuilder() : null;
        }

        public final void setRollbackConfiguration(RollbackConfiguration.BuilderImpl rollbackConfiguration) {
            this.rollbackConfiguration = rollbackConfiguration != null ? rollbackConfiguration.build() : null;
        }

        @Override
        public final Builder rollbackConfiguration(RollbackConfiguration rollbackConfiguration) {
            this.rollbackConfiguration = rollbackConfiguration;
            return this;
        }

        public final String getStackPolicyBody() {
            return stackPolicyBody;
        }

        public final void setStackPolicyBody(String stackPolicyBody) {
            this.stackPolicyBody = stackPolicyBody;
        }

        @Override
        public final Builder stackPolicyBody(String stackPolicyBody) {
            this.stackPolicyBody = stackPolicyBody;
            return this;
        }

        public final String getStackPolicyURL() {
            return stackPolicyURL;
        }

        public final void setStackPolicyURL(String stackPolicyURL) {
            this.stackPolicyURL = stackPolicyURL;
        }

        @Override
        public final Builder stackPolicyURL(String stackPolicyURL) {
            this.stackPolicyURL = stackPolicyURL;
            return this;
        }

        public final Collection<String> getNotificationARNs() {
            if (notificationARNs instanceof SdkAutoConstructList) {
                return null;
            }
            return notificationARNs;
        }

        public final void setNotificationARNs(Collection<String> notificationARNs) {
            this.notificationARNs = NotificationARNsCopier.copy(notificationARNs);
        }

        @Override
        public final Builder notificationARNs(Collection<String> notificationARNs) {
            this.notificationARNs = NotificationARNsCopier.copy(notificationARNs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder notificationARNs(String... notificationARNs) {
            notificationARNs(Arrays.asList(notificationARNs));
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagsCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagsCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Boolean getDisableRollback() {
            return disableRollback;
        }

        public final void setDisableRollback(Boolean disableRollback) {
            this.disableRollback = disableRollback;
        }

        @Override
        public final Builder disableRollback(Boolean disableRollback) {
            this.disableRollback = disableRollback;
            return this;
        }

        public final String getClientRequestToken() {
            return clientRequestToken;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        public final Boolean getRetainExceptOnCreate() {
            return retainExceptOnCreate;
        }

        public final void setRetainExceptOnCreate(Boolean retainExceptOnCreate) {
            this.retainExceptOnCreate = retainExceptOnCreate;
        }

        @Override
        public final Builder retainExceptOnCreate(Boolean retainExceptOnCreate) {
            this.retainExceptOnCreate = retainExceptOnCreate;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateStackRequest build() {
            return new UpdateStackRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
