/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudformation.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ImportStacksToStackSetRequest extends CloudFormationRequest implements
        ToCopyableBuilder<ImportStacksToStackSetRequest.Builder, ImportStacksToStackSetRequest> {
    private static final SdkField<String> STACK_SET_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StackSetName").getter(getter(ImportStacksToStackSetRequest::stackSetName))
            .setter(setter(Builder::stackSetName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StackSetName").build()).build();

    private static final SdkField<List<String>> STACK_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("StackIds")
            .getter(getter(ImportStacksToStackSetRequest::stackIds))
            .setter(setter(Builder::stackIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StackIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> STACK_IDS_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StackIdsUrl").getter(getter(ImportStacksToStackSetRequest::stackIdsUrl))
            .setter(setter(Builder::stackIdsUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StackIdsUrl").build()).build();

    private static final SdkField<List<String>> ORGANIZATIONAL_UNIT_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("OrganizationalUnitIds")
            .getter(getter(ImportStacksToStackSetRequest::organizationalUnitIds))
            .setter(setter(Builder::organizationalUnitIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrganizationalUnitIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<StackSetOperationPreferences> OPERATION_PREFERENCES_FIELD = SdkField
            .<StackSetOperationPreferences> builder(MarshallingType.SDK_POJO).memberName("OperationPreferences")
            .getter(getter(ImportStacksToStackSetRequest::operationPreferences)).setter(setter(Builder::operationPreferences))
            .constructor(StackSetOperationPreferences::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OperationPreferences").build())
            .build();

    private static final SdkField<String> OPERATION_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("OperationId")
            .getter(getter(ImportStacksToStackSetRequest::operationId))
            .setter(setter(Builder::operationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OperationId").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<String> CALL_AS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("CallAs")
            .getter(getter(ImportStacksToStackSetRequest::callAsAsString)).setter(setter(Builder::callAs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CallAs").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STACK_SET_NAME_FIELD,
            STACK_IDS_FIELD, STACK_IDS_URL_FIELD, ORGANIZATIONAL_UNIT_IDS_FIELD, OPERATION_PREFERENCES_FIELD, OPERATION_ID_FIELD,
            CALL_AS_FIELD));

    private final String stackSetName;

    private final List<String> stackIds;

    private final String stackIdsUrl;

    private final List<String> organizationalUnitIds;

    private final StackSetOperationPreferences operationPreferences;

    private final String operationId;

    private final String callAs;

    private ImportStacksToStackSetRequest(BuilderImpl builder) {
        super(builder);
        this.stackSetName = builder.stackSetName;
        this.stackIds = builder.stackIds;
        this.stackIdsUrl = builder.stackIdsUrl;
        this.organizationalUnitIds = builder.organizationalUnitIds;
        this.operationPreferences = builder.operationPreferences;
        this.operationId = builder.operationId;
        this.callAs = builder.callAs;
    }

    /**
     * <p>
     * The name of the stack set. The name must be unique in the Region where you create your stack set.
     * </p>
     * 
     * @return The name of the stack set. The name must be unique in the Region where you create your stack set.
     */
    public final String stackSetName() {
        return stackSetName;
    }

    /**
     * For responses, this returns true if the service returned a value for the StackIds property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasStackIds() {
        return stackIds != null && !(stackIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The IDs of the stacks you are importing into a stack set. You import up to 10 stacks per stack set at a time.
     * </p>
     * <p>
     * Specify either <code>StackIds</code> or <code>StackIdsUrl</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasStackIds} method.
     * </p>
     * 
     * @return The IDs of the stacks you are importing into a stack set. You import up to 10 stacks per stack set at a
     *         time.</p>
     *         <p>
     *         Specify either <code>StackIds</code> or <code>StackIdsUrl</code>.
     */
    public final List<String> stackIds() {
        return stackIds;
    }

    /**
     * <p>
     * The Amazon S3 URL which contains list of stack ids to be inputted.
     * </p>
     * <p>
     * Specify either <code>StackIds</code> or <code>StackIdsUrl</code>.
     * </p>
     * 
     * @return The Amazon S3 URL which contains list of stack ids to be inputted.</p>
     *         <p>
     *         Specify either <code>StackIds</code> or <code>StackIdsUrl</code>.
     */
    public final String stackIdsUrl() {
        return stackIdsUrl;
    }

    /**
     * For responses, this returns true if the service returned a value for the OrganizationalUnitIds property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasOrganizationalUnitIds() {
        return organizationalUnitIds != null && !(organizationalUnitIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of OU ID's to which the stacks being imported has to be mapped as deployment target.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasOrganizationalUnitIds} method.
     * </p>
     * 
     * @return The list of OU ID's to which the stacks being imported has to be mapped as deployment target.
     */
    public final List<String> organizationalUnitIds() {
        return organizationalUnitIds;
    }

    /**
     * <p>
     * The user-specified preferences for how CloudFormation performs a stack set operation.
     * </p>
     * <p>
     * For more information about maximum concurrent accounts and failure tolerance, see <a href=
     * "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/what-is-cfnstacksets.html#stackset-ops-options"
     * >Stack set operation options</a>.
     * </p>
     * 
     * @return The user-specified preferences for how CloudFormation performs a stack set operation.</p>
     *         <p>
     *         For more information about maximum concurrent accounts and failure tolerance, see <a href=
     *         "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/what-is-cfnstacksets.html#stackset-ops-options"
     *         >Stack set operation options</a>.
     */
    public final StackSetOperationPreferences operationPreferences() {
        return operationPreferences;
    }

    /**
     * <p>
     * A unique, user defined, identifier for the stack set operation.
     * </p>
     * 
     * @return A unique, user defined, identifier for the stack set operation.
     */
    public final String operationId() {
        return operationId;
    }

    /**
     * <p>
     * By default, <code>SELF</code> is specified. Use <code>SELF</code> for stack sets with self-managed permissions.
     * </p>
     * <ul>
     * <li>
     * <p>
     * If you are signed in to the management account, specify <code>SELF</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * For service managed stack sets, specify <code>DELEGATED_ADMIN</code>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #callAs} will
     * return {@link CallAs#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #callAsAsString}.
     * </p>
     * 
     * @return By default, <code>SELF</code> is specified. Use <code>SELF</code> for stack sets with self-managed
     *         permissions.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         If you are signed in to the management account, specify <code>SELF</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For service managed stack sets, specify <code>DELEGATED_ADMIN</code>.
     *         </p>
     *         </li>
     * @see CallAs
     */
    public final CallAs callAs() {
        return CallAs.fromValue(callAs);
    }

    /**
     * <p>
     * By default, <code>SELF</code> is specified. Use <code>SELF</code> for stack sets with self-managed permissions.
     * </p>
     * <ul>
     * <li>
     * <p>
     * If you are signed in to the management account, specify <code>SELF</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * For service managed stack sets, specify <code>DELEGATED_ADMIN</code>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #callAs} will
     * return {@link CallAs#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #callAsAsString}.
     * </p>
     * 
     * @return By default, <code>SELF</code> is specified. Use <code>SELF</code> for stack sets with self-managed
     *         permissions.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         If you are signed in to the management account, specify <code>SELF</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For service managed stack sets, specify <code>DELEGATED_ADMIN</code>.
     *         </p>
     *         </li>
     * @see CallAs
     */
    public final String callAsAsString() {
        return callAs;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(stackSetName());
        hashCode = 31 * hashCode + Objects.hashCode(hasStackIds() ? stackIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(stackIdsUrl());
        hashCode = 31 * hashCode + Objects.hashCode(hasOrganizationalUnitIds() ? organizationalUnitIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(operationPreferences());
        hashCode = 31 * hashCode + Objects.hashCode(operationId());
        hashCode = 31 * hashCode + Objects.hashCode(callAsAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImportStacksToStackSetRequest)) {
            return false;
        }
        ImportStacksToStackSetRequest other = (ImportStacksToStackSetRequest) obj;
        return Objects.equals(stackSetName(), other.stackSetName()) && hasStackIds() == other.hasStackIds()
                && Objects.equals(stackIds(), other.stackIds()) && Objects.equals(stackIdsUrl(), other.stackIdsUrl())
                && hasOrganizationalUnitIds() == other.hasOrganizationalUnitIds()
                && Objects.equals(organizationalUnitIds(), other.organizationalUnitIds())
                && Objects.equals(operationPreferences(), other.operationPreferences())
                && Objects.equals(operationId(), other.operationId()) && Objects.equals(callAsAsString(), other.callAsAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ImportStacksToStackSetRequest").add("StackSetName", stackSetName())
                .add("StackIds", hasStackIds() ? stackIds() : null).add("StackIdsUrl", stackIdsUrl())
                .add("OrganizationalUnitIds", hasOrganizationalUnitIds() ? organizationalUnitIds() : null)
                .add("OperationPreferences", operationPreferences()).add("OperationId", operationId())
                .add("CallAs", callAsAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StackSetName":
            return Optional.ofNullable(clazz.cast(stackSetName()));
        case "StackIds":
            return Optional.ofNullable(clazz.cast(stackIds()));
        case "StackIdsUrl":
            return Optional.ofNullable(clazz.cast(stackIdsUrl()));
        case "OrganizationalUnitIds":
            return Optional.ofNullable(clazz.cast(organizationalUnitIds()));
        case "OperationPreferences":
            return Optional.ofNullable(clazz.cast(operationPreferences()));
        case "OperationId":
            return Optional.ofNullable(clazz.cast(operationId()));
        case "CallAs":
            return Optional.ofNullable(clazz.cast(callAsAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ImportStacksToStackSetRequest, T> g) {
        return obj -> g.apply((ImportStacksToStackSetRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudFormationRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, ImportStacksToStackSetRequest> {
        /**
         * <p>
         * The name of the stack set. The name must be unique in the Region where you create your stack set.
         * </p>
         * 
         * @param stackSetName
         *        The name of the stack set. The name must be unique in the Region where you create your stack set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stackSetName(String stackSetName);

        /**
         * <p>
         * The IDs of the stacks you are importing into a stack set. You import up to 10 stacks per stack set at a time.
         * </p>
         * <p>
         * Specify either <code>StackIds</code> or <code>StackIdsUrl</code>.
         * </p>
         * 
         * @param stackIds
         *        The IDs of the stacks you are importing into a stack set. You import up to 10 stacks per stack set at
         *        a time.</p>
         *        <p>
         *        Specify either <code>StackIds</code> or <code>StackIdsUrl</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stackIds(Collection<String> stackIds);

        /**
         * <p>
         * The IDs of the stacks you are importing into a stack set. You import up to 10 stacks per stack set at a time.
         * </p>
         * <p>
         * Specify either <code>StackIds</code> or <code>StackIdsUrl</code>.
         * </p>
         * 
         * @param stackIds
         *        The IDs of the stacks you are importing into a stack set. You import up to 10 stacks per stack set at
         *        a time.</p>
         *        <p>
         *        Specify either <code>StackIds</code> or <code>StackIdsUrl</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stackIds(String... stackIds);

        /**
         * <p>
         * The Amazon S3 URL which contains list of stack ids to be inputted.
         * </p>
         * <p>
         * Specify either <code>StackIds</code> or <code>StackIdsUrl</code>.
         * </p>
         * 
         * @param stackIdsUrl
         *        The Amazon S3 URL which contains list of stack ids to be inputted.</p>
         *        <p>
         *        Specify either <code>StackIds</code> or <code>StackIdsUrl</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stackIdsUrl(String stackIdsUrl);

        /**
         * <p>
         * The list of OU ID's to which the stacks being imported has to be mapped as deployment target.
         * </p>
         * 
         * @param organizationalUnitIds
         *        The list of OU ID's to which the stacks being imported has to be mapped as deployment target.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder organizationalUnitIds(Collection<String> organizationalUnitIds);

        /**
         * <p>
         * The list of OU ID's to which the stacks being imported has to be mapped as deployment target.
         * </p>
         * 
         * @param organizationalUnitIds
         *        The list of OU ID's to which the stacks being imported has to be mapped as deployment target.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder organizationalUnitIds(String... organizationalUnitIds);

        /**
         * <p>
         * The user-specified preferences for how CloudFormation performs a stack set operation.
         * </p>
         * <p>
         * For more information about maximum concurrent accounts and failure tolerance, see <a href=
         * "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/what-is-cfnstacksets.html#stackset-ops-options"
         * >Stack set operation options</a>.
         * </p>
         * 
         * @param operationPreferences
         *        The user-specified preferences for how CloudFormation performs a stack set operation.</p>
         *        <p>
         *        For more information about maximum concurrent accounts and failure tolerance, see <a href=
         *        "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/what-is-cfnstacksets.html#stackset-ops-options"
         *        >Stack set operation options</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder operationPreferences(StackSetOperationPreferences operationPreferences);

        /**
         * <p>
         * The user-specified preferences for how CloudFormation performs a stack set operation.
         * </p>
         * <p>
         * For more information about maximum concurrent accounts and failure tolerance, see <a href=
         * "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/what-is-cfnstacksets.html#stackset-ops-options"
         * >Stack set operation options</a>.
         * </p>
         * This is a convenience method that creates an instance of the {@link StackSetOperationPreferences.Builder}
         * avoiding the need to create one manually via {@link StackSetOperationPreferences#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link StackSetOperationPreferences.Builder#build()} is called
         * immediately and its result is passed to {@link #operationPreferences(StackSetOperationPreferences)}.
         * 
         * @param operationPreferences
         *        a consumer that will call methods on {@link StackSetOperationPreferences.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #operationPreferences(StackSetOperationPreferences)
         */
        default Builder operationPreferences(Consumer<StackSetOperationPreferences.Builder> operationPreferences) {
            return operationPreferences(StackSetOperationPreferences.builder().applyMutation(operationPreferences).build());
        }

        /**
         * <p>
         * A unique, user defined, identifier for the stack set operation.
         * </p>
         * 
         * @param operationId
         *        A unique, user defined, identifier for the stack set operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder operationId(String operationId);

        /**
         * <p>
         * By default, <code>SELF</code> is specified. Use <code>SELF</code> for stack sets with self-managed
         * permissions.
         * </p>
         * <ul>
         * <li>
         * <p>
         * If you are signed in to the management account, specify <code>SELF</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * For service managed stack sets, specify <code>DELEGATED_ADMIN</code>.
         * </p>
         * </li>
         * </ul>
         * 
         * @param callAs
         *        By default, <code>SELF</code> is specified. Use <code>SELF</code> for stack sets with self-managed
         *        permissions.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        If you are signed in to the management account, specify <code>SELF</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        For service managed stack sets, specify <code>DELEGATED_ADMIN</code>.
         *        </p>
         *        </li>
         * @see CallAs
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CallAs
         */
        Builder callAs(String callAs);

        /**
         * <p>
         * By default, <code>SELF</code> is specified. Use <code>SELF</code> for stack sets with self-managed
         * permissions.
         * </p>
         * <ul>
         * <li>
         * <p>
         * If you are signed in to the management account, specify <code>SELF</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * For service managed stack sets, specify <code>DELEGATED_ADMIN</code>.
         * </p>
         * </li>
         * </ul>
         * 
         * @param callAs
         *        By default, <code>SELF</code> is specified. Use <code>SELF</code> for stack sets with self-managed
         *        permissions.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        If you are signed in to the management account, specify <code>SELF</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        For service managed stack sets, specify <code>DELEGATED_ADMIN</code>.
         *        </p>
         *        </li>
         * @see CallAs
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CallAs
         */
        Builder callAs(CallAs callAs);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CloudFormationRequest.BuilderImpl implements Builder {
        private String stackSetName;

        private List<String> stackIds = DefaultSdkAutoConstructList.getInstance();

        private String stackIdsUrl;

        private List<String> organizationalUnitIds = DefaultSdkAutoConstructList.getInstance();

        private StackSetOperationPreferences operationPreferences;

        private String operationId;

        private String callAs;

        private BuilderImpl() {
        }

        private BuilderImpl(ImportStacksToStackSetRequest model) {
            super(model);
            stackSetName(model.stackSetName);
            stackIds(model.stackIds);
            stackIdsUrl(model.stackIdsUrl);
            organizationalUnitIds(model.organizationalUnitIds);
            operationPreferences(model.operationPreferences);
            operationId(model.operationId);
            callAs(model.callAs);
        }

        public final String getStackSetName() {
            return stackSetName;
        }

        public final void setStackSetName(String stackSetName) {
            this.stackSetName = stackSetName;
        }

        @Override
        public final Builder stackSetName(String stackSetName) {
            this.stackSetName = stackSetName;
            return this;
        }

        public final Collection<String> getStackIds() {
            if (stackIds instanceof SdkAutoConstructList) {
                return null;
            }
            return stackIds;
        }

        public final void setStackIds(Collection<String> stackIds) {
            this.stackIds = StackIdListCopier.copy(stackIds);
        }

        @Override
        public final Builder stackIds(Collection<String> stackIds) {
            this.stackIds = StackIdListCopier.copy(stackIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stackIds(String... stackIds) {
            stackIds(Arrays.asList(stackIds));
            return this;
        }

        public final String getStackIdsUrl() {
            return stackIdsUrl;
        }

        public final void setStackIdsUrl(String stackIdsUrl) {
            this.stackIdsUrl = stackIdsUrl;
        }

        @Override
        public final Builder stackIdsUrl(String stackIdsUrl) {
            this.stackIdsUrl = stackIdsUrl;
            return this;
        }

        public final Collection<String> getOrganizationalUnitIds() {
            if (organizationalUnitIds instanceof SdkAutoConstructList) {
                return null;
            }
            return organizationalUnitIds;
        }

        public final void setOrganizationalUnitIds(Collection<String> organizationalUnitIds) {
            this.organizationalUnitIds = OrganizationalUnitIdListCopier.copy(organizationalUnitIds);
        }

        @Override
        public final Builder organizationalUnitIds(Collection<String> organizationalUnitIds) {
            this.organizationalUnitIds = OrganizationalUnitIdListCopier.copy(organizationalUnitIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder organizationalUnitIds(String... organizationalUnitIds) {
            organizationalUnitIds(Arrays.asList(organizationalUnitIds));
            return this;
        }

        public final StackSetOperationPreferences.Builder getOperationPreferences() {
            return operationPreferences != null ? operationPreferences.toBuilder() : null;
        }

        public final void setOperationPreferences(StackSetOperationPreferences.BuilderImpl operationPreferences) {
            this.operationPreferences = operationPreferences != null ? operationPreferences.build() : null;
        }

        @Override
        public final Builder operationPreferences(StackSetOperationPreferences operationPreferences) {
            this.operationPreferences = operationPreferences;
            return this;
        }

        public final String getOperationId() {
            return operationId;
        }

        public final void setOperationId(String operationId) {
            this.operationId = operationId;
        }

        @Override
        public final Builder operationId(String operationId) {
            this.operationId = operationId;
            return this;
        }

        public final String getCallAs() {
            return callAs;
        }

        public final void setCallAs(String callAs) {
            this.callAs = callAs;
        }

        @Override
        public final Builder callAs(String callAs) {
            this.callAs = callAs;
            return this;
        }

        @Override
        public final Builder callAs(CallAs callAs) {
            this.callAs(callAs == null ? null : callAs.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ImportStacksToStackSetRequest build() {
            return new ImportStacksToStackSetRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
