/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudformation.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Options for the <code>GetTemplateSummary</code> API action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TemplateSummaryConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<TemplateSummaryConfig.Builder, TemplateSummaryConfig> {
    private static final SdkField<Boolean> TREAT_UNRECOGNIZED_RESOURCE_TYPES_AS_WARNINGS_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("TreatUnrecognizedResourceTypesAsWarnings")
            .getter(getter(TemplateSummaryConfig::treatUnrecognizedResourceTypesAsWarnings))
            .setter(setter(Builder::treatUnrecognizedResourceTypesAsWarnings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("TreatUnrecognizedResourceTypesAsWarnings").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(TREAT_UNRECOGNIZED_RESOURCE_TYPES_AS_WARNINGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("TreatUnrecognizedResourceTypesAsWarnings", TREAT_UNRECOGNIZED_RESOURCE_TYPES_AS_WARNINGS_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final Boolean treatUnrecognizedResourceTypesAsWarnings;

    private TemplateSummaryConfig(BuilderImpl builder) {
        this.treatUnrecognizedResourceTypesAsWarnings = builder.treatUnrecognizedResourceTypesAsWarnings;
    }

    /**
     * <p>
     * If set to <code>True</code>, any unrecognized resource types generate warnings and not an error. Any unrecognized
     * resource types are returned in the <code>Warnings</code> output parameter.
     * </p>
     * 
     * @return If set to <code>True</code>, any unrecognized resource types generate warnings and not an error. Any
     *         unrecognized resource types are returned in the <code>Warnings</code> output parameter.
     */
    public final Boolean treatUnrecognizedResourceTypesAsWarnings() {
        return treatUnrecognizedResourceTypesAsWarnings;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(treatUnrecognizedResourceTypesAsWarnings());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TemplateSummaryConfig)) {
            return false;
        }
        TemplateSummaryConfig other = (TemplateSummaryConfig) obj;
        return Objects.equals(treatUnrecognizedResourceTypesAsWarnings(), other.treatUnrecognizedResourceTypesAsWarnings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TemplateSummaryConfig")
                .add("TreatUnrecognizedResourceTypesAsWarnings", treatUnrecognizedResourceTypesAsWarnings()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TreatUnrecognizedResourceTypesAsWarnings":
            return Optional.ofNullable(clazz.cast(treatUnrecognizedResourceTypesAsWarnings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<TemplateSummaryConfig, T> g) {
        return obj -> g.apply((TemplateSummaryConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TemplateSummaryConfig> {
        /**
         * <p>
         * If set to <code>True</code>, any unrecognized resource types generate warnings and not an error. Any
         * unrecognized resource types are returned in the <code>Warnings</code> output parameter.
         * </p>
         * 
         * @param treatUnrecognizedResourceTypesAsWarnings
         *        If set to <code>True</code>, any unrecognized resource types generate warnings and not an error. Any
         *        unrecognized resource types are returned in the <code>Warnings</code> output parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder treatUnrecognizedResourceTypesAsWarnings(Boolean treatUnrecognizedResourceTypesAsWarnings);
    }

    static final class BuilderImpl implements Builder {
        private Boolean treatUnrecognizedResourceTypesAsWarnings;

        private BuilderImpl() {
        }

        private BuilderImpl(TemplateSummaryConfig model) {
            treatUnrecognizedResourceTypesAsWarnings(model.treatUnrecognizedResourceTypesAsWarnings);
        }

        public final Boolean getTreatUnrecognizedResourceTypesAsWarnings() {
            return treatUnrecognizedResourceTypesAsWarnings;
        }

        public final void setTreatUnrecognizedResourceTypesAsWarnings(Boolean treatUnrecognizedResourceTypesAsWarnings) {
            this.treatUnrecognizedResourceTypesAsWarnings = treatUnrecognizedResourceTypesAsWarnings;
        }

        @Override
        public final Builder treatUnrecognizedResourceTypesAsWarnings(Boolean treatUnrecognizedResourceTypesAsWarnings) {
            this.treatUnrecognizedResourceTypesAsWarnings = treatUnrecognizedResourceTypesAsWarnings;
            return this;
        }

        @Override
        public TemplateSummaryConfig build() {
            return new TemplateSummaryConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
