/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TemplateProgress
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TemplateProgress> {
    private static final SdkField<Integer> RESOURCES_SUCCEEDED_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ResourcesSucceeded").getter(TemplateProgress.getter(TemplateProgress::resourcesSucceeded)).setter(TemplateProgress.setter(Builder::resourcesSucceeded)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourcesSucceeded").build()}).build();
    private static final SdkField<Integer> RESOURCES_FAILED_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ResourcesFailed").getter(TemplateProgress.getter(TemplateProgress::resourcesFailed)).setter(TemplateProgress.setter(Builder::resourcesFailed)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourcesFailed").build()}).build();
    private static final SdkField<Integer> RESOURCES_PROCESSING_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ResourcesProcessing").getter(TemplateProgress.getter(TemplateProgress::resourcesProcessing)).setter(TemplateProgress.setter(Builder::resourcesProcessing)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourcesProcessing").build()}).build();
    private static final SdkField<Integer> RESOURCES_PENDING_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ResourcesPending").getter(TemplateProgress.getter(TemplateProgress::resourcesPending)).setter(TemplateProgress.setter(Builder::resourcesPending)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourcesPending").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCES_SUCCEEDED_FIELD, RESOURCES_FAILED_FIELD, RESOURCES_PROCESSING_FIELD, RESOURCES_PENDING_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("ResourcesSucceeded", RESOURCES_SUCCEEDED_FIELD);
            this.put("ResourcesFailed", RESOURCES_FAILED_FIELD);
            this.put("ResourcesProcessing", RESOURCES_PROCESSING_FIELD);
            this.put("ResourcesPending", RESOURCES_PENDING_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final Integer resourcesSucceeded;
    private final Integer resourcesFailed;
    private final Integer resourcesProcessing;
    private final Integer resourcesPending;

    private TemplateProgress(BuilderImpl builder) {
        this.resourcesSucceeded = builder.resourcesSucceeded;
        this.resourcesFailed = builder.resourcesFailed;
        this.resourcesProcessing = builder.resourcesProcessing;
        this.resourcesPending = builder.resourcesPending;
    }

    public final Integer resourcesSucceeded() {
        return this.resourcesSucceeded;
    }

    public final Integer resourcesFailed() {
        return this.resourcesFailed;
    }

    public final Integer resourcesProcessing() {
        return this.resourcesProcessing;
    }

    public final Integer resourcesPending() {
        return this.resourcesPending;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.resourcesSucceeded());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourcesFailed());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourcesProcessing());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourcesPending());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TemplateProgress)) {
            return false;
        }
        TemplateProgress other = (TemplateProgress)obj;
        return Objects.equals(this.resourcesSucceeded(), other.resourcesSucceeded()) && Objects.equals(this.resourcesFailed(), other.resourcesFailed()) && Objects.equals(this.resourcesProcessing(), other.resourcesProcessing()) && Objects.equals(this.resourcesPending(), other.resourcesPending());
    }

    public final String toString() {
        return ToString.builder((String)"TemplateProgress").add("ResourcesSucceeded", (Object)this.resourcesSucceeded()).add("ResourcesFailed", (Object)this.resourcesFailed()).add("ResourcesProcessing", (Object)this.resourcesProcessing()).add("ResourcesPending", (Object)this.resourcesPending()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ResourcesSucceeded": {
                return Optional.ofNullable(clazz.cast(this.resourcesSucceeded()));
            }
            case "ResourcesFailed": {
                return Optional.ofNullable(clazz.cast(this.resourcesFailed()));
            }
            case "ResourcesProcessing": {
                return Optional.ofNullable(clazz.cast(this.resourcesProcessing()));
            }
            case "ResourcesPending": {
                return Optional.ofNullable(clazz.cast(this.resourcesPending()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<TemplateProgress, T> g) {
        return obj -> g.apply((TemplateProgress)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer resourcesSucceeded;
        private Integer resourcesFailed;
        private Integer resourcesProcessing;
        private Integer resourcesPending;

        private BuilderImpl() {
        }

        private BuilderImpl(TemplateProgress model) {
            this.resourcesSucceeded(model.resourcesSucceeded);
            this.resourcesFailed(model.resourcesFailed);
            this.resourcesProcessing(model.resourcesProcessing);
            this.resourcesPending(model.resourcesPending);
        }

        public final Integer getResourcesSucceeded() {
            return this.resourcesSucceeded;
        }

        public final void setResourcesSucceeded(Integer resourcesSucceeded) {
            this.resourcesSucceeded = resourcesSucceeded;
        }

        @Override
        public final Builder resourcesSucceeded(Integer resourcesSucceeded) {
            this.resourcesSucceeded = resourcesSucceeded;
            return this;
        }

        public final Integer getResourcesFailed() {
            return this.resourcesFailed;
        }

        public final void setResourcesFailed(Integer resourcesFailed) {
            this.resourcesFailed = resourcesFailed;
        }

        @Override
        public final Builder resourcesFailed(Integer resourcesFailed) {
            this.resourcesFailed = resourcesFailed;
            return this;
        }

        public final Integer getResourcesProcessing() {
            return this.resourcesProcessing;
        }

        public final void setResourcesProcessing(Integer resourcesProcessing) {
            this.resourcesProcessing = resourcesProcessing;
        }

        @Override
        public final Builder resourcesProcessing(Integer resourcesProcessing) {
            this.resourcesProcessing = resourcesProcessing;
            return this;
        }

        public final Integer getResourcesPending() {
            return this.resourcesPending;
        }

        public final void setResourcesPending(Integer resourcesPending) {
            this.resourcesPending = resourcesPending;
        }

        @Override
        public final Builder resourcesPending(Integer resourcesPending) {
            this.resourcesPending = resourcesPending;
            return this;
        }

        public TemplateProgress build() {
            return new TemplateProgress(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TemplateProgress> {
        public Builder resourcesSucceeded(Integer var1);

        public Builder resourcesFailed(Integer var1);

        public Builder resourcesProcessing(Integer var1);

        public Builder resourcesPending(Integer var1);
    }
}

