/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudformation.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The input for a <a>GetTemplate</a> action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetTemplateRequest extends CloudFormationRequest implements
        ToCopyableBuilder<GetTemplateRequest.Builder, GetTemplateRequest> {
    private static final SdkField<String> STACK_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetTemplateRequest::stackName)).setter(setter(Builder::stackName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StackName").build()).build();

    private static final SdkField<String> CHANGE_SET_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetTemplateRequest::changeSetName)).setter(setter(Builder::changeSetName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChangeSetName").build()).build();

    private static final SdkField<String> TEMPLATE_STAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetTemplateRequest::templateStageAsString)).setter(setter(Builder::templateStage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TemplateStage").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STACK_NAME_FIELD,
            CHANGE_SET_NAME_FIELD, TEMPLATE_STAGE_FIELD));

    private final String stackName;

    private final String changeSetName;

    private final String templateStage;

    private GetTemplateRequest(BuilderImpl builder) {
        super(builder);
        this.stackName = builder.stackName;
        this.changeSetName = builder.changeSetName;
        this.templateStage = builder.templateStage;
    }

    /**
     * <p>
     * The name or the unique stack ID that is associated with the stack, which are not always interchangeable:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Running stacks: You can specify either the stack's name or its unique stack ID.
     * </p>
     * </li>
     * <li>
     * <p>
     * Deleted stacks: You must specify the unique stack ID.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Default: There is no default value.
     * </p>
     * 
     * @return The name or the unique stack ID that is associated with the stack, which are not always
     *         interchangeable:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Running stacks: You can specify either the stack's name or its unique stack ID.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Deleted stacks: You must specify the unique stack ID.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         Default: There is no default value.
     */
    public String stackName() {
        return stackName;
    }

    /**
     * <p>
     * The name or Amazon Resource Name (ARN) of a change set for which AWS CloudFormation returns the associated
     * template. If you specify a name, you must also specify the <code>StackName</code>.
     * </p>
     * 
     * @return The name or Amazon Resource Name (ARN) of a change set for which AWS CloudFormation returns the
     *         associated template. If you specify a name, you must also specify the <code>StackName</code>.
     */
    public String changeSetName() {
        return changeSetName;
    }

    /**
     * <p>
     * For templates that include transforms, the stage of the template that AWS CloudFormation returns. To get the
     * user-submitted template, specify <code>Original</code>. To get the template after AWS CloudFormation has
     * processed all transforms, specify <code>Processed</code>.
     * </p>
     * <p>
     * If the template doesn't include transforms, <code>Original</code> and <code>Processed</code> return the same
     * template. By default, AWS CloudFormation specifies <code>Original</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #templateStage}
     * will return {@link TemplateStage#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #templateStageAsString}.
     * </p>
     * 
     * @return For templates that include transforms, the stage of the template that AWS CloudFormation returns. To get
     *         the user-submitted template, specify <code>Original</code>. To get the template after AWS CloudFormation
     *         has processed all transforms, specify <code>Processed</code>. </p>
     *         <p>
     *         If the template doesn't include transforms, <code>Original</code> and <code>Processed</code> return the
     *         same template. By default, AWS CloudFormation specifies <code>Original</code>.
     * @see TemplateStage
     */
    public TemplateStage templateStage() {
        return TemplateStage.fromValue(templateStage);
    }

    /**
     * <p>
     * For templates that include transforms, the stage of the template that AWS CloudFormation returns. To get the
     * user-submitted template, specify <code>Original</code>. To get the template after AWS CloudFormation has
     * processed all transforms, specify <code>Processed</code>.
     * </p>
     * <p>
     * If the template doesn't include transforms, <code>Original</code> and <code>Processed</code> return the same
     * template. By default, AWS CloudFormation specifies <code>Original</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #templateStage}
     * will return {@link TemplateStage#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #templateStageAsString}.
     * </p>
     * 
     * @return For templates that include transforms, the stage of the template that AWS CloudFormation returns. To get
     *         the user-submitted template, specify <code>Original</code>. To get the template after AWS CloudFormation
     *         has processed all transforms, specify <code>Processed</code>. </p>
     *         <p>
     *         If the template doesn't include transforms, <code>Original</code> and <code>Processed</code> return the
     *         same template. By default, AWS CloudFormation specifies <code>Original</code>.
     * @see TemplateStage
     */
    public String templateStageAsString() {
        return templateStage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(stackName());
        hashCode = 31 * hashCode + Objects.hashCode(changeSetName());
        hashCode = 31 * hashCode + Objects.hashCode(templateStageAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetTemplateRequest)) {
            return false;
        }
        GetTemplateRequest other = (GetTemplateRequest) obj;
        return Objects.equals(stackName(), other.stackName()) && Objects.equals(changeSetName(), other.changeSetName())
                && Objects.equals(templateStageAsString(), other.templateStageAsString());
    }

    @Override
    public String toString() {
        return ToString.builder("GetTemplateRequest").add("StackName", stackName()).add("ChangeSetName", changeSetName())
                .add("TemplateStage", templateStageAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StackName":
            return Optional.ofNullable(clazz.cast(stackName()));
        case "ChangeSetName":
            return Optional.ofNullable(clazz.cast(changeSetName()));
        case "TemplateStage":
            return Optional.ofNullable(clazz.cast(templateStageAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetTemplateRequest, T> g) {
        return obj -> g.apply((GetTemplateRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudFormationRequest.Builder, SdkPojo, CopyableBuilder<Builder, GetTemplateRequest> {
        /**
         * <p>
         * The name or the unique stack ID that is associated with the stack, which are not always interchangeable:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Running stacks: You can specify either the stack's name or its unique stack ID.
         * </p>
         * </li>
         * <li>
         * <p>
         * Deleted stacks: You must specify the unique stack ID.
         * </p>
         * </li>
         * </ul>
         * <p>
         * Default: There is no default value.
         * </p>
         * 
         * @param stackName
         *        The name or the unique stack ID that is associated with the stack, which are not always
         *        interchangeable:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        Running stacks: You can specify either the stack's name or its unique stack ID.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Deleted stacks: You must specify the unique stack ID.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        Default: There is no default value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stackName(String stackName);

        /**
         * <p>
         * The name or Amazon Resource Name (ARN) of a change set for which AWS CloudFormation returns the associated
         * template. If you specify a name, you must also specify the <code>StackName</code>.
         * </p>
         * 
         * @param changeSetName
         *        The name or Amazon Resource Name (ARN) of a change set for which AWS CloudFormation returns the
         *        associated template. If you specify a name, you must also specify the <code>StackName</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder changeSetName(String changeSetName);

        /**
         * <p>
         * For templates that include transforms, the stage of the template that AWS CloudFormation returns. To get the
         * user-submitted template, specify <code>Original</code>. To get the template after AWS CloudFormation has
         * processed all transforms, specify <code>Processed</code>.
         * </p>
         * <p>
         * If the template doesn't include transforms, <code>Original</code> and <code>Processed</code> return the same
         * template. By default, AWS CloudFormation specifies <code>Original</code>.
         * </p>
         * 
         * @param templateStage
         *        For templates that include transforms, the stage of the template that AWS CloudFormation returns. To
         *        get the user-submitted template, specify <code>Original</code>. To get the template after AWS
         *        CloudFormation has processed all transforms, specify <code>Processed</code>. </p>
         *        <p>
         *        If the template doesn't include transforms, <code>Original</code> and <code>Processed</code> return
         *        the same template. By default, AWS CloudFormation specifies <code>Original</code>.
         * @see TemplateStage
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TemplateStage
         */
        Builder templateStage(String templateStage);

        /**
         * <p>
         * For templates that include transforms, the stage of the template that AWS CloudFormation returns. To get the
         * user-submitted template, specify <code>Original</code>. To get the template after AWS CloudFormation has
         * processed all transforms, specify <code>Processed</code>.
         * </p>
         * <p>
         * If the template doesn't include transforms, <code>Original</code> and <code>Processed</code> return the same
         * template. By default, AWS CloudFormation specifies <code>Original</code>.
         * </p>
         * 
         * @param templateStage
         *        For templates that include transforms, the stage of the template that AWS CloudFormation returns. To
         *        get the user-submitted template, specify <code>Original</code>. To get the template after AWS
         *        CloudFormation has processed all transforms, specify <code>Processed</code>. </p>
         *        <p>
         *        If the template doesn't include transforms, <code>Original</code> and <code>Processed</code> return
         *        the same template. By default, AWS CloudFormation specifies <code>Original</code>.
         * @see TemplateStage
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TemplateStage
         */
        Builder templateStage(TemplateStage templateStage);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CloudFormationRequest.BuilderImpl implements Builder {
        private String stackName;

        private String changeSetName;

        private String templateStage;

        private BuilderImpl() {
        }

        private BuilderImpl(GetTemplateRequest model) {
            super(model);
            stackName(model.stackName);
            changeSetName(model.changeSetName);
            templateStage(model.templateStage);
        }

        public final String getStackName() {
            return stackName;
        }

        @Override
        public final Builder stackName(String stackName) {
            this.stackName = stackName;
            return this;
        }

        public final void setStackName(String stackName) {
            this.stackName = stackName;
        }

        public final String getChangeSetName() {
            return changeSetName;
        }

        @Override
        public final Builder changeSetName(String changeSetName) {
            this.changeSetName = changeSetName;
            return this;
        }

        public final void setChangeSetName(String changeSetName) {
            this.changeSetName = changeSetName;
        }

        public final String getTemplateStageAsString() {
            return templateStage;
        }

        @Override
        public final Builder templateStage(String templateStage) {
            this.templateStage = templateStage;
            return this;
        }

        @Override
        public final Builder templateStage(TemplateStage templateStage) {
            this.templateStage(templateStage.toString());
            return this;
        }

        public final void setTemplateStage(String templateStage) {
            this.templateStage = templateStage;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetTemplateRequest build() {
            return new GetTemplateRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
