/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudformation.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The TemplateParameter data type.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TemplateParameter implements SdkPojo, Serializable,
        ToCopyableBuilder<TemplateParameter.Builder, TemplateParameter> {
    private static final SdkField<String> PARAMETER_KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(TemplateParameter::parameterKey)).setter(setter(Builder::parameterKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParameterKey").build()).build();

    private static final SdkField<String> DEFAULT_VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(TemplateParameter::defaultValue)).setter(setter(Builder::defaultValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultValue").build()).build();

    private static final SdkField<Boolean> NO_ECHO_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(TemplateParameter::noEcho)).setter(setter(Builder::noEcho))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NoEcho").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(TemplateParameter::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PARAMETER_KEY_FIELD,
            DEFAULT_VALUE_FIELD, NO_ECHO_FIELD, DESCRIPTION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String parameterKey;

    private final String defaultValue;

    private final Boolean noEcho;

    private final String description;

    private TemplateParameter(BuilderImpl builder) {
        this.parameterKey = builder.parameterKey;
        this.defaultValue = builder.defaultValue;
        this.noEcho = builder.noEcho;
        this.description = builder.description;
    }

    /**
     * <p>
     * The name associated with the parameter.
     * </p>
     * 
     * @return The name associated with the parameter.
     */
    public String parameterKey() {
        return parameterKey;
    }

    /**
     * <p>
     * The default value associated with the parameter.
     * </p>
     * 
     * @return The default value associated with the parameter.
     */
    public String defaultValue() {
        return defaultValue;
    }

    /**
     * <p>
     * Flag indicating whether the parameter should be displayed as plain text in logs and UIs.
     * </p>
     * 
     * @return Flag indicating whether the parameter should be displayed as plain text in logs and UIs.
     */
    public Boolean noEcho() {
        return noEcho;
    }

    /**
     * <p>
     * User defined description associated with the parameter.
     * </p>
     * 
     * @return User defined description associated with the parameter.
     */
    public String description() {
        return description;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(parameterKey());
        hashCode = 31 * hashCode + Objects.hashCode(defaultValue());
        hashCode = 31 * hashCode + Objects.hashCode(noEcho());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TemplateParameter)) {
            return false;
        }
        TemplateParameter other = (TemplateParameter) obj;
        return Objects.equals(parameterKey(), other.parameterKey()) && Objects.equals(defaultValue(), other.defaultValue())
                && Objects.equals(noEcho(), other.noEcho()) && Objects.equals(description(), other.description());
    }

    @Override
    public String toString() {
        return ToString.builder("TemplateParameter").add("ParameterKey", parameterKey()).add("DefaultValue", defaultValue())
                .add("NoEcho", noEcho()).add("Description", description()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ParameterKey":
            return Optional.ofNullable(clazz.cast(parameterKey()));
        case "DefaultValue":
            return Optional.ofNullable(clazz.cast(defaultValue()));
        case "NoEcho":
            return Optional.ofNullable(clazz.cast(noEcho()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TemplateParameter, T> g) {
        return obj -> g.apply((TemplateParameter) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TemplateParameter> {
        /**
         * <p>
         * The name associated with the parameter.
         * </p>
         * 
         * @param parameterKey
         *        The name associated with the parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameterKey(String parameterKey);

        /**
         * <p>
         * The default value associated with the parameter.
         * </p>
         * 
         * @param defaultValue
         *        The default value associated with the parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultValue(String defaultValue);

        /**
         * <p>
         * Flag indicating whether the parameter should be displayed as plain text in logs and UIs.
         * </p>
         * 
         * @param noEcho
         *        Flag indicating whether the parameter should be displayed as plain text in logs and UIs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder noEcho(Boolean noEcho);

        /**
         * <p>
         * User defined description associated with the parameter.
         * </p>
         * 
         * @param description
         *        User defined description associated with the parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);
    }

    static final class BuilderImpl implements Builder {
        private String parameterKey;

        private String defaultValue;

        private Boolean noEcho;

        private String description;

        private BuilderImpl() {
        }

        private BuilderImpl(TemplateParameter model) {
            parameterKey(model.parameterKey);
            defaultValue(model.defaultValue);
            noEcho(model.noEcho);
            description(model.description);
        }

        public final String getParameterKey() {
            return parameterKey;
        }

        @Override
        public final Builder parameterKey(String parameterKey) {
            this.parameterKey = parameterKey;
            return this;
        }

        public final void setParameterKey(String parameterKey) {
            this.parameterKey = parameterKey;
        }

        public final String getDefaultValue() {
            return defaultValue;
        }

        @Override
        public final Builder defaultValue(String defaultValue) {
            this.defaultValue = defaultValue;
            return this;
        }

        public final void setDefaultValue(String defaultValue) {
            this.defaultValue = defaultValue;
        }

        public final Boolean getNoEcho() {
            return noEcho;
        }

        @Override
        public final Builder noEcho(Boolean noEcho) {
            this.noEcho = noEcho;
            return this;
        }

        public final void setNoEcho(Boolean noEcho) {
            this.noEcho = noEcho;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public TemplateParameter build() {
            return new TemplateParameter(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
