/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudformation.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribePublisherResponse extends CloudFormationResponse implements
        ToCopyableBuilder<DescribePublisherResponse.Builder, DescribePublisherResponse> {
    private static final SdkField<String> PUBLISHER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PublisherId").getter(getter(DescribePublisherResponse::publisherId))
            .setter(setter(Builder::publisherId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PublisherId").build()).build();

    private static final SdkField<String> PUBLISHER_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PublisherStatus").getter(getter(DescribePublisherResponse::publisherStatusAsString))
            .setter(setter(Builder::publisherStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PublisherStatus").build()).build();

    private static final SdkField<String> IDENTITY_PROVIDER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IdentityProvider").getter(getter(DescribePublisherResponse::identityProviderAsString))
            .setter(setter(Builder::identityProvider))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdentityProvider").build()).build();

    private static final SdkField<String> PUBLISHER_PROFILE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PublisherProfile").getter(getter(DescribePublisherResponse::publisherProfile))
            .setter(setter(Builder::publisherProfile))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PublisherProfile").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PUBLISHER_ID_FIELD,
            PUBLISHER_STATUS_FIELD, IDENTITY_PROVIDER_FIELD, PUBLISHER_PROFILE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String publisherId;

    private final String publisherStatus;

    private final String identityProvider;

    private final String publisherProfile;

    private DescribePublisherResponse(BuilderImpl builder) {
        super(builder);
        this.publisherId = builder.publisherId;
        this.publisherStatus = builder.publisherStatus;
        this.identityProvider = builder.identityProvider;
        this.publisherProfile = builder.publisherProfile;
    }

    /**
     * <p>
     * The ID of the extension publisher.
     * </p>
     * 
     * @return The ID of the extension publisher.
     */
    public final String publisherId() {
        return publisherId;
    }

    /**
     * <p>
     * Whether the publisher is verified. Currently, all registered publishers are verified.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #publisherStatus}
     * will return {@link PublisherStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #publisherStatusAsString}.
     * </p>
     * 
     * @return Whether the publisher is verified. Currently, all registered publishers are verified.
     * @see PublisherStatus
     */
    public final PublisherStatus publisherStatus() {
        return PublisherStatus.fromValue(publisherStatus);
    }

    /**
     * <p>
     * Whether the publisher is verified. Currently, all registered publishers are verified.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #publisherStatus}
     * will return {@link PublisherStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #publisherStatusAsString}.
     * </p>
     * 
     * @return Whether the publisher is verified. Currently, all registered publishers are verified.
     * @see PublisherStatus
     */
    public final String publisherStatusAsString() {
        return publisherStatus;
    }

    /**
     * <p>
     * The type of account used as the identity provider when registering this publisher with CloudFormation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #identityProvider}
     * will return {@link IdentityProvider#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #identityProviderAsString}.
     * </p>
     * 
     * @return The type of account used as the identity provider when registering this publisher with CloudFormation.
     * @see IdentityProvider
     */
    public final IdentityProvider identityProvider() {
        return IdentityProvider.fromValue(identityProvider);
    }

    /**
     * <p>
     * The type of account used as the identity provider when registering this publisher with CloudFormation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #identityProvider}
     * will return {@link IdentityProvider#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #identityProviderAsString}.
     * </p>
     * 
     * @return The type of account used as the identity provider when registering this publisher with CloudFormation.
     * @see IdentityProvider
     */
    public final String identityProviderAsString() {
        return identityProvider;
    }

    /**
     * <p>
     * The URL to the publisher's profile with the identity provider.
     * </p>
     * 
     * @return The URL to the publisher's profile with the identity provider.
     */
    public final String publisherProfile() {
        return publisherProfile;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(publisherId());
        hashCode = 31 * hashCode + Objects.hashCode(publisherStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(identityProviderAsString());
        hashCode = 31 * hashCode + Objects.hashCode(publisherProfile());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribePublisherResponse)) {
            return false;
        }
        DescribePublisherResponse other = (DescribePublisherResponse) obj;
        return Objects.equals(publisherId(), other.publisherId())
                && Objects.equals(publisherStatusAsString(), other.publisherStatusAsString())
                && Objects.equals(identityProviderAsString(), other.identityProviderAsString())
                && Objects.equals(publisherProfile(), other.publisherProfile());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribePublisherResponse").add("PublisherId", publisherId())
                .add("PublisherStatus", publisherStatusAsString()).add("IdentityProvider", identityProviderAsString())
                .add("PublisherProfile", publisherProfile()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PublisherId":
            return Optional.ofNullable(clazz.cast(publisherId()));
        case "PublisherStatus":
            return Optional.ofNullable(clazz.cast(publisherStatusAsString()));
        case "IdentityProvider":
            return Optional.ofNullable(clazz.cast(identityProviderAsString()));
        case "PublisherProfile":
            return Optional.ofNullable(clazz.cast(publisherProfile()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("PublisherId", PUBLISHER_ID_FIELD);
        map.put("PublisherStatus", PUBLISHER_STATUS_FIELD);
        map.put("IdentityProvider", IDENTITY_PROVIDER_FIELD);
        map.put("PublisherProfile", PUBLISHER_PROFILE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribePublisherResponse, T> g) {
        return obj -> g.apply((DescribePublisherResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudFormationResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribePublisherResponse> {
        /**
         * <p>
         * The ID of the extension publisher.
         * </p>
         * 
         * @param publisherId
         *        The ID of the extension publisher.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder publisherId(String publisherId);

        /**
         * <p>
         * Whether the publisher is verified. Currently, all registered publishers are verified.
         * </p>
         * 
         * @param publisherStatus
         *        Whether the publisher is verified. Currently, all registered publishers are verified.
         * @see PublisherStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PublisherStatus
         */
        Builder publisherStatus(String publisherStatus);

        /**
         * <p>
         * Whether the publisher is verified. Currently, all registered publishers are verified.
         * </p>
         * 
         * @param publisherStatus
         *        Whether the publisher is verified. Currently, all registered publishers are verified.
         * @see PublisherStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PublisherStatus
         */
        Builder publisherStatus(PublisherStatus publisherStatus);

        /**
         * <p>
         * The type of account used as the identity provider when registering this publisher with CloudFormation.
         * </p>
         * 
         * @param identityProvider
         *        The type of account used as the identity provider when registering this publisher with CloudFormation.
         * @see IdentityProvider
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IdentityProvider
         */
        Builder identityProvider(String identityProvider);

        /**
         * <p>
         * The type of account used as the identity provider when registering this publisher with CloudFormation.
         * </p>
         * 
         * @param identityProvider
         *        The type of account used as the identity provider when registering this publisher with CloudFormation.
         * @see IdentityProvider
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IdentityProvider
         */
        Builder identityProvider(IdentityProvider identityProvider);

        /**
         * <p>
         * The URL to the publisher's profile with the identity provider.
         * </p>
         * 
         * @param publisherProfile
         *        The URL to the publisher's profile with the identity provider.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder publisherProfile(String publisherProfile);
    }

    static final class BuilderImpl extends CloudFormationResponse.BuilderImpl implements Builder {
        private String publisherId;

        private String publisherStatus;

        private String identityProvider;

        private String publisherProfile;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribePublisherResponse model) {
            super(model);
            publisherId(model.publisherId);
            publisherStatus(model.publisherStatus);
            identityProvider(model.identityProvider);
            publisherProfile(model.publisherProfile);
        }

        public final String getPublisherId() {
            return publisherId;
        }

        public final void setPublisherId(String publisherId) {
            this.publisherId = publisherId;
        }

        @Override
        public final Builder publisherId(String publisherId) {
            this.publisherId = publisherId;
            return this;
        }

        public final String getPublisherStatus() {
            return publisherStatus;
        }

        public final void setPublisherStatus(String publisherStatus) {
            this.publisherStatus = publisherStatus;
        }

        @Override
        public final Builder publisherStatus(String publisherStatus) {
            this.publisherStatus = publisherStatus;
            return this;
        }

        @Override
        public final Builder publisherStatus(PublisherStatus publisherStatus) {
            this.publisherStatus(publisherStatus == null ? null : publisherStatus.toString());
            return this;
        }

        public final String getIdentityProvider() {
            return identityProvider;
        }

        public final void setIdentityProvider(String identityProvider) {
            this.identityProvider = identityProvider;
        }

        @Override
        public final Builder identityProvider(String identityProvider) {
            this.identityProvider = identityProvider;
            return this;
        }

        @Override
        public final Builder identityProvider(IdentityProvider identityProvider) {
            this.identityProvider(identityProvider == null ? null : identityProvider.toString());
            return this;
        }

        public final String getPublisherProfile() {
            return publisherProfile;
        }

        public final void setPublisherProfile(String publisherProfile) {
            this.publisherProfile = publisherProfile;
        }

        @Override
        public final Builder publisherProfile(String publisherProfile) {
            this.publisherProfile = publisherProfile;
            return this;
        }

        @Override
        public DescribePublisherResponse build() {
            return new DescribePublisherResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
