/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudformation.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains summary information about the specified CloudFormation extension.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TypeSummary implements SdkPojo, Serializable, ToCopyableBuilder<TypeSummary.Builder, TypeSummary> {
    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(TypeSummary::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final SdkField<String> TYPE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TypeName").getter(getter(TypeSummary::typeName)).setter(setter(Builder::typeName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TypeName").build()).build();

    private static final SdkField<String> DEFAULT_VERSION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DefaultVersionId").getter(getter(TypeSummary::defaultVersionId))
            .setter(setter(Builder::defaultVersionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultVersionId").build()).build();

    private static final SdkField<String> TYPE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TypeArn").getter(getter(TypeSummary::typeArn)).setter(setter(Builder::typeArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TypeArn").build()).build();

    private static final SdkField<Instant> LAST_UPDATED_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastUpdated").getter(getter(TypeSummary::lastUpdated)).setter(setter(Builder::lastUpdated))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdated").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(TypeSummary::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> PUBLISHER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PublisherId").getter(getter(TypeSummary::publisherId)).setter(setter(Builder::publisherId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PublisherId").build()).build();

    private static final SdkField<String> ORIGINAL_TYPE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OriginalTypeName").getter(getter(TypeSummary::originalTypeName))
            .setter(setter(Builder::originalTypeName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OriginalTypeName").build()).build();

    private static final SdkField<String> PUBLIC_VERSION_NUMBER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PublicVersionNumber").getter(getter(TypeSummary::publicVersionNumber))
            .setter(setter(Builder::publicVersionNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PublicVersionNumber").build())
            .build();

    private static final SdkField<String> LATEST_PUBLIC_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LatestPublicVersion").getter(getter(TypeSummary::latestPublicVersion))
            .setter(setter(Builder::latestPublicVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LatestPublicVersion").build())
            .build();

    private static final SdkField<String> PUBLISHER_IDENTITY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PublisherIdentity").getter(getter(TypeSummary::publisherIdentityAsString))
            .setter(setter(Builder::publisherIdentity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PublisherIdentity").build()).build();

    private static final SdkField<String> PUBLISHER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PublisherName").getter(getter(TypeSummary::publisherName)).setter(setter(Builder::publisherName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PublisherName").build()).build();

    private static final SdkField<Boolean> IS_ACTIVATED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("IsActivated").getter(getter(TypeSummary::isActivated)).setter(setter(Builder::isActivated))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsActivated").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD, TYPE_NAME_FIELD,
            DEFAULT_VERSION_ID_FIELD, TYPE_ARN_FIELD, LAST_UPDATED_FIELD, DESCRIPTION_FIELD, PUBLISHER_ID_FIELD,
            ORIGINAL_TYPE_NAME_FIELD, PUBLIC_VERSION_NUMBER_FIELD, LATEST_PUBLIC_VERSION_FIELD, PUBLISHER_IDENTITY_FIELD,
            PUBLISHER_NAME_FIELD, IS_ACTIVATED_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String type;

    private final String typeName;

    private final String defaultVersionId;

    private final String typeArn;

    private final Instant lastUpdated;

    private final String description;

    private final String publisherId;

    private final String originalTypeName;

    private final String publicVersionNumber;

    private final String latestPublicVersion;

    private final String publisherIdentity;

    private final String publisherName;

    private final Boolean isActivated;

    private TypeSummary(BuilderImpl builder) {
        this.type = builder.type;
        this.typeName = builder.typeName;
        this.defaultVersionId = builder.defaultVersionId;
        this.typeArn = builder.typeArn;
        this.lastUpdated = builder.lastUpdated;
        this.description = builder.description;
        this.publisherId = builder.publisherId;
        this.originalTypeName = builder.originalTypeName;
        this.publicVersionNumber = builder.publicVersionNumber;
        this.latestPublicVersion = builder.latestPublicVersion;
        this.publisherIdentity = builder.publisherIdentity;
        this.publisherName = builder.publisherName;
        this.isActivated = builder.isActivated;
    }

    /**
     * <p>
     * The kind of extension.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link RegistryType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The kind of extension.
     * @see RegistryType
     */
    public final RegistryType type() {
        return RegistryType.fromValue(type);
    }

    /**
     * <p>
     * The kind of extension.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link RegistryType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The kind of extension.
     * @see RegistryType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The name of the extension.
     * </p>
     * <p>
     * If you specified a <code>TypeNameAlias</code> when you call the <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_ActivateType.html">ActivateType</a>
     * API operation in your account and Region, CloudFormation considers that alias as the type name.
     * </p>
     * 
     * @return The name of the extension.</p>
     *         <p>
     *         If you specified a <code>TypeNameAlias</code> when you call the <a
     *         href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_ActivateType.html"
     *         >ActivateType</a> API operation in your account and Region, CloudFormation considers that alias as the
     *         type name.
     */
    public final String typeName() {
        return typeName;
    }

    /**
     * <p>
     * The ID of the default version of the extension. The default version is used when the extension version isn't
     * specified.
     * </p>
     * <p>
     * This applies only to private extensions you have registered in your account. For public extensions, both those
     * provided by Amazon and published by third parties, CloudFormation returns <code>null</code>. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_RegisterType.html">RegisterType</a>.
     * </p>
     * <p>
     * To set the default version of an extension, use <a>SetTypeDefaultVersion</a>.
     * </p>
     * 
     * @return The ID of the default version of the extension. The default version is used when the extension version
     *         isn't specified.</p>
     *         <p>
     *         This applies only to private extensions you have registered in your account. For public extensions, both
     *         those provided by Amazon and published by third parties, CloudFormation returns <code>null</code>. For
     *         more information, see <a
     *         href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_RegisterType.html"
     *         >RegisterType</a>.
     *         </p>
     *         <p>
     *         To set the default version of an extension, use <a>SetTypeDefaultVersion</a>.
     */
    public final String defaultVersionId() {
        return defaultVersionId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the extension.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the extension.
     */
    public final String typeArn() {
        return typeArn;
    }

    /**
     * <p>
     * When the specified extension version was registered. This applies only to:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Private extensions you have registered in your account. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_RegisterType.html">RegisterType</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Public extensions you have activated in your account with auto-update specified. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_ActivateType.html">ActivateType</a>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * For all other extension types, CloudFormation returns <code>null</code>.
     * </p>
     * 
     * @return When the specified extension version was registered. This applies only to:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Private extensions you have registered in your account. For more information, see <a
     *         href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_RegisterType.html"
     *         >RegisterType</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Public extensions you have activated in your account with auto-update specified. For more information,
     *         see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_ActivateType.html">
     *         ActivateType</a>.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For all other extension types, CloudFormation returns <code>null</code>.
     */
    public final Instant lastUpdated() {
        return lastUpdated;
    }

    /**
     * <p>
     * The description of the extension.
     * </p>
     * 
     * @return The description of the extension.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The ID of the extension publisher, if the extension is published by a third party. Extensions published by Amazon
     * don't return a publisher ID.
     * </p>
     * 
     * @return The ID of the extension publisher, if the extension is published by a third party. Extensions published
     *         by Amazon don't return a publisher ID.
     */
    public final String publisherId() {
        return publisherId;
    }

    /**
     * <p>
     * For public extensions that have been activated for this account and Region, the type name of the public
     * extension.
     * </p>
     * <p>
     * If you specified a <code>TypeNameAlias</code> when enabling the extension in this account and Region,
     * CloudFormation treats that alias as the extension's type name within the account and Region, not the type name of
     * the public extension. For more information, see <a href=
     * "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/registry-public.html#registry-public-enable-alias"
     * >Use aliases to refer to extensions</a> in the <i>CloudFormation User Guide</i>.
     * </p>
     * 
     * @return For public extensions that have been activated for this account and Region, the type name of the public
     *         extension.</p>
     *         <p>
     *         If you specified a <code>TypeNameAlias</code> when enabling the extension in this account and Region,
     *         CloudFormation treats that alias as the extension's type name within the account and Region, not the type
     *         name of the public extension. For more information, see <a href=
     *         "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/registry-public.html#registry-public-enable-alias"
     *         >Use aliases to refer to extensions</a> in the <i>CloudFormation User Guide</i>.
     */
    public final String originalTypeName() {
        return originalTypeName;
    }

    /**
     * <p>
     * For public extensions that have been activated for this account and Region, the version of the public extension
     * to be used for CloudFormation operations in this account and Region.
     * </p>
     * <p>
     * How you specified <code>AutoUpdate</code> when enabling the extension affects whether CloudFormation
     * automatically updates the extension in this account and Region when a new version is released. For more
     * information, see <a href=
     * "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/registry-public.html#registry-public-enable-auto"
     * >Automatically use new versions of extensions</a> in the <i>CloudFormation User Guide</i>.
     * </p>
     * 
     * @return For public extensions that have been activated for this account and Region, the version of the public
     *         extension to be used for CloudFormation operations in this account and Region.</p>
     *         <p>
     *         How you specified <code>AutoUpdate</code> when enabling the extension affects whether CloudFormation
     *         automatically updates the extension in this account and Region when a new version is released. For more
     *         information, see <a href=
     *         "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/registry-public.html#registry-public-enable-auto"
     *         >Automatically use new versions of extensions</a> in the <i>CloudFormation User Guide</i>.
     */
    public final String publicVersionNumber() {
        return publicVersionNumber;
    }

    /**
     * <p>
     * For public extensions that have been activated for this account and Region, the latest version of the public
     * extension <i>that is available</i>. For any extensions other than activated third-party extensions,
     * CloudFormation returns <code>null</code>.
     * </p>
     * <p>
     * How you specified <code>AutoUpdate</code> when enabling the extension affects whether CloudFormation
     * automatically updates the extension in this account and Region when a new version is released. For more
     * information, see <a href=
     * "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/registry-public.html#registry-public-enable-auto"
     * >Automatically use new versions of extensions</a> in the <i>CloudFormation User Guide</i>.
     * </p>
     * 
     * @return For public extensions that have been activated for this account and Region, the latest version of the
     *         public extension <i>that is available</i>. For any extensions other than activated third-party
     *         extensions, CloudFormation returns <code>null</code>.</p>
     *         <p>
     *         How you specified <code>AutoUpdate</code> when enabling the extension affects whether CloudFormation
     *         automatically updates the extension in this account and Region when a new version is released. For more
     *         information, see <a href=
     *         "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/registry-public.html#registry-public-enable-auto"
     *         >Automatically use new versions of extensions</a> in the <i>CloudFormation User Guide</i>.
     */
    public final String latestPublicVersion() {
        return latestPublicVersion;
    }

    /**
     * <p>
     * The service used to verify the publisher identity.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/publish-extension.html">Publishing
     * extensions to make them available for public use</a> in the <i>CloudFormation Command Line Interface (CLI) User
     * Guide</i>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #publisherIdentity}
     * will return {@link IdentityProvider#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #publisherIdentityAsString}.
     * </p>
     * 
     * @return The service used to verify the publisher identity.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/publish-extension.html">Publishing
     *         extensions to make them available for public use</a> in the <i>CloudFormation Command Line Interface
     *         (CLI) User Guide</i>.
     * @see IdentityProvider
     */
    public final IdentityProvider publisherIdentity() {
        return IdentityProvider.fromValue(publisherIdentity);
    }

    /**
     * <p>
     * The service used to verify the publisher identity.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/publish-extension.html">Publishing
     * extensions to make them available for public use</a> in the <i>CloudFormation Command Line Interface (CLI) User
     * Guide</i>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #publisherIdentity}
     * will return {@link IdentityProvider#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #publisherIdentityAsString}.
     * </p>
     * 
     * @return The service used to verify the publisher identity.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/publish-extension.html">Publishing
     *         extensions to make them available for public use</a> in the <i>CloudFormation Command Line Interface
     *         (CLI) User Guide</i>.
     * @see IdentityProvider
     */
    public final String publisherIdentityAsString() {
        return publisherIdentity;
    }

    /**
     * <p>
     * The publisher name, as defined in the public profile for that publisher in the service used to verify the
     * publisher identity.
     * </p>
     * 
     * @return The publisher name, as defined in the public profile for that publisher in the service used to verify the
     *         publisher identity.
     */
    public final String publisherName() {
        return publisherName;
    }

    /**
     * <p>
     * Whether the extension is activated for this account and Region.
     * </p>
     * <p>
     * This applies only to third-party public extensions. Extensions published by Amazon are activated by default.
     * </p>
     * 
     * @return Whether the extension is activated for this account and Region.</p>
     *         <p>
     *         This applies only to third-party public extensions. Extensions published by Amazon are activated by
     *         default.
     */
    public final Boolean isActivated() {
        return isActivated;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(typeName());
        hashCode = 31 * hashCode + Objects.hashCode(defaultVersionId());
        hashCode = 31 * hashCode + Objects.hashCode(typeArn());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdated());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(publisherId());
        hashCode = 31 * hashCode + Objects.hashCode(originalTypeName());
        hashCode = 31 * hashCode + Objects.hashCode(publicVersionNumber());
        hashCode = 31 * hashCode + Objects.hashCode(latestPublicVersion());
        hashCode = 31 * hashCode + Objects.hashCode(publisherIdentityAsString());
        hashCode = 31 * hashCode + Objects.hashCode(publisherName());
        hashCode = 31 * hashCode + Objects.hashCode(isActivated());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TypeSummary)) {
            return false;
        }
        TypeSummary other = (TypeSummary) obj;
        return Objects.equals(typeAsString(), other.typeAsString()) && Objects.equals(typeName(), other.typeName())
                && Objects.equals(defaultVersionId(), other.defaultVersionId()) && Objects.equals(typeArn(), other.typeArn())
                && Objects.equals(lastUpdated(), other.lastUpdated()) && Objects.equals(description(), other.description())
                && Objects.equals(publisherId(), other.publisherId())
                && Objects.equals(originalTypeName(), other.originalTypeName())
                && Objects.equals(publicVersionNumber(), other.publicVersionNumber())
                && Objects.equals(latestPublicVersion(), other.latestPublicVersion())
                && Objects.equals(publisherIdentityAsString(), other.publisherIdentityAsString())
                && Objects.equals(publisherName(), other.publisherName()) && Objects.equals(isActivated(), other.isActivated());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TypeSummary").add("Type", typeAsString()).add("TypeName", typeName())
                .add("DefaultVersionId", defaultVersionId()).add("TypeArn", typeArn()).add("LastUpdated", lastUpdated())
                .add("Description", description()).add("PublisherId", publisherId()).add("OriginalTypeName", originalTypeName())
                .add("PublicVersionNumber", publicVersionNumber()).add("LatestPublicVersion", latestPublicVersion())
                .add("PublisherIdentity", publisherIdentityAsString()).add("PublisherName", publisherName())
                .add("IsActivated", isActivated()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "TypeName":
            return Optional.ofNullable(clazz.cast(typeName()));
        case "DefaultVersionId":
            return Optional.ofNullable(clazz.cast(defaultVersionId()));
        case "TypeArn":
            return Optional.ofNullable(clazz.cast(typeArn()));
        case "LastUpdated":
            return Optional.ofNullable(clazz.cast(lastUpdated()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "PublisherId":
            return Optional.ofNullable(clazz.cast(publisherId()));
        case "OriginalTypeName":
            return Optional.ofNullable(clazz.cast(originalTypeName()));
        case "PublicVersionNumber":
            return Optional.ofNullable(clazz.cast(publicVersionNumber()));
        case "LatestPublicVersion":
            return Optional.ofNullable(clazz.cast(latestPublicVersion()));
        case "PublisherIdentity":
            return Optional.ofNullable(clazz.cast(publisherIdentityAsString()));
        case "PublisherName":
            return Optional.ofNullable(clazz.cast(publisherName()));
        case "IsActivated":
            return Optional.ofNullable(clazz.cast(isActivated()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Type", TYPE_FIELD);
        map.put("TypeName", TYPE_NAME_FIELD);
        map.put("DefaultVersionId", DEFAULT_VERSION_ID_FIELD);
        map.put("TypeArn", TYPE_ARN_FIELD);
        map.put("LastUpdated", LAST_UPDATED_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("PublisherId", PUBLISHER_ID_FIELD);
        map.put("OriginalTypeName", ORIGINAL_TYPE_NAME_FIELD);
        map.put("PublicVersionNumber", PUBLIC_VERSION_NUMBER_FIELD);
        map.put("LatestPublicVersion", LATEST_PUBLIC_VERSION_FIELD);
        map.put("PublisherIdentity", PUBLISHER_IDENTITY_FIELD);
        map.put("PublisherName", PUBLISHER_NAME_FIELD);
        map.put("IsActivated", IS_ACTIVATED_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TypeSummary, T> g) {
        return obj -> g.apply((TypeSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TypeSummary> {
        /**
         * <p>
         * The kind of extension.
         * </p>
         * 
         * @param type
         *        The kind of extension.
         * @see RegistryType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RegistryType
         */
        Builder type(String type);

        /**
         * <p>
         * The kind of extension.
         * </p>
         * 
         * @param type
         *        The kind of extension.
         * @see RegistryType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RegistryType
         */
        Builder type(RegistryType type);

        /**
         * <p>
         * The name of the extension.
         * </p>
         * <p>
         * If you specified a <code>TypeNameAlias</code> when you call the <a
         * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_ActivateType.html"
         * >ActivateType</a> API operation in your account and Region, CloudFormation considers that alias as the type
         * name.
         * </p>
         * 
         * @param typeName
         *        The name of the extension.</p>
         *        <p>
         *        If you specified a <code>TypeNameAlias</code> when you call the <a
         *        href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_ActivateType.html"
         *        >ActivateType</a> API operation in your account and Region, CloudFormation considers that alias as the
         *        type name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder typeName(String typeName);

        /**
         * <p>
         * The ID of the default version of the extension. The default version is used when the extension version isn't
         * specified.
         * </p>
         * <p>
         * This applies only to private extensions you have registered in your account. For public extensions, both
         * those provided by Amazon and published by third parties, CloudFormation returns <code>null</code>. For more
         * information, see <a
         * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_RegisterType.html"
         * >RegisterType</a>.
         * </p>
         * <p>
         * To set the default version of an extension, use <a>SetTypeDefaultVersion</a>.
         * </p>
         * 
         * @param defaultVersionId
         *        The ID of the default version of the extension. The default version is used when the extension version
         *        isn't specified.</p>
         *        <p>
         *        This applies only to private extensions you have registered in your account. For public extensions,
         *        both those provided by Amazon and published by third parties, CloudFormation returns <code>null</code>
         *        . For more information, see <a
         *        href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_RegisterType.html"
         *        >RegisterType</a>.
         *        </p>
         *        <p>
         *        To set the default version of an extension, use <a>SetTypeDefaultVersion</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultVersionId(String defaultVersionId);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the extension.
         * </p>
         * 
         * @param typeArn
         *        The Amazon Resource Name (ARN) of the extension.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder typeArn(String typeArn);

        /**
         * <p>
         * When the specified extension version was registered. This applies only to:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Private extensions you have registered in your account. For more information, see <a
         * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_RegisterType.html"
         * >RegisterType</a>.
         * </p>
         * </li>
         * <li>
         * <p>
         * Public extensions you have activated in your account with auto-update specified. For more information, see <a
         * href
         * ="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_ActivateType.html">ActivateType</a>.
         * </p>
         * </li>
         * </ul>
         * <p>
         * For all other extension types, CloudFormation returns <code>null</code>.
         * </p>
         * 
         * @param lastUpdated
         *        When the specified extension version was registered. This applies only to:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        Private extensions you have registered in your account. For more information, see <a
         *        href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_RegisterType.html"
         *        >RegisterType</a>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Public extensions you have activated in your account with auto-update specified. For more information,
         *        see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_ActivateType.html">
         *        ActivateType</a>.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        For all other extension types, CloudFormation returns <code>null</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdated(Instant lastUpdated);

        /**
         * <p>
         * The description of the extension.
         * </p>
         * 
         * @param description
         *        The description of the extension.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The ID of the extension publisher, if the extension is published by a third party. Extensions published by
         * Amazon don't return a publisher ID.
         * </p>
         * 
         * @param publisherId
         *        The ID of the extension publisher, if the extension is published by a third party. Extensions
         *        published by Amazon don't return a publisher ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder publisherId(String publisherId);

        /**
         * <p>
         * For public extensions that have been activated for this account and Region, the type name of the public
         * extension.
         * </p>
         * <p>
         * If you specified a <code>TypeNameAlias</code> when enabling the extension in this account and Region,
         * CloudFormation treats that alias as the extension's type name within the account and Region, not the type
         * name of the public extension. For more information, see <a href=
         * "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/registry-public.html#registry-public-enable-alias"
         * >Use aliases to refer to extensions</a> in the <i>CloudFormation User Guide</i>.
         * </p>
         * 
         * @param originalTypeName
         *        For public extensions that have been activated for this account and Region, the type name of the
         *        public extension.</p>
         *        <p>
         *        If you specified a <code>TypeNameAlias</code> when enabling the extension in this account and Region,
         *        CloudFormation treats that alias as the extension's type name within the account and Region, not the
         *        type name of the public extension. For more information, see <a href=
         *        "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/registry-public.html#registry-public-enable-alias"
         *        >Use aliases to refer to extensions</a> in the <i>CloudFormation User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder originalTypeName(String originalTypeName);

        /**
         * <p>
         * For public extensions that have been activated for this account and Region, the version of the public
         * extension to be used for CloudFormation operations in this account and Region.
         * </p>
         * <p>
         * How you specified <code>AutoUpdate</code> when enabling the extension affects whether CloudFormation
         * automatically updates the extension in this account and Region when a new version is released. For more
         * information, see <a href=
         * "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/registry-public.html#registry-public-enable-auto"
         * >Automatically use new versions of extensions</a> in the <i>CloudFormation User Guide</i>.
         * </p>
         * 
         * @param publicVersionNumber
         *        For public extensions that have been activated for this account and Region, the version of the public
         *        extension to be used for CloudFormation operations in this account and Region.</p>
         *        <p>
         *        How you specified <code>AutoUpdate</code> when enabling the extension affects whether CloudFormation
         *        automatically updates the extension in this account and Region when a new version is released. For
         *        more information, see <a href=
         *        "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/registry-public.html#registry-public-enable-auto"
         *        >Automatically use new versions of extensions</a> in the <i>CloudFormation User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder publicVersionNumber(String publicVersionNumber);

        /**
         * <p>
         * For public extensions that have been activated for this account and Region, the latest version of the public
         * extension <i>that is available</i>. For any extensions other than activated third-party extensions,
         * CloudFormation returns <code>null</code>.
         * </p>
         * <p>
         * How you specified <code>AutoUpdate</code> when enabling the extension affects whether CloudFormation
         * automatically updates the extension in this account and Region when a new version is released. For more
         * information, see <a href=
         * "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/registry-public.html#registry-public-enable-auto"
         * >Automatically use new versions of extensions</a> in the <i>CloudFormation User Guide</i>.
         * </p>
         * 
         * @param latestPublicVersion
         *        For public extensions that have been activated for this account and Region, the latest version of the
         *        public extension <i>that is available</i>. For any extensions other than activated third-party
         *        extensions, CloudFormation returns <code>null</code>.</p>
         *        <p>
         *        How you specified <code>AutoUpdate</code> when enabling the extension affects whether CloudFormation
         *        automatically updates the extension in this account and Region when a new version is released. For
         *        more information, see <a href=
         *        "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/registry-public.html#registry-public-enable-auto"
         *        >Automatically use new versions of extensions</a> in the <i>CloudFormation User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder latestPublicVersion(String latestPublicVersion);

        /**
         * <p>
         * The service used to verify the publisher identity.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/publish-extension.html">Publishing
         * extensions to make them available for public use</a> in the <i>CloudFormation Command Line Interface (CLI)
         * User Guide</i>.
         * </p>
         * 
         * @param publisherIdentity
         *        The service used to verify the publisher identity.</p>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/publish-extension.html"
         *        >Publishing extensions to make them available for public use</a> in the <i>CloudFormation Command Line
         *        Interface (CLI) User Guide</i>.
         * @see IdentityProvider
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IdentityProvider
         */
        Builder publisherIdentity(String publisherIdentity);

        /**
         * <p>
         * The service used to verify the publisher identity.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/publish-extension.html">Publishing
         * extensions to make them available for public use</a> in the <i>CloudFormation Command Line Interface (CLI)
         * User Guide</i>.
         * </p>
         * 
         * @param publisherIdentity
         *        The service used to verify the publisher identity.</p>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/publish-extension.html"
         *        >Publishing extensions to make them available for public use</a> in the <i>CloudFormation Command Line
         *        Interface (CLI) User Guide</i>.
         * @see IdentityProvider
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IdentityProvider
         */
        Builder publisherIdentity(IdentityProvider publisherIdentity);

        /**
         * <p>
         * The publisher name, as defined in the public profile for that publisher in the service used to verify the
         * publisher identity.
         * </p>
         * 
         * @param publisherName
         *        The publisher name, as defined in the public profile for that publisher in the service used to verify
         *        the publisher identity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder publisherName(String publisherName);

        /**
         * <p>
         * Whether the extension is activated for this account and Region.
         * </p>
         * <p>
         * This applies only to third-party public extensions. Extensions published by Amazon are activated by default.
         * </p>
         * 
         * @param isActivated
         *        Whether the extension is activated for this account and Region.</p>
         *        <p>
         *        This applies only to third-party public extensions. Extensions published by Amazon are activated by
         *        default.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isActivated(Boolean isActivated);
    }

    static final class BuilderImpl implements Builder {
        private String type;

        private String typeName;

        private String defaultVersionId;

        private String typeArn;

        private Instant lastUpdated;

        private String description;

        private String publisherId;

        private String originalTypeName;

        private String publicVersionNumber;

        private String latestPublicVersion;

        private String publisherIdentity;

        private String publisherName;

        private Boolean isActivated;

        private BuilderImpl() {
        }

        private BuilderImpl(TypeSummary model) {
            type(model.type);
            typeName(model.typeName);
            defaultVersionId(model.defaultVersionId);
            typeArn(model.typeArn);
            lastUpdated(model.lastUpdated);
            description(model.description);
            publisherId(model.publisherId);
            originalTypeName(model.originalTypeName);
            publicVersionNumber(model.publicVersionNumber);
            latestPublicVersion(model.latestPublicVersion);
            publisherIdentity(model.publisherIdentity);
            publisherName(model.publisherName);
            isActivated(model.isActivated);
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(RegistryType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getTypeName() {
            return typeName;
        }

        public final void setTypeName(String typeName) {
            this.typeName = typeName;
        }

        @Override
        public final Builder typeName(String typeName) {
            this.typeName = typeName;
            return this;
        }

        public final String getDefaultVersionId() {
            return defaultVersionId;
        }

        public final void setDefaultVersionId(String defaultVersionId) {
            this.defaultVersionId = defaultVersionId;
        }

        @Override
        public final Builder defaultVersionId(String defaultVersionId) {
            this.defaultVersionId = defaultVersionId;
            return this;
        }

        public final String getTypeArn() {
            return typeArn;
        }

        public final void setTypeArn(String typeArn) {
            this.typeArn = typeArn;
        }

        @Override
        public final Builder typeArn(String typeArn) {
            this.typeArn = typeArn;
            return this;
        }

        public final Instant getLastUpdated() {
            return lastUpdated;
        }

        public final void setLastUpdated(Instant lastUpdated) {
            this.lastUpdated = lastUpdated;
        }

        @Override
        public final Builder lastUpdated(Instant lastUpdated) {
            this.lastUpdated = lastUpdated;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getPublisherId() {
            return publisherId;
        }

        public final void setPublisherId(String publisherId) {
            this.publisherId = publisherId;
        }

        @Override
        public final Builder publisherId(String publisherId) {
            this.publisherId = publisherId;
            return this;
        }

        public final String getOriginalTypeName() {
            return originalTypeName;
        }

        public final void setOriginalTypeName(String originalTypeName) {
            this.originalTypeName = originalTypeName;
        }

        @Override
        public final Builder originalTypeName(String originalTypeName) {
            this.originalTypeName = originalTypeName;
            return this;
        }

        public final String getPublicVersionNumber() {
            return publicVersionNumber;
        }

        public final void setPublicVersionNumber(String publicVersionNumber) {
            this.publicVersionNumber = publicVersionNumber;
        }

        @Override
        public final Builder publicVersionNumber(String publicVersionNumber) {
            this.publicVersionNumber = publicVersionNumber;
            return this;
        }

        public final String getLatestPublicVersion() {
            return latestPublicVersion;
        }

        public final void setLatestPublicVersion(String latestPublicVersion) {
            this.latestPublicVersion = latestPublicVersion;
        }

        @Override
        public final Builder latestPublicVersion(String latestPublicVersion) {
            this.latestPublicVersion = latestPublicVersion;
            return this;
        }

        public final String getPublisherIdentity() {
            return publisherIdentity;
        }

        public final void setPublisherIdentity(String publisherIdentity) {
            this.publisherIdentity = publisherIdentity;
        }

        @Override
        public final Builder publisherIdentity(String publisherIdentity) {
            this.publisherIdentity = publisherIdentity;
            return this;
        }

        @Override
        public final Builder publisherIdentity(IdentityProvider publisherIdentity) {
            this.publisherIdentity(publisherIdentity == null ? null : publisherIdentity.toString());
            return this;
        }

        public final String getPublisherName() {
            return publisherName;
        }

        public final void setPublisherName(String publisherName) {
            this.publisherName = publisherName;
        }

        @Override
        public final Builder publisherName(String publisherName) {
            this.publisherName = publisherName;
            return this;
        }

        public final Boolean getIsActivated() {
            return isActivated;
        }

        public final void setIsActivated(Boolean isActivated) {
            this.isActivated = isActivated;
        }

        @Override
        public final Builder isActivated(Boolean isActivated) {
            this.isActivated = isActivated;
            return this;
        }

        @Override
        public TypeSummary build() {
            return new TypeSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
