/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudformation.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeStackRefactorResponse extends CloudFormationResponse implements
        ToCopyableBuilder<DescribeStackRefactorResponse.Builder, DescribeStackRefactorResponse> {
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(DescribeStackRefactorResponse::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> STACK_REFACTOR_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StackRefactorId").getter(getter(DescribeStackRefactorResponse::stackRefactorId))
            .setter(setter(Builder::stackRefactorId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StackRefactorId").build()).build();

    private static final SdkField<List<String>> STACK_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("StackIds")
            .getter(getter(DescribeStackRefactorResponse::stackIds))
            .setter(setter(Builder::stackIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StackIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> EXECUTION_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ExecutionStatus").getter(getter(DescribeStackRefactorResponse::executionStatusAsString))
            .setter(setter(Builder::executionStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecutionStatus").build()).build();

    private static final SdkField<String> EXECUTION_STATUS_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ExecutionStatusReason").getter(getter(DescribeStackRefactorResponse::executionStatusReason))
            .setter(setter(Builder::executionStatusReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecutionStatusReason").build())
            .build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(DescribeStackRefactorResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> STATUS_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StatusReason").getter(getter(DescribeStackRefactorResponse::statusReason))
            .setter(setter(Builder::statusReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusReason").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESCRIPTION_FIELD,
            STACK_REFACTOR_ID_FIELD, STACK_IDS_FIELD, EXECUTION_STATUS_FIELD, EXECUTION_STATUS_REASON_FIELD, STATUS_FIELD,
            STATUS_REASON_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String description;

    private final String stackRefactorId;

    private final List<String> stackIds;

    private final String executionStatus;

    private final String executionStatusReason;

    private final String status;

    private final String statusReason;

    private DescribeStackRefactorResponse(BuilderImpl builder) {
        super(builder);
        this.description = builder.description;
        this.stackRefactorId = builder.stackRefactorId;
        this.stackIds = builder.stackIds;
        this.executionStatus = builder.executionStatus;
        this.executionStatusReason = builder.executionStatusReason;
        this.status = builder.status;
        this.statusReason = builder.statusReason;
    }

    /**
     * <p>
     * A description to help you identify the refactor.
     * </p>
     * 
     * @return A description to help you identify the refactor.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The ID associated with the stack refactor created from the <a>CreateStackRefactor</a> action.
     * </p>
     * 
     * @return The ID associated with the stack refactor created from the <a>CreateStackRefactor</a> action.
     */
    public final String stackRefactorId() {
        return stackRefactorId;
    }

    /**
     * For responses, this returns true if the service returned a value for the StackIds property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasStackIds() {
        return stackIds != null && !(stackIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The unique ID for each stack.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasStackIds} method.
     * </p>
     * 
     * @return The unique ID for each stack.
     */
    public final List<String> stackIds() {
        return stackIds;
    }

    /**
     * <p>
     * The stack refactor execution operation status that's provided after calling the <a>ExecuteStackRefactor</a>
     * action.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #executionStatus}
     * will return {@link StackRefactorExecutionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #executionStatusAsString}.
     * </p>
     * 
     * @return The stack refactor execution operation status that's provided after calling the
     *         <a>ExecuteStackRefactor</a> action.
     * @see StackRefactorExecutionStatus
     */
    public final StackRefactorExecutionStatus executionStatus() {
        return StackRefactorExecutionStatus.fromValue(executionStatus);
    }

    /**
     * <p>
     * The stack refactor execution operation status that's provided after calling the <a>ExecuteStackRefactor</a>
     * action.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #executionStatus}
     * will return {@link StackRefactorExecutionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #executionStatusAsString}.
     * </p>
     * 
     * @return The stack refactor execution operation status that's provided after calling the
     *         <a>ExecuteStackRefactor</a> action.
     * @see StackRefactorExecutionStatus
     */
    public final String executionStatusAsString() {
        return executionStatus;
    }

    /**
     * <p>
     * A detailed explanation for the stack refactor <code>ExecutionStatus</code>.
     * </p>
     * 
     * @return A detailed explanation for the stack refactor <code>ExecutionStatus</code>.
     */
    public final String executionStatusReason() {
        return executionStatusReason;
    }

    /**
     * <p>
     * The stack refactor operation status that's provided after calling the <a>CreateStackRefactor</a> action.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link StackRefactorStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The stack refactor operation status that's provided after calling the <a>CreateStackRefactor</a> action.
     * @see StackRefactorStatus
     */
    public final StackRefactorStatus status() {
        return StackRefactorStatus.fromValue(status);
    }

    /**
     * <p>
     * The stack refactor operation status that's provided after calling the <a>CreateStackRefactor</a> action.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link StackRefactorStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The stack refactor operation status that's provided after calling the <a>CreateStackRefactor</a> action.
     * @see StackRefactorStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * A detailed explanation for the stack refactor operation <code>Status</code>.
     * </p>
     * 
     * @return A detailed explanation for the stack refactor operation <code>Status</code>.
     */
    public final String statusReason() {
        return statusReason;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(stackRefactorId());
        hashCode = 31 * hashCode + Objects.hashCode(hasStackIds() ? stackIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(executionStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(executionStatusReason());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusReason());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeStackRefactorResponse)) {
            return false;
        }
        DescribeStackRefactorResponse other = (DescribeStackRefactorResponse) obj;
        return Objects.equals(description(), other.description()) && Objects.equals(stackRefactorId(), other.stackRefactorId())
                && hasStackIds() == other.hasStackIds() && Objects.equals(stackIds(), other.stackIds())
                && Objects.equals(executionStatusAsString(), other.executionStatusAsString())
                && Objects.equals(executionStatusReason(), other.executionStatusReason())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(statusReason(), other.statusReason());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeStackRefactorResponse").add("Description", description())
                .add("StackRefactorId", stackRefactorId()).add("StackIds", hasStackIds() ? stackIds() : null)
                .add("ExecutionStatus", executionStatusAsString()).add("ExecutionStatusReason", executionStatusReason())
                .add("Status", statusAsString()).add("StatusReason", statusReason()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "StackRefactorId":
            return Optional.ofNullable(clazz.cast(stackRefactorId()));
        case "StackIds":
            return Optional.ofNullable(clazz.cast(stackIds()));
        case "ExecutionStatus":
            return Optional.ofNullable(clazz.cast(executionStatusAsString()));
        case "ExecutionStatusReason":
            return Optional.ofNullable(clazz.cast(executionStatusReason()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "StatusReason":
            return Optional.ofNullable(clazz.cast(statusReason()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Description", DESCRIPTION_FIELD);
        map.put("StackRefactorId", STACK_REFACTOR_ID_FIELD);
        map.put("StackIds", STACK_IDS_FIELD);
        map.put("ExecutionStatus", EXECUTION_STATUS_FIELD);
        map.put("ExecutionStatusReason", EXECUTION_STATUS_REASON_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("StatusReason", STATUS_REASON_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeStackRefactorResponse, T> g) {
        return obj -> g.apply((DescribeStackRefactorResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudFormationResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeStackRefactorResponse> {
        /**
         * <p>
         * A description to help you identify the refactor.
         * </p>
         * 
         * @param description
         *        A description to help you identify the refactor.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The ID associated with the stack refactor created from the <a>CreateStackRefactor</a> action.
         * </p>
         * 
         * @param stackRefactorId
         *        The ID associated with the stack refactor created from the <a>CreateStackRefactor</a> action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stackRefactorId(String stackRefactorId);

        /**
         * <p>
         * The unique ID for each stack.
         * </p>
         * 
         * @param stackIds
         *        The unique ID for each stack.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stackIds(Collection<String> stackIds);

        /**
         * <p>
         * The unique ID for each stack.
         * </p>
         * 
         * @param stackIds
         *        The unique ID for each stack.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stackIds(String... stackIds);

        /**
         * <p>
         * The stack refactor execution operation status that's provided after calling the <a>ExecuteStackRefactor</a>
         * action.
         * </p>
         * 
         * @param executionStatus
         *        The stack refactor execution operation status that's provided after calling the
         *        <a>ExecuteStackRefactor</a> action.
         * @see StackRefactorExecutionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StackRefactorExecutionStatus
         */
        Builder executionStatus(String executionStatus);

        /**
         * <p>
         * The stack refactor execution operation status that's provided after calling the <a>ExecuteStackRefactor</a>
         * action.
         * </p>
         * 
         * @param executionStatus
         *        The stack refactor execution operation status that's provided after calling the
         *        <a>ExecuteStackRefactor</a> action.
         * @see StackRefactorExecutionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StackRefactorExecutionStatus
         */
        Builder executionStatus(StackRefactorExecutionStatus executionStatus);

        /**
         * <p>
         * A detailed explanation for the stack refactor <code>ExecutionStatus</code>.
         * </p>
         * 
         * @param executionStatusReason
         *        A detailed explanation for the stack refactor <code>ExecutionStatus</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executionStatusReason(String executionStatusReason);

        /**
         * <p>
         * The stack refactor operation status that's provided after calling the <a>CreateStackRefactor</a> action.
         * </p>
         * 
         * @param status
         *        The stack refactor operation status that's provided after calling the <a>CreateStackRefactor</a>
         *        action.
         * @see StackRefactorStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StackRefactorStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The stack refactor operation status that's provided after calling the <a>CreateStackRefactor</a> action.
         * </p>
         * 
         * @param status
         *        The stack refactor operation status that's provided after calling the <a>CreateStackRefactor</a>
         *        action.
         * @see StackRefactorStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StackRefactorStatus
         */
        Builder status(StackRefactorStatus status);

        /**
         * <p>
         * A detailed explanation for the stack refactor operation <code>Status</code>.
         * </p>
         * 
         * @param statusReason
         *        A detailed explanation for the stack refactor operation <code>Status</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusReason(String statusReason);
    }

    static final class BuilderImpl extends CloudFormationResponse.BuilderImpl implements Builder {
        private String description;

        private String stackRefactorId;

        private List<String> stackIds = DefaultSdkAutoConstructList.getInstance();

        private String executionStatus;

        private String executionStatusReason;

        private String status;

        private String statusReason;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeStackRefactorResponse model) {
            super(model);
            description(model.description);
            stackRefactorId(model.stackRefactorId);
            stackIds(model.stackIds);
            executionStatus(model.executionStatus);
            executionStatusReason(model.executionStatusReason);
            status(model.status);
            statusReason(model.statusReason);
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getStackRefactorId() {
            return stackRefactorId;
        }

        public final void setStackRefactorId(String stackRefactorId) {
            this.stackRefactorId = stackRefactorId;
        }

        @Override
        public final Builder stackRefactorId(String stackRefactorId) {
            this.stackRefactorId = stackRefactorId;
            return this;
        }

        public final Collection<String> getStackIds() {
            if (stackIds instanceof SdkAutoConstructList) {
                return null;
            }
            return stackIds;
        }

        public final void setStackIds(Collection<String> stackIds) {
            this.stackIds = StackIdsCopier.copy(stackIds);
        }

        @Override
        public final Builder stackIds(Collection<String> stackIds) {
            this.stackIds = StackIdsCopier.copy(stackIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stackIds(String... stackIds) {
            stackIds(Arrays.asList(stackIds));
            return this;
        }

        public final String getExecutionStatus() {
            return executionStatus;
        }

        public final void setExecutionStatus(String executionStatus) {
            this.executionStatus = executionStatus;
        }

        @Override
        public final Builder executionStatus(String executionStatus) {
            this.executionStatus = executionStatus;
            return this;
        }

        @Override
        public final Builder executionStatus(StackRefactorExecutionStatus executionStatus) {
            this.executionStatus(executionStatus == null ? null : executionStatus.toString());
            return this;
        }

        public final String getExecutionStatusReason() {
            return executionStatusReason;
        }

        public final void setExecutionStatusReason(String executionStatusReason) {
            this.executionStatusReason = executionStatusReason;
        }

        @Override
        public final Builder executionStatusReason(String executionStatusReason) {
            this.executionStatusReason = executionStatusReason;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(StackRefactorStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusReason() {
            return statusReason;
        }

        public final void setStatusReason(String statusReason) {
            this.statusReason = statusReason;
        }

        @Override
        public final Builder statusReason(String statusReason) {
            this.statusReason = statusReason;
            return this;
        }

        @Override
        public DescribeStackRefactorResponse build() {
            return new DescribeStackRefactorResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
