/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudformation.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListResourceScanRelatedResourcesResponse extends CloudFormationResponse implements
        ToCopyableBuilder<ListResourceScanRelatedResourcesResponse.Builder, ListResourceScanRelatedResourcesResponse> {
    private static final SdkField<List<ScannedResource>> RELATED_RESOURCES_FIELD = SdkField
            .<List<ScannedResource>> builder(MarshallingType.LIST)
            .memberName("RelatedResources")
            .getter(getter(ListResourceScanRelatedResourcesResponse::relatedResources))
            .setter(setter(Builder::relatedResources))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RelatedResources").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ScannedResource> builder(MarshallingType.SDK_POJO)
                                            .constructor(ScannedResource::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListResourceScanRelatedResourcesResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RELATED_RESOURCES_FIELD,
            NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<ScannedResource> relatedResources;

    private final String nextToken;

    private ListResourceScanRelatedResourcesResponse(BuilderImpl builder) {
        super(builder);
        this.relatedResources = builder.relatedResources;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the RelatedResources property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasRelatedResources() {
        return relatedResources != null && !(relatedResources instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * List of up to <code>MaxResults</code> resources in the specified resource scan related to the specified
     * resources.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRelatedResources} method.
     * </p>
     * 
     * @return List of up to <code>MaxResults</code> resources in the specified resource scan related to the specified
     *         resources.
     */
    public final List<ScannedResource> relatedResources() {
        return relatedResources;
    }

    /**
     * <p>
     * If the request doesn't return all the remaining results, <code>NextToken</code> is set to a token. To retrieve
     * the next set of results, call <code>ListResourceScanRelatedResources</code> again and use that value for the
     * <code>NextToken</code> parameter. If the request returns all results, <code>NextToken</code> is set to an empty
     * string.
     * </p>
     * 
     * @return If the request doesn't return all the remaining results, <code>NextToken</code> is set to a token. To
     *         retrieve the next set of results, call <code>ListResourceScanRelatedResources</code> again and use that
     *         value for the <code>NextToken</code> parameter. If the request returns all results,
     *         <code>NextToken</code> is set to an empty string.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasRelatedResources() ? relatedResources() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListResourceScanRelatedResourcesResponse)) {
            return false;
        }
        ListResourceScanRelatedResourcesResponse other = (ListResourceScanRelatedResourcesResponse) obj;
        return hasRelatedResources() == other.hasRelatedResources()
                && Objects.equals(relatedResources(), other.relatedResources()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListResourceScanRelatedResourcesResponse")
                .add("RelatedResources", hasRelatedResources() ? relatedResources() : null).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RelatedResources":
            return Optional.ofNullable(clazz.cast(relatedResources()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("RelatedResources", RELATED_RESOURCES_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListResourceScanRelatedResourcesResponse, T> g) {
        return obj -> g.apply((ListResourceScanRelatedResourcesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudFormationResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListResourceScanRelatedResourcesResponse> {
        /**
         * <p>
         * List of up to <code>MaxResults</code> resources in the specified resource scan related to the specified
         * resources.
         * </p>
         * 
         * @param relatedResources
         *        List of up to <code>MaxResults</code> resources in the specified resource scan related to the
         *        specified resources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder relatedResources(Collection<ScannedResource> relatedResources);

        /**
         * <p>
         * List of up to <code>MaxResults</code> resources in the specified resource scan related to the specified
         * resources.
         * </p>
         * 
         * @param relatedResources
         *        List of up to <code>MaxResults</code> resources in the specified resource scan related to the
         *        specified resources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder relatedResources(ScannedResource... relatedResources);

        /**
         * <p>
         * List of up to <code>MaxResults</code> resources in the specified resource scan related to the specified
         * resources.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.cloudformation.model.ScannedResource.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.cloudformation.model.ScannedResource#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.cloudformation.model.ScannedResource.Builder#build()} is called
         * immediately and its result is passed to {@link #relatedResources(List<ScannedResource>)}.
         * 
         * @param relatedResources
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.cloudformation.model.ScannedResource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #relatedResources(java.util.Collection<ScannedResource>)
         */
        Builder relatedResources(Consumer<ScannedResource.Builder>... relatedResources);

        /**
         * <p>
         * If the request doesn't return all the remaining results, <code>NextToken</code> is set to a token. To
         * retrieve the next set of results, call <code>ListResourceScanRelatedResources</code> again and use that value
         * for the <code>NextToken</code> parameter. If the request returns all results, <code>NextToken</code> is set
         * to an empty string.
         * </p>
         * 
         * @param nextToken
         *        If the request doesn't return all the remaining results, <code>NextToken</code> is set to a token. To
         *        retrieve the next set of results, call <code>ListResourceScanRelatedResources</code> again and use
         *        that value for the <code>NextToken</code> parameter. If the request returns all results,
         *        <code>NextToken</code> is set to an empty string.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends CloudFormationResponse.BuilderImpl implements Builder {
        private List<ScannedResource> relatedResources = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListResourceScanRelatedResourcesResponse model) {
            super(model);
            relatedResources(model.relatedResources);
            nextToken(model.nextToken);
        }

        public final List<ScannedResource.Builder> getRelatedResources() {
            List<ScannedResource.Builder> result = RelatedResourcesCopier.copyToBuilder(this.relatedResources);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRelatedResources(Collection<ScannedResource.BuilderImpl> relatedResources) {
            this.relatedResources = RelatedResourcesCopier.copyFromBuilder(relatedResources);
        }

        @Override
        public final Builder relatedResources(Collection<ScannedResource> relatedResources) {
            this.relatedResources = RelatedResourcesCopier.copy(relatedResources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder relatedResources(ScannedResource... relatedResources) {
            relatedResources(Arrays.asList(relatedResources));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder relatedResources(Consumer<ScannedResource.Builder>... relatedResources) {
            relatedResources(Stream.of(relatedResources).map(c -> ScannedResource.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListResourceScanRelatedResourcesResponse build() {
            return new ListResourceScanRelatedResourcesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
