/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudformation.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The Parameter data type.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Parameter implements SdkPojo, Serializable, ToCopyableBuilder<Parameter.Builder, Parameter> {
    private static final SdkField<String> PARAMETER_KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ParameterKey").getter(getter(Parameter::parameterKey)).setter(setter(Builder::parameterKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParameterKey").build()).build();

    private static final SdkField<String> PARAMETER_VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ParameterValue").getter(getter(Parameter::parameterValue)).setter(setter(Builder::parameterValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParameterValue").build()).build();

    private static final SdkField<Boolean> USE_PREVIOUS_VALUE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("UsePreviousValue").getter(getter(Parameter::usePreviousValue)).setter(setter(Builder::usePreviousValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UsePreviousValue").build()).build();

    private static final SdkField<String> RESOLVED_VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResolvedValue").getter(getter(Parameter::resolvedValue)).setter(setter(Builder::resolvedValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResolvedValue").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PARAMETER_KEY_FIELD,
            PARAMETER_VALUE_FIELD, USE_PREVIOUS_VALUE_FIELD, RESOLVED_VALUE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String parameterKey;

    private final String parameterValue;

    private final Boolean usePreviousValue;

    private final String resolvedValue;

    private Parameter(BuilderImpl builder) {
        this.parameterKey = builder.parameterKey;
        this.parameterValue = builder.parameterValue;
        this.usePreviousValue = builder.usePreviousValue;
        this.resolvedValue = builder.resolvedValue;
    }

    /**
     * <p>
     * The key associated with the parameter. If you don't specify a key and value for a particular parameter,
     * CloudFormation uses the default value that's specified in your template.
     * </p>
     * 
     * @return The key associated with the parameter. If you don't specify a key and value for a particular parameter,
     *         CloudFormation uses the default value that's specified in your template.
     */
    public final String parameterKey() {
        return parameterKey;
    }

    /**
     * <p>
     * The input value associated with the parameter.
     * </p>
     * 
     * @return The input value associated with the parameter.
     */
    public final String parameterValue() {
        return parameterValue;
    }

    /**
     * <p>
     * During a stack update, use the existing parameter value that the stack is using for a given parameter key. If you
     * specify <code>true</code>, do not specify a parameter value.
     * </p>
     * 
     * @return During a stack update, use the existing parameter value that the stack is using for a given parameter
     *         key. If you specify <code>true</code>, do not specify a parameter value.
     */
    public final Boolean usePreviousValue() {
        return usePreviousValue;
    }

    /**
     * <p>
     * Read-only. The value that corresponds to a Systems Manager parameter key. This field is returned only for Systems
     * Manager parameter types in the template. For more information, see <a href=
     * "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/cloudformation-supplied-parameter-types.html">Use
     * CloudFormation-supplied parameter types</a> in the <i>CloudFormation User Guide</i>.
     * </p>
     * 
     * @return Read-only. The value that corresponds to a Systems Manager parameter key. This field is returned only for
     *         Systems Manager parameter types in the template. For more information, see <a href=
     *         "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/cloudformation-supplied-parameter-types.html"
     *         >Use CloudFormation-supplied parameter types</a> in the <i>CloudFormation User Guide</i>.
     */
    public final String resolvedValue() {
        return resolvedValue;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(parameterKey());
        hashCode = 31 * hashCode + Objects.hashCode(parameterValue());
        hashCode = 31 * hashCode + Objects.hashCode(usePreviousValue());
        hashCode = 31 * hashCode + Objects.hashCode(resolvedValue());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Parameter)) {
            return false;
        }
        Parameter other = (Parameter) obj;
        return Objects.equals(parameterKey(), other.parameterKey()) && Objects.equals(parameterValue(), other.parameterValue())
                && Objects.equals(usePreviousValue(), other.usePreviousValue())
                && Objects.equals(resolvedValue(), other.resolvedValue());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Parameter").add("ParameterKey", parameterKey()).add("ParameterValue", parameterValue())
                .add("UsePreviousValue", usePreviousValue()).add("ResolvedValue", resolvedValue()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ParameterKey":
            return Optional.ofNullable(clazz.cast(parameterKey()));
        case "ParameterValue":
            return Optional.ofNullable(clazz.cast(parameterValue()));
        case "UsePreviousValue":
            return Optional.ofNullable(clazz.cast(usePreviousValue()));
        case "ResolvedValue":
            return Optional.ofNullable(clazz.cast(resolvedValue()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ParameterKey", PARAMETER_KEY_FIELD);
        map.put("ParameterValue", PARAMETER_VALUE_FIELD);
        map.put("UsePreviousValue", USE_PREVIOUS_VALUE_FIELD);
        map.put("ResolvedValue", RESOLVED_VALUE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Parameter, T> g) {
        return obj -> g.apply((Parameter) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Parameter> {
        /**
         * <p>
         * The key associated with the parameter. If you don't specify a key and value for a particular parameter,
         * CloudFormation uses the default value that's specified in your template.
         * </p>
         * 
         * @param parameterKey
         *        The key associated with the parameter. If you don't specify a key and value for a particular
         *        parameter, CloudFormation uses the default value that's specified in your template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameterKey(String parameterKey);

        /**
         * <p>
         * The input value associated with the parameter.
         * </p>
         * 
         * @param parameterValue
         *        The input value associated with the parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameterValue(String parameterValue);

        /**
         * <p>
         * During a stack update, use the existing parameter value that the stack is using for a given parameter key. If
         * you specify <code>true</code>, do not specify a parameter value.
         * </p>
         * 
         * @param usePreviousValue
         *        During a stack update, use the existing parameter value that the stack is using for a given parameter
         *        key. If you specify <code>true</code>, do not specify a parameter value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder usePreviousValue(Boolean usePreviousValue);

        /**
         * <p>
         * Read-only. The value that corresponds to a Systems Manager parameter key. This field is returned only for
         * Systems Manager parameter types in the template. For more information, see <a href=
         * "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/cloudformation-supplied-parameter-types.html"
         * >Use CloudFormation-supplied parameter types</a> in the <i>CloudFormation User Guide</i>.
         * </p>
         * 
         * @param resolvedValue
         *        Read-only. The value that corresponds to a Systems Manager parameter key. This field is returned only
         *        for Systems Manager parameter types in the template. For more information, see <a href=
         *        "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/cloudformation-supplied-parameter-types.html"
         *        >Use CloudFormation-supplied parameter types</a> in the <i>CloudFormation User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resolvedValue(String resolvedValue);
    }

    static final class BuilderImpl implements Builder {
        private String parameterKey;

        private String parameterValue;

        private Boolean usePreviousValue;

        private String resolvedValue;

        private BuilderImpl() {
        }

        private BuilderImpl(Parameter model) {
            parameterKey(model.parameterKey);
            parameterValue(model.parameterValue);
            usePreviousValue(model.usePreviousValue);
            resolvedValue(model.resolvedValue);
        }

        public final String getParameterKey() {
            return parameterKey;
        }

        public final void setParameterKey(String parameterKey) {
            this.parameterKey = parameterKey;
        }

        @Override
        public final Builder parameterKey(String parameterKey) {
            this.parameterKey = parameterKey;
            return this;
        }

        public final String getParameterValue() {
            return parameterValue;
        }

        public final void setParameterValue(String parameterValue) {
            this.parameterValue = parameterValue;
        }

        @Override
        public final Builder parameterValue(String parameterValue) {
            this.parameterValue = parameterValue;
            return this;
        }

        public final Boolean getUsePreviousValue() {
            return usePreviousValue;
        }

        public final void setUsePreviousValue(Boolean usePreviousValue) {
            this.usePreviousValue = usePreviousValue;
        }

        @Override
        public final Builder usePreviousValue(Boolean usePreviousValue) {
            this.usePreviousValue = usePreviousValue;
            return this;
        }

        public final String getResolvedValue() {
            return resolvedValue;
        }

        public final void setResolvedValue(String resolvedValue) {
            this.resolvedValue = resolvedValue;
        }

        @Override
        public final Builder resolvedValue(String resolvedValue) {
            this.resolvedValue = resolvedValue;
            return this;
        }

        @Override
        public Parameter build() {
            return new Parameter(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
