/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudformation.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The structure that contains summary information about a stack instance.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class StackInstanceSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<StackInstanceSummary.Builder, StackInstanceSummary> {
    private static final SdkField<String> STACK_SET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StackSetId").getter(getter(StackInstanceSummary::stackSetId)).setter(setter(Builder::stackSetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StackSetId").build()).build();

    private static final SdkField<String> REGION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Region")
            .getter(getter(StackInstanceSummary::region)).setter(setter(Builder::region))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Region").build()).build();

    private static final SdkField<String> ACCOUNT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Account")
            .getter(getter(StackInstanceSummary::account)).setter(setter(Builder::account))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Account").build()).build();

    private static final SdkField<String> STACK_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StackId").getter(getter(StackInstanceSummary::stackId)).setter(setter(Builder::stackId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StackId").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(StackInstanceSummary::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> STATUS_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StatusReason").getter(getter(StackInstanceSummary::statusReason)).setter(setter(Builder::statusReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusReason").build()).build();

    private static final SdkField<StackInstanceComprehensiveStatus> STACK_INSTANCE_STATUS_FIELD = SdkField
            .<StackInstanceComprehensiveStatus> builder(MarshallingType.SDK_POJO).memberName("StackInstanceStatus")
            .getter(getter(StackInstanceSummary::stackInstanceStatus)).setter(setter(Builder::stackInstanceStatus))
            .constructor(StackInstanceComprehensiveStatus::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StackInstanceStatus").build())
            .build();

    private static final SdkField<String> ORGANIZATIONAL_UNIT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OrganizationalUnitId").getter(getter(StackInstanceSummary::organizationalUnitId))
            .setter(setter(Builder::organizationalUnitId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrganizationalUnitId").build())
            .build();

    private static final SdkField<String> DRIFT_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DriftStatus").getter(getter(StackInstanceSummary::driftStatusAsString))
            .setter(setter(Builder::driftStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DriftStatus").build()).build();

    private static final SdkField<Instant> LAST_DRIFT_CHECK_TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastDriftCheckTimestamp").getter(getter(StackInstanceSummary::lastDriftCheckTimestamp))
            .setter(setter(Builder::lastDriftCheckTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastDriftCheckTimestamp").build())
            .build();

    private static final SdkField<String> LAST_OPERATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LastOperationId").getter(getter(StackInstanceSummary::lastOperationId))
            .setter(setter(Builder::lastOperationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastOperationId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STACK_SET_ID_FIELD,
            REGION_FIELD, ACCOUNT_FIELD, STACK_ID_FIELD, STATUS_FIELD, STATUS_REASON_FIELD, STACK_INSTANCE_STATUS_FIELD,
            ORGANIZATIONAL_UNIT_ID_FIELD, DRIFT_STATUS_FIELD, LAST_DRIFT_CHECK_TIMESTAMP_FIELD, LAST_OPERATION_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String stackSetId;

    private final String region;

    private final String account;

    private final String stackId;

    private final String status;

    private final String statusReason;

    private final StackInstanceComprehensiveStatus stackInstanceStatus;

    private final String organizationalUnitId;

    private final String driftStatus;

    private final Instant lastDriftCheckTimestamp;

    private final String lastOperationId;

    private StackInstanceSummary(BuilderImpl builder) {
        this.stackSetId = builder.stackSetId;
        this.region = builder.region;
        this.account = builder.account;
        this.stackId = builder.stackId;
        this.status = builder.status;
        this.statusReason = builder.statusReason;
        this.stackInstanceStatus = builder.stackInstanceStatus;
        this.organizationalUnitId = builder.organizationalUnitId;
        this.driftStatus = builder.driftStatus;
        this.lastDriftCheckTimestamp = builder.lastDriftCheckTimestamp;
        this.lastOperationId = builder.lastOperationId;
    }

    /**
     * <p>
     * The name or unique ID of the stack set that the stack instance is associated with.
     * </p>
     * 
     * @return The name or unique ID of the stack set that the stack instance is associated with.
     */
    public final String stackSetId() {
        return stackSetId;
    }

    /**
     * <p>
     * The name of the Amazon Web Services Region that the stack instance is associated with.
     * </p>
     * 
     * @return The name of the Amazon Web Services Region that the stack instance is associated with.
     */
    public final String region() {
        return region;
    }

    /**
     * <p>
     * [Self-managed permissions] The name of the Amazon Web Services account that the stack instance is associated
     * with.
     * </p>
     * 
     * @return [Self-managed permissions] The name of the Amazon Web Services account that the stack instance is
     *         associated with.
     */
    public final String account() {
        return account;
    }

    /**
     * <p>
     * The ID of the stack instance.
     * </p>
     * 
     * @return The ID of the stack instance.
     */
    public final String stackId() {
        return stackId;
    }

    /**
     * <p>
     * The status of the stack instance, in terms of its synchronization with its associated stack set.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>INOPERABLE</code>: A <code>DeleteStackInstances</code> operation has failed and left the stack in an
     * unstable state. Stacks in this state are excluded from further <code>UpdateStackSet</code> operations. You might
     * need to perform a <code>DeleteStackInstances</code> operation, with <code>RetainStacks</code> set to
     * <code>true</code>, to delete the stack instance, and then delete the stack manually. <code>INOPERABLE</code> can
     * be returned here when the cause is a failed import. If it's due to a failed import, the operation can be retried
     * once the failures are fixed. To see if this is due to a failed import, call the <a>DescribeStackInstance</a> API
     * operation, look at the <code>DetailedStatus</code> member returned in the <code>StackInstanceSummary</code>
     * member.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>OUTDATED</code>: The stack isn't currently up to date with the stack set because:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The associated stack failed during a <code>CreateStackSet</code> or <code>UpdateStackSet</code> operation.
     * </p>
     * </li>
     * <li>
     * <p>
     * The stack was part of a <code>CreateStackSet</code> or <code>UpdateStackSet</code> operation that failed or was
     * stopped before the stack was created or updated.
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <code>CURRENT</code>: The stack is currently up to date with the stack set.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link StackInstanceStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the stack instance, in terms of its synchronization with its associated stack set.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>INOPERABLE</code>: A <code>DeleteStackInstances</code> operation has failed and left the stack in
     *         an unstable state. Stacks in this state are excluded from further <code>UpdateStackSet</code> operations.
     *         You might need to perform a <code>DeleteStackInstances</code> operation, with <code>RetainStacks</code>
     *         set to <code>true</code>, to delete the stack instance, and then delete the stack manually.
     *         <code>INOPERABLE</code> can be returned here when the cause is a failed import. If it's due to a failed
     *         import, the operation can be retried once the failures are fixed. To see if this is due to a failed
     *         import, call the <a>DescribeStackInstance</a> API operation, look at the <code>DetailedStatus</code>
     *         member returned in the <code>StackInstanceSummary</code> member.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>OUTDATED</code>: The stack isn't currently up to date with the stack set because:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         The associated stack failed during a <code>CreateStackSet</code> or <code>UpdateStackSet</code>
     *         operation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The stack was part of a <code>CreateStackSet</code> or <code>UpdateStackSet</code> operation that failed
     *         or was stopped before the stack was created or updated.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CURRENT</code>: The stack is currently up to date with the stack set.
     *         </p>
     *         </li>
     * @see StackInstanceStatus
     */
    public final StackInstanceStatus status() {
        return StackInstanceStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the stack instance, in terms of its synchronization with its associated stack set.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>INOPERABLE</code>: A <code>DeleteStackInstances</code> operation has failed and left the stack in an
     * unstable state. Stacks in this state are excluded from further <code>UpdateStackSet</code> operations. You might
     * need to perform a <code>DeleteStackInstances</code> operation, with <code>RetainStacks</code> set to
     * <code>true</code>, to delete the stack instance, and then delete the stack manually. <code>INOPERABLE</code> can
     * be returned here when the cause is a failed import. If it's due to a failed import, the operation can be retried
     * once the failures are fixed. To see if this is due to a failed import, call the <a>DescribeStackInstance</a> API
     * operation, look at the <code>DetailedStatus</code> member returned in the <code>StackInstanceSummary</code>
     * member.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>OUTDATED</code>: The stack isn't currently up to date with the stack set because:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The associated stack failed during a <code>CreateStackSet</code> or <code>UpdateStackSet</code> operation.
     * </p>
     * </li>
     * <li>
     * <p>
     * The stack was part of a <code>CreateStackSet</code> or <code>UpdateStackSet</code> operation that failed or was
     * stopped before the stack was created or updated.
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <code>CURRENT</code>: The stack is currently up to date with the stack set.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link StackInstanceStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the stack instance, in terms of its synchronization with its associated stack set.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>INOPERABLE</code>: A <code>DeleteStackInstances</code> operation has failed and left the stack in
     *         an unstable state. Stacks in this state are excluded from further <code>UpdateStackSet</code> operations.
     *         You might need to perform a <code>DeleteStackInstances</code> operation, with <code>RetainStacks</code>
     *         set to <code>true</code>, to delete the stack instance, and then delete the stack manually.
     *         <code>INOPERABLE</code> can be returned here when the cause is a failed import. If it's due to a failed
     *         import, the operation can be retried once the failures are fixed. To see if this is due to a failed
     *         import, call the <a>DescribeStackInstance</a> API operation, look at the <code>DetailedStatus</code>
     *         member returned in the <code>StackInstanceSummary</code> member.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>OUTDATED</code>: The stack isn't currently up to date with the stack set because:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         The associated stack failed during a <code>CreateStackSet</code> or <code>UpdateStackSet</code>
     *         operation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The stack was part of a <code>CreateStackSet</code> or <code>UpdateStackSet</code> operation that failed
     *         or was stopped before the stack was created or updated.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CURRENT</code>: The stack is currently up to date with the stack set.
     *         </p>
     *         </li>
     * @see StackInstanceStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The explanation for the specific status code assigned to this stack instance.
     * </p>
     * 
     * @return The explanation for the specific status code assigned to this stack instance.
     */
    public final String statusReason() {
        return statusReason;
    }

    /**
     * <p>
     * The detailed status of the stack instance.
     * </p>
     * 
     * @return The detailed status of the stack instance.
     */
    public final StackInstanceComprehensiveStatus stackInstanceStatus() {
        return stackInstanceStatus;
    }

    /**
     * <p>
     * [Service-managed permissions] The organization root ID or organizational unit (OU) IDs that you specified for <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_DeploymentTargets.html">
     * DeploymentTargets</a>.
     * </p>
     * 
     * @return [Service-managed permissions] The organization root ID or organizational unit (OU) IDs that you specified
     *         for <a
     *         href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_DeploymentTargets.html"
     *         >DeploymentTargets</a>.
     */
    public final String organizationalUnitId() {
        return organizationalUnitId;
    }

    /**
     * <p>
     * Status of the stack instance's actual configuration compared to the expected template and parameter configuration
     * of the stack set to which it belongs.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>DRIFTED</code>: The stack differs from the expected template and parameter configuration of the stack set
     * to which it belongs. A stack instance is considered to have drifted if one or more of the resources in the
     * associated stack have drifted.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>NOT_CHECKED</code>: CloudFormation hasn't checked if the stack instance differs from its expected stack set
     * configuration.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>IN_SYNC</code>: The stack instance's actual configuration matches its expected stack set configuration.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>UNKNOWN</code>: This value is reserved for future use.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #driftStatus} will
     * return {@link StackDriftStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #driftStatusAsString}.
     * </p>
     * 
     * @return Status of the stack instance's actual configuration compared to the expected template and parameter
     *         configuration of the stack set to which it belongs.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>DRIFTED</code>: The stack differs from the expected template and parameter configuration of the
     *         stack set to which it belongs. A stack instance is considered to have drifted if one or more of the
     *         resources in the associated stack have drifted.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>NOT_CHECKED</code>: CloudFormation hasn't checked if the stack instance differs from its expected
     *         stack set configuration.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>IN_SYNC</code>: The stack instance's actual configuration matches its expected stack set
     *         configuration.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>UNKNOWN</code>: This value is reserved for future use.
     *         </p>
     *         </li>
     * @see StackDriftStatus
     */
    public final StackDriftStatus driftStatus() {
        return StackDriftStatus.fromValue(driftStatus);
    }

    /**
     * <p>
     * Status of the stack instance's actual configuration compared to the expected template and parameter configuration
     * of the stack set to which it belongs.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>DRIFTED</code>: The stack differs from the expected template and parameter configuration of the stack set
     * to which it belongs. A stack instance is considered to have drifted if one or more of the resources in the
     * associated stack have drifted.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>NOT_CHECKED</code>: CloudFormation hasn't checked if the stack instance differs from its expected stack set
     * configuration.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>IN_SYNC</code>: The stack instance's actual configuration matches its expected stack set configuration.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>UNKNOWN</code>: This value is reserved for future use.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #driftStatus} will
     * return {@link StackDriftStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #driftStatusAsString}.
     * </p>
     * 
     * @return Status of the stack instance's actual configuration compared to the expected template and parameter
     *         configuration of the stack set to which it belongs.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>DRIFTED</code>: The stack differs from the expected template and parameter configuration of the
     *         stack set to which it belongs. A stack instance is considered to have drifted if one or more of the
     *         resources in the associated stack have drifted.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>NOT_CHECKED</code>: CloudFormation hasn't checked if the stack instance differs from its expected
     *         stack set configuration.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>IN_SYNC</code>: The stack instance's actual configuration matches its expected stack set
     *         configuration.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>UNKNOWN</code>: This value is reserved for future use.
     *         </p>
     *         </li>
     * @see StackDriftStatus
     */
    public final String driftStatusAsString() {
        return driftStatus;
    }

    /**
     * <p>
     * Most recent time when CloudFormation performed a drift detection operation on the stack instance. This value will
     * be <code>NULL</code> for any stack instance on which drift detection hasn't yet been performed.
     * </p>
     * 
     * @return Most recent time when CloudFormation performed a drift detection operation on the stack instance. This
     *         value will be <code>NULL</code> for any stack instance on which drift detection hasn't yet been
     *         performed.
     */
    public final Instant lastDriftCheckTimestamp() {
        return lastDriftCheckTimestamp;
    }

    /**
     * <p>
     * The last unique ID of a StackSet operation performed on a stack instance.
     * </p>
     * 
     * @return The last unique ID of a StackSet operation performed on a stack instance.
     */
    public final String lastOperationId() {
        return lastOperationId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(stackSetId());
        hashCode = 31 * hashCode + Objects.hashCode(region());
        hashCode = 31 * hashCode + Objects.hashCode(account());
        hashCode = 31 * hashCode + Objects.hashCode(stackId());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusReason());
        hashCode = 31 * hashCode + Objects.hashCode(stackInstanceStatus());
        hashCode = 31 * hashCode + Objects.hashCode(organizationalUnitId());
        hashCode = 31 * hashCode + Objects.hashCode(driftStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(lastDriftCheckTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(lastOperationId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StackInstanceSummary)) {
            return false;
        }
        StackInstanceSummary other = (StackInstanceSummary) obj;
        return Objects.equals(stackSetId(), other.stackSetId()) && Objects.equals(region(), other.region())
                && Objects.equals(account(), other.account()) && Objects.equals(stackId(), other.stackId())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(statusReason(), other.statusReason())
                && Objects.equals(stackInstanceStatus(), other.stackInstanceStatus())
                && Objects.equals(organizationalUnitId(), other.organizationalUnitId())
                && Objects.equals(driftStatusAsString(), other.driftStatusAsString())
                && Objects.equals(lastDriftCheckTimestamp(), other.lastDriftCheckTimestamp())
                && Objects.equals(lastOperationId(), other.lastOperationId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StackInstanceSummary").add("StackSetId", stackSetId()).add("Region", region())
                .add("Account", account()).add("StackId", stackId()).add("Status", statusAsString())
                .add("StatusReason", statusReason()).add("StackInstanceStatus", stackInstanceStatus())
                .add("OrganizationalUnitId", organizationalUnitId()).add("DriftStatus", driftStatusAsString())
                .add("LastDriftCheckTimestamp", lastDriftCheckTimestamp()).add("LastOperationId", lastOperationId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StackSetId":
            return Optional.ofNullable(clazz.cast(stackSetId()));
        case "Region":
            return Optional.ofNullable(clazz.cast(region()));
        case "Account":
            return Optional.ofNullable(clazz.cast(account()));
        case "StackId":
            return Optional.ofNullable(clazz.cast(stackId()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "StatusReason":
            return Optional.ofNullable(clazz.cast(statusReason()));
        case "StackInstanceStatus":
            return Optional.ofNullable(clazz.cast(stackInstanceStatus()));
        case "OrganizationalUnitId":
            return Optional.ofNullable(clazz.cast(organizationalUnitId()));
        case "DriftStatus":
            return Optional.ofNullable(clazz.cast(driftStatusAsString()));
        case "LastDriftCheckTimestamp":
            return Optional.ofNullable(clazz.cast(lastDriftCheckTimestamp()));
        case "LastOperationId":
            return Optional.ofNullable(clazz.cast(lastOperationId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("StackSetId", STACK_SET_ID_FIELD);
        map.put("Region", REGION_FIELD);
        map.put("Account", ACCOUNT_FIELD);
        map.put("StackId", STACK_ID_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("StatusReason", STATUS_REASON_FIELD);
        map.put("StackInstanceStatus", STACK_INSTANCE_STATUS_FIELD);
        map.put("OrganizationalUnitId", ORGANIZATIONAL_UNIT_ID_FIELD);
        map.put("DriftStatus", DRIFT_STATUS_FIELD);
        map.put("LastDriftCheckTimestamp", LAST_DRIFT_CHECK_TIMESTAMP_FIELD);
        map.put("LastOperationId", LAST_OPERATION_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StackInstanceSummary, T> g) {
        return obj -> g.apply((StackInstanceSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, StackInstanceSummary> {
        /**
         * <p>
         * The name or unique ID of the stack set that the stack instance is associated with.
         * </p>
         * 
         * @param stackSetId
         *        The name or unique ID of the stack set that the stack instance is associated with.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stackSetId(String stackSetId);

        /**
         * <p>
         * The name of the Amazon Web Services Region that the stack instance is associated with.
         * </p>
         * 
         * @param region
         *        The name of the Amazon Web Services Region that the stack instance is associated with.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder region(String region);

        /**
         * <p>
         * [Self-managed permissions] The name of the Amazon Web Services account that the stack instance is associated
         * with.
         * </p>
         * 
         * @param account
         *        [Self-managed permissions] The name of the Amazon Web Services account that the stack instance is
         *        associated with.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder account(String account);

        /**
         * <p>
         * The ID of the stack instance.
         * </p>
         * 
         * @param stackId
         *        The ID of the stack instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stackId(String stackId);

        /**
         * <p>
         * The status of the stack instance, in terms of its synchronization with its associated stack set.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>INOPERABLE</code>: A <code>DeleteStackInstances</code> operation has failed and left the stack in an
         * unstable state. Stacks in this state are excluded from further <code>UpdateStackSet</code> operations. You
         * might need to perform a <code>DeleteStackInstances</code> operation, with <code>RetainStacks</code> set to
         * <code>true</code>, to delete the stack instance, and then delete the stack manually. <code>INOPERABLE</code>
         * can be returned here when the cause is a failed import. If it's due to a failed import, the operation can be
         * retried once the failures are fixed. To see if this is due to a failed import, call the
         * <a>DescribeStackInstance</a> API operation, look at the <code>DetailedStatus</code> member returned in the
         * <code>StackInstanceSummary</code> member.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>OUTDATED</code>: The stack isn't currently up to date with the stack set because:
         * </p>
         * <ul>
         * <li>
         * <p>
         * The associated stack failed during a <code>CreateStackSet</code> or <code>UpdateStackSet</code> operation.
         * </p>
         * </li>
         * <li>
         * <p>
         * The stack was part of a <code>CreateStackSet</code> or <code>UpdateStackSet</code> operation that failed or
         * was stopped before the stack was created or updated.
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <code>CURRENT</code>: The stack is currently up to date with the stack set.
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The status of the stack instance, in terms of its synchronization with its associated stack set.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>INOPERABLE</code>: A <code>DeleteStackInstances</code> operation has failed and left the stack
         *        in an unstable state. Stacks in this state are excluded from further <code>UpdateStackSet</code>
         *        operations. You might need to perform a <code>DeleteStackInstances</code> operation, with
         *        <code>RetainStacks</code> set to <code>true</code>, to delete the stack instance, and then delete the
         *        stack manually. <code>INOPERABLE</code> can be returned here when the cause is a failed import. If
         *        it's due to a failed import, the operation can be retried once the failures are fixed. To see if this
         *        is due to a failed import, call the <a>DescribeStackInstance</a> API operation, look at the
         *        <code>DetailedStatus</code> member returned in the <code>StackInstanceSummary</code> member.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>OUTDATED</code>: The stack isn't currently up to date with the stack set because:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        The associated stack failed during a <code>CreateStackSet</code> or <code>UpdateStackSet</code>
         *        operation.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The stack was part of a <code>CreateStackSet</code> or <code>UpdateStackSet</code> operation that
         *        failed or was stopped before the stack was created or updated.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CURRENT</code>: The stack is currently up to date with the stack set.
         *        </p>
         *        </li>
         * @see StackInstanceStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StackInstanceStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the stack instance, in terms of its synchronization with its associated stack set.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>INOPERABLE</code>: A <code>DeleteStackInstances</code> operation has failed and left the stack in an
         * unstable state. Stacks in this state are excluded from further <code>UpdateStackSet</code> operations. You
         * might need to perform a <code>DeleteStackInstances</code> operation, with <code>RetainStacks</code> set to
         * <code>true</code>, to delete the stack instance, and then delete the stack manually. <code>INOPERABLE</code>
         * can be returned here when the cause is a failed import. If it's due to a failed import, the operation can be
         * retried once the failures are fixed. To see if this is due to a failed import, call the
         * <a>DescribeStackInstance</a> API operation, look at the <code>DetailedStatus</code> member returned in the
         * <code>StackInstanceSummary</code> member.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>OUTDATED</code>: The stack isn't currently up to date with the stack set because:
         * </p>
         * <ul>
         * <li>
         * <p>
         * The associated stack failed during a <code>CreateStackSet</code> or <code>UpdateStackSet</code> operation.
         * </p>
         * </li>
         * <li>
         * <p>
         * The stack was part of a <code>CreateStackSet</code> or <code>UpdateStackSet</code> operation that failed or
         * was stopped before the stack was created or updated.
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <code>CURRENT</code>: The stack is currently up to date with the stack set.
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The status of the stack instance, in terms of its synchronization with its associated stack set.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>INOPERABLE</code>: A <code>DeleteStackInstances</code> operation has failed and left the stack
         *        in an unstable state. Stacks in this state are excluded from further <code>UpdateStackSet</code>
         *        operations. You might need to perform a <code>DeleteStackInstances</code> operation, with
         *        <code>RetainStacks</code> set to <code>true</code>, to delete the stack instance, and then delete the
         *        stack manually. <code>INOPERABLE</code> can be returned here when the cause is a failed import. If
         *        it's due to a failed import, the operation can be retried once the failures are fixed. To see if this
         *        is due to a failed import, call the <a>DescribeStackInstance</a> API operation, look at the
         *        <code>DetailedStatus</code> member returned in the <code>StackInstanceSummary</code> member.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>OUTDATED</code>: The stack isn't currently up to date with the stack set because:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        The associated stack failed during a <code>CreateStackSet</code> or <code>UpdateStackSet</code>
         *        operation.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The stack was part of a <code>CreateStackSet</code> or <code>UpdateStackSet</code> operation that
         *        failed or was stopped before the stack was created or updated.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CURRENT</code>: The stack is currently up to date with the stack set.
         *        </p>
         *        </li>
         * @see StackInstanceStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StackInstanceStatus
         */
        Builder status(StackInstanceStatus status);

        /**
         * <p>
         * The explanation for the specific status code assigned to this stack instance.
         * </p>
         * 
         * @param statusReason
         *        The explanation for the specific status code assigned to this stack instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusReason(String statusReason);

        /**
         * <p>
         * The detailed status of the stack instance.
         * </p>
         * 
         * @param stackInstanceStatus
         *        The detailed status of the stack instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stackInstanceStatus(StackInstanceComprehensiveStatus stackInstanceStatus);

        /**
         * <p>
         * The detailed status of the stack instance.
         * </p>
         * This is a convenience method that creates an instance of the {@link StackInstanceComprehensiveStatus.Builder}
         * avoiding the need to create one manually via {@link StackInstanceComprehensiveStatus#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link StackInstanceComprehensiveStatus.Builder#build()} is called
         * immediately and its result is passed to {@link #stackInstanceStatus(StackInstanceComprehensiveStatus)}.
         * 
         * @param stackInstanceStatus
         *        a consumer that will call methods on {@link StackInstanceComprehensiveStatus.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #stackInstanceStatus(StackInstanceComprehensiveStatus)
         */
        default Builder stackInstanceStatus(Consumer<StackInstanceComprehensiveStatus.Builder> stackInstanceStatus) {
            return stackInstanceStatus(StackInstanceComprehensiveStatus.builder().applyMutation(stackInstanceStatus).build());
        }

        /**
         * <p>
         * [Service-managed permissions] The organization root ID or organizational unit (OU) IDs that you specified for
         * <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_DeploymentTargets.html">
         * DeploymentTargets</a>.
         * </p>
         * 
         * @param organizationalUnitId
         *        [Service-managed permissions] The organization root ID or organizational unit (OU) IDs that you
         *        specified for <a
         *        href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_DeploymentTargets.html"
         *        >DeploymentTargets</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder organizationalUnitId(String organizationalUnitId);

        /**
         * <p>
         * Status of the stack instance's actual configuration compared to the expected template and parameter
         * configuration of the stack set to which it belongs.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>DRIFTED</code>: The stack differs from the expected template and parameter configuration of the stack
         * set to which it belongs. A stack instance is considered to have drifted if one or more of the resources in
         * the associated stack have drifted.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>NOT_CHECKED</code>: CloudFormation hasn't checked if the stack instance differs from its expected stack
         * set configuration.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>IN_SYNC</code>: The stack instance's actual configuration matches its expected stack set configuration.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>UNKNOWN</code>: This value is reserved for future use.
         * </p>
         * </li>
         * </ul>
         * 
         * @param driftStatus
         *        Status of the stack instance's actual configuration compared to the expected template and parameter
         *        configuration of the stack set to which it belongs.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>DRIFTED</code>: The stack differs from the expected template and parameter configuration of the
         *        stack set to which it belongs. A stack instance is considered to have drifted if one or more of the
         *        resources in the associated stack have drifted.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>NOT_CHECKED</code>: CloudFormation hasn't checked if the stack instance differs from its
         *        expected stack set configuration.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>IN_SYNC</code>: The stack instance's actual configuration matches its expected stack set
         *        configuration.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>UNKNOWN</code>: This value is reserved for future use.
         *        </p>
         *        </li>
         * @see StackDriftStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StackDriftStatus
         */
        Builder driftStatus(String driftStatus);

        /**
         * <p>
         * Status of the stack instance's actual configuration compared to the expected template and parameter
         * configuration of the stack set to which it belongs.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>DRIFTED</code>: The stack differs from the expected template and parameter configuration of the stack
         * set to which it belongs. A stack instance is considered to have drifted if one or more of the resources in
         * the associated stack have drifted.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>NOT_CHECKED</code>: CloudFormation hasn't checked if the stack instance differs from its expected stack
         * set configuration.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>IN_SYNC</code>: The stack instance's actual configuration matches its expected stack set configuration.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>UNKNOWN</code>: This value is reserved for future use.
         * </p>
         * </li>
         * </ul>
         * 
         * @param driftStatus
         *        Status of the stack instance's actual configuration compared to the expected template and parameter
         *        configuration of the stack set to which it belongs.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>DRIFTED</code>: The stack differs from the expected template and parameter configuration of the
         *        stack set to which it belongs. A stack instance is considered to have drifted if one or more of the
         *        resources in the associated stack have drifted.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>NOT_CHECKED</code>: CloudFormation hasn't checked if the stack instance differs from its
         *        expected stack set configuration.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>IN_SYNC</code>: The stack instance's actual configuration matches its expected stack set
         *        configuration.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>UNKNOWN</code>: This value is reserved for future use.
         *        </p>
         *        </li>
         * @see StackDriftStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StackDriftStatus
         */
        Builder driftStatus(StackDriftStatus driftStatus);

        /**
         * <p>
         * Most recent time when CloudFormation performed a drift detection operation on the stack instance. This value
         * will be <code>NULL</code> for any stack instance on which drift detection hasn't yet been performed.
         * </p>
         * 
         * @param lastDriftCheckTimestamp
         *        Most recent time when CloudFormation performed a drift detection operation on the stack instance. This
         *        value will be <code>NULL</code> for any stack instance on which drift detection hasn't yet been
         *        performed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastDriftCheckTimestamp(Instant lastDriftCheckTimestamp);

        /**
         * <p>
         * The last unique ID of a StackSet operation performed on a stack instance.
         * </p>
         * 
         * @param lastOperationId
         *        The last unique ID of a StackSet operation performed on a stack instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastOperationId(String lastOperationId);
    }

    static final class BuilderImpl implements Builder {
        private String stackSetId;

        private String region;

        private String account;

        private String stackId;

        private String status;

        private String statusReason;

        private StackInstanceComprehensiveStatus stackInstanceStatus;

        private String organizationalUnitId;

        private String driftStatus;

        private Instant lastDriftCheckTimestamp;

        private String lastOperationId;

        private BuilderImpl() {
        }

        private BuilderImpl(StackInstanceSummary model) {
            stackSetId(model.stackSetId);
            region(model.region);
            account(model.account);
            stackId(model.stackId);
            status(model.status);
            statusReason(model.statusReason);
            stackInstanceStatus(model.stackInstanceStatus);
            organizationalUnitId(model.organizationalUnitId);
            driftStatus(model.driftStatus);
            lastDriftCheckTimestamp(model.lastDriftCheckTimestamp);
            lastOperationId(model.lastOperationId);
        }

        public final String getStackSetId() {
            return stackSetId;
        }

        public final void setStackSetId(String stackSetId) {
            this.stackSetId = stackSetId;
        }

        @Override
        public final Builder stackSetId(String stackSetId) {
            this.stackSetId = stackSetId;
            return this;
        }

        public final String getRegion() {
            return region;
        }

        public final void setRegion(String region) {
            this.region = region;
        }

        @Override
        public final Builder region(String region) {
            this.region = region;
            return this;
        }

        public final String getAccount() {
            return account;
        }

        public final void setAccount(String account) {
            this.account = account;
        }

        @Override
        public final Builder account(String account) {
            this.account = account;
            return this;
        }

        public final String getStackId() {
            return stackId;
        }

        public final void setStackId(String stackId) {
            this.stackId = stackId;
        }

        @Override
        public final Builder stackId(String stackId) {
            this.stackId = stackId;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(StackInstanceStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusReason() {
            return statusReason;
        }

        public final void setStatusReason(String statusReason) {
            this.statusReason = statusReason;
        }

        @Override
        public final Builder statusReason(String statusReason) {
            this.statusReason = statusReason;
            return this;
        }

        public final StackInstanceComprehensiveStatus.Builder getStackInstanceStatus() {
            return stackInstanceStatus != null ? stackInstanceStatus.toBuilder() : null;
        }

        public final void setStackInstanceStatus(StackInstanceComprehensiveStatus.BuilderImpl stackInstanceStatus) {
            this.stackInstanceStatus = stackInstanceStatus != null ? stackInstanceStatus.build() : null;
        }

        @Override
        public final Builder stackInstanceStatus(StackInstanceComprehensiveStatus stackInstanceStatus) {
            this.stackInstanceStatus = stackInstanceStatus;
            return this;
        }

        public final String getOrganizationalUnitId() {
            return organizationalUnitId;
        }

        public final void setOrganizationalUnitId(String organizationalUnitId) {
            this.organizationalUnitId = organizationalUnitId;
        }

        @Override
        public final Builder organizationalUnitId(String organizationalUnitId) {
            this.organizationalUnitId = organizationalUnitId;
            return this;
        }

        public final String getDriftStatus() {
            return driftStatus;
        }

        public final void setDriftStatus(String driftStatus) {
            this.driftStatus = driftStatus;
        }

        @Override
        public final Builder driftStatus(String driftStatus) {
            this.driftStatus = driftStatus;
            return this;
        }

        @Override
        public final Builder driftStatus(StackDriftStatus driftStatus) {
            this.driftStatus(driftStatus == null ? null : driftStatus.toString());
            return this;
        }

        public final Instant getLastDriftCheckTimestamp() {
            return lastDriftCheckTimestamp;
        }

        public final void setLastDriftCheckTimestamp(Instant lastDriftCheckTimestamp) {
            this.lastDriftCheckTimestamp = lastDriftCheckTimestamp;
        }

        @Override
        public final Builder lastDriftCheckTimestamp(Instant lastDriftCheckTimestamp) {
            this.lastDriftCheckTimestamp = lastDriftCheckTimestamp;
            return this;
        }

        public final String getLastOperationId() {
            return lastOperationId;
        }

        public final void setLastOperationId(String lastOperationId) {
            this.lastOperationId = lastOperationId;
        }

        @Override
        public final Builder lastOperationId(String lastOperationId) {
            this.lastOperationId = lastOperationId;
            return this;
        }

        @Override
        public StackInstanceSummary build() {
            return new StackInstanceSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
