/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudformation.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeTypeRequest extends CloudFormationRequest implements
        ToCopyableBuilder<DescribeTypeRequest.Builder, DescribeTypeRequest> {
    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(DescribeTypeRequest::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final SdkField<String> TYPE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TypeName").getter(getter(DescribeTypeRequest::typeName)).setter(setter(Builder::typeName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TypeName").build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(DescribeTypeRequest::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<String> VERSION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VersionId").getter(getter(DescribeTypeRequest::versionId)).setter(setter(Builder::versionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VersionId").build()).build();

    private static final SdkField<String> PUBLISHER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PublisherId").getter(getter(DescribeTypeRequest::publisherId)).setter(setter(Builder::publisherId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PublisherId").build()).build();

    private static final SdkField<String> PUBLIC_VERSION_NUMBER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PublicVersionNumber").getter(getter(DescribeTypeRequest::publicVersionNumber))
            .setter(setter(Builder::publicVersionNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PublicVersionNumber").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD, TYPE_NAME_FIELD,
            ARN_FIELD, VERSION_ID_FIELD, PUBLISHER_ID_FIELD, PUBLIC_VERSION_NUMBER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String type;

    private final String typeName;

    private final String arn;

    private final String versionId;

    private final String publisherId;

    private final String publicVersionNumber;

    private DescribeTypeRequest(BuilderImpl builder) {
        super(builder);
        this.type = builder.type;
        this.typeName = builder.typeName;
        this.arn = builder.arn;
        this.versionId = builder.versionId;
        this.publisherId = builder.publisherId;
        this.publicVersionNumber = builder.publicVersionNumber;
    }

    /**
     * <p>
     * The kind of extension.
     * </p>
     * <p>
     * Conditional: You must specify either <code>TypeName</code> and <code>Type</code>, or <code>Arn</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link RegistryType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The kind of extension.</p>
     *         <p>
     *         Conditional: You must specify either <code>TypeName</code> and <code>Type</code>, or <code>Arn</code>.
     * @see RegistryType
     */
    public final RegistryType type() {
        return RegistryType.fromValue(type);
    }

    /**
     * <p>
     * The kind of extension.
     * </p>
     * <p>
     * Conditional: You must specify either <code>TypeName</code> and <code>Type</code>, or <code>Arn</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link RegistryType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The kind of extension.</p>
     *         <p>
     *         Conditional: You must specify either <code>TypeName</code> and <code>Type</code>, or <code>Arn</code>.
     * @see RegistryType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The name of the extension.
     * </p>
     * <p>
     * Conditional: You must specify either <code>TypeName</code> and <code>Type</code>, or <code>Arn</code>.
     * </p>
     * 
     * @return The name of the extension.</p>
     *         <p>
     *         Conditional: You must specify either <code>TypeName</code> and <code>Type</code>, or <code>Arn</code>.
     */
    public final String typeName() {
        return typeName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the extension.
     * </p>
     * <p>
     * Conditional: You must specify either <code>TypeName</code> and <code>Type</code>, or <code>Arn</code>.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the extension.</p>
     *         <p>
     *         Conditional: You must specify either <code>TypeName</code> and <code>Type</code>, or <code>Arn</code>.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The ID of a specific version of the extension. The version ID is the value at the end of the Amazon Resource Name
     * (ARN) assigned to the extension version when it is registered.
     * </p>
     * <p>
     * If you specify a <code>VersionId</code>, <code>DescribeType</code> returns information about that specific
     * extension version. Otherwise, it returns information about the default extension version.
     * </p>
     * 
     * @return The ID of a specific version of the extension. The version ID is the value at the end of the Amazon
     *         Resource Name (ARN) assigned to the extension version when it is registered.</p>
     *         <p>
     *         If you specify a <code>VersionId</code>, <code>DescribeType</code> returns information about that
     *         specific extension version. Otherwise, it returns information about the default extension version.
     */
    public final String versionId() {
        return versionId;
    }

    /**
     * <p>
     * The publisher ID of the extension publisher.
     * </p>
     * <p>
     * Extensions provided by Amazon Web Services are not assigned a publisher ID.
     * </p>
     * 
     * @return The publisher ID of the extension publisher.</p>
     *         <p>
     *         Extensions provided by Amazon Web Services are not assigned a publisher ID.
     */
    public final String publisherId() {
        return publisherId;
    }

    /**
     * <p>
     * The version number of a public third-party extension.
     * </p>
     * 
     * @return The version number of a public third-party extension.
     */
    public final String publicVersionNumber() {
        return publicVersionNumber;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(typeName());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(versionId());
        hashCode = 31 * hashCode + Objects.hashCode(publisherId());
        hashCode = 31 * hashCode + Objects.hashCode(publicVersionNumber());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeTypeRequest)) {
            return false;
        }
        DescribeTypeRequest other = (DescribeTypeRequest) obj;
        return Objects.equals(typeAsString(), other.typeAsString()) && Objects.equals(typeName(), other.typeName())
                && Objects.equals(arn(), other.arn()) && Objects.equals(versionId(), other.versionId())
                && Objects.equals(publisherId(), other.publisherId())
                && Objects.equals(publicVersionNumber(), other.publicVersionNumber());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeTypeRequest").add("Type", typeAsString()).add("TypeName", typeName()).add("Arn", arn())
                .add("VersionId", versionId()).add("PublisherId", publisherId())
                .add("PublicVersionNumber", publicVersionNumber()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "TypeName":
            return Optional.ofNullable(clazz.cast(typeName()));
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "VersionId":
            return Optional.ofNullable(clazz.cast(versionId()));
        case "PublisherId":
            return Optional.ofNullable(clazz.cast(publisherId()));
        case "PublicVersionNumber":
            return Optional.ofNullable(clazz.cast(publicVersionNumber()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Type", TYPE_FIELD);
        map.put("TypeName", TYPE_NAME_FIELD);
        map.put("Arn", ARN_FIELD);
        map.put("VersionId", VERSION_ID_FIELD);
        map.put("PublisherId", PUBLISHER_ID_FIELD);
        map.put("PublicVersionNumber", PUBLIC_VERSION_NUMBER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeTypeRequest, T> g) {
        return obj -> g.apply((DescribeTypeRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudFormationRequest.Builder, SdkPojo, CopyableBuilder<Builder, DescribeTypeRequest> {
        /**
         * <p>
         * The kind of extension.
         * </p>
         * <p>
         * Conditional: You must specify either <code>TypeName</code> and <code>Type</code>, or <code>Arn</code>.
         * </p>
         * 
         * @param type
         *        The kind of extension.</p>
         *        <p>
         *        Conditional: You must specify either <code>TypeName</code> and <code>Type</code>, or <code>Arn</code>.
         * @see RegistryType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RegistryType
         */
        Builder type(String type);

        /**
         * <p>
         * The kind of extension.
         * </p>
         * <p>
         * Conditional: You must specify either <code>TypeName</code> and <code>Type</code>, or <code>Arn</code>.
         * </p>
         * 
         * @param type
         *        The kind of extension.</p>
         *        <p>
         *        Conditional: You must specify either <code>TypeName</code> and <code>Type</code>, or <code>Arn</code>.
         * @see RegistryType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RegistryType
         */
        Builder type(RegistryType type);

        /**
         * <p>
         * The name of the extension.
         * </p>
         * <p>
         * Conditional: You must specify either <code>TypeName</code> and <code>Type</code>, or <code>Arn</code>.
         * </p>
         * 
         * @param typeName
         *        The name of the extension.</p>
         *        <p>
         *        Conditional: You must specify either <code>TypeName</code> and <code>Type</code>, or <code>Arn</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder typeName(String typeName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the extension.
         * </p>
         * <p>
         * Conditional: You must specify either <code>TypeName</code> and <code>Type</code>, or <code>Arn</code>.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the extension.</p>
         *        <p>
         *        Conditional: You must specify either <code>TypeName</code> and <code>Type</code>, or <code>Arn</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The ID of a specific version of the extension. The version ID is the value at the end of the Amazon Resource
         * Name (ARN) assigned to the extension version when it is registered.
         * </p>
         * <p>
         * If you specify a <code>VersionId</code>, <code>DescribeType</code> returns information about that specific
         * extension version. Otherwise, it returns information about the default extension version.
         * </p>
         * 
         * @param versionId
         *        The ID of a specific version of the extension. The version ID is the value at the end of the Amazon
         *        Resource Name (ARN) assigned to the extension version when it is registered.</p>
         *        <p>
         *        If you specify a <code>VersionId</code>, <code>DescribeType</code> returns information about that
         *        specific extension version. Otherwise, it returns information about the default extension version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder versionId(String versionId);

        /**
         * <p>
         * The publisher ID of the extension publisher.
         * </p>
         * <p>
         * Extensions provided by Amazon Web Services are not assigned a publisher ID.
         * </p>
         * 
         * @param publisherId
         *        The publisher ID of the extension publisher.</p>
         *        <p>
         *        Extensions provided by Amazon Web Services are not assigned a publisher ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder publisherId(String publisherId);

        /**
         * <p>
         * The version number of a public third-party extension.
         * </p>
         * 
         * @param publicVersionNumber
         *        The version number of a public third-party extension.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder publicVersionNumber(String publicVersionNumber);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CloudFormationRequest.BuilderImpl implements Builder {
        private String type;

        private String typeName;

        private String arn;

        private String versionId;

        private String publisherId;

        private String publicVersionNumber;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeTypeRequest model) {
            super(model);
            type(model.type);
            typeName(model.typeName);
            arn(model.arn);
            versionId(model.versionId);
            publisherId(model.publisherId);
            publicVersionNumber(model.publicVersionNumber);
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(RegistryType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getTypeName() {
            return typeName;
        }

        public final void setTypeName(String typeName) {
            this.typeName = typeName;
        }

        @Override
        public final Builder typeName(String typeName) {
            this.typeName = typeName;
            return this;
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getVersionId() {
            return versionId;
        }

        public final void setVersionId(String versionId) {
            this.versionId = versionId;
        }

        @Override
        public final Builder versionId(String versionId) {
            this.versionId = versionId;
            return this;
        }

        public final String getPublisherId() {
            return publisherId;
        }

        public final void setPublisherId(String publisherId) {
            this.publisherId = publisherId;
        }

        @Override
        public final Builder publisherId(String publisherId) {
            this.publisherId = publisherId;
            return this;
        }

        public final String getPublicVersionNumber() {
            return publicVersionNumber;
        }

        public final void setPublicVersionNumber(String publicVersionNumber) {
            this.publicVersionNumber = publicVersionNumber;
        }

        @Override
        public final Builder publicVersionNumber(String publicVersionNumber) {
            this.publicVersionNumber = publicVersionNumber;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeTypeRequest build() {
            return new DescribeTypeRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
