/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudformation;

import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.AwsProtocolMetadata;
import software.amazon.awssdk.awscore.internal.AwsServiceProtocol;
import software.amazon.awssdk.awscore.retry.AwsRetryStrategy;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.retry.RetryMode;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.query.AwsQueryProtocolFactory;
import software.amazon.awssdk.retries.api.RetryStrategy;
import software.amazon.awssdk.services.cloudformation.internal.CloudFormationServiceClientConfigurationBuilder;
import software.amazon.awssdk.services.cloudformation.model.ActivateOrganizationsAccessRequest;
import software.amazon.awssdk.services.cloudformation.model.ActivateOrganizationsAccessResponse;
import software.amazon.awssdk.services.cloudformation.model.ActivateTypeRequest;
import software.amazon.awssdk.services.cloudformation.model.ActivateTypeResponse;
import software.amazon.awssdk.services.cloudformation.model.AlreadyExistsException;
import software.amazon.awssdk.services.cloudformation.model.BatchDescribeTypeConfigurationsRequest;
import software.amazon.awssdk.services.cloudformation.model.BatchDescribeTypeConfigurationsResponse;
import software.amazon.awssdk.services.cloudformation.model.CancelUpdateStackRequest;
import software.amazon.awssdk.services.cloudformation.model.CancelUpdateStackResponse;
import software.amazon.awssdk.services.cloudformation.model.CfnRegistryException;
import software.amazon.awssdk.services.cloudformation.model.ChangeSetNotFoundException;
import software.amazon.awssdk.services.cloudformation.model.CloudFormationException;
import software.amazon.awssdk.services.cloudformation.model.ConcurrentResourcesLimitExceededException;
import software.amazon.awssdk.services.cloudformation.model.ContinueUpdateRollbackRequest;
import software.amazon.awssdk.services.cloudformation.model.ContinueUpdateRollbackResponse;
import software.amazon.awssdk.services.cloudformation.model.CreateChangeSetRequest;
import software.amazon.awssdk.services.cloudformation.model.CreateChangeSetResponse;
import software.amazon.awssdk.services.cloudformation.model.CreateGeneratedTemplateRequest;
import software.amazon.awssdk.services.cloudformation.model.CreateGeneratedTemplateResponse;
import software.amazon.awssdk.services.cloudformation.model.CreateStackInstancesRequest;
import software.amazon.awssdk.services.cloudformation.model.CreateStackInstancesResponse;
import software.amazon.awssdk.services.cloudformation.model.CreateStackRefactorRequest;
import software.amazon.awssdk.services.cloudformation.model.CreateStackRefactorResponse;
import software.amazon.awssdk.services.cloudformation.model.CreateStackRequest;
import software.amazon.awssdk.services.cloudformation.model.CreateStackResponse;
import software.amazon.awssdk.services.cloudformation.model.CreateStackSetRequest;
import software.amazon.awssdk.services.cloudformation.model.CreateStackSetResponse;
import software.amazon.awssdk.services.cloudformation.model.CreatedButModifiedException;
import software.amazon.awssdk.services.cloudformation.model.DeactivateOrganizationsAccessRequest;
import software.amazon.awssdk.services.cloudformation.model.DeactivateOrganizationsAccessResponse;
import software.amazon.awssdk.services.cloudformation.model.DeactivateTypeRequest;
import software.amazon.awssdk.services.cloudformation.model.DeactivateTypeResponse;
import software.amazon.awssdk.services.cloudformation.model.DeleteChangeSetRequest;
import software.amazon.awssdk.services.cloudformation.model.DeleteChangeSetResponse;
import software.amazon.awssdk.services.cloudformation.model.DeleteGeneratedTemplateRequest;
import software.amazon.awssdk.services.cloudformation.model.DeleteGeneratedTemplateResponse;
import software.amazon.awssdk.services.cloudformation.model.DeleteStackInstancesRequest;
import software.amazon.awssdk.services.cloudformation.model.DeleteStackInstancesResponse;
import software.amazon.awssdk.services.cloudformation.model.DeleteStackRequest;
import software.amazon.awssdk.services.cloudformation.model.DeleteStackResponse;
import software.amazon.awssdk.services.cloudformation.model.DeleteStackSetRequest;
import software.amazon.awssdk.services.cloudformation.model.DeleteStackSetResponse;
import software.amazon.awssdk.services.cloudformation.model.DeregisterTypeRequest;
import software.amazon.awssdk.services.cloudformation.model.DeregisterTypeResponse;
import software.amazon.awssdk.services.cloudformation.model.DescribeAccountLimitsRequest;
import software.amazon.awssdk.services.cloudformation.model.DescribeAccountLimitsResponse;
import software.amazon.awssdk.services.cloudformation.model.DescribeChangeSetHooksRequest;
import software.amazon.awssdk.services.cloudformation.model.DescribeChangeSetHooksResponse;
import software.amazon.awssdk.services.cloudformation.model.DescribeChangeSetRequest;
import software.amazon.awssdk.services.cloudformation.model.DescribeChangeSetResponse;
import software.amazon.awssdk.services.cloudformation.model.DescribeGeneratedTemplateRequest;
import software.amazon.awssdk.services.cloudformation.model.DescribeGeneratedTemplateResponse;
import software.amazon.awssdk.services.cloudformation.model.DescribeOrganizationsAccessRequest;
import software.amazon.awssdk.services.cloudformation.model.DescribeOrganizationsAccessResponse;
import software.amazon.awssdk.services.cloudformation.model.DescribePublisherRequest;
import software.amazon.awssdk.services.cloudformation.model.DescribePublisherResponse;
import software.amazon.awssdk.services.cloudformation.model.DescribeResourceScanRequest;
import software.amazon.awssdk.services.cloudformation.model.DescribeResourceScanResponse;
import software.amazon.awssdk.services.cloudformation.model.DescribeStackDriftDetectionStatusRequest;
import software.amazon.awssdk.services.cloudformation.model.DescribeStackDriftDetectionStatusResponse;
import software.amazon.awssdk.services.cloudformation.model.DescribeStackEventsRequest;
import software.amazon.awssdk.services.cloudformation.model.DescribeStackEventsResponse;
import software.amazon.awssdk.services.cloudformation.model.DescribeStackInstanceRequest;
import software.amazon.awssdk.services.cloudformation.model.DescribeStackInstanceResponse;
import software.amazon.awssdk.services.cloudformation.model.DescribeStackRefactorRequest;
import software.amazon.awssdk.services.cloudformation.model.DescribeStackRefactorResponse;
import software.amazon.awssdk.services.cloudformation.model.DescribeStackResourceDriftsRequest;
import software.amazon.awssdk.services.cloudformation.model.DescribeStackResourceDriftsResponse;
import software.amazon.awssdk.services.cloudformation.model.DescribeStackResourceRequest;
import software.amazon.awssdk.services.cloudformation.model.DescribeStackResourceResponse;
import software.amazon.awssdk.services.cloudformation.model.DescribeStackResourcesRequest;
import software.amazon.awssdk.services.cloudformation.model.DescribeStackResourcesResponse;
import software.amazon.awssdk.services.cloudformation.model.DescribeStackSetOperationRequest;
import software.amazon.awssdk.services.cloudformation.model.DescribeStackSetOperationResponse;
import software.amazon.awssdk.services.cloudformation.model.DescribeStackSetRequest;
import software.amazon.awssdk.services.cloudformation.model.DescribeStackSetResponse;
import software.amazon.awssdk.services.cloudformation.model.DescribeStacksRequest;
import software.amazon.awssdk.services.cloudformation.model.DescribeStacksResponse;
import software.amazon.awssdk.services.cloudformation.model.DescribeTypeRegistrationRequest;
import software.amazon.awssdk.services.cloudformation.model.DescribeTypeRegistrationResponse;
import software.amazon.awssdk.services.cloudformation.model.DescribeTypeRequest;
import software.amazon.awssdk.services.cloudformation.model.DescribeTypeResponse;
import software.amazon.awssdk.services.cloudformation.model.DetectStackDriftRequest;
import software.amazon.awssdk.services.cloudformation.model.DetectStackDriftResponse;
import software.amazon.awssdk.services.cloudformation.model.DetectStackResourceDriftRequest;
import software.amazon.awssdk.services.cloudformation.model.DetectStackResourceDriftResponse;
import software.amazon.awssdk.services.cloudformation.model.DetectStackSetDriftRequest;
import software.amazon.awssdk.services.cloudformation.model.DetectStackSetDriftResponse;
import software.amazon.awssdk.services.cloudformation.model.EstimateTemplateCostRequest;
import software.amazon.awssdk.services.cloudformation.model.EstimateTemplateCostResponse;
import software.amazon.awssdk.services.cloudformation.model.ExecuteChangeSetRequest;
import software.amazon.awssdk.services.cloudformation.model.ExecuteChangeSetResponse;
import software.amazon.awssdk.services.cloudformation.model.ExecuteStackRefactorRequest;
import software.amazon.awssdk.services.cloudformation.model.ExecuteStackRefactorResponse;
import software.amazon.awssdk.services.cloudformation.model.GeneratedTemplateNotFoundException;
import software.amazon.awssdk.services.cloudformation.model.GetGeneratedTemplateRequest;
import software.amazon.awssdk.services.cloudformation.model.GetGeneratedTemplateResponse;
import software.amazon.awssdk.services.cloudformation.model.GetStackPolicyRequest;
import software.amazon.awssdk.services.cloudformation.model.GetStackPolicyResponse;
import software.amazon.awssdk.services.cloudformation.model.GetTemplateRequest;
import software.amazon.awssdk.services.cloudformation.model.GetTemplateResponse;
import software.amazon.awssdk.services.cloudformation.model.GetTemplateSummaryRequest;
import software.amazon.awssdk.services.cloudformation.model.GetTemplateSummaryResponse;
import software.amazon.awssdk.services.cloudformation.model.HookResultNotFoundException;
import software.amazon.awssdk.services.cloudformation.model.ImportStacksToStackSetRequest;
import software.amazon.awssdk.services.cloudformation.model.ImportStacksToStackSetResponse;
import software.amazon.awssdk.services.cloudformation.model.InsufficientCapabilitiesException;
import software.amazon.awssdk.services.cloudformation.model.InvalidChangeSetStatusException;
import software.amazon.awssdk.services.cloudformation.model.InvalidOperationException;
import software.amazon.awssdk.services.cloudformation.model.InvalidStateTransitionException;
import software.amazon.awssdk.services.cloudformation.model.LimitExceededException;
import software.amazon.awssdk.services.cloudformation.model.ListChangeSetsRequest;
import software.amazon.awssdk.services.cloudformation.model.ListChangeSetsResponse;
import software.amazon.awssdk.services.cloudformation.model.ListExportsRequest;
import software.amazon.awssdk.services.cloudformation.model.ListExportsResponse;
import software.amazon.awssdk.services.cloudformation.model.ListGeneratedTemplatesRequest;
import software.amazon.awssdk.services.cloudformation.model.ListGeneratedTemplatesResponse;
import software.amazon.awssdk.services.cloudformation.model.ListHookResultsRequest;
import software.amazon.awssdk.services.cloudformation.model.ListHookResultsResponse;
import software.amazon.awssdk.services.cloudformation.model.ListImportsRequest;
import software.amazon.awssdk.services.cloudformation.model.ListImportsResponse;
import software.amazon.awssdk.services.cloudformation.model.ListResourceScanRelatedResourcesRequest;
import software.amazon.awssdk.services.cloudformation.model.ListResourceScanRelatedResourcesResponse;
import software.amazon.awssdk.services.cloudformation.model.ListResourceScanResourcesRequest;
import software.amazon.awssdk.services.cloudformation.model.ListResourceScanResourcesResponse;
import software.amazon.awssdk.services.cloudformation.model.ListResourceScansRequest;
import software.amazon.awssdk.services.cloudformation.model.ListResourceScansResponse;
import software.amazon.awssdk.services.cloudformation.model.ListStackInstanceResourceDriftsRequest;
import software.amazon.awssdk.services.cloudformation.model.ListStackInstanceResourceDriftsResponse;
import software.amazon.awssdk.services.cloudformation.model.ListStackInstancesRequest;
import software.amazon.awssdk.services.cloudformation.model.ListStackInstancesResponse;
import software.amazon.awssdk.services.cloudformation.model.ListStackRefactorActionsRequest;
import software.amazon.awssdk.services.cloudformation.model.ListStackRefactorActionsResponse;
import software.amazon.awssdk.services.cloudformation.model.ListStackRefactorsRequest;
import software.amazon.awssdk.services.cloudformation.model.ListStackRefactorsResponse;
import software.amazon.awssdk.services.cloudformation.model.ListStackResourcesRequest;
import software.amazon.awssdk.services.cloudformation.model.ListStackResourcesResponse;
import software.amazon.awssdk.services.cloudformation.model.ListStackSetAutoDeploymentTargetsRequest;
import software.amazon.awssdk.services.cloudformation.model.ListStackSetAutoDeploymentTargetsResponse;
import software.amazon.awssdk.services.cloudformation.model.ListStackSetOperationResultsRequest;
import software.amazon.awssdk.services.cloudformation.model.ListStackSetOperationResultsResponse;
import software.amazon.awssdk.services.cloudformation.model.ListStackSetOperationsRequest;
import software.amazon.awssdk.services.cloudformation.model.ListStackSetOperationsResponse;
import software.amazon.awssdk.services.cloudformation.model.ListStackSetsRequest;
import software.amazon.awssdk.services.cloudformation.model.ListStackSetsResponse;
import software.amazon.awssdk.services.cloudformation.model.ListStacksRequest;
import software.amazon.awssdk.services.cloudformation.model.ListStacksResponse;
import software.amazon.awssdk.services.cloudformation.model.ListTypeRegistrationsRequest;
import software.amazon.awssdk.services.cloudformation.model.ListTypeRegistrationsResponse;
import software.amazon.awssdk.services.cloudformation.model.ListTypeVersionsRequest;
import software.amazon.awssdk.services.cloudformation.model.ListTypeVersionsResponse;
import software.amazon.awssdk.services.cloudformation.model.ListTypesRequest;
import software.amazon.awssdk.services.cloudformation.model.ListTypesResponse;
import software.amazon.awssdk.services.cloudformation.model.NameAlreadyExistsException;
import software.amazon.awssdk.services.cloudformation.model.OperationIdAlreadyExistsException;
import software.amazon.awssdk.services.cloudformation.model.OperationInProgressException;
import software.amazon.awssdk.services.cloudformation.model.OperationNotFoundException;
import software.amazon.awssdk.services.cloudformation.model.OperationStatusCheckFailedException;
import software.amazon.awssdk.services.cloudformation.model.PublishTypeRequest;
import software.amazon.awssdk.services.cloudformation.model.PublishTypeResponse;
import software.amazon.awssdk.services.cloudformation.model.RecordHandlerProgressRequest;
import software.amazon.awssdk.services.cloudformation.model.RecordHandlerProgressResponse;
import software.amazon.awssdk.services.cloudformation.model.RegisterPublisherRequest;
import software.amazon.awssdk.services.cloudformation.model.RegisterPublisherResponse;
import software.amazon.awssdk.services.cloudformation.model.RegisterTypeRequest;
import software.amazon.awssdk.services.cloudformation.model.RegisterTypeResponse;
import software.amazon.awssdk.services.cloudformation.model.ResourceScanInProgressException;
import software.amazon.awssdk.services.cloudformation.model.ResourceScanLimitExceededException;
import software.amazon.awssdk.services.cloudformation.model.ResourceScanNotFoundException;
import software.amazon.awssdk.services.cloudformation.model.RollbackStackRequest;
import software.amazon.awssdk.services.cloudformation.model.RollbackStackResponse;
import software.amazon.awssdk.services.cloudformation.model.SetStackPolicyRequest;
import software.amazon.awssdk.services.cloudformation.model.SetStackPolicyResponse;
import software.amazon.awssdk.services.cloudformation.model.SetTypeConfigurationRequest;
import software.amazon.awssdk.services.cloudformation.model.SetTypeConfigurationResponse;
import software.amazon.awssdk.services.cloudformation.model.SetTypeDefaultVersionRequest;
import software.amazon.awssdk.services.cloudformation.model.SetTypeDefaultVersionResponse;
import software.amazon.awssdk.services.cloudformation.model.SignalResourceRequest;
import software.amazon.awssdk.services.cloudformation.model.SignalResourceResponse;
import software.amazon.awssdk.services.cloudformation.model.StackInstanceNotFoundException;
import software.amazon.awssdk.services.cloudformation.model.StackNotFoundException;
import software.amazon.awssdk.services.cloudformation.model.StackRefactorNotFoundException;
import software.amazon.awssdk.services.cloudformation.model.StackSetNotEmptyException;
import software.amazon.awssdk.services.cloudformation.model.StackSetNotFoundException;
import software.amazon.awssdk.services.cloudformation.model.StaleRequestException;
import software.amazon.awssdk.services.cloudformation.model.StartResourceScanRequest;
import software.amazon.awssdk.services.cloudformation.model.StartResourceScanResponse;
import software.amazon.awssdk.services.cloudformation.model.StopStackSetOperationRequest;
import software.amazon.awssdk.services.cloudformation.model.StopStackSetOperationResponse;
import software.amazon.awssdk.services.cloudformation.model.TestTypeRequest;
import software.amazon.awssdk.services.cloudformation.model.TestTypeResponse;
import software.amazon.awssdk.services.cloudformation.model.TokenAlreadyExistsException;
import software.amazon.awssdk.services.cloudformation.model.TypeConfigurationNotFoundException;
import software.amazon.awssdk.services.cloudformation.model.TypeNotFoundException;
import software.amazon.awssdk.services.cloudformation.model.UpdateGeneratedTemplateRequest;
import software.amazon.awssdk.services.cloudformation.model.UpdateGeneratedTemplateResponse;
import software.amazon.awssdk.services.cloudformation.model.UpdateStackInstancesRequest;
import software.amazon.awssdk.services.cloudformation.model.UpdateStackInstancesResponse;
import software.amazon.awssdk.services.cloudformation.model.UpdateStackRequest;
import software.amazon.awssdk.services.cloudformation.model.UpdateStackResponse;
import software.amazon.awssdk.services.cloudformation.model.UpdateStackSetRequest;
import software.amazon.awssdk.services.cloudformation.model.UpdateStackSetResponse;
import software.amazon.awssdk.services.cloudformation.model.UpdateTerminationProtectionRequest;
import software.amazon.awssdk.services.cloudformation.model.UpdateTerminationProtectionResponse;
import software.amazon.awssdk.services.cloudformation.model.ValidateTemplateRequest;
import software.amazon.awssdk.services.cloudformation.model.ValidateTemplateResponse;
import software.amazon.awssdk.services.cloudformation.transform.ActivateOrganizationsAccessRequestMarshaller;
import software.amazon.awssdk.services.cloudformation.transform.ActivateTypeRequestMarshaller;
import software.amazon.awssdk.services.cloudformation.transform.BatchDescribeTypeConfigurationsRequestMarshaller;
import software.amazon.awssdk.services.cloudformation.transform.CancelUpdateStackRequestMarshaller;
import software.amazon.awssdk.services.cloudformation.transform.ContinueUpdateRollbackRequestMarshaller;
import software.amazon.awssdk.services.cloudformation.transform.CreateChangeSetRequestMarshaller;
import software.amazon.awssdk.services.cloudformation.transform.CreateGeneratedTemplateRequestMarshaller;
import software.amazon.awssdk.services.cloudformation.transform.CreateStackInstancesRequestMarshaller;
import software.amazon.awssdk.services.cloudformation.transform.CreateStackRefactorRequestMarshaller;
import software.amazon.awssdk.services.cloudformation.transform.CreateStackRequestMarshaller;
import software.amazon.awssdk.services.cloudformation.transform.CreateStackSetRequestMarshaller;
import software.amazon.awssdk.services.cloudformation.transform.DeactivateOrganizationsAccessRequestMarshaller;
import software.amazon.awssdk.services.cloudformation.transform.DeactivateTypeRequestMarshaller;
import software.amazon.awssdk.services.cloudformation.transform.DeleteChangeSetRequestMarshaller;
import software.amazon.awssdk.services.cloudformation.transform.DeleteGeneratedTemplateRequestMarshaller;
import software.amazon.awssdk.services.cloudformation.transform.DeleteStackInstancesRequestMarshaller;
import software.amazon.awssdk.services.cloudformation.transform.DeleteStackRequestMarshaller;
import software.amazon.awssdk.services.cloudformation.transform.DeleteStackSetRequestMarshaller;
import software.amazon.awssdk.services.cloudformation.transform.DeregisterTypeRequestMarshaller;
import software.amazon.awssdk.services.cloudformation.transform.DescribeAccountLimitsRequestMarshaller;
import software.amazon.awssdk.services.cloudformation.transform.DescribeChangeSetHooksRequestMarshaller;
import software.amazon.awssdk.services.cloudformation.transform.DescribeChangeSetRequestMarshaller;
import software.amazon.awssdk.services.cloudformation.transform.DescribeGeneratedTemplateRequestMarshaller;
import software.amazon.awssdk.services.cloudformation.transform.DescribeOrganizationsAccessRequestMarshaller;
import software.amazon.awssdk.services.cloudformation.transform.DescribePublisherRequestMarshaller;
import software.amazon.awssdk.services.cloudformation.transform.DescribeResourceScanRequestMarshaller;
import software.amazon.awssdk.services.cloudformation.transform.DescribeStackDriftDetectionStatusRequestMarshaller;
import software.amazon.awssdk.services.cloudformation.transform.DescribeStackEventsRequestMarshaller;
import software.amazon.awssdk.services.cloudformation.transform.DescribeStackInstanceRequestMarshaller;
import software.amazon.awssdk.services.cloudformation.transform.DescribeStackRefactorRequestMarshaller;
import software.amazon.awssdk.services.cloudformation.transform.DescribeStackResourceDriftsRequestMarshaller;
import software.amazon.awssdk.services.cloudformation.transform.DescribeStackResourceRequestMarshaller;
import software.amazon.awssdk.services.cloudformation.transform.DescribeStackResourcesRequestMarshaller;
import software.amazon.awssdk.services.cloudformation.transform.DescribeStackSetOperationRequestMarshaller;
import software.amazon.awssdk.services.cloudformation.transform.DescribeStackSetRequestMarshaller;
import software.amazon.awssdk.services.cloudformation.transform.DescribeStacksRequestMarshaller;
import software.amazon.awssdk.services.cloudformation.transform.DescribeTypeRegistrationRequestMarshaller;
import software.amazon.awssdk.services.cloudformation.transform.DescribeTypeRequestMarshaller;
import software.amazon.awssdk.services.cloudformation.transform.DetectStackDriftRequestMarshaller;
import software.amazon.awssdk.services.cloudformation.transform.DetectStackResourceDriftRequestMarshaller;
import software.amazon.awssdk.services.cloudformation.transform.DetectStackSetDriftRequestMarshaller;
import software.amazon.awssdk.services.cloudformation.transform.EstimateTemplateCostRequestMarshaller;
import software.amazon.awssdk.services.cloudformation.transform.ExecuteChangeSetRequestMarshaller;
import software.amazon.awssdk.services.cloudformation.transform.ExecuteStackRefactorRequestMarshaller;
import software.amazon.awssdk.services.cloudformation.transform.GetGeneratedTemplateRequestMarshaller;
import software.amazon.awssdk.services.cloudformation.transform.GetStackPolicyRequestMarshaller;
import software.amazon.awssdk.services.cloudformation.transform.GetTemplateRequestMarshaller;
import software.amazon.awssdk.services.cloudformation.transform.GetTemplateSummaryRequestMarshaller;
import software.amazon.awssdk.services.cloudformation.transform.ImportStacksToStackSetRequestMarshaller;
import software.amazon.awssdk.services.cloudformation.transform.ListChangeSetsRequestMarshaller;
import software.amazon.awssdk.services.cloudformation.transform.ListExportsRequestMarshaller;
import software.amazon.awssdk.services.cloudformation.transform.ListGeneratedTemplatesRequestMarshaller;
import software.amazon.awssdk.services.cloudformation.transform.ListHookResultsRequestMarshaller;
import software.amazon.awssdk.services.cloudformation.transform.ListImportsRequestMarshaller;
import software.amazon.awssdk.services.cloudformation.transform.ListResourceScanRelatedResourcesRequestMarshaller;
import software.amazon.awssdk.services.cloudformation.transform.ListResourceScanResourcesRequestMarshaller;
import software.amazon.awssdk.services.cloudformation.transform.ListResourceScansRequestMarshaller;
import software.amazon.awssdk.services.cloudformation.transform.ListStackInstanceResourceDriftsRequestMarshaller;
import software.amazon.awssdk.services.cloudformation.transform.ListStackInstancesRequestMarshaller;
import software.amazon.awssdk.services.cloudformation.transform.ListStackRefactorActionsRequestMarshaller;
import software.amazon.awssdk.services.cloudformation.transform.ListStackRefactorsRequestMarshaller;
import software.amazon.awssdk.services.cloudformation.transform.ListStackResourcesRequestMarshaller;
import software.amazon.awssdk.services.cloudformation.transform.ListStackSetAutoDeploymentTargetsRequestMarshaller;
import software.amazon.awssdk.services.cloudformation.transform.ListStackSetOperationResultsRequestMarshaller;
import software.amazon.awssdk.services.cloudformation.transform.ListStackSetOperationsRequestMarshaller;
import software.amazon.awssdk.services.cloudformation.transform.ListStackSetsRequestMarshaller;
import software.amazon.awssdk.services.cloudformation.transform.ListStacksRequestMarshaller;
import software.amazon.awssdk.services.cloudformation.transform.ListTypeRegistrationsRequestMarshaller;
import software.amazon.awssdk.services.cloudformation.transform.ListTypeVersionsRequestMarshaller;
import software.amazon.awssdk.services.cloudformation.transform.ListTypesRequestMarshaller;
import software.amazon.awssdk.services.cloudformation.transform.PublishTypeRequestMarshaller;
import software.amazon.awssdk.services.cloudformation.transform.RecordHandlerProgressRequestMarshaller;
import software.amazon.awssdk.services.cloudformation.transform.RegisterPublisherRequestMarshaller;
import software.amazon.awssdk.services.cloudformation.transform.RegisterTypeRequestMarshaller;
import software.amazon.awssdk.services.cloudformation.transform.RollbackStackRequestMarshaller;
import software.amazon.awssdk.services.cloudformation.transform.SetStackPolicyRequestMarshaller;
import software.amazon.awssdk.services.cloudformation.transform.SetTypeConfigurationRequestMarshaller;
import software.amazon.awssdk.services.cloudformation.transform.SetTypeDefaultVersionRequestMarshaller;
import software.amazon.awssdk.services.cloudformation.transform.SignalResourceRequestMarshaller;
import software.amazon.awssdk.services.cloudformation.transform.StartResourceScanRequestMarshaller;
import software.amazon.awssdk.services.cloudformation.transform.StopStackSetOperationRequestMarshaller;
import software.amazon.awssdk.services.cloudformation.transform.TestTypeRequestMarshaller;
import software.amazon.awssdk.services.cloudformation.transform.UpdateGeneratedTemplateRequestMarshaller;
import software.amazon.awssdk.services.cloudformation.transform.UpdateStackInstancesRequestMarshaller;
import software.amazon.awssdk.services.cloudformation.transform.UpdateStackRequestMarshaller;
import software.amazon.awssdk.services.cloudformation.transform.UpdateStackSetRequestMarshaller;
import software.amazon.awssdk.services.cloudformation.transform.UpdateTerminationProtectionRequestMarshaller;
import software.amazon.awssdk.services.cloudformation.transform.ValidateTemplateRequestMarshaller;
import software.amazon.awssdk.services.cloudformation.waiters.CloudFormationWaiter;
import software.amazon.awssdk.utils.Logger;

/**
 * Internal implementation of {@link CloudFormationClient}.
 *
 * @see CloudFormationClient#builder()
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
final class DefaultCloudFormationClient implements CloudFormationClient {
    private static final Logger log = Logger.loggerFor(DefaultCloudFormationClient.class);

    private static final AwsProtocolMetadata protocolMetadata = AwsProtocolMetadata.builder()
            .serviceProtocol(AwsServiceProtocol.QUERY).build();

    private final SyncClientHandler clientHandler;

    private final AwsQueryProtocolFactory protocolFactory;

    private final SdkClientConfiguration clientConfiguration;

    protected DefaultCloudFormationClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration.toBuilder().option(SdkClientOption.SDK_CLIENT, this).build();
        this.protocolFactory = init();
    }

    /**
     * <p>
     * Activate trusted access with Organizations. With trusted access between StackSets and Organizations activated,
     * the management account has permissions to create and manage StackSets for your organization.
     * </p>
     *
     * @param activateOrganizationsAccessRequest
     * @return Result of the ActivateOrganizationsAccess operation returned by the service.
     * @throws InvalidOperationException
     *         The specified operation isn't valid.
     * @throws OperationNotFoundException
     *         The specified ID refers to an operation that doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFormationClient.ActivateOrganizationsAccess
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ActivateOrganizationsAccess"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ActivateOrganizationsAccessResponse activateOrganizationsAccess(
            ActivateOrganizationsAccessRequest activateOrganizationsAccessRequest) throws InvalidOperationException,
            OperationNotFoundException, AwsServiceException, SdkClientException, CloudFormationException {

        HttpResponseHandler<ActivateOrganizationsAccessResponse> responseHandler = protocolFactory
                .createResponseHandler(ActivateOrganizationsAccessResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(activateOrganizationsAccessRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, activateOrganizationsAccessRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ActivateOrganizationsAccess");

            return clientHandler
                    .execute(new ClientExecutionParams<ActivateOrganizationsAccessRequest, ActivateOrganizationsAccessResponse>()
                            .withOperationName("ActivateOrganizationsAccess").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(activateOrganizationsAccessRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ActivateOrganizationsAccessRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Activates a public third-party extension, making it available for use in stack templates. Once you have activated
     * a public third-party extension in your account and Region, use <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_SetTypeConfiguration.html"
     * >SetTypeConfiguration</a> to specify configuration properties for the extension. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/registry-public.html">Using public
     * extensions</a> in the <i>CloudFormation User Guide</i>.
     * </p>
     *
     * @param activateTypeRequest
     * @return Result of the ActivateType operation returned by the service.
     * @throws CfnRegistryException
     *         An error occurred during a CloudFormation registry operation.
     * @throws TypeNotFoundException
     *         The specified extension doesn't exist in the CloudFormation registry.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFormationClient.ActivateType
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ActivateType" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public ActivateTypeResponse activateType(ActivateTypeRequest activateTypeRequest) throws CfnRegistryException,
            TypeNotFoundException, AwsServiceException, SdkClientException, CloudFormationException {

        HttpResponseHandler<ActivateTypeResponse> responseHandler = protocolFactory
                .createResponseHandler(ActivateTypeResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(activateTypeRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, activateTypeRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ActivateType");

            return clientHandler.execute(new ClientExecutionParams<ActivateTypeRequest, ActivateTypeResponse>()
                    .withOperationName("ActivateType").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(activateTypeRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ActivateTypeRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns configuration data for the specified CloudFormation extensions, from the CloudFormation registry for the
     * account and Region.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/registry-set-configuration.html">Edit
     * configuration data for extensions in your account</a> in the <i>CloudFormation User Guide</i>.
     * </p>
     *
     * @param batchDescribeTypeConfigurationsRequest
     * @return Result of the BatchDescribeTypeConfigurations operation returned by the service.
     * @throws TypeConfigurationNotFoundException
     *         The specified extension configuration can't be found.
     * @throws CfnRegistryException
     *         An error occurred during a CloudFormation registry operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFormationClient.BatchDescribeTypeConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/BatchDescribeTypeConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public BatchDescribeTypeConfigurationsResponse batchDescribeTypeConfigurations(
            BatchDescribeTypeConfigurationsRequest batchDescribeTypeConfigurationsRequest)
            throws TypeConfigurationNotFoundException, CfnRegistryException, AwsServiceException, SdkClientException,
            CloudFormationException {

        HttpResponseHandler<BatchDescribeTypeConfigurationsResponse> responseHandler = protocolFactory
                .createResponseHandler(BatchDescribeTypeConfigurationsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(batchDescribeTypeConfigurationsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                batchDescribeTypeConfigurationsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "BatchDescribeTypeConfigurations");

            return clientHandler
                    .execute(new ClientExecutionParams<BatchDescribeTypeConfigurationsRequest, BatchDescribeTypeConfigurationsResponse>()
                            .withOperationName("BatchDescribeTypeConfigurations").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(batchDescribeTypeConfigurationsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new BatchDescribeTypeConfigurationsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Cancels an update on the specified stack. If the call completes successfully, the stack rolls back the update and
     * reverts to the previous stack configuration.
     * </p>
     * <note>
     * <p>
     * You can cancel only stacks that are in the <code>UPDATE_IN_PROGRESS</code> state.
     * </p>
     * </note>
     *
     * @param cancelUpdateStackRequest
     *        The input for the <a>CancelUpdateStack</a> action.
     * @return Result of the CancelUpdateStack operation returned by the service.
     * @throws TokenAlreadyExistsException
     *         A client request token already exists.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFormationClient.CancelUpdateStack
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/CancelUpdateStack"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CancelUpdateStackResponse cancelUpdateStack(CancelUpdateStackRequest cancelUpdateStackRequest)
            throws TokenAlreadyExistsException, AwsServiceException, SdkClientException, CloudFormationException {

        HttpResponseHandler<CancelUpdateStackResponse> responseHandler = protocolFactory
                .createResponseHandler(CancelUpdateStackResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(cancelUpdateStackRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, cancelUpdateStackRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CancelUpdateStack");

            return clientHandler.execute(new ClientExecutionParams<CancelUpdateStackRequest, CancelUpdateStackResponse>()
                    .withOperationName("CancelUpdateStack").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(cancelUpdateStackRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CancelUpdateStackRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * For a specified stack that's in the <code>UPDATE_ROLLBACK_FAILED</code> state, continues rolling it back to the
     * <code>UPDATE_ROLLBACK_COMPLETE</code> state. Depending on the cause of the failure, you can manually <a href=
     * "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/troubleshooting.html#troubleshooting-errors-update-rollback-failed"
     * >fix the error</a> and continue the rollback. By continuing the rollback, you can return your stack to a working
     * state (the <code>UPDATE_ROLLBACK_COMPLETE</code> state), and then try to update the stack again.
     * </p>
     * <p>
     * A stack goes into the <code>UPDATE_ROLLBACK_FAILED</code> state when CloudFormation can't roll back all changes
     * after a failed stack update. For example, you might have a stack that's rolling back to an old database instance
     * that was deleted outside of CloudFormation. Because CloudFormation doesn't know the database was deleted, it
     * assumes that the database instance still exists and attempts to roll back to it, causing the update rollback to
     * fail.
     * </p>
     *
     * @param continueUpdateRollbackRequest
     *        The input for the <a>ContinueUpdateRollback</a> action.
     * @return Result of the ContinueUpdateRollback operation returned by the service.
     * @throws TokenAlreadyExistsException
     *         A client request token already exists.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFormationClient.ContinueUpdateRollback
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ContinueUpdateRollback"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ContinueUpdateRollbackResponse continueUpdateRollback(ContinueUpdateRollbackRequest continueUpdateRollbackRequest)
            throws TokenAlreadyExistsException, AwsServiceException, SdkClientException, CloudFormationException {

        HttpResponseHandler<ContinueUpdateRollbackResponse> responseHandler = protocolFactory
                .createResponseHandler(ContinueUpdateRollbackResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(continueUpdateRollbackRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, continueUpdateRollbackRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ContinueUpdateRollback");

            return clientHandler
                    .execute(new ClientExecutionParams<ContinueUpdateRollbackRequest, ContinueUpdateRollbackResponse>()
                            .withOperationName("ContinueUpdateRollback").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(continueUpdateRollbackRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ContinueUpdateRollbackRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a list of changes that will be applied to a stack so that you can review the changes before executing
     * them. You can create a change set for a stack that doesn't exist or an existing stack. If you create a change set
     * for a stack that doesn't exist, the change set shows all of the resources that CloudFormation will create. If you
     * create a change set for an existing stack, CloudFormation compares the stack's information with the information
     * that you submit in the change set and lists the differences. Use change sets to understand which resources
     * CloudFormation will create or change, and how it will change resources in an existing stack, before you create or
     * update a stack.
     * </p>
     * <p>
     * To create a change set for a stack that doesn't exist, for the <code>ChangeSetType</code> parameter, specify
     * <code>CREATE</code>. To create a change set for an existing stack, specify <code>UPDATE</code> for the
     * <code>ChangeSetType</code> parameter. To create a change set for an import operation, specify <code>IMPORT</code>
     * for the <code>ChangeSetType</code> parameter. After the <code>CreateChangeSet</code> call successfully completes,
     * CloudFormation starts creating the change set. To check the status of the change set or to review it, use the
     * <a>DescribeChangeSet</a> action.
     * </p>
     * <p>
     * When you are satisfied with the changes the change set will make, execute the change set by using the
     * <a>ExecuteChangeSet</a> action. CloudFormation doesn't make changes until you execute the change set.
     * </p>
     * <p>
     * To create a change set for the entire stack hierarchy, set <code>IncludeNestedStacks</code> to <code>True</code>.
     * </p>
     *
     * @param createChangeSetRequest
     *        The input for the <a>CreateChangeSet</a> action.
     * @return Result of the CreateChangeSet operation returned by the service.
     * @throws AlreadyExistsException
     *         The resource with the name requested already exists.
     * @throws InsufficientCapabilitiesException
     *         The template contains resources with capabilities that weren't specified in the Capabilities parameter.
     * @throws LimitExceededException
     *         The quota for the resource has already been reached.</p>
     *         <p>
     *         For information about resource and stack limitations, see <a
     *         href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/cloudformation-limits.html"
     *         >CloudFormation quotas</a> in the <i>CloudFormation User Guide</i>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFormationClient.CreateChangeSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/CreateChangeSet"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateChangeSetResponse createChangeSet(CreateChangeSetRequest createChangeSetRequest) throws AlreadyExistsException,
            InsufficientCapabilitiesException, LimitExceededException, AwsServiceException, SdkClientException,
            CloudFormationException {

        HttpResponseHandler<CreateChangeSetResponse> responseHandler = protocolFactory
                .createResponseHandler(CreateChangeSetResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createChangeSetRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createChangeSetRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateChangeSet");

            return clientHandler.execute(new ClientExecutionParams<CreateChangeSetRequest, CreateChangeSetResponse>()
                    .withOperationName("CreateChangeSet").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createChangeSetRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateChangeSetRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a template from existing resources that are not already managed with CloudFormation. You can check the
     * status of the template generation using the <code>DescribeGeneratedTemplate</code> API action.
     * </p>
     *
     * @param createGeneratedTemplateRequest
     * @return Result of the CreateGeneratedTemplate operation returned by the service.
     * @throws AlreadyExistsException
     *         The resource with the name requested already exists.
     * @throws LimitExceededException
     *         The quota for the resource has already been reached.</p>
     *         <p>
     *         For information about resource and stack limitations, see <a
     *         href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/cloudformation-limits.html"
     *         >CloudFormation quotas</a> in the <i>CloudFormation User Guide</i>.
     * @throws ConcurrentResourcesLimitExceededException
     *         No more than 5 generated templates can be in an <code>InProgress</code> or <code>Pending</code> status at
     *         one time. This error is also returned if a generated template that is in an <code>InProgress</code> or
     *         <code>Pending</code> status is attempted to be updated or deleted.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFormationClient.CreateGeneratedTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/CreateGeneratedTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateGeneratedTemplateResponse createGeneratedTemplate(CreateGeneratedTemplateRequest createGeneratedTemplateRequest)
            throws AlreadyExistsException, LimitExceededException, ConcurrentResourcesLimitExceededException,
            AwsServiceException, SdkClientException, CloudFormationException {

        HttpResponseHandler<CreateGeneratedTemplateResponse> responseHandler = protocolFactory
                .createResponseHandler(CreateGeneratedTemplateResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createGeneratedTemplateRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createGeneratedTemplateRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateGeneratedTemplate");

            return clientHandler
                    .execute(new ClientExecutionParams<CreateGeneratedTemplateRequest, CreateGeneratedTemplateResponse>()
                            .withOperationName("CreateGeneratedTemplate").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(createGeneratedTemplateRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CreateGeneratedTemplateRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a stack as specified in the template. After the call completes successfully, the stack creation starts.
     * You can check the status of the stack through the <a>DescribeStacks</a> operation.
     * </p>
     * <p>
     * For more information about creating a stack and monitoring stack progress, see <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacks.html">Managing Amazon Web Services
     * resources as a single unit with CloudFormation stacks</a> in the <i>CloudFormation User Guide</i>.
     * </p>
     *
     * @param createStackRequest
     *        The input for <a>CreateStack</a> action.
     * @return Result of the CreateStack operation returned by the service.
     * @throws LimitExceededException
     *         The quota for the resource has already been reached.</p>
     *         <p>
     *         For information about resource and stack limitations, see <a
     *         href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/cloudformation-limits.html"
     *         >CloudFormation quotas</a> in the <i>CloudFormation User Guide</i>.
     * @throws AlreadyExistsException
     *         The resource with the name requested already exists.
     * @throws TokenAlreadyExistsException
     *         A client request token already exists.
     * @throws InsufficientCapabilitiesException
     *         The template contains resources with capabilities that weren't specified in the Capabilities parameter.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFormationClient.CreateStack
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/CreateStack" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CreateStackResponse createStack(CreateStackRequest createStackRequest) throws LimitExceededException,
            AlreadyExistsException, TokenAlreadyExistsException, InsufficientCapabilitiesException, AwsServiceException,
            SdkClientException, CloudFormationException {

        HttpResponseHandler<CreateStackResponse> responseHandler = protocolFactory
                .createResponseHandler(CreateStackResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createStackRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createStackRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateStack");

            return clientHandler.execute(new ClientExecutionParams<CreateStackRequest, CreateStackResponse>()
                    .withOperationName("CreateStack").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(createStackRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateStackRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates stack instances for the specified accounts, within the specified Amazon Web Services Regions. A stack
     * instance refers to a stack in a specific account and Region. You must specify at least one value for either
     * <code>Accounts</code> or <code>DeploymentTargets</code>, and you must specify at least one value for
     * <code>Regions</code>.
     * </p>
     *
     * @param createStackInstancesRequest
     * @return Result of the CreateStackInstances operation returned by the service.
     * @throws StackSetNotFoundException
     *         The specified stack set doesn't exist.
     * @throws OperationInProgressException
     *         Another operation is currently in progress for this stack set. Only one operation can be performed for a
     *         stack set at a given time.
     * @throws OperationIdAlreadyExistsException
     *         The specified operation ID already exists.
     * @throws StaleRequestException
     *         Another operation has been performed on this stack set since the specified operation was performed.
     * @throws InvalidOperationException
     *         The specified operation isn't valid.
     * @throws LimitExceededException
     *         The quota for the resource has already been reached.</p>
     *         <p>
     *         For information about resource and stack limitations, see <a
     *         href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/cloudformation-limits.html"
     *         >CloudFormation quotas</a> in the <i>CloudFormation User Guide</i>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFormationClient.CreateStackInstances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/CreateStackInstances"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateStackInstancesResponse createStackInstances(CreateStackInstancesRequest createStackInstancesRequest)
            throws StackSetNotFoundException, OperationInProgressException, OperationIdAlreadyExistsException,
            StaleRequestException, InvalidOperationException, LimitExceededException, AwsServiceException, SdkClientException,
            CloudFormationException {

        HttpResponseHandler<CreateStackInstancesResponse> responseHandler = protocolFactory
                .createResponseHandler(CreateStackInstancesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createStackInstancesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createStackInstancesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateStackInstances");

            return clientHandler.execute(new ClientExecutionParams<CreateStackInstancesRequest, CreateStackInstancesResponse>()
                    .withOperationName("CreateStackInstances").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createStackInstancesRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateStackInstancesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a refactor across multiple stacks, with the list of stacks and resources that are affected.
     * </p>
     *
     * @param createStackRefactorRequest
     * @return Result of the CreateStackRefactor operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFormationClient.CreateStackRefactor
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/CreateStackRefactor"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateStackRefactorResponse createStackRefactor(CreateStackRefactorRequest createStackRefactorRequest)
            throws AwsServiceException, SdkClientException, CloudFormationException {

        HttpResponseHandler<CreateStackRefactorResponse> responseHandler = protocolFactory
                .createResponseHandler(CreateStackRefactorResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createStackRefactorRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createStackRefactorRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateStackRefactor");

            return clientHandler.execute(new ClientExecutionParams<CreateStackRefactorRequest, CreateStackRefactorResponse>()
                    .withOperationName("CreateStackRefactor").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createStackRefactorRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateStackRefactorRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a stack set.
     * </p>
     *
     * @param createStackSetRequest
     * @return Result of the CreateStackSet operation returned by the service.
     * @throws NameAlreadyExistsException
     *         The specified name is already in use.
     * @throws CreatedButModifiedException
     *         The specified resource exists, but has been changed.
     * @throws LimitExceededException
     *         The quota for the resource has already been reached.</p>
     *         <p>
     *         For information about resource and stack limitations, see <a
     *         href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/cloudformation-limits.html"
     *         >CloudFormation quotas</a> in the <i>CloudFormation User Guide</i>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFormationClient.CreateStackSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/CreateStackSet" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CreateStackSetResponse createStackSet(CreateStackSetRequest createStackSetRequest) throws NameAlreadyExistsException,
            CreatedButModifiedException, LimitExceededException, AwsServiceException, SdkClientException, CloudFormationException {

        HttpResponseHandler<CreateStackSetResponse> responseHandler = protocolFactory
                .createResponseHandler(CreateStackSetResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createStackSetRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createStackSetRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateStackSet");

            return clientHandler.execute(new ClientExecutionParams<CreateStackSetRequest, CreateStackSetResponse>()
                    .withOperationName("CreateStackSet").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createStackSetRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateStackSetRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deactivates trusted access with Organizations. If trusted access is deactivated, the management account does not
     * have permissions to create and manage service-managed StackSets for your organization.
     * </p>
     *
     * @param deactivateOrganizationsAccessRequest
     * @return Result of the DeactivateOrganizationsAccess operation returned by the service.
     * @throws InvalidOperationException
     *         The specified operation isn't valid.
     * @throws OperationNotFoundException
     *         The specified ID refers to an operation that doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFormationClient.DeactivateOrganizationsAccess
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DeactivateOrganizationsAccess"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeactivateOrganizationsAccessResponse deactivateOrganizationsAccess(
            DeactivateOrganizationsAccessRequest deactivateOrganizationsAccessRequest) throws InvalidOperationException,
            OperationNotFoundException, AwsServiceException, SdkClientException, CloudFormationException {

        HttpResponseHandler<DeactivateOrganizationsAccessResponse> responseHandler = protocolFactory
                .createResponseHandler(DeactivateOrganizationsAccessResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deactivateOrganizationsAccessRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                deactivateOrganizationsAccessRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeactivateOrganizationsAccess");

            return clientHandler
                    .execute(new ClientExecutionParams<DeactivateOrganizationsAccessRequest, DeactivateOrganizationsAccessResponse>()
                            .withOperationName("DeactivateOrganizationsAccess").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(deactivateOrganizationsAccessRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeactivateOrganizationsAccessRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deactivates a public extension that was previously activated in this account and Region.
     * </p>
     * <p>
     * Once deactivated, an extension can't be used in any CloudFormation operation. This includes stack update
     * operations where the stack template includes the extension, even if no updates are being made to the extension.
     * In addition, deactivated extensions aren't automatically updated if a new version of the extension is released.
     * </p>
     *
     * @param deactivateTypeRequest
     * @return Result of the DeactivateType operation returned by the service.
     * @throws CfnRegistryException
     *         An error occurred during a CloudFormation registry operation.
     * @throws TypeNotFoundException
     *         The specified extension doesn't exist in the CloudFormation registry.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFormationClient.DeactivateType
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DeactivateType" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DeactivateTypeResponse deactivateType(DeactivateTypeRequest deactivateTypeRequest) throws CfnRegistryException,
            TypeNotFoundException, AwsServiceException, SdkClientException, CloudFormationException {

        HttpResponseHandler<DeactivateTypeResponse> responseHandler = protocolFactory
                .createResponseHandler(DeactivateTypeResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deactivateTypeRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deactivateTypeRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeactivateType");

            return clientHandler.execute(new ClientExecutionParams<DeactivateTypeRequest, DeactivateTypeResponse>()
                    .withOperationName("DeactivateType").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(deactivateTypeRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeactivateTypeRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes the specified change set. Deleting change sets ensures that no one executes the wrong change set.
     * </p>
     * <p>
     * If the call successfully completes, CloudFormation successfully deleted the change set.
     * </p>
     * <p>
     * If <code>IncludeNestedStacks</code> specifies <code>True</code> during the creation of the nested change set,
     * then <code>DeleteChangeSet</code> will delete all change sets that belong to the stacks hierarchy and will also
     * delete all change sets for nested stacks with the status of <code>REVIEW_IN_PROGRESS</code>.
     * </p>
     *
     * @param deleteChangeSetRequest
     *        The input for the <a>DeleteChangeSet</a> action.
     * @return Result of the DeleteChangeSet operation returned by the service.
     * @throws InvalidChangeSetStatusException
     *         The specified change set can't be used to update the stack. For example, the change set status might be
     *         <code>CREATE_IN_PROGRESS</code>, or the stack status might be <code>UPDATE_IN_PROGRESS</code>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFormationClient.DeleteChangeSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DeleteChangeSet"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteChangeSetResponse deleteChangeSet(DeleteChangeSetRequest deleteChangeSetRequest)
            throws InvalidChangeSetStatusException, AwsServiceException, SdkClientException, CloudFormationException {

        HttpResponseHandler<DeleteChangeSetResponse> responseHandler = protocolFactory
                .createResponseHandler(DeleteChangeSetResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteChangeSetRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteChangeSetRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteChangeSet");

            return clientHandler.execute(new ClientExecutionParams<DeleteChangeSetRequest, DeleteChangeSetResponse>()
                    .withOperationName("DeleteChangeSet").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(deleteChangeSetRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteChangeSetRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deleted a generated template.
     * </p>
     *
     * @param deleteGeneratedTemplateRequest
     * @return Result of the DeleteGeneratedTemplate operation returned by the service.
     * @throws GeneratedTemplateNotFoundException
     *         The generated template was not found.
     * @throws ConcurrentResourcesLimitExceededException
     *         No more than 5 generated templates can be in an <code>InProgress</code> or <code>Pending</code> status at
     *         one time. This error is also returned if a generated template that is in an <code>InProgress</code> or
     *         <code>Pending</code> status is attempted to be updated or deleted.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFormationClient.DeleteGeneratedTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DeleteGeneratedTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteGeneratedTemplateResponse deleteGeneratedTemplate(DeleteGeneratedTemplateRequest deleteGeneratedTemplateRequest)
            throws GeneratedTemplateNotFoundException, ConcurrentResourcesLimitExceededException, AwsServiceException,
            SdkClientException, CloudFormationException {

        HttpResponseHandler<DeleteGeneratedTemplateResponse> responseHandler = protocolFactory
                .createResponseHandler(DeleteGeneratedTemplateResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteGeneratedTemplateRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteGeneratedTemplateRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteGeneratedTemplate");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteGeneratedTemplateRequest, DeleteGeneratedTemplateResponse>()
                            .withOperationName("DeleteGeneratedTemplate").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(deleteGeneratedTemplateRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteGeneratedTemplateRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a specified stack. Once the call completes successfully, stack deletion starts. Deleted stacks don't show
     * up in the <a>DescribeStacks</a> operation if the deletion has been completed successfully.
     * </p>
     * <p>
     * For more information about deleting a stack, see <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/cfn-console-delete-stack.html">Delete a
     * stack from the CloudFormation console</a> in the <i>CloudFormation User Guide</i>.
     * </p>
     *
     * @param deleteStackRequest
     *        The input for <a>DeleteStack</a> action.
     * @return Result of the DeleteStack operation returned by the service.
     * @throws TokenAlreadyExistsException
     *         A client request token already exists.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFormationClient.DeleteStack
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DeleteStack" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DeleteStackResponse deleteStack(DeleteStackRequest deleteStackRequest) throws TokenAlreadyExistsException,
            AwsServiceException, SdkClientException, CloudFormationException {

        HttpResponseHandler<DeleteStackResponse> responseHandler = protocolFactory
                .createResponseHandler(DeleteStackResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteStackRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteStackRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteStack");

            return clientHandler.execute(new ClientExecutionParams<DeleteStackRequest, DeleteStackResponse>()
                    .withOperationName("DeleteStack").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(deleteStackRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteStackRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes stack instances for the specified accounts, in the specified Amazon Web Services Regions.
     * </p>
     *
     * @param deleteStackInstancesRequest
     * @return Result of the DeleteStackInstances operation returned by the service.
     * @throws StackSetNotFoundException
     *         The specified stack set doesn't exist.
     * @throws OperationInProgressException
     *         Another operation is currently in progress for this stack set. Only one operation can be performed for a
     *         stack set at a given time.
     * @throws OperationIdAlreadyExistsException
     *         The specified operation ID already exists.
     * @throws StaleRequestException
     *         Another operation has been performed on this stack set since the specified operation was performed.
     * @throws InvalidOperationException
     *         The specified operation isn't valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFormationClient.DeleteStackInstances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DeleteStackInstances"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteStackInstancesResponse deleteStackInstances(DeleteStackInstancesRequest deleteStackInstancesRequest)
            throws StackSetNotFoundException, OperationInProgressException, OperationIdAlreadyExistsException,
            StaleRequestException, InvalidOperationException, AwsServiceException, SdkClientException, CloudFormationException {

        HttpResponseHandler<DeleteStackInstancesResponse> responseHandler = protocolFactory
                .createResponseHandler(DeleteStackInstancesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteStackInstancesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteStackInstancesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteStackInstances");

            return clientHandler.execute(new ClientExecutionParams<DeleteStackInstancesRequest, DeleteStackInstancesResponse>()
                    .withOperationName("DeleteStackInstances").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(deleteStackInstancesRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteStackInstancesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a stack set. Before you can delete a stack set, all its member stack instances must be deleted. For more
     * information about how to complete this, see <a>DeleteStackInstances</a>.
     * </p>
     *
     * @param deleteStackSetRequest
     * @return Result of the DeleteStackSet operation returned by the service.
     * @throws StackSetNotEmptyException
     *         You can't yet delete this stack set, because it still contains one or more stack instances. Delete all
     *         stack instances from the stack set before deleting the stack set.
     * @throws OperationInProgressException
     *         Another operation is currently in progress for this stack set. Only one operation can be performed for a
     *         stack set at a given time.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFormationClient.DeleteStackSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DeleteStackSet" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DeleteStackSetResponse deleteStackSet(DeleteStackSetRequest deleteStackSetRequest) throws StackSetNotEmptyException,
            OperationInProgressException, AwsServiceException, SdkClientException, CloudFormationException {

        HttpResponseHandler<DeleteStackSetResponse> responseHandler = protocolFactory
                .createResponseHandler(DeleteStackSetResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteStackSetRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteStackSetRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteStackSet");

            return clientHandler.execute(new ClientExecutionParams<DeleteStackSetRequest, DeleteStackSetResponse>()
                    .withOperationName("DeleteStackSet").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(deleteStackSetRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteStackSetRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Marks an extension or extension version as <code>DEPRECATED</code> in the CloudFormation registry, removing it
     * from active use. Deprecated extensions or extension versions cannot be used in CloudFormation operations.
     * </p>
     * <p>
     * To deregister an entire extension, you must individually deregister all active versions of that extension. If an
     * extension has only a single active version, deregistering that version results in the extension itself being
     * deregistered and marked as deprecated in the registry.
     * </p>
     * <p>
     * You can't deregister the default version of an extension if there are other active version of that extension. If
     * you do deregister the default version of an extension, the extension type itself is deregistered as well and
     * marked as deprecated.
     * </p>
     * <p>
     * To view the deprecation status of an extension or extension version, use <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_DescribeType.html">DescribeType</a>.
     * </p>
     *
     * @param deregisterTypeRequest
     * @return Result of the DeregisterType operation returned by the service.
     * @throws CfnRegistryException
     *         An error occurred during a CloudFormation registry operation.
     * @throws TypeNotFoundException
     *         The specified extension doesn't exist in the CloudFormation registry.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFormationClient.DeregisterType
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DeregisterType" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DeregisterTypeResponse deregisterType(DeregisterTypeRequest deregisterTypeRequest) throws CfnRegistryException,
            TypeNotFoundException, AwsServiceException, SdkClientException, CloudFormationException {

        HttpResponseHandler<DeregisterTypeResponse> responseHandler = protocolFactory
                .createResponseHandler(DeregisterTypeResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deregisterTypeRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deregisterTypeRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeregisterType");

            return clientHandler.execute(new ClientExecutionParams<DeregisterTypeRequest, DeregisterTypeResponse>()
                    .withOperationName("DeregisterType").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(deregisterTypeRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeregisterTypeRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves your account's CloudFormation limits, such as the maximum number of stacks that you can create in your
     * account. For more information about account limits, see <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/cloudformation-limits.html">Understand
     * CloudFormation quotas</a> in the <i>CloudFormation User Guide</i>.
     * </p>
     *
     * @param describeAccountLimitsRequest
     *        The input for the <a>DescribeAccountLimits</a> action.
     * @return Result of the DescribeAccountLimits operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFormationClient.DescribeAccountLimits
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribeAccountLimits"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeAccountLimitsResponse describeAccountLimits(DescribeAccountLimitsRequest describeAccountLimitsRequest)
            throws AwsServiceException, SdkClientException, CloudFormationException {

        HttpResponseHandler<DescribeAccountLimitsResponse> responseHandler = protocolFactory
                .createResponseHandler(DescribeAccountLimitsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeAccountLimitsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeAccountLimitsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeAccountLimits");

            return clientHandler.execute(new ClientExecutionParams<DescribeAccountLimitsRequest, DescribeAccountLimitsResponse>()
                    .withOperationName("DescribeAccountLimits").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(describeAccountLimitsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DescribeAccountLimitsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns the inputs for the change set and a list of changes that CloudFormation will make if you execute the
     * change set. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-updating-stacks-changesets.html"
     * >Update CloudFormation stacks using change sets</a> in the <i>CloudFormation User Guide</i>.
     * </p>
     *
     * @param describeChangeSetRequest
     *        The input for the <a>DescribeChangeSet</a> action.
     * @return Result of the DescribeChangeSet operation returned by the service.
     * @throws ChangeSetNotFoundException
     *         The specified change set name or ID doesn't exit. To view valid change sets for a stack, use the
     *         <code>ListChangeSets</code> operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFormationClient.DescribeChangeSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribeChangeSet"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeChangeSetResponse describeChangeSet(DescribeChangeSetRequest describeChangeSetRequest)
            throws ChangeSetNotFoundException, AwsServiceException, SdkClientException, CloudFormationException {

        HttpResponseHandler<DescribeChangeSetResponse> responseHandler = protocolFactory
                .createResponseHandler(DescribeChangeSetResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeChangeSetRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeChangeSetRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeChangeSet");

            return clientHandler.execute(new ClientExecutionParams<DescribeChangeSetRequest, DescribeChangeSetResponse>()
                    .withOperationName("DescribeChangeSet").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(describeChangeSetRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DescribeChangeSetRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns hook-related information for the change set and a list of changes that CloudFormation makes when you run
     * the change set.
     * </p>
     *
     * @param describeChangeSetHooksRequest
     * @return Result of the DescribeChangeSetHooks operation returned by the service.
     * @throws ChangeSetNotFoundException
     *         The specified change set name or ID doesn't exit. To view valid change sets for a stack, use the
     *         <code>ListChangeSets</code> operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFormationClient.DescribeChangeSetHooks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribeChangeSetHooks"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeChangeSetHooksResponse describeChangeSetHooks(DescribeChangeSetHooksRequest describeChangeSetHooksRequest)
            throws ChangeSetNotFoundException, AwsServiceException, SdkClientException, CloudFormationException {

        HttpResponseHandler<DescribeChangeSetHooksResponse> responseHandler = protocolFactory
                .createResponseHandler(DescribeChangeSetHooksResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeChangeSetHooksRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeChangeSetHooksRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeChangeSetHooks");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeChangeSetHooksRequest, DescribeChangeSetHooksResponse>()
                            .withOperationName("DescribeChangeSetHooks").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(describeChangeSetHooksRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeChangeSetHooksRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Describes a generated template. The output includes details about the progress of the creation of a generated
     * template started by a <code>CreateGeneratedTemplate</code> API action or the update of a generated template
     * started with an <code>UpdateGeneratedTemplate</code> API action.
     * </p>
     *
     * @param describeGeneratedTemplateRequest
     * @return Result of the DescribeGeneratedTemplate operation returned by the service.
     * @throws GeneratedTemplateNotFoundException
     *         The generated template was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFormationClient.DescribeGeneratedTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribeGeneratedTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeGeneratedTemplateResponse describeGeneratedTemplate(
            DescribeGeneratedTemplateRequest describeGeneratedTemplateRequest) throws GeneratedTemplateNotFoundException,
            AwsServiceException, SdkClientException, CloudFormationException {

        HttpResponseHandler<DescribeGeneratedTemplateResponse> responseHandler = protocolFactory
                .createResponseHandler(DescribeGeneratedTemplateResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeGeneratedTemplateRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeGeneratedTemplateRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeGeneratedTemplate");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeGeneratedTemplateRequest, DescribeGeneratedTemplateResponse>()
                            .withOperationName("DescribeGeneratedTemplate").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(describeGeneratedTemplateRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeGeneratedTemplateRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves information about the account's <code>OrganizationAccess</code> status. This API can be called either
     * by the management account or the delegated administrator by using the <code>CallAs</code> parameter. This API can
     * also be called without the <code>CallAs</code> parameter by the management account.
     * </p>
     *
     * @param describeOrganizationsAccessRequest
     * @return Result of the DescribeOrganizationsAccess operation returned by the service.
     * @throws InvalidOperationException
     *         The specified operation isn't valid.
     * @throws OperationNotFoundException
     *         The specified ID refers to an operation that doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFormationClient.DescribeOrganizationsAccess
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribeOrganizationsAccess"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeOrganizationsAccessResponse describeOrganizationsAccess(
            DescribeOrganizationsAccessRequest describeOrganizationsAccessRequest) throws InvalidOperationException,
            OperationNotFoundException, AwsServiceException, SdkClientException, CloudFormationException {

        HttpResponseHandler<DescribeOrganizationsAccessResponse> responseHandler = protocolFactory
                .createResponseHandler(DescribeOrganizationsAccessResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeOrganizationsAccessRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeOrganizationsAccessRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeOrganizationsAccess");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeOrganizationsAccessRequest, DescribeOrganizationsAccessResponse>()
                            .withOperationName("DescribeOrganizationsAccess").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(describeOrganizationsAccessRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeOrganizationsAccessRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns information about a CloudFormation extension publisher.
     * </p>
     * <p>
     * If you don't supply a <code>PublisherId</code>, and you have registered as an extension publisher,
     * <code>DescribePublisher</code> returns information about your own publisher account.
     * </p>
     * <p>
     * For more information about registering as a publisher, see:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_RegisterPublisher.html">
     * RegisterPublisher</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/publish-extension.html">Publishing
     * extensions to make them available for public use</a> in the <i>CloudFormation Command Line Interface (CLI) User
     * Guide</i>
     * </p>
     * </li>
     * </ul>
     *
     * @param describePublisherRequest
     * @return Result of the DescribePublisher operation returned by the service.
     * @throws CfnRegistryException
     *         An error occurred during a CloudFormation registry operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFormationClient.DescribePublisher
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribePublisher"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribePublisherResponse describePublisher(DescribePublisherRequest describePublisherRequest)
            throws CfnRegistryException, AwsServiceException, SdkClientException, CloudFormationException {

        HttpResponseHandler<DescribePublisherResponse> responseHandler = protocolFactory
                .createResponseHandler(DescribePublisherResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describePublisherRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describePublisherRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribePublisher");

            return clientHandler.execute(new ClientExecutionParams<DescribePublisherRequest, DescribePublisherResponse>()
                    .withOperationName("DescribePublisher").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(describePublisherRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DescribePublisherRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Describes details of a resource scan.
     * </p>
     *
     * @param describeResourceScanRequest
     * @return Result of the DescribeResourceScan operation returned by the service.
     * @throws ResourceScanNotFoundException
     *         The resource scan was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFormationClient.DescribeResourceScan
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribeResourceScan"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeResourceScanResponse describeResourceScan(DescribeResourceScanRequest describeResourceScanRequest)
            throws ResourceScanNotFoundException, AwsServiceException, SdkClientException, CloudFormationException {

        HttpResponseHandler<DescribeResourceScanResponse> responseHandler = protocolFactory
                .createResponseHandler(DescribeResourceScanResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeResourceScanRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeResourceScanRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeResourceScan");

            return clientHandler.execute(new ClientExecutionParams<DescribeResourceScanRequest, DescribeResourceScanResponse>()
                    .withOperationName("DescribeResourceScan").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(describeResourceScanRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DescribeResourceScanRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns information about a stack drift detection operation. A stack drift detection operation detects whether a
     * stack's actual configuration differs, or has <i>drifted</i>, from its expected configuration, as defined in the
     * stack template and any values specified as template parameters. A stack is considered to have drifted if one or
     * more of its resources have drifted. For more information about stack and resource drift, see <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-stack-drift.html">Detect unmanaged
     * configuration changes to stacks and resources with drift detection</a>.
     * </p>
     * <p>
     * Use <a>DetectStackDrift</a> to initiate a stack drift detection operation. <code>DetectStackDrift</code> returns
     * a <code>StackDriftDetectionId</code> you can use to monitor the progress of the operation using
     * <code>DescribeStackDriftDetectionStatus</code>. Once the drift detection operation has completed, use
     * <a>DescribeStackResourceDrifts</a> to return drift information about the stack and its resources.
     * </p>
     *
     * @param describeStackDriftDetectionStatusRequest
     * @return Result of the DescribeStackDriftDetectionStatus operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFormationClient.DescribeStackDriftDetectionStatus
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribeStackDriftDetectionStatus"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeStackDriftDetectionStatusResponse describeStackDriftDetectionStatus(
            DescribeStackDriftDetectionStatusRequest describeStackDriftDetectionStatusRequest) throws AwsServiceException,
            SdkClientException, CloudFormationException {

        HttpResponseHandler<DescribeStackDriftDetectionStatusResponse> responseHandler = protocolFactory
                .createResponseHandler(DescribeStackDriftDetectionStatusResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeStackDriftDetectionStatusRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeStackDriftDetectionStatusRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeStackDriftDetectionStatus");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeStackDriftDetectionStatusRequest, DescribeStackDriftDetectionStatusResponse>()
                            .withOperationName("DescribeStackDriftDetectionStatus").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(describeStackDriftDetectionStatusRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeStackDriftDetectionStatusRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns all stack related events for a specified stack in reverse chronological order. For more information about
     * a stack's event history, see <a href=
     * "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stack-resource-configuration-complete.html"
     * >Understand CloudFormation stack creation events</a> in the <i>CloudFormation User Guide</i>.
     * </p>
     * <note>
     * <p>
     * You can list events for stacks that have failed to create or have been deleted by specifying the unique stack
     * identifier (stack ID).
     * </p>
     * </note>
     *
     * @param describeStackEventsRequest
     *        The input for <a>DescribeStackEvents</a> action.
     * @return Result of the DescribeStackEvents operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFormationClient.DescribeStackEvents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribeStackEvents"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeStackEventsResponse describeStackEvents(DescribeStackEventsRequest describeStackEventsRequest)
            throws AwsServiceException, SdkClientException, CloudFormationException {

        HttpResponseHandler<DescribeStackEventsResponse> responseHandler = protocolFactory
                .createResponseHandler(DescribeStackEventsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeStackEventsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeStackEventsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeStackEvents");

            return clientHandler.execute(new ClientExecutionParams<DescribeStackEventsRequest, DescribeStackEventsResponse>()
                    .withOperationName("DescribeStackEvents").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(describeStackEventsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DescribeStackEventsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns the stack instance that's associated with the specified StackSet, Amazon Web Services account, and Amazon
     * Web Services Region.
     * </p>
     * <p>
     * For a list of stack instances that are associated with a specific StackSet, use <a>ListStackInstances</a>.
     * </p>
     *
     * @param describeStackInstanceRequest
     * @return Result of the DescribeStackInstance operation returned by the service.
     * @throws StackSetNotFoundException
     *         The specified stack set doesn't exist.
     * @throws StackInstanceNotFoundException
     *         The specified stack instance doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFormationClient.DescribeStackInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribeStackInstance"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeStackInstanceResponse describeStackInstance(DescribeStackInstanceRequest describeStackInstanceRequest)
            throws StackSetNotFoundException, StackInstanceNotFoundException, AwsServiceException, SdkClientException,
            CloudFormationException {

        HttpResponseHandler<DescribeStackInstanceResponse> responseHandler = protocolFactory
                .createResponseHandler(DescribeStackInstanceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeStackInstanceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeStackInstanceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeStackInstance");

            return clientHandler.execute(new ClientExecutionParams<DescribeStackInstanceRequest, DescribeStackInstanceResponse>()
                    .withOperationName("DescribeStackInstance").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(describeStackInstanceRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DescribeStackInstanceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Describes the stack refactor status.
     * </p>
     *
     * @param describeStackRefactorRequest
     * @return Result of the DescribeStackRefactor operation returned by the service.
     * @throws StackRefactorNotFoundException
     *         The specified stack refactor can't be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFormationClient.DescribeStackRefactor
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribeStackRefactor"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeStackRefactorResponse describeStackRefactor(DescribeStackRefactorRequest describeStackRefactorRequest)
            throws StackRefactorNotFoundException, AwsServiceException, SdkClientException, CloudFormationException {

        HttpResponseHandler<DescribeStackRefactorResponse> responseHandler = protocolFactory
                .createResponseHandler(DescribeStackRefactorResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeStackRefactorRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeStackRefactorRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeStackRefactor");

            return clientHandler.execute(new ClientExecutionParams<DescribeStackRefactorRequest, DescribeStackRefactorResponse>()
                    .withOperationName("DescribeStackRefactor").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(describeStackRefactorRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DescribeStackRefactorRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns a description of the specified resource in the specified stack.
     * </p>
     * <p>
     * For deleted stacks, DescribeStackResource returns resource information for up to 90 days after the stack has been
     * deleted.
     * </p>
     *
     * @param describeStackResourceRequest
     *        The input for <a>DescribeStackResource</a> action.
     * @return Result of the DescribeStackResource operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFormationClient.DescribeStackResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribeStackResource"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeStackResourceResponse describeStackResource(DescribeStackResourceRequest describeStackResourceRequest)
            throws AwsServiceException, SdkClientException, CloudFormationException {

        HttpResponseHandler<DescribeStackResourceResponse> responseHandler = protocolFactory
                .createResponseHandler(DescribeStackResourceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeStackResourceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeStackResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeStackResource");

            return clientHandler.execute(new ClientExecutionParams<DescribeStackResourceRequest, DescribeStackResourceResponse>()
                    .withOperationName("DescribeStackResource").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(describeStackResourceRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DescribeStackResourceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns drift information for the resources that have been checked for drift in the specified stack. This
     * includes actual and expected configuration values for resources where CloudFormation detects configuration drift.
     * </p>
     * <p>
     * For a given stack, there will be one <code>StackResourceDrift</code> for each stack resource that has been
     * checked for drift. Resources that haven't yet been checked for drift aren't included. Resources that don't
     * currently support drift detection aren't checked, and so not included. For a list of resources that support drift
     * detection, see <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/resource-import-supported-resources.html"
     * >Resource type support for imports and drift detection</a>.
     * </p>
     * <p>
     * Use <a>DetectStackResourceDrift</a> to detect drift on individual resources, or <a>DetectStackDrift</a> to detect
     * drift on all supported resources for a given stack.
     * </p>
     *
     * @param describeStackResourceDriftsRequest
     * @return Result of the DescribeStackResourceDrifts operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFormationClient.DescribeStackResourceDrifts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribeStackResourceDrifts"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeStackResourceDriftsResponse describeStackResourceDrifts(
            DescribeStackResourceDriftsRequest describeStackResourceDriftsRequest) throws AwsServiceException,
            SdkClientException, CloudFormationException {

        HttpResponseHandler<DescribeStackResourceDriftsResponse> responseHandler = protocolFactory
                .createResponseHandler(DescribeStackResourceDriftsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeStackResourceDriftsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeStackResourceDriftsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeStackResourceDrifts");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeStackResourceDriftsRequest, DescribeStackResourceDriftsResponse>()
                            .withOperationName("DescribeStackResourceDrifts").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(describeStackResourceDriftsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeStackResourceDriftsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns Amazon Web Services resource descriptions for running and deleted stacks. If <code>StackName</code> is
     * specified, all the associated resources that are part of the stack are returned. If
     * <code>PhysicalResourceId</code> is specified, the associated resources of the stack that the resource belongs to
     * are returned.
     * </p>
     * <note>
     * <p>
     * Only the first 100 resources will be returned. If your stack has more resources than this, you should use
     * <code>ListStackResources</code> instead.
     * </p>
     * </note>
     * <p>
     * For deleted stacks, <code>DescribeStackResources</code> returns resource information for up to 90 days after the
     * stack has been deleted.
     * </p>
     * <p>
     * You must specify either <code>StackName</code> or <code>PhysicalResourceId</code>, but not both. In addition, you
     * can specify <code>LogicalResourceId</code> to filter the returned result. For more information about resources,
     * the <code>LogicalResourceId</code> and <code>PhysicalResourceId</code>, see the <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/">CloudFormation User Guide</a>.
     * </p>
     * <note>
     * <p>
     * A <code>ValidationError</code> is returned if you specify both <code>StackName</code> and
     * <code>PhysicalResourceId</code> in the same request.
     * </p>
     * </note>
     *
     * @param describeStackResourcesRequest
     *        The input for <a>DescribeStackResources</a> action.
     * @return Result of the DescribeStackResources operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFormationClient.DescribeStackResources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribeStackResources"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeStackResourcesResponse describeStackResources(DescribeStackResourcesRequest describeStackResourcesRequest)
            throws AwsServiceException, SdkClientException, CloudFormationException {

        HttpResponseHandler<DescribeStackResourcesResponse> responseHandler = protocolFactory
                .createResponseHandler(DescribeStackResourcesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeStackResourcesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeStackResourcesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeStackResources");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeStackResourcesRequest, DescribeStackResourcesResponse>()
                            .withOperationName("DescribeStackResources").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(describeStackResourcesRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeStackResourcesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns the description of the specified StackSet.
     * </p>
     *
     * @param describeStackSetRequest
     * @return Result of the DescribeStackSet operation returned by the service.
     * @throws StackSetNotFoundException
     *         The specified stack set doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFormationClient.DescribeStackSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribeStackSet"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeStackSetResponse describeStackSet(DescribeStackSetRequest describeStackSetRequest)
            throws StackSetNotFoundException, AwsServiceException, SdkClientException, CloudFormationException {

        HttpResponseHandler<DescribeStackSetResponse> responseHandler = protocolFactory
                .createResponseHandler(DescribeStackSetResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeStackSetRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeStackSetRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeStackSet");

            return clientHandler.execute(new ClientExecutionParams<DescribeStackSetRequest, DescribeStackSetResponse>()
                    .withOperationName("DescribeStackSet").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(describeStackSetRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DescribeStackSetRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns the description of the specified StackSet operation.
     * </p>
     *
     * @param describeStackSetOperationRequest
     * @return Result of the DescribeStackSetOperation operation returned by the service.
     * @throws StackSetNotFoundException
     *         The specified stack set doesn't exist.
     * @throws OperationNotFoundException
     *         The specified ID refers to an operation that doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFormationClient.DescribeStackSetOperation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribeStackSetOperation"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeStackSetOperationResponse describeStackSetOperation(
            DescribeStackSetOperationRequest describeStackSetOperationRequest) throws StackSetNotFoundException,
            OperationNotFoundException, AwsServiceException, SdkClientException, CloudFormationException {

        HttpResponseHandler<DescribeStackSetOperationResponse> responseHandler = protocolFactory
                .createResponseHandler(DescribeStackSetOperationResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeStackSetOperationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeStackSetOperationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeStackSetOperation");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeStackSetOperationRequest, DescribeStackSetOperationResponse>()
                            .withOperationName("DescribeStackSetOperation").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(describeStackSetOperationRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeStackSetOperationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns the description for the specified stack; if no stack name was specified, then it returns the description
     * for all the stacks created. For more information about a stack's event history, see <a href=
     * "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stack-resource-configuration-complete.html"
     * >Understand CloudFormation stack creation events</a> in the <i>CloudFormation User Guide</i>.
     * </p>
     * <note>
     * <p>
     * If the stack doesn't exist, a <code>ValidationError</code> is returned.
     * </p>
     * </note>
     *
     * @param describeStacksRequest
     *        The input for <a>DescribeStacks</a> action.
     * @return Result of the DescribeStacks operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFormationClient.DescribeStacks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribeStacks" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DescribeStacksResponse describeStacks(DescribeStacksRequest describeStacksRequest) throws AwsServiceException,
            SdkClientException, CloudFormationException {

        HttpResponseHandler<DescribeStacksResponse> responseHandler = protocolFactory
                .createResponseHandler(DescribeStacksResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeStacksRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeStacksRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeStacks");

            return clientHandler.execute(new ClientExecutionParams<DescribeStacksRequest, DescribeStacksResponse>()
                    .withOperationName("DescribeStacks").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(describeStacksRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DescribeStacksRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns detailed information about an extension that has been registered.
     * </p>
     * <p>
     * If you specify a <code>VersionId</code>, <code>DescribeType</code> returns information about that specific
     * extension version. Otherwise, it returns information about the default extension version.
     * </p>
     *
     * @param describeTypeRequest
     * @return Result of the DescribeType operation returned by the service.
     * @throws CfnRegistryException
     *         An error occurred during a CloudFormation registry operation.
     * @throws TypeNotFoundException
     *         The specified extension doesn't exist in the CloudFormation registry.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFormationClient.DescribeType
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribeType" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DescribeTypeResponse describeType(DescribeTypeRequest describeTypeRequest) throws CfnRegistryException,
            TypeNotFoundException, AwsServiceException, SdkClientException, CloudFormationException {

        HttpResponseHandler<DescribeTypeResponse> responseHandler = protocolFactory
                .createResponseHandler(DescribeTypeResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeTypeRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeTypeRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeType");

            return clientHandler.execute(new ClientExecutionParams<DescribeTypeRequest, DescribeTypeResponse>()
                    .withOperationName("DescribeType").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(describeTypeRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DescribeTypeRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns information about an extension's registration, including its current status and type and version
     * identifiers.
     * </p>
     * <p>
     * When you initiate a registration request using <a>RegisterType</a>, you can then use
     * <a>DescribeTypeRegistration</a> to monitor the progress of that registration request.
     * </p>
     * <p>
     * Once the registration request has completed, use <a>DescribeType</a> to return detailed information about an
     * extension.
     * </p>
     *
     * @param describeTypeRegistrationRequest
     * @return Result of the DescribeTypeRegistration operation returned by the service.
     * @throws CfnRegistryException
     *         An error occurred during a CloudFormation registry operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFormationClient.DescribeTypeRegistration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribeTypeRegistration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeTypeRegistrationResponse describeTypeRegistration(
            DescribeTypeRegistrationRequest describeTypeRegistrationRequest) throws CfnRegistryException, AwsServiceException,
            SdkClientException, CloudFormationException {

        HttpResponseHandler<DescribeTypeRegistrationResponse> responseHandler = protocolFactory
                .createResponseHandler(DescribeTypeRegistrationResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeTypeRegistrationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeTypeRegistrationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeTypeRegistration");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeTypeRegistrationRequest, DescribeTypeRegistrationResponse>()
                            .withOperationName("DescribeTypeRegistration").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(describeTypeRegistrationRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeTypeRegistrationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Detects whether a stack's actual configuration differs, or has <i>drifted</i>, from its expected configuration,
     * as defined in the stack template and any values specified as template parameters. For each resource in the stack
     * that supports drift detection, CloudFormation compares the actual configuration of the resource with its expected
     * template configuration. Only resource properties explicitly defined in the stack template are checked for drift.
     * A stack is considered to have drifted if one or more of its resources differ from their expected template
     * configurations. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-stack-drift.html">Detect unmanaged
     * configuration changes to stacks and resources with drift detection</a>.
     * </p>
     * <p>
     * Use <code>DetectStackDrift</code> to detect drift on all supported resources for a given stack, or
     * <a>DetectStackResourceDrift</a> to detect drift on individual resources.
     * </p>
     * <p>
     * For a list of stack resources that currently support drift detection, see <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/resource-import-supported-resources.html"
     * >Resource type support for imports and drift detection</a>.
     * </p>
     * <p>
     * <code>DetectStackDrift</code> can take up to several minutes, depending on the number of resources contained
     * within the stack. Use <a>DescribeStackDriftDetectionStatus</a> to monitor the progress of a detect stack drift
     * operation. Once the drift detection operation has completed, use <a>DescribeStackResourceDrifts</a> to return
     * drift information about the stack and its resources.
     * </p>
     * <p>
     * When detecting drift on a stack, CloudFormation doesn't detect drift on any nested stacks belonging to that
     * stack. Perform <code>DetectStackDrift</code> directly on the nested stack itself.
     * </p>
     *
     * @param detectStackDriftRequest
     * @return Result of the DetectStackDrift operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFormationClient.DetectStackDrift
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DetectStackDrift"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DetectStackDriftResponse detectStackDrift(DetectStackDriftRequest detectStackDriftRequest) throws AwsServiceException,
            SdkClientException, CloudFormationException {

        HttpResponseHandler<DetectStackDriftResponse> responseHandler = protocolFactory
                .createResponseHandler(DetectStackDriftResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(detectStackDriftRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, detectStackDriftRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DetectStackDrift");

            return clientHandler.execute(new ClientExecutionParams<DetectStackDriftRequest, DetectStackDriftResponse>()
                    .withOperationName("DetectStackDrift").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(detectStackDriftRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DetectStackDriftRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns information about whether a resource's actual configuration differs, or has <i>drifted</i>, from its
     * expected configuration, as defined in the stack template and any values specified as template parameters. This
     * information includes actual and expected property values for resources in which CloudFormation detects drift.
     * Only resource properties explicitly defined in the stack template are checked for drift. For more information
     * about stack and resource drift, see <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-stack-drift.html">Detect unmanaged
     * configuration changes to stacks and resources with drift detection</a>.
     * </p>
     * <p>
     * Use <code>DetectStackResourceDrift</code> to detect drift on individual resources, or <a>DetectStackDrift</a> to
     * detect drift on all resources in a given stack that support drift detection.
     * </p>
     * <p>
     * Resources that don't currently support drift detection can't be checked. For a list of resources that support
     * drift detection, see <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/resource-import-supported-resources.html"
     * >Resource type support for imports and drift detection</a>.
     * </p>
     *
     * @param detectStackResourceDriftRequest
     * @return Result of the DetectStackResourceDrift operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFormationClient.DetectStackResourceDrift
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DetectStackResourceDrift"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DetectStackResourceDriftResponse detectStackResourceDrift(
            DetectStackResourceDriftRequest detectStackResourceDriftRequest) throws AwsServiceException, SdkClientException,
            CloudFormationException {

        HttpResponseHandler<DetectStackResourceDriftResponse> responseHandler = protocolFactory
                .createResponseHandler(DetectStackResourceDriftResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(detectStackResourceDriftRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, detectStackResourceDriftRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DetectStackResourceDrift");

            return clientHandler
                    .execute(new ClientExecutionParams<DetectStackResourceDriftRequest, DetectStackResourceDriftResponse>()
                            .withOperationName("DetectStackResourceDrift").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(detectStackResourceDriftRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DetectStackResourceDriftRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Detect drift on a stack set. When CloudFormation performs drift detection on a stack set, it performs drift
     * detection on the stack associated with each stack instance in the stack set. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-drift.html">Performing drift
     * detection on CloudFormation StackSets</a>.
     * </p>
     * <p>
     * <code>DetectStackSetDrift</code> returns the <code>OperationId</code> of the stack set drift detection operation.
     * Use this operation id with <a>DescribeStackSetOperation</a> to monitor the progress of the drift detection
     * operation. The drift detection operation may take some time, depending on the number of stack instances included
     * in the stack set, in addition to the number of resources included in each stack.
     * </p>
     * <p>
     * Once the operation has completed, use the following actions to return drift information:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Use <a>DescribeStackSet</a> to return detailed information about the stack set, including detailed information
     * about the last <i>completed</i> drift operation performed on the stack set. (Information about drift operations
     * that are in progress isn't included.)
     * </p>
     * </li>
     * <li>
     * <p>
     * Use <a>ListStackInstances</a> to return a list of stack instances belonging to the stack set, including the drift
     * status and last drift time checked of each instance.
     * </p>
     * </li>
     * <li>
     * <p>
     * Use <a>DescribeStackInstance</a> to return detailed information about a specific stack instance, including its
     * drift status and last drift time checked.
     * </p>
     * </li>
     * </ul>
     * <p>
     * You can only run a single drift detection operation on a given stack set at one time.
     * </p>
     * <p>
     * To stop a drift detection stack set operation, use <a>StopStackSetOperation</a>.
     * </p>
     *
     * @param detectStackSetDriftRequest
     * @return Result of the DetectStackSetDrift operation returned by the service.
     * @throws InvalidOperationException
     *         The specified operation isn't valid.
     * @throws OperationInProgressException
     *         Another operation is currently in progress for this stack set. Only one operation can be performed for a
     *         stack set at a given time.
     * @throws StackSetNotFoundException
     *         The specified stack set doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFormationClient.DetectStackSetDrift
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DetectStackSetDrift"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DetectStackSetDriftResponse detectStackSetDrift(DetectStackSetDriftRequest detectStackSetDriftRequest)
            throws InvalidOperationException, OperationInProgressException, StackSetNotFoundException, AwsServiceException,
            SdkClientException, CloudFormationException {

        HttpResponseHandler<DetectStackSetDriftResponse> responseHandler = protocolFactory
                .createResponseHandler(DetectStackSetDriftResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(detectStackSetDriftRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, detectStackSetDriftRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DetectStackSetDrift");

            return clientHandler.execute(new ClientExecutionParams<DetectStackSetDriftRequest, DetectStackSetDriftResponse>()
                    .withOperationName("DetectStackSetDrift").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(detectStackSetDriftRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DetectStackSetDriftRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns the estimated monthly cost of a template. The return value is an Amazon Web Services Simple Monthly
     * Calculator URL with a query string that describes the resources required to run the template.
     * </p>
     *
     * @param estimateTemplateCostRequest
     *        The input for an <a>EstimateTemplateCost</a> action.
     * @return Result of the EstimateTemplateCost operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFormationClient.EstimateTemplateCost
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/EstimateTemplateCost"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public EstimateTemplateCostResponse estimateTemplateCost(EstimateTemplateCostRequest estimateTemplateCostRequest)
            throws AwsServiceException, SdkClientException, CloudFormationException {

        HttpResponseHandler<EstimateTemplateCostResponse> responseHandler = protocolFactory
                .createResponseHandler(EstimateTemplateCostResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(estimateTemplateCostRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, estimateTemplateCostRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "EstimateTemplateCost");

            return clientHandler.execute(new ClientExecutionParams<EstimateTemplateCostRequest, EstimateTemplateCostResponse>()
                    .withOperationName("EstimateTemplateCost").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(estimateTemplateCostRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new EstimateTemplateCostRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates a stack using the input information that was provided when the specified change set was created. After
     * the call successfully completes, CloudFormation starts updating the stack. Use the <a>DescribeStacks</a> action
     * to view the status of the update.
     * </p>
     * <p>
     * When you execute a change set, CloudFormation deletes all other change sets associated with the stack because
     * they aren't valid for the updated stack.
     * </p>
     * <p>
     * If a stack policy is associated with the stack, CloudFormation enforces the policy during the update. You can't
     * specify a temporary stack policy that overrides the current policy.
     * </p>
     * <p>
     * To create a change set for the entire stack hierarchy, <code>IncludeNestedStacks</code> must have been set to
     * <code>True</code>.
     * </p>
     *
     * @param executeChangeSetRequest
     *        The input for the <a>ExecuteChangeSet</a> action.
     * @return Result of the ExecuteChangeSet operation returned by the service.
     * @throws InvalidChangeSetStatusException
     *         The specified change set can't be used to update the stack. For example, the change set status might be
     *         <code>CREATE_IN_PROGRESS</code>, or the stack status might be <code>UPDATE_IN_PROGRESS</code>.
     * @throws ChangeSetNotFoundException
     *         The specified change set name or ID doesn't exit. To view valid change sets for a stack, use the
     *         <code>ListChangeSets</code> operation.
     * @throws InsufficientCapabilitiesException
     *         The template contains resources with capabilities that weren't specified in the Capabilities parameter.
     * @throws TokenAlreadyExistsException
     *         A client request token already exists.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFormationClient.ExecuteChangeSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ExecuteChangeSet"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ExecuteChangeSetResponse executeChangeSet(ExecuteChangeSetRequest executeChangeSetRequest)
            throws InvalidChangeSetStatusException, ChangeSetNotFoundException, InsufficientCapabilitiesException,
            TokenAlreadyExistsException, AwsServiceException, SdkClientException, CloudFormationException {

        HttpResponseHandler<ExecuteChangeSetResponse> responseHandler = protocolFactory
                .createResponseHandler(ExecuteChangeSetResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(executeChangeSetRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, executeChangeSetRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ExecuteChangeSet");

            return clientHandler.execute(new ClientExecutionParams<ExecuteChangeSetRequest, ExecuteChangeSetResponse>()
                    .withOperationName("ExecuteChangeSet").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(executeChangeSetRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ExecuteChangeSetRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Executes the stack refactor operation.
     * </p>
     *
     * @param executeStackRefactorRequest
     * @return Result of the ExecuteStackRefactor operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFormationClient.ExecuteStackRefactor
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ExecuteStackRefactor"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ExecuteStackRefactorResponse executeStackRefactor(ExecuteStackRefactorRequest executeStackRefactorRequest)
            throws AwsServiceException, SdkClientException, CloudFormationException {

        HttpResponseHandler<ExecuteStackRefactorResponse> responseHandler = protocolFactory
                .createResponseHandler(ExecuteStackRefactorResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(executeStackRefactorRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, executeStackRefactorRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ExecuteStackRefactor");

            return clientHandler.execute(new ClientExecutionParams<ExecuteStackRefactorRequest, ExecuteStackRefactorResponse>()
                    .withOperationName("ExecuteStackRefactor").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(executeStackRefactorRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ExecuteStackRefactorRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves a generated template. If the template is in an <code>InProgress</code> or <code>Pending</code> status
     * then the template returned will be the template when the template was last in a <code>Complete</code> status. If
     * the template has not yet been in a <code>Complete</code> status then an empty template will be returned.
     * </p>
     *
     * @param getGeneratedTemplateRequest
     * @return Result of the GetGeneratedTemplate operation returned by the service.
     * @throws GeneratedTemplateNotFoundException
     *         The generated template was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFormationClient.GetGeneratedTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/GetGeneratedTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetGeneratedTemplateResponse getGeneratedTemplate(GetGeneratedTemplateRequest getGeneratedTemplateRequest)
            throws GeneratedTemplateNotFoundException, AwsServiceException, SdkClientException, CloudFormationException {

        HttpResponseHandler<GetGeneratedTemplateResponse> responseHandler = protocolFactory
                .createResponseHandler(GetGeneratedTemplateResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getGeneratedTemplateRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getGeneratedTemplateRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetGeneratedTemplate");

            return clientHandler.execute(new ClientExecutionParams<GetGeneratedTemplateRequest, GetGeneratedTemplateResponse>()
                    .withOperationName("GetGeneratedTemplate").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(getGeneratedTemplateRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetGeneratedTemplateRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns the stack policy for a specified stack. If a stack doesn't have a policy, a null value is returned.
     * </p>
     *
     * @param getStackPolicyRequest
     *        The input for the <a>GetStackPolicy</a> action.
     * @return Result of the GetStackPolicy operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFormationClient.GetStackPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/GetStackPolicy" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public GetStackPolicyResponse getStackPolicy(GetStackPolicyRequest getStackPolicyRequest) throws AwsServiceException,
            SdkClientException, CloudFormationException {

        HttpResponseHandler<GetStackPolicyResponse> responseHandler = protocolFactory
                .createResponseHandler(GetStackPolicyResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getStackPolicyRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getStackPolicyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetStackPolicy");

            return clientHandler.execute(new ClientExecutionParams<GetStackPolicyRequest, GetStackPolicyResponse>()
                    .withOperationName("GetStackPolicy").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(getStackPolicyRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetStackPolicyRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns the template body for a specified stack. You can get the template for running or deleted stacks.
     * </p>
     * <p>
     * For deleted stacks, <code>GetTemplate</code> returns the template for up to 90 days after the stack has been
     * deleted.
     * </p>
     * <note>
     * <p>
     * If the template doesn't exist, a <code>ValidationError</code> is returned.
     * </p>
     * </note>
     *
     * @param getTemplateRequest
     *        The input for a <a>GetTemplate</a> action.
     * @return Result of the GetTemplate operation returned by the service.
     * @throws ChangeSetNotFoundException
     *         The specified change set name or ID doesn't exit. To view valid change sets for a stack, use the
     *         <code>ListChangeSets</code> operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFormationClient.GetTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/GetTemplate" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public GetTemplateResponse getTemplate(GetTemplateRequest getTemplateRequest) throws ChangeSetNotFoundException,
            AwsServiceException, SdkClientException, CloudFormationException {

        HttpResponseHandler<GetTemplateResponse> responseHandler = protocolFactory
                .createResponseHandler(GetTemplateResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getTemplateRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getTemplateRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetTemplate");

            return clientHandler.execute(new ClientExecutionParams<GetTemplateRequest, GetTemplateResponse>()
                    .withOperationName("GetTemplate").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(getTemplateRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetTemplateRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns information about a new or existing template. The <code>GetTemplateSummary</code> action is useful for
     * viewing parameter information, such as default parameter values and parameter types, before you create or update
     * a stack or stack set.
     * </p>
     * <p>
     * You can use the <code>GetTemplateSummary</code> action when you submit a template, or you can get template
     * information for a stack set, or a running or deleted stack.
     * </p>
     * <p>
     * For deleted stacks, <code>GetTemplateSummary</code> returns the template information for up to 90 days after the
     * stack has been deleted. If the template doesn't exist, a <code>ValidationError</code> is returned.
     * </p>
     *
     * @param getTemplateSummaryRequest
     *        The input for the <a>GetTemplateSummary</a> action.
     * @return Result of the GetTemplateSummary operation returned by the service.
     * @throws StackSetNotFoundException
     *         The specified stack set doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFormationClient.GetTemplateSummary
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/GetTemplateSummary"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetTemplateSummaryResponse getTemplateSummary(GetTemplateSummaryRequest getTemplateSummaryRequest)
            throws StackSetNotFoundException, AwsServiceException, SdkClientException, CloudFormationException {

        HttpResponseHandler<GetTemplateSummaryResponse> responseHandler = protocolFactory
                .createResponseHandler(GetTemplateSummaryResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getTemplateSummaryRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getTemplateSummaryRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetTemplateSummary");

            return clientHandler.execute(new ClientExecutionParams<GetTemplateSummaryRequest, GetTemplateSummaryResponse>()
                    .withOperationName("GetTemplateSummary").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(getTemplateSummaryRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetTemplateSummaryRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Import existing stacks into a new stack sets. Use the stack import operation to import up to 10 stacks into a new
     * stack set in the same account as the source stack or in a different administrator account and Region, by
     * specifying the stack ID of the stack you intend to import.
     * </p>
     *
     * @param importStacksToStackSetRequest
     * @return Result of the ImportStacksToStackSet operation returned by the service.
     * @throws LimitExceededException
     *         The quota for the resource has already been reached.</p>
     *         <p>
     *         For information about resource and stack limitations, see <a
     *         href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/cloudformation-limits.html"
     *         >CloudFormation quotas</a> in the <i>CloudFormation User Guide</i>.
     * @throws StackSetNotFoundException
     *         The specified stack set doesn't exist.
     * @throws InvalidOperationException
     *         The specified operation isn't valid.
     * @throws OperationInProgressException
     *         Another operation is currently in progress for this stack set. Only one operation can be performed for a
     *         stack set at a given time.
     * @throws OperationIdAlreadyExistsException
     *         The specified operation ID already exists.
     * @throws StackNotFoundException
     *         The specified stack ARN doesn't exist or stack doesn't exist corresponding to the ARN in input.
     * @throws StaleRequestException
     *         Another operation has been performed on this stack set since the specified operation was performed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFormationClient.ImportStacksToStackSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ImportStacksToStackSet"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ImportStacksToStackSetResponse importStacksToStackSet(ImportStacksToStackSetRequest importStacksToStackSetRequest)
            throws LimitExceededException, StackSetNotFoundException, InvalidOperationException, OperationInProgressException,
            OperationIdAlreadyExistsException, StackNotFoundException, StaleRequestException, AwsServiceException,
            SdkClientException, CloudFormationException {

        HttpResponseHandler<ImportStacksToStackSetResponse> responseHandler = protocolFactory
                .createResponseHandler(ImportStacksToStackSetResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(importStacksToStackSetRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, importStacksToStackSetRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ImportStacksToStackSet");

            return clientHandler
                    .execute(new ClientExecutionParams<ImportStacksToStackSetRequest, ImportStacksToStackSetResponse>()
                            .withOperationName("ImportStacksToStackSet").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(importStacksToStackSetRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ImportStacksToStackSetRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns the ID and status of each active change set for a stack. For example, CloudFormation lists change sets
     * that are in the <code>CREATE_IN_PROGRESS</code> or <code>CREATE_PENDING</code> state.
     * </p>
     *
     * @param listChangeSetsRequest
     *        The input for the <a>ListChangeSets</a> action.
     * @return Result of the ListChangeSets operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFormationClient.ListChangeSets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListChangeSets" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public ListChangeSetsResponse listChangeSets(ListChangeSetsRequest listChangeSetsRequest) throws AwsServiceException,
            SdkClientException, CloudFormationException {

        HttpResponseHandler<ListChangeSetsResponse> responseHandler = protocolFactory
                .createResponseHandler(ListChangeSetsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listChangeSetsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listChangeSetsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListChangeSets");

            return clientHandler.execute(new ClientExecutionParams<ListChangeSetsRequest, ListChangeSetsResponse>()
                    .withOperationName("ListChangeSets").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(listChangeSetsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListChangeSetsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists all exported output values in the account and Region in which you call this action. Use this action to see
     * the exported output values that you can import into other stacks. To import values, use the <a href=
     * "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/intrinsic-function-reference-importvalue.html">
     * Fn::ImportValue</a> function.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-stack-exports.html">Get exported
     * outputs from a deployed CloudFormation stack</a>.
     * </p>
     *
     * @param listExportsRequest
     * @return Result of the ListExports operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFormationClient.ListExports
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListExports" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public ListExportsResponse listExports(ListExportsRequest listExportsRequest) throws AwsServiceException, SdkClientException,
            CloudFormationException {

        HttpResponseHandler<ListExportsResponse> responseHandler = protocolFactory
                .createResponseHandler(ListExportsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listExportsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listExportsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListExports");

            return clientHandler.execute(new ClientExecutionParams<ListExportsRequest, ListExportsResponse>()
                    .withOperationName("ListExports").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(listExportsRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListExportsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists your generated templates in this Region.
     * </p>
     *
     * @param listGeneratedTemplatesRequest
     * @return Result of the ListGeneratedTemplates operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFormationClient.ListGeneratedTemplates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListGeneratedTemplates"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListGeneratedTemplatesResponse listGeneratedTemplates(ListGeneratedTemplatesRequest listGeneratedTemplatesRequest)
            throws AwsServiceException, SdkClientException, CloudFormationException {

        HttpResponseHandler<ListGeneratedTemplatesResponse> responseHandler = protocolFactory
                .createResponseHandler(ListGeneratedTemplatesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listGeneratedTemplatesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listGeneratedTemplatesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListGeneratedTemplates");

            return clientHandler
                    .execute(new ClientExecutionParams<ListGeneratedTemplatesRequest, ListGeneratedTemplatesResponse>()
                            .withOperationName("ListGeneratedTemplates").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(listGeneratedTemplatesRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListGeneratedTemplatesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns summaries of invoked Hooks when a change set or Cloud Control API operation target is provided.
     * </p>
     *
     * @param listHookResultsRequest
     * @return Result of the ListHookResults operation returned by the service.
     * @throws HookResultNotFoundException
     *         The specified target doesn't have any requested Hook invocations.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFormationClient.ListHookResults
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListHookResults"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListHookResultsResponse listHookResults(ListHookResultsRequest listHookResultsRequest)
            throws HookResultNotFoundException, AwsServiceException, SdkClientException, CloudFormationException {

        HttpResponseHandler<ListHookResultsResponse> responseHandler = protocolFactory
                .createResponseHandler(ListHookResultsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listHookResultsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listHookResultsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListHookResults");

            return clientHandler.execute(new ClientExecutionParams<ListHookResultsRequest, ListHookResultsResponse>()
                    .withOperationName("ListHookResults").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(listHookResultsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListHookResultsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists all stacks that are importing an exported output value. To modify or remove an exported output value, first
     * use this action to see which stacks are using it. To see the exported output values in your account, see
     * <a>ListExports</a>.
     * </p>
     * <p>
     * For more information about importing an exported output value, see the <a href=
     * "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/intrinsic-function-reference-importvalue.html"
     * >Fn::ImportValue</a> function.
     * </p>
     *
     * @param listImportsRequest
     * @return Result of the ListImports operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFormationClient.ListImports
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListImports" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public ListImportsResponse listImports(ListImportsRequest listImportsRequest) throws AwsServiceException, SdkClientException,
            CloudFormationException {

        HttpResponseHandler<ListImportsResponse> responseHandler = protocolFactory
                .createResponseHandler(ListImportsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listImportsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listImportsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListImports");

            return clientHandler.execute(new ClientExecutionParams<ListImportsRequest, ListImportsResponse>()
                    .withOperationName("ListImports").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(listImportsRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListImportsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists the related resources for a list of resources from a resource scan. The response indicates whether each
     * returned resource is already managed by CloudFormation.
     * </p>
     *
     * @param listResourceScanRelatedResourcesRequest
     * @return Result of the ListResourceScanRelatedResources operation returned by the service.
     * @throws ResourceScanNotFoundException
     *         The resource scan was not found.
     * @throws ResourceScanInProgressException
     *         A resource scan is currently in progress. Only one can be run at a time for an account in a Region.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFormationClient.ListResourceScanRelatedResources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListResourceScanRelatedResources"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListResourceScanRelatedResourcesResponse listResourceScanRelatedResources(
            ListResourceScanRelatedResourcesRequest listResourceScanRelatedResourcesRequest)
            throws ResourceScanNotFoundException, ResourceScanInProgressException, AwsServiceException, SdkClientException,
            CloudFormationException {

        HttpResponseHandler<ListResourceScanRelatedResourcesResponse> responseHandler = protocolFactory
                .createResponseHandler(ListResourceScanRelatedResourcesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listResourceScanRelatedResourcesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                listResourceScanRelatedResourcesRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListResourceScanRelatedResources");

            return clientHandler
                    .execute(new ClientExecutionParams<ListResourceScanRelatedResourcesRequest, ListResourceScanRelatedResourcesResponse>()
                            .withOperationName("ListResourceScanRelatedResources").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(listResourceScanRelatedResourcesRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListResourceScanRelatedResourcesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists the resources from a resource scan. The results can be filtered by resource identifier, resource type
     * prefix, tag key, and tag value. Only resources that match all specified filters are returned. The response
     * indicates whether each returned resource is already managed by CloudFormation.
     * </p>
     *
     * @param listResourceScanResourcesRequest
     * @return Result of the ListResourceScanResources operation returned by the service.
     * @throws ResourceScanNotFoundException
     *         The resource scan was not found.
     * @throws ResourceScanInProgressException
     *         A resource scan is currently in progress. Only one can be run at a time for an account in a Region.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFormationClient.ListResourceScanResources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListResourceScanResources"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListResourceScanResourcesResponse listResourceScanResources(
            ListResourceScanResourcesRequest listResourceScanResourcesRequest) throws ResourceScanNotFoundException,
            ResourceScanInProgressException, AwsServiceException, SdkClientException, CloudFormationException {

        HttpResponseHandler<ListResourceScanResourcesResponse> responseHandler = protocolFactory
                .createResponseHandler(ListResourceScanResourcesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listResourceScanResourcesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listResourceScanResourcesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListResourceScanResources");

            return clientHandler
                    .execute(new ClientExecutionParams<ListResourceScanResourcesRequest, ListResourceScanResourcesResponse>()
                            .withOperationName("ListResourceScanResources").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(listResourceScanResourcesRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListResourceScanResourcesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * List the resource scans from newest to oldest. By default it will return up to 10 resource scans.
     * </p>
     *
     * @param listResourceScansRequest
     * @return Result of the ListResourceScans operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFormationClient.ListResourceScans
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListResourceScans"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListResourceScansResponse listResourceScans(ListResourceScansRequest listResourceScansRequest)
            throws AwsServiceException, SdkClientException, CloudFormationException {

        HttpResponseHandler<ListResourceScansResponse> responseHandler = protocolFactory
                .createResponseHandler(ListResourceScansResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listResourceScansRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listResourceScansRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListResourceScans");

            return clientHandler.execute(new ClientExecutionParams<ListResourceScansRequest, ListResourceScansResponse>()
                    .withOperationName("ListResourceScans").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(listResourceScansRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListResourceScansRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns drift information for resources in a stack instance.
     * </p>
     * <note>
     * <p>
     * <code>ListStackInstanceResourceDrifts</code> returns drift information for the most recent drift detection
     * operation. If an operation is in progress, it may only return partial results.
     * </p>
     * </note>
     *
     * @param listStackInstanceResourceDriftsRequest
     * @return Result of the ListStackInstanceResourceDrifts operation returned by the service.
     * @throws StackSetNotFoundException
     *         The specified stack set doesn't exist.
     * @throws StackInstanceNotFoundException
     *         The specified stack instance doesn't exist.
     * @throws OperationNotFoundException
     *         The specified ID refers to an operation that doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFormationClient.ListStackInstanceResourceDrifts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListStackInstanceResourceDrifts"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListStackInstanceResourceDriftsResponse listStackInstanceResourceDrifts(
            ListStackInstanceResourceDriftsRequest listStackInstanceResourceDriftsRequest) throws StackSetNotFoundException,
            StackInstanceNotFoundException, OperationNotFoundException, AwsServiceException, SdkClientException,
            CloudFormationException {

        HttpResponseHandler<ListStackInstanceResourceDriftsResponse> responseHandler = protocolFactory
                .createResponseHandler(ListStackInstanceResourceDriftsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listStackInstanceResourceDriftsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                listStackInstanceResourceDriftsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListStackInstanceResourceDrifts");

            return clientHandler
                    .execute(new ClientExecutionParams<ListStackInstanceResourceDriftsRequest, ListStackInstanceResourceDriftsResponse>()
                            .withOperationName("ListStackInstanceResourceDrifts").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(listStackInstanceResourceDriftsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListStackInstanceResourceDriftsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns summary information about stack instances that are associated with the specified stack set. You can
     * filter for stack instances that are associated with a specific Amazon Web Services account name or Region, or
     * that have a specific status.
     * </p>
     *
     * @param listStackInstancesRequest
     * @return Result of the ListStackInstances operation returned by the service.
     * @throws StackSetNotFoundException
     *         The specified stack set doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFormationClient.ListStackInstances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListStackInstances"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListStackInstancesResponse listStackInstances(ListStackInstancesRequest listStackInstancesRequest)
            throws StackSetNotFoundException, AwsServiceException, SdkClientException, CloudFormationException {

        HttpResponseHandler<ListStackInstancesResponse> responseHandler = protocolFactory
                .createResponseHandler(ListStackInstancesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listStackInstancesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listStackInstancesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListStackInstances");

            return clientHandler.execute(new ClientExecutionParams<ListStackInstancesRequest, ListStackInstancesResponse>()
                    .withOperationName("ListStackInstances").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(listStackInstancesRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListStackInstancesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists the stack refactor actions that will be taken after calling the <a>ExecuteStackRefactor</a> action.
     * </p>
     *
     * @param listStackRefactorActionsRequest
     * @return Result of the ListStackRefactorActions operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFormationClient.ListStackRefactorActions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListStackRefactorActions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListStackRefactorActionsResponse listStackRefactorActions(
            ListStackRefactorActionsRequest listStackRefactorActionsRequest) throws AwsServiceException, SdkClientException,
            CloudFormationException {

        HttpResponseHandler<ListStackRefactorActionsResponse> responseHandler = protocolFactory
                .createResponseHandler(ListStackRefactorActionsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listStackRefactorActionsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listStackRefactorActionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListStackRefactorActions");

            return clientHandler
                    .execute(new ClientExecutionParams<ListStackRefactorActionsRequest, ListStackRefactorActionsResponse>()
                            .withOperationName("ListStackRefactorActions").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(listStackRefactorActionsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListStackRefactorActionsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists all account stack refactor operations and their statuses.
     * </p>
     *
     * @param listStackRefactorsRequest
     * @return Result of the ListStackRefactors operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFormationClient.ListStackRefactors
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListStackRefactors"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListStackRefactorsResponse listStackRefactors(ListStackRefactorsRequest listStackRefactorsRequest)
            throws AwsServiceException, SdkClientException, CloudFormationException {

        HttpResponseHandler<ListStackRefactorsResponse> responseHandler = protocolFactory
                .createResponseHandler(ListStackRefactorsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listStackRefactorsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listStackRefactorsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListStackRefactors");

            return clientHandler.execute(new ClientExecutionParams<ListStackRefactorsRequest, ListStackRefactorsResponse>()
                    .withOperationName("ListStackRefactors").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(listStackRefactorsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListStackRefactorsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns descriptions of all resources of the specified stack.
     * </p>
     * <p>
     * For deleted stacks, ListStackResources returns resource information for up to 90 days after the stack has been
     * deleted.
     * </p>
     *
     * @param listStackResourcesRequest
     *        The input for the <a>ListStackResource</a> action.
     * @return Result of the ListStackResources operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFormationClient.ListStackResources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListStackResources"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListStackResourcesResponse listStackResources(ListStackResourcesRequest listStackResourcesRequest)
            throws AwsServiceException, SdkClientException, CloudFormationException {

        HttpResponseHandler<ListStackResourcesResponse> responseHandler = protocolFactory
                .createResponseHandler(ListStackResourcesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listStackResourcesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listStackResourcesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListStackResources");

            return clientHandler.execute(new ClientExecutionParams<ListStackResourcesRequest, ListStackResourcesResponse>()
                    .withOperationName("ListStackResources").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(listStackResourcesRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListStackResourcesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns summary information about deployment targets for a stack set.
     * </p>
     *
     * @param listStackSetAutoDeploymentTargetsRequest
     * @return Result of the ListStackSetAutoDeploymentTargets operation returned by the service.
     * @throws StackSetNotFoundException
     *         The specified stack set doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFormationClient.ListStackSetAutoDeploymentTargets
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListStackSetAutoDeploymentTargets"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListStackSetAutoDeploymentTargetsResponse listStackSetAutoDeploymentTargets(
            ListStackSetAutoDeploymentTargetsRequest listStackSetAutoDeploymentTargetsRequest) throws StackSetNotFoundException,
            AwsServiceException, SdkClientException, CloudFormationException {

        HttpResponseHandler<ListStackSetAutoDeploymentTargetsResponse> responseHandler = protocolFactory
                .createResponseHandler(ListStackSetAutoDeploymentTargetsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listStackSetAutoDeploymentTargetsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                listStackSetAutoDeploymentTargetsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListStackSetAutoDeploymentTargets");

            return clientHandler
                    .execute(new ClientExecutionParams<ListStackSetAutoDeploymentTargetsRequest, ListStackSetAutoDeploymentTargetsResponse>()
                            .withOperationName("ListStackSetAutoDeploymentTargets").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(listStackSetAutoDeploymentTargetsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListStackSetAutoDeploymentTargetsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns summary information about the results of a stack set operation.
     * </p>
     *
     * @param listStackSetOperationResultsRequest
     * @return Result of the ListStackSetOperationResults operation returned by the service.
     * @throws StackSetNotFoundException
     *         The specified stack set doesn't exist.
     * @throws OperationNotFoundException
     *         The specified ID refers to an operation that doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFormationClient.ListStackSetOperationResults
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListStackSetOperationResults"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListStackSetOperationResultsResponse listStackSetOperationResults(
            ListStackSetOperationResultsRequest listStackSetOperationResultsRequest) throws StackSetNotFoundException,
            OperationNotFoundException, AwsServiceException, SdkClientException, CloudFormationException {

        HttpResponseHandler<ListStackSetOperationResultsResponse> responseHandler = protocolFactory
                .createResponseHandler(ListStackSetOperationResultsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listStackSetOperationResultsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listStackSetOperationResultsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListStackSetOperationResults");

            return clientHandler
                    .execute(new ClientExecutionParams<ListStackSetOperationResultsRequest, ListStackSetOperationResultsResponse>()
                            .withOperationName("ListStackSetOperationResults").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(listStackSetOperationResultsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListStackSetOperationResultsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns summary information about operations performed on a stack set.
     * </p>
     *
     * @param listStackSetOperationsRequest
     * @return Result of the ListStackSetOperations operation returned by the service.
     * @throws StackSetNotFoundException
     *         The specified stack set doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFormationClient.ListStackSetOperations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListStackSetOperations"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListStackSetOperationsResponse listStackSetOperations(ListStackSetOperationsRequest listStackSetOperationsRequest)
            throws StackSetNotFoundException, AwsServiceException, SdkClientException, CloudFormationException {

        HttpResponseHandler<ListStackSetOperationsResponse> responseHandler = protocolFactory
                .createResponseHandler(ListStackSetOperationsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listStackSetOperationsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listStackSetOperationsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListStackSetOperations");

            return clientHandler
                    .execute(new ClientExecutionParams<ListStackSetOperationsRequest, ListStackSetOperationsResponse>()
                            .withOperationName("ListStackSetOperations").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(listStackSetOperationsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListStackSetOperationsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns summary information about stack sets that are associated with the user.
     * </p>
     * <ul>
     * <li>
     * <p>
     * [Self-managed permissions] If you set the <code>CallAs</code> parameter to <code>SELF</code> while signed in to
     * your Amazon Web Services account, <code>ListStackSets</code> returns all self-managed stack sets in your Amazon
     * Web Services account.
     * </p>
     * </li>
     * <li>
     * <p>
     * [Service-managed permissions] If you set the <code>CallAs</code> parameter to <code>SELF</code> while signed in
     * to the organization's management account, <code>ListStackSets</code> returns all stack sets in the management
     * account.
     * </p>
     * </li>
     * <li>
     * <p>
     * [Service-managed permissions] If you set the <code>CallAs</code> parameter to <code>DELEGATED_ADMIN</code> while
     * signed in to your member account, <code>ListStackSets</code> returns all stack sets with service-managed
     * permissions in the management account.
     * </p>
     * </li>
     * </ul>
     *
     * @param listStackSetsRequest
     * @return Result of the ListStackSets operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFormationClient.ListStackSets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListStackSets" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public ListStackSetsResponse listStackSets(ListStackSetsRequest listStackSetsRequest) throws AwsServiceException,
            SdkClientException, CloudFormationException {

        HttpResponseHandler<ListStackSetsResponse> responseHandler = protocolFactory
                .createResponseHandler(ListStackSetsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listStackSetsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listStackSetsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListStackSets");

            return clientHandler.execute(new ClientExecutionParams<ListStackSetsRequest, ListStackSetsResponse>()
                    .withOperationName("ListStackSets").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(listStackSetsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListStackSetsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns the summary information for stacks whose status matches the specified <code>StackStatusFilter</code>.
     * Summary information for stacks that have been deleted is kept for 90 days after the stack is deleted. If no
     * <code>StackStatusFilter</code> is specified, summary information for all stacks is returned (including existing
     * stacks and stacks that have been deleted).
     * </p>
     *
     * @param listStacksRequest
     *        The input for <a>ListStacks</a> action.
     * @return Result of the ListStacks operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFormationClient.ListStacks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListStacks" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListStacksResponse listStacks(ListStacksRequest listStacksRequest) throws AwsServiceException, SdkClientException,
            CloudFormationException {

        HttpResponseHandler<ListStacksResponse> responseHandler = protocolFactory
                .createResponseHandler(ListStacksResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listStacksRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listStacksRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListStacks");

            return clientHandler.execute(new ClientExecutionParams<ListStacksRequest, ListStacksResponse>()
                    .withOperationName("ListStacks").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(listStacksRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListStacksRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns a list of registration tokens for the specified extension(s).
     * </p>
     *
     * @param listTypeRegistrationsRequest
     * @return Result of the ListTypeRegistrations operation returned by the service.
     * @throws CfnRegistryException
     *         An error occurred during a CloudFormation registry operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFormationClient.ListTypeRegistrations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListTypeRegistrations"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListTypeRegistrationsResponse listTypeRegistrations(ListTypeRegistrationsRequest listTypeRegistrationsRequest)
            throws CfnRegistryException, AwsServiceException, SdkClientException, CloudFormationException {

        HttpResponseHandler<ListTypeRegistrationsResponse> responseHandler = protocolFactory
                .createResponseHandler(ListTypeRegistrationsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listTypeRegistrationsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listTypeRegistrationsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListTypeRegistrations");

            return clientHandler.execute(new ClientExecutionParams<ListTypeRegistrationsRequest, ListTypeRegistrationsResponse>()
                    .withOperationName("ListTypeRegistrations").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(listTypeRegistrationsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListTypeRegistrationsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns summary information about the versions of an extension.
     * </p>
     *
     * @param listTypeVersionsRequest
     * @return Result of the ListTypeVersions operation returned by the service.
     * @throws CfnRegistryException
     *         An error occurred during a CloudFormation registry operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFormationClient.ListTypeVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListTypeVersions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListTypeVersionsResponse listTypeVersions(ListTypeVersionsRequest listTypeVersionsRequest)
            throws CfnRegistryException, AwsServiceException, SdkClientException, CloudFormationException {

        HttpResponseHandler<ListTypeVersionsResponse> responseHandler = protocolFactory
                .createResponseHandler(ListTypeVersionsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listTypeVersionsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listTypeVersionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListTypeVersions");

            return clientHandler.execute(new ClientExecutionParams<ListTypeVersionsRequest, ListTypeVersionsResponse>()
                    .withOperationName("ListTypeVersions").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(listTypeVersionsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListTypeVersionsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns summary information about extension that have been registered with CloudFormation.
     * </p>
     *
     * @param listTypesRequest
     * @return Result of the ListTypes operation returned by the service.
     * @throws CfnRegistryException
     *         An error occurred during a CloudFormation registry operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFormationClient.ListTypes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListTypes" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListTypesResponse listTypes(ListTypesRequest listTypesRequest) throws CfnRegistryException, AwsServiceException,
            SdkClientException, CloudFormationException {

        HttpResponseHandler<ListTypesResponse> responseHandler = protocolFactory
                .createResponseHandler(ListTypesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listTypesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listTypesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListTypes");

            return clientHandler.execute(new ClientExecutionParams<ListTypesRequest, ListTypesResponse>()
                    .withOperationName("ListTypes").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(listTypesRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListTypesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Publishes the specified extension to the CloudFormation registry as a public extension in this Region. Public
     * extensions are available for use by all CloudFormation users. For more information about publishing extensions,
     * see <a href="https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/publish-extension.html">Publishing
     * extensions to make them available for public use</a> in the <i>CloudFormation Command Line Interface (CLI) User
     * Guide</i>.
     * </p>
     * <p>
     * To publish an extension, you must be registered as a publisher with CloudFormation. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_RegisterPublisher.html">
     * RegisterPublisher</a>.
     * </p>
     *
     * @param publishTypeRequest
     * @return Result of the PublishType operation returned by the service.
     * @throws CfnRegistryException
     *         An error occurred during a CloudFormation registry operation.
     * @throws TypeNotFoundException
     *         The specified extension doesn't exist in the CloudFormation registry.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFormationClient.PublishType
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/PublishType" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public PublishTypeResponse publishType(PublishTypeRequest publishTypeRequest) throws CfnRegistryException,
            TypeNotFoundException, AwsServiceException, SdkClientException, CloudFormationException {

        HttpResponseHandler<PublishTypeResponse> responseHandler = protocolFactory
                .createResponseHandler(PublishTypeResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(publishTypeRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, publishTypeRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PublishType");

            return clientHandler.execute(new ClientExecutionParams<PublishTypeRequest, PublishTypeResponse>()
                    .withOperationName("PublishType").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(publishTypeRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new PublishTypeRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Reports progress of a resource handler to CloudFormation.
     * </p>
     * <p>
     * Reserved for use by the <a
     * href="https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/what-is-cloudformation-cli.html"
     * >CloudFormation CLI</a>. Don't use this API in your code.
     * </p>
     *
     * @param recordHandlerProgressRequest
     * @return Result of the RecordHandlerProgress operation returned by the service.
     * @throws InvalidStateTransitionException
     *         Error reserved for use by the <a
     *         href="https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/what-is-cloudformation-cli.html"
     *         >CloudFormation CLI</a>. CloudFormation doesn't return this error to users.
     * @throws OperationStatusCheckFailedException
     *         Error reserved for use by the <a
     *         href="https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/what-is-cloudformation-cli.html"
     *         >CloudFormation CLI</a>. CloudFormation doesn't return this error to users.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFormationClient.RecordHandlerProgress
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/RecordHandlerProgress"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public RecordHandlerProgressResponse recordHandlerProgress(RecordHandlerProgressRequest recordHandlerProgressRequest)
            throws InvalidStateTransitionException, OperationStatusCheckFailedException, AwsServiceException, SdkClientException,
            CloudFormationException {

        HttpResponseHandler<RecordHandlerProgressResponse> responseHandler = protocolFactory
                .createResponseHandler(RecordHandlerProgressResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(recordHandlerProgressRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, recordHandlerProgressRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "RecordHandlerProgress");

            return clientHandler.execute(new ClientExecutionParams<RecordHandlerProgressRequest, RecordHandlerProgressResponse>()
                    .withOperationName("RecordHandlerProgress").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(recordHandlerProgressRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new RecordHandlerProgressRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Registers your account as a publisher of public extensions in the CloudFormation registry. Public extensions are
     * available for use by all CloudFormation users. This publisher ID applies to your account in all Amazon Web
     * Services Regions.
     * </p>
     * <p>
     * For information about requirements for registering as a public extension publisher, see <a href=
     * "https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/publish-extension.html#publish-extension-prereqs"
     * >Prerequisite: Registering your account to publish CloudFormation extensions</a> in the <i>CloudFormation Command
     * Line Interface (CLI) User Guide</i>.
     * </p>
     * <p/>
     *
     * @param registerPublisherRequest
     * @return Result of the RegisterPublisher operation returned by the service.
     * @throws CfnRegistryException
     *         An error occurred during a CloudFormation registry operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFormationClient.RegisterPublisher
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/RegisterPublisher"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public RegisterPublisherResponse registerPublisher(RegisterPublisherRequest registerPublisherRequest)
            throws CfnRegistryException, AwsServiceException, SdkClientException, CloudFormationException {

        HttpResponseHandler<RegisterPublisherResponse> responseHandler = protocolFactory
                .createResponseHandler(RegisterPublisherResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(registerPublisherRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, registerPublisherRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "RegisterPublisher");

            return clientHandler.execute(new ClientExecutionParams<RegisterPublisherRequest, RegisterPublisherResponse>()
                    .withOperationName("RegisterPublisher").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(registerPublisherRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new RegisterPublisherRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Registers an extension with the CloudFormation service. Registering an extension makes it available for use in
     * CloudFormation templates in your Amazon Web Services account, and includes:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Validating the extension schema.
     * </p>
     * </li>
     * <li>
     * <p>
     * Determining which handlers, if any, have been specified for the extension.
     * </p>
     * </li>
     * <li>
     * <p>
     * Making the extension available for use in your account.
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information about how to develop extensions and ready them for registration, see <a
     * href="https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/resource-types.html">Creating resource
     * types using the CloudFormation CLI</a> in the <i>CloudFormation Command Line Interface (CLI) User Guide</i>.
     * </p>
     * <p>
     * You can have a maximum of 50 resource extension versions registered at a time. This maximum is per account and
     * per Region. Use <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_DeregisterType.html"
     * >DeregisterType</a> to deregister specific extension versions if necessary.
     * </p>
     * <p>
     * Once you have initiated a registration request using <a>RegisterType</a>, you can use
     * <a>DescribeTypeRegistration</a> to monitor the progress of the registration request.
     * </p>
     * <p>
     * Once you have registered a private extension in your account and Region, use <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_SetTypeConfiguration.html"
     * >SetTypeConfiguration</a> to specify configuration properties for the extension. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/registry-set-configuration.html">Edit
     * configuration data for extensions in your account</a> in the <i>CloudFormation User Guide</i>.
     * </p>
     *
     * @param registerTypeRequest
     * @return Result of the RegisterType operation returned by the service.
     * @throws CfnRegistryException
     *         An error occurred during a CloudFormation registry operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFormationClient.RegisterType
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/RegisterType" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public RegisterTypeResponse registerType(RegisterTypeRequest registerTypeRequest) throws CfnRegistryException,
            AwsServiceException, SdkClientException, CloudFormationException {

        HttpResponseHandler<RegisterTypeResponse> responseHandler = protocolFactory
                .createResponseHandler(RegisterTypeResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(registerTypeRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, registerTypeRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "RegisterType");

            return clientHandler.execute(new ClientExecutionParams<RegisterTypeRequest, RegisterTypeResponse>()
                    .withOperationName("RegisterType").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(registerTypeRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new RegisterTypeRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * When specifying <code>RollbackStack</code>, you preserve the state of previously provisioned resources when an
     * operation fails. You can check the status of the stack through the <a>DescribeStacks</a> operation.
     * </p>
     * <p>
     * Rolls back the specified stack to the last known stable state from <code>CREATE_FAILED</code> or
     * <code>UPDATE_FAILED</code> stack statuses.
     * </p>
     * <p>
     * This operation will delete a stack if it doesn't contain a last known stable state. A last known stable state
     * includes any status in a <code>*_COMPLETE</code>. This includes the following stack statuses.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>CREATE_COMPLETE</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>UPDATE_COMPLETE</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>UPDATE_ROLLBACK_COMPLETE</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>IMPORT_COMPLETE</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>IMPORT_ROLLBACK_COMPLETE</code>
     * </p>
     * </li>
     * </ul>
     *
     * @param rollbackStackRequest
     * @return Result of the RollbackStack operation returned by the service.
     * @throws TokenAlreadyExistsException
     *         A client request token already exists.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFormationClient.RollbackStack
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/RollbackStack" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public RollbackStackResponse rollbackStack(RollbackStackRequest rollbackStackRequest) throws TokenAlreadyExistsException,
            AwsServiceException, SdkClientException, CloudFormationException {

        HttpResponseHandler<RollbackStackResponse> responseHandler = protocolFactory
                .createResponseHandler(RollbackStackResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(rollbackStackRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, rollbackStackRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "RollbackStack");

            return clientHandler.execute(new ClientExecutionParams<RollbackStackRequest, RollbackStackResponse>()
                    .withOperationName("RollbackStack").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(rollbackStackRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new RollbackStackRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Sets a stack policy for a specified stack.
     * </p>
     *
     * @param setStackPolicyRequest
     *        The input for the <a>SetStackPolicy</a> action.
     * @return Result of the SetStackPolicy operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFormationClient.SetStackPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/SetStackPolicy" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public SetStackPolicyResponse setStackPolicy(SetStackPolicyRequest setStackPolicyRequest) throws AwsServiceException,
            SdkClientException, CloudFormationException {

        HttpResponseHandler<SetStackPolicyResponse> responseHandler = protocolFactory
                .createResponseHandler(SetStackPolicyResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(setStackPolicyRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, setStackPolicyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "SetStackPolicy");

            return clientHandler.execute(new ClientExecutionParams<SetStackPolicyRequest, SetStackPolicyResponse>()
                    .withOperationName("SetStackPolicy").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(setStackPolicyRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new SetStackPolicyRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Specifies the configuration data for a registered CloudFormation extension, in the given account and Region.
     * </p>
     * <p>
     * To view the current configuration data for an extension, refer to the <code>ConfigurationSchema</code> element of
     * <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_DescribeType.html">DescribeType</a>.
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/registry-set-configuration.html">Edit
     * configuration data for extensions in your account</a> in the <i>CloudFormation User Guide</i>.
     * </p>
     * <important>
     * <p>
     * It's strongly recommended that you use dynamic references to restrict sensitive configuration definitions, such
     * as third-party credentials. For more details on dynamic references, see <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/dynamic-references.html">Specify values
     * stored in other services using dynamic references</a> in the <i>CloudFormation User Guide</i>.
     * </p>
     * </important>
     *
     * @param setTypeConfigurationRequest
     * @return Result of the SetTypeConfiguration operation returned by the service.
     * @throws CfnRegistryException
     *         An error occurred during a CloudFormation registry operation.
     * @throws TypeNotFoundException
     *         The specified extension doesn't exist in the CloudFormation registry.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFormationClient.SetTypeConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/SetTypeConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public SetTypeConfigurationResponse setTypeConfiguration(SetTypeConfigurationRequest setTypeConfigurationRequest)
            throws CfnRegistryException, TypeNotFoundException, AwsServiceException, SdkClientException, CloudFormationException {

        HttpResponseHandler<SetTypeConfigurationResponse> responseHandler = protocolFactory
                .createResponseHandler(SetTypeConfigurationResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(setTypeConfigurationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, setTypeConfigurationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "SetTypeConfiguration");

            return clientHandler.execute(new ClientExecutionParams<SetTypeConfigurationRequest, SetTypeConfigurationResponse>()
                    .withOperationName("SetTypeConfiguration").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(setTypeConfigurationRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new SetTypeConfigurationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Specify the default version of an extension. The default version of an extension will be used in CloudFormation
     * operations.
     * </p>
     *
     * @param setTypeDefaultVersionRequest
     * @return Result of the SetTypeDefaultVersion operation returned by the service.
     * @throws CfnRegistryException
     *         An error occurred during a CloudFormation registry operation.
     * @throws TypeNotFoundException
     *         The specified extension doesn't exist in the CloudFormation registry.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFormationClient.SetTypeDefaultVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/SetTypeDefaultVersion"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public SetTypeDefaultVersionResponse setTypeDefaultVersion(SetTypeDefaultVersionRequest setTypeDefaultVersionRequest)
            throws CfnRegistryException, TypeNotFoundException, AwsServiceException, SdkClientException, CloudFormationException {

        HttpResponseHandler<SetTypeDefaultVersionResponse> responseHandler = protocolFactory
                .createResponseHandler(SetTypeDefaultVersionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(setTypeDefaultVersionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, setTypeDefaultVersionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "SetTypeDefaultVersion");

            return clientHandler.execute(new ClientExecutionParams<SetTypeDefaultVersionRequest, SetTypeDefaultVersionResponse>()
                    .withOperationName("SetTypeDefaultVersion").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(setTypeDefaultVersionRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new SetTypeDefaultVersionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Sends a signal to the specified resource with a success or failure status. You can use the
     * <code>SignalResource</code> operation in conjunction with a creation policy or update policy. CloudFormation
     * doesn't proceed with a stack creation or update until resources receive the required number of signals or the
     * timeout period is exceeded. The <code>SignalResource</code> operation is useful in cases where you want to send
     * signals from anywhere other than an Amazon EC2 instance.
     * </p>
     *
     * @param signalResourceRequest
     *        The input for the <a>SignalResource</a> action.
     * @return Result of the SignalResource operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFormationClient.SignalResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/SignalResource" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public SignalResourceResponse signalResource(SignalResourceRequest signalResourceRequest) throws AwsServiceException,
            SdkClientException, CloudFormationException {

        HttpResponseHandler<SignalResourceResponse> responseHandler = protocolFactory
                .createResponseHandler(SignalResourceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(signalResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, signalResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "SignalResource");

            return clientHandler.execute(new ClientExecutionParams<SignalResourceRequest, SignalResourceResponse>()
                    .withOperationName("SignalResource").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(signalResourceRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new SignalResourceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Starts a scan of the resources in this account in this Region. You can the status of a scan using the
     * <code>ListResourceScans</code> API action.
     * </p>
     *
     * @param startResourceScanRequest
     * @return Result of the StartResourceScan operation returned by the service.
     * @throws ResourceScanInProgressException
     *         A resource scan is currently in progress. Only one can be run at a time for an account in a Region.
     * @throws ResourceScanLimitExceededException
     *         The limit on resource scans has been exceeded. Reasons include:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Exceeded the daily quota for resource scans.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         A resource scan recently failed. You must wait 10 minutes before starting a new resource scan.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The last resource scan failed after exceeding 100,000 resources. When this happens, you must wait 24
     *         hours before starting a new resource scan.
     *         </p>
     *         </li>
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFormationClient.StartResourceScan
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/StartResourceScan"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public StartResourceScanResponse startResourceScan(StartResourceScanRequest startResourceScanRequest)
            throws ResourceScanInProgressException, ResourceScanLimitExceededException, AwsServiceException, SdkClientException,
            CloudFormationException {

        HttpResponseHandler<StartResourceScanResponse> responseHandler = protocolFactory
                .createResponseHandler(StartResourceScanResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(startResourceScanRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, startResourceScanRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StartResourceScan");

            return clientHandler.execute(new ClientExecutionParams<StartResourceScanRequest, StartResourceScanResponse>()
                    .withOperationName("StartResourceScan").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(startResourceScanRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new StartResourceScanRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Stops an in-progress operation on a stack set and its associated stack instances. StackSets will cancel all the
     * unstarted stack instance deployments and wait for those are in-progress to complete.
     * </p>
     *
     * @param stopStackSetOperationRequest
     * @return Result of the StopStackSetOperation operation returned by the service.
     * @throws StackSetNotFoundException
     *         The specified stack set doesn't exist.
     * @throws OperationNotFoundException
     *         The specified ID refers to an operation that doesn't exist.
     * @throws InvalidOperationException
     *         The specified operation isn't valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFormationClient.StopStackSetOperation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/StopStackSetOperation"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public StopStackSetOperationResponse stopStackSetOperation(StopStackSetOperationRequest stopStackSetOperationRequest)
            throws StackSetNotFoundException, OperationNotFoundException, InvalidOperationException, AwsServiceException,
            SdkClientException, CloudFormationException {

        HttpResponseHandler<StopStackSetOperationResponse> responseHandler = protocolFactory
                .createResponseHandler(StopStackSetOperationResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(stopStackSetOperationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, stopStackSetOperationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StopStackSetOperation");

            return clientHandler.execute(new ClientExecutionParams<StopStackSetOperationRequest, StopStackSetOperationResponse>()
                    .withOperationName("StopStackSetOperation").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(stopStackSetOperationRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new StopStackSetOperationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Tests a registered extension to make sure it meets all necessary requirements for being published in the
     * CloudFormation registry.
     * </p>
     * <ul>
     * <li>
     * <p>
     * For resource types, this includes passing all contracts tests defined for the type.
     * </p>
     * </li>
     * <li>
     * <p>
     * For modules, this includes determining if the module's model meets all necessary requirements.
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information, see <a href=
     * "https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/publish-extension.html#publish-extension-testing"
     * >Testing your public extension before publishing</a> in the <i>CloudFormation Command Line Interface (CLI) User
     * Guide</i>.
     * </p>
     * <p>
     * If you don't specify a version, CloudFormation uses the default version of the extension in your account and
     * Region for testing.
     * </p>
     * <p>
     * To perform testing, CloudFormation assumes the execution role specified when the type was registered. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_RegisterType.html">RegisterType</a>.
     * </p>
     * <p>
     * Once you've initiated testing on an extension using <code>TestType</code>, you can pass the returned
     * <code>TypeVersionArn</code> into <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_DescribeType.html">DescribeType</a>
     * to monitor the current test status and test status description for the extension.
     * </p>
     * <p>
     * An extension must have a test status of <code>PASSED</code> before it can be published. For more information, see
     * <a href="https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/resource-type-publish.html">Publishing
     * extensions to make them available for public use</a> in the <i>CloudFormation Command Line Interface (CLI) User
     * Guide</i>.
     * </p>
     *
     * @param testTypeRequest
     * @return Result of the TestType operation returned by the service.
     * @throws CfnRegistryException
     *         An error occurred during a CloudFormation registry operation.
     * @throws TypeNotFoundException
     *         The specified extension doesn't exist in the CloudFormation registry.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFormationClient.TestType
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/TestType" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public TestTypeResponse testType(TestTypeRequest testTypeRequest) throws CfnRegistryException, TypeNotFoundException,
            AwsServiceException, SdkClientException, CloudFormationException {

        HttpResponseHandler<TestTypeResponse> responseHandler = protocolFactory.createResponseHandler(TestTypeResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(testTypeRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, testTypeRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "TestType");

            return clientHandler.execute(new ClientExecutionParams<TestTypeRequest, TestTypeResponse>()
                    .withOperationName("TestType").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(testTypeRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new TestTypeRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates a generated template. This can be used to change the name, add and remove resources, refresh resources,
     * and change the <code>DeletionPolicy</code> and <code>UpdateReplacePolicy</code> settings. You can check the
     * status of the update to the generated template using the <code>DescribeGeneratedTemplate</code> API action.
     * </p>
     *
     * @param updateGeneratedTemplateRequest
     * @return Result of the UpdateGeneratedTemplate operation returned by the service.
     * @throws AlreadyExistsException
     *         The resource with the name requested already exists.
     * @throws GeneratedTemplateNotFoundException
     *         The generated template was not found.
     * @throws LimitExceededException
     *         The quota for the resource has already been reached.</p>
     *         <p>
     *         For information about resource and stack limitations, see <a
     *         href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/cloudformation-limits.html"
     *         >CloudFormation quotas</a> in the <i>CloudFormation User Guide</i>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFormationClient.UpdateGeneratedTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/UpdateGeneratedTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UpdateGeneratedTemplateResponse updateGeneratedTemplate(UpdateGeneratedTemplateRequest updateGeneratedTemplateRequest)
            throws AlreadyExistsException, GeneratedTemplateNotFoundException, LimitExceededException, AwsServiceException,
            SdkClientException, CloudFormationException {

        HttpResponseHandler<UpdateGeneratedTemplateResponse> responseHandler = protocolFactory
                .createResponseHandler(UpdateGeneratedTemplateResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateGeneratedTemplateRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateGeneratedTemplateRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateGeneratedTemplate");

            return clientHandler
                    .execute(new ClientExecutionParams<UpdateGeneratedTemplateRequest, UpdateGeneratedTemplateResponse>()
                            .withOperationName("UpdateGeneratedTemplate").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(updateGeneratedTemplateRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new UpdateGeneratedTemplateRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates a stack as specified in the template. After the call completes successfully, the stack update starts. You
     * can check the status of the stack through the <a>DescribeStacks</a> action.
     * </p>
     * <p>
     * To get a copy of the template for an existing stack, you can use the <a>GetTemplate</a> action.
     * </p>
     * <p>
     * For more information about updating a stack and monitoring the progress of the update, see <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacks.html">Managing Amazon Web Services
     * resources as a single unit with CloudFormation stacks</a> in the <i>CloudFormation User Guide</i>.
     * </p>
     *
     * @param updateStackRequest
     *        The input for an <a>UpdateStack</a> action.
     * @return Result of the UpdateStack operation returned by the service.
     * @throws InsufficientCapabilitiesException
     *         The template contains resources with capabilities that weren't specified in the Capabilities parameter.
     * @throws TokenAlreadyExistsException
     *         A client request token already exists.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFormationClient.UpdateStack
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/UpdateStack" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public UpdateStackResponse updateStack(UpdateStackRequest updateStackRequest) throws InsufficientCapabilitiesException,
            TokenAlreadyExistsException, AwsServiceException, SdkClientException, CloudFormationException {

        HttpResponseHandler<UpdateStackResponse> responseHandler = protocolFactory
                .createResponseHandler(UpdateStackResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateStackRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateStackRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateStack");

            return clientHandler.execute(new ClientExecutionParams<UpdateStackRequest, UpdateStackResponse>()
                    .withOperationName("UpdateStack").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(updateStackRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateStackRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates the parameter values for stack instances for the specified accounts, within the specified Amazon Web
     * Services Regions. A stack instance refers to a stack in a specific account and Region.
     * </p>
     * <p>
     * You can only update stack instances in Amazon Web Services Regions and accounts where they already exist; to
     * create additional stack instances, use <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_CreateStackInstances.html"
     * >CreateStackInstances</a>.
     * </p>
     * <p>
     * During stack set updates, any parameters overridden for a stack instance aren't updated, but retain their
     * overridden value.
     * </p>
     * <p>
     * You can only update the parameter <i>values</i> that are specified in the stack set; to add or delete a parameter
     * itself, use <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_UpdateStackSet.html">UpdateStackSet
     * </a> to update the stack set template. If you add a parameter to a template, before you can override the
     * parameter value specified in the stack set you must first use <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_UpdateStackSet.html"
     * >UpdateStackSet</a> to update all stack instances with the updated template and parameter value specified in the
     * stack set. Once a stack instance has been updated with the new parameter, you can then override the parameter
     * value using <code>UpdateStackInstances</code>.
     * </p>
     *
     * @param updateStackInstancesRequest
     * @return Result of the UpdateStackInstances operation returned by the service.
     * @throws StackSetNotFoundException
     *         The specified stack set doesn't exist.
     * @throws StackInstanceNotFoundException
     *         The specified stack instance doesn't exist.
     * @throws OperationInProgressException
     *         Another operation is currently in progress for this stack set. Only one operation can be performed for a
     *         stack set at a given time.
     * @throws OperationIdAlreadyExistsException
     *         The specified operation ID already exists.
     * @throws StaleRequestException
     *         Another operation has been performed on this stack set since the specified operation was performed.
     * @throws InvalidOperationException
     *         The specified operation isn't valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFormationClient.UpdateStackInstances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/UpdateStackInstances"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UpdateStackInstancesResponse updateStackInstances(UpdateStackInstancesRequest updateStackInstancesRequest)
            throws StackSetNotFoundException, StackInstanceNotFoundException, OperationInProgressException,
            OperationIdAlreadyExistsException, StaleRequestException, InvalidOperationException, AwsServiceException,
            SdkClientException, CloudFormationException {

        HttpResponseHandler<UpdateStackInstancesResponse> responseHandler = protocolFactory
                .createResponseHandler(UpdateStackInstancesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateStackInstancesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateStackInstancesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateStackInstances");

            return clientHandler.execute(new ClientExecutionParams<UpdateStackInstancesRequest, UpdateStackInstancesResponse>()
                    .withOperationName("UpdateStackInstances").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(updateStackInstancesRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateStackInstancesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates the stack set and associated stack instances in the specified accounts and Amazon Web Services Regions.
     * </p>
     * <p>
     * Even if the stack set operation created by updating the stack set fails (completely or partially, below or above
     * a specified failure tolerance), the stack set is updated with your changes. Subsequent
     * <a>CreateStackInstances</a> calls on the specified stack set use the updated stack set.
     * </p>
     *
     * @param updateStackSetRequest
     * @return Result of the UpdateStackSet operation returned by the service.
     * @throws StackSetNotFoundException
     *         The specified stack set doesn't exist.
     * @throws OperationInProgressException
     *         Another operation is currently in progress for this stack set. Only one operation can be performed for a
     *         stack set at a given time.
     * @throws OperationIdAlreadyExistsException
     *         The specified operation ID already exists.
     * @throws StaleRequestException
     *         Another operation has been performed on this stack set since the specified operation was performed.
     * @throws InvalidOperationException
     *         The specified operation isn't valid.
     * @throws StackInstanceNotFoundException
     *         The specified stack instance doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFormationClient.UpdateStackSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/UpdateStackSet" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public UpdateStackSetResponse updateStackSet(UpdateStackSetRequest updateStackSetRequest) throws StackSetNotFoundException,
            OperationInProgressException, OperationIdAlreadyExistsException, StaleRequestException, InvalidOperationException,
            StackInstanceNotFoundException, AwsServiceException, SdkClientException, CloudFormationException {

        HttpResponseHandler<UpdateStackSetResponse> responseHandler = protocolFactory
                .createResponseHandler(UpdateStackSetResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateStackSetRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateStackSetRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateStackSet");

            return clientHandler.execute(new ClientExecutionParams<UpdateStackSetRequest, UpdateStackSetResponse>()
                    .withOperationName("UpdateStackSet").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(updateStackSetRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateStackSetRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates termination protection for the specified stack. If a user attempts to delete a stack with termination
     * protection enabled, the operation fails and the stack remains unchanged. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-protect-stacks.html">Protect a
     * CloudFormation stack from being deleted</a> in the <i>CloudFormation User Guide</i>.
     * </p>
     * <p>
     * For <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-nested-stacks.html">nested
     * stacks</a>, termination protection is set on the root stack and can't be changed directly on the nested stack.
     * </p>
     *
     * @param updateTerminationProtectionRequest
     * @return Result of the UpdateTerminationProtection operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFormationClient.UpdateTerminationProtection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/UpdateTerminationProtection"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UpdateTerminationProtectionResponse updateTerminationProtection(
            UpdateTerminationProtectionRequest updateTerminationProtectionRequest) throws AwsServiceException,
            SdkClientException, CloudFormationException {

        HttpResponseHandler<UpdateTerminationProtectionResponse> responseHandler = protocolFactory
                .createResponseHandler(UpdateTerminationProtectionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateTerminationProtectionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateTerminationProtectionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateTerminationProtection");

            return clientHandler
                    .execute(new ClientExecutionParams<UpdateTerminationProtectionRequest, UpdateTerminationProtectionResponse>()
                            .withOperationName("UpdateTerminationProtection").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(updateTerminationProtectionRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new UpdateTerminationProtectionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Validates a specified template. CloudFormation first checks if the template is valid JSON. If it isn't,
     * CloudFormation checks if the template is valid YAML. If both these checks fail, CloudFormation returns a template
     * validation error.
     * </p>
     *
     * @param validateTemplateRequest
     *        The input for <a>ValidateTemplate</a> action.
     * @return Result of the ValidateTemplate operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFormationClient.ValidateTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ValidateTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ValidateTemplateResponse validateTemplate(ValidateTemplateRequest validateTemplateRequest) throws AwsServiceException,
            SdkClientException, CloudFormationException {

        HttpResponseHandler<ValidateTemplateResponse> responseHandler = protocolFactory
                .createResponseHandler(ValidateTemplateResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(validateTemplateRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, validateTemplateRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ValidateTemplate");

            return clientHandler.execute(new ClientExecutionParams<ValidateTemplateRequest, ValidateTemplateResponse>()
                    .withOperationName("ValidateTemplate").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(validateTemplateRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ValidateTemplateRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * Create an instance of {@link CloudFormationWaiter} using this client.
     * <p>
     * Waiters created via this method are managed by the SDK and resources will be released when the service client is
     * closed.
     *
     * @return an instance of {@link CloudFormationWaiter}
     */
    @Override
    public CloudFormationWaiter waiter() {
        return CloudFormationWaiter.builder().client(this).build();
    }

    @Override
    public final String serviceName() {
        return SERVICE_NAME;
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration,
            RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = clientConfiguration.option(SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private void updateRetryStrategyClientConfiguration(SdkClientConfiguration.Builder configuration) {
        ClientOverrideConfiguration.Builder builder = configuration.asOverrideConfigurationBuilder();
        RetryMode retryMode = builder.retryMode();
        if (retryMode != null) {
            configuration.option(SdkClientOption.RETRY_STRATEGY, AwsRetryStrategy.forRetryMode(retryMode));
        } else {
            Consumer<RetryStrategy.Builder<?, ?>> configurator = builder.retryStrategyConfigurator();
            if (configurator != null) {
                RetryStrategy.Builder<?, ?> defaultBuilder = AwsRetryStrategy.defaultRetryStrategy().toBuilder();
                configurator.accept(defaultBuilder);
                configuration.option(SdkClientOption.RETRY_STRATEGY, defaultBuilder.build());
            } else {
                RetryStrategy retryStrategy = builder.retryStrategy();
                if (retryStrategy != null) {
                    configuration.option(SdkClientOption.RETRY_STRATEGY, retryStrategy);
                }
            }
        }
        configuration.option(SdkClientOption.CONFIGURED_RETRY_MODE, null);
        configuration.option(SdkClientOption.CONFIGURED_RETRY_STRATEGY, null);
        configuration.option(SdkClientOption.CONFIGURED_RETRY_CONFIGURATOR, null);
    }

    private SdkClientConfiguration updateSdkClientConfiguration(SdkRequest request, SdkClientConfiguration clientConfiguration) {
        List<SdkPlugin> plugins = request.overrideConfiguration().map(c -> c.plugins()).orElse(Collections.emptyList());
        SdkClientConfiguration.Builder configuration = clientConfiguration.toBuilder();
        if (plugins.isEmpty()) {
            return configuration.build();
        }
        CloudFormationServiceClientConfigurationBuilder serviceConfigBuilder = new CloudFormationServiceClientConfigurationBuilder(
                configuration);
        for (SdkPlugin plugin : plugins) {
            plugin.configureClient(serviceConfigBuilder);
        }
        updateRetryStrategyClientConfiguration(configuration);
        return configuration.build();
    }

    private AwsQueryProtocolFactory init() {
        return AwsQueryProtocolFactory
                .builder()
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidOperationException")
                                .exceptionBuilderSupplier(InvalidOperationException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TypeConfigurationNotFoundException")
                                .exceptionBuilderSupplier(TypeConfigurationNotFoundException::builder).httpStatusCode(404)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("GeneratedTemplateNotFound")
                                .exceptionBuilderSupplier(GeneratedTemplateNotFoundException::builder).httpStatusCode(404)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TokenAlreadyExistsException")
                                .exceptionBuilderSupplier(TokenAlreadyExistsException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("CFNRegistryException")
                                .exceptionBuilderSupplier(CfnRegistryException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ConditionalCheckFailed")
                                .exceptionBuilderSupplier(OperationStatusCheckFailedException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("NameAlreadyExistsException")
                                .exceptionBuilderSupplier(NameAlreadyExistsException::builder).httpStatusCode(409).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("LimitExceededException")
                                .exceptionBuilderSupplier(LimitExceededException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("OperationNotFoundException")
                                .exceptionBuilderSupplier(OperationNotFoundException::builder).httpStatusCode(404).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("StackSetNotFoundException")
                                .exceptionBuilderSupplier(StackSetNotFoundException::builder).httpStatusCode(404).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ResourceScanNotFound")
                                .exceptionBuilderSupplier(ResourceScanNotFoundException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InsufficientCapabilitiesException")
                                .exceptionBuilderSupplier(InsufficientCapabilitiesException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ConcurrentResourcesLimitExceeded")
                                .exceptionBuilderSupplier(ConcurrentResourcesLimitExceededException::builder).httpStatusCode(429)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("AlreadyExistsException")
                                .exceptionBuilderSupplier(AlreadyExistsException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("OperationInProgressException")
                                .exceptionBuilderSupplier(OperationInProgressException::builder).httpStatusCode(409).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("StaleRequestException")
                                .exceptionBuilderSupplier(StaleRequestException::builder).httpStatusCode(409).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("HookResultNotFound")
                                .exceptionBuilderSupplier(HookResultNotFoundException::builder).httpStatusCode(404).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ResourceScanInProgress")
                                .exceptionBuilderSupplier(ResourceScanInProgressException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidChangeSetStatus")
                                .exceptionBuilderSupplier(InvalidChangeSetStatusException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("StackSetNotEmptyException")
                                .exceptionBuilderSupplier(StackSetNotEmptyException::builder).httpStatusCode(409).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ChangeSetNotFound")
                                .exceptionBuilderSupplier(ChangeSetNotFoundException::builder).httpStatusCode(404).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("StackInstanceNotFoundException")
                                .exceptionBuilderSupplier(StackInstanceNotFoundException::builder).httpStatusCode(404).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ResourceScanLimitExceeded")
                                .exceptionBuilderSupplier(ResourceScanLimitExceededException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("StackNotFoundException")
                                .exceptionBuilderSupplier(StackNotFoundException::builder).httpStatusCode(404).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("StackRefactorNotFoundException")
                                .exceptionBuilderSupplier(StackRefactorNotFoundException::builder).httpStatusCode(404).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidStateTransition")
                                .exceptionBuilderSupplier(InvalidStateTransitionException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("OperationIdAlreadyExistsException")
                                .exceptionBuilderSupplier(OperationIdAlreadyExistsException::builder).httpStatusCode(409).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TypeNotFoundException")
                                .exceptionBuilderSupplier(TypeNotFoundException::builder).httpStatusCode(404).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("CreatedButModifiedException")
                                .exceptionBuilderSupplier(CreatedButModifiedException::builder).httpStatusCode(409).build())
                .clientConfiguration(clientConfiguration).defaultServiceExceptionSupplier(CloudFormationException::builder)
                .build();
    }

    @Override
    public final CloudFormationServiceClientConfiguration serviceClientConfiguration() {
        return new CloudFormationServiceClientConfigurationBuilder(this.clientConfiguration.toBuilder()).build();
    }

    @Override
    public void close() {
        clientHandler.close();
    }
}
