/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudformation.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The input for <a>DeleteStack</a> action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteStackRequest extends CloudFormationRequest implements
        ToCopyableBuilder<DeleteStackRequest.Builder, DeleteStackRequest> {
    private static final SdkField<String> STACK_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StackName").getter(getter(DeleteStackRequest::stackName)).setter(setter(Builder::stackName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StackName").build()).build();

    private static final SdkField<List<String>> RETAIN_RESOURCES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("RetainResources")
            .getter(getter(DeleteStackRequest::retainResources))
            .setter(setter(Builder::retainResources))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RetainResources").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RoleARN").getter(getter(DeleteStackRequest::roleARN)).setter(setter(Builder::roleARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleARN").build()).build();

    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ClientRequestToken").getter(getter(DeleteStackRequest::clientRequestToken))
            .setter(setter(Builder::clientRequestToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientRequestToken").build())
            .build();

    private static final SdkField<String> DELETION_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DeletionMode").getter(getter(DeleteStackRequest::deletionModeAsString))
            .setter(setter(Builder::deletionMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeletionMode").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STACK_NAME_FIELD,
            RETAIN_RESOURCES_FIELD, ROLE_ARN_FIELD, CLIENT_REQUEST_TOKEN_FIELD, DELETION_MODE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String stackName;

    private final List<String> retainResources;

    private final String roleARN;

    private final String clientRequestToken;

    private final String deletionMode;

    private DeleteStackRequest(BuilderImpl builder) {
        super(builder);
        this.stackName = builder.stackName;
        this.retainResources = builder.retainResources;
        this.roleARN = builder.roleARN;
        this.clientRequestToken = builder.clientRequestToken;
        this.deletionMode = builder.deletionMode;
    }

    /**
     * <p>
     * The name or the unique stack ID that's associated with the stack.
     * </p>
     * 
     * @return The name or the unique stack ID that's associated with the stack.
     */
    public final String stackName() {
        return stackName;
    }

    /**
     * For responses, this returns true if the service returned a value for the RetainResources property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasRetainResources() {
        return retainResources != null && !(retainResources instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * For stacks in the <code>DELETE_FAILED</code> state, a list of resource logical IDs that are associated with the
     * resources you want to retain. During deletion, CloudFormation deletes the stack but doesn't delete the retained
     * resources.
     * </p>
     * <p>
     * Retaining resources is useful when you can't delete a resource, such as a non-empty S3 bucket, but you want to
     * delete the stack.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRetainResources} method.
     * </p>
     * 
     * @return For stacks in the <code>DELETE_FAILED</code> state, a list of resource logical IDs that are associated
     *         with the resources you want to retain. During deletion, CloudFormation deletes the stack but doesn't
     *         delete the retained resources.</p>
     *         <p>
     *         Retaining resources is useful when you can't delete a resource, such as a non-empty S3 bucket, but you
     *         want to delete the stack.
     */
    public final List<String> retainResources() {
        return retainResources;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of an IAM role that CloudFormation assumes to delete the stack. CloudFormation
     * uses the role's credentials to make calls on your behalf.
     * </p>
     * <p>
     * If you don't specify a value, CloudFormation uses the role that was previously associated with the stack. If no
     * role is available, CloudFormation uses a temporary session that's generated from your user credentials.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of an IAM role that CloudFormation assumes to delete the stack.
     *         CloudFormation uses the role's credentials to make calls on your behalf.</p>
     *         <p>
     *         If you don't specify a value, CloudFormation uses the role that was previously associated with the stack.
     *         If no role is available, CloudFormation uses a temporary session that's generated from your user
     *         credentials.
     */
    public final String roleARN() {
        return roleARN;
    }

    /**
     * <p>
     * A unique identifier for this <code>DeleteStack</code> request. Specify this token if you plan to retry requests
     * so that CloudFormation knows that you're not attempting to delete a stack with the same name. You might retry
     * <code>DeleteStack</code> requests to ensure that CloudFormation successfully received them.
     * </p>
     * <p>
     * All events initiated by a given stack operation are assigned the same client request token, which you can use to
     * track operations. For example, if you execute a <code>CreateStack</code> operation with the token
     * <code>token1</code>, then all the <code>StackEvents</code> generated by that operation will have
     * <code>ClientRequestToken</code> set as <code>token1</code>.
     * </p>
     * <p>
     * In the console, stack operations display the client request token on the Events tab. Stack operations that are
     * initiated from the console use the token format <i>Console-StackOperation-ID</i>, which helps you easily identify
     * the stack operation . For example, if you create a stack using the console, each stack event would be assigned
     * the same token in the following format: <code>Console-CreateStack-7f59c3cf-00d2-40c7-b2ff-e75db0987002</code>.
     * </p>
     * 
     * @return A unique identifier for this <code>DeleteStack</code> request. Specify this token if you plan to retry
     *         requests so that CloudFormation knows that you're not attempting to delete a stack with the same name.
     *         You might retry <code>DeleteStack</code> requests to ensure that CloudFormation successfully received
     *         them.</p>
     *         <p>
     *         All events initiated by a given stack operation are assigned the same client request token, which you can
     *         use to track operations. For example, if you execute a <code>CreateStack</code> operation with the token
     *         <code>token1</code>, then all the <code>StackEvents</code> generated by that operation will have
     *         <code>ClientRequestToken</code> set as <code>token1</code>.
     *         </p>
     *         <p>
     *         In the console, stack operations display the client request token on the Events tab. Stack operations
     *         that are initiated from the console use the token format <i>Console-StackOperation-ID</i>, which helps
     *         you easily identify the stack operation . For example, if you create a stack using the console, each
     *         stack event would be assigned the same token in the following format:
     *         <code>Console-CreateStack-7f59c3cf-00d2-40c7-b2ff-e75db0987002</code>.
     */
    public final String clientRequestToken() {
        return clientRequestToken;
    }

    /**
     * <p>
     * Specifies the deletion mode for the stack. Possible values are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>STANDARD</code> - Use the standard behavior. Specifying this value is the same as not specifying this
     * parameter.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>FORCE_DELETE_STACK</code> - Delete the stack if it's stuck in a <code>DELETE_FAILED</code> state due to
     * resource deletion failure.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #deletionMode} will
     * return {@link DeletionMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #deletionModeAsString}.
     * </p>
     * 
     * @return Specifies the deletion mode for the stack. Possible values are:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>STANDARD</code> - Use the standard behavior. Specifying this value is the same as not specifying
     *         this parameter.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>FORCE_DELETE_STACK</code> - Delete the stack if it's stuck in a <code>DELETE_FAILED</code> state
     *         due to resource deletion failure.
     *         </p>
     *         </li>
     * @see DeletionMode
     */
    public final DeletionMode deletionMode() {
        return DeletionMode.fromValue(deletionMode);
    }

    /**
     * <p>
     * Specifies the deletion mode for the stack. Possible values are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>STANDARD</code> - Use the standard behavior. Specifying this value is the same as not specifying this
     * parameter.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>FORCE_DELETE_STACK</code> - Delete the stack if it's stuck in a <code>DELETE_FAILED</code> state due to
     * resource deletion failure.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #deletionMode} will
     * return {@link DeletionMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #deletionModeAsString}.
     * </p>
     * 
     * @return Specifies the deletion mode for the stack. Possible values are:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>STANDARD</code> - Use the standard behavior. Specifying this value is the same as not specifying
     *         this parameter.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>FORCE_DELETE_STACK</code> - Delete the stack if it's stuck in a <code>DELETE_FAILED</code> state
     *         due to resource deletion failure.
     *         </p>
     *         </li>
     * @see DeletionMode
     */
    public final String deletionModeAsString() {
        return deletionMode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(stackName());
        hashCode = 31 * hashCode + Objects.hashCode(hasRetainResources() ? retainResources() : null);
        hashCode = 31 * hashCode + Objects.hashCode(roleARN());
        hashCode = 31 * hashCode + Objects.hashCode(clientRequestToken());
        hashCode = 31 * hashCode + Objects.hashCode(deletionModeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteStackRequest)) {
            return false;
        }
        DeleteStackRequest other = (DeleteStackRequest) obj;
        return Objects.equals(stackName(), other.stackName()) && hasRetainResources() == other.hasRetainResources()
                && Objects.equals(retainResources(), other.retainResources()) && Objects.equals(roleARN(), other.roleARN())
                && Objects.equals(clientRequestToken(), other.clientRequestToken())
                && Objects.equals(deletionModeAsString(), other.deletionModeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteStackRequest").add("StackName", stackName())
                .add("RetainResources", hasRetainResources() ? retainResources() : null).add("RoleARN", roleARN())
                .add("ClientRequestToken", clientRequestToken()).add("DeletionMode", deletionModeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StackName":
            return Optional.ofNullable(clazz.cast(stackName()));
        case "RetainResources":
            return Optional.ofNullable(clazz.cast(retainResources()));
        case "RoleARN":
            return Optional.ofNullable(clazz.cast(roleARN()));
        case "ClientRequestToken":
            return Optional.ofNullable(clazz.cast(clientRequestToken()));
        case "DeletionMode":
            return Optional.ofNullable(clazz.cast(deletionModeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("StackName", STACK_NAME_FIELD);
        map.put("RetainResources", RETAIN_RESOURCES_FIELD);
        map.put("RoleARN", ROLE_ARN_FIELD);
        map.put("ClientRequestToken", CLIENT_REQUEST_TOKEN_FIELD);
        map.put("DeletionMode", DELETION_MODE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeleteStackRequest, T> g) {
        return obj -> g.apply((DeleteStackRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudFormationRequest.Builder, SdkPojo, CopyableBuilder<Builder, DeleteStackRequest> {
        /**
         * <p>
         * The name or the unique stack ID that's associated with the stack.
         * </p>
         * 
         * @param stackName
         *        The name or the unique stack ID that's associated with the stack.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stackName(String stackName);

        /**
         * <p>
         * For stacks in the <code>DELETE_FAILED</code> state, a list of resource logical IDs that are associated with
         * the resources you want to retain. During deletion, CloudFormation deletes the stack but doesn't delete the
         * retained resources.
         * </p>
         * <p>
         * Retaining resources is useful when you can't delete a resource, such as a non-empty S3 bucket, but you want
         * to delete the stack.
         * </p>
         * 
         * @param retainResources
         *        For stacks in the <code>DELETE_FAILED</code> state, a list of resource logical IDs that are associated
         *        with the resources you want to retain. During deletion, CloudFormation deletes the stack but doesn't
         *        delete the retained resources.</p>
         *        <p>
         *        Retaining resources is useful when you can't delete a resource, such as a non-empty S3 bucket, but you
         *        want to delete the stack.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder retainResources(Collection<String> retainResources);

        /**
         * <p>
         * For stacks in the <code>DELETE_FAILED</code> state, a list of resource logical IDs that are associated with
         * the resources you want to retain. During deletion, CloudFormation deletes the stack but doesn't delete the
         * retained resources.
         * </p>
         * <p>
         * Retaining resources is useful when you can't delete a resource, such as a non-empty S3 bucket, but you want
         * to delete the stack.
         * </p>
         * 
         * @param retainResources
         *        For stacks in the <code>DELETE_FAILED</code> state, a list of resource logical IDs that are associated
         *        with the resources you want to retain. During deletion, CloudFormation deletes the stack but doesn't
         *        delete the retained resources.</p>
         *        <p>
         *        Retaining resources is useful when you can't delete a resource, such as a non-empty S3 bucket, but you
         *        want to delete the stack.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder retainResources(String... retainResources);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of an IAM role that CloudFormation assumes to delete the stack. CloudFormation
         * uses the role's credentials to make calls on your behalf.
         * </p>
         * <p>
         * If you don't specify a value, CloudFormation uses the role that was previously associated with the stack. If
         * no role is available, CloudFormation uses a temporary session that's generated from your user credentials.
         * </p>
         * 
         * @param roleARN
         *        The Amazon Resource Name (ARN) of an IAM role that CloudFormation assumes to delete the stack.
         *        CloudFormation uses the role's credentials to make calls on your behalf.</p>
         *        <p>
         *        If you don't specify a value, CloudFormation uses the role that was previously associated with the
         *        stack. If no role is available, CloudFormation uses a temporary session that's generated from your
         *        user credentials.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleARN(String roleARN);

        /**
         * <p>
         * A unique identifier for this <code>DeleteStack</code> request. Specify this token if you plan to retry
         * requests so that CloudFormation knows that you're not attempting to delete a stack with the same name. You
         * might retry <code>DeleteStack</code> requests to ensure that CloudFormation successfully received them.
         * </p>
         * <p>
         * All events initiated by a given stack operation are assigned the same client request token, which you can use
         * to track operations. For example, if you execute a <code>CreateStack</code> operation with the token
         * <code>token1</code>, then all the <code>StackEvents</code> generated by that operation will have
         * <code>ClientRequestToken</code> set as <code>token1</code>.
         * </p>
         * <p>
         * In the console, stack operations display the client request token on the Events tab. Stack operations that
         * are initiated from the console use the token format <i>Console-StackOperation-ID</i>, which helps you easily
         * identify the stack operation . For example, if you create a stack using the console, each stack event would
         * be assigned the same token in the following format:
         * <code>Console-CreateStack-7f59c3cf-00d2-40c7-b2ff-e75db0987002</code>.
         * </p>
         * 
         * @param clientRequestToken
         *        A unique identifier for this <code>DeleteStack</code> request. Specify this token if you plan to retry
         *        requests so that CloudFormation knows that you're not attempting to delete a stack with the same name.
         *        You might retry <code>DeleteStack</code> requests to ensure that CloudFormation successfully received
         *        them.</p>
         *        <p>
         *        All events initiated by a given stack operation are assigned the same client request token, which you
         *        can use to track operations. For example, if you execute a <code>CreateStack</code> operation with the
         *        token <code>token1</code>, then all the <code>StackEvents</code> generated by that operation will have
         *        <code>ClientRequestToken</code> set as <code>token1</code>.
         *        </p>
         *        <p>
         *        In the console, stack operations display the client request token on the Events tab. Stack operations
         *        that are initiated from the console use the token format <i>Console-StackOperation-ID</i>, which helps
         *        you easily identify the stack operation . For example, if you create a stack using the console, each
         *        stack event would be assigned the same token in the following format:
         *        <code>Console-CreateStack-7f59c3cf-00d2-40c7-b2ff-e75db0987002</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientRequestToken(String clientRequestToken);

        /**
         * <p>
         * Specifies the deletion mode for the stack. Possible values are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>STANDARD</code> - Use the standard behavior. Specifying this value is the same as not specifying this
         * parameter.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>FORCE_DELETE_STACK</code> - Delete the stack if it's stuck in a <code>DELETE_FAILED</code> state due to
         * resource deletion failure.
         * </p>
         * </li>
         * </ul>
         * 
         * @param deletionMode
         *        Specifies the deletion mode for the stack. Possible values are:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>STANDARD</code> - Use the standard behavior. Specifying this value is the same as not specifying
         *        this parameter.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>FORCE_DELETE_STACK</code> - Delete the stack if it's stuck in a <code>DELETE_FAILED</code> state
         *        due to resource deletion failure.
         *        </p>
         *        </li>
         * @see DeletionMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeletionMode
         */
        Builder deletionMode(String deletionMode);

        /**
         * <p>
         * Specifies the deletion mode for the stack. Possible values are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>STANDARD</code> - Use the standard behavior. Specifying this value is the same as not specifying this
         * parameter.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>FORCE_DELETE_STACK</code> - Delete the stack if it's stuck in a <code>DELETE_FAILED</code> state due to
         * resource deletion failure.
         * </p>
         * </li>
         * </ul>
         * 
         * @param deletionMode
         *        Specifies the deletion mode for the stack. Possible values are:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>STANDARD</code> - Use the standard behavior. Specifying this value is the same as not specifying
         *        this parameter.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>FORCE_DELETE_STACK</code> - Delete the stack if it's stuck in a <code>DELETE_FAILED</code> state
         *        due to resource deletion failure.
         *        </p>
         *        </li>
         * @see DeletionMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeletionMode
         */
        Builder deletionMode(DeletionMode deletionMode);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CloudFormationRequest.BuilderImpl implements Builder {
        private String stackName;

        private List<String> retainResources = DefaultSdkAutoConstructList.getInstance();

        private String roleARN;

        private String clientRequestToken;

        private String deletionMode;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteStackRequest model) {
            super(model);
            stackName(model.stackName);
            retainResources(model.retainResources);
            roleARN(model.roleARN);
            clientRequestToken(model.clientRequestToken);
            deletionMode(model.deletionMode);
        }

        public final String getStackName() {
            return stackName;
        }

        public final void setStackName(String stackName) {
            this.stackName = stackName;
        }

        @Override
        public final Builder stackName(String stackName) {
            this.stackName = stackName;
            return this;
        }

        public final Collection<String> getRetainResources() {
            if (retainResources instanceof SdkAutoConstructList) {
                return null;
            }
            return retainResources;
        }

        public final void setRetainResources(Collection<String> retainResources) {
            this.retainResources = RetainResourcesCopier.copy(retainResources);
        }

        @Override
        public final Builder retainResources(Collection<String> retainResources) {
            this.retainResources = RetainResourcesCopier.copy(retainResources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder retainResources(String... retainResources) {
            retainResources(Arrays.asList(retainResources));
            return this;
        }

        public final String getRoleARN() {
            return roleARN;
        }

        public final void setRoleARN(String roleARN) {
            this.roleARN = roleARN;
        }

        @Override
        public final Builder roleARN(String roleARN) {
            this.roleARN = roleARN;
            return this;
        }

        public final String getClientRequestToken() {
            return clientRequestToken;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        public final String getDeletionMode() {
            return deletionMode;
        }

        public final void setDeletionMode(String deletionMode) {
            this.deletionMode = deletionMode;
        }

        @Override
        public final Builder deletionMode(String deletionMode) {
            this.deletionMode = deletionMode;
            return this;
        }

        @Override
        public final Builder deletionMode(DeletionMode deletionMode) {
            this.deletionMode(deletionMode == null ? null : deletionMode.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteStackRequest build() {
            return new DeleteStackRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
