/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudformation.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DetectStackDriftResponse extends CloudFormationResponse implements
        ToCopyableBuilder<DetectStackDriftResponse.Builder, DetectStackDriftResponse> {
    private static final SdkField<String> STACK_DRIFT_DETECTION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StackDriftDetectionId").getter(getter(DetectStackDriftResponse::stackDriftDetectionId))
            .setter(setter(Builder::stackDriftDetectionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StackDriftDetectionId").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(STACK_DRIFT_DETECTION_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String stackDriftDetectionId;

    private DetectStackDriftResponse(BuilderImpl builder) {
        super(builder);
        this.stackDriftDetectionId = builder.stackDriftDetectionId;
    }

    /**
     * <p>
     * The ID of the drift detection results of this operation.
     * </p>
     * <p>
     * CloudFormation generates new results, with a new drift detection ID, each time this operation is run. However,
     * the number of drift results CloudFormation retains for any given stack, and for how long, may vary.
     * </p>
     * 
     * @return The ID of the drift detection results of this operation.</p>
     *         <p>
     *         CloudFormation generates new results, with a new drift detection ID, each time this operation is run.
     *         However, the number of drift results CloudFormation retains for any given stack, and for how long, may
     *         vary.
     */
    public final String stackDriftDetectionId() {
        return stackDriftDetectionId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(stackDriftDetectionId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DetectStackDriftResponse)) {
            return false;
        }
        DetectStackDriftResponse other = (DetectStackDriftResponse) obj;
        return Objects.equals(stackDriftDetectionId(), other.stackDriftDetectionId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DetectStackDriftResponse").add("StackDriftDetectionId", stackDriftDetectionId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StackDriftDetectionId":
            return Optional.ofNullable(clazz.cast(stackDriftDetectionId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("StackDriftDetectionId", STACK_DRIFT_DETECTION_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DetectStackDriftResponse, T> g) {
        return obj -> g.apply((DetectStackDriftResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudFormationResponse.Builder, SdkPojo, CopyableBuilder<Builder, DetectStackDriftResponse> {
        /**
         * <p>
         * The ID of the drift detection results of this operation.
         * </p>
         * <p>
         * CloudFormation generates new results, with a new drift detection ID, each time this operation is run.
         * However, the number of drift results CloudFormation retains for any given stack, and for how long, may vary.
         * </p>
         * 
         * @param stackDriftDetectionId
         *        The ID of the drift detection results of this operation.</p>
         *        <p>
         *        CloudFormation generates new results, with a new drift detection ID, each time this operation is run.
         *        However, the number of drift results CloudFormation retains for any given stack, and for how long, may
         *        vary.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stackDriftDetectionId(String stackDriftDetectionId);
    }

    static final class BuilderImpl extends CloudFormationResponse.BuilderImpl implements Builder {
        private String stackDriftDetectionId;

        private BuilderImpl() {
        }

        private BuilderImpl(DetectStackDriftResponse model) {
            super(model);
            stackDriftDetectionId(model.stackDriftDetectionId);
        }

        public final String getStackDriftDetectionId() {
            return stackDriftDetectionId;
        }

        public final void setStackDriftDetectionId(String stackDriftDetectionId) {
            this.stackDriftDetectionId = stackDriftDetectionId;
        }

        @Override
        public final Builder stackDriftDetectionId(String stackDriftDetectionId) {
            this.stackDriftDetectionId = stackDriftDetectionId;
            return this;
        }

        @Override
        public DetectStackDriftResponse build() {
            return new DetectStackDriftResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
