/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudformation.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeStackSetOperationRequest extends CloudFormationRequest implements
        ToCopyableBuilder<DescribeStackSetOperationRequest.Builder, DescribeStackSetOperationRequest> {
    private static final SdkField<String> STACK_SET_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StackSetName").getter(getter(DescribeStackSetOperationRequest::stackSetName))
            .setter(setter(Builder::stackSetName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StackSetName").build()).build();

    private static final SdkField<String> OPERATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OperationId").getter(getter(DescribeStackSetOperationRequest::operationId))
            .setter(setter(Builder::operationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OperationId").build()).build();

    private static final SdkField<String> CALL_AS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("CallAs")
            .getter(getter(DescribeStackSetOperationRequest::callAsAsString)).setter(setter(Builder::callAs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CallAs").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STACK_SET_NAME_FIELD,
            OPERATION_ID_FIELD, CALL_AS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String stackSetName;

    private final String operationId;

    private final String callAs;

    private DescribeStackSetOperationRequest(BuilderImpl builder) {
        super(builder);
        this.stackSetName = builder.stackSetName;
        this.operationId = builder.operationId;
        this.callAs = builder.callAs;
    }

    /**
     * <p>
     * The name or the unique stack ID of the stack set for the stack operation.
     * </p>
     * 
     * @return The name or the unique stack ID of the stack set for the stack operation.
     */
    public final String stackSetName() {
        return stackSetName;
    }

    /**
     * <p>
     * The unique ID of the stack set operation.
     * </p>
     * 
     * @return The unique ID of the stack set operation.
     */
    public final String operationId() {
        return operationId;
    }

    /**
     * <p>
     * [Service-managed permissions] Specifies whether you are acting as an account administrator in the organization's
     * management account or as a delegated administrator in a member account.
     * </p>
     * <p>
     * By default, <code>SELF</code> is specified. Use <code>SELF</code> for stack sets with self-managed permissions.
     * </p>
     * <ul>
     * <li>
     * <p>
     * If you are signed in to the management account, specify <code>SELF</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * If you are signed in to a delegated administrator account, specify <code>DELEGATED_ADMIN</code>.
     * </p>
     * <p>
     * Your Amazon Web Services account must be registered as a delegated administrator in the management account. For
     * more information, see <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-orgs-delegated-admin.html"
     * >Register a delegated administrator</a> in the <i>CloudFormation User Guide</i>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #callAs} will
     * return {@link CallAs#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #callAsAsString}.
     * </p>
     * 
     * @return [Service-managed permissions] Specifies whether you are acting as an account administrator in the
     *         organization's management account or as a delegated administrator in a member account.</p>
     *         <p>
     *         By default, <code>SELF</code> is specified. Use <code>SELF</code> for stack sets with self-managed
     *         permissions.
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         If you are signed in to the management account, specify <code>SELF</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         If you are signed in to a delegated administrator account, specify <code>DELEGATED_ADMIN</code>.
     *         </p>
     *         <p>
     *         Your Amazon Web Services account must be registered as a delegated administrator in the management
     *         account. For more information, see <a href=
     *         "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-orgs-delegated-admin.html"
     *         >Register a delegated administrator</a> in the <i>CloudFormation User Guide</i>.
     *         </p>
     *         </li>
     * @see CallAs
     */
    public final CallAs callAs() {
        return CallAs.fromValue(callAs);
    }

    /**
     * <p>
     * [Service-managed permissions] Specifies whether you are acting as an account administrator in the organization's
     * management account or as a delegated administrator in a member account.
     * </p>
     * <p>
     * By default, <code>SELF</code> is specified. Use <code>SELF</code> for stack sets with self-managed permissions.
     * </p>
     * <ul>
     * <li>
     * <p>
     * If you are signed in to the management account, specify <code>SELF</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * If you are signed in to a delegated administrator account, specify <code>DELEGATED_ADMIN</code>.
     * </p>
     * <p>
     * Your Amazon Web Services account must be registered as a delegated administrator in the management account. For
     * more information, see <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-orgs-delegated-admin.html"
     * >Register a delegated administrator</a> in the <i>CloudFormation User Guide</i>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #callAs} will
     * return {@link CallAs#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #callAsAsString}.
     * </p>
     * 
     * @return [Service-managed permissions] Specifies whether you are acting as an account administrator in the
     *         organization's management account or as a delegated administrator in a member account.</p>
     *         <p>
     *         By default, <code>SELF</code> is specified. Use <code>SELF</code> for stack sets with self-managed
     *         permissions.
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         If you are signed in to the management account, specify <code>SELF</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         If you are signed in to a delegated administrator account, specify <code>DELEGATED_ADMIN</code>.
     *         </p>
     *         <p>
     *         Your Amazon Web Services account must be registered as a delegated administrator in the management
     *         account. For more information, see <a href=
     *         "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-orgs-delegated-admin.html"
     *         >Register a delegated administrator</a> in the <i>CloudFormation User Guide</i>.
     *         </p>
     *         </li>
     * @see CallAs
     */
    public final String callAsAsString() {
        return callAs;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(stackSetName());
        hashCode = 31 * hashCode + Objects.hashCode(operationId());
        hashCode = 31 * hashCode + Objects.hashCode(callAsAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeStackSetOperationRequest)) {
            return false;
        }
        DescribeStackSetOperationRequest other = (DescribeStackSetOperationRequest) obj;
        return Objects.equals(stackSetName(), other.stackSetName()) && Objects.equals(operationId(), other.operationId())
                && Objects.equals(callAsAsString(), other.callAsAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeStackSetOperationRequest").add("StackSetName", stackSetName())
                .add("OperationId", operationId()).add("CallAs", callAsAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StackSetName":
            return Optional.ofNullable(clazz.cast(stackSetName()));
        case "OperationId":
            return Optional.ofNullable(clazz.cast(operationId()));
        case "CallAs":
            return Optional.ofNullable(clazz.cast(callAsAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("StackSetName", STACK_SET_NAME_FIELD);
        map.put("OperationId", OPERATION_ID_FIELD);
        map.put("CallAs", CALL_AS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeStackSetOperationRequest, T> g) {
        return obj -> g.apply((DescribeStackSetOperationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudFormationRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeStackSetOperationRequest> {
        /**
         * <p>
         * The name or the unique stack ID of the stack set for the stack operation.
         * </p>
         * 
         * @param stackSetName
         *        The name or the unique stack ID of the stack set for the stack operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stackSetName(String stackSetName);

        /**
         * <p>
         * The unique ID of the stack set operation.
         * </p>
         * 
         * @param operationId
         *        The unique ID of the stack set operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder operationId(String operationId);

        /**
         * <p>
         * [Service-managed permissions] Specifies whether you are acting as an account administrator in the
         * organization's management account or as a delegated administrator in a member account.
         * </p>
         * <p>
         * By default, <code>SELF</code> is specified. Use <code>SELF</code> for stack sets with self-managed
         * permissions.
         * </p>
         * <ul>
         * <li>
         * <p>
         * If you are signed in to the management account, specify <code>SELF</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * If you are signed in to a delegated administrator account, specify <code>DELEGATED_ADMIN</code>.
         * </p>
         * <p>
         * Your Amazon Web Services account must be registered as a delegated administrator in the management account.
         * For more information, see <a
         * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-orgs-delegated-admin.html"
         * >Register a delegated administrator</a> in the <i>CloudFormation User Guide</i>.
         * </p>
         * </li>
         * </ul>
         * 
         * @param callAs
         *        [Service-managed permissions] Specifies whether you are acting as an account administrator in the
         *        organization's management account or as a delegated administrator in a member account.</p>
         *        <p>
         *        By default, <code>SELF</code> is specified. Use <code>SELF</code> for stack sets with self-managed
         *        permissions.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        If you are signed in to the management account, specify <code>SELF</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If you are signed in to a delegated administrator account, specify <code>DELEGATED_ADMIN</code>.
         *        </p>
         *        <p>
         *        Your Amazon Web Services account must be registered as a delegated administrator in the management
         *        account. For more information, see <a href=
         *        "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-orgs-delegated-admin.html"
         *        >Register a delegated administrator</a> in the <i>CloudFormation User Guide</i>.
         *        </p>
         *        </li>
         * @see CallAs
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CallAs
         */
        Builder callAs(String callAs);

        /**
         * <p>
         * [Service-managed permissions] Specifies whether you are acting as an account administrator in the
         * organization's management account or as a delegated administrator in a member account.
         * </p>
         * <p>
         * By default, <code>SELF</code> is specified. Use <code>SELF</code> for stack sets with self-managed
         * permissions.
         * </p>
         * <ul>
         * <li>
         * <p>
         * If you are signed in to the management account, specify <code>SELF</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * If you are signed in to a delegated administrator account, specify <code>DELEGATED_ADMIN</code>.
         * </p>
         * <p>
         * Your Amazon Web Services account must be registered as a delegated administrator in the management account.
         * For more information, see <a
         * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-orgs-delegated-admin.html"
         * >Register a delegated administrator</a> in the <i>CloudFormation User Guide</i>.
         * </p>
         * </li>
         * </ul>
         * 
         * @param callAs
         *        [Service-managed permissions] Specifies whether you are acting as an account administrator in the
         *        organization's management account or as a delegated administrator in a member account.</p>
         *        <p>
         *        By default, <code>SELF</code> is specified. Use <code>SELF</code> for stack sets with self-managed
         *        permissions.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        If you are signed in to the management account, specify <code>SELF</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If you are signed in to a delegated administrator account, specify <code>DELEGATED_ADMIN</code>.
         *        </p>
         *        <p>
         *        Your Amazon Web Services account must be registered as a delegated administrator in the management
         *        account. For more information, see <a href=
         *        "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-orgs-delegated-admin.html"
         *        >Register a delegated administrator</a> in the <i>CloudFormation User Guide</i>.
         *        </p>
         *        </li>
         * @see CallAs
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CallAs
         */
        Builder callAs(CallAs callAs);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CloudFormationRequest.BuilderImpl implements Builder {
        private String stackSetName;

        private String operationId;

        private String callAs;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeStackSetOperationRequest model) {
            super(model);
            stackSetName(model.stackSetName);
            operationId(model.operationId);
            callAs(model.callAs);
        }

        public final String getStackSetName() {
            return stackSetName;
        }

        public final void setStackSetName(String stackSetName) {
            this.stackSetName = stackSetName;
        }

        @Override
        public final Builder stackSetName(String stackSetName) {
            this.stackSetName = stackSetName;
            return this;
        }

        public final String getOperationId() {
            return operationId;
        }

        public final void setOperationId(String operationId) {
            this.operationId = operationId;
        }

        @Override
        public final Builder operationId(String operationId) {
            this.operationId = operationId;
            return this;
        }

        public final String getCallAs() {
            return callAs;
        }

        public final void setCallAs(String callAs) {
            this.callAs = callAs;
        }

        @Override
        public final Builder callAs(String callAs) {
            this.callAs = callAs;
            return this;
        }

        @Override
        public final Builder callAs(CallAs callAs) {
            this.callAs(callAs == null ? null : callAs.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeStackSetOperationRequest build() {
            return new DescribeStackSetOperationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
