/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudformation.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListHookResultsResponse extends CloudFormationResponse implements
        ToCopyableBuilder<ListHookResultsResponse.Builder, ListHookResultsResponse> {
    private static final SdkField<String> TARGET_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TargetType").getter(getter(ListHookResultsResponse::targetTypeAsString))
            .setter(setter(Builder::targetType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetType").build()).build();

    private static final SdkField<String> TARGET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TargetId").getter(getter(ListHookResultsResponse::targetId)).setter(setter(Builder::targetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetId").build()).build();

    private static final SdkField<List<HookResultSummary>> HOOK_RESULTS_FIELD = SdkField
            .<List<HookResultSummary>> builder(MarshallingType.LIST)
            .memberName("HookResults")
            .getter(getter(ListHookResultsResponse::hookResults))
            .setter(setter(Builder::hookResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HookResults").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<HookResultSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(HookResultSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListHookResultsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TARGET_TYPE_FIELD,
            TARGET_ID_FIELD, HOOK_RESULTS_FIELD, NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String targetType;

    private final String targetId;

    private final List<HookResultSummary> hookResults;

    private final String nextToken;

    private ListHookResultsResponse(BuilderImpl builder) {
        super(builder);
        this.targetType = builder.targetType;
        this.targetId = builder.targetId;
        this.hookResults = builder.hookResults;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The type of operation being targeted by the Hook.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #targetType} will
     * return {@link ListHookResultsTargetType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #targetTypeAsString}.
     * </p>
     * 
     * @return The type of operation being targeted by the Hook.
     * @see ListHookResultsTargetType
     */
    public final ListHookResultsTargetType targetType() {
        return ListHookResultsTargetType.fromValue(targetType);
    }

    /**
     * <p>
     * The type of operation being targeted by the Hook.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #targetType} will
     * return {@link ListHookResultsTargetType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #targetTypeAsString}.
     * </p>
     * 
     * @return The type of operation being targeted by the Hook.
     * @see ListHookResultsTargetType
     */
    public final String targetTypeAsString() {
        return targetType;
    }

    /**
     * <p>
     * The logical ID of the target the operation is acting on by the Hook. If the target is a change set, it's the ARN
     * of the change set.
     * </p>
     * <p>
     * If the target is a Cloud Control API operation, this will be the <code>HooksRequestToken</code> returned by the
     * Cloud Control API operation request. For more information on the <code>HooksRequestToken</code>, see <a
     * href="https://docs.aws.amazon.com/cloudcontrolapi/latest/APIReference/API_ProgressEvent.html">ProgressEvent</a>.
     * </p>
     * 
     * @return The logical ID of the target the operation is acting on by the Hook. If the target is a change set, it's
     *         the ARN of the change set.</p>
     *         <p>
     *         If the target is a Cloud Control API operation, this will be the <code>HooksRequestToken</code> returned
     *         by the Cloud Control API operation request. For more information on the <code>HooksRequestToken</code>,
     *         see <a href="https://docs.aws.amazon.com/cloudcontrolapi/latest/APIReference/API_ProgressEvent.html">
     *         ProgressEvent</a>.
     */
    public final String targetId() {
        return targetId;
    }

    /**
     * For responses, this returns true if the service returned a value for the HookResults property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasHookResults() {
        return hookResults != null && !(hookResults instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of <code>HookResultSummary</code> structures that provides the status and Hook status reason for each Hook
     * invocation for the specified target.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasHookResults} method.
     * </p>
     * 
     * @return A list of <code>HookResultSummary</code> structures that provides the status and Hook status reason for
     *         each Hook invocation for the specified target.
     */
    public final List<HookResultSummary> hookResults() {
        return hookResults;
    }

    /**
     * <p>
     * Pagination token, <code>null</code> or empty if no more results.
     * </p>
     * 
     * @return Pagination token, <code>null</code> or empty if no more results.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(targetTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(targetId());
        hashCode = 31 * hashCode + Objects.hashCode(hasHookResults() ? hookResults() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListHookResultsResponse)) {
            return false;
        }
        ListHookResultsResponse other = (ListHookResultsResponse) obj;
        return Objects.equals(targetTypeAsString(), other.targetTypeAsString()) && Objects.equals(targetId(), other.targetId())
                && hasHookResults() == other.hasHookResults() && Objects.equals(hookResults(), other.hookResults())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListHookResultsResponse").add("TargetType", targetTypeAsString()).add("TargetId", targetId())
                .add("HookResults", hasHookResults() ? hookResults() : null).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TargetType":
            return Optional.ofNullable(clazz.cast(targetTypeAsString()));
        case "TargetId":
            return Optional.ofNullable(clazz.cast(targetId()));
        case "HookResults":
            return Optional.ofNullable(clazz.cast(hookResults()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("TargetType", TARGET_TYPE_FIELD);
        map.put("TargetId", TARGET_ID_FIELD);
        map.put("HookResults", HOOK_RESULTS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListHookResultsResponse, T> g) {
        return obj -> g.apply((ListHookResultsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudFormationResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListHookResultsResponse> {
        /**
         * <p>
         * The type of operation being targeted by the Hook.
         * </p>
         * 
         * @param targetType
         *        The type of operation being targeted by the Hook.
         * @see ListHookResultsTargetType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ListHookResultsTargetType
         */
        Builder targetType(String targetType);

        /**
         * <p>
         * The type of operation being targeted by the Hook.
         * </p>
         * 
         * @param targetType
         *        The type of operation being targeted by the Hook.
         * @see ListHookResultsTargetType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ListHookResultsTargetType
         */
        Builder targetType(ListHookResultsTargetType targetType);

        /**
         * <p>
         * The logical ID of the target the operation is acting on by the Hook. If the target is a change set, it's the
         * ARN of the change set.
         * </p>
         * <p>
         * If the target is a Cloud Control API operation, this will be the <code>HooksRequestToken</code> returned by
         * the Cloud Control API operation request. For more information on the <code>HooksRequestToken</code>, see <a
         * href
         * ="https://docs.aws.amazon.com/cloudcontrolapi/latest/APIReference/API_ProgressEvent.html">ProgressEvent</a>.
         * </p>
         * 
         * @param targetId
         *        The logical ID of the target the operation is acting on by the Hook. If the target is a change set,
         *        it's the ARN of the change set.</p>
         *        <p>
         *        If the target is a Cloud Control API operation, this will be the <code>HooksRequestToken</code>
         *        returned by the Cloud Control API operation request. For more information on the
         *        <code>HooksRequestToken</code>, see <a
         *        href="https://docs.aws.amazon.com/cloudcontrolapi/latest/APIReference/API_ProgressEvent.html"
         *        >ProgressEvent</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetId(String targetId);

        /**
         * <p>
         * A list of <code>HookResultSummary</code> structures that provides the status and Hook status reason for each
         * Hook invocation for the specified target.
         * </p>
         * 
         * @param hookResults
         *        A list of <code>HookResultSummary</code> structures that provides the status and Hook status reason
         *        for each Hook invocation for the specified target.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hookResults(Collection<HookResultSummary> hookResults);

        /**
         * <p>
         * A list of <code>HookResultSummary</code> structures that provides the status and Hook status reason for each
         * Hook invocation for the specified target.
         * </p>
         * 
         * @param hookResults
         *        A list of <code>HookResultSummary</code> structures that provides the status and Hook status reason
         *        for each Hook invocation for the specified target.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hookResults(HookResultSummary... hookResults);

        /**
         * <p>
         * A list of <code>HookResultSummary</code> structures that provides the status and Hook status reason for each
         * Hook invocation for the specified target.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.cloudformation.model.HookResultSummary.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.cloudformation.model.HookResultSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.cloudformation.model.HookResultSummary.Builder#build()} is called
         * immediately and its result is passed to {@link #hookResults(List<HookResultSummary>)}.
         * 
         * @param hookResults
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.cloudformation.model.HookResultSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #hookResults(java.util.Collection<HookResultSummary>)
         */
        Builder hookResults(Consumer<HookResultSummary.Builder>... hookResults);

        /**
         * <p>
         * Pagination token, <code>null</code> or empty if no more results.
         * </p>
         * 
         * @param nextToken
         *        Pagination token, <code>null</code> or empty if no more results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends CloudFormationResponse.BuilderImpl implements Builder {
        private String targetType;

        private String targetId;

        private List<HookResultSummary> hookResults = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListHookResultsResponse model) {
            super(model);
            targetType(model.targetType);
            targetId(model.targetId);
            hookResults(model.hookResults);
            nextToken(model.nextToken);
        }

        public final String getTargetType() {
            return targetType;
        }

        public final void setTargetType(String targetType) {
            this.targetType = targetType;
        }

        @Override
        public final Builder targetType(String targetType) {
            this.targetType = targetType;
            return this;
        }

        @Override
        public final Builder targetType(ListHookResultsTargetType targetType) {
            this.targetType(targetType == null ? null : targetType.toString());
            return this;
        }

        public final String getTargetId() {
            return targetId;
        }

        public final void setTargetId(String targetId) {
            this.targetId = targetId;
        }

        @Override
        public final Builder targetId(String targetId) {
            this.targetId = targetId;
            return this;
        }

        public final List<HookResultSummary.Builder> getHookResults() {
            List<HookResultSummary.Builder> result = HookResultSummariesCopier.copyToBuilder(this.hookResults);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setHookResults(Collection<HookResultSummary.BuilderImpl> hookResults) {
            this.hookResults = HookResultSummariesCopier.copyFromBuilder(hookResults);
        }

        @Override
        public final Builder hookResults(Collection<HookResultSummary> hookResults) {
            this.hookResults = HookResultSummariesCopier.copy(hookResults);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder hookResults(HookResultSummary... hookResults) {
            hookResults(Arrays.asList(hookResults));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder hookResults(Consumer<HookResultSummary.Builder>... hookResults) {
            hookResults(Stream.of(hookResults).map(c -> HookResultSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListHookResultsResponse build() {
            return new ListHookResultsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
