/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cloudformation.model.ResourceMapping;
import software.amazon.awssdk.services.cloudformation.model.StackRefactorActionEntity;
import software.amazon.awssdk.services.cloudformation.model.StackRefactorActionType;
import software.amazon.awssdk.services.cloudformation.model.StackRefactorDetection;
import software.amazon.awssdk.services.cloudformation.model.StackRefactorTagResourcesCopier;
import software.amazon.awssdk.services.cloudformation.model.StackRefactorUntagResourcesCopier;
import software.amazon.awssdk.services.cloudformation.model.Tag;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StackRefactorAction
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, StackRefactorAction> {
    private static final SdkField<String> ACTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Action").getter(StackRefactorAction.getter(StackRefactorAction::actionAsString)).setter(StackRefactorAction.setter(Builder::action)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Action").build()}).build();
    private static final SdkField<String> ENTITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Entity").getter(StackRefactorAction.getter(StackRefactorAction::entityAsString)).setter(StackRefactorAction.setter(Builder::entity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Entity").build()}).build();
    private static final SdkField<String> PHYSICAL_RESOURCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PhysicalResourceId").getter(StackRefactorAction.getter(StackRefactorAction::physicalResourceId)).setter(StackRefactorAction.setter(Builder::physicalResourceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PhysicalResourceId").build()}).build();
    private static final SdkField<String> RESOURCE_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceIdentifier").getter(StackRefactorAction.getter(StackRefactorAction::resourceIdentifier)).setter(StackRefactorAction.setter(Builder::resourceIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceIdentifier").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(StackRefactorAction.getter(StackRefactorAction::description)).setter(StackRefactorAction.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> DETECTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Detection").getter(StackRefactorAction.getter(StackRefactorAction::detectionAsString)).setter(StackRefactorAction.setter(Builder::detection)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Detection").build()}).build();
    private static final SdkField<String> DETECTION_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DetectionReason").getter(StackRefactorAction.getter(StackRefactorAction::detectionReason)).setter(StackRefactorAction.setter(Builder::detectionReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DetectionReason").build()}).build();
    private static final SdkField<List<Tag>> TAG_RESOURCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TagResources").getter(StackRefactorAction.getter(StackRefactorAction::tagResources)).setter(StackRefactorAction.setter(Builder::tagResources)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagResources").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> UNTAG_RESOURCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("UntagResources").getter(StackRefactorAction.getter(StackRefactorAction::untagResources)).setter(StackRefactorAction.setter(Builder::untagResources)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UntagResources").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<ResourceMapping> RESOURCE_MAPPING_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ResourceMapping").getter(StackRefactorAction.getter(StackRefactorAction::resourceMapping)).setter(StackRefactorAction.setter(Builder::resourceMapping)).constructor(ResourceMapping::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceMapping").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTION_FIELD, ENTITY_FIELD, PHYSICAL_RESOURCE_ID_FIELD, RESOURCE_IDENTIFIER_FIELD, DESCRIPTION_FIELD, DETECTION_FIELD, DETECTION_REASON_FIELD, TAG_RESOURCES_FIELD, UNTAG_RESOURCES_FIELD, RESOURCE_MAPPING_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = StackRefactorAction.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String action;
    private final String entity;
    private final String physicalResourceId;
    private final String resourceIdentifier;
    private final String description;
    private final String detection;
    private final String detectionReason;
    private final List<Tag> tagResources;
    private final List<String> untagResources;
    private final ResourceMapping resourceMapping;

    private StackRefactorAction(BuilderImpl builder) {
        this.action = builder.action;
        this.entity = builder.entity;
        this.physicalResourceId = builder.physicalResourceId;
        this.resourceIdentifier = builder.resourceIdentifier;
        this.description = builder.description;
        this.detection = builder.detection;
        this.detectionReason = builder.detectionReason;
        this.tagResources = builder.tagResources;
        this.untagResources = builder.untagResources;
        this.resourceMapping = builder.resourceMapping;
    }

    public final StackRefactorActionType action() {
        return StackRefactorActionType.fromValue(this.action);
    }

    public final String actionAsString() {
        return this.action;
    }

    public final StackRefactorActionEntity entity() {
        return StackRefactorActionEntity.fromValue(this.entity);
    }

    public final String entityAsString() {
        return this.entity;
    }

    public final String physicalResourceId() {
        return this.physicalResourceId;
    }

    public final String resourceIdentifier() {
        return this.resourceIdentifier;
    }

    public final String description() {
        return this.description;
    }

    public final StackRefactorDetection detection() {
        return StackRefactorDetection.fromValue(this.detection);
    }

    public final String detectionAsString() {
        return this.detection;
    }

    public final String detectionReason() {
        return this.detectionReason;
    }

    public final boolean hasTagResources() {
        return this.tagResources != null && !(this.tagResources instanceof SdkAutoConstructList);
    }

    public final List<Tag> tagResources() {
        return this.tagResources;
    }

    public final boolean hasUntagResources() {
        return this.untagResources != null && !(this.untagResources instanceof SdkAutoConstructList);
    }

    public final List<String> untagResources() {
        return this.untagResources;
    }

    public final ResourceMapping resourceMapping() {
        return this.resourceMapping;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.actionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.entityAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.physicalResourceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.detectionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.detectionReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTagResources() ? this.tagResources() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasUntagResources() ? this.untagResources() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceMapping());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StackRefactorAction)) {
            return false;
        }
        StackRefactorAction other = (StackRefactorAction)obj;
        return Objects.equals(this.actionAsString(), other.actionAsString()) && Objects.equals(this.entityAsString(), other.entityAsString()) && Objects.equals(this.physicalResourceId(), other.physicalResourceId()) && Objects.equals(this.resourceIdentifier(), other.resourceIdentifier()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.detectionAsString(), other.detectionAsString()) && Objects.equals(this.detectionReason(), other.detectionReason()) && this.hasTagResources() == other.hasTagResources() && Objects.equals(this.tagResources(), other.tagResources()) && this.hasUntagResources() == other.hasUntagResources() && Objects.equals(this.untagResources(), other.untagResources()) && Objects.equals(this.resourceMapping(), other.resourceMapping());
    }

    public final String toString() {
        return ToString.builder((String)"StackRefactorAction").add("Action", (Object)this.actionAsString()).add("Entity", (Object)this.entityAsString()).add("PhysicalResourceId", (Object)this.physicalResourceId()).add("ResourceIdentifier", (Object)this.resourceIdentifier()).add("Description", (Object)this.description()).add("Detection", (Object)this.detectionAsString()).add("DetectionReason", (Object)this.detectionReason()).add("TagResources", this.hasTagResources() ? this.tagResources() : null).add("UntagResources", this.hasUntagResources() ? this.untagResources() : null).add("ResourceMapping", (Object)this.resourceMapping()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Action": {
                return Optional.ofNullable(clazz.cast(this.actionAsString()));
            }
            case "Entity": {
                return Optional.ofNullable(clazz.cast(this.entityAsString()));
            }
            case "PhysicalResourceId": {
                return Optional.ofNullable(clazz.cast(this.physicalResourceId()));
            }
            case "ResourceIdentifier": {
                return Optional.ofNullable(clazz.cast(this.resourceIdentifier()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "Detection": {
                return Optional.ofNullable(clazz.cast(this.detectionAsString()));
            }
            case "DetectionReason": {
                return Optional.ofNullable(clazz.cast(this.detectionReason()));
            }
            case "TagResources": {
                return Optional.ofNullable(clazz.cast(this.tagResources()));
            }
            case "UntagResources": {
                return Optional.ofNullable(clazz.cast(this.untagResources()));
            }
            case "ResourceMapping": {
                return Optional.ofNullable(clazz.cast(this.resourceMapping()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Action", ACTION_FIELD);
        map.put("Entity", ENTITY_FIELD);
        map.put("PhysicalResourceId", PHYSICAL_RESOURCE_ID_FIELD);
        map.put("ResourceIdentifier", RESOURCE_IDENTIFIER_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("Detection", DETECTION_FIELD);
        map.put("DetectionReason", DETECTION_REASON_FIELD);
        map.put("TagResources", TAG_RESOURCES_FIELD);
        map.put("UntagResources", UNTAG_RESOURCES_FIELD);
        map.put("ResourceMapping", RESOURCE_MAPPING_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StackRefactorAction, T> g) {
        return obj -> g.apply((StackRefactorAction)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String action;
        private String entity;
        private String physicalResourceId;
        private String resourceIdentifier;
        private String description;
        private String detection;
        private String detectionReason;
        private List<Tag> tagResources = DefaultSdkAutoConstructList.getInstance();
        private List<String> untagResources = DefaultSdkAutoConstructList.getInstance();
        private ResourceMapping resourceMapping;

        private BuilderImpl() {
        }

        private BuilderImpl(StackRefactorAction model) {
            this.action(model.action);
            this.entity(model.entity);
            this.physicalResourceId(model.physicalResourceId);
            this.resourceIdentifier(model.resourceIdentifier);
            this.description(model.description);
            this.detection(model.detection);
            this.detectionReason(model.detectionReason);
            this.tagResources(model.tagResources);
            this.untagResources(model.untagResources);
            this.resourceMapping(model.resourceMapping);
        }

        public final String getAction() {
            return this.action;
        }

        public final void setAction(String action) {
            this.action = action;
        }

        @Override
        public final Builder action(String action) {
            this.action = action;
            return this;
        }

        @Override
        public final Builder action(StackRefactorActionType action) {
            this.action(action == null ? null : action.toString());
            return this;
        }

        public final String getEntity() {
            return this.entity;
        }

        public final void setEntity(String entity) {
            this.entity = entity;
        }

        @Override
        public final Builder entity(String entity) {
            this.entity = entity;
            return this;
        }

        @Override
        public final Builder entity(StackRefactorActionEntity entity) {
            this.entity(entity == null ? null : entity.toString());
            return this;
        }

        public final String getPhysicalResourceId() {
            return this.physicalResourceId;
        }

        public final void setPhysicalResourceId(String physicalResourceId) {
            this.physicalResourceId = physicalResourceId;
        }

        @Override
        public final Builder physicalResourceId(String physicalResourceId) {
            this.physicalResourceId = physicalResourceId;
            return this;
        }

        public final String getResourceIdentifier() {
            return this.resourceIdentifier;
        }

        public final void setResourceIdentifier(String resourceIdentifier) {
            this.resourceIdentifier = resourceIdentifier;
        }

        @Override
        public final Builder resourceIdentifier(String resourceIdentifier) {
            this.resourceIdentifier = resourceIdentifier;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getDetection() {
            return this.detection;
        }

        public final void setDetection(String detection) {
            this.detection = detection;
        }

        @Override
        public final Builder detection(String detection) {
            this.detection = detection;
            return this;
        }

        @Override
        public final Builder detection(StackRefactorDetection detection) {
            this.detection(detection == null ? null : detection.toString());
            return this;
        }

        public final String getDetectionReason() {
            return this.detectionReason;
        }

        public final void setDetectionReason(String detectionReason) {
            this.detectionReason = detectionReason;
        }

        @Override
        public final Builder detectionReason(String detectionReason) {
            this.detectionReason = detectionReason;
            return this;
        }

        public final List<Tag.Builder> getTagResources() {
            List<Tag.Builder> result = StackRefactorTagResourcesCopier.copyToBuilder(this.tagResources);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTagResources(Collection<Tag.BuilderImpl> tagResources) {
            this.tagResources = StackRefactorTagResourcesCopier.copyFromBuilder(tagResources);
        }

        @Override
        public final Builder tagResources(Collection<Tag> tagResources) {
            this.tagResources = StackRefactorTagResourcesCopier.copy(tagResources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagResources(Tag ... tagResources) {
            this.tagResources(Arrays.asList(tagResources));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagResources(Consumer<Tag.Builder> ... tagResources) {
            this.tagResources(Stream.of(tagResources).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getUntagResources() {
            if (this.untagResources instanceof SdkAutoConstructList) {
                return null;
            }
            return this.untagResources;
        }

        public final void setUntagResources(Collection<String> untagResources) {
            this.untagResources = StackRefactorUntagResourcesCopier.copy(untagResources);
        }

        @Override
        public final Builder untagResources(Collection<String> untagResources) {
            this.untagResources = StackRefactorUntagResourcesCopier.copy(untagResources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder untagResources(String ... untagResources) {
            this.untagResources(Arrays.asList(untagResources));
            return this;
        }

        public final ResourceMapping.Builder getResourceMapping() {
            return this.resourceMapping != null ? this.resourceMapping.toBuilder() : null;
        }

        public final void setResourceMapping(ResourceMapping.BuilderImpl resourceMapping) {
            this.resourceMapping = resourceMapping != null ? resourceMapping.build() : null;
        }

        @Override
        public final Builder resourceMapping(ResourceMapping resourceMapping) {
            this.resourceMapping = resourceMapping;
            return this;
        }

        public StackRefactorAction build() {
            return new StackRefactorAction(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, StackRefactorAction> {
        public Builder action(String var1);

        public Builder action(StackRefactorActionType var1);

        public Builder entity(String var1);

        public Builder entity(StackRefactorActionEntity var1);

        public Builder physicalResourceId(String var1);

        public Builder resourceIdentifier(String var1);

        public Builder description(String var1);

        public Builder detection(String var1);

        public Builder detection(StackRefactorDetection var1);

        public Builder detectionReason(String var1);

        public Builder tagResources(Collection<Tag> var1);

        public Builder tagResources(Tag ... var1);

        public Builder tagResources(Consumer<Tag.Builder> ... var1);

        public Builder untagResources(Collection<String> var1);

        public Builder untagResources(String ... var1);

        public Builder resourceMapping(ResourceMapping var1);

        default public Builder resourceMapping(Consumer<ResourceMapping.Builder> resourceMapping) {
            return this.resourceMapping((ResourceMapping)((ResourceMapping.Builder)ResourceMapping.builder().applyMutation(resourceMapping)).build());
        }
    }
}

