/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudformation.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartResourceScanRequest extends CloudFormationRequest implements
        ToCopyableBuilder<StartResourceScanRequest.Builder, StartResourceScanRequest> {
    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ClientRequestToken").getter(getter(StartResourceScanRequest::clientRequestToken))
            .setter(setter(Builder::clientRequestToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientRequestToken").build())
            .build();

    private static final SdkField<List<ScanFilter>> SCAN_FILTERS_FIELD = SdkField
            .<List<ScanFilter>> builder(MarshallingType.LIST)
            .memberName("ScanFilters")
            .getter(getter(StartResourceScanRequest::scanFilters))
            .setter(setter(Builder::scanFilters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScanFilters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ScanFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(ScanFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_REQUEST_TOKEN_FIELD,
            SCAN_FILTERS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String clientRequestToken;

    private final List<ScanFilter> scanFilters;

    private StartResourceScanRequest(BuilderImpl builder) {
        super(builder);
        this.clientRequestToken = builder.clientRequestToken;
        this.scanFilters = builder.scanFilters;
    }

    /**
     * <p>
     * A unique identifier for this <code>StartResourceScan</code> request. Specify this token if you plan to retry
     * requests so that CloudFormation knows that you're not attempting to start a new resource scan.
     * </p>
     * 
     * @return A unique identifier for this <code>StartResourceScan</code> request. Specify this token if you plan to
     *         retry requests so that CloudFormation knows that you're not attempting to start a new resource scan.
     */
    public final String clientRequestToken() {
        return clientRequestToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the ScanFilters property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasScanFilters() {
        return scanFilters != null && !(scanFilters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The scan filters to use.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasScanFilters} method.
     * </p>
     * 
     * @return The scan filters to use.
     */
    public final List<ScanFilter> scanFilters() {
        return scanFilters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clientRequestToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasScanFilters() ? scanFilters() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartResourceScanRequest)) {
            return false;
        }
        StartResourceScanRequest other = (StartResourceScanRequest) obj;
        return Objects.equals(clientRequestToken(), other.clientRequestToken()) && hasScanFilters() == other.hasScanFilters()
                && Objects.equals(scanFilters(), other.scanFilters());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StartResourceScanRequest").add("ClientRequestToken", clientRequestToken())
                .add("ScanFilters", hasScanFilters() ? scanFilters() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ClientRequestToken":
            return Optional.ofNullable(clazz.cast(clientRequestToken()));
        case "ScanFilters":
            return Optional.ofNullable(clazz.cast(scanFilters()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ClientRequestToken", CLIENT_REQUEST_TOKEN_FIELD);
        map.put("ScanFilters", SCAN_FILTERS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StartResourceScanRequest, T> g) {
        return obj -> g.apply((StartResourceScanRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudFormationRequest.Builder, SdkPojo, CopyableBuilder<Builder, StartResourceScanRequest> {
        /**
         * <p>
         * A unique identifier for this <code>StartResourceScan</code> request. Specify this token if you plan to retry
         * requests so that CloudFormation knows that you're not attempting to start a new resource scan.
         * </p>
         * 
         * @param clientRequestToken
         *        A unique identifier for this <code>StartResourceScan</code> request. Specify this token if you plan to
         *        retry requests so that CloudFormation knows that you're not attempting to start a new resource scan.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientRequestToken(String clientRequestToken);

        /**
         * <p>
         * The scan filters to use.
         * </p>
         * 
         * @param scanFilters
         *        The scan filters to use.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scanFilters(Collection<ScanFilter> scanFilters);

        /**
         * <p>
         * The scan filters to use.
         * </p>
         * 
         * @param scanFilters
         *        The scan filters to use.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scanFilters(ScanFilter... scanFilters);

        /**
         * <p>
         * The scan filters to use.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.cloudformation.model.ScanFilter.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.cloudformation.model.ScanFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.cloudformation.model.ScanFilter.Builder#build()} is called immediately
         * and its result is passed to {@link #scanFilters(List<ScanFilter>)}.
         * 
         * @param scanFilters
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.cloudformation.model.ScanFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #scanFilters(java.util.Collection<ScanFilter>)
         */
        Builder scanFilters(Consumer<ScanFilter.Builder>... scanFilters);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CloudFormationRequest.BuilderImpl implements Builder {
        private String clientRequestToken;

        private List<ScanFilter> scanFilters = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(StartResourceScanRequest model) {
            super(model);
            clientRequestToken(model.clientRequestToken);
            scanFilters(model.scanFilters);
        }

        public final String getClientRequestToken() {
            return clientRequestToken;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        public final List<ScanFilter.Builder> getScanFilters() {
            List<ScanFilter.Builder> result = ScanFiltersCopier.copyToBuilder(this.scanFilters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setScanFilters(Collection<ScanFilter.BuilderImpl> scanFilters) {
            this.scanFilters = ScanFiltersCopier.copyFromBuilder(scanFilters);
        }

        @Override
        public final Builder scanFilters(Collection<ScanFilter> scanFilters) {
            this.scanFilters = ScanFiltersCopier.copy(scanFilters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scanFilters(ScanFilter... scanFilters) {
            scanFilters(Arrays.asList(scanFilters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scanFilters(Consumer<ScanFilter.Builder>... scanFilters) {
            scanFilters(Stream.of(scanFilters).map(c -> ScanFilter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartResourceScanRequest build() {
            return new StartResourceScanRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
