/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudformation.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListStackRefactorActionsResponse extends CloudFormationResponse implements
        ToCopyableBuilder<ListStackRefactorActionsResponse.Builder, ListStackRefactorActionsResponse> {
    private static final SdkField<List<StackRefactorAction>> STACK_REFACTOR_ACTIONS_FIELD = SdkField
            .<List<StackRefactorAction>> builder(MarshallingType.LIST)
            .memberName("StackRefactorActions")
            .getter(getter(ListStackRefactorActionsResponse::stackRefactorActions))
            .setter(setter(Builder::stackRefactorActions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StackRefactorActions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<StackRefactorAction> builder(MarshallingType.SDK_POJO)
                                            .constructor(StackRefactorAction::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListStackRefactorActionsResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STACK_REFACTOR_ACTIONS_FIELD,
            NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<StackRefactorAction> stackRefactorActions;

    private final String nextToken;

    private ListStackRefactorActionsResponse(BuilderImpl builder) {
        super(builder);
        this.stackRefactorActions = builder.stackRefactorActions;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the StackRefactorActions property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasStackRefactorActions() {
        return stackRefactorActions != null && !(stackRefactorActions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The stack refactor actions.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasStackRefactorActions} method.
     * </p>
     * 
     * @return The stack refactor actions.
     */
    public final List<StackRefactorAction> stackRefactorActions() {
        return stackRefactorActions;
    }

    /**
     * <p>
     * If the request doesn't return all the remaining results, <code>NextToken</code> is set to a token. To retrieve
     * the next set of results, call this action again and assign that token to the request object's
     * <code>NextToken</code> parameter. If the request returns all results, <code>NextToken</code> is set to
     * <code>null</code>.
     * </p>
     * 
     * @return If the request doesn't return all the remaining results, <code>NextToken</code> is set to a token. To
     *         retrieve the next set of results, call this action again and assign that token to the request object's
     *         <code>NextToken</code> parameter. If the request returns all results, <code>NextToken</code> is set to
     *         <code>null</code>.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasStackRefactorActions() ? stackRefactorActions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListStackRefactorActionsResponse)) {
            return false;
        }
        ListStackRefactorActionsResponse other = (ListStackRefactorActionsResponse) obj;
        return hasStackRefactorActions() == other.hasStackRefactorActions()
                && Objects.equals(stackRefactorActions(), other.stackRefactorActions())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListStackRefactorActionsResponse")
                .add("StackRefactorActions", hasStackRefactorActions() ? stackRefactorActions() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StackRefactorActions":
            return Optional.ofNullable(clazz.cast(stackRefactorActions()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("StackRefactorActions", STACK_REFACTOR_ACTIONS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListStackRefactorActionsResponse, T> g) {
        return obj -> g.apply((ListStackRefactorActionsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudFormationResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListStackRefactorActionsResponse> {
        /**
         * <p>
         * The stack refactor actions.
         * </p>
         * 
         * @param stackRefactorActions
         *        The stack refactor actions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stackRefactorActions(Collection<StackRefactorAction> stackRefactorActions);

        /**
         * <p>
         * The stack refactor actions.
         * </p>
         * 
         * @param stackRefactorActions
         *        The stack refactor actions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stackRefactorActions(StackRefactorAction... stackRefactorActions);

        /**
         * <p>
         * The stack refactor actions.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.cloudformation.model.StackRefactorAction.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.cloudformation.model.StackRefactorAction#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.cloudformation.model.StackRefactorAction.Builder#build()} is called
         * immediately and its result is passed to {@link #stackRefactorActions(List<StackRefactorAction>)}.
         * 
         * @param stackRefactorActions
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.cloudformation.model.StackRefactorAction.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #stackRefactorActions(java.util.Collection<StackRefactorAction>)
         */
        Builder stackRefactorActions(Consumer<StackRefactorAction.Builder>... stackRefactorActions);

        /**
         * <p>
         * If the request doesn't return all the remaining results, <code>NextToken</code> is set to a token. To
         * retrieve the next set of results, call this action again and assign that token to the request object's
         * <code>NextToken</code> parameter. If the request returns all results, <code>NextToken</code> is set to
         * <code>null</code>.
         * </p>
         * 
         * @param nextToken
         *        If the request doesn't return all the remaining results, <code>NextToken</code> is set to a token. To
         *        retrieve the next set of results, call this action again and assign that token to the request object's
         *        <code>NextToken</code> parameter. If the request returns all results, <code>NextToken</code> is set to
         *        <code>null</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends CloudFormationResponse.BuilderImpl implements Builder {
        private List<StackRefactorAction> stackRefactorActions = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListStackRefactorActionsResponse model) {
            super(model);
            stackRefactorActions(model.stackRefactorActions);
            nextToken(model.nextToken);
        }

        public final List<StackRefactorAction.Builder> getStackRefactorActions() {
            List<StackRefactorAction.Builder> result = StackRefactorActionsCopier.copyToBuilder(this.stackRefactorActions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setStackRefactorActions(Collection<StackRefactorAction.BuilderImpl> stackRefactorActions) {
            this.stackRefactorActions = StackRefactorActionsCopier.copyFromBuilder(stackRefactorActions);
        }

        @Override
        public final Builder stackRefactorActions(Collection<StackRefactorAction> stackRefactorActions) {
            this.stackRefactorActions = StackRefactorActionsCopier.copy(stackRefactorActions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stackRefactorActions(StackRefactorAction... stackRefactorActions) {
            stackRefactorActions(Arrays.asList(stackRefactorActions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stackRefactorActions(Consumer<StackRefactorAction.Builder>... stackRefactorActions) {
            stackRefactorActions(Stream.of(stackRefactorActions).map(c -> StackRefactorAction.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListStackRefactorActionsResponse build() {
            return new ListStackRefactorActionsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
