/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudformation.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains summary information about a specific version of a CloudFormation extension.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TypeVersionSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<TypeVersionSummary.Builder, TypeVersionSummary> {
    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(TypeVersionSummary::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final SdkField<String> TYPE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TypeName").getter(getter(TypeVersionSummary::typeName)).setter(setter(Builder::typeName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TypeName").build()).build();

    private static final SdkField<String> VERSION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VersionId").getter(getter(TypeVersionSummary::versionId)).setter(setter(Builder::versionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VersionId").build()).build();

    private static final SdkField<Boolean> IS_DEFAULT_VERSION_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("IsDefaultVersion").getter(getter(TypeVersionSummary::isDefaultVersion))
            .setter(setter(Builder::isDefaultVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsDefaultVersion").build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(TypeVersionSummary::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<Instant> TIME_CREATED_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("TimeCreated").getter(getter(TypeVersionSummary::timeCreated)).setter(setter(Builder::timeCreated))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimeCreated").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(TypeVersionSummary::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> PUBLIC_VERSION_NUMBER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PublicVersionNumber").getter(getter(TypeVersionSummary::publicVersionNumber))
            .setter(setter(Builder::publicVersionNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PublicVersionNumber").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD, TYPE_NAME_FIELD,
            VERSION_ID_FIELD, IS_DEFAULT_VERSION_FIELD, ARN_FIELD, TIME_CREATED_FIELD, DESCRIPTION_FIELD,
            PUBLIC_VERSION_NUMBER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String type;

    private final String typeName;

    private final String versionId;

    private final Boolean isDefaultVersion;

    private final String arn;

    private final Instant timeCreated;

    private final String description;

    private final String publicVersionNumber;

    private TypeVersionSummary(BuilderImpl builder) {
        this.type = builder.type;
        this.typeName = builder.typeName;
        this.versionId = builder.versionId;
        this.isDefaultVersion = builder.isDefaultVersion;
        this.arn = builder.arn;
        this.timeCreated = builder.timeCreated;
        this.description = builder.description;
        this.publicVersionNumber = builder.publicVersionNumber;
    }

    /**
     * <p>
     * The kind of extension.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link RegistryType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The kind of extension.
     * @see RegistryType
     */
    public final RegistryType type() {
        return RegistryType.fromValue(type);
    }

    /**
     * <p>
     * The kind of extension.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link RegistryType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The kind of extension.
     * @see RegistryType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The name of the extension.
     * </p>
     * 
     * @return The name of the extension.
     */
    public final String typeName() {
        return typeName;
    }

    /**
     * <p>
     * The ID of a specific version of the extension. The version ID is the value at the end of the Amazon Resource Name
     * (ARN) assigned to the extension version when it's registered.
     * </p>
     * 
     * @return The ID of a specific version of the extension. The version ID is the value at the end of the Amazon
     *         Resource Name (ARN) assigned to the extension version when it's registered.
     */
    public final String versionId() {
        return versionId;
    }

    /**
     * <p>
     * Whether the specified extension version is set as the default version.
     * </p>
     * <p>
     * This applies only to private extensions you have registered in your account, and extensions published by Amazon.
     * For public third-party extensions, CloudFormation returns <code>null</code>.
     * </p>
     * 
     * @return Whether the specified extension version is set as the default version.</p>
     *         <p>
     *         This applies only to private extensions you have registered in your account, and extensions published by
     *         Amazon. For public third-party extensions, CloudFormation returns <code>null</code>.
     */
    public final Boolean isDefaultVersion() {
        return isDefaultVersion;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the extension version.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the extension version.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * When the version was registered.
     * </p>
     * 
     * @return When the version was registered.
     */
    public final Instant timeCreated() {
        return timeCreated;
    }

    /**
     * <p>
     * The description of the extension version.
     * </p>
     * 
     * @return The description of the extension version.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * For public extensions that have been activated for this account and Region, the version of the public extension
     * to be used for CloudFormation operations in this account and Region. For any extensions other than activated
     * third-party extensions, CloudFormation returns <code>null</code>.
     * </p>
     * <p>
     * How you specified <code>AutoUpdate</code> when enabling the extension affects whether CloudFormation
     * automatically updates the extension in this account and Region when a new version is released. For more
     * information, see <a href=
     * "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/registry-public.html#registry-public-enable-auto"
     * >Automatically use new versions of extensions</a> in the <i>CloudFormation User Guide</i>.
     * </p>
     * 
     * @return For public extensions that have been activated for this account and Region, the version of the public
     *         extension to be used for CloudFormation operations in this account and Region. For any extensions other
     *         than activated third-party extensions, CloudFormation returns <code>null</code>.</p>
     *         <p>
     *         How you specified <code>AutoUpdate</code> when enabling the extension affects whether CloudFormation
     *         automatically updates the extension in this account and Region when a new version is released. For more
     *         information, see <a href=
     *         "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/registry-public.html#registry-public-enable-auto"
     *         >Automatically use new versions of extensions</a> in the <i>CloudFormation User Guide</i>.
     */
    public final String publicVersionNumber() {
        return publicVersionNumber;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(typeName());
        hashCode = 31 * hashCode + Objects.hashCode(versionId());
        hashCode = 31 * hashCode + Objects.hashCode(isDefaultVersion());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(timeCreated());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(publicVersionNumber());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TypeVersionSummary)) {
            return false;
        }
        TypeVersionSummary other = (TypeVersionSummary) obj;
        return Objects.equals(typeAsString(), other.typeAsString()) && Objects.equals(typeName(), other.typeName())
                && Objects.equals(versionId(), other.versionId()) && Objects.equals(isDefaultVersion(), other.isDefaultVersion())
                && Objects.equals(arn(), other.arn()) && Objects.equals(timeCreated(), other.timeCreated())
                && Objects.equals(description(), other.description())
                && Objects.equals(publicVersionNumber(), other.publicVersionNumber());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TypeVersionSummary").add("Type", typeAsString()).add("TypeName", typeName())
                .add("VersionId", versionId()).add("IsDefaultVersion", isDefaultVersion()).add("Arn", arn())
                .add("TimeCreated", timeCreated()).add("Description", description())
                .add("PublicVersionNumber", publicVersionNumber()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "TypeName":
            return Optional.ofNullable(clazz.cast(typeName()));
        case "VersionId":
            return Optional.ofNullable(clazz.cast(versionId()));
        case "IsDefaultVersion":
            return Optional.ofNullable(clazz.cast(isDefaultVersion()));
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "TimeCreated":
            return Optional.ofNullable(clazz.cast(timeCreated()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "PublicVersionNumber":
            return Optional.ofNullable(clazz.cast(publicVersionNumber()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Type", TYPE_FIELD);
        map.put("TypeName", TYPE_NAME_FIELD);
        map.put("VersionId", VERSION_ID_FIELD);
        map.put("IsDefaultVersion", IS_DEFAULT_VERSION_FIELD);
        map.put("Arn", ARN_FIELD);
        map.put("TimeCreated", TIME_CREATED_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("PublicVersionNumber", PUBLIC_VERSION_NUMBER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TypeVersionSummary, T> g) {
        return obj -> g.apply((TypeVersionSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TypeVersionSummary> {
        /**
         * <p>
         * The kind of extension.
         * </p>
         * 
         * @param type
         *        The kind of extension.
         * @see RegistryType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RegistryType
         */
        Builder type(String type);

        /**
         * <p>
         * The kind of extension.
         * </p>
         * 
         * @param type
         *        The kind of extension.
         * @see RegistryType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RegistryType
         */
        Builder type(RegistryType type);

        /**
         * <p>
         * The name of the extension.
         * </p>
         * 
         * @param typeName
         *        The name of the extension.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder typeName(String typeName);

        /**
         * <p>
         * The ID of a specific version of the extension. The version ID is the value at the end of the Amazon Resource
         * Name (ARN) assigned to the extension version when it's registered.
         * </p>
         * 
         * @param versionId
         *        The ID of a specific version of the extension. The version ID is the value at the end of the Amazon
         *        Resource Name (ARN) assigned to the extension version when it's registered.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder versionId(String versionId);

        /**
         * <p>
         * Whether the specified extension version is set as the default version.
         * </p>
         * <p>
         * This applies only to private extensions you have registered in your account, and extensions published by
         * Amazon. For public third-party extensions, CloudFormation returns <code>null</code>.
         * </p>
         * 
         * @param isDefaultVersion
         *        Whether the specified extension version is set as the default version.</p>
         *        <p>
         *        This applies only to private extensions you have registered in your account, and extensions published
         *        by Amazon. For public third-party extensions, CloudFormation returns <code>null</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isDefaultVersion(Boolean isDefaultVersion);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the extension version.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the extension version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * When the version was registered.
         * </p>
         * 
         * @param timeCreated
         *        When the version was registered.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timeCreated(Instant timeCreated);

        /**
         * <p>
         * The description of the extension version.
         * </p>
         * 
         * @param description
         *        The description of the extension version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * For public extensions that have been activated for this account and Region, the version of the public
         * extension to be used for CloudFormation operations in this account and Region. For any extensions other than
         * activated third-party extensions, CloudFormation returns <code>null</code>.
         * </p>
         * <p>
         * How you specified <code>AutoUpdate</code> when enabling the extension affects whether CloudFormation
         * automatically updates the extension in this account and Region when a new version is released. For more
         * information, see <a href=
         * "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/registry-public.html#registry-public-enable-auto"
         * >Automatically use new versions of extensions</a> in the <i>CloudFormation User Guide</i>.
         * </p>
         * 
         * @param publicVersionNumber
         *        For public extensions that have been activated for this account and Region, the version of the public
         *        extension to be used for CloudFormation operations in this account and Region. For any extensions
         *        other than activated third-party extensions, CloudFormation returns <code>null</code>.</p>
         *        <p>
         *        How you specified <code>AutoUpdate</code> when enabling the extension affects whether CloudFormation
         *        automatically updates the extension in this account and Region when a new version is released. For
         *        more information, see <a href=
         *        "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/registry-public.html#registry-public-enable-auto"
         *        >Automatically use new versions of extensions</a> in the <i>CloudFormation User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder publicVersionNumber(String publicVersionNumber);
    }

    static final class BuilderImpl implements Builder {
        private String type;

        private String typeName;

        private String versionId;

        private Boolean isDefaultVersion;

        private String arn;

        private Instant timeCreated;

        private String description;

        private String publicVersionNumber;

        private BuilderImpl() {
        }

        private BuilderImpl(TypeVersionSummary model) {
            type(model.type);
            typeName(model.typeName);
            versionId(model.versionId);
            isDefaultVersion(model.isDefaultVersion);
            arn(model.arn);
            timeCreated(model.timeCreated);
            description(model.description);
            publicVersionNumber(model.publicVersionNumber);
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(RegistryType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getTypeName() {
            return typeName;
        }

        public final void setTypeName(String typeName) {
            this.typeName = typeName;
        }

        @Override
        public final Builder typeName(String typeName) {
            this.typeName = typeName;
            return this;
        }

        public final String getVersionId() {
            return versionId;
        }

        public final void setVersionId(String versionId) {
            this.versionId = versionId;
        }

        @Override
        public final Builder versionId(String versionId) {
            this.versionId = versionId;
            return this;
        }

        public final Boolean getIsDefaultVersion() {
            return isDefaultVersion;
        }

        public final void setIsDefaultVersion(Boolean isDefaultVersion) {
            this.isDefaultVersion = isDefaultVersion;
        }

        @Override
        public final Builder isDefaultVersion(Boolean isDefaultVersion) {
            this.isDefaultVersion = isDefaultVersion;
            return this;
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final Instant getTimeCreated() {
            return timeCreated;
        }

        public final void setTimeCreated(Instant timeCreated) {
            this.timeCreated = timeCreated;
        }

        @Override
        public final Builder timeCreated(Instant timeCreated) {
            this.timeCreated = timeCreated;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getPublicVersionNumber() {
            return publicVersionNumber;
        }

        public final void setPublicVersionNumber(String publicVersionNumber) {
            this.publicVersionNumber = publicVersionNumber;
        }

        @Override
        public final Builder publicVersionNumber(String publicVersionNumber) {
            this.publicVersionNumber = publicVersionNumber;
            return this;
        }

        @Override
        public TypeVersionSummary build() {
            return new TypeVersionSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
