/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudformation.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The input for the <a>SetStackPolicy</a> action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SetStackPolicyRequest extends CloudFormationRequest implements
        ToCopyableBuilder<SetStackPolicyRequest.Builder, SetStackPolicyRequest> {
    private static final SdkField<String> STACK_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StackName").getter(getter(SetStackPolicyRequest::stackName)).setter(setter(Builder::stackName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StackName").build()).build();

    private static final SdkField<String> STACK_POLICY_BODY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StackPolicyBody").getter(getter(SetStackPolicyRequest::stackPolicyBody))
            .setter(setter(Builder::stackPolicyBody))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StackPolicyBody").build()).build();

    private static final SdkField<String> STACK_POLICY_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StackPolicyURL").getter(getter(SetStackPolicyRequest::stackPolicyURL))
            .setter(setter(Builder::stackPolicyURL))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StackPolicyURL").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STACK_NAME_FIELD,
            STACK_POLICY_BODY_FIELD, STACK_POLICY_URL_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String stackName;

    private final String stackPolicyBody;

    private final String stackPolicyURL;

    private SetStackPolicyRequest(BuilderImpl builder) {
        super(builder);
        this.stackName = builder.stackName;
        this.stackPolicyBody = builder.stackPolicyBody;
        this.stackPolicyURL = builder.stackPolicyURL;
    }

    /**
     * <p>
     * The name or unique stack ID that you want to associate a policy with.
     * </p>
     * 
     * @return The name or unique stack ID that you want to associate a policy with.
     */
    public final String stackName() {
        return stackName;
    }

    /**
     * <p>
     * Structure containing the stack policy body. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/protect-stack-resources.html">Prevent
     * updates to stack resources</a> in the <i>CloudFormation User Guide</i>. You can specify either the
     * <code>StackPolicyBody</code> or the <code>StackPolicyURL</code> parameter, but not both.
     * </p>
     * 
     * @return Structure containing the stack policy body. For more information, see <a
     *         href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/protect-stack-resources.html"
     *         >Prevent updates to stack resources</a> in the <i>CloudFormation User Guide</i>. You can specify either
     *         the <code>StackPolicyBody</code> or the <code>StackPolicyURL</code> parameter, but not both.
     */
    public final String stackPolicyBody() {
        return stackPolicyBody;
    }

    /**
     * <p>
     * Location of a file containing the stack policy. The URL must point to a policy (maximum size: 16 KB) located in
     * an Amazon S3 bucket in the same Amazon Web Services Region as the stack. The location for an Amazon S3 bucket
     * must start with <code>https://</code>. You can specify either the <code>StackPolicyBody</code> or the
     * <code>StackPolicyURL</code> parameter, but not both.
     * </p>
     * 
     * @return Location of a file containing the stack policy. The URL must point to a policy (maximum size: 16 KB)
     *         located in an Amazon S3 bucket in the same Amazon Web Services Region as the stack. The location for an
     *         Amazon S3 bucket must start with <code>https://</code>. You can specify either the
     *         <code>StackPolicyBody</code> or the <code>StackPolicyURL</code> parameter, but not both.
     */
    public final String stackPolicyURL() {
        return stackPolicyURL;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(stackName());
        hashCode = 31 * hashCode + Objects.hashCode(stackPolicyBody());
        hashCode = 31 * hashCode + Objects.hashCode(stackPolicyURL());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SetStackPolicyRequest)) {
            return false;
        }
        SetStackPolicyRequest other = (SetStackPolicyRequest) obj;
        return Objects.equals(stackName(), other.stackName()) && Objects.equals(stackPolicyBody(), other.stackPolicyBody())
                && Objects.equals(stackPolicyURL(), other.stackPolicyURL());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SetStackPolicyRequest").add("StackName", stackName()).add("StackPolicyBody", stackPolicyBody())
                .add("StackPolicyURL", stackPolicyURL()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StackName":
            return Optional.ofNullable(clazz.cast(stackName()));
        case "StackPolicyBody":
            return Optional.ofNullable(clazz.cast(stackPolicyBody()));
        case "StackPolicyURL":
            return Optional.ofNullable(clazz.cast(stackPolicyURL()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("StackName", STACK_NAME_FIELD);
        map.put("StackPolicyBody", STACK_POLICY_BODY_FIELD);
        map.put("StackPolicyURL", STACK_POLICY_URL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SetStackPolicyRequest, T> g) {
        return obj -> g.apply((SetStackPolicyRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends CloudFormationRequest.Builder, SdkPojo, CopyableBuilder<Builder, SetStackPolicyRequest> {
        /**
         * <p>
         * The name or unique stack ID that you want to associate a policy with.
         * </p>
         * 
         * @param stackName
         *        The name or unique stack ID that you want to associate a policy with.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stackName(String stackName);

        /**
         * <p>
         * Structure containing the stack policy body. For more information, see <a
         * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/protect-stack-resources.html">Prevent
         * updates to stack resources</a> in the <i>CloudFormation User Guide</i>. You can specify either the
         * <code>StackPolicyBody</code> or the <code>StackPolicyURL</code> parameter, but not both.
         * </p>
         * 
         * @param stackPolicyBody
         *        Structure containing the stack policy body. For more information, see <a
         *        href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/protect-stack-resources.html"
         *        >Prevent updates to stack resources</a> in the <i>CloudFormation User Guide</i>. You can specify
         *        either the <code>StackPolicyBody</code> or the <code>StackPolicyURL</code> parameter, but not both.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stackPolicyBody(String stackPolicyBody);

        /**
         * <p>
         * Location of a file containing the stack policy. The URL must point to a policy (maximum size: 16 KB) located
         * in an Amazon S3 bucket in the same Amazon Web Services Region as the stack. The location for an Amazon S3
         * bucket must start with <code>https://</code>. You can specify either the <code>StackPolicyBody</code> or the
         * <code>StackPolicyURL</code> parameter, but not both.
         * </p>
         * 
         * @param stackPolicyURL
         *        Location of a file containing the stack policy. The URL must point to a policy (maximum size: 16 KB)
         *        located in an Amazon S3 bucket in the same Amazon Web Services Region as the stack. The location for
         *        an Amazon S3 bucket must start with <code>https://</code>. You can specify either the
         *        <code>StackPolicyBody</code> or the <code>StackPolicyURL</code> parameter, but not both.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stackPolicyURL(String stackPolicyURL);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CloudFormationRequest.BuilderImpl implements Builder {
        private String stackName;

        private String stackPolicyBody;

        private String stackPolicyURL;

        private BuilderImpl() {
        }

        private BuilderImpl(SetStackPolicyRequest model) {
            super(model);
            stackName(model.stackName);
            stackPolicyBody(model.stackPolicyBody);
            stackPolicyURL(model.stackPolicyURL);
        }

        public final String getStackName() {
            return stackName;
        }

        public final void setStackName(String stackName) {
            this.stackName = stackName;
        }

        @Override
        public final Builder stackName(String stackName) {
            this.stackName = stackName;
            return this;
        }

        public final String getStackPolicyBody() {
            return stackPolicyBody;
        }

        public final void setStackPolicyBody(String stackPolicyBody) {
            this.stackPolicyBody = stackPolicyBody;
        }

        @Override
        public final Builder stackPolicyBody(String stackPolicyBody) {
            this.stackPolicyBody = stackPolicyBody;
            return this;
        }

        public final String getStackPolicyURL() {
            return stackPolicyURL;
        }

        public final void setStackPolicyURL(String stackPolicyURL) {
            this.stackPolicyURL = stackPolicyURL;
        }

        @Override
        public final Builder stackPolicyURL(String stackPolicyURL) {
            this.stackPolicyURL = stackPolicyURL;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public SetStackPolicyRequest build() {
            return new SetStackPolicyRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
