/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudformation.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetGeneratedTemplateRequest extends CloudFormationRequest implements
        ToCopyableBuilder<GetGeneratedTemplateRequest.Builder, GetGeneratedTemplateRequest> {
    private static final SdkField<String> FORMAT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Format")
            .getter(getter(GetGeneratedTemplateRequest::formatAsString)).setter(setter(Builder::format))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Format").build()).build();

    private static final SdkField<String> GENERATED_TEMPLATE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GeneratedTemplateName").getter(getter(GetGeneratedTemplateRequest::generatedTemplateName))
            .setter(setter(Builder::generatedTemplateName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GeneratedTemplateName").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FORMAT_FIELD,
            GENERATED_TEMPLATE_NAME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String format;

    private final String generatedTemplateName;

    private GetGeneratedTemplateRequest(BuilderImpl builder) {
        super(builder);
        this.format = builder.format;
        this.generatedTemplateName = builder.generatedTemplateName;
    }

    /**
     * <p>
     * The language to use to retrieve for the generated template. Supported values are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>JSON</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>YAML</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #format} will
     * return {@link TemplateFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #formatAsString}.
     * </p>
     * 
     * @return The language to use to retrieve for the generated template. Supported values are:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>JSON</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>YAML</code>
     *         </p>
     *         </li>
     * @see TemplateFormat
     */
    public final TemplateFormat format() {
        return TemplateFormat.fromValue(format);
    }

    /**
     * <p>
     * The language to use to retrieve for the generated template. Supported values are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>JSON</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>YAML</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #format} will
     * return {@link TemplateFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #formatAsString}.
     * </p>
     * 
     * @return The language to use to retrieve for the generated template. Supported values are:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>JSON</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>YAML</code>
     *         </p>
     *         </li>
     * @see TemplateFormat
     */
    public final String formatAsString() {
        return format;
    }

    /**
     * <p>
     * The name or Amazon Resource Name (ARN) of the generated template. The format is
     * <code>arn:${Partition}:cloudformation:${Region}:${Account}:generatedtemplate/${Id}</code>. For example,
     * <code>arn:aws:cloudformation:<i>us-east-1</i>:<i>123456789012</i>:generatedtemplate/<i>2e8465c1-9a80-43ea-a3a3-4f2d692fe6dc</i> </code>
     * .
     * </p>
     * 
     * @return The name or Amazon Resource Name (ARN) of the generated template. The format is
     *         <code>arn:${Partition}:cloudformation:${Region}:${Account}:generatedtemplate/${Id}</code>. For example,
     *         <code>arn:aws:cloudformation:<i>us-east-1</i>:<i>123456789012</i>:generatedtemplate/<i>2e8465c1-9a80-43ea-a3a3-4f2d692fe6dc</i> </code>
     *         .
     */
    public final String generatedTemplateName() {
        return generatedTemplateName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(formatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(generatedTemplateName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetGeneratedTemplateRequest)) {
            return false;
        }
        GetGeneratedTemplateRequest other = (GetGeneratedTemplateRequest) obj;
        return Objects.equals(formatAsString(), other.formatAsString())
                && Objects.equals(generatedTemplateName(), other.generatedTemplateName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetGeneratedTemplateRequest").add("Format", formatAsString())
                .add("GeneratedTemplateName", generatedTemplateName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Format":
            return Optional.ofNullable(clazz.cast(formatAsString()));
        case "GeneratedTemplateName":
            return Optional.ofNullable(clazz.cast(generatedTemplateName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Format", FORMAT_FIELD);
        map.put("GeneratedTemplateName", GENERATED_TEMPLATE_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetGeneratedTemplateRequest, T> g) {
        return obj -> g.apply((GetGeneratedTemplateRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudFormationRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, GetGeneratedTemplateRequest> {
        /**
         * <p>
         * The language to use to retrieve for the generated template. Supported values are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>JSON</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>YAML</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param format
         *        The language to use to retrieve for the generated template. Supported values are:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>JSON</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>YAML</code>
         *        </p>
         *        </li>
         * @see TemplateFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TemplateFormat
         */
        Builder format(String format);

        /**
         * <p>
         * The language to use to retrieve for the generated template. Supported values are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>JSON</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>YAML</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param format
         *        The language to use to retrieve for the generated template. Supported values are:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>JSON</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>YAML</code>
         *        </p>
         *        </li>
         * @see TemplateFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TemplateFormat
         */
        Builder format(TemplateFormat format);

        /**
         * <p>
         * The name or Amazon Resource Name (ARN) of the generated template. The format is
         * <code>arn:${Partition}:cloudformation:${Region}:${Account}:generatedtemplate/${Id}</code>. For example,
         * <code>arn:aws:cloudformation:<i>us-east-1</i>:<i>123456789012</i>:generatedtemplate/<i>2e8465c1-9a80-43ea-a3a3-4f2d692fe6dc</i> </code>
         * .
         * </p>
         * 
         * @param generatedTemplateName
         *        The name or Amazon Resource Name (ARN) of the generated template. The format is
         *        <code>arn:${Partition}:cloudformation:${Region}:${Account}:generatedtemplate/${Id}</code>. For
         *        example,
         *        <code>arn:aws:cloudformation:<i>us-east-1</i>:<i>123456789012</i>:generatedtemplate/<i>2e8465c1-9a80-43ea-a3a3-4f2d692fe6dc</i> </code>
         *        .
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder generatedTemplateName(String generatedTemplateName);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CloudFormationRequest.BuilderImpl implements Builder {
        private String format;

        private String generatedTemplateName;

        private BuilderImpl() {
        }

        private BuilderImpl(GetGeneratedTemplateRequest model) {
            super(model);
            format(model.format);
            generatedTemplateName(model.generatedTemplateName);
        }

        public final String getFormat() {
            return format;
        }

        public final void setFormat(String format) {
            this.format = format;
        }

        @Override
        public final Builder format(String format) {
            this.format = format;
            return this;
        }

        @Override
        public final Builder format(TemplateFormat format) {
            this.format(format == null ? null : format.toString());
            return this;
        }

        public final String getGeneratedTemplateName() {
            return generatedTemplateName;
        }

        public final void setGeneratedTemplateName(String generatedTemplateName) {
            this.generatedTemplateName = generatedTemplateName;
        }

        @Override
        public final Builder generatedTemplateName(String generatedTemplateName) {
            this.generatedTemplateName = generatedTemplateName;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetGeneratedTemplateRequest build() {
            return new GetGeneratedTemplateRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
