/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudformation.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The input for <a>ListStacks</a> action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListStacksRequest extends CloudFormationRequest implements
        ToCopyableBuilder<ListStacksRequest.Builder, ListStacksRequest> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListStacksRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<List<String>> STACK_STATUS_FILTERS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("stackStatusFilters")
            .getter(getter(ListStacksRequest::stackStatusFiltersAsStrings))
            .setter(setter(Builder::stackStatusFiltersWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StackStatusFilter").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            STACK_STATUS_FILTERS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String nextToken;

    private final List<String> stackStatusFilters;

    private ListStacksRequest(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.stackStatusFilters = builder.stackStatusFilters;
    }

    /**
     * <p>
     * A string that identifies the next page of stacks that you want to retrieve.
     * </p>
     * 
     * @return A string that identifies the next page of stacks that you want to retrieve.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * Stack status to use as a filter. Specify one or more stack status codes to list only stacks with the specified
     * status codes. For a complete list of stack status codes, see the <code>StackStatus</code> parameter of the
     * <a>Stack</a> data type.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasStackStatusFilters} method.
     * </p>
     * 
     * @return Stack status to use as a filter. Specify one or more stack status codes to list only stacks with the
     *         specified status codes. For a complete list of stack status codes, see the <code>StackStatus</code>
     *         parameter of the <a>Stack</a> data type.
     */
    public final List<StackStatus> stackStatusFilters() {
        return StackStatusFilterCopier.copyStringToEnum(stackStatusFilters);
    }

    /**
     * For responses, this returns true if the service returned a value for the StackStatusFilters property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasStackStatusFilters() {
        return stackStatusFilters != null && !(stackStatusFilters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Stack status to use as a filter. Specify one or more stack status codes to list only stacks with the specified
     * status codes. For a complete list of stack status codes, see the <code>StackStatus</code> parameter of the
     * <a>Stack</a> data type.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasStackStatusFilters} method.
     * </p>
     * 
     * @return Stack status to use as a filter. Specify one or more stack status codes to list only stacks with the
     *         specified status codes. For a complete list of stack status codes, see the <code>StackStatus</code>
     *         parameter of the <a>Stack</a> data type.
     */
    public final List<String> stackStatusFiltersAsStrings() {
        return stackStatusFilters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasStackStatusFilters() ? stackStatusFiltersAsStrings() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListStacksRequest)) {
            return false;
        }
        ListStacksRequest other = (ListStacksRequest) obj;
        return Objects.equals(nextToken(), other.nextToken()) && hasStackStatusFilters() == other.hasStackStatusFilters()
                && Objects.equals(stackStatusFiltersAsStrings(), other.stackStatusFiltersAsStrings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListStacksRequest").add("NextToken", nextToken())
                .add("StackStatusFilters", hasStackStatusFilters() ? stackStatusFiltersAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "stackStatusFilters":
            return Optional.ofNullable(clazz.cast(stackStatusFiltersAsStrings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("StackStatusFilter", STACK_STATUS_FILTERS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListStacksRequest, T> g) {
        return obj -> g.apply((ListStacksRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends CloudFormationRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListStacksRequest> {
        /**
         * <p>
         * A string that identifies the next page of stacks that you want to retrieve.
         * </p>
         * 
         * @param nextToken
         *        A string that identifies the next page of stacks that you want to retrieve.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * Stack status to use as a filter. Specify one or more stack status codes to list only stacks with the
         * specified status codes. For a complete list of stack status codes, see the <code>StackStatus</code> parameter
         * of the <a>Stack</a> data type.
         * </p>
         * 
         * @param stackStatusFilters
         *        Stack status to use as a filter. Specify one or more stack status codes to list only stacks with the
         *        specified status codes. For a complete list of stack status codes, see the <code>StackStatus</code>
         *        parameter of the <a>Stack</a> data type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stackStatusFiltersWithStrings(Collection<String> stackStatusFilters);

        /**
         * <p>
         * Stack status to use as a filter. Specify one or more stack status codes to list only stacks with the
         * specified status codes. For a complete list of stack status codes, see the <code>StackStatus</code> parameter
         * of the <a>Stack</a> data type.
         * </p>
         * 
         * @param stackStatusFilters
         *        Stack status to use as a filter. Specify one or more stack status codes to list only stacks with the
         *        specified status codes. For a complete list of stack status codes, see the <code>StackStatus</code>
         *        parameter of the <a>Stack</a> data type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stackStatusFiltersWithStrings(String... stackStatusFilters);

        /**
         * <p>
         * Stack status to use as a filter. Specify one or more stack status codes to list only stacks with the
         * specified status codes. For a complete list of stack status codes, see the <code>StackStatus</code> parameter
         * of the <a>Stack</a> data type.
         * </p>
         * 
         * @param stackStatusFilters
         *        Stack status to use as a filter. Specify one or more stack status codes to list only stacks with the
         *        specified status codes. For a complete list of stack status codes, see the <code>StackStatus</code>
         *        parameter of the <a>Stack</a> data type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stackStatusFilters(Collection<StackStatus> stackStatusFilters);

        /**
         * <p>
         * Stack status to use as a filter. Specify one or more stack status codes to list only stacks with the
         * specified status codes. For a complete list of stack status codes, see the <code>StackStatus</code> parameter
         * of the <a>Stack</a> data type.
         * </p>
         * 
         * @param stackStatusFilters
         *        Stack status to use as a filter. Specify one or more stack status codes to list only stacks with the
         *        specified status codes. For a complete list of stack status codes, see the <code>StackStatus</code>
         *        parameter of the <a>Stack</a> data type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stackStatusFilters(StackStatus... stackStatusFilters);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CloudFormationRequest.BuilderImpl implements Builder {
        private String nextToken;

        private List<String> stackStatusFilters = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListStacksRequest model) {
            super(model);
            nextToken(model.nextToken);
            stackStatusFiltersWithStrings(model.stackStatusFilters);
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Collection<String> getStackStatusFilters() {
            if (stackStatusFilters instanceof SdkAutoConstructList) {
                return null;
            }
            return stackStatusFilters;
        }

        public final void setStackStatusFilters(Collection<String> stackStatusFilters) {
            this.stackStatusFilters = StackStatusFilterCopier.copy(stackStatusFilters);
        }

        @Override
        public final Builder stackStatusFiltersWithStrings(Collection<String> stackStatusFilters) {
            this.stackStatusFilters = StackStatusFilterCopier.copy(stackStatusFilters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stackStatusFiltersWithStrings(String... stackStatusFilters) {
            stackStatusFiltersWithStrings(Arrays.asList(stackStatusFilters));
            return this;
        }

        @Override
        public final Builder stackStatusFilters(Collection<StackStatus> stackStatusFilters) {
            this.stackStatusFilters = StackStatusFilterCopier.copyEnumToString(stackStatusFilters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stackStatusFilters(StackStatus... stackStatusFilters) {
            stackStatusFilters(Arrays.asList(stackStatusFilters));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListStacksRequest build() {
            return new ListStacksRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
