/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudformation.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies the current source of the resource and the destination of where it will be moved to.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ResourceMapping implements SdkPojo, Serializable, ToCopyableBuilder<ResourceMapping.Builder, ResourceMapping> {
    private static final SdkField<ResourceLocation> SOURCE_FIELD = SdkField.<ResourceLocation> builder(MarshallingType.SDK_POJO)
            .memberName("Source").getter(getter(ResourceMapping::source)).setter(setter(Builder::source))
            .constructor(ResourceLocation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Source").build()).build();

    private static final SdkField<ResourceLocation> DESTINATION_FIELD = SdkField
            .<ResourceLocation> builder(MarshallingType.SDK_POJO).memberName("Destination")
            .getter(getter(ResourceMapping::destination)).setter(setter(Builder::destination))
            .constructor(ResourceLocation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Destination").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_FIELD,
            DESTINATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final ResourceLocation source;

    private final ResourceLocation destination;

    private ResourceMapping(BuilderImpl builder) {
        this.source = builder.source;
        this.destination = builder.destination;
    }

    /**
     * <p>
     * The source stack <code>StackName</code> and <code>LogicalResourceId</code> for the resource being refactored.
     * </p>
     * 
     * @return The source stack <code>StackName</code> and <code>LogicalResourceId</code> for the resource being
     *         refactored.
     */
    public final ResourceLocation source() {
        return source;
    }

    /**
     * <p>
     * The destination stack <code>StackName</code> and <code>LogicalResourceId</code> for the resource being
     * refactored.
     * </p>
     * 
     * @return The destination stack <code>StackName</code> and <code>LogicalResourceId</code> for the resource being
     *         refactored.
     */
    public final ResourceLocation destination() {
        return destination;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(source());
        hashCode = 31 * hashCode + Objects.hashCode(destination());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourceMapping)) {
            return false;
        }
        ResourceMapping other = (ResourceMapping) obj;
        return Objects.equals(source(), other.source()) && Objects.equals(destination(), other.destination());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ResourceMapping").add("Source", source()).add("Destination", destination()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Source":
            return Optional.ofNullable(clazz.cast(source()));
        case "Destination":
            return Optional.ofNullable(clazz.cast(destination()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Source", SOURCE_FIELD);
        map.put("Destination", DESTINATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ResourceMapping, T> g) {
        return obj -> g.apply((ResourceMapping) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ResourceMapping> {
        /**
         * <p>
         * The source stack <code>StackName</code> and <code>LogicalResourceId</code> for the resource being refactored.
         * </p>
         * 
         * @param source
         *        The source stack <code>StackName</code> and <code>LogicalResourceId</code> for the resource being
         *        refactored.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder source(ResourceLocation source);

        /**
         * <p>
         * The source stack <code>StackName</code> and <code>LogicalResourceId</code> for the resource being refactored.
         * </p>
         * This is a convenience method that creates an instance of the {@link ResourceLocation.Builder} avoiding the
         * need to create one manually via {@link ResourceLocation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ResourceLocation.Builder#build()} is called immediately and its
         * result is passed to {@link #source(ResourceLocation)}.
         * 
         * @param source
         *        a consumer that will call methods on {@link ResourceLocation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #source(ResourceLocation)
         */
        default Builder source(Consumer<ResourceLocation.Builder> source) {
            return source(ResourceLocation.builder().applyMutation(source).build());
        }

        /**
         * <p>
         * The destination stack <code>StackName</code> and <code>LogicalResourceId</code> for the resource being
         * refactored.
         * </p>
         * 
         * @param destination
         *        The destination stack <code>StackName</code> and <code>LogicalResourceId</code> for the resource being
         *        refactored.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destination(ResourceLocation destination);

        /**
         * <p>
         * The destination stack <code>StackName</code> and <code>LogicalResourceId</code> for the resource being
         * refactored.
         * </p>
         * This is a convenience method that creates an instance of the {@link ResourceLocation.Builder} avoiding the
         * need to create one manually via {@link ResourceLocation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ResourceLocation.Builder#build()} is called immediately and its
         * result is passed to {@link #destination(ResourceLocation)}.
         * 
         * @param destination
         *        a consumer that will call methods on {@link ResourceLocation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #destination(ResourceLocation)
         */
        default Builder destination(Consumer<ResourceLocation.Builder> destination) {
            return destination(ResourceLocation.builder().applyMutation(destination).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private ResourceLocation source;

        private ResourceLocation destination;

        private BuilderImpl() {
        }

        private BuilderImpl(ResourceMapping model) {
            source(model.source);
            destination(model.destination);
        }

        public final ResourceLocation.Builder getSource() {
            return source != null ? source.toBuilder() : null;
        }

        public final void setSource(ResourceLocation.BuilderImpl source) {
            this.source = source != null ? source.build() : null;
        }

        @Override
        public final Builder source(ResourceLocation source) {
            this.source = source;
            return this;
        }

        public final ResourceLocation.Builder getDestination() {
            return destination != null ? destination.toBuilder() : null;
        }

        public final void setDestination(ResourceLocation.BuilderImpl destination) {
            this.destination = destination != null ? destination.build() : null;
        }

        @Override
        public final Builder destination(ResourceLocation destination) {
            this.destination = destination;
            return this;
        }

        @Override
        public ResourceMapping build() {
            return new ResourceMapping(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
