/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudformation.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The <code>ChangeSetSummary</code> structure describes a change set, its status, and the stack with which it's
 * associated.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ChangeSetSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<ChangeSetSummary.Builder, ChangeSetSummary> {
    private static final SdkField<String> STACK_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StackId").getter(getter(ChangeSetSummary::stackId)).setter(setter(Builder::stackId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StackId").build()).build();

    private static final SdkField<String> STACK_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StackName").getter(getter(ChangeSetSummary::stackName)).setter(setter(Builder::stackName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StackName").build()).build();

    private static final SdkField<String> CHANGE_SET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ChangeSetId").getter(getter(ChangeSetSummary::changeSetId)).setter(setter(Builder::changeSetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChangeSetId").build()).build();

    private static final SdkField<String> CHANGE_SET_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ChangeSetName").getter(getter(ChangeSetSummary::changeSetName)).setter(setter(Builder::changeSetName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChangeSetName").build()).build();

    private static final SdkField<String> EXECUTION_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ExecutionStatus").getter(getter(ChangeSetSummary::executionStatusAsString))
            .setter(setter(Builder::executionStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecutionStatus").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(ChangeSetSummary::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> STATUS_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StatusReason").getter(getter(ChangeSetSummary::statusReason)).setter(setter(Builder::statusReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusReason").build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTime").getter(getter(ChangeSetSummary::creationTime)).setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(ChangeSetSummary::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<Boolean> INCLUDE_NESTED_STACKS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("IncludeNestedStacks").getter(getter(ChangeSetSummary::includeNestedStacks))
            .setter(setter(Builder::includeNestedStacks))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IncludeNestedStacks").build())
            .build();

    private static final SdkField<String> PARENT_CHANGE_SET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ParentChangeSetId").getter(getter(ChangeSetSummary::parentChangeSetId))
            .setter(setter(Builder::parentChangeSetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParentChangeSetId").build()).build();

    private static final SdkField<String> ROOT_CHANGE_SET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RootChangeSetId").getter(getter(ChangeSetSummary::rootChangeSetId))
            .setter(setter(Builder::rootChangeSetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RootChangeSetId").build()).build();

    private static final SdkField<Boolean> IMPORT_EXISTING_RESOURCES_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("ImportExistingResources").getter(getter(ChangeSetSummary::importExistingResources))
            .setter(setter(Builder::importExistingResources))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImportExistingResources").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STACK_ID_FIELD,
            STACK_NAME_FIELD, CHANGE_SET_ID_FIELD, CHANGE_SET_NAME_FIELD, EXECUTION_STATUS_FIELD, STATUS_FIELD,
            STATUS_REASON_FIELD, CREATION_TIME_FIELD, DESCRIPTION_FIELD, INCLUDE_NESTED_STACKS_FIELD, PARENT_CHANGE_SET_ID_FIELD,
            ROOT_CHANGE_SET_ID_FIELD, IMPORT_EXISTING_RESOURCES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String stackId;

    private final String stackName;

    private final String changeSetId;

    private final String changeSetName;

    private final String executionStatus;

    private final String status;

    private final String statusReason;

    private final Instant creationTime;

    private final String description;

    private final Boolean includeNestedStacks;

    private final String parentChangeSetId;

    private final String rootChangeSetId;

    private final Boolean importExistingResources;

    private ChangeSetSummary(BuilderImpl builder) {
        this.stackId = builder.stackId;
        this.stackName = builder.stackName;
        this.changeSetId = builder.changeSetId;
        this.changeSetName = builder.changeSetName;
        this.executionStatus = builder.executionStatus;
        this.status = builder.status;
        this.statusReason = builder.statusReason;
        this.creationTime = builder.creationTime;
        this.description = builder.description;
        this.includeNestedStacks = builder.includeNestedStacks;
        this.parentChangeSetId = builder.parentChangeSetId;
        this.rootChangeSetId = builder.rootChangeSetId;
        this.importExistingResources = builder.importExistingResources;
    }

    /**
     * <p>
     * The ID of the stack with which the change set is associated.
     * </p>
     * 
     * @return The ID of the stack with which the change set is associated.
     */
    public final String stackId() {
        return stackId;
    }

    /**
     * <p>
     * The name of the stack with which the change set is associated.
     * </p>
     * 
     * @return The name of the stack with which the change set is associated.
     */
    public final String stackName() {
        return stackName;
    }

    /**
     * <p>
     * The ID of the change set.
     * </p>
     * 
     * @return The ID of the change set.
     */
    public final String changeSetId() {
        return changeSetId;
    }

    /**
     * <p>
     * The name of the change set.
     * </p>
     * 
     * @return The name of the change set.
     */
    public final String changeSetName() {
        return changeSetName;
    }

    /**
     * <p>
     * If the change set execution status is <code>AVAILABLE</code>, you can execute the change set. If you can't
     * execute the change set, the status indicates why. For example, a change set might be in an
     * <code>UNAVAILABLE</code> state because CloudFormation is still creating it or in an <code>OBSOLETE</code> state
     * because the stack was already updated.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #executionStatus}
     * will return {@link ExecutionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #executionStatusAsString}.
     * </p>
     * 
     * @return If the change set execution status is <code>AVAILABLE</code>, you can execute the change set. If you
     *         can't execute the change set, the status indicates why. For example, a change set might be in an
     *         <code>UNAVAILABLE</code> state because CloudFormation is still creating it or in an <code>OBSOLETE</code>
     *         state because the stack was already updated.
     * @see ExecutionStatus
     */
    public final ExecutionStatus executionStatus() {
        return ExecutionStatus.fromValue(executionStatus);
    }

    /**
     * <p>
     * If the change set execution status is <code>AVAILABLE</code>, you can execute the change set. If you can't
     * execute the change set, the status indicates why. For example, a change set might be in an
     * <code>UNAVAILABLE</code> state because CloudFormation is still creating it or in an <code>OBSOLETE</code> state
     * because the stack was already updated.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #executionStatus}
     * will return {@link ExecutionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #executionStatusAsString}.
     * </p>
     * 
     * @return If the change set execution status is <code>AVAILABLE</code>, you can execute the change set. If you
     *         can't execute the change set, the status indicates why. For example, a change set might be in an
     *         <code>UNAVAILABLE</code> state because CloudFormation is still creating it or in an <code>OBSOLETE</code>
     *         state because the stack was already updated.
     * @see ExecutionStatus
     */
    public final String executionStatusAsString() {
        return executionStatus;
    }

    /**
     * <p>
     * The state of the change set, such as <code>CREATE_PENDING</code>, <code>CREATE_COMPLETE</code>, or
     * <code>FAILED</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ChangeSetStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The state of the change set, such as <code>CREATE_PENDING</code>, <code>CREATE_COMPLETE</code>, or
     *         <code>FAILED</code>.
     * @see ChangeSetStatus
     */
    public final ChangeSetStatus status() {
        return ChangeSetStatus.fromValue(status);
    }

    /**
     * <p>
     * The state of the change set, such as <code>CREATE_PENDING</code>, <code>CREATE_COMPLETE</code>, or
     * <code>FAILED</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ChangeSetStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The state of the change set, such as <code>CREATE_PENDING</code>, <code>CREATE_COMPLETE</code>, or
     *         <code>FAILED</code>.
     * @see ChangeSetStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * A description of the change set's status. For example, if your change set is in the <code>FAILED</code> state,
     * CloudFormation shows the error message.
     * </p>
     * 
     * @return A description of the change set's status. For example, if your change set is in the <code>FAILED</code>
     *         state, CloudFormation shows the error message.
     */
    public final String statusReason() {
        return statusReason;
    }

    /**
     * <p>
     * The start time when the change set was created, in UTC.
     * </p>
     * 
     * @return The start time when the change set was created, in UTC.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * Descriptive information about the change set.
     * </p>
     * 
     * @return Descriptive information about the change set.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * Specifies the current setting of <code>IncludeNestedStacks</code> for the change set.
     * </p>
     * 
     * @return Specifies the current setting of <code>IncludeNestedStacks</code> for the change set.
     */
    public final Boolean includeNestedStacks() {
        return includeNestedStacks;
    }

    /**
     * <p>
     * The parent change set ID.
     * </p>
     * 
     * @return The parent change set ID.
     */
    public final String parentChangeSetId() {
        return parentChangeSetId;
    }

    /**
     * <p>
     * The root change set ID.
     * </p>
     * 
     * @return The root change set ID.
     */
    public final String rootChangeSetId() {
        return rootChangeSetId;
    }

    /**
     * <p>
     * Indicates if the change set imports resources that already exist.
     * </p>
     * 
     * @return Indicates if the change set imports resources that already exist.
     */
    public final Boolean importExistingResources() {
        return importExistingResources;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(stackId());
        hashCode = 31 * hashCode + Objects.hashCode(stackName());
        hashCode = 31 * hashCode + Objects.hashCode(changeSetId());
        hashCode = 31 * hashCode + Objects.hashCode(changeSetName());
        hashCode = 31 * hashCode + Objects.hashCode(executionStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusReason());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(includeNestedStacks());
        hashCode = 31 * hashCode + Objects.hashCode(parentChangeSetId());
        hashCode = 31 * hashCode + Objects.hashCode(rootChangeSetId());
        hashCode = 31 * hashCode + Objects.hashCode(importExistingResources());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ChangeSetSummary)) {
            return false;
        }
        ChangeSetSummary other = (ChangeSetSummary) obj;
        return Objects.equals(stackId(), other.stackId()) && Objects.equals(stackName(), other.stackName())
                && Objects.equals(changeSetId(), other.changeSetId()) && Objects.equals(changeSetName(), other.changeSetName())
                && Objects.equals(executionStatusAsString(), other.executionStatusAsString())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(statusReason(), other.statusReason()) && Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(description(), other.description())
                && Objects.equals(includeNestedStacks(), other.includeNestedStacks())
                && Objects.equals(parentChangeSetId(), other.parentChangeSetId())
                && Objects.equals(rootChangeSetId(), other.rootChangeSetId())
                && Objects.equals(importExistingResources(), other.importExistingResources());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ChangeSetSummary").add("StackId", stackId()).add("StackName", stackName())
                .add("ChangeSetId", changeSetId()).add("ChangeSetName", changeSetName())
                .add("ExecutionStatus", executionStatusAsString()).add("Status", statusAsString())
                .add("StatusReason", statusReason()).add("CreationTime", creationTime()).add("Description", description())
                .add("IncludeNestedStacks", includeNestedStacks()).add("ParentChangeSetId", parentChangeSetId())
                .add("RootChangeSetId", rootChangeSetId()).add("ImportExistingResources", importExistingResources()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StackId":
            return Optional.ofNullable(clazz.cast(stackId()));
        case "StackName":
            return Optional.ofNullable(clazz.cast(stackName()));
        case "ChangeSetId":
            return Optional.ofNullable(clazz.cast(changeSetId()));
        case "ChangeSetName":
            return Optional.ofNullable(clazz.cast(changeSetName()));
        case "ExecutionStatus":
            return Optional.ofNullable(clazz.cast(executionStatusAsString()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "StatusReason":
            return Optional.ofNullable(clazz.cast(statusReason()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "IncludeNestedStacks":
            return Optional.ofNullable(clazz.cast(includeNestedStacks()));
        case "ParentChangeSetId":
            return Optional.ofNullable(clazz.cast(parentChangeSetId()));
        case "RootChangeSetId":
            return Optional.ofNullable(clazz.cast(rootChangeSetId()));
        case "ImportExistingResources":
            return Optional.ofNullable(clazz.cast(importExistingResources()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("StackId", STACK_ID_FIELD);
        map.put("StackName", STACK_NAME_FIELD);
        map.put("ChangeSetId", CHANGE_SET_ID_FIELD);
        map.put("ChangeSetName", CHANGE_SET_NAME_FIELD);
        map.put("ExecutionStatus", EXECUTION_STATUS_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("StatusReason", STATUS_REASON_FIELD);
        map.put("CreationTime", CREATION_TIME_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("IncludeNestedStacks", INCLUDE_NESTED_STACKS_FIELD);
        map.put("ParentChangeSetId", PARENT_CHANGE_SET_ID_FIELD);
        map.put("RootChangeSetId", ROOT_CHANGE_SET_ID_FIELD);
        map.put("ImportExistingResources", IMPORT_EXISTING_RESOURCES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ChangeSetSummary, T> g) {
        return obj -> g.apply((ChangeSetSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ChangeSetSummary> {
        /**
         * <p>
         * The ID of the stack with which the change set is associated.
         * </p>
         * 
         * @param stackId
         *        The ID of the stack with which the change set is associated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stackId(String stackId);

        /**
         * <p>
         * The name of the stack with which the change set is associated.
         * </p>
         * 
         * @param stackName
         *        The name of the stack with which the change set is associated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stackName(String stackName);

        /**
         * <p>
         * The ID of the change set.
         * </p>
         * 
         * @param changeSetId
         *        The ID of the change set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder changeSetId(String changeSetId);

        /**
         * <p>
         * The name of the change set.
         * </p>
         * 
         * @param changeSetName
         *        The name of the change set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder changeSetName(String changeSetName);

        /**
         * <p>
         * If the change set execution status is <code>AVAILABLE</code>, you can execute the change set. If you can't
         * execute the change set, the status indicates why. For example, a change set might be in an
         * <code>UNAVAILABLE</code> state because CloudFormation is still creating it or in an <code>OBSOLETE</code>
         * state because the stack was already updated.
         * </p>
         * 
         * @param executionStatus
         *        If the change set execution status is <code>AVAILABLE</code>, you can execute the change set. If you
         *        can't execute the change set, the status indicates why. For example, a change set might be in an
         *        <code>UNAVAILABLE</code> state because CloudFormation is still creating it or in an
         *        <code>OBSOLETE</code> state because the stack was already updated.
         * @see ExecutionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExecutionStatus
         */
        Builder executionStatus(String executionStatus);

        /**
         * <p>
         * If the change set execution status is <code>AVAILABLE</code>, you can execute the change set. If you can't
         * execute the change set, the status indicates why. For example, a change set might be in an
         * <code>UNAVAILABLE</code> state because CloudFormation is still creating it or in an <code>OBSOLETE</code>
         * state because the stack was already updated.
         * </p>
         * 
         * @param executionStatus
         *        If the change set execution status is <code>AVAILABLE</code>, you can execute the change set. If you
         *        can't execute the change set, the status indicates why. For example, a change set might be in an
         *        <code>UNAVAILABLE</code> state because CloudFormation is still creating it or in an
         *        <code>OBSOLETE</code> state because the stack was already updated.
         * @see ExecutionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExecutionStatus
         */
        Builder executionStatus(ExecutionStatus executionStatus);

        /**
         * <p>
         * The state of the change set, such as <code>CREATE_PENDING</code>, <code>CREATE_COMPLETE</code>, or
         * <code>FAILED</code>.
         * </p>
         * 
         * @param status
         *        The state of the change set, such as <code>CREATE_PENDING</code>, <code>CREATE_COMPLETE</code>, or
         *        <code>FAILED</code>.
         * @see ChangeSetStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ChangeSetStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The state of the change set, such as <code>CREATE_PENDING</code>, <code>CREATE_COMPLETE</code>, or
         * <code>FAILED</code>.
         * </p>
         * 
         * @param status
         *        The state of the change set, such as <code>CREATE_PENDING</code>, <code>CREATE_COMPLETE</code>, or
         *        <code>FAILED</code>.
         * @see ChangeSetStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ChangeSetStatus
         */
        Builder status(ChangeSetStatus status);

        /**
         * <p>
         * A description of the change set's status. For example, if your change set is in the <code>FAILED</code>
         * state, CloudFormation shows the error message.
         * </p>
         * 
         * @param statusReason
         *        A description of the change set's status. For example, if your change set is in the
         *        <code>FAILED</code> state, CloudFormation shows the error message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusReason(String statusReason);

        /**
         * <p>
         * The start time when the change set was created, in UTC.
         * </p>
         * 
         * @param creationTime
         *        The start time when the change set was created, in UTC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * Descriptive information about the change set.
         * </p>
         * 
         * @param description
         *        Descriptive information about the change set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * Specifies the current setting of <code>IncludeNestedStacks</code> for the change set.
         * </p>
         * 
         * @param includeNestedStacks
         *        Specifies the current setting of <code>IncludeNestedStacks</code> for the change set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder includeNestedStacks(Boolean includeNestedStacks);

        /**
         * <p>
         * The parent change set ID.
         * </p>
         * 
         * @param parentChangeSetId
         *        The parent change set ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parentChangeSetId(String parentChangeSetId);

        /**
         * <p>
         * The root change set ID.
         * </p>
         * 
         * @param rootChangeSetId
         *        The root change set ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rootChangeSetId(String rootChangeSetId);

        /**
         * <p>
         * Indicates if the change set imports resources that already exist.
         * </p>
         * 
         * @param importExistingResources
         *        Indicates if the change set imports resources that already exist.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder importExistingResources(Boolean importExistingResources);
    }

    static final class BuilderImpl implements Builder {
        private String stackId;

        private String stackName;

        private String changeSetId;

        private String changeSetName;

        private String executionStatus;

        private String status;

        private String statusReason;

        private Instant creationTime;

        private String description;

        private Boolean includeNestedStacks;

        private String parentChangeSetId;

        private String rootChangeSetId;

        private Boolean importExistingResources;

        private BuilderImpl() {
        }

        private BuilderImpl(ChangeSetSummary model) {
            stackId(model.stackId);
            stackName(model.stackName);
            changeSetId(model.changeSetId);
            changeSetName(model.changeSetName);
            executionStatus(model.executionStatus);
            status(model.status);
            statusReason(model.statusReason);
            creationTime(model.creationTime);
            description(model.description);
            includeNestedStacks(model.includeNestedStacks);
            parentChangeSetId(model.parentChangeSetId);
            rootChangeSetId(model.rootChangeSetId);
            importExistingResources(model.importExistingResources);
        }

        public final String getStackId() {
            return stackId;
        }

        public final void setStackId(String stackId) {
            this.stackId = stackId;
        }

        @Override
        public final Builder stackId(String stackId) {
            this.stackId = stackId;
            return this;
        }

        public final String getStackName() {
            return stackName;
        }

        public final void setStackName(String stackName) {
            this.stackName = stackName;
        }

        @Override
        public final Builder stackName(String stackName) {
            this.stackName = stackName;
            return this;
        }

        public final String getChangeSetId() {
            return changeSetId;
        }

        public final void setChangeSetId(String changeSetId) {
            this.changeSetId = changeSetId;
        }

        @Override
        public final Builder changeSetId(String changeSetId) {
            this.changeSetId = changeSetId;
            return this;
        }

        public final String getChangeSetName() {
            return changeSetName;
        }

        public final void setChangeSetName(String changeSetName) {
            this.changeSetName = changeSetName;
        }

        @Override
        public final Builder changeSetName(String changeSetName) {
            this.changeSetName = changeSetName;
            return this;
        }

        public final String getExecutionStatus() {
            return executionStatus;
        }

        public final void setExecutionStatus(String executionStatus) {
            this.executionStatus = executionStatus;
        }

        @Override
        public final Builder executionStatus(String executionStatus) {
            this.executionStatus = executionStatus;
            return this;
        }

        @Override
        public final Builder executionStatus(ExecutionStatus executionStatus) {
            this.executionStatus(executionStatus == null ? null : executionStatus.toString());
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ChangeSetStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusReason() {
            return statusReason;
        }

        public final void setStatusReason(String statusReason) {
            this.statusReason = statusReason;
        }

        @Override
        public final Builder statusReason(String statusReason) {
            this.statusReason = statusReason;
            return this;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Boolean getIncludeNestedStacks() {
            return includeNestedStacks;
        }

        public final void setIncludeNestedStacks(Boolean includeNestedStacks) {
            this.includeNestedStacks = includeNestedStacks;
        }

        @Override
        public final Builder includeNestedStacks(Boolean includeNestedStacks) {
            this.includeNestedStacks = includeNestedStacks;
            return this;
        }

        public final String getParentChangeSetId() {
            return parentChangeSetId;
        }

        public final void setParentChangeSetId(String parentChangeSetId) {
            this.parentChangeSetId = parentChangeSetId;
        }

        @Override
        public final Builder parentChangeSetId(String parentChangeSetId) {
            this.parentChangeSetId = parentChangeSetId;
            return this;
        }

        public final String getRootChangeSetId() {
            return rootChangeSetId;
        }

        public final void setRootChangeSetId(String rootChangeSetId) {
            this.rootChangeSetId = rootChangeSetId;
        }

        @Override
        public final Builder rootChangeSetId(String rootChangeSetId) {
            this.rootChangeSetId = rootChangeSetId;
            return this;
        }

        public final Boolean getImportExistingResources() {
            return importExistingResources;
        }

        public final void setImportExistingResources(Boolean importExistingResources) {
            this.importExistingResources = importExistingResources;
        }

        @Override
        public final Builder importExistingResources(Boolean importExistingResources) {
            this.importExistingResources = importExistingResources;
            return this;
        }

        @Override
        public ChangeSetSummary build() {
            return new ChangeSetSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
