/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudformation.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListStackRefactorsResponse extends CloudFormationResponse implements
        ToCopyableBuilder<ListStackRefactorsResponse.Builder, ListStackRefactorsResponse> {
    private static final SdkField<List<StackRefactorSummary>> STACK_REFACTOR_SUMMARIES_FIELD = SdkField
            .<List<StackRefactorSummary>> builder(MarshallingType.LIST)
            .memberName("StackRefactorSummaries")
            .getter(getter(ListStackRefactorsResponse::stackRefactorSummaries))
            .setter(setter(Builder::stackRefactorSummaries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StackRefactorSummaries").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<StackRefactorSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(StackRefactorSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListStackRefactorsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            STACK_REFACTOR_SUMMARIES_FIELD, NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<StackRefactorSummary> stackRefactorSummaries;

    private final String nextToken;

    private ListStackRefactorsResponse(BuilderImpl builder) {
        super(builder);
        this.stackRefactorSummaries = builder.stackRefactorSummaries;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the StackRefactorSummaries property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasStackRefactorSummaries() {
        return stackRefactorSummaries != null && !(stackRefactorSummaries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Provides a summary of a stack refactor, including the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>StackRefactorId</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Status</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>StatusReason</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ExecutionStatus</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ExecutionStatusReason</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Description</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasStackRefactorSummaries} method.
     * </p>
     * 
     * @return Provides a summary of a stack refactor, including the following:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>StackRefactorId</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Status</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>StatusReason</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ExecutionStatus</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ExecutionStatusReason</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Description</code>
     *         </p>
     *         </li>
     */
    public final List<StackRefactorSummary> stackRefactorSummaries() {
        return stackRefactorSummaries;
    }

    /**
     * <p>
     * If the request doesn't return all the remaining results, <code>NextToken</code> is set to a token. To retrieve
     * the next set of results, call this action again and assign that token to the request object's
     * <code>NextToken</code> parameter. If the request returns all results, <code>NextToken</code> is set to
     * <code>null</code>.
     * </p>
     * 
     * @return If the request doesn't return all the remaining results, <code>NextToken</code> is set to a token. To
     *         retrieve the next set of results, call this action again and assign that token to the request object's
     *         <code>NextToken</code> parameter. If the request returns all results, <code>NextToken</code> is set to
     *         <code>null</code>.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasStackRefactorSummaries() ? stackRefactorSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListStackRefactorsResponse)) {
            return false;
        }
        ListStackRefactorsResponse other = (ListStackRefactorsResponse) obj;
        return hasStackRefactorSummaries() == other.hasStackRefactorSummaries()
                && Objects.equals(stackRefactorSummaries(), other.stackRefactorSummaries())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListStackRefactorsResponse")
                .add("StackRefactorSummaries", hasStackRefactorSummaries() ? stackRefactorSummaries() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StackRefactorSummaries":
            return Optional.ofNullable(clazz.cast(stackRefactorSummaries()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("StackRefactorSummaries", STACK_REFACTOR_SUMMARIES_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListStackRefactorsResponse, T> g) {
        return obj -> g.apply((ListStackRefactorsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends CloudFormationResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListStackRefactorsResponse> {
        /**
         * <p>
         * Provides a summary of a stack refactor, including the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>StackRefactorId</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Status</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>StatusReason</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ExecutionStatus</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ExecutionStatusReason</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Description</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param stackRefactorSummaries
         *        Provides a summary of a stack refactor, including the following:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>StackRefactorId</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Status</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>StatusReason</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ExecutionStatus</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ExecutionStatusReason</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Description</code>
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stackRefactorSummaries(Collection<StackRefactorSummary> stackRefactorSummaries);

        /**
         * <p>
         * Provides a summary of a stack refactor, including the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>StackRefactorId</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Status</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>StatusReason</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ExecutionStatus</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ExecutionStatusReason</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Description</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param stackRefactorSummaries
         *        Provides a summary of a stack refactor, including the following:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>StackRefactorId</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Status</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>StatusReason</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ExecutionStatus</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ExecutionStatusReason</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Description</code>
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stackRefactorSummaries(StackRefactorSummary... stackRefactorSummaries);

        /**
         * <p>
         * Provides a summary of a stack refactor, including the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>StackRefactorId</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Status</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>StatusReason</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ExecutionStatus</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ExecutionStatusReason</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Description</code>
         * </p>
         * </li>
         * </ul>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.cloudformation.model.StackRefactorSummary.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.cloudformation.model.StackRefactorSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.cloudformation.model.StackRefactorSummary.Builder#build()} is called
         * immediately and its result is passed to {@link #stackRefactorSummaries(List<StackRefactorSummary>)}.
         * 
         * @param stackRefactorSummaries
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.cloudformation.model.StackRefactorSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #stackRefactorSummaries(java.util.Collection<StackRefactorSummary>)
         */
        Builder stackRefactorSummaries(Consumer<StackRefactorSummary.Builder>... stackRefactorSummaries);

        /**
         * <p>
         * If the request doesn't return all the remaining results, <code>NextToken</code> is set to a token. To
         * retrieve the next set of results, call this action again and assign that token to the request object's
         * <code>NextToken</code> parameter. If the request returns all results, <code>NextToken</code> is set to
         * <code>null</code>.
         * </p>
         * 
         * @param nextToken
         *        If the request doesn't return all the remaining results, <code>NextToken</code> is set to a token. To
         *        retrieve the next set of results, call this action again and assign that token to the request object's
         *        <code>NextToken</code> parameter. If the request returns all results, <code>NextToken</code> is set to
         *        <code>null</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends CloudFormationResponse.BuilderImpl implements Builder {
        private List<StackRefactorSummary> stackRefactorSummaries = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListStackRefactorsResponse model) {
            super(model);
            stackRefactorSummaries(model.stackRefactorSummaries);
            nextToken(model.nextToken);
        }

        public final List<StackRefactorSummary.Builder> getStackRefactorSummaries() {
            List<StackRefactorSummary.Builder> result = StackRefactorSummariesCopier.copyToBuilder(this.stackRefactorSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setStackRefactorSummaries(Collection<StackRefactorSummary.BuilderImpl> stackRefactorSummaries) {
            this.stackRefactorSummaries = StackRefactorSummariesCopier.copyFromBuilder(stackRefactorSummaries);
        }

        @Override
        public final Builder stackRefactorSummaries(Collection<StackRefactorSummary> stackRefactorSummaries) {
            this.stackRefactorSummaries = StackRefactorSummariesCopier.copy(stackRefactorSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stackRefactorSummaries(StackRefactorSummary... stackRefactorSummaries) {
            stackRefactorSummaries(Arrays.asList(stackRefactorSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stackRefactorSummaries(Consumer<StackRefactorSummary.Builder>... stackRefactorSummaries) {
            stackRefactorSummaries(Stream.of(stackRefactorSummaries)
                    .map(c -> StackRefactorSummary.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListStackRefactorsResponse build() {
            return new ListStackRefactorsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
