/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudformation.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The output for the <a>GetStackPolicy</a> action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetStackPolicyResponse extends CloudFormationResponse implements
        ToCopyableBuilder<GetStackPolicyResponse.Builder, GetStackPolicyResponse> {
    private static final SdkField<String> STACK_POLICY_BODY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StackPolicyBody").getter(getter(GetStackPolicyResponse::stackPolicyBody))
            .setter(setter(Builder::stackPolicyBody))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StackPolicyBody").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STACK_POLICY_BODY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String stackPolicyBody;

    private GetStackPolicyResponse(BuilderImpl builder) {
        super(builder);
        this.stackPolicyBody = builder.stackPolicyBody;
    }

    /**
     * <p>
     * Structure that contains the stack policy body. (For more information, see <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/protect-stack-resources.html">Prevent
     * updates to stack resources</a> in the <i>CloudFormation User Guide</i>.)
     * </p>
     * 
     * @return Structure that contains the stack policy body. (For more information, see <a
     *         href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/protect-stack-resources.html"
     *         >Prevent updates to stack resources</a> in the <i>CloudFormation User Guide</i>.)
     */
    public final String stackPolicyBody() {
        return stackPolicyBody;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(stackPolicyBody());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetStackPolicyResponse)) {
            return false;
        }
        GetStackPolicyResponse other = (GetStackPolicyResponse) obj;
        return Objects.equals(stackPolicyBody(), other.stackPolicyBody());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetStackPolicyResponse").add("StackPolicyBody", stackPolicyBody()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StackPolicyBody":
            return Optional.ofNullable(clazz.cast(stackPolicyBody()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("StackPolicyBody", STACK_POLICY_BODY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetStackPolicyResponse, T> g) {
        return obj -> g.apply((GetStackPolicyResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends CloudFormationResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetStackPolicyResponse> {
        /**
         * <p>
         * Structure that contains the stack policy body. (For more information, see <a
         * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/protect-stack-resources.html">Prevent
         * updates to stack resources</a> in the <i>CloudFormation User Guide</i>.)
         * </p>
         * 
         * @param stackPolicyBody
         *        Structure that contains the stack policy body. (For more information, see <a
         *        href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/protect-stack-resources.html"
         *        >Prevent updates to stack resources</a> in the <i>CloudFormation User Guide</i>.)
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stackPolicyBody(String stackPolicyBody);
    }

    static final class BuilderImpl extends CloudFormationResponse.BuilderImpl implements Builder {
        private String stackPolicyBody;

        private BuilderImpl() {
        }

        private BuilderImpl(GetStackPolicyResponse model) {
            super(model);
            stackPolicyBody(model.stackPolicyBody);
        }

        public final String getStackPolicyBody() {
            return stackPolicyBody;
        }

        public final void setStackPolicyBody(String stackPolicyBody) {
            this.stackPolicyBody = stackPolicyBody;
        }

        @Override
        public final Builder stackPolicyBody(String stackPolicyBody) {
            this.stackPolicyBody = stackPolicyBody;
            return this;
        }

        @Override
        public GetStackPolicyResponse build() {
            return new GetStackPolicyResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
