/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudformation.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeResourceScanResponse extends CloudFormationResponse implements
        ToCopyableBuilder<DescribeResourceScanResponse.Builder, DescribeResourceScanResponse> {
    private static final SdkField<String> RESOURCE_SCAN_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceScanId").getter(getter(DescribeResourceScanResponse::resourceScanId))
            .setter(setter(Builder::resourceScanId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceScanId").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(DescribeResourceScanResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> STATUS_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StatusReason").getter(getter(DescribeResourceScanResponse::statusReason))
            .setter(setter(Builder::statusReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusReason").build()).build();

    private static final SdkField<Instant> START_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("StartTime").getter(getter(DescribeResourceScanResponse::startTime)).setter(setter(Builder::startTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").build()).build();

    private static final SdkField<Instant> END_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("EndTime").getter(getter(DescribeResourceScanResponse::endTime)).setter(setter(Builder::endTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndTime").build()).build();

    private static final SdkField<Double> PERCENTAGE_COMPLETED_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("PercentageCompleted").getter(getter(DescribeResourceScanResponse::percentageCompleted))
            .setter(setter(Builder::percentageCompleted))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PercentageCompleted").build())
            .build();

    private static final SdkField<List<String>> RESOURCE_TYPES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ResourceTypes")
            .getter(getter(DescribeResourceScanResponse::resourceTypes))
            .setter(setter(Builder::resourceTypes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceTypes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Integer> RESOURCES_SCANNED_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("ResourcesScanned").getter(getter(DescribeResourceScanResponse::resourcesScanned))
            .setter(setter(Builder::resourcesScanned))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourcesScanned").build()).build();

    private static final SdkField<Integer> RESOURCES_READ_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("ResourcesRead").getter(getter(DescribeResourceScanResponse::resourcesRead))
            .setter(setter(Builder::resourcesRead))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourcesRead").build()).build();

    private static final SdkField<List<ScanFilter>> SCAN_FILTERS_FIELD = SdkField
            .<List<ScanFilter>> builder(MarshallingType.LIST)
            .memberName("ScanFilters")
            .getter(getter(DescribeResourceScanResponse::scanFilters))
            .setter(setter(Builder::scanFilters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScanFilters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ScanFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(ScanFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_SCAN_ID_FIELD,
            STATUS_FIELD, STATUS_REASON_FIELD, START_TIME_FIELD, END_TIME_FIELD, PERCENTAGE_COMPLETED_FIELD,
            RESOURCE_TYPES_FIELD, RESOURCES_SCANNED_FIELD, RESOURCES_READ_FIELD, SCAN_FILTERS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String resourceScanId;

    private final String status;

    private final String statusReason;

    private final Instant startTime;

    private final Instant endTime;

    private final Double percentageCompleted;

    private final List<String> resourceTypes;

    private final Integer resourcesScanned;

    private final Integer resourcesRead;

    private final List<ScanFilter> scanFilters;

    private DescribeResourceScanResponse(BuilderImpl builder) {
        super(builder);
        this.resourceScanId = builder.resourceScanId;
        this.status = builder.status;
        this.statusReason = builder.statusReason;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.percentageCompleted = builder.percentageCompleted;
        this.resourceTypes = builder.resourceTypes;
        this.resourcesScanned = builder.resourcesScanned;
        this.resourcesRead = builder.resourcesRead;
        this.scanFilters = builder.scanFilters;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the resource scan. The format is
     * <code>arn:${Partition}:cloudformation:${Region}:${Account}:resourceScan/${Id}</code>. An example is
     * <code>arn:aws:cloudformation:<i>us-east-1</i>:<i>123456789012</i>:resourceScan/<i>f5b490f7-7ed4-428a-aa06-31ff25db0772</i> </code>
     * .
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the resource scan. The format is
     *         <code>arn:${Partition}:cloudformation:${Region}:${Account}:resourceScan/${Id}</code>. An example is
     *         <code>arn:aws:cloudformation:<i>us-east-1</i>:<i>123456789012</i>:resourceScan/<i>f5b490f7-7ed4-428a-aa06-31ff25db0772</i> </code>
     *         .
     */
    public final String resourceScanId() {
        return resourceScanId;
    }

    /**
     * <p>
     * Status of the resource scan.
     * </p>
     * <dl>
     * <dt>IN_PROGRESS</dt>
     * <dd>
     * <p>
     * The resource scan is still in progress.
     * </p>
     * </dd>
     * <dt>COMPLETE</dt>
     * <dd>
     * <p>
     * The resource scan is complete.
     * </p>
     * </dd>
     * <dt>EXPIRED</dt>
     * <dd>
     * <p>
     * The resource scan has expired.
     * </p>
     * </dd>
     * <dt>FAILED</dt>
     * <dd>
     * <p>
     * The resource scan has failed.
     * </p>
     * </dd>
     * </dl>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ResourceScanStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return Status of the resource scan.</p>
     *         <dl>
     *         <dt>IN_PROGRESS</dt>
     *         <dd>
     *         <p>
     *         The resource scan is still in progress.
     *         </p>
     *         </dd>
     *         <dt>COMPLETE</dt>
     *         <dd>
     *         <p>
     *         The resource scan is complete.
     *         </p>
     *         </dd>
     *         <dt>EXPIRED</dt>
     *         <dd>
     *         <p>
     *         The resource scan has expired.
     *         </p>
     *         </dd>
     *         <dt>FAILED</dt>
     *         <dd>
     *         <p>
     *         The resource scan has failed.
     *         </p>
     *         </dd>
     * @see ResourceScanStatus
     */
    public final ResourceScanStatus status() {
        return ResourceScanStatus.fromValue(status);
    }

    /**
     * <p>
     * Status of the resource scan.
     * </p>
     * <dl>
     * <dt>IN_PROGRESS</dt>
     * <dd>
     * <p>
     * The resource scan is still in progress.
     * </p>
     * </dd>
     * <dt>COMPLETE</dt>
     * <dd>
     * <p>
     * The resource scan is complete.
     * </p>
     * </dd>
     * <dt>EXPIRED</dt>
     * <dd>
     * <p>
     * The resource scan has expired.
     * </p>
     * </dd>
     * <dt>FAILED</dt>
     * <dd>
     * <p>
     * The resource scan has failed.
     * </p>
     * </dd>
     * </dl>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ResourceScanStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return Status of the resource scan.</p>
     *         <dl>
     *         <dt>IN_PROGRESS</dt>
     *         <dd>
     *         <p>
     *         The resource scan is still in progress.
     *         </p>
     *         </dd>
     *         <dt>COMPLETE</dt>
     *         <dd>
     *         <p>
     *         The resource scan is complete.
     *         </p>
     *         </dd>
     *         <dt>EXPIRED</dt>
     *         <dd>
     *         <p>
     *         The resource scan has expired.
     *         </p>
     *         </dd>
     *         <dt>FAILED</dt>
     *         <dd>
     *         <p>
     *         The resource scan has failed.
     *         </p>
     *         </dd>
     * @see ResourceScanStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The reason for the resource scan status, providing more information if a failure happened.
     * </p>
     * 
     * @return The reason for the resource scan status, providing more information if a failure happened.
     */
    public final String statusReason() {
        return statusReason;
    }

    /**
     * <p>
     * The time that the resource scan was started.
     * </p>
     * 
     * @return The time that the resource scan was started.
     */
    public final Instant startTime() {
        return startTime;
    }

    /**
     * <p>
     * The time that the resource scan was finished.
     * </p>
     * 
     * @return The time that the resource scan was finished.
     */
    public final Instant endTime() {
        return endTime;
    }

    /**
     * <p>
     * The percentage of the resource scan that has been completed.
     * </p>
     * 
     * @return The percentage of the resource scan that has been completed.
     */
    public final Double percentageCompleted() {
        return percentageCompleted;
    }

    /**
     * For responses, this returns true if the service returned a value for the ResourceTypes property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasResourceTypes() {
        return resourceTypes != null && !(resourceTypes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of resource types for the specified scan. Resource types are only available for scans with a
     * <code>Status</code> set to <code>COMPLETE</code> or <code>FAILED </code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasResourceTypes} method.
     * </p>
     * 
     * @return The list of resource types for the specified scan. Resource types are only available for scans with a
     *         <code>Status</code> set to <code>COMPLETE</code> or <code>FAILED </code>.
     */
    public final List<String> resourceTypes() {
        return resourceTypes;
    }

    /**
     * <p>
     * The number of resources that were listed. This is only available for scans with a <code>Status</code> set to
     * <code>COMPLETE</code>, <code>EXPIRED</code>, or <code>FAILED </code>.
     * </p>
     * 
     * @return The number of resources that were listed. This is only available for scans with a <code>Status</code> set
     *         to <code>COMPLETE</code>, <code>EXPIRED</code>, or <code>FAILED </code>.
     */
    public final Integer resourcesScanned() {
        return resourcesScanned;
    }

    /**
     * <p>
     * The number of resources that were read. This is only available for scans with a <code>Status</code> set to
     * <code>COMPLETE</code>, <code>EXPIRED</code>, or <code>FAILED</code>.
     * </p>
     * <note>
     * <p>
     * This field may be 0 if the resource scan failed with a <code>ResourceScanLimitExceededException</code>.
     * </p>
     * </note>
     * 
     * @return The number of resources that were read. This is only available for scans with a <code>Status</code> set
     *         to <code>COMPLETE</code>, <code>EXPIRED</code>, or <code>FAILED</code>.</p> <note>
     *         <p>
     *         This field may be 0 if the resource scan failed with a <code>ResourceScanLimitExceededException</code>.
     *         </p>
     */
    public final Integer resourcesRead() {
        return resourcesRead;
    }

    /**
     * For responses, this returns true if the service returned a value for the ScanFilters property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasScanFilters() {
        return scanFilters != null && !(scanFilters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The scan filters that were used.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasScanFilters} method.
     * </p>
     * 
     * @return The scan filters that were used.
     */
    public final List<ScanFilter> scanFilters() {
        return scanFilters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(resourceScanId());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusReason());
        hashCode = 31 * hashCode + Objects.hashCode(startTime());
        hashCode = 31 * hashCode + Objects.hashCode(endTime());
        hashCode = 31 * hashCode + Objects.hashCode(percentageCompleted());
        hashCode = 31 * hashCode + Objects.hashCode(hasResourceTypes() ? resourceTypes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(resourcesScanned());
        hashCode = 31 * hashCode + Objects.hashCode(resourcesRead());
        hashCode = 31 * hashCode + Objects.hashCode(hasScanFilters() ? scanFilters() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeResourceScanResponse)) {
            return false;
        }
        DescribeResourceScanResponse other = (DescribeResourceScanResponse) obj;
        return Objects.equals(resourceScanId(), other.resourceScanId())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(statusReason(), other.statusReason()) && Objects.equals(startTime(), other.startTime())
                && Objects.equals(endTime(), other.endTime())
                && Objects.equals(percentageCompleted(), other.percentageCompleted())
                && hasResourceTypes() == other.hasResourceTypes() && Objects.equals(resourceTypes(), other.resourceTypes())
                && Objects.equals(resourcesScanned(), other.resourcesScanned())
                && Objects.equals(resourcesRead(), other.resourcesRead()) && hasScanFilters() == other.hasScanFilters()
                && Objects.equals(scanFilters(), other.scanFilters());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeResourceScanResponse").add("ResourceScanId", resourceScanId())
                .add("Status", statusAsString()).add("StatusReason", statusReason()).add("StartTime", startTime())
                .add("EndTime", endTime()).add("PercentageCompleted", percentageCompleted())
                .add("ResourceTypes", hasResourceTypes() ? resourceTypes() : null).add("ResourcesScanned", resourcesScanned())
                .add("ResourcesRead", resourcesRead()).add("ScanFilters", hasScanFilters() ? scanFilters() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ResourceScanId":
            return Optional.ofNullable(clazz.cast(resourceScanId()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "StatusReason":
            return Optional.ofNullable(clazz.cast(statusReason()));
        case "StartTime":
            return Optional.ofNullable(clazz.cast(startTime()));
        case "EndTime":
            return Optional.ofNullable(clazz.cast(endTime()));
        case "PercentageCompleted":
            return Optional.ofNullable(clazz.cast(percentageCompleted()));
        case "ResourceTypes":
            return Optional.ofNullable(clazz.cast(resourceTypes()));
        case "ResourcesScanned":
            return Optional.ofNullable(clazz.cast(resourcesScanned()));
        case "ResourcesRead":
            return Optional.ofNullable(clazz.cast(resourcesRead()));
        case "ScanFilters":
            return Optional.ofNullable(clazz.cast(scanFilters()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ResourceScanId", RESOURCE_SCAN_ID_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("StatusReason", STATUS_REASON_FIELD);
        map.put("StartTime", START_TIME_FIELD);
        map.put("EndTime", END_TIME_FIELD);
        map.put("PercentageCompleted", PERCENTAGE_COMPLETED_FIELD);
        map.put("ResourceTypes", RESOURCE_TYPES_FIELD);
        map.put("ResourcesScanned", RESOURCES_SCANNED_FIELD);
        map.put("ResourcesRead", RESOURCES_READ_FIELD);
        map.put("ScanFilters", SCAN_FILTERS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeResourceScanResponse, T> g) {
        return obj -> g.apply((DescribeResourceScanResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends CloudFormationResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeResourceScanResponse> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the resource scan. The format is
         * <code>arn:${Partition}:cloudformation:${Region}:${Account}:resourceScan/${Id}</code>. An example is
         * <code>arn:aws:cloudformation:<i>us-east-1</i>:<i>123456789012</i>:resourceScan/<i>f5b490f7-7ed4-428a-aa06-31ff25db0772</i> </code>
         * .
         * </p>
         * 
         * @param resourceScanId
         *        The Amazon Resource Name (ARN) of the resource scan. The format is
         *        <code>arn:${Partition}:cloudformation:${Region}:${Account}:resourceScan/${Id}</code>. An example is
         *        <code>arn:aws:cloudformation:<i>us-east-1</i>:<i>123456789012</i>:resourceScan/<i>f5b490f7-7ed4-428a-aa06-31ff25db0772</i> </code>
         *        .
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceScanId(String resourceScanId);

        /**
         * <p>
         * Status of the resource scan.
         * </p>
         * <dl>
         * <dt>IN_PROGRESS</dt>
         * <dd>
         * <p>
         * The resource scan is still in progress.
         * </p>
         * </dd>
         * <dt>COMPLETE</dt>
         * <dd>
         * <p>
         * The resource scan is complete.
         * </p>
         * </dd>
         * <dt>EXPIRED</dt>
         * <dd>
         * <p>
         * The resource scan has expired.
         * </p>
         * </dd>
         * <dt>FAILED</dt>
         * <dd>
         * <p>
         * The resource scan has failed.
         * </p>
         * </dd>
         * </dl>
         * 
         * @param status
         *        Status of the resource scan.</p>
         *        <dl>
         *        <dt>IN_PROGRESS</dt>
         *        <dd>
         *        <p>
         *        The resource scan is still in progress.
         *        </p>
         *        </dd>
         *        <dt>COMPLETE</dt>
         *        <dd>
         *        <p>
         *        The resource scan is complete.
         *        </p>
         *        </dd>
         *        <dt>EXPIRED</dt>
         *        <dd>
         *        <p>
         *        The resource scan has expired.
         *        </p>
         *        </dd>
         *        <dt>FAILED</dt>
         *        <dd>
         *        <p>
         *        The resource scan has failed.
         *        </p>
         *        </dd>
         * @see ResourceScanStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceScanStatus
         */
        Builder status(String status);

        /**
         * <p>
         * Status of the resource scan.
         * </p>
         * <dl>
         * <dt>IN_PROGRESS</dt>
         * <dd>
         * <p>
         * The resource scan is still in progress.
         * </p>
         * </dd>
         * <dt>COMPLETE</dt>
         * <dd>
         * <p>
         * The resource scan is complete.
         * </p>
         * </dd>
         * <dt>EXPIRED</dt>
         * <dd>
         * <p>
         * The resource scan has expired.
         * </p>
         * </dd>
         * <dt>FAILED</dt>
         * <dd>
         * <p>
         * The resource scan has failed.
         * </p>
         * </dd>
         * </dl>
         * 
         * @param status
         *        Status of the resource scan.</p>
         *        <dl>
         *        <dt>IN_PROGRESS</dt>
         *        <dd>
         *        <p>
         *        The resource scan is still in progress.
         *        </p>
         *        </dd>
         *        <dt>COMPLETE</dt>
         *        <dd>
         *        <p>
         *        The resource scan is complete.
         *        </p>
         *        </dd>
         *        <dt>EXPIRED</dt>
         *        <dd>
         *        <p>
         *        The resource scan has expired.
         *        </p>
         *        </dd>
         *        <dt>FAILED</dt>
         *        <dd>
         *        <p>
         *        The resource scan has failed.
         *        </p>
         *        </dd>
         * @see ResourceScanStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceScanStatus
         */
        Builder status(ResourceScanStatus status);

        /**
         * <p>
         * The reason for the resource scan status, providing more information if a failure happened.
         * </p>
         * 
         * @param statusReason
         *        The reason for the resource scan status, providing more information if a failure happened.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusReason(String statusReason);

        /**
         * <p>
         * The time that the resource scan was started.
         * </p>
         * 
         * @param startTime
         *        The time that the resource scan was started.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(Instant startTime);

        /**
         * <p>
         * The time that the resource scan was finished.
         * </p>
         * 
         * @param endTime
         *        The time that the resource scan was finished.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endTime(Instant endTime);

        /**
         * <p>
         * The percentage of the resource scan that has been completed.
         * </p>
         * 
         * @param percentageCompleted
         *        The percentage of the resource scan that has been completed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder percentageCompleted(Double percentageCompleted);

        /**
         * <p>
         * The list of resource types for the specified scan. Resource types are only available for scans with a
         * <code>Status</code> set to <code>COMPLETE</code> or <code>FAILED </code>.
         * </p>
         * 
         * @param resourceTypes
         *        The list of resource types for the specified scan. Resource types are only available for scans with a
         *        <code>Status</code> set to <code>COMPLETE</code> or <code>FAILED </code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceTypes(Collection<String> resourceTypes);

        /**
         * <p>
         * The list of resource types for the specified scan. Resource types are only available for scans with a
         * <code>Status</code> set to <code>COMPLETE</code> or <code>FAILED </code>.
         * </p>
         * 
         * @param resourceTypes
         *        The list of resource types for the specified scan. Resource types are only available for scans with a
         *        <code>Status</code> set to <code>COMPLETE</code> or <code>FAILED </code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceTypes(String... resourceTypes);

        /**
         * <p>
         * The number of resources that were listed. This is only available for scans with a <code>Status</code> set to
         * <code>COMPLETE</code>, <code>EXPIRED</code>, or <code>FAILED </code>.
         * </p>
         * 
         * @param resourcesScanned
         *        The number of resources that were listed. This is only available for scans with a <code>Status</code>
         *        set to <code>COMPLETE</code>, <code>EXPIRED</code>, or <code>FAILED </code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourcesScanned(Integer resourcesScanned);

        /**
         * <p>
         * The number of resources that were read. This is only available for scans with a <code>Status</code> set to
         * <code>COMPLETE</code>, <code>EXPIRED</code>, or <code>FAILED</code>.
         * </p>
         * <note>
         * <p>
         * This field may be 0 if the resource scan failed with a <code>ResourceScanLimitExceededException</code>.
         * </p>
         * </note>
         * 
         * @param resourcesRead
         *        The number of resources that were read. This is only available for scans with a <code>Status</code>
         *        set to <code>COMPLETE</code>, <code>EXPIRED</code>, or <code>FAILED</code>.</p> <note>
         *        <p>
         *        This field may be 0 if the resource scan failed with a <code>ResourceScanLimitExceededException</code>
         *        .
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourcesRead(Integer resourcesRead);

        /**
         * <p>
         * The scan filters that were used.
         * </p>
         * 
         * @param scanFilters
         *        The scan filters that were used.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scanFilters(Collection<ScanFilter> scanFilters);

        /**
         * <p>
         * The scan filters that were used.
         * </p>
         * 
         * @param scanFilters
         *        The scan filters that were used.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scanFilters(ScanFilter... scanFilters);

        /**
         * <p>
         * The scan filters that were used.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.cloudformation.model.ScanFilter.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.cloudformation.model.ScanFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.cloudformation.model.ScanFilter.Builder#build()} is called immediately
         * and its result is passed to {@link #scanFilters(List<ScanFilter>)}.
         * 
         * @param scanFilters
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.cloudformation.model.ScanFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #scanFilters(java.util.Collection<ScanFilter>)
         */
        Builder scanFilters(Consumer<ScanFilter.Builder>... scanFilters);
    }

    static final class BuilderImpl extends CloudFormationResponse.BuilderImpl implements Builder {
        private String resourceScanId;

        private String status;

        private String statusReason;

        private Instant startTime;

        private Instant endTime;

        private Double percentageCompleted;

        private List<String> resourceTypes = DefaultSdkAutoConstructList.getInstance();

        private Integer resourcesScanned;

        private Integer resourcesRead;

        private List<ScanFilter> scanFilters = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeResourceScanResponse model) {
            super(model);
            resourceScanId(model.resourceScanId);
            status(model.status);
            statusReason(model.statusReason);
            startTime(model.startTime);
            endTime(model.endTime);
            percentageCompleted(model.percentageCompleted);
            resourceTypes(model.resourceTypes);
            resourcesScanned(model.resourcesScanned);
            resourcesRead(model.resourcesRead);
            scanFilters(model.scanFilters);
        }

        public final String getResourceScanId() {
            return resourceScanId;
        }

        public final void setResourceScanId(String resourceScanId) {
            this.resourceScanId = resourceScanId;
        }

        @Override
        public final Builder resourceScanId(String resourceScanId) {
            this.resourceScanId = resourceScanId;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ResourceScanStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusReason() {
            return statusReason;
        }

        public final void setStatusReason(String statusReason) {
            this.statusReason = statusReason;
        }

        @Override
        public final Builder statusReason(String statusReason) {
            this.statusReason = statusReason;
            return this;
        }

        public final Instant getStartTime() {
            return startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final Instant getEndTime() {
            return endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final Double getPercentageCompleted() {
            return percentageCompleted;
        }

        public final void setPercentageCompleted(Double percentageCompleted) {
            this.percentageCompleted = percentageCompleted;
        }

        @Override
        public final Builder percentageCompleted(Double percentageCompleted) {
            this.percentageCompleted = percentageCompleted;
            return this;
        }

        public final Collection<String> getResourceTypes() {
            if (resourceTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return resourceTypes;
        }

        public final void setResourceTypes(Collection<String> resourceTypes) {
            this.resourceTypes = ResourceTypesCopier.copy(resourceTypes);
        }

        @Override
        public final Builder resourceTypes(Collection<String> resourceTypes) {
            this.resourceTypes = ResourceTypesCopier.copy(resourceTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceTypes(String... resourceTypes) {
            resourceTypes(Arrays.asList(resourceTypes));
            return this;
        }

        public final Integer getResourcesScanned() {
            return resourcesScanned;
        }

        public final void setResourcesScanned(Integer resourcesScanned) {
            this.resourcesScanned = resourcesScanned;
        }

        @Override
        public final Builder resourcesScanned(Integer resourcesScanned) {
            this.resourcesScanned = resourcesScanned;
            return this;
        }

        public final Integer getResourcesRead() {
            return resourcesRead;
        }

        public final void setResourcesRead(Integer resourcesRead) {
            this.resourcesRead = resourcesRead;
        }

        @Override
        public final Builder resourcesRead(Integer resourcesRead) {
            this.resourcesRead = resourcesRead;
            return this;
        }

        public final List<ScanFilter.Builder> getScanFilters() {
            List<ScanFilter.Builder> result = ScanFiltersCopier.copyToBuilder(this.scanFilters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setScanFilters(Collection<ScanFilter.BuilderImpl> scanFilters) {
            this.scanFilters = ScanFiltersCopier.copyFromBuilder(scanFilters);
        }

        @Override
        public final Builder scanFilters(Collection<ScanFilter> scanFilters) {
            this.scanFilters = ScanFiltersCopier.copy(scanFilters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scanFilters(ScanFilter... scanFilters) {
            scanFilters(Arrays.asList(scanFilters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scanFilters(Consumer<ScanFilter.Builder>... scanFilters) {
            scanFilters(Stream.of(scanFilters).map(c -> ScanFilter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public DescribeResourceScanResponse build() {
            return new DescribeResourceScanResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
