/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudformation.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The <code>Output</code> data type.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Output implements SdkPojo, Serializable, ToCopyableBuilder<Output.Builder, Output> {
    private static final SdkField<String> OUTPUT_KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OutputKey").getter(getter(Output::outputKey)).setter(setter(Builder::outputKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputKey").build()).build();

    private static final SdkField<String> OUTPUT_VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OutputValue").getter(getter(Output::outputValue)).setter(setter(Builder::outputValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputValue").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(Output::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> EXPORT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ExportName").getter(getter(Output::exportName)).setter(setter(Builder::exportName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExportName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OUTPUT_KEY_FIELD,
            OUTPUT_VALUE_FIELD, DESCRIPTION_FIELD, EXPORT_NAME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String outputKey;

    private final String outputValue;

    private final String description;

    private final String exportName;

    private Output(BuilderImpl builder) {
        this.outputKey = builder.outputKey;
        this.outputValue = builder.outputValue;
        this.description = builder.description;
        this.exportName = builder.exportName;
    }

    /**
     * <p>
     * The key associated with the output.
     * </p>
     * 
     * @return The key associated with the output.
     */
    public final String outputKey() {
        return outputKey;
    }

    /**
     * <p>
     * The value associated with the output.
     * </p>
     * 
     * @return The value associated with the output.
     */
    public final String outputValue() {
        return outputValue;
    }

    /**
     * <p>
     * User defined description associated with the output.
     * </p>
     * 
     * @return User defined description associated with the output.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The name of the export associated with the output.
     * </p>
     * 
     * @return The name of the export associated with the output.
     */
    public final String exportName() {
        return exportName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(outputKey());
        hashCode = 31 * hashCode + Objects.hashCode(outputValue());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(exportName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Output)) {
            return false;
        }
        Output other = (Output) obj;
        return Objects.equals(outputKey(), other.outputKey()) && Objects.equals(outputValue(), other.outputValue())
                && Objects.equals(description(), other.description()) && Objects.equals(exportName(), other.exportName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Output").add("OutputKey", outputKey()).add("OutputValue", outputValue())
                .add("Description", description()).add("ExportName", exportName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "OutputKey":
            return Optional.ofNullable(clazz.cast(outputKey()));
        case "OutputValue":
            return Optional.ofNullable(clazz.cast(outputValue()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "ExportName":
            return Optional.ofNullable(clazz.cast(exportName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("OutputKey", OUTPUT_KEY_FIELD);
        map.put("OutputValue", OUTPUT_VALUE_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("ExportName", EXPORT_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Output, T> g) {
        return obj -> g.apply((Output) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Output> {
        /**
         * <p>
         * The key associated with the output.
         * </p>
         * 
         * @param outputKey
         *        The key associated with the output.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputKey(String outputKey);

        /**
         * <p>
         * The value associated with the output.
         * </p>
         * 
         * @param outputValue
         *        The value associated with the output.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputValue(String outputValue);

        /**
         * <p>
         * User defined description associated with the output.
         * </p>
         * 
         * @param description
         *        User defined description associated with the output.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The name of the export associated with the output.
         * </p>
         * 
         * @param exportName
         *        The name of the export associated with the output.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exportName(String exportName);
    }

    static final class BuilderImpl implements Builder {
        private String outputKey;

        private String outputValue;

        private String description;

        private String exportName;

        private BuilderImpl() {
        }

        private BuilderImpl(Output model) {
            outputKey(model.outputKey);
            outputValue(model.outputValue);
            description(model.description);
            exportName(model.exportName);
        }

        public final String getOutputKey() {
            return outputKey;
        }

        public final void setOutputKey(String outputKey) {
            this.outputKey = outputKey;
        }

        @Override
        public final Builder outputKey(String outputKey) {
            this.outputKey = outputKey;
            return this;
        }

        public final String getOutputValue() {
            return outputValue;
        }

        public final void setOutputValue(String outputValue) {
            this.outputValue = outputValue;
        }

        @Override
        public final Builder outputValue(String outputValue) {
            this.outputValue = outputValue;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getExportName() {
            return exportName;
        }

        public final void setExportName(String exportName) {
            this.exportName = exportName;
        }

        @Override
        public final Builder exportName(String exportName) {
            this.exportName = exportName;
            return this;
        }

        @Override
        public Output build() {
            return new Output(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
