/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudformation.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The <code>Annotation</code> data type.
 * </p>
 * <p>
 * A <code>GetHookResult</code> call returns detailed information and remediation guidance from Control Tower, Guard,
 * Lambda, or custom Hooks for a Hook invocation result.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Annotation implements SdkPojo, Serializable, ToCopyableBuilder<Annotation.Builder, Annotation> {
    private static final SdkField<String> ANNOTATION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AnnotationName").getter(getter(Annotation::annotationName)).setter(setter(Builder::annotationName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AnnotationName").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(Annotation::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StatusMessage").getter(getter(Annotation::statusMessage)).setter(setter(Builder::statusMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusMessage").build()).build();

    private static final SdkField<String> REMEDIATION_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RemediationMessage").getter(getter(Annotation::remediationMessage))
            .setter(setter(Builder::remediationMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RemediationMessage").build())
            .build();

    private static final SdkField<String> REMEDIATION_LINK_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RemediationLink").getter(getter(Annotation::remediationLink)).setter(setter(Builder::remediationLink))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RemediationLink").build()).build();

    private static final SdkField<String> SEVERITY_LEVEL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SeverityLevel").getter(getter(Annotation::severityLevelAsString)).setter(setter(Builder::severityLevel))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SeverityLevel").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ANNOTATION_NAME_FIELD,
            STATUS_FIELD, STATUS_MESSAGE_FIELD, REMEDIATION_MESSAGE_FIELD, REMEDIATION_LINK_FIELD, SEVERITY_LEVEL_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String annotationName;

    private final String status;

    private final String statusMessage;

    private final String remediationMessage;

    private final String remediationLink;

    private final String severityLevel;

    private Annotation(BuilderImpl builder) {
        this.annotationName = builder.annotationName;
        this.status = builder.status;
        this.statusMessage = builder.statusMessage;
        this.remediationMessage = builder.remediationMessage;
        this.remediationLink = builder.remediationLink;
        this.severityLevel = builder.severityLevel;
    }

    /**
     * <p>
     * An identifier for the evaluation logic that was used when invoking the Hook. For Control Tower, this is the
     * control ID. For Guard, this is the rule ID. For Lambda and custom Hooks, this is a user-defined identifier.
     * </p>
     * 
     * @return An identifier for the evaluation logic that was used when invoking the Hook. For Control Tower, this is
     *         the control ID. For Guard, this is the rule ID. For Lambda and custom Hooks, this is a user-defined
     *         identifier.
     */
    public final String annotationName() {
        return annotationName;
    }

    /**
     * <p>
     * The status of the Hook invocation from the downstream service.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link AnnotationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the Hook invocation from the downstream service.
     * @see AnnotationStatus
     */
    public final AnnotationStatus status() {
        return AnnotationStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the Hook invocation from the downstream service.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link AnnotationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the Hook invocation from the downstream service.
     * @see AnnotationStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The explanation for the specific status assigned to this Hook invocation. For example,
     * "Bucket does not block public access".
     * </p>
     * 
     * @return The explanation for the specific status assigned to this Hook invocation. For example,
     *         "Bucket does not block public access".
     */
    public final String statusMessage() {
        return statusMessage;
    }

    /**
     * <p>
     * Suggests what to change if your Hook returns a <code>FAILED</code> status. For example,
     * "Block public access to the bucket".
     * </p>
     * 
     * @return Suggests what to change if your Hook returns a <code>FAILED</code> status. For example,
     *         "Block public access to the bucket".
     */
    public final String remediationMessage() {
        return remediationMessage;
    }

    /**
     * <p>
     * A URL that you can access for additional remediation guidance.
     * </p>
     * 
     * @return A URL that you can access for additional remediation guidance.
     */
    public final String remediationLink() {
        return remediationLink;
    }

    /**
     * <p>
     * The relative risk associated with any violations of this type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #severityLevel}
     * will return {@link AnnotationSeverityLevel#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #severityLevelAsString}.
     * </p>
     * 
     * @return The relative risk associated with any violations of this type.
     * @see AnnotationSeverityLevel
     */
    public final AnnotationSeverityLevel severityLevel() {
        return AnnotationSeverityLevel.fromValue(severityLevel);
    }

    /**
     * <p>
     * The relative risk associated with any violations of this type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #severityLevel}
     * will return {@link AnnotationSeverityLevel#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #severityLevelAsString}.
     * </p>
     * 
     * @return The relative risk associated with any violations of this type.
     * @see AnnotationSeverityLevel
     */
    public final String severityLevelAsString() {
        return severityLevel;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(annotationName());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(remediationMessage());
        hashCode = 31 * hashCode + Objects.hashCode(remediationLink());
        hashCode = 31 * hashCode + Objects.hashCode(severityLevelAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Annotation)) {
            return false;
        }
        Annotation other = (Annotation) obj;
        return Objects.equals(annotationName(), other.annotationName())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(statusMessage(), other.statusMessage())
                && Objects.equals(remediationMessage(), other.remediationMessage())
                && Objects.equals(remediationLink(), other.remediationLink())
                && Objects.equals(severityLevelAsString(), other.severityLevelAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Annotation").add("AnnotationName", annotationName()).add("Status", statusAsString())
                .add("StatusMessage", statusMessage()).add("RemediationMessage", remediationMessage())
                .add("RemediationLink", remediationLink()).add("SeverityLevel", severityLevelAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AnnotationName":
            return Optional.ofNullable(clazz.cast(annotationName()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "StatusMessage":
            return Optional.ofNullable(clazz.cast(statusMessage()));
        case "RemediationMessage":
            return Optional.ofNullable(clazz.cast(remediationMessage()));
        case "RemediationLink":
            return Optional.ofNullable(clazz.cast(remediationLink()));
        case "SeverityLevel":
            return Optional.ofNullable(clazz.cast(severityLevelAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AnnotationName", ANNOTATION_NAME_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("StatusMessage", STATUS_MESSAGE_FIELD);
        map.put("RemediationMessage", REMEDIATION_MESSAGE_FIELD);
        map.put("RemediationLink", REMEDIATION_LINK_FIELD);
        map.put("SeverityLevel", SEVERITY_LEVEL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Annotation, T> g) {
        return obj -> g.apply((Annotation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Annotation> {
        /**
         * <p>
         * An identifier for the evaluation logic that was used when invoking the Hook. For Control Tower, this is the
         * control ID. For Guard, this is the rule ID. For Lambda and custom Hooks, this is a user-defined identifier.
         * </p>
         * 
         * @param annotationName
         *        An identifier for the evaluation logic that was used when invoking the Hook. For Control Tower, this
         *        is the control ID. For Guard, this is the rule ID. For Lambda and custom Hooks, this is a user-defined
         *        identifier.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder annotationName(String annotationName);

        /**
         * <p>
         * The status of the Hook invocation from the downstream service.
         * </p>
         * 
         * @param status
         *        The status of the Hook invocation from the downstream service.
         * @see AnnotationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AnnotationStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the Hook invocation from the downstream service.
         * </p>
         * 
         * @param status
         *        The status of the Hook invocation from the downstream service.
         * @see AnnotationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AnnotationStatus
         */
        Builder status(AnnotationStatus status);

        /**
         * <p>
         * The explanation for the specific status assigned to this Hook invocation. For example,
         * "Bucket does not block public access".
         * </p>
         * 
         * @param statusMessage
         *        The explanation for the specific status assigned to this Hook invocation. For example,
         *        "Bucket does not block public access".
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusMessage(String statusMessage);

        /**
         * <p>
         * Suggests what to change if your Hook returns a <code>FAILED</code> status. For example,
         * "Block public access to the bucket".
         * </p>
         * 
         * @param remediationMessage
         *        Suggests what to change if your Hook returns a <code>FAILED</code> status. For example,
         *        "Block public access to the bucket".
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder remediationMessage(String remediationMessage);

        /**
         * <p>
         * A URL that you can access for additional remediation guidance.
         * </p>
         * 
         * @param remediationLink
         *        A URL that you can access for additional remediation guidance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder remediationLink(String remediationLink);

        /**
         * <p>
         * The relative risk associated with any violations of this type.
         * </p>
         * 
         * @param severityLevel
         *        The relative risk associated with any violations of this type.
         * @see AnnotationSeverityLevel
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AnnotationSeverityLevel
         */
        Builder severityLevel(String severityLevel);

        /**
         * <p>
         * The relative risk associated with any violations of this type.
         * </p>
         * 
         * @param severityLevel
         *        The relative risk associated with any violations of this type.
         * @see AnnotationSeverityLevel
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AnnotationSeverityLevel
         */
        Builder severityLevel(AnnotationSeverityLevel severityLevel);
    }

    static final class BuilderImpl implements Builder {
        private String annotationName;

        private String status;

        private String statusMessage;

        private String remediationMessage;

        private String remediationLink;

        private String severityLevel;

        private BuilderImpl() {
        }

        private BuilderImpl(Annotation model) {
            annotationName(model.annotationName);
            status(model.status);
            statusMessage(model.statusMessage);
            remediationMessage(model.remediationMessage);
            remediationLink(model.remediationLink);
            severityLevel(model.severityLevel);
        }

        public final String getAnnotationName() {
            return annotationName;
        }

        public final void setAnnotationName(String annotationName) {
            this.annotationName = annotationName;
        }

        @Override
        public final Builder annotationName(String annotationName) {
            this.annotationName = annotationName;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(AnnotationStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusMessage() {
            return statusMessage;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public final String getRemediationMessage() {
            return remediationMessage;
        }

        public final void setRemediationMessage(String remediationMessage) {
            this.remediationMessage = remediationMessage;
        }

        @Override
        public final Builder remediationMessage(String remediationMessage) {
            this.remediationMessage = remediationMessage;
            return this;
        }

        public final String getRemediationLink() {
            return remediationLink;
        }

        public final void setRemediationLink(String remediationLink) {
            this.remediationLink = remediationLink;
        }

        @Override
        public final Builder remediationLink(String remediationLink) {
            this.remediationLink = remediationLink;
            return this;
        }

        public final String getSeverityLevel() {
            return severityLevel;
        }

        public final void setSeverityLevel(String severityLevel) {
            this.severityLevel = severityLevel;
        }

        @Override
        public final Builder severityLevel(String severityLevel) {
            this.severityLevel = severityLevel;
            return this;
        }

        @Override
        public final Builder severityLevel(AnnotationSeverityLevel severityLevel) {
            this.severityLevel(severityLevel == null ? null : severityLevel.toString());
            return this;
        }

        @Override
        public Annotation build() {
            return new Annotation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
