/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudformation.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The <code>HookTarget</code> data type.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class HookTarget implements SdkPojo, Serializable, ToCopyableBuilder<HookTarget.Builder, HookTarget> {
    private static final SdkField<String> TARGET_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TargetType").getter(getter(HookTarget::targetTypeAsString)).setter(setter(Builder::targetType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetType").build()).build();

    private static final SdkField<String> TARGET_TYPE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TargetTypeName").getter(getter(HookTarget::targetTypeName)).setter(setter(Builder::targetTypeName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetTypeName").build()).build();

    private static final SdkField<String> TARGET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TargetId").getter(getter(HookTarget::targetId)).setter(setter(Builder::targetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetId").build()).build();

    private static final SdkField<String> ACTION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Action")
            .getter(getter(HookTarget::actionAsString)).setter(setter(Builder::action))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Action").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TARGET_TYPE_FIELD,
            TARGET_TYPE_NAME_FIELD, TARGET_ID_FIELD, ACTION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String targetType;

    private final String targetTypeName;

    private final String targetId;

    private final String action;

    private HookTarget(BuilderImpl builder) {
        this.targetType = builder.targetType;
        this.targetTypeName = builder.targetTypeName;
        this.targetId = builder.targetId;
        this.action = builder.action;
    }

    /**
     * <p>
     * The target type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #targetType} will
     * return {@link HookTargetType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #targetTypeAsString}.
     * </p>
     * 
     * @return The target type.
     * @see HookTargetType
     */
    public final HookTargetType targetType() {
        return HookTargetType.fromValue(targetType);
    }

    /**
     * <p>
     * The target type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #targetType} will
     * return {@link HookTargetType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #targetTypeAsString}.
     * </p>
     * 
     * @return The target type.
     * @see HookTargetType
     */
    public final String targetTypeAsString() {
        return targetType;
    }

    /**
     * <p>
     * The target name, for example, <code>AWS::S3::Bucket</code>.
     * </p>
     * 
     * @return The target name, for example, <code>AWS::S3::Bucket</code>.
     */
    public final String targetTypeName() {
        return targetTypeName;
    }

    /**
     * <p>
     * The unique identifier of the Hook invocation target.
     * </p>
     * 
     * @return The unique identifier of the Hook invocation target.
     */
    public final String targetId() {
        return targetId;
    }

    /**
     * <p>
     * The action that invoked the Hook.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #action} will
     * return {@link HookTargetAction#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #actionAsString}.
     * </p>
     * 
     * @return The action that invoked the Hook.
     * @see HookTargetAction
     */
    public final HookTargetAction action() {
        return HookTargetAction.fromValue(action);
    }

    /**
     * <p>
     * The action that invoked the Hook.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #action} will
     * return {@link HookTargetAction#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #actionAsString}.
     * </p>
     * 
     * @return The action that invoked the Hook.
     * @see HookTargetAction
     */
    public final String actionAsString() {
        return action;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(targetTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(targetTypeName());
        hashCode = 31 * hashCode + Objects.hashCode(targetId());
        hashCode = 31 * hashCode + Objects.hashCode(actionAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HookTarget)) {
            return false;
        }
        HookTarget other = (HookTarget) obj;
        return Objects.equals(targetTypeAsString(), other.targetTypeAsString())
                && Objects.equals(targetTypeName(), other.targetTypeName()) && Objects.equals(targetId(), other.targetId())
                && Objects.equals(actionAsString(), other.actionAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("HookTarget").add("TargetType", targetTypeAsString()).add("TargetTypeName", targetTypeName())
                .add("TargetId", targetId()).add("Action", actionAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TargetType":
            return Optional.ofNullable(clazz.cast(targetTypeAsString()));
        case "TargetTypeName":
            return Optional.ofNullable(clazz.cast(targetTypeName()));
        case "TargetId":
            return Optional.ofNullable(clazz.cast(targetId()));
        case "Action":
            return Optional.ofNullable(clazz.cast(actionAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("TargetType", TARGET_TYPE_FIELD);
        map.put("TargetTypeName", TARGET_TYPE_NAME_FIELD);
        map.put("TargetId", TARGET_ID_FIELD);
        map.put("Action", ACTION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<HookTarget, T> g) {
        return obj -> g.apply((HookTarget) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, HookTarget> {
        /**
         * <p>
         * The target type.
         * </p>
         * 
         * @param targetType
         *        The target type.
         * @see HookTargetType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HookTargetType
         */
        Builder targetType(String targetType);

        /**
         * <p>
         * The target type.
         * </p>
         * 
         * @param targetType
         *        The target type.
         * @see HookTargetType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HookTargetType
         */
        Builder targetType(HookTargetType targetType);

        /**
         * <p>
         * The target name, for example, <code>AWS::S3::Bucket</code>.
         * </p>
         * 
         * @param targetTypeName
         *        The target name, for example, <code>AWS::S3::Bucket</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetTypeName(String targetTypeName);

        /**
         * <p>
         * The unique identifier of the Hook invocation target.
         * </p>
         * 
         * @param targetId
         *        The unique identifier of the Hook invocation target.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetId(String targetId);

        /**
         * <p>
         * The action that invoked the Hook.
         * </p>
         * 
         * @param action
         *        The action that invoked the Hook.
         * @see HookTargetAction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HookTargetAction
         */
        Builder action(String action);

        /**
         * <p>
         * The action that invoked the Hook.
         * </p>
         * 
         * @param action
         *        The action that invoked the Hook.
         * @see HookTargetAction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HookTargetAction
         */
        Builder action(HookTargetAction action);
    }

    static final class BuilderImpl implements Builder {
        private String targetType;

        private String targetTypeName;

        private String targetId;

        private String action;

        private BuilderImpl() {
        }

        private BuilderImpl(HookTarget model) {
            targetType(model.targetType);
            targetTypeName(model.targetTypeName);
            targetId(model.targetId);
            action(model.action);
        }

        public final String getTargetType() {
            return targetType;
        }

        public final void setTargetType(String targetType) {
            this.targetType = targetType;
        }

        @Override
        public final Builder targetType(String targetType) {
            this.targetType = targetType;
            return this;
        }

        @Override
        public final Builder targetType(HookTargetType targetType) {
            this.targetType(targetType == null ? null : targetType.toString());
            return this;
        }

        public final String getTargetTypeName() {
            return targetTypeName;
        }

        public final void setTargetTypeName(String targetTypeName) {
            this.targetTypeName = targetTypeName;
        }

        @Override
        public final Builder targetTypeName(String targetTypeName) {
            this.targetTypeName = targetTypeName;
            return this;
        }

        public final String getTargetId() {
            return targetId;
        }

        public final void setTargetId(String targetId) {
            this.targetId = targetId;
        }

        @Override
        public final Builder targetId(String targetId) {
            this.targetId = targetId;
            return this;
        }

        public final String getAction() {
            return action;
        }

        public final void setAction(String action) {
            this.action = action;
        }

        @Override
        public final Builder action(String action) {
            this.action = action;
            return this;
        }

        @Override
        public final Builder action(HookTargetAction action) {
            this.action(action == null ? null : action.toString());
            return this;
        }

        @Override
        public HookTarget build() {
            return new HookTarget(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
