/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudformation.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains drift information for a resource property, including actual value, previous deployment value, and drift
 * detection timestamp.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LiveResourceDrift implements SdkPojo, Serializable,
        ToCopyableBuilder<LiveResourceDrift.Builder, LiveResourceDrift> {
    private static final SdkField<String> PREVIOUS_VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PreviousValue").getter(getter(LiveResourceDrift::previousValue)).setter(setter(Builder::previousValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PreviousValue").build()).build();

    private static final SdkField<String> ACTUAL_VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ActualValue").getter(getter(LiveResourceDrift::actualValue)).setter(setter(Builder::actualValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActualValue").build()).build();

    private static final SdkField<Instant> DRIFT_DETECTION_TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("DriftDetectionTimestamp").getter(getter(LiveResourceDrift::driftDetectionTimestamp))
            .setter(setter(Builder::driftDetectionTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DriftDetectionTimestamp").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PREVIOUS_VALUE_FIELD,
            ACTUAL_VALUE_FIELD, DRIFT_DETECTION_TIMESTAMP_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String previousValue;

    private final String actualValue;

    private final Instant driftDetectionTimestamp;

    private LiveResourceDrift(BuilderImpl builder) {
        this.previousValue = builder.previousValue;
        this.actualValue = builder.actualValue;
        this.driftDetectionTimestamp = builder.driftDetectionTimestamp;
    }

    /**
     * <p>
     * The configuration value from the previous CloudFormation deployment.
     * </p>
     * 
     * @return The configuration value from the previous CloudFormation deployment.
     */
    public final String previousValue() {
        return previousValue;
    }

    /**
     * <p>
     * The current live configuration value of the resource property.
     * </p>
     * 
     * @return The current live configuration value of the resource property.
     */
    public final String actualValue() {
        return actualValue;
    }

    /**
     * <p>
     * The timestamp when drift was detected for this resource property.
     * </p>
     * 
     * @return The timestamp when drift was detected for this resource property.
     */
    public final Instant driftDetectionTimestamp() {
        return driftDetectionTimestamp;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(previousValue());
        hashCode = 31 * hashCode + Objects.hashCode(actualValue());
        hashCode = 31 * hashCode + Objects.hashCode(driftDetectionTimestamp());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LiveResourceDrift)) {
            return false;
        }
        LiveResourceDrift other = (LiveResourceDrift) obj;
        return Objects.equals(previousValue(), other.previousValue()) && Objects.equals(actualValue(), other.actualValue())
                && Objects.equals(driftDetectionTimestamp(), other.driftDetectionTimestamp());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LiveResourceDrift").add("PreviousValue", previousValue()).add("ActualValue", actualValue())
                .add("DriftDetectionTimestamp", driftDetectionTimestamp()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PreviousValue":
            return Optional.ofNullable(clazz.cast(previousValue()));
        case "ActualValue":
            return Optional.ofNullable(clazz.cast(actualValue()));
        case "DriftDetectionTimestamp":
            return Optional.ofNullable(clazz.cast(driftDetectionTimestamp()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("PreviousValue", PREVIOUS_VALUE_FIELD);
        map.put("ActualValue", ACTUAL_VALUE_FIELD);
        map.put("DriftDetectionTimestamp", DRIFT_DETECTION_TIMESTAMP_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<LiveResourceDrift, T> g) {
        return obj -> g.apply((LiveResourceDrift) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LiveResourceDrift> {
        /**
         * <p>
         * The configuration value from the previous CloudFormation deployment.
         * </p>
         * 
         * @param previousValue
         *        The configuration value from the previous CloudFormation deployment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder previousValue(String previousValue);

        /**
         * <p>
         * The current live configuration value of the resource property.
         * </p>
         * 
         * @param actualValue
         *        The current live configuration value of the resource property.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actualValue(String actualValue);

        /**
         * <p>
         * The timestamp when drift was detected for this resource property.
         * </p>
         * 
         * @param driftDetectionTimestamp
         *        The timestamp when drift was detected for this resource property.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder driftDetectionTimestamp(Instant driftDetectionTimestamp);
    }

    static final class BuilderImpl implements Builder {
        private String previousValue;

        private String actualValue;

        private Instant driftDetectionTimestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(LiveResourceDrift model) {
            previousValue(model.previousValue);
            actualValue(model.actualValue);
            driftDetectionTimestamp(model.driftDetectionTimestamp);
        }

        public final String getPreviousValue() {
            return previousValue;
        }

        public final void setPreviousValue(String previousValue) {
            this.previousValue = previousValue;
        }

        @Override
        public final Builder previousValue(String previousValue) {
            this.previousValue = previousValue;
            return this;
        }

        public final String getActualValue() {
            return actualValue;
        }

        public final void setActualValue(String actualValue) {
            this.actualValue = actualValue;
        }

        @Override
        public final Builder actualValue(String actualValue) {
            this.actualValue = actualValue;
            return this;
        }

        public final Instant getDriftDetectionTimestamp() {
            return driftDetectionTimestamp;
        }

        public final void setDriftDetectionTimestamp(Instant driftDetectionTimestamp) {
            this.driftDetectionTimestamp = driftDetectionTimestamp;
        }

        @Override
        public final Builder driftDetectionTimestamp(Instant driftDetectionTimestamp) {
            this.driftDetectionTimestamp = driftDetectionTimestamp;
            return this;
        }

        @Override
        public LiveResourceDrift build() {
            return new LiveResourceDrift(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
