/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudformation.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The input for <a>CreateStack</a> action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateStackRequest extends CloudFormationRequest implements
        ToCopyableBuilder<CreateStackRequest.Builder, CreateStackRequest> {
    private static final SdkField<String> STACK_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateStackRequest::stackName)).setter(setter(Builder::stackName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StackName").build()).build();

    private static final SdkField<String> TEMPLATE_BODY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateStackRequest::templateBody)).setter(setter(Builder::templateBody))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TemplateBody").build()).build();

    private static final SdkField<String> TEMPLATE_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateStackRequest::templateURL)).setter(setter(Builder::templateURL))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TemplateURL").build()).build();

    private static final SdkField<List<Parameter>> PARAMETERS_FIELD = SdkField
            .<List<Parameter>> builder(MarshallingType.LIST)
            .getter(getter(CreateStackRequest::parameters))
            .setter(setter(Builder::parameters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Parameters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Parameter> builder(MarshallingType.SDK_POJO)
                                            .constructor(Parameter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Boolean> DISABLE_ROLLBACK_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(CreateStackRequest::disableRollback)).setter(setter(Builder::disableRollback))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisableRollback").build()).build();

    private static final SdkField<RollbackConfiguration> ROLLBACK_CONFIGURATION_FIELD = SdkField
            .<RollbackConfiguration> builder(MarshallingType.SDK_POJO).getter(getter(CreateStackRequest::rollbackConfiguration))
            .setter(setter(Builder::rollbackConfiguration)).constructor(RollbackConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RollbackConfiguration").build())
            .build();

    private static final SdkField<Integer> TIMEOUT_IN_MINUTES_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(CreateStackRequest::timeoutInMinutes)).setter(setter(Builder::timeoutInMinutes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimeoutInMinutes").build()).build();

    private static final SdkField<List<String>> NOTIFICATION_AR_NS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(CreateStackRequest::notificationARNs))
            .setter(setter(Builder::notificationARNs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NotificationARNs").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> CAPABILITIES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(CreateStackRequest::capabilitiesAsStrings))
            .setter(setter(Builder::capabilitiesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Capabilities").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> RESOURCE_TYPES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(CreateStackRequest::resourceTypes))
            .setter(setter(Builder::resourceTypes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceTypes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateStackRequest::roleARN)).setter(setter(Builder::roleARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleARN").build()).build();

    private static final SdkField<String> ON_FAILURE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateStackRequest::onFailureAsString)).setter(setter(Builder::onFailure))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OnFailure").build()).build();

    private static final SdkField<String> STACK_POLICY_BODY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateStackRequest::stackPolicyBody)).setter(setter(Builder::stackPolicyBody))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StackPolicyBody").build()).build();

    private static final SdkField<String> STACK_POLICY_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateStackRequest::stackPolicyURL)).setter(setter(Builder::stackPolicyURL))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StackPolicyURL").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .getter(getter(CreateStackRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateStackRequest::clientRequestToken)).setter(setter(Builder::clientRequestToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientRequestToken").build())
            .build();

    private static final SdkField<Boolean> ENABLE_TERMINATION_PROTECTION_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(CreateStackRequest::enableTerminationProtection))
            .setter(setter(Builder::enableTerminationProtection))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnableTerminationProtection")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STACK_NAME_FIELD,
            TEMPLATE_BODY_FIELD, TEMPLATE_URL_FIELD, PARAMETERS_FIELD, DISABLE_ROLLBACK_FIELD, ROLLBACK_CONFIGURATION_FIELD,
            TIMEOUT_IN_MINUTES_FIELD, NOTIFICATION_AR_NS_FIELD, CAPABILITIES_FIELD, RESOURCE_TYPES_FIELD, ROLE_ARN_FIELD,
            ON_FAILURE_FIELD, STACK_POLICY_BODY_FIELD, STACK_POLICY_URL_FIELD, TAGS_FIELD, CLIENT_REQUEST_TOKEN_FIELD,
            ENABLE_TERMINATION_PROTECTION_FIELD));

    private final String stackName;

    private final String templateBody;

    private final String templateURL;

    private final List<Parameter> parameters;

    private final Boolean disableRollback;

    private final RollbackConfiguration rollbackConfiguration;

    private final Integer timeoutInMinutes;

    private final List<String> notificationARNs;

    private final List<String> capabilities;

    private final List<String> resourceTypes;

    private final String roleARN;

    private final String onFailure;

    private final String stackPolicyBody;

    private final String stackPolicyURL;

    private final List<Tag> tags;

    private final String clientRequestToken;

    private final Boolean enableTerminationProtection;

    private CreateStackRequest(BuilderImpl builder) {
        super(builder);
        this.stackName = builder.stackName;
        this.templateBody = builder.templateBody;
        this.templateURL = builder.templateURL;
        this.parameters = builder.parameters;
        this.disableRollback = builder.disableRollback;
        this.rollbackConfiguration = builder.rollbackConfiguration;
        this.timeoutInMinutes = builder.timeoutInMinutes;
        this.notificationARNs = builder.notificationARNs;
        this.capabilities = builder.capabilities;
        this.resourceTypes = builder.resourceTypes;
        this.roleARN = builder.roleARN;
        this.onFailure = builder.onFailure;
        this.stackPolicyBody = builder.stackPolicyBody;
        this.stackPolicyURL = builder.stackPolicyURL;
        this.tags = builder.tags;
        this.clientRequestToken = builder.clientRequestToken;
        this.enableTerminationProtection = builder.enableTerminationProtection;
    }

    /**
     * <p>
     * The name that is associated with the stack. The name must be unique in the region in which you are creating the
     * stack.
     * </p>
     * <note>
     * <p>
     * A stack name can contain only alphanumeric characters (case sensitive) and hyphens. It must start with an
     * alphabetic character and cannot be longer than 128 characters.
     * </p>
     * </note>
     * 
     * @return The name that is associated with the stack. The name must be unique in the region in which you are
     *         creating the stack.</p> <note>
     *         <p>
     *         A stack name can contain only alphanumeric characters (case sensitive) and hyphens. It must start with an
     *         alphabetic character and cannot be longer than 128 characters.
     *         </p>
     */
    public String stackName() {
        return stackName;
    }

    /**
     * <p>
     * Structure containing the template body with a minimum length of 1 byte and a maximum length of 51,200 bytes. For
     * more information, go to <a
     * href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html">Template Anatomy</a>
     * in the AWS CloudFormation User Guide.
     * </p>
     * <p>
     * Conditional: You must specify either the <code>TemplateBody</code> or the <code>TemplateURL</code> parameter, but
     * not both.
     * </p>
     * 
     * @return Structure containing the template body with a minimum length of 1 byte and a maximum length of 51,200
     *         bytes. For more information, go to <a
     *         href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html">Template
     *         Anatomy</a> in the AWS CloudFormation User Guide.</p>
     *         <p>
     *         Conditional: You must specify either the <code>TemplateBody</code> or the <code>TemplateURL</code>
     *         parameter, but not both.
     */
    public String templateBody() {
        return templateBody;
    }

    /**
     * <p>
     * Location of file containing the template body. The URL must point to a template (max size: 460,800 bytes) that is
     * located in an Amazon S3 bucket. For more information, go to the <a
     * href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html">Template Anatomy</a>
     * in the AWS CloudFormation User Guide.
     * </p>
     * <p>
     * Conditional: You must specify either the <code>TemplateBody</code> or the <code>TemplateURL</code> parameter, but
     * not both.
     * </p>
     * 
     * @return Location of file containing the template body. The URL must point to a template (max size: 460,800 bytes)
     *         that is located in an Amazon S3 bucket. For more information, go to the <a
     *         href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html">Template
     *         Anatomy</a> in the AWS CloudFormation User Guide.</p>
     *         <p>
     *         Conditional: You must specify either the <code>TemplateBody</code> or the <code>TemplateURL</code>
     *         parameter, but not both.
     */
    public String templateURL() {
        return templateURL;
    }

    /**
     * <p>
     * A list of <code>Parameter</code> structures that specify input parameters for the stack. For more information,
     * see the <a
     * href="http://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_Parameter.html">Parameter</a> data
     * type.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A list of <code>Parameter</code> structures that specify input parameters for the stack. For more
     *         information, see the <a
     *         href="http://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_Parameter.html">Parameter</a>
     *         data type.
     */
    public List<Parameter> parameters() {
        return parameters;
    }

    /**
     * <p>
     * Set to <code>true</code> to disable rollback of the stack if stack creation failed. You can specify either
     * <code>DisableRollback</code> or <code>OnFailure</code>, but not both.
     * </p>
     * <p>
     * Default: <code>false</code>
     * </p>
     * 
     * @return Set to <code>true</code> to disable rollback of the stack if stack creation failed. You can specify
     *         either <code>DisableRollback</code> or <code>OnFailure</code>, but not both.</p>
     *         <p>
     *         Default: <code>false</code>
     */
    public Boolean disableRollback() {
        return disableRollback;
    }

    /**
     * <p>
     * The rollback triggers for AWS CloudFormation to monitor during stack creation and updating operations, and for
     * the specified monitoring period afterwards.
     * </p>
     * 
     * @return The rollback triggers for AWS CloudFormation to monitor during stack creation and updating operations,
     *         and for the specified monitoring period afterwards.
     */
    public RollbackConfiguration rollbackConfiguration() {
        return rollbackConfiguration;
    }

    /**
     * <p>
     * The amount of time that can pass before the stack status becomes CREATE_FAILED; if <code>DisableRollback</code>
     * is not set or is set to <code>false</code>, the stack will be rolled back.
     * </p>
     * 
     * @return The amount of time that can pass before the stack status becomes CREATE_FAILED; if
     *         <code>DisableRollback</code> is not set or is set to <code>false</code>, the stack will be rolled back.
     */
    public Integer timeoutInMinutes() {
        return timeoutInMinutes;
    }

    /**
     * <p>
     * The Simple Notification Service (SNS) topic ARNs to publish stack related events. You can find your SNS topic
     * ARNs using the SNS console or your Command Line Interface (CLI).
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The Simple Notification Service (SNS) topic ARNs to publish stack related events. You can find your SNS
     *         topic ARNs using the SNS console or your Command Line Interface (CLI).
     */
    public List<String> notificationARNs() {
        return notificationARNs;
    }

    /**
     * <p>
     * In some cases, you must explicity acknowledge that your stack template contains certain capabilities in order for
     * AWS CloudFormation to create the stack.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>CAPABILITY_IAM</code> and <code>CAPABILITY_NAMED_IAM</code>
     * </p>
     * <p>
     * Some stack templates might include resources that can affect permissions in your AWS account; for example, by
     * creating new AWS Identity and Access Management (IAM) users. For those stacks, you must explicitly acknowledge
     * this by specifying one of these capabilities.
     * </p>
     * <p>
     * The following IAM resources require you to specify either the <code>CAPABILITY_IAM</code> or
     * <code>CAPABILITY_NAMED_IAM</code> capability.
     * </p>
     * <ul>
     * <li>
     * <p>
     * If you have IAM resources, you can specify either capability.
     * </p>
     * </li>
     * <li>
     * <p>
     * If you have IAM resources with custom names, you <i>must</i> specify <code>CAPABILITY_NAMED_IAM</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * If you don't specify either of these capabilities, AWS CloudFormation returns an
     * <code>InsufficientCapabilities</code> error.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If your stack template contains these resources, we recommend that you review all permissions associated with
     * them and edit their permissions if necessary.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-accesskey.html">
     * AWS::IAM::AccessKey</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-group.html">
     * AWS::IAM::Group</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-instanceprofile.html">
     * AWS::IAM::InstanceProfile</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-policy.html">
     * AWS::IAM::Policy</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-role.html">
     * AWS::IAM::Role</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-user.html">
     * AWS::IAM::User</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-addusertogroup.html">
     * AWS::IAM::UserToGroupAddition</a>
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information, see <a
     * href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html#capabilities"
     * >Acknowledging IAM Resources in AWS CloudFormation Templates</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CAPABILITY_AUTO_EXPAND</code>
     * </p>
     * <p>
     * Some template contain macros. Macros perform custom processing on templates; this can include simple actions like
     * find-and-replace operations, all the way to extensive transformations of entire templates. Because of this, users
     * typically create a change set from the processed template, so that they can review the changes resulting from the
     * macros before actually creating the stack. If your stack template contains one or more macros, and you choose to
     * create a stack directly from the processed template, without first reviewing the resulting changes in a change
     * set, you must acknowledge this capability. This includes the <a href=
     * "http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/create-reusable-transform-function-snippets-and-add-to-your-template-with-aws-include-transform.html"
     * >AWS::Include</a> and <a
     * href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/transform-aws-serverless.html"
     * >AWS::Serverless</a> transforms, which are macros hosted by AWS CloudFormation.
     * </p>
     * <p>
     * Change sets do not currently support nested stacks. If you want to create a stack from a stack template that
     * contains macros <i>and</i> nested stacks, you must create the stack directly from the template using this
     * capability.
     * </p>
     * <important>
     * <p>
     * You should only create stacks directly from a stack template that contains macros if you know what processing the
     * macro performs.
     * </p>
     * <p>
     * Each macro relies on an underlying Lambda service function for processing stack templates. Be aware that the
     * Lambda function owner can update the function operation without AWS CloudFormation being notified.
     * </p>
     * </important>
     * <p>
     * For more information, see <a
     * href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-macros.html">Using AWS
     * CloudFormation Macros to Perform Custom Processing on Templates</a>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return In some cases, you must explicity acknowledge that your stack template contains certain capabilities in
     *         order for AWS CloudFormation to create the stack.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>CAPABILITY_IAM</code> and <code>CAPABILITY_NAMED_IAM</code>
     *         </p>
     *         <p>
     *         Some stack templates might include resources that can affect permissions in your AWS account; for
     *         example, by creating new AWS Identity and Access Management (IAM) users. For those stacks, you must
     *         explicitly acknowledge this by specifying one of these capabilities.
     *         </p>
     *         <p>
     *         The following IAM resources require you to specify either the <code>CAPABILITY_IAM</code> or
     *         <code>CAPABILITY_NAMED_IAM</code> capability.
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         If you have IAM resources, you can specify either capability.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         If you have IAM resources with custom names, you <i>must</i> specify <code>CAPABILITY_NAMED_IAM</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         If you don't specify either of these capabilities, AWS CloudFormation returns an
     *         <code>InsufficientCapabilities</code> error.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         If your stack template contains these resources, we recommend that you review all permissions associated
     *         with them and edit their permissions if necessary.
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <a
     *         href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-accesskey.html">
     *         AWS::IAM::AccessKey</a>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-group.html">
     *         AWS::IAM::Group</a>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <a href=
     *         "http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-instanceprofile.html">
     *         AWS::IAM::InstanceProfile</a>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-policy.html">
     *         AWS::IAM::Policy</a>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-role.html">
     *         AWS::IAM::Role</a>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-user.html">
     *         AWS::IAM::User</a>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <a href=
     *         "http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-addusertogroup.html">
     *         AWS::IAM::UserToGroupAddition</a>
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For more information, see <a href=
     *         "http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html#capabilities"
     *         >Acknowledging IAM Resources in AWS CloudFormation Templates</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CAPABILITY_AUTO_EXPAND</code>
     *         </p>
     *         <p>
     *         Some template contain macros. Macros perform custom processing on templates; this can include simple
     *         actions like find-and-replace operations, all the way to extensive transformations of entire templates.
     *         Because of this, users typically create a change set from the processed template, so that they can review
     *         the changes resulting from the macros before actually creating the stack. If your stack template contains
     *         one or more macros, and you choose to create a stack directly from the processed template, without first
     *         reviewing the resulting changes in a change set, you must acknowledge this capability. This includes the
     *         <a href=
     *         "http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/create-reusable-transform-function-snippets-and-add-to-your-template-with-aws-include-transform.html"
     *         >AWS::Include</a> and <a
     *         href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/transform-aws-serverless.html"
     *         >AWS::Serverless</a> transforms, which are macros hosted by AWS CloudFormation.
     *         </p>
     *         <p>
     *         Change sets do not currently support nested stacks. If you want to create a stack from a stack template
     *         that contains macros <i>and</i> nested stacks, you must create the stack directly from the template using
     *         this capability.
     *         </p>
     *         <important>
     *         <p>
     *         You should only create stacks directly from a stack template that contains macros if you know what
     *         processing the macro performs.
     *         </p>
     *         <p>
     *         Each macro relies on an underlying Lambda service function for processing stack templates. Be aware that
     *         the Lambda function owner can update the function operation without AWS CloudFormation being notified.
     *         </p>
     *         </important>
     *         <p>
     *         For more information, see <a
     *         href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-macros.html">Using AWS
     *         CloudFormation Macros to Perform Custom Processing on Templates</a>.
     *         </p>
     *         </li>
     */
    public List<Capability> capabilities() {
        return CapabilitiesCopier.copyStringToEnum(capabilities);
    }

    /**
     * <p>
     * In some cases, you must explicity acknowledge that your stack template contains certain capabilities in order for
     * AWS CloudFormation to create the stack.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>CAPABILITY_IAM</code> and <code>CAPABILITY_NAMED_IAM</code>
     * </p>
     * <p>
     * Some stack templates might include resources that can affect permissions in your AWS account; for example, by
     * creating new AWS Identity and Access Management (IAM) users. For those stacks, you must explicitly acknowledge
     * this by specifying one of these capabilities.
     * </p>
     * <p>
     * The following IAM resources require you to specify either the <code>CAPABILITY_IAM</code> or
     * <code>CAPABILITY_NAMED_IAM</code> capability.
     * </p>
     * <ul>
     * <li>
     * <p>
     * If you have IAM resources, you can specify either capability.
     * </p>
     * </li>
     * <li>
     * <p>
     * If you have IAM resources with custom names, you <i>must</i> specify <code>CAPABILITY_NAMED_IAM</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * If you don't specify either of these capabilities, AWS CloudFormation returns an
     * <code>InsufficientCapabilities</code> error.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If your stack template contains these resources, we recommend that you review all permissions associated with
     * them and edit their permissions if necessary.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-accesskey.html">
     * AWS::IAM::AccessKey</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-group.html">
     * AWS::IAM::Group</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-instanceprofile.html">
     * AWS::IAM::InstanceProfile</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-policy.html">
     * AWS::IAM::Policy</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-role.html">
     * AWS::IAM::Role</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-user.html">
     * AWS::IAM::User</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-addusertogroup.html">
     * AWS::IAM::UserToGroupAddition</a>
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information, see <a
     * href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html#capabilities"
     * >Acknowledging IAM Resources in AWS CloudFormation Templates</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CAPABILITY_AUTO_EXPAND</code>
     * </p>
     * <p>
     * Some template contain macros. Macros perform custom processing on templates; this can include simple actions like
     * find-and-replace operations, all the way to extensive transformations of entire templates. Because of this, users
     * typically create a change set from the processed template, so that they can review the changes resulting from the
     * macros before actually creating the stack. If your stack template contains one or more macros, and you choose to
     * create a stack directly from the processed template, without first reviewing the resulting changes in a change
     * set, you must acknowledge this capability. This includes the <a href=
     * "http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/create-reusable-transform-function-snippets-and-add-to-your-template-with-aws-include-transform.html"
     * >AWS::Include</a> and <a
     * href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/transform-aws-serverless.html"
     * >AWS::Serverless</a> transforms, which are macros hosted by AWS CloudFormation.
     * </p>
     * <p>
     * Change sets do not currently support nested stacks. If you want to create a stack from a stack template that
     * contains macros <i>and</i> nested stacks, you must create the stack directly from the template using this
     * capability.
     * </p>
     * <important>
     * <p>
     * You should only create stacks directly from a stack template that contains macros if you know what processing the
     * macro performs.
     * </p>
     * <p>
     * Each macro relies on an underlying Lambda service function for processing stack templates. Be aware that the
     * Lambda function owner can update the function operation without AWS CloudFormation being notified.
     * </p>
     * </important>
     * <p>
     * For more information, see <a
     * href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-macros.html">Using AWS
     * CloudFormation Macros to Perform Custom Processing on Templates</a>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return In some cases, you must explicity acknowledge that your stack template contains certain capabilities in
     *         order for AWS CloudFormation to create the stack.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>CAPABILITY_IAM</code> and <code>CAPABILITY_NAMED_IAM</code>
     *         </p>
     *         <p>
     *         Some stack templates might include resources that can affect permissions in your AWS account; for
     *         example, by creating new AWS Identity and Access Management (IAM) users. For those stacks, you must
     *         explicitly acknowledge this by specifying one of these capabilities.
     *         </p>
     *         <p>
     *         The following IAM resources require you to specify either the <code>CAPABILITY_IAM</code> or
     *         <code>CAPABILITY_NAMED_IAM</code> capability.
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         If you have IAM resources, you can specify either capability.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         If you have IAM resources with custom names, you <i>must</i> specify <code>CAPABILITY_NAMED_IAM</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         If you don't specify either of these capabilities, AWS CloudFormation returns an
     *         <code>InsufficientCapabilities</code> error.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         If your stack template contains these resources, we recommend that you review all permissions associated
     *         with them and edit their permissions if necessary.
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <a
     *         href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-accesskey.html">
     *         AWS::IAM::AccessKey</a>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-group.html">
     *         AWS::IAM::Group</a>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <a href=
     *         "http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-instanceprofile.html">
     *         AWS::IAM::InstanceProfile</a>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-policy.html">
     *         AWS::IAM::Policy</a>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-role.html">
     *         AWS::IAM::Role</a>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-user.html">
     *         AWS::IAM::User</a>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <a href=
     *         "http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-addusertogroup.html">
     *         AWS::IAM::UserToGroupAddition</a>
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For more information, see <a href=
     *         "http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html#capabilities"
     *         >Acknowledging IAM Resources in AWS CloudFormation Templates</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CAPABILITY_AUTO_EXPAND</code>
     *         </p>
     *         <p>
     *         Some template contain macros. Macros perform custom processing on templates; this can include simple
     *         actions like find-and-replace operations, all the way to extensive transformations of entire templates.
     *         Because of this, users typically create a change set from the processed template, so that they can review
     *         the changes resulting from the macros before actually creating the stack. If your stack template contains
     *         one or more macros, and you choose to create a stack directly from the processed template, without first
     *         reviewing the resulting changes in a change set, you must acknowledge this capability. This includes the
     *         <a href=
     *         "http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/create-reusable-transform-function-snippets-and-add-to-your-template-with-aws-include-transform.html"
     *         >AWS::Include</a> and <a
     *         href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/transform-aws-serverless.html"
     *         >AWS::Serverless</a> transforms, which are macros hosted by AWS CloudFormation.
     *         </p>
     *         <p>
     *         Change sets do not currently support nested stacks. If you want to create a stack from a stack template
     *         that contains macros <i>and</i> nested stacks, you must create the stack directly from the template using
     *         this capability.
     *         </p>
     *         <important>
     *         <p>
     *         You should only create stacks directly from a stack template that contains macros if you know what
     *         processing the macro performs.
     *         </p>
     *         <p>
     *         Each macro relies on an underlying Lambda service function for processing stack templates. Be aware that
     *         the Lambda function owner can update the function operation without AWS CloudFormation being notified.
     *         </p>
     *         </important>
     *         <p>
     *         For more information, see <a
     *         href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-macros.html">Using AWS
     *         CloudFormation Macros to Perform Custom Processing on Templates</a>.
     *         </p>
     *         </li>
     */
    public List<String> capabilitiesAsStrings() {
        return capabilities;
    }

    /**
     * <p>
     * The template resource types that you have permissions to work with for this create stack action, such as
     * <code>AWS::EC2::Instance</code>, <code>AWS::EC2::*</code>, or <code>Custom::MyCustomInstance</code>. Use the
     * following syntax to describe template resource types: <code>AWS::*</code> (for all AWS resource),
     * <code>Custom::*</code> (for all custom resources), <code>Custom::<i>logical_ID</i> </code> (for a specific custom
     * resource), <code>AWS::<i>service_name</i>::*</code> (for all resources of a particular AWS service), and
     * <code>AWS::<i>service_name</i>::<i>resource_logical_ID</i> </code> (for a specific AWS resource).
     * </p>
     * <p>
     * If the list of resource types doesn't include a resource that you're creating, the stack creation fails. By
     * default, AWS CloudFormation grants permissions to all resource types. AWS Identity and Access Management (IAM)
     * uses this parameter for AWS CloudFormation-specific condition keys in IAM policies. For more information, see <a
     * href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html">Controlling Access
     * with AWS Identity and Access Management</a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The template resource types that you have permissions to work with for this create stack action, such as
     *         <code>AWS::EC2::Instance</code>, <code>AWS::EC2::*</code>, or <code>Custom::MyCustomInstance</code>. Use
     *         the following syntax to describe template resource types: <code>AWS::*</code> (for all AWS resource),
     *         <code>Custom::*</code> (for all custom resources), <code>Custom::<i>logical_ID</i> </code> (for a
     *         specific custom resource), <code>AWS::<i>service_name</i>::*</code> (for all resources of a particular
     *         AWS service), and <code>AWS::<i>service_name</i>::<i>resource_logical_ID</i> </code> (for a specific AWS
     *         resource).</p>
     *         <p>
     *         If the list of resource types doesn't include a resource that you're creating, the stack creation fails.
     *         By default, AWS CloudFormation grants permissions to all resource types. AWS Identity and Access
     *         Management (IAM) uses this parameter for AWS CloudFormation-specific condition keys in IAM policies. For
     *         more information, see <a
     *         href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html">Controlling
     *         Access with AWS Identity and Access Management</a>.
     */
    public List<String> resourceTypes() {
        return resourceTypes;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of an AWS Identity and Access Management (IAM) role that AWS CloudFormation
     * assumes to create the stack. AWS CloudFormation uses the role's credentials to make calls on your behalf. AWS
     * CloudFormation always uses this role for all future operations on the stack. As long as users have permission to
     * operate on the stack, AWS CloudFormation uses this role even if the users don't have permission to pass it.
     * Ensure that the role grants least privilege.
     * </p>
     * <p>
     * If you don't specify a value, AWS CloudFormation uses the role that was previously associated with the stack. If
     * no role is available, AWS CloudFormation uses a temporary session that is generated from your user credentials.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of an AWS Identity and Access Management (IAM) role that AWS
     *         CloudFormation assumes to create the stack. AWS CloudFormation uses the role's credentials to make calls
     *         on your behalf. AWS CloudFormation always uses this role for all future operations on the stack. As long
     *         as users have permission to operate on the stack, AWS CloudFormation uses this role even if the users
     *         don't have permission to pass it. Ensure that the role grants least privilege.</p>
     *         <p>
     *         If you don't specify a value, AWS CloudFormation uses the role that was previously associated with the
     *         stack. If no role is available, AWS CloudFormation uses a temporary session that is generated from your
     *         user credentials.
     */
    public String roleARN() {
        return roleARN;
    }

    /**
     * <p>
     * Determines what action will be taken if stack creation fails. This must be one of: DO_NOTHING, ROLLBACK, or
     * DELETE. You can specify either <code>OnFailure</code> or <code>DisableRollback</code>, but not both.
     * </p>
     * <p>
     * Default: <code>ROLLBACK</code>
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #onFailure} will
     * return {@link OnFailure#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #onFailureAsString}.
     * </p>
     * 
     * @return Determines what action will be taken if stack creation fails. This must be one of: DO_NOTHING, ROLLBACK,
     *         or DELETE. You can specify either <code>OnFailure</code> or <code>DisableRollback</code>, but not
     *         both.</p>
     *         <p>
     *         Default: <code>ROLLBACK</code>
     * @see OnFailure
     */
    public OnFailure onFailure() {
        return OnFailure.fromValue(onFailure);
    }

    /**
     * <p>
     * Determines what action will be taken if stack creation fails. This must be one of: DO_NOTHING, ROLLBACK, or
     * DELETE. You can specify either <code>OnFailure</code> or <code>DisableRollback</code>, but not both.
     * </p>
     * <p>
     * Default: <code>ROLLBACK</code>
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #onFailure} will
     * return {@link OnFailure#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #onFailureAsString}.
     * </p>
     * 
     * @return Determines what action will be taken if stack creation fails. This must be one of: DO_NOTHING, ROLLBACK,
     *         or DELETE. You can specify either <code>OnFailure</code> or <code>DisableRollback</code>, but not
     *         both.</p>
     *         <p>
     *         Default: <code>ROLLBACK</code>
     * @see OnFailure
     */
    public String onFailureAsString() {
        return onFailure;
    }

    /**
     * <p>
     * Structure containing the stack policy body. For more information, go to <a
     * href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/protect-stack-resources.html"> Prevent
     * Updates to Stack Resources</a> in the <i>AWS CloudFormation User Guide</i>. You can specify either the
     * <code>StackPolicyBody</code> or the <code>StackPolicyURL</code> parameter, but not both.
     * </p>
     * 
     * @return Structure containing the stack policy body. For more information, go to <a
     *         href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/protect-stack-resources.html">
     *         Prevent Updates to Stack Resources</a> in the <i>AWS CloudFormation User Guide</i>. You can specify
     *         either the <code>StackPolicyBody</code> or the <code>StackPolicyURL</code> parameter, but not both.
     */
    public String stackPolicyBody() {
        return stackPolicyBody;
    }

    /**
     * <p>
     * Location of a file containing the stack policy. The URL must point to a policy (maximum size: 16 KB) located in
     * an S3 bucket in the same region as the stack. You can specify either the <code>StackPolicyBody</code> or the
     * <code>StackPolicyURL</code> parameter, but not both.
     * </p>
     * 
     * @return Location of a file containing the stack policy. The URL must point to a policy (maximum size: 16 KB)
     *         located in an S3 bucket in the same region as the stack. You can specify either the
     *         <code>StackPolicyBody</code> or the <code>StackPolicyURL</code> parameter, but not both.
     */
    public String stackPolicyURL() {
        return stackPolicyURL;
    }

    /**
     * <p>
     * Key-value pairs to associate with this stack. AWS CloudFormation also propagates these tags to the resources
     * created in the stack. A maximum number of 50 tags can be specified.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Key-value pairs to associate with this stack. AWS CloudFormation also propagates these tags to the
     *         resources created in the stack. A maximum number of 50 tags can be specified.
     */
    public List<Tag> tags() {
        return tags;
    }

    /**
     * <p>
     * A unique identifier for this <code>CreateStack</code> request. Specify this token if you plan to retry requests
     * so that AWS CloudFormation knows that you're not attempting to create a stack with the same name. You might retry
     * <code>CreateStack</code> requests to ensure that AWS CloudFormation successfully received them.
     * </p>
     * <p>
     * All events triggered by a given stack operation are assigned the same client request token, which you can use to
     * track operations. For example, if you execute a <code>CreateStack</code> operation with the token
     * <code>token1</code>, then all the <code>StackEvents</code> generated by that operation will have
     * <code>ClientRequestToken</code> set as <code>token1</code>.
     * </p>
     * <p>
     * In the console, stack operations display the client request token on the Events tab. Stack operations that are
     * initiated from the console use the token format <i>Console-StackOperation-ID</i>, which helps you easily identify
     * the stack operation . For example, if you create a stack using the console, each stack event would be assigned
     * the same token in the following format: <code>Console-CreateStack-7f59c3cf-00d2-40c7-b2ff-e75db0987002</code>.
     * </p>
     * 
     * @return A unique identifier for this <code>CreateStack</code> request. Specify this token if you plan to retry
     *         requests so that AWS CloudFormation knows that you're not attempting to create a stack with the same
     *         name. You might retry <code>CreateStack</code> requests to ensure that AWS CloudFormation successfully
     *         received them.</p>
     *         <p>
     *         All events triggered by a given stack operation are assigned the same client request token, which you can
     *         use to track operations. For example, if you execute a <code>CreateStack</code> operation with the token
     *         <code>token1</code>, then all the <code>StackEvents</code> generated by that operation will have
     *         <code>ClientRequestToken</code> set as <code>token1</code>.
     *         </p>
     *         <p>
     *         In the console, stack operations display the client request token on the Events tab. Stack operations
     *         that are initiated from the console use the token format <i>Console-StackOperation-ID</i>, which helps
     *         you easily identify the stack operation . For example, if you create a stack using the console, each
     *         stack event would be assigned the same token in the following format:
     *         <code>Console-CreateStack-7f59c3cf-00d2-40c7-b2ff-e75db0987002</code>.
     */
    public String clientRequestToken() {
        return clientRequestToken;
    }

    /**
     * <p>
     * Whether to enable termination protection on the specified stack. If a user attempts to delete a stack with
     * termination protection enabled, the operation fails and the stack remains unchanged. For more information, see <a
     * href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-protect-stacks.html">Protecting a
     * Stack From Being Deleted</a> in the <i>AWS CloudFormation User Guide</i>. Termination protection is disabled on
     * stacks by default.
     * </p>
     * <p>
     * For <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-nested-stacks.html">nested
     * stacks</a>, termination protection is set on the root stack and cannot be changed directly on the nested stack.
     * </p>
     * 
     * @return Whether to enable termination protection on the specified stack. If a user attempts to delete a stack
     *         with termination protection enabled, the operation fails and the stack remains unchanged. For more
     *         information, see <a
     *         href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-protect-stacks.html"
     *         >Protecting a Stack From Being Deleted</a> in the <i>AWS CloudFormation User Guide</i>. Termination
     *         protection is disabled on stacks by default. </p>
     *         <p>
     *         For <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-nested-stacks.html">
     *         nested stacks</a>, termination protection is set on the root stack and cannot be changed directly on the
     *         nested stack.
     */
    public Boolean enableTerminationProtection() {
        return enableTerminationProtection;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(stackName());
        hashCode = 31 * hashCode + Objects.hashCode(templateBody());
        hashCode = 31 * hashCode + Objects.hashCode(templateURL());
        hashCode = 31 * hashCode + Objects.hashCode(parameters());
        hashCode = 31 * hashCode + Objects.hashCode(disableRollback());
        hashCode = 31 * hashCode + Objects.hashCode(rollbackConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(timeoutInMinutes());
        hashCode = 31 * hashCode + Objects.hashCode(notificationARNs());
        hashCode = 31 * hashCode + Objects.hashCode(capabilitiesAsStrings());
        hashCode = 31 * hashCode + Objects.hashCode(resourceTypes());
        hashCode = 31 * hashCode + Objects.hashCode(roleARN());
        hashCode = 31 * hashCode + Objects.hashCode(onFailureAsString());
        hashCode = 31 * hashCode + Objects.hashCode(stackPolicyBody());
        hashCode = 31 * hashCode + Objects.hashCode(stackPolicyURL());
        hashCode = 31 * hashCode + Objects.hashCode(tags());
        hashCode = 31 * hashCode + Objects.hashCode(clientRequestToken());
        hashCode = 31 * hashCode + Objects.hashCode(enableTerminationProtection());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateStackRequest)) {
            return false;
        }
        CreateStackRequest other = (CreateStackRequest) obj;
        return Objects.equals(stackName(), other.stackName()) && Objects.equals(templateBody(), other.templateBody())
                && Objects.equals(templateURL(), other.templateURL()) && Objects.equals(parameters(), other.parameters())
                && Objects.equals(disableRollback(), other.disableRollback())
                && Objects.equals(rollbackConfiguration(), other.rollbackConfiguration())
                && Objects.equals(timeoutInMinutes(), other.timeoutInMinutes())
                && Objects.equals(notificationARNs(), other.notificationARNs())
                && Objects.equals(capabilitiesAsStrings(), other.capabilitiesAsStrings())
                && Objects.equals(resourceTypes(), other.resourceTypes()) && Objects.equals(roleARN(), other.roleARN())
                && Objects.equals(onFailureAsString(), other.onFailureAsString())
                && Objects.equals(stackPolicyBody(), other.stackPolicyBody())
                && Objects.equals(stackPolicyURL(), other.stackPolicyURL()) && Objects.equals(tags(), other.tags())
                && Objects.equals(clientRequestToken(), other.clientRequestToken())
                && Objects.equals(enableTerminationProtection(), other.enableTerminationProtection());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CreateStackRequest").add("StackName", stackName()).add("TemplateBody", templateBody())
                .add("TemplateURL", templateURL()).add("Parameters", parameters()).add("DisableRollback", disableRollback())
                .add("RollbackConfiguration", rollbackConfiguration()).add("TimeoutInMinutes", timeoutInMinutes())
                .add("NotificationARNs", notificationARNs()).add("Capabilities", capabilitiesAsStrings())
                .add("ResourceTypes", resourceTypes()).add("RoleARN", roleARN()).add("OnFailure", onFailureAsString())
                .add("StackPolicyBody", stackPolicyBody()).add("StackPolicyURL", stackPolicyURL()).add("Tags", tags())
                .add("ClientRequestToken", clientRequestToken())
                .add("EnableTerminationProtection", enableTerminationProtection()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StackName":
            return Optional.ofNullable(clazz.cast(stackName()));
        case "TemplateBody":
            return Optional.ofNullable(clazz.cast(templateBody()));
        case "TemplateURL":
            return Optional.ofNullable(clazz.cast(templateURL()));
        case "Parameters":
            return Optional.ofNullable(clazz.cast(parameters()));
        case "DisableRollback":
            return Optional.ofNullable(clazz.cast(disableRollback()));
        case "RollbackConfiguration":
            return Optional.ofNullable(clazz.cast(rollbackConfiguration()));
        case "TimeoutInMinutes":
            return Optional.ofNullable(clazz.cast(timeoutInMinutes()));
        case "NotificationARNs":
            return Optional.ofNullable(clazz.cast(notificationARNs()));
        case "Capabilities":
            return Optional.ofNullable(clazz.cast(capabilitiesAsStrings()));
        case "ResourceTypes":
            return Optional.ofNullable(clazz.cast(resourceTypes()));
        case "RoleARN":
            return Optional.ofNullable(clazz.cast(roleARN()));
        case "OnFailure":
            return Optional.ofNullable(clazz.cast(onFailureAsString()));
        case "StackPolicyBody":
            return Optional.ofNullable(clazz.cast(stackPolicyBody()));
        case "StackPolicyURL":
            return Optional.ofNullable(clazz.cast(stackPolicyURL()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "ClientRequestToken":
            return Optional.ofNullable(clazz.cast(clientRequestToken()));
        case "EnableTerminationProtection":
            return Optional.ofNullable(clazz.cast(enableTerminationProtection()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateStackRequest, T> g) {
        return obj -> g.apply((CreateStackRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudFormationRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateStackRequest> {
        /**
         * <p>
         * The name that is associated with the stack. The name must be unique in the region in which you are creating
         * the stack.
         * </p>
         * <note>
         * <p>
         * A stack name can contain only alphanumeric characters (case sensitive) and hyphens. It must start with an
         * alphabetic character and cannot be longer than 128 characters.
         * </p>
         * </note>
         * 
         * @param stackName
         *        The name that is associated with the stack. The name must be unique in the region in which you are
         *        creating the stack.</p> <note>
         *        <p>
         *        A stack name can contain only alphanumeric characters (case sensitive) and hyphens. It must start with
         *        an alphabetic character and cannot be longer than 128 characters.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stackName(String stackName);

        /**
         * <p>
         * Structure containing the template body with a minimum length of 1 byte and a maximum length of 51,200 bytes.
         * For more information, go to <a
         * href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html">Template
         * Anatomy</a> in the AWS CloudFormation User Guide.
         * </p>
         * <p>
         * Conditional: You must specify either the <code>TemplateBody</code> or the <code>TemplateURL</code> parameter,
         * but not both.
         * </p>
         * 
         * @param templateBody
         *        Structure containing the template body with a minimum length of 1 byte and a maximum length of 51,200
         *        bytes. For more information, go to <a
         *        href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html">Template
         *        Anatomy</a> in the AWS CloudFormation User Guide.</p>
         *        <p>
         *        Conditional: You must specify either the <code>TemplateBody</code> or the <code>TemplateURL</code>
         *        parameter, but not both.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder templateBody(String templateBody);

        /**
         * <p>
         * Location of file containing the template body. The URL must point to a template (max size: 460,800 bytes)
         * that is located in an Amazon S3 bucket. For more information, go to the <a
         * href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html">Template
         * Anatomy</a> in the AWS CloudFormation User Guide.
         * </p>
         * <p>
         * Conditional: You must specify either the <code>TemplateBody</code> or the <code>TemplateURL</code> parameter,
         * but not both.
         * </p>
         * 
         * @param templateURL
         *        Location of file containing the template body. The URL must point to a template (max size: 460,800
         *        bytes) that is located in an Amazon S3 bucket. For more information, go to the <a
         *        href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html">Template
         *        Anatomy</a> in the AWS CloudFormation User Guide.</p>
         *        <p>
         *        Conditional: You must specify either the <code>TemplateBody</code> or the <code>TemplateURL</code>
         *        parameter, but not both.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder templateURL(String templateURL);

        /**
         * <p>
         * A list of <code>Parameter</code> structures that specify input parameters for the stack. For more
         * information, see the <a
         * href="http://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_Parameter.html">Parameter</a> data
         * type.
         * </p>
         * 
         * @param parameters
         *        A list of <code>Parameter</code> structures that specify input parameters for the stack. For more
         *        information, see the <a
         *        href="http://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_Parameter.html"
         *        >Parameter</a> data type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameters(Collection<Parameter> parameters);

        /**
         * <p>
         * A list of <code>Parameter</code> structures that specify input parameters for the stack. For more
         * information, see the <a
         * href="http://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_Parameter.html">Parameter</a> data
         * type.
         * </p>
         * 
         * @param parameters
         *        A list of <code>Parameter</code> structures that specify input parameters for the stack. For more
         *        information, see the <a
         *        href="http://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_Parameter.html"
         *        >Parameter</a> data type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameters(Parameter... parameters);

        /**
         * <p>
         * A list of <code>Parameter</code> structures that specify input parameters for the stack. For more
         * information, see the <a
         * href="http://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_Parameter.html">Parameter</a> data
         * type.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Parameter>.Builder} avoiding the need to
         * create one manually via {@link List<Parameter>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Parameter>.Builder#build()} is called immediately and its
         * result is passed to {@link #parameters(List<Parameter>)}.
         * 
         * @param parameters
         *        a consumer that will call methods on {@link List<Parameter>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #parameters(List<Parameter>)
         */
        Builder parameters(Consumer<Parameter.Builder>... parameters);

        /**
         * <p>
         * Set to <code>true</code> to disable rollback of the stack if stack creation failed. You can specify either
         * <code>DisableRollback</code> or <code>OnFailure</code>, but not both.
         * </p>
         * <p>
         * Default: <code>false</code>
         * </p>
         * 
         * @param disableRollback
         *        Set to <code>true</code> to disable rollback of the stack if stack creation failed. You can specify
         *        either <code>DisableRollback</code> or <code>OnFailure</code>, but not both.</p>
         *        <p>
         *        Default: <code>false</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder disableRollback(Boolean disableRollback);

        /**
         * <p>
         * The rollback triggers for AWS CloudFormation to monitor during stack creation and updating operations, and
         * for the specified monitoring period afterwards.
         * </p>
         * 
         * @param rollbackConfiguration
         *        The rollback triggers for AWS CloudFormation to monitor during stack creation and updating operations,
         *        and for the specified monitoring period afterwards.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rollbackConfiguration(RollbackConfiguration rollbackConfiguration);

        /**
         * <p>
         * The rollback triggers for AWS CloudFormation to monitor during stack creation and updating operations, and
         * for the specified monitoring period afterwards.
         * </p>
         * This is a convenience that creates an instance of the {@link RollbackConfiguration.Builder} avoiding the need
         * to create one manually via {@link RollbackConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link RollbackConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #rollbackConfiguration(RollbackConfiguration)}.
         * 
         * @param rollbackConfiguration
         *        a consumer that will call methods on {@link RollbackConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #rollbackConfiguration(RollbackConfiguration)
         */
        default Builder rollbackConfiguration(Consumer<RollbackConfiguration.Builder> rollbackConfiguration) {
            return rollbackConfiguration(RollbackConfiguration.builder().applyMutation(rollbackConfiguration).build());
        }

        /**
         * <p>
         * The amount of time that can pass before the stack status becomes CREATE_FAILED; if
         * <code>DisableRollback</code> is not set or is set to <code>false</code>, the stack will be rolled back.
         * </p>
         * 
         * @param timeoutInMinutes
         *        The amount of time that can pass before the stack status becomes CREATE_FAILED; if
         *        <code>DisableRollback</code> is not set or is set to <code>false</code>, the stack will be rolled
         *        back.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timeoutInMinutes(Integer timeoutInMinutes);

        /**
         * <p>
         * The Simple Notification Service (SNS) topic ARNs to publish stack related events. You can find your SNS topic
         * ARNs using the SNS console or your Command Line Interface (CLI).
         * </p>
         * 
         * @param notificationARNs
         *        The Simple Notification Service (SNS) topic ARNs to publish stack related events. You can find your
         *        SNS topic ARNs using the SNS console or your Command Line Interface (CLI).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notificationARNs(Collection<String> notificationARNs);

        /**
         * <p>
         * The Simple Notification Service (SNS) topic ARNs to publish stack related events. You can find your SNS topic
         * ARNs using the SNS console or your Command Line Interface (CLI).
         * </p>
         * 
         * @param notificationARNs
         *        The Simple Notification Service (SNS) topic ARNs to publish stack related events. You can find your
         *        SNS topic ARNs using the SNS console or your Command Line Interface (CLI).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notificationARNs(String... notificationARNs);

        /**
         * <p>
         * In some cases, you must explicity acknowledge that your stack template contains certain capabilities in order
         * for AWS CloudFormation to create the stack.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>CAPABILITY_IAM</code> and <code>CAPABILITY_NAMED_IAM</code>
         * </p>
         * <p>
         * Some stack templates might include resources that can affect permissions in your AWS account; for example, by
         * creating new AWS Identity and Access Management (IAM) users. For those stacks, you must explicitly
         * acknowledge this by specifying one of these capabilities.
         * </p>
         * <p>
         * The following IAM resources require you to specify either the <code>CAPABILITY_IAM</code> or
         * <code>CAPABILITY_NAMED_IAM</code> capability.
         * </p>
         * <ul>
         * <li>
         * <p>
         * If you have IAM resources, you can specify either capability.
         * </p>
         * </li>
         * <li>
         * <p>
         * If you have IAM resources with custom names, you <i>must</i> specify <code>CAPABILITY_NAMED_IAM</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * If you don't specify either of these capabilities, AWS CloudFormation returns an
         * <code>InsufficientCapabilities</code> error.
         * </p>
         * </li>
         * </ul>
         * <p>
         * If your stack template contains these resources, we recommend that you review all permissions associated with
         * them and edit their permissions if necessary.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-accesskey.html">
         * AWS::IAM::AccessKey</a>
         * </p>
         * </li>
         * <li>
         * <p>
         * <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-group.html">
         * AWS::IAM::Group</a>
         * </p>
         * </li>
         * <li>
         * <p>
         * <a
         * href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-instanceprofile.html">
         * AWS::IAM::InstanceProfile</a>
         * </p>
         * </li>
         * <li>
         * <p>
         * <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-policy.html">
         * AWS::IAM::Policy</a>
         * </p>
         * </li>
         * <li>
         * <p>
         * <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-role.html">
         * AWS::IAM::Role</a>
         * </p>
         * </li>
         * <li>
         * <p>
         * <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-user.html">
         * AWS::IAM::User</a>
         * </p>
         * </li>
         * <li>
         * <p>
         * <a
         * href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-addusertogroup.html">
         * AWS::IAM::UserToGroupAddition</a>
         * </p>
         * </li>
         * </ul>
         * <p>
         * For more information, see <a
         * href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html#capabilities"
         * >Acknowledging IAM Resources in AWS CloudFormation Templates</a>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CAPABILITY_AUTO_EXPAND</code>
         * </p>
         * <p>
         * Some template contain macros. Macros perform custom processing on templates; this can include simple actions
         * like find-and-replace operations, all the way to extensive transformations of entire templates. Because of
         * this, users typically create a change set from the processed template, so that they can review the changes
         * resulting from the macros before actually creating the stack. If your stack template contains one or more
         * macros, and you choose to create a stack directly from the processed template, without first reviewing the
         * resulting changes in a change set, you must acknowledge this capability. This includes the <a href=
         * "http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/create-reusable-transform-function-snippets-and-add-to-your-template-with-aws-include-transform.html"
         * >AWS::Include</a> and <a
         * href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/transform-aws-serverless.html"
         * >AWS::Serverless</a> transforms, which are macros hosted by AWS CloudFormation.
         * </p>
         * <p>
         * Change sets do not currently support nested stacks. If you want to create a stack from a stack template that
         * contains macros <i>and</i> nested stacks, you must create the stack directly from the template using this
         * capability.
         * </p>
         * <important>
         * <p>
         * You should only create stacks directly from a stack template that contains macros if you know what processing
         * the macro performs.
         * </p>
         * <p>
         * Each macro relies on an underlying Lambda service function for processing stack templates. Be aware that the
         * Lambda function owner can update the function operation without AWS CloudFormation being notified.
         * </p>
         * </important>
         * <p>
         * For more information, see <a
         * href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-macros.html">Using AWS
         * CloudFormation Macros to Perform Custom Processing on Templates</a>.
         * </p>
         * </li>
         * </ul>
         * 
         * @param capabilities
         *        In some cases, you must explicity acknowledge that your stack template contains certain capabilities
         *        in order for AWS CloudFormation to create the stack.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>CAPABILITY_IAM</code> and <code>CAPABILITY_NAMED_IAM</code>
         *        </p>
         *        <p>
         *        Some stack templates might include resources that can affect permissions in your AWS account; for
         *        example, by creating new AWS Identity and Access Management (IAM) users. For those stacks, you must
         *        explicitly acknowledge this by specifying one of these capabilities.
         *        </p>
         *        <p>
         *        The following IAM resources require you to specify either the <code>CAPABILITY_IAM</code> or
         *        <code>CAPABILITY_NAMED_IAM</code> capability.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        If you have IAM resources, you can specify either capability.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If you have IAM resources with custom names, you <i>must</i> specify <code>CAPABILITY_NAMED_IAM</code>
         *        .
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If you don't specify either of these capabilities, AWS CloudFormation returns an
         *        <code>InsufficientCapabilities</code> error.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        If your stack template contains these resources, we recommend that you review all permissions
         *        associated with them and edit their permissions if necessary.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <a href=
         *        "http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-accesskey.html">
         *        AWS::IAM::AccessKey</a>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-group.html">
         *        AWS::IAM::Group</a>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <a href=
         *        "http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-instanceprofile.html">
         *        AWS::IAM::InstanceProfile</a>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <a
         *        href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-policy.html">
         *        AWS::IAM::Policy</a>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-role.html">
         *        AWS::IAM::Role</a>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-user.html">
         *        AWS::IAM::User</a>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <a href=
         *        "http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-addusertogroup.html"
         *        > AWS::IAM::UserToGroupAddition</a>
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        For more information, see <a href=
         *        "http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html#capabilities"
         *        >Acknowledging IAM Resources in AWS CloudFormation Templates</a>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CAPABILITY_AUTO_EXPAND</code>
         *        </p>
         *        <p>
         *        Some template contain macros. Macros perform custom processing on templates; this can include simple
         *        actions like find-and-replace operations, all the way to extensive transformations of entire
         *        templates. Because of this, users typically create a change set from the processed template, so that
         *        they can review the changes resulting from the macros before actually creating the stack. If your
         *        stack template contains one or more macros, and you choose to create a stack directly from the
         *        processed template, without first reviewing the resulting changes in a change set, you must
         *        acknowledge this capability. This includes the <a href=
         *        "http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/create-reusable-transform-function-snippets-and-add-to-your-template-with-aws-include-transform.html"
         *        >AWS::Include</a> and <a
         *        href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/transform-aws-serverless.html"
         *        >AWS::Serverless</a> transforms, which are macros hosted by AWS CloudFormation.
         *        </p>
         *        <p>
         *        Change sets do not currently support nested stacks. If you want to create a stack from a stack
         *        template that contains macros <i>and</i> nested stacks, you must create the stack directly from the
         *        template using this capability.
         *        </p>
         *        <important>
         *        <p>
         *        You should only create stacks directly from a stack template that contains macros if you know what
         *        processing the macro performs.
         *        </p>
         *        <p>
         *        Each macro relies on an underlying Lambda service function for processing stack templates. Be aware
         *        that the Lambda function owner can update the function operation without AWS CloudFormation being
         *        notified.
         *        </p>
         *        </important>
         *        <p>
         *        For more information, see <a
         *        href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-macros.html">Using AWS
         *        CloudFormation Macros to Perform Custom Processing on Templates</a>.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capabilitiesWithStrings(Collection<String> capabilities);

        /**
         * <p>
         * In some cases, you must explicity acknowledge that your stack template contains certain capabilities in order
         * for AWS CloudFormation to create the stack.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>CAPABILITY_IAM</code> and <code>CAPABILITY_NAMED_IAM</code>
         * </p>
         * <p>
         * Some stack templates might include resources that can affect permissions in your AWS account; for example, by
         * creating new AWS Identity and Access Management (IAM) users. For those stacks, you must explicitly
         * acknowledge this by specifying one of these capabilities.
         * </p>
         * <p>
         * The following IAM resources require you to specify either the <code>CAPABILITY_IAM</code> or
         * <code>CAPABILITY_NAMED_IAM</code> capability.
         * </p>
         * <ul>
         * <li>
         * <p>
         * If you have IAM resources, you can specify either capability.
         * </p>
         * </li>
         * <li>
         * <p>
         * If you have IAM resources with custom names, you <i>must</i> specify <code>CAPABILITY_NAMED_IAM</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * If you don't specify either of these capabilities, AWS CloudFormation returns an
         * <code>InsufficientCapabilities</code> error.
         * </p>
         * </li>
         * </ul>
         * <p>
         * If your stack template contains these resources, we recommend that you review all permissions associated with
         * them and edit their permissions if necessary.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-accesskey.html">
         * AWS::IAM::AccessKey</a>
         * </p>
         * </li>
         * <li>
         * <p>
         * <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-group.html">
         * AWS::IAM::Group</a>
         * </p>
         * </li>
         * <li>
         * <p>
         * <a
         * href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-instanceprofile.html">
         * AWS::IAM::InstanceProfile</a>
         * </p>
         * </li>
         * <li>
         * <p>
         * <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-policy.html">
         * AWS::IAM::Policy</a>
         * </p>
         * </li>
         * <li>
         * <p>
         * <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-role.html">
         * AWS::IAM::Role</a>
         * </p>
         * </li>
         * <li>
         * <p>
         * <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-user.html">
         * AWS::IAM::User</a>
         * </p>
         * </li>
         * <li>
         * <p>
         * <a
         * href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-addusertogroup.html">
         * AWS::IAM::UserToGroupAddition</a>
         * </p>
         * </li>
         * </ul>
         * <p>
         * For more information, see <a
         * href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html#capabilities"
         * >Acknowledging IAM Resources in AWS CloudFormation Templates</a>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CAPABILITY_AUTO_EXPAND</code>
         * </p>
         * <p>
         * Some template contain macros. Macros perform custom processing on templates; this can include simple actions
         * like find-and-replace operations, all the way to extensive transformations of entire templates. Because of
         * this, users typically create a change set from the processed template, so that they can review the changes
         * resulting from the macros before actually creating the stack. If your stack template contains one or more
         * macros, and you choose to create a stack directly from the processed template, without first reviewing the
         * resulting changes in a change set, you must acknowledge this capability. This includes the <a href=
         * "http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/create-reusable-transform-function-snippets-and-add-to-your-template-with-aws-include-transform.html"
         * >AWS::Include</a> and <a
         * href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/transform-aws-serverless.html"
         * >AWS::Serverless</a> transforms, which are macros hosted by AWS CloudFormation.
         * </p>
         * <p>
         * Change sets do not currently support nested stacks. If you want to create a stack from a stack template that
         * contains macros <i>and</i> nested stacks, you must create the stack directly from the template using this
         * capability.
         * </p>
         * <important>
         * <p>
         * You should only create stacks directly from a stack template that contains macros if you know what processing
         * the macro performs.
         * </p>
         * <p>
         * Each macro relies on an underlying Lambda service function for processing stack templates. Be aware that the
         * Lambda function owner can update the function operation without AWS CloudFormation being notified.
         * </p>
         * </important>
         * <p>
         * For more information, see <a
         * href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-macros.html">Using AWS
         * CloudFormation Macros to Perform Custom Processing on Templates</a>.
         * </p>
         * </li>
         * </ul>
         * 
         * @param capabilities
         *        In some cases, you must explicity acknowledge that your stack template contains certain capabilities
         *        in order for AWS CloudFormation to create the stack.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>CAPABILITY_IAM</code> and <code>CAPABILITY_NAMED_IAM</code>
         *        </p>
         *        <p>
         *        Some stack templates might include resources that can affect permissions in your AWS account; for
         *        example, by creating new AWS Identity and Access Management (IAM) users. For those stacks, you must
         *        explicitly acknowledge this by specifying one of these capabilities.
         *        </p>
         *        <p>
         *        The following IAM resources require you to specify either the <code>CAPABILITY_IAM</code> or
         *        <code>CAPABILITY_NAMED_IAM</code> capability.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        If you have IAM resources, you can specify either capability.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If you have IAM resources with custom names, you <i>must</i> specify <code>CAPABILITY_NAMED_IAM</code>
         *        .
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If you don't specify either of these capabilities, AWS CloudFormation returns an
         *        <code>InsufficientCapabilities</code> error.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        If your stack template contains these resources, we recommend that you review all permissions
         *        associated with them and edit their permissions if necessary.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <a href=
         *        "http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-accesskey.html">
         *        AWS::IAM::AccessKey</a>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-group.html">
         *        AWS::IAM::Group</a>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <a href=
         *        "http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-instanceprofile.html">
         *        AWS::IAM::InstanceProfile</a>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <a
         *        href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-policy.html">
         *        AWS::IAM::Policy</a>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-role.html">
         *        AWS::IAM::Role</a>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-user.html">
         *        AWS::IAM::User</a>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <a href=
         *        "http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-addusertogroup.html"
         *        > AWS::IAM::UserToGroupAddition</a>
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        For more information, see <a href=
         *        "http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html#capabilities"
         *        >Acknowledging IAM Resources in AWS CloudFormation Templates</a>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CAPABILITY_AUTO_EXPAND</code>
         *        </p>
         *        <p>
         *        Some template contain macros. Macros perform custom processing on templates; this can include simple
         *        actions like find-and-replace operations, all the way to extensive transformations of entire
         *        templates. Because of this, users typically create a change set from the processed template, so that
         *        they can review the changes resulting from the macros before actually creating the stack. If your
         *        stack template contains one or more macros, and you choose to create a stack directly from the
         *        processed template, without first reviewing the resulting changes in a change set, you must
         *        acknowledge this capability. This includes the <a href=
         *        "http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/create-reusable-transform-function-snippets-and-add-to-your-template-with-aws-include-transform.html"
         *        >AWS::Include</a> and <a
         *        href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/transform-aws-serverless.html"
         *        >AWS::Serverless</a> transforms, which are macros hosted by AWS CloudFormation.
         *        </p>
         *        <p>
         *        Change sets do not currently support nested stacks. If you want to create a stack from a stack
         *        template that contains macros <i>and</i> nested stacks, you must create the stack directly from the
         *        template using this capability.
         *        </p>
         *        <important>
         *        <p>
         *        You should only create stacks directly from a stack template that contains macros if you know what
         *        processing the macro performs.
         *        </p>
         *        <p>
         *        Each macro relies on an underlying Lambda service function for processing stack templates. Be aware
         *        that the Lambda function owner can update the function operation without AWS CloudFormation being
         *        notified.
         *        </p>
         *        </important>
         *        <p>
         *        For more information, see <a
         *        href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-macros.html">Using AWS
         *        CloudFormation Macros to Perform Custom Processing on Templates</a>.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capabilitiesWithStrings(String... capabilities);

        /**
         * <p>
         * In some cases, you must explicity acknowledge that your stack template contains certain capabilities in order
         * for AWS CloudFormation to create the stack.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>CAPABILITY_IAM</code> and <code>CAPABILITY_NAMED_IAM</code>
         * </p>
         * <p>
         * Some stack templates might include resources that can affect permissions in your AWS account; for example, by
         * creating new AWS Identity and Access Management (IAM) users. For those stacks, you must explicitly
         * acknowledge this by specifying one of these capabilities.
         * </p>
         * <p>
         * The following IAM resources require you to specify either the <code>CAPABILITY_IAM</code> or
         * <code>CAPABILITY_NAMED_IAM</code> capability.
         * </p>
         * <ul>
         * <li>
         * <p>
         * If you have IAM resources, you can specify either capability.
         * </p>
         * </li>
         * <li>
         * <p>
         * If you have IAM resources with custom names, you <i>must</i> specify <code>CAPABILITY_NAMED_IAM</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * If you don't specify either of these capabilities, AWS CloudFormation returns an
         * <code>InsufficientCapabilities</code> error.
         * </p>
         * </li>
         * </ul>
         * <p>
         * If your stack template contains these resources, we recommend that you review all permissions associated with
         * them and edit their permissions if necessary.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-accesskey.html">
         * AWS::IAM::AccessKey</a>
         * </p>
         * </li>
         * <li>
         * <p>
         * <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-group.html">
         * AWS::IAM::Group</a>
         * </p>
         * </li>
         * <li>
         * <p>
         * <a
         * href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-instanceprofile.html">
         * AWS::IAM::InstanceProfile</a>
         * </p>
         * </li>
         * <li>
         * <p>
         * <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-policy.html">
         * AWS::IAM::Policy</a>
         * </p>
         * </li>
         * <li>
         * <p>
         * <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-role.html">
         * AWS::IAM::Role</a>
         * </p>
         * </li>
         * <li>
         * <p>
         * <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-user.html">
         * AWS::IAM::User</a>
         * </p>
         * </li>
         * <li>
         * <p>
         * <a
         * href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-addusertogroup.html">
         * AWS::IAM::UserToGroupAddition</a>
         * </p>
         * </li>
         * </ul>
         * <p>
         * For more information, see <a
         * href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html#capabilities"
         * >Acknowledging IAM Resources in AWS CloudFormation Templates</a>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CAPABILITY_AUTO_EXPAND</code>
         * </p>
         * <p>
         * Some template contain macros. Macros perform custom processing on templates; this can include simple actions
         * like find-and-replace operations, all the way to extensive transformations of entire templates. Because of
         * this, users typically create a change set from the processed template, so that they can review the changes
         * resulting from the macros before actually creating the stack. If your stack template contains one or more
         * macros, and you choose to create a stack directly from the processed template, without first reviewing the
         * resulting changes in a change set, you must acknowledge this capability. This includes the <a href=
         * "http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/create-reusable-transform-function-snippets-and-add-to-your-template-with-aws-include-transform.html"
         * >AWS::Include</a> and <a
         * href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/transform-aws-serverless.html"
         * >AWS::Serverless</a> transforms, which are macros hosted by AWS CloudFormation.
         * </p>
         * <p>
         * Change sets do not currently support nested stacks. If you want to create a stack from a stack template that
         * contains macros <i>and</i> nested stacks, you must create the stack directly from the template using this
         * capability.
         * </p>
         * <important>
         * <p>
         * You should only create stacks directly from a stack template that contains macros if you know what processing
         * the macro performs.
         * </p>
         * <p>
         * Each macro relies on an underlying Lambda service function for processing stack templates. Be aware that the
         * Lambda function owner can update the function operation without AWS CloudFormation being notified.
         * </p>
         * </important>
         * <p>
         * For more information, see <a
         * href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-macros.html">Using AWS
         * CloudFormation Macros to Perform Custom Processing on Templates</a>.
         * </p>
         * </li>
         * </ul>
         * 
         * @param capabilities
         *        In some cases, you must explicity acknowledge that your stack template contains certain capabilities
         *        in order for AWS CloudFormation to create the stack.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>CAPABILITY_IAM</code> and <code>CAPABILITY_NAMED_IAM</code>
         *        </p>
         *        <p>
         *        Some stack templates might include resources that can affect permissions in your AWS account; for
         *        example, by creating new AWS Identity and Access Management (IAM) users. For those stacks, you must
         *        explicitly acknowledge this by specifying one of these capabilities.
         *        </p>
         *        <p>
         *        The following IAM resources require you to specify either the <code>CAPABILITY_IAM</code> or
         *        <code>CAPABILITY_NAMED_IAM</code> capability.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        If you have IAM resources, you can specify either capability.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If you have IAM resources with custom names, you <i>must</i> specify <code>CAPABILITY_NAMED_IAM</code>
         *        .
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If you don't specify either of these capabilities, AWS CloudFormation returns an
         *        <code>InsufficientCapabilities</code> error.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        If your stack template contains these resources, we recommend that you review all permissions
         *        associated with them and edit their permissions if necessary.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <a href=
         *        "http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-accesskey.html">
         *        AWS::IAM::AccessKey</a>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-group.html">
         *        AWS::IAM::Group</a>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <a href=
         *        "http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-instanceprofile.html">
         *        AWS::IAM::InstanceProfile</a>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <a
         *        href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-policy.html">
         *        AWS::IAM::Policy</a>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-role.html">
         *        AWS::IAM::Role</a>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-user.html">
         *        AWS::IAM::User</a>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <a href=
         *        "http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-addusertogroup.html"
         *        > AWS::IAM::UserToGroupAddition</a>
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        For more information, see <a href=
         *        "http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html#capabilities"
         *        >Acknowledging IAM Resources in AWS CloudFormation Templates</a>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CAPABILITY_AUTO_EXPAND</code>
         *        </p>
         *        <p>
         *        Some template contain macros. Macros perform custom processing on templates; this can include simple
         *        actions like find-and-replace operations, all the way to extensive transformations of entire
         *        templates. Because of this, users typically create a change set from the processed template, so that
         *        they can review the changes resulting from the macros before actually creating the stack. If your
         *        stack template contains one or more macros, and you choose to create a stack directly from the
         *        processed template, without first reviewing the resulting changes in a change set, you must
         *        acknowledge this capability. This includes the <a href=
         *        "http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/create-reusable-transform-function-snippets-and-add-to-your-template-with-aws-include-transform.html"
         *        >AWS::Include</a> and <a
         *        href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/transform-aws-serverless.html"
         *        >AWS::Serverless</a> transforms, which are macros hosted by AWS CloudFormation.
         *        </p>
         *        <p>
         *        Change sets do not currently support nested stacks. If you want to create a stack from a stack
         *        template that contains macros <i>and</i> nested stacks, you must create the stack directly from the
         *        template using this capability.
         *        </p>
         *        <important>
         *        <p>
         *        You should only create stacks directly from a stack template that contains macros if you know what
         *        processing the macro performs.
         *        </p>
         *        <p>
         *        Each macro relies on an underlying Lambda service function for processing stack templates. Be aware
         *        that the Lambda function owner can update the function operation without AWS CloudFormation being
         *        notified.
         *        </p>
         *        </important>
         *        <p>
         *        For more information, see <a
         *        href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-macros.html">Using AWS
         *        CloudFormation Macros to Perform Custom Processing on Templates</a>.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capabilities(Collection<Capability> capabilities);

        /**
         * <p>
         * In some cases, you must explicity acknowledge that your stack template contains certain capabilities in order
         * for AWS CloudFormation to create the stack.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>CAPABILITY_IAM</code> and <code>CAPABILITY_NAMED_IAM</code>
         * </p>
         * <p>
         * Some stack templates might include resources that can affect permissions in your AWS account; for example, by
         * creating new AWS Identity and Access Management (IAM) users. For those stacks, you must explicitly
         * acknowledge this by specifying one of these capabilities.
         * </p>
         * <p>
         * The following IAM resources require you to specify either the <code>CAPABILITY_IAM</code> or
         * <code>CAPABILITY_NAMED_IAM</code> capability.
         * </p>
         * <ul>
         * <li>
         * <p>
         * If you have IAM resources, you can specify either capability.
         * </p>
         * </li>
         * <li>
         * <p>
         * If you have IAM resources with custom names, you <i>must</i> specify <code>CAPABILITY_NAMED_IAM</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * If you don't specify either of these capabilities, AWS CloudFormation returns an
         * <code>InsufficientCapabilities</code> error.
         * </p>
         * </li>
         * </ul>
         * <p>
         * If your stack template contains these resources, we recommend that you review all permissions associated with
         * them and edit their permissions if necessary.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-accesskey.html">
         * AWS::IAM::AccessKey</a>
         * </p>
         * </li>
         * <li>
         * <p>
         * <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-group.html">
         * AWS::IAM::Group</a>
         * </p>
         * </li>
         * <li>
         * <p>
         * <a
         * href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-instanceprofile.html">
         * AWS::IAM::InstanceProfile</a>
         * </p>
         * </li>
         * <li>
         * <p>
         * <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-policy.html">
         * AWS::IAM::Policy</a>
         * </p>
         * </li>
         * <li>
         * <p>
         * <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-role.html">
         * AWS::IAM::Role</a>
         * </p>
         * </li>
         * <li>
         * <p>
         * <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-user.html">
         * AWS::IAM::User</a>
         * </p>
         * </li>
         * <li>
         * <p>
         * <a
         * href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-addusertogroup.html">
         * AWS::IAM::UserToGroupAddition</a>
         * </p>
         * </li>
         * </ul>
         * <p>
         * For more information, see <a
         * href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html#capabilities"
         * >Acknowledging IAM Resources in AWS CloudFormation Templates</a>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CAPABILITY_AUTO_EXPAND</code>
         * </p>
         * <p>
         * Some template contain macros. Macros perform custom processing on templates; this can include simple actions
         * like find-and-replace operations, all the way to extensive transformations of entire templates. Because of
         * this, users typically create a change set from the processed template, so that they can review the changes
         * resulting from the macros before actually creating the stack. If your stack template contains one or more
         * macros, and you choose to create a stack directly from the processed template, without first reviewing the
         * resulting changes in a change set, you must acknowledge this capability. This includes the <a href=
         * "http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/create-reusable-transform-function-snippets-and-add-to-your-template-with-aws-include-transform.html"
         * >AWS::Include</a> and <a
         * href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/transform-aws-serverless.html"
         * >AWS::Serverless</a> transforms, which are macros hosted by AWS CloudFormation.
         * </p>
         * <p>
         * Change sets do not currently support nested stacks. If you want to create a stack from a stack template that
         * contains macros <i>and</i> nested stacks, you must create the stack directly from the template using this
         * capability.
         * </p>
         * <important>
         * <p>
         * You should only create stacks directly from a stack template that contains macros if you know what processing
         * the macro performs.
         * </p>
         * <p>
         * Each macro relies on an underlying Lambda service function for processing stack templates. Be aware that the
         * Lambda function owner can update the function operation without AWS CloudFormation being notified.
         * </p>
         * </important>
         * <p>
         * For more information, see <a
         * href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-macros.html">Using AWS
         * CloudFormation Macros to Perform Custom Processing on Templates</a>.
         * </p>
         * </li>
         * </ul>
         * 
         * @param capabilities
         *        In some cases, you must explicity acknowledge that your stack template contains certain capabilities
         *        in order for AWS CloudFormation to create the stack.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>CAPABILITY_IAM</code> and <code>CAPABILITY_NAMED_IAM</code>
         *        </p>
         *        <p>
         *        Some stack templates might include resources that can affect permissions in your AWS account; for
         *        example, by creating new AWS Identity and Access Management (IAM) users. For those stacks, you must
         *        explicitly acknowledge this by specifying one of these capabilities.
         *        </p>
         *        <p>
         *        The following IAM resources require you to specify either the <code>CAPABILITY_IAM</code> or
         *        <code>CAPABILITY_NAMED_IAM</code> capability.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        If you have IAM resources, you can specify either capability.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If you have IAM resources with custom names, you <i>must</i> specify <code>CAPABILITY_NAMED_IAM</code>
         *        .
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If you don't specify either of these capabilities, AWS CloudFormation returns an
         *        <code>InsufficientCapabilities</code> error.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        If your stack template contains these resources, we recommend that you review all permissions
         *        associated with them and edit their permissions if necessary.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <a href=
         *        "http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-accesskey.html">
         *        AWS::IAM::AccessKey</a>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-group.html">
         *        AWS::IAM::Group</a>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <a href=
         *        "http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-instanceprofile.html">
         *        AWS::IAM::InstanceProfile</a>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <a
         *        href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-policy.html">
         *        AWS::IAM::Policy</a>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-role.html">
         *        AWS::IAM::Role</a>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-user.html">
         *        AWS::IAM::User</a>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <a href=
         *        "http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-addusertogroup.html"
         *        > AWS::IAM::UserToGroupAddition</a>
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        For more information, see <a href=
         *        "http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html#capabilities"
         *        >Acknowledging IAM Resources in AWS CloudFormation Templates</a>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CAPABILITY_AUTO_EXPAND</code>
         *        </p>
         *        <p>
         *        Some template contain macros. Macros perform custom processing on templates; this can include simple
         *        actions like find-and-replace operations, all the way to extensive transformations of entire
         *        templates. Because of this, users typically create a change set from the processed template, so that
         *        they can review the changes resulting from the macros before actually creating the stack. If your
         *        stack template contains one or more macros, and you choose to create a stack directly from the
         *        processed template, without first reviewing the resulting changes in a change set, you must
         *        acknowledge this capability. This includes the <a href=
         *        "http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/create-reusable-transform-function-snippets-and-add-to-your-template-with-aws-include-transform.html"
         *        >AWS::Include</a> and <a
         *        href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/transform-aws-serverless.html"
         *        >AWS::Serverless</a> transforms, which are macros hosted by AWS CloudFormation.
         *        </p>
         *        <p>
         *        Change sets do not currently support nested stacks. If you want to create a stack from a stack
         *        template that contains macros <i>and</i> nested stacks, you must create the stack directly from the
         *        template using this capability.
         *        </p>
         *        <important>
         *        <p>
         *        You should only create stacks directly from a stack template that contains macros if you know what
         *        processing the macro performs.
         *        </p>
         *        <p>
         *        Each macro relies on an underlying Lambda service function for processing stack templates. Be aware
         *        that the Lambda function owner can update the function operation without AWS CloudFormation being
         *        notified.
         *        </p>
         *        </important>
         *        <p>
         *        For more information, see <a
         *        href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-macros.html">Using AWS
         *        CloudFormation Macros to Perform Custom Processing on Templates</a>.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capabilities(Capability... capabilities);

        /**
         * <p>
         * The template resource types that you have permissions to work with for this create stack action, such as
         * <code>AWS::EC2::Instance</code>, <code>AWS::EC2::*</code>, or <code>Custom::MyCustomInstance</code>. Use the
         * following syntax to describe template resource types: <code>AWS::*</code> (for all AWS resource),
         * <code>Custom::*</code> (for all custom resources), <code>Custom::<i>logical_ID</i> </code> (for a specific
         * custom resource), <code>AWS::<i>service_name</i>::*</code> (for all resources of a particular AWS service),
         * and <code>AWS::<i>service_name</i>::<i>resource_logical_ID</i> </code> (for a specific AWS resource).
         * </p>
         * <p>
         * If the list of resource types doesn't include a resource that you're creating, the stack creation fails. By
         * default, AWS CloudFormation grants permissions to all resource types. AWS Identity and Access Management
         * (IAM) uses this parameter for AWS CloudFormation-specific condition keys in IAM policies. For more
         * information, see <a
         * href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html">Controlling
         * Access with AWS Identity and Access Management</a>.
         * </p>
         * 
         * @param resourceTypes
         *        The template resource types that you have permissions to work with for this create stack action, such
         *        as <code>AWS::EC2::Instance</code>, <code>AWS::EC2::*</code>, or <code>Custom::MyCustomInstance</code>
         *        . Use the following syntax to describe template resource types: <code>AWS::*</code> (for all AWS
         *        resource), <code>Custom::*</code> (for all custom resources), <code>Custom::<i>logical_ID</i> </code>
         *        (for a specific custom resource), <code>AWS::<i>service_name</i>::*</code> (for all resources of a
         *        particular AWS service), and <code>AWS::<i>service_name</i>::<i>resource_logical_ID</i> </code> (for a
         *        specific AWS resource).</p>
         *        <p>
         *        If the list of resource types doesn't include a resource that you're creating, the stack creation
         *        fails. By default, AWS CloudFormation grants permissions to all resource types. AWS Identity and
         *        Access Management (IAM) uses this parameter for AWS CloudFormation-specific condition keys in IAM
         *        policies. For more information, see <a
         *        href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html"
         *        >Controlling Access with AWS Identity and Access Management</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceTypes(Collection<String> resourceTypes);

        /**
         * <p>
         * The template resource types that you have permissions to work with for this create stack action, such as
         * <code>AWS::EC2::Instance</code>, <code>AWS::EC2::*</code>, or <code>Custom::MyCustomInstance</code>. Use the
         * following syntax to describe template resource types: <code>AWS::*</code> (for all AWS resource),
         * <code>Custom::*</code> (for all custom resources), <code>Custom::<i>logical_ID</i> </code> (for a specific
         * custom resource), <code>AWS::<i>service_name</i>::*</code> (for all resources of a particular AWS service),
         * and <code>AWS::<i>service_name</i>::<i>resource_logical_ID</i> </code> (for a specific AWS resource).
         * </p>
         * <p>
         * If the list of resource types doesn't include a resource that you're creating, the stack creation fails. By
         * default, AWS CloudFormation grants permissions to all resource types. AWS Identity and Access Management
         * (IAM) uses this parameter for AWS CloudFormation-specific condition keys in IAM policies. For more
         * information, see <a
         * href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html">Controlling
         * Access with AWS Identity and Access Management</a>.
         * </p>
         * 
         * @param resourceTypes
         *        The template resource types that you have permissions to work with for this create stack action, such
         *        as <code>AWS::EC2::Instance</code>, <code>AWS::EC2::*</code>, or <code>Custom::MyCustomInstance</code>
         *        . Use the following syntax to describe template resource types: <code>AWS::*</code> (for all AWS
         *        resource), <code>Custom::*</code> (for all custom resources), <code>Custom::<i>logical_ID</i> </code>
         *        (for a specific custom resource), <code>AWS::<i>service_name</i>::*</code> (for all resources of a
         *        particular AWS service), and <code>AWS::<i>service_name</i>::<i>resource_logical_ID</i> </code> (for a
         *        specific AWS resource).</p>
         *        <p>
         *        If the list of resource types doesn't include a resource that you're creating, the stack creation
         *        fails. By default, AWS CloudFormation grants permissions to all resource types. AWS Identity and
         *        Access Management (IAM) uses this parameter for AWS CloudFormation-specific condition keys in IAM
         *        policies. For more information, see <a
         *        href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html"
         *        >Controlling Access with AWS Identity and Access Management</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceTypes(String... resourceTypes);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of an AWS Identity and Access Management (IAM) role that AWS CloudFormation
         * assumes to create the stack. AWS CloudFormation uses the role's credentials to make calls on your behalf. AWS
         * CloudFormation always uses this role for all future operations on the stack. As long as users have permission
         * to operate on the stack, AWS CloudFormation uses this role even if the users don't have permission to pass
         * it. Ensure that the role grants least privilege.
         * </p>
         * <p>
         * If you don't specify a value, AWS CloudFormation uses the role that was previously associated with the stack.
         * If no role is available, AWS CloudFormation uses a temporary session that is generated from your user
         * credentials.
         * </p>
         * 
         * @param roleARN
         *        The Amazon Resource Name (ARN) of an AWS Identity and Access Management (IAM) role that AWS
         *        CloudFormation assumes to create the stack. AWS CloudFormation uses the role's credentials to make
         *        calls on your behalf. AWS CloudFormation always uses this role for all future operations on the stack.
         *        As long as users have permission to operate on the stack, AWS CloudFormation uses this role even if
         *        the users don't have permission to pass it. Ensure that the role grants least privilege.</p>
         *        <p>
         *        If you don't specify a value, AWS CloudFormation uses the role that was previously associated with the
         *        stack. If no role is available, AWS CloudFormation uses a temporary session that is generated from
         *        your user credentials.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleARN(String roleARN);

        /**
         * <p>
         * Determines what action will be taken if stack creation fails. This must be one of: DO_NOTHING, ROLLBACK, or
         * DELETE. You can specify either <code>OnFailure</code> or <code>DisableRollback</code>, but not both.
         * </p>
         * <p>
         * Default: <code>ROLLBACK</code>
         * </p>
         * 
         * @param onFailure
         *        Determines what action will be taken if stack creation fails. This must be one of: DO_NOTHING,
         *        ROLLBACK, or DELETE. You can specify either <code>OnFailure</code> or <code>DisableRollback</code>,
         *        but not both.</p>
         *        <p>
         *        Default: <code>ROLLBACK</code>
         * @see OnFailure
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OnFailure
         */
        Builder onFailure(String onFailure);

        /**
         * <p>
         * Determines what action will be taken if stack creation fails. This must be one of: DO_NOTHING, ROLLBACK, or
         * DELETE. You can specify either <code>OnFailure</code> or <code>DisableRollback</code>, but not both.
         * </p>
         * <p>
         * Default: <code>ROLLBACK</code>
         * </p>
         * 
         * @param onFailure
         *        Determines what action will be taken if stack creation fails. This must be one of: DO_NOTHING,
         *        ROLLBACK, or DELETE. You can specify either <code>OnFailure</code> or <code>DisableRollback</code>,
         *        but not both.</p>
         *        <p>
         *        Default: <code>ROLLBACK</code>
         * @see OnFailure
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OnFailure
         */
        Builder onFailure(OnFailure onFailure);

        /**
         * <p>
         * Structure containing the stack policy body. For more information, go to <a
         * href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/protect-stack-resources.html"> Prevent
         * Updates to Stack Resources</a> in the <i>AWS CloudFormation User Guide</i>. You can specify either the
         * <code>StackPolicyBody</code> or the <code>StackPolicyURL</code> parameter, but not both.
         * </p>
         * 
         * @param stackPolicyBody
         *        Structure containing the stack policy body. For more information, go to <a
         *        href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/protect-stack-resources.html">
         *        Prevent Updates to Stack Resources</a> in the <i>AWS CloudFormation User Guide</i>. You can specify
         *        either the <code>StackPolicyBody</code> or the <code>StackPolicyURL</code> parameter, but not both.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stackPolicyBody(String stackPolicyBody);

        /**
         * <p>
         * Location of a file containing the stack policy. The URL must point to a policy (maximum size: 16 KB) located
         * in an S3 bucket in the same region as the stack. You can specify either the <code>StackPolicyBody</code> or
         * the <code>StackPolicyURL</code> parameter, but not both.
         * </p>
         * 
         * @param stackPolicyURL
         *        Location of a file containing the stack policy. The URL must point to a policy (maximum size: 16 KB)
         *        located in an S3 bucket in the same region as the stack. You can specify either the
         *        <code>StackPolicyBody</code> or the <code>StackPolicyURL</code> parameter, but not both.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stackPolicyURL(String stackPolicyURL);

        /**
         * <p>
         * Key-value pairs to associate with this stack. AWS CloudFormation also propagates these tags to the resources
         * created in the stack. A maximum number of 50 tags can be specified.
         * </p>
         * 
         * @param tags
         *        Key-value pairs to associate with this stack. AWS CloudFormation also propagates these tags to the
         *        resources created in the stack. A maximum number of 50 tags can be specified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * Key-value pairs to associate with this stack. AWS CloudFormation also propagates these tags to the resources
         * created in the stack. A maximum number of 50 tags can be specified.
         * </p>
         * 
         * @param tags
         *        Key-value pairs to associate with this stack. AWS CloudFormation also propagates these tags to the
         *        resources created in the stack. A maximum number of 50 tags can be specified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * Key-value pairs to associate with this stack. AWS CloudFormation also propagates these tags to the resources
         * created in the stack. A maximum number of 50 tags can be specified.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Tag>.Builder} avoiding the need to create
         * one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        /**
         * <p>
         * A unique identifier for this <code>CreateStack</code> request. Specify this token if you plan to retry
         * requests so that AWS CloudFormation knows that you're not attempting to create a stack with the same name.
         * You might retry <code>CreateStack</code> requests to ensure that AWS CloudFormation successfully received
         * them.
         * </p>
         * <p>
         * All events triggered by a given stack operation are assigned the same client request token, which you can use
         * to track operations. For example, if you execute a <code>CreateStack</code> operation with the token
         * <code>token1</code>, then all the <code>StackEvents</code> generated by that operation will have
         * <code>ClientRequestToken</code> set as <code>token1</code>.
         * </p>
         * <p>
         * In the console, stack operations display the client request token on the Events tab. Stack operations that
         * are initiated from the console use the token format <i>Console-StackOperation-ID</i>, which helps you easily
         * identify the stack operation . For example, if you create a stack using the console, each stack event would
         * be assigned the same token in the following format:
         * <code>Console-CreateStack-7f59c3cf-00d2-40c7-b2ff-e75db0987002</code>.
         * </p>
         * 
         * @param clientRequestToken
         *        A unique identifier for this <code>CreateStack</code> request. Specify this token if you plan to retry
         *        requests so that AWS CloudFormation knows that you're not attempting to create a stack with the same
         *        name. You might retry <code>CreateStack</code> requests to ensure that AWS CloudFormation successfully
         *        received them.</p>
         *        <p>
         *        All events triggered by a given stack operation are assigned the same client request token, which you
         *        can use to track operations. For example, if you execute a <code>CreateStack</code> operation with the
         *        token <code>token1</code>, then all the <code>StackEvents</code> generated by that operation will have
         *        <code>ClientRequestToken</code> set as <code>token1</code>.
         *        </p>
         *        <p>
         *        In the console, stack operations display the client request token on the Events tab. Stack operations
         *        that are initiated from the console use the token format <i>Console-StackOperation-ID</i>, which helps
         *        you easily identify the stack operation . For example, if you create a stack using the console, each
         *        stack event would be assigned the same token in the following format:
         *        <code>Console-CreateStack-7f59c3cf-00d2-40c7-b2ff-e75db0987002</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientRequestToken(String clientRequestToken);

        /**
         * <p>
         * Whether to enable termination protection on the specified stack. If a user attempts to delete a stack with
         * termination protection enabled, the operation fails and the stack remains unchanged. For more information,
         * see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-protect-stacks.html">
         * Protecting a Stack From Being Deleted</a> in the <i>AWS CloudFormation User Guide</i>. Termination protection
         * is disabled on stacks by default.
         * </p>
         * <p>
         * For <a
         * href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-nested-stacks.html">nested
         * stacks</a>, termination protection is set on the root stack and cannot be changed directly on the nested
         * stack.
         * </p>
         * 
         * @param enableTerminationProtection
         *        Whether to enable termination protection on the specified stack. If a user attempts to delete a stack
         *        with termination protection enabled, the operation fails and the stack remains unchanged. For more
         *        information, see <a
         *        href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-protect-stacks.html"
         *        >Protecting a Stack From Being Deleted</a> in the <i>AWS CloudFormation User Guide</i>. Termination
         *        protection is disabled on stacks by default. </p>
         *        <p>
         *        For <a
         *        href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-nested-stacks.html"
         *        >nested stacks</a>, termination protection is set on the root stack and cannot be changed directly on
         *        the nested stack.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enableTerminationProtection(Boolean enableTerminationProtection);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CloudFormationRequest.BuilderImpl implements Builder {
        private String stackName;

        private String templateBody;

        private String templateURL;

        private List<Parameter> parameters = DefaultSdkAutoConstructList.getInstance();

        private Boolean disableRollback;

        private RollbackConfiguration rollbackConfiguration;

        private Integer timeoutInMinutes;

        private List<String> notificationARNs = DefaultSdkAutoConstructList.getInstance();

        private List<String> capabilities = DefaultSdkAutoConstructList.getInstance();

        private List<String> resourceTypes = DefaultSdkAutoConstructList.getInstance();

        private String roleARN;

        private String onFailure;

        private String stackPolicyBody;

        private String stackPolicyURL;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private String clientRequestToken;

        private Boolean enableTerminationProtection;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateStackRequest model) {
            super(model);
            stackName(model.stackName);
            templateBody(model.templateBody);
            templateURL(model.templateURL);
            parameters(model.parameters);
            disableRollback(model.disableRollback);
            rollbackConfiguration(model.rollbackConfiguration);
            timeoutInMinutes(model.timeoutInMinutes);
            notificationARNs(model.notificationARNs);
            capabilitiesWithStrings(model.capabilities);
            resourceTypes(model.resourceTypes);
            roleARN(model.roleARN);
            onFailure(model.onFailure);
            stackPolicyBody(model.stackPolicyBody);
            stackPolicyURL(model.stackPolicyURL);
            tags(model.tags);
            clientRequestToken(model.clientRequestToken);
            enableTerminationProtection(model.enableTerminationProtection);
        }

        public final String getStackName() {
            return stackName;
        }

        @Override
        public final Builder stackName(String stackName) {
            this.stackName = stackName;
            return this;
        }

        public final void setStackName(String stackName) {
            this.stackName = stackName;
        }

        public final String getTemplateBody() {
            return templateBody;
        }

        @Override
        public final Builder templateBody(String templateBody) {
            this.templateBody = templateBody;
            return this;
        }

        public final void setTemplateBody(String templateBody) {
            this.templateBody = templateBody;
        }

        public final String getTemplateURL() {
            return templateURL;
        }

        @Override
        public final Builder templateURL(String templateURL) {
            this.templateURL = templateURL;
            return this;
        }

        public final void setTemplateURL(String templateURL) {
            this.templateURL = templateURL;
        }

        public final Collection<Parameter.Builder> getParameters() {
            return parameters != null ? parameters.stream().map(Parameter::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder parameters(Collection<Parameter> parameters) {
            this.parameters = ParametersCopier.copy(parameters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameters(Parameter... parameters) {
            parameters(Arrays.asList(parameters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameters(Consumer<Parameter.Builder>... parameters) {
            parameters(Stream.of(parameters).map(c -> Parameter.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setParameters(Collection<Parameter.BuilderImpl> parameters) {
            this.parameters = ParametersCopier.copyFromBuilder(parameters);
        }

        public final Boolean getDisableRollback() {
            return disableRollback;
        }

        @Override
        public final Builder disableRollback(Boolean disableRollback) {
            this.disableRollback = disableRollback;
            return this;
        }

        public final void setDisableRollback(Boolean disableRollback) {
            this.disableRollback = disableRollback;
        }

        public final RollbackConfiguration.Builder getRollbackConfiguration() {
            return rollbackConfiguration != null ? rollbackConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder rollbackConfiguration(RollbackConfiguration rollbackConfiguration) {
            this.rollbackConfiguration = rollbackConfiguration;
            return this;
        }

        public final void setRollbackConfiguration(RollbackConfiguration.BuilderImpl rollbackConfiguration) {
            this.rollbackConfiguration = rollbackConfiguration != null ? rollbackConfiguration.build() : null;
        }

        public final Integer getTimeoutInMinutes() {
            return timeoutInMinutes;
        }

        @Override
        public final Builder timeoutInMinutes(Integer timeoutInMinutes) {
            this.timeoutInMinutes = timeoutInMinutes;
            return this;
        }

        public final void setTimeoutInMinutes(Integer timeoutInMinutes) {
            this.timeoutInMinutes = timeoutInMinutes;
        }

        public final Collection<String> getNotificationARNs() {
            return notificationARNs;
        }

        @Override
        public final Builder notificationARNs(Collection<String> notificationARNs) {
            this.notificationARNs = NotificationARNsCopier.copy(notificationARNs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder notificationARNs(String... notificationARNs) {
            notificationARNs(Arrays.asList(notificationARNs));
            return this;
        }

        public final void setNotificationARNs(Collection<String> notificationARNs) {
            this.notificationARNs = NotificationARNsCopier.copy(notificationARNs);
        }

        public final Collection<String> getCapabilitiesAsStrings() {
            return capabilities;
        }

        @Override
        public final Builder capabilitiesWithStrings(Collection<String> capabilities) {
            this.capabilities = CapabilitiesCopier.copy(capabilities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder capabilitiesWithStrings(String... capabilities) {
            capabilitiesWithStrings(Arrays.asList(capabilities));
            return this;
        }

        @Override
        public final Builder capabilities(Collection<Capability> capabilities) {
            this.capabilities = CapabilitiesCopier.copyEnumToString(capabilities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder capabilities(Capability... capabilities) {
            capabilities(Arrays.asList(capabilities));
            return this;
        }

        public final void setCapabilitiesWithStrings(Collection<String> capabilities) {
            this.capabilities = CapabilitiesCopier.copy(capabilities);
        }

        public final Collection<String> getResourceTypes() {
            return resourceTypes;
        }

        @Override
        public final Builder resourceTypes(Collection<String> resourceTypes) {
            this.resourceTypes = ResourceTypesCopier.copy(resourceTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceTypes(String... resourceTypes) {
            resourceTypes(Arrays.asList(resourceTypes));
            return this;
        }

        public final void setResourceTypes(Collection<String> resourceTypes) {
            this.resourceTypes = ResourceTypesCopier.copy(resourceTypes);
        }

        public final String getRoleARN() {
            return roleARN;
        }

        @Override
        public final Builder roleARN(String roleARN) {
            this.roleARN = roleARN;
            return this;
        }

        public final void setRoleARN(String roleARN) {
            this.roleARN = roleARN;
        }

        public final String getOnFailureAsString() {
            return onFailure;
        }

        @Override
        public final Builder onFailure(String onFailure) {
            this.onFailure = onFailure;
            return this;
        }

        @Override
        public final Builder onFailure(OnFailure onFailure) {
            this.onFailure(onFailure.toString());
            return this;
        }

        public final void setOnFailure(String onFailure) {
            this.onFailure = onFailure;
        }

        public final String getStackPolicyBody() {
            return stackPolicyBody;
        }

        @Override
        public final Builder stackPolicyBody(String stackPolicyBody) {
            this.stackPolicyBody = stackPolicyBody;
            return this;
        }

        public final void setStackPolicyBody(String stackPolicyBody) {
            this.stackPolicyBody = stackPolicyBody;
        }

        public final String getStackPolicyURL() {
            return stackPolicyURL;
        }

        @Override
        public final Builder stackPolicyURL(String stackPolicyURL) {
            this.stackPolicyURL = stackPolicyURL;
            return this;
        }

        public final void setStackPolicyURL(String stackPolicyURL) {
            this.stackPolicyURL = stackPolicyURL;
        }

        public final Collection<Tag.Builder> getTags() {
            return tags != null ? tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagsCopier.copyFromBuilder(tags);
        }

        public final String getClientRequestToken() {
            return clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        public final Boolean getEnableTerminationProtection() {
            return enableTerminationProtection;
        }

        @Override
        public final Builder enableTerminationProtection(Boolean enableTerminationProtection) {
            this.enableTerminationProtection = enableTerminationProtection;
            return this;
        }

        public final void setEnableTerminationProtection(Boolean enableTerminationProtection) {
            this.enableTerminationProtection = enableTerminationProtection;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateStackRequest build() {
            return new CreateStackRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
