/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudformation.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateStackInstancesRequest extends CloudFormationRequest implements
        ToCopyableBuilder<UpdateStackInstancesRequest.Builder, UpdateStackInstancesRequest> {
    private static final SdkField<String> STACK_SET_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateStackInstancesRequest::stackSetName)).setter(setter(Builder::stackSetName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StackSetName").build()).build();

    private static final SdkField<List<String>> ACCOUNTS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(UpdateStackInstancesRequest::accounts))
            .setter(setter(Builder::accounts))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Accounts").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> REGIONS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(UpdateStackInstancesRequest::regions))
            .setter(setter(Builder::regions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Regions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<Parameter>> PARAMETER_OVERRIDES_FIELD = SdkField
            .<List<Parameter>> builder(MarshallingType.LIST)
            .getter(getter(UpdateStackInstancesRequest::parameterOverrides))
            .setter(setter(Builder::parameterOverrides))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParameterOverrides").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Parameter> builder(MarshallingType.SDK_POJO)
                                            .constructor(Parameter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<StackSetOperationPreferences> OPERATION_PREFERENCES_FIELD = SdkField
            .<StackSetOperationPreferences> builder(MarshallingType.SDK_POJO)
            .getter(getter(UpdateStackInstancesRequest::operationPreferences)).setter(setter(Builder::operationPreferences))
            .constructor(StackSetOperationPreferences::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OperationPreferences").build())
            .build();

    private static final SdkField<String> OPERATION_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateStackInstancesRequest::operationId))
            .setter(setter(Builder::operationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OperationId").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STACK_SET_NAME_FIELD,
            ACCOUNTS_FIELD, REGIONS_FIELD, PARAMETER_OVERRIDES_FIELD, OPERATION_PREFERENCES_FIELD, OPERATION_ID_FIELD));

    private final String stackSetName;

    private final List<String> accounts;

    private final List<String> regions;

    private final List<Parameter> parameterOverrides;

    private final StackSetOperationPreferences operationPreferences;

    private final String operationId;

    private UpdateStackInstancesRequest(BuilderImpl builder) {
        super(builder);
        this.stackSetName = builder.stackSetName;
        this.accounts = builder.accounts;
        this.regions = builder.regions;
        this.parameterOverrides = builder.parameterOverrides;
        this.operationPreferences = builder.operationPreferences;
        this.operationId = builder.operationId;
    }

    /**
     * <p>
     * The name or unique ID of the stack set associated with the stack instances.
     * </p>
     * 
     * @return The name or unique ID of the stack set associated with the stack instances.
     */
    public String stackSetName() {
        return stackSetName;
    }

    /**
     * <p>
     * The names of one or more AWS accounts for which you want to update parameter values for stack instances. The
     * overridden parameter values will be applied to all stack instances in the specified accounts and regions.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The names of one or more AWS accounts for which you want to update parameter values for stack instances.
     *         The overridden parameter values will be applied to all stack instances in the specified accounts and
     *         regions.
     */
    public List<String> accounts() {
        return accounts;
    }

    /**
     * <p>
     * The names of one or more regions in which you want to update parameter values for stack instances. The overridden
     * parameter values will be applied to all stack instances in the specified accounts and regions.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The names of one or more regions in which you want to update parameter values for stack instances. The
     *         overridden parameter values will be applied to all stack instances in the specified accounts and regions.
     */
    public List<String> regions() {
        return regions;
    }

    /**
     * <p>
     * A list of input parameters whose values you want to update for the specified stack instances.
     * </p>
     * <p>
     * Any overridden parameter values will be applied to all stack instances in the specified accounts and regions.
     * When specifying parameters and their values, be aware of how AWS CloudFormation sets parameter values during
     * stack instance update operations:
     * </p>
     * <ul>
     * <li>
     * <p>
     * To override the current value for a parameter, include the parameter and specify its value.
     * </p>
     * </li>
     * <li>
     * <p>
     * To leave a parameter set to its present value, you can do one of the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Do not include the parameter in the list.
     * </p>
     * </li>
     * <li>
     * <p>
     * Include the parameter and specify <code>UsePreviousValue</code> as <code>true</code>. (You cannot specify both a
     * value and set <code>UsePreviousValue</code> to <code>true</code>.)
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * To set all overridden parameter back to the values specified in the stack set, specify a parameter list but do
     * not include any parameters.
     * </p>
     * </li>
     * <li>
     * <p>
     * To leave all parameters set to their present values, do not specify this property at all.
     * </p>
     * </li>
     * </ul>
     * <p>
     * During stack set updates, any parameter values overridden for a stack instance are not updated, but retain their
     * overridden value.
     * </p>
     * <p>
     * You can only override the parameter <i>values</i> that are specified in the stack set; to add or delete a
     * parameter itself, use <code>UpdateStackSet</code> to update the stack set template. If you add a parameter to a
     * template, before you can override the parameter value specified in the stack set you must first use <a
     * href="http://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_UpdateStackSet.html"
     * >UpdateStackSet</a> to update all stack instances with the updated template and parameter value specified in the
     * stack set. Once a stack instance has been updated with the new parameter, you can then override the parameter
     * value using <code>UpdateStackInstances</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A list of input parameters whose values you want to update for the specified stack instances. </p>
     *         <p>
     *         Any overridden parameter values will be applied to all stack instances in the specified accounts and
     *         regions. When specifying parameters and their values, be aware of how AWS CloudFormation sets parameter
     *         values during stack instance update operations:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         To override the current value for a parameter, include the parameter and specify its value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         To leave a parameter set to its present value, you can do one of the following:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Do not include the parameter in the list.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Include the parameter and specify <code>UsePreviousValue</code> as <code>true</code>. (You cannot specify
     *         both a value and set <code>UsePreviousValue</code> to <code>true</code>.)
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         To set all overridden parameter back to the values specified in the stack set, specify a parameter list
     *         but do not include any parameters.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         To leave all parameters set to their present values, do not specify this property at all.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         During stack set updates, any parameter values overridden for a stack instance are not updated, but
     *         retain their overridden value.
     *         </p>
     *         <p>
     *         You can only override the parameter <i>values</i> that are specified in the stack set; to add or delete a
     *         parameter itself, use <code>UpdateStackSet</code> to update the stack set template. If you add a
     *         parameter to a template, before you can override the parameter value specified in the stack set you must
     *         first use <a
     *         href="http://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_UpdateStackSet.html"
     *         >UpdateStackSet</a> to update all stack instances with the updated template and parameter value specified
     *         in the stack set. Once a stack instance has been updated with the new parameter, you can then override
     *         the parameter value using <code>UpdateStackInstances</code>.
     */
    public List<Parameter> parameterOverrides() {
        return parameterOverrides;
    }

    /**
     * <p>
     * Preferences for how AWS CloudFormation performs this stack set operation.
     * </p>
     * 
     * @return Preferences for how AWS CloudFormation performs this stack set operation.
     */
    public StackSetOperationPreferences operationPreferences() {
        return operationPreferences;
    }

    /**
     * <p>
     * The unique identifier for this stack set operation.
     * </p>
     * <p>
     * The operation ID also functions as an idempotency token, to ensure that AWS CloudFormation performs the stack set
     * operation only once, even if you retry the request multiple times. You might retry stack set operation requests
     * to ensure that AWS CloudFormation successfully received them.
     * </p>
     * <p>
     * If you don't specify an operation ID, the SDK generates one automatically.
     * </p>
     * 
     * @return The unique identifier for this stack set operation. </p>
     *         <p>
     *         The operation ID also functions as an idempotency token, to ensure that AWS CloudFormation performs the
     *         stack set operation only once, even if you retry the request multiple times. You might retry stack set
     *         operation requests to ensure that AWS CloudFormation successfully received them.
     *         </p>
     *         <p>
     *         If you don't specify an operation ID, the SDK generates one automatically.
     */
    public String operationId() {
        return operationId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(stackSetName());
        hashCode = 31 * hashCode + Objects.hashCode(accounts());
        hashCode = 31 * hashCode + Objects.hashCode(regions());
        hashCode = 31 * hashCode + Objects.hashCode(parameterOverrides());
        hashCode = 31 * hashCode + Objects.hashCode(operationPreferences());
        hashCode = 31 * hashCode + Objects.hashCode(operationId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateStackInstancesRequest)) {
            return false;
        }
        UpdateStackInstancesRequest other = (UpdateStackInstancesRequest) obj;
        return Objects.equals(stackSetName(), other.stackSetName()) && Objects.equals(accounts(), other.accounts())
                && Objects.equals(regions(), other.regions()) && Objects.equals(parameterOverrides(), other.parameterOverrides())
                && Objects.equals(operationPreferences(), other.operationPreferences())
                && Objects.equals(operationId(), other.operationId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("UpdateStackInstancesRequest").add("StackSetName", stackSetName()).add("Accounts", accounts())
                .add("Regions", regions()).add("ParameterOverrides", parameterOverrides())
                .add("OperationPreferences", operationPreferences()).add("OperationId", operationId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StackSetName":
            return Optional.ofNullable(clazz.cast(stackSetName()));
        case "Accounts":
            return Optional.ofNullable(clazz.cast(accounts()));
        case "Regions":
            return Optional.ofNullable(clazz.cast(regions()));
        case "ParameterOverrides":
            return Optional.ofNullable(clazz.cast(parameterOverrides()));
        case "OperationPreferences":
            return Optional.ofNullable(clazz.cast(operationPreferences()));
        case "OperationId":
            return Optional.ofNullable(clazz.cast(operationId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateStackInstancesRequest, T> g) {
        return obj -> g.apply((UpdateStackInstancesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudFormationRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateStackInstancesRequest> {
        /**
         * <p>
         * The name or unique ID of the stack set associated with the stack instances.
         * </p>
         * 
         * @param stackSetName
         *        The name or unique ID of the stack set associated with the stack instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stackSetName(String stackSetName);

        /**
         * <p>
         * The names of one or more AWS accounts for which you want to update parameter values for stack instances. The
         * overridden parameter values will be applied to all stack instances in the specified accounts and regions.
         * </p>
         * 
         * @param accounts
         *        The names of one or more AWS accounts for which you want to update parameter values for stack
         *        instances. The overridden parameter values will be applied to all stack instances in the specified
         *        accounts and regions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accounts(Collection<String> accounts);

        /**
         * <p>
         * The names of one or more AWS accounts for which you want to update parameter values for stack instances. The
         * overridden parameter values will be applied to all stack instances in the specified accounts and regions.
         * </p>
         * 
         * @param accounts
         *        The names of one or more AWS accounts for which you want to update parameter values for stack
         *        instances. The overridden parameter values will be applied to all stack instances in the specified
         *        accounts and regions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accounts(String... accounts);

        /**
         * <p>
         * The names of one or more regions in which you want to update parameter values for stack instances. The
         * overridden parameter values will be applied to all stack instances in the specified accounts and regions.
         * </p>
         * 
         * @param regions
         *        The names of one or more regions in which you want to update parameter values for stack instances. The
         *        overridden parameter values will be applied to all stack instances in the specified accounts and
         *        regions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder regions(Collection<String> regions);

        /**
         * <p>
         * The names of one or more regions in which you want to update parameter values for stack instances. The
         * overridden parameter values will be applied to all stack instances in the specified accounts and regions.
         * </p>
         * 
         * @param regions
         *        The names of one or more regions in which you want to update parameter values for stack instances. The
         *        overridden parameter values will be applied to all stack instances in the specified accounts and
         *        regions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder regions(String... regions);

        /**
         * <p>
         * A list of input parameters whose values you want to update for the specified stack instances.
         * </p>
         * <p>
         * Any overridden parameter values will be applied to all stack instances in the specified accounts and regions.
         * When specifying parameters and their values, be aware of how AWS CloudFormation sets parameter values during
         * stack instance update operations:
         * </p>
         * <ul>
         * <li>
         * <p>
         * To override the current value for a parameter, include the parameter and specify its value.
         * </p>
         * </li>
         * <li>
         * <p>
         * To leave a parameter set to its present value, you can do one of the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Do not include the parameter in the list.
         * </p>
         * </li>
         * <li>
         * <p>
         * Include the parameter and specify <code>UsePreviousValue</code> as <code>true</code>. (You cannot specify
         * both a value and set <code>UsePreviousValue</code> to <code>true</code>.)
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * To set all overridden parameter back to the values specified in the stack set, specify a parameter list but
         * do not include any parameters.
         * </p>
         * </li>
         * <li>
         * <p>
         * To leave all parameters set to their present values, do not specify this property at all.
         * </p>
         * </li>
         * </ul>
         * <p>
         * During stack set updates, any parameter values overridden for a stack instance are not updated, but retain
         * their overridden value.
         * </p>
         * <p>
         * You can only override the parameter <i>values</i> that are specified in the stack set; to add or delete a
         * parameter itself, use <code>UpdateStackSet</code> to update the stack set template. If you add a parameter to
         * a template, before you can override the parameter value specified in the stack set you must first use <a
         * href=
         * "http://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_UpdateStackSet.html">UpdateStackSet</a>
         * to update all stack instances with the updated template and parameter value specified in the stack set. Once
         * a stack instance has been updated with the new parameter, you can then override the parameter value using
         * <code>UpdateStackInstances</code>.
         * </p>
         * 
         * @param parameterOverrides
         *        A list of input parameters whose values you want to update for the specified stack instances. </p>
         *        <p>
         *        Any overridden parameter values will be applied to all stack instances in the specified accounts and
         *        regions. When specifying parameters and their values, be aware of how AWS CloudFormation sets
         *        parameter values during stack instance update operations:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        To override the current value for a parameter, include the parameter and specify its value.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        To leave a parameter set to its present value, you can do one of the following:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Do not include the parameter in the list.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Include the parameter and specify <code>UsePreviousValue</code> as <code>true</code>. (You cannot
         *        specify both a value and set <code>UsePreviousValue</code> to <code>true</code>.)
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        To set all overridden parameter back to the values specified in the stack set, specify a parameter
         *        list but do not include any parameters.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        To leave all parameters set to their present values, do not specify this property at all.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        During stack set updates, any parameter values overridden for a stack instance are not updated, but
         *        retain their overridden value.
         *        </p>
         *        <p>
         *        You can only override the parameter <i>values</i> that are specified in the stack set; to add or
         *        delete a parameter itself, use <code>UpdateStackSet</code> to update the stack set template. If you
         *        add a parameter to a template, before you can override the parameter value specified in the stack set
         *        you must first use <a
         *        href="http://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_UpdateStackSet.html"
         *        >UpdateStackSet</a> to update all stack instances with the updated template and parameter value
         *        specified in the stack set. Once a stack instance has been updated with the new parameter, you can
         *        then override the parameter value using <code>UpdateStackInstances</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameterOverrides(Collection<Parameter> parameterOverrides);

        /**
         * <p>
         * A list of input parameters whose values you want to update for the specified stack instances.
         * </p>
         * <p>
         * Any overridden parameter values will be applied to all stack instances in the specified accounts and regions.
         * When specifying parameters and their values, be aware of how AWS CloudFormation sets parameter values during
         * stack instance update operations:
         * </p>
         * <ul>
         * <li>
         * <p>
         * To override the current value for a parameter, include the parameter and specify its value.
         * </p>
         * </li>
         * <li>
         * <p>
         * To leave a parameter set to its present value, you can do one of the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Do not include the parameter in the list.
         * </p>
         * </li>
         * <li>
         * <p>
         * Include the parameter and specify <code>UsePreviousValue</code> as <code>true</code>. (You cannot specify
         * both a value and set <code>UsePreviousValue</code> to <code>true</code>.)
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * To set all overridden parameter back to the values specified in the stack set, specify a parameter list but
         * do not include any parameters.
         * </p>
         * </li>
         * <li>
         * <p>
         * To leave all parameters set to their present values, do not specify this property at all.
         * </p>
         * </li>
         * </ul>
         * <p>
         * During stack set updates, any parameter values overridden for a stack instance are not updated, but retain
         * their overridden value.
         * </p>
         * <p>
         * You can only override the parameter <i>values</i> that are specified in the stack set; to add or delete a
         * parameter itself, use <code>UpdateStackSet</code> to update the stack set template. If you add a parameter to
         * a template, before you can override the parameter value specified in the stack set you must first use <a
         * href=
         * "http://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_UpdateStackSet.html">UpdateStackSet</a>
         * to update all stack instances with the updated template and parameter value specified in the stack set. Once
         * a stack instance has been updated with the new parameter, you can then override the parameter value using
         * <code>UpdateStackInstances</code>.
         * </p>
         * 
         * @param parameterOverrides
         *        A list of input parameters whose values you want to update for the specified stack instances. </p>
         *        <p>
         *        Any overridden parameter values will be applied to all stack instances in the specified accounts and
         *        regions. When specifying parameters and their values, be aware of how AWS CloudFormation sets
         *        parameter values during stack instance update operations:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        To override the current value for a parameter, include the parameter and specify its value.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        To leave a parameter set to its present value, you can do one of the following:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Do not include the parameter in the list.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Include the parameter and specify <code>UsePreviousValue</code> as <code>true</code>. (You cannot
         *        specify both a value and set <code>UsePreviousValue</code> to <code>true</code>.)
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        To set all overridden parameter back to the values specified in the stack set, specify a parameter
         *        list but do not include any parameters.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        To leave all parameters set to their present values, do not specify this property at all.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        During stack set updates, any parameter values overridden for a stack instance are not updated, but
         *        retain their overridden value.
         *        </p>
         *        <p>
         *        You can only override the parameter <i>values</i> that are specified in the stack set; to add or
         *        delete a parameter itself, use <code>UpdateStackSet</code> to update the stack set template. If you
         *        add a parameter to a template, before you can override the parameter value specified in the stack set
         *        you must first use <a
         *        href="http://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_UpdateStackSet.html"
         *        >UpdateStackSet</a> to update all stack instances with the updated template and parameter value
         *        specified in the stack set. Once a stack instance has been updated with the new parameter, you can
         *        then override the parameter value using <code>UpdateStackInstances</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameterOverrides(Parameter... parameterOverrides);

        /**
         * <p>
         * A list of input parameters whose values you want to update for the specified stack instances.
         * </p>
         * <p>
         * Any overridden parameter values will be applied to all stack instances in the specified accounts and regions.
         * When specifying parameters and their values, be aware of how AWS CloudFormation sets parameter values during
         * stack instance update operations:
         * </p>
         * <ul>
         * <li>
         * <p>
         * To override the current value for a parameter, include the parameter and specify its value.
         * </p>
         * </li>
         * <li>
         * <p>
         * To leave a parameter set to its present value, you can do one of the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Do not include the parameter in the list.
         * </p>
         * </li>
         * <li>
         * <p>
         * Include the parameter and specify <code>UsePreviousValue</code> as <code>true</code>. (You cannot specify
         * both a value and set <code>UsePreviousValue</code> to <code>true</code>.)
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * To set all overridden parameter back to the values specified in the stack set, specify a parameter list but
         * do not include any parameters.
         * </p>
         * </li>
         * <li>
         * <p>
         * To leave all parameters set to their present values, do not specify this property at all.
         * </p>
         * </li>
         * </ul>
         * <p>
         * During stack set updates, any parameter values overridden for a stack instance are not updated, but retain
         * their overridden value.
         * </p>
         * <p>
         * You can only override the parameter <i>values</i> that are specified in the stack set; to add or delete a
         * parameter itself, use <code>UpdateStackSet</code> to update the stack set template. If you add a parameter to
         * a template, before you can override the parameter value specified in the stack set you must first use <a
         * href=
         * "http://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_UpdateStackSet.html">UpdateStackSet</a>
         * to update all stack instances with the updated template and parameter value specified in the stack set. Once
         * a stack instance has been updated with the new parameter, you can then override the parameter value using
         * <code>UpdateStackInstances</code>.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Parameter>.Builder} avoiding the need to
         * create one manually via {@link List<Parameter>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Parameter>.Builder#build()} is called immediately and its
         * result is passed to {@link #parameterOverrides(List<Parameter>)}.
         * 
         * @param parameterOverrides
         *        a consumer that will call methods on {@link List<Parameter>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #parameterOverrides(List<Parameter>)
         */
        Builder parameterOverrides(Consumer<Parameter.Builder>... parameterOverrides);

        /**
         * <p>
         * Preferences for how AWS CloudFormation performs this stack set operation.
         * </p>
         * 
         * @param operationPreferences
         *        Preferences for how AWS CloudFormation performs this stack set operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder operationPreferences(StackSetOperationPreferences operationPreferences);

        /**
         * <p>
         * Preferences for how AWS CloudFormation performs this stack set operation.
         * </p>
         * This is a convenience that creates an instance of the {@link StackSetOperationPreferences.Builder} avoiding
         * the need to create one manually via {@link StackSetOperationPreferences#builder()}.
         *
         * When the {@link Consumer} completes, {@link StackSetOperationPreferences.Builder#build()} is called
         * immediately and its result is passed to {@link #operationPreferences(StackSetOperationPreferences)}.
         * 
         * @param operationPreferences
         *        a consumer that will call methods on {@link StackSetOperationPreferences.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #operationPreferences(StackSetOperationPreferences)
         */
        default Builder operationPreferences(Consumer<StackSetOperationPreferences.Builder> operationPreferences) {
            return operationPreferences(StackSetOperationPreferences.builder().applyMutation(operationPreferences).build());
        }

        /**
         * <p>
         * The unique identifier for this stack set operation.
         * </p>
         * <p>
         * The operation ID also functions as an idempotency token, to ensure that AWS CloudFormation performs the stack
         * set operation only once, even if you retry the request multiple times. You might retry stack set operation
         * requests to ensure that AWS CloudFormation successfully received them.
         * </p>
         * <p>
         * If you don't specify an operation ID, the SDK generates one automatically.
         * </p>
         * 
         * @param operationId
         *        The unique identifier for this stack set operation. </p>
         *        <p>
         *        The operation ID also functions as an idempotency token, to ensure that AWS CloudFormation performs
         *        the stack set operation only once, even if you retry the request multiple times. You might retry stack
         *        set operation requests to ensure that AWS CloudFormation successfully received them.
         *        </p>
         *        <p>
         *        If you don't specify an operation ID, the SDK generates one automatically.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder operationId(String operationId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CloudFormationRequest.BuilderImpl implements Builder {
        private String stackSetName;

        private List<String> accounts = DefaultSdkAutoConstructList.getInstance();

        private List<String> regions = DefaultSdkAutoConstructList.getInstance();

        private List<Parameter> parameterOverrides = DefaultSdkAutoConstructList.getInstance();

        private StackSetOperationPreferences operationPreferences;

        private String operationId;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateStackInstancesRequest model) {
            super(model);
            stackSetName(model.stackSetName);
            accounts(model.accounts);
            regions(model.regions);
            parameterOverrides(model.parameterOverrides);
            operationPreferences(model.operationPreferences);
            operationId(model.operationId);
        }

        public final String getStackSetName() {
            return stackSetName;
        }

        @Override
        public final Builder stackSetName(String stackSetName) {
            this.stackSetName = stackSetName;
            return this;
        }

        public final void setStackSetName(String stackSetName) {
            this.stackSetName = stackSetName;
        }

        public final Collection<String> getAccounts() {
            return accounts;
        }

        @Override
        public final Builder accounts(Collection<String> accounts) {
            this.accounts = AccountListCopier.copy(accounts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accounts(String... accounts) {
            accounts(Arrays.asList(accounts));
            return this;
        }

        public final void setAccounts(Collection<String> accounts) {
            this.accounts = AccountListCopier.copy(accounts);
        }

        public final Collection<String> getRegions() {
            return regions;
        }

        @Override
        public final Builder regions(Collection<String> regions) {
            this.regions = RegionListCopier.copy(regions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder regions(String... regions) {
            regions(Arrays.asList(regions));
            return this;
        }

        public final void setRegions(Collection<String> regions) {
            this.regions = RegionListCopier.copy(regions);
        }

        public final Collection<Parameter.Builder> getParameterOverrides() {
            return parameterOverrides != null ? parameterOverrides.stream().map(Parameter::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder parameterOverrides(Collection<Parameter> parameterOverrides) {
            this.parameterOverrides = ParametersCopier.copy(parameterOverrides);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameterOverrides(Parameter... parameterOverrides) {
            parameterOverrides(Arrays.asList(parameterOverrides));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameterOverrides(Consumer<Parameter.Builder>... parameterOverrides) {
            parameterOverrides(Stream.of(parameterOverrides).map(c -> Parameter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setParameterOverrides(Collection<Parameter.BuilderImpl> parameterOverrides) {
            this.parameterOverrides = ParametersCopier.copyFromBuilder(parameterOverrides);
        }

        public final StackSetOperationPreferences.Builder getOperationPreferences() {
            return operationPreferences != null ? operationPreferences.toBuilder() : null;
        }

        @Override
        public final Builder operationPreferences(StackSetOperationPreferences operationPreferences) {
            this.operationPreferences = operationPreferences;
            return this;
        }

        public final void setOperationPreferences(StackSetOperationPreferences.BuilderImpl operationPreferences) {
            this.operationPreferences = operationPreferences != null ? operationPreferences.build() : null;
        }

        public final String getOperationId() {
            return operationId;
        }

        @Override
        public final Builder operationId(String operationId) {
            this.operationId = operationId;
            return this;
        }

        public final void setOperationId(String operationId) {
            this.operationId = operationId;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateStackInstancesRequest build() {
            return new UpdateStackInstancesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
