/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudformation.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The output for a <a>ListStackResources</a> action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListStackResourcesResponse extends CloudFormationResponse implements
        ToCopyableBuilder<ListStackResourcesResponse.Builder, ListStackResourcesResponse> {
    private static final SdkField<List<StackResourceSummary>> STACK_RESOURCE_SUMMARIES_FIELD = SdkField
            .<List<StackResourceSummary>> builder(MarshallingType.LIST)
            .getter(getter(ListStackResourcesResponse::stackResourceSummaries))
            .setter(setter(Builder::stackResourceSummaries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StackResourceSummaries").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<StackResourceSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(StackResourceSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListStackResourcesResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            STACK_RESOURCE_SUMMARIES_FIELD, NEXT_TOKEN_FIELD));

    private final List<StackResourceSummary> stackResourceSummaries;

    private final String nextToken;

    private ListStackResourcesResponse(BuilderImpl builder) {
        super(builder);
        this.stackResourceSummaries = builder.stackResourceSummaries;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * A list of <code>StackResourceSummary</code> structures.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A list of <code>StackResourceSummary</code> structures.
     */
    public List<StackResourceSummary> stackResourceSummaries() {
        return stackResourceSummaries;
    }

    /**
     * <p>
     * If the output exceeds 1 MB, a string that identifies the next page of stack resources. If no additional page
     * exists, this value is null.
     * </p>
     * 
     * @return If the output exceeds 1 MB, a string that identifies the next page of stack resources. If no additional
     *         page exists, this value is null.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(stackResourceSummaries());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListStackResourcesResponse)) {
            return false;
        }
        ListStackResourcesResponse other = (ListStackResourcesResponse) obj;
        return Objects.equals(stackResourceSummaries(), other.stackResourceSummaries())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListStackResourcesResponse").add("StackResourceSummaries", stackResourceSummaries())
                .add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StackResourceSummaries":
            return Optional.ofNullable(clazz.cast(stackResourceSummaries()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListStackResourcesResponse, T> g) {
        return obj -> g.apply((ListStackResourcesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudFormationResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListStackResourcesResponse> {
        /**
         * <p>
         * A list of <code>StackResourceSummary</code> structures.
         * </p>
         * 
         * @param stackResourceSummaries
         *        A list of <code>StackResourceSummary</code> structures.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stackResourceSummaries(Collection<StackResourceSummary> stackResourceSummaries);

        /**
         * <p>
         * A list of <code>StackResourceSummary</code> structures.
         * </p>
         * 
         * @param stackResourceSummaries
         *        A list of <code>StackResourceSummary</code> structures.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stackResourceSummaries(StackResourceSummary... stackResourceSummaries);

        /**
         * <p>
         * A list of <code>StackResourceSummary</code> structures.
         * </p>
         * This is a convenience that creates an instance of the {@link List<StackResourceSummary>.Builder} avoiding the
         * need to create one manually via {@link List<StackResourceSummary>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<StackResourceSummary>.Builder#build()} is called immediately
         * and its result is passed to {@link #stackResourceSummaries(List<StackResourceSummary>)}.
         * 
         * @param stackResourceSummaries
         *        a consumer that will call methods on {@link List<StackResourceSummary>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #stackResourceSummaries(List<StackResourceSummary>)
         */
        Builder stackResourceSummaries(Consumer<StackResourceSummary.Builder>... stackResourceSummaries);

        /**
         * <p>
         * If the output exceeds 1 MB, a string that identifies the next page of stack resources. If no additional page
         * exists, this value is null.
         * </p>
         * 
         * @param nextToken
         *        If the output exceeds 1 MB, a string that identifies the next page of stack resources. If no
         *        additional page exists, this value is null.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends CloudFormationResponse.BuilderImpl implements Builder {
        private List<StackResourceSummary> stackResourceSummaries = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListStackResourcesResponse model) {
            super(model);
            stackResourceSummaries(model.stackResourceSummaries);
            nextToken(model.nextToken);
        }

        public final Collection<StackResourceSummary.Builder> getStackResourceSummaries() {
            return stackResourceSummaries != null ? stackResourceSummaries.stream().map(StackResourceSummary::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder stackResourceSummaries(Collection<StackResourceSummary> stackResourceSummaries) {
            this.stackResourceSummaries = StackResourceSummariesCopier.copy(stackResourceSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stackResourceSummaries(StackResourceSummary... stackResourceSummaries) {
            stackResourceSummaries(Arrays.asList(stackResourceSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stackResourceSummaries(Consumer<StackResourceSummary.Builder>... stackResourceSummaries) {
            stackResourceSummaries(Stream.of(stackResourceSummaries)
                    .map(c -> StackResourceSummary.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setStackResourceSummaries(Collection<StackResourceSummary.BuilderImpl> stackResourceSummaries) {
            this.stackResourceSummaries = StackResourceSummariesCopier.copyFromBuilder(stackResourceSummaries);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListStackResourcesResponse build() {
            return new ListStackResourcesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
