/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudformation.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The output for the <a>ListChangeSets</a> action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListChangeSetsResponse extends CloudFormationResponse implements
        ToCopyableBuilder<ListChangeSetsResponse.Builder, ListChangeSetsResponse> {
    private static final SdkField<List<ChangeSetSummary>> SUMMARIES_FIELD = SdkField
            .<List<ChangeSetSummary>> builder(MarshallingType.LIST)
            .getter(getter(ListChangeSetsResponse::summaries))
            .setter(setter(Builder::summaries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Summaries").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ChangeSetSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(ChangeSetSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListChangeSetsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUMMARIES_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<ChangeSetSummary> summaries;

    private final String nextToken;

    private ListChangeSetsResponse(BuilderImpl builder) {
        super(builder);
        this.summaries = builder.summaries;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * A list of <code>ChangeSetSummary</code> structures that provides the ID and status of each change set for the
     * specified stack.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A list of <code>ChangeSetSummary</code> structures that provides the ID and status of each change set for
     *         the specified stack.
     */
    public List<ChangeSetSummary> summaries() {
        return summaries;
    }

    /**
     * <p>
     * If the output exceeds 1 MB, a string that identifies the next page of change sets. If there is no additional
     * page, this value is null.
     * </p>
     * 
     * @return If the output exceeds 1 MB, a string that identifies the next page of change sets. If there is no
     *         additional page, this value is null.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(summaries());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListChangeSetsResponse)) {
            return false;
        }
        ListChangeSetsResponse other = (ListChangeSetsResponse) obj;
        return Objects.equals(summaries(), other.summaries()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListChangeSetsResponse").add("Summaries", summaries()).add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Summaries":
            return Optional.ofNullable(clazz.cast(summaries()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListChangeSetsResponse, T> g) {
        return obj -> g.apply((ListChangeSetsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudFormationResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListChangeSetsResponse> {
        /**
         * <p>
         * A list of <code>ChangeSetSummary</code> structures that provides the ID and status of each change set for the
         * specified stack.
         * </p>
         * 
         * @param summaries
         *        A list of <code>ChangeSetSummary</code> structures that provides the ID and status of each change set
         *        for the specified stack.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder summaries(Collection<ChangeSetSummary> summaries);

        /**
         * <p>
         * A list of <code>ChangeSetSummary</code> structures that provides the ID and status of each change set for the
         * specified stack.
         * </p>
         * 
         * @param summaries
         *        A list of <code>ChangeSetSummary</code> structures that provides the ID and status of each change set
         *        for the specified stack.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder summaries(ChangeSetSummary... summaries);

        /**
         * <p>
         * A list of <code>ChangeSetSummary</code> structures that provides the ID and status of each change set for the
         * specified stack.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ChangeSetSummary>.Builder} avoiding the
         * need to create one manually via {@link List<ChangeSetSummary>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ChangeSetSummary>.Builder#build()} is called immediately and
         * its result is passed to {@link #summaries(List<ChangeSetSummary>)}.
         * 
         * @param summaries
         *        a consumer that will call methods on {@link List<ChangeSetSummary>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #summaries(List<ChangeSetSummary>)
         */
        Builder summaries(Consumer<ChangeSetSummary.Builder>... summaries);

        /**
         * <p>
         * If the output exceeds 1 MB, a string that identifies the next page of change sets. If there is no additional
         * page, this value is null.
         * </p>
         * 
         * @param nextToken
         *        If the output exceeds 1 MB, a string that identifies the next page of change sets. If there is no
         *        additional page, this value is null.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends CloudFormationResponse.BuilderImpl implements Builder {
        private List<ChangeSetSummary> summaries = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListChangeSetsResponse model) {
            super(model);
            summaries(model.summaries);
            nextToken(model.nextToken);
        }

        public final Collection<ChangeSetSummary.Builder> getSummaries() {
            return summaries != null ? summaries.stream().map(ChangeSetSummary::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder summaries(Collection<ChangeSetSummary> summaries) {
            this.summaries = ChangeSetSummariesCopier.copy(summaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder summaries(ChangeSetSummary... summaries) {
            summaries(Arrays.asList(summaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder summaries(Consumer<ChangeSetSummary.Builder>... summaries) {
            summaries(Stream.of(summaries).map(c -> ChangeSetSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setSummaries(Collection<ChangeSetSummary.BuilderImpl> summaries) {
            this.summaries = ChangeSetSummariesCopier.copyFromBuilder(summaries);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListChangeSetsResponse build() {
            return new ListChangeSetsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
