/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudformation.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The input for the <a>CreateChangeSet</a> action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateChangeSetRequest extends CloudFormationRequest implements
        ToCopyableBuilder<CreateChangeSetRequest.Builder, CreateChangeSetRequest> {
    private static final SdkField<String> STACK_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateChangeSetRequest::stackName)).setter(setter(Builder::stackName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StackName").build()).build();

    private static final SdkField<String> TEMPLATE_BODY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateChangeSetRequest::templateBody)).setter(setter(Builder::templateBody))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TemplateBody").build()).build();

    private static final SdkField<String> TEMPLATE_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateChangeSetRequest::templateURL)).setter(setter(Builder::templateURL))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TemplateURL").build()).build();

    private static final SdkField<Boolean> USE_PREVIOUS_TEMPLATE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(CreateChangeSetRequest::usePreviousTemplate)).setter(setter(Builder::usePreviousTemplate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UsePreviousTemplate").build())
            .build();

    private static final SdkField<List<Parameter>> PARAMETERS_FIELD = SdkField
            .<List<Parameter>> builder(MarshallingType.LIST)
            .getter(getter(CreateChangeSetRequest::parameters))
            .setter(setter(Builder::parameters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Parameters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Parameter> builder(MarshallingType.SDK_POJO)
                                            .constructor(Parameter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> CAPABILITIES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(CreateChangeSetRequest::capabilitiesAsStrings))
            .setter(setter(Builder::capabilitiesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Capabilities").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> RESOURCE_TYPES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(CreateChangeSetRequest::resourceTypes))
            .setter(setter(Builder::resourceTypes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceTypes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateChangeSetRequest::roleARN)).setter(setter(Builder::roleARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleARN").build()).build();

    private static final SdkField<RollbackConfiguration> ROLLBACK_CONFIGURATION_FIELD = SdkField
            .<RollbackConfiguration> builder(MarshallingType.SDK_POJO)
            .getter(getter(CreateChangeSetRequest::rollbackConfiguration)).setter(setter(Builder::rollbackConfiguration))
            .constructor(RollbackConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RollbackConfiguration").build())
            .build();

    private static final SdkField<List<String>> NOTIFICATION_AR_NS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(CreateChangeSetRequest::notificationARNs))
            .setter(setter(Builder::notificationARNs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NotificationARNs").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .getter(getter(CreateChangeSetRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> CHANGE_SET_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateChangeSetRequest::changeSetName)).setter(setter(Builder::changeSetName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChangeSetName").build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateChangeSetRequest::clientToken)).setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateChangeSetRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> CHANGE_SET_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateChangeSetRequest::changeSetTypeAsString)).setter(setter(Builder::changeSetType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChangeSetType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STACK_NAME_FIELD,
            TEMPLATE_BODY_FIELD, TEMPLATE_URL_FIELD, USE_PREVIOUS_TEMPLATE_FIELD, PARAMETERS_FIELD, CAPABILITIES_FIELD,
            RESOURCE_TYPES_FIELD, ROLE_ARN_FIELD, ROLLBACK_CONFIGURATION_FIELD, NOTIFICATION_AR_NS_FIELD, TAGS_FIELD,
            CHANGE_SET_NAME_FIELD, CLIENT_TOKEN_FIELD, DESCRIPTION_FIELD, CHANGE_SET_TYPE_FIELD));

    private final String stackName;

    private final String templateBody;

    private final String templateURL;

    private final Boolean usePreviousTemplate;

    private final List<Parameter> parameters;

    private final List<String> capabilities;

    private final List<String> resourceTypes;

    private final String roleARN;

    private final RollbackConfiguration rollbackConfiguration;

    private final List<String> notificationARNs;

    private final List<Tag> tags;

    private final String changeSetName;

    private final String clientToken;

    private final String description;

    private final String changeSetType;

    private CreateChangeSetRequest(BuilderImpl builder) {
        super(builder);
        this.stackName = builder.stackName;
        this.templateBody = builder.templateBody;
        this.templateURL = builder.templateURL;
        this.usePreviousTemplate = builder.usePreviousTemplate;
        this.parameters = builder.parameters;
        this.capabilities = builder.capabilities;
        this.resourceTypes = builder.resourceTypes;
        this.roleARN = builder.roleARN;
        this.rollbackConfiguration = builder.rollbackConfiguration;
        this.notificationARNs = builder.notificationARNs;
        this.tags = builder.tags;
        this.changeSetName = builder.changeSetName;
        this.clientToken = builder.clientToken;
        this.description = builder.description;
        this.changeSetType = builder.changeSetType;
    }

    /**
     * <p>
     * The name or the unique ID of the stack for which you are creating a change set. AWS CloudFormation generates the
     * change set by comparing this stack's information with the information that you submit, such as a modified
     * template or different parameter input values.
     * </p>
     * 
     * @return The name or the unique ID of the stack for which you are creating a change set. AWS CloudFormation
     *         generates the change set by comparing this stack's information with the information that you submit, such
     *         as a modified template or different parameter input values.
     */
    public String stackName() {
        return stackName;
    }

    /**
     * <p>
     * A structure that contains the body of the revised template, with a minimum length of 1 byte and a maximum length
     * of 51,200 bytes. AWS CloudFormation generates the change set by comparing this template with the template of the
     * stack that you specified.
     * </p>
     * <p>
     * Conditional: You must specify only <code>TemplateBody</code> or <code>TemplateURL</code>.
     * </p>
     * 
     * @return A structure that contains the body of the revised template, with a minimum length of 1 byte and a maximum
     *         length of 51,200 bytes. AWS CloudFormation generates the change set by comparing this template with the
     *         template of the stack that you specified.</p>
     *         <p>
     *         Conditional: You must specify only <code>TemplateBody</code> or <code>TemplateURL</code>.
     */
    public String templateBody() {
        return templateBody;
    }

    /**
     * <p>
     * The location of the file that contains the revised template. The URL must point to a template (max size: 460,800
     * bytes) that is located in an S3 bucket. AWS CloudFormation generates the change set by comparing this template
     * with the stack that you specified.
     * </p>
     * <p>
     * Conditional: You must specify only <code>TemplateBody</code> or <code>TemplateURL</code>.
     * </p>
     * 
     * @return The location of the file that contains the revised template. The URL must point to a template (max size:
     *         460,800 bytes) that is located in an S3 bucket. AWS CloudFormation generates the change set by comparing
     *         this template with the stack that you specified.</p>
     *         <p>
     *         Conditional: You must specify only <code>TemplateBody</code> or <code>TemplateURL</code>.
     */
    public String templateURL() {
        return templateURL;
    }

    /**
     * <p>
     * Whether to reuse the template that is associated with the stack to create the change set.
     * </p>
     * 
     * @return Whether to reuse the template that is associated with the stack to create the change set.
     */
    public Boolean usePreviousTemplate() {
        return usePreviousTemplate;
    }

    /**
     * <p>
     * A list of <code>Parameter</code> structures that specify input parameters for the change set. For more
     * information, see the <a>Parameter</a> data type.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A list of <code>Parameter</code> structures that specify input parameters for the change set. For more
     *         information, see the <a>Parameter</a> data type.
     */
    public List<Parameter> parameters() {
        return parameters;
    }

    /**
     * <p>
     * In some cases, you must explicity acknowledge that your stack template contains certain capabilities in order for
     * AWS CloudFormation to create the stack.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>CAPABILITY_IAM</code> and <code>CAPABILITY_NAMED_IAM</code>
     * </p>
     * <p>
     * Some stack templates might include resources that can affect permissions in your AWS account; for example, by
     * creating new AWS Identity and Access Management (IAM) users. For those stacks, you must explicitly acknowledge
     * this by specifying one of these capabilities.
     * </p>
     * <p>
     * The following IAM resources require you to specify either the <code>CAPABILITY_IAM</code> or
     * <code>CAPABILITY_NAMED_IAM</code> capability.
     * </p>
     * <ul>
     * <li>
     * <p>
     * If you have IAM resources, you can specify either capability.
     * </p>
     * </li>
     * <li>
     * <p>
     * If you have IAM resources with custom names, you <i>must</i> specify <code>CAPABILITY_NAMED_IAM</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * If you don't specify either of these capabilities, AWS CloudFormation returns an
     * <code>InsufficientCapabilities</code> error.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If your stack template contains these resources, we recommend that you review all permissions associated with
     * them and edit their permissions if necessary.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-accesskey.html">
     * AWS::IAM::AccessKey</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-group.html">
     * AWS::IAM::Group</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-instanceprofile.html">
     * AWS::IAM::InstanceProfile</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-policy.html">
     * AWS::IAM::Policy</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-role.html">
     * AWS::IAM::Role</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-user.html">
     * AWS::IAM::User</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-addusertogroup.html">
     * AWS::IAM::UserToGroupAddition</a>
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information, see <a
     * href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html#capabilities"
     * >Acknowledging IAM Resources in AWS CloudFormation Templates</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CAPABILITY_AUTO_EXPAND</code>
     * </p>
     * <p>
     * Some template contain macros. Macros perform custom processing on templates; this can include simple actions like
     * find-and-replace operations, all the way to extensive transformations of entire templates. Because of this, users
     * typically create a change set from the processed template, so that they can review the changes resulting from the
     * macros before actually creating the stack. If your stack template contains one or more macros, and you choose to
     * create a stack directly from the processed template, without first reviewing the resulting changes in a change
     * set, you must acknowledge this capability. This includes the <a href=
     * "http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/create-reusable-transform-function-snippets-and-add-to-your-template-with-aws-include-transform.html"
     * >AWS::Include</a> and <a
     * href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/transform-aws-serverless.html"
     * >AWS::Serverless</a> transforms, which are macros hosted by AWS CloudFormation.
     * </p>
     * <note>
     * <p>
     * This capacity does not apply to creating change sets, and specifying it when creating change sets has no effect.
     * </p>
     * <p>
     * Also, change sets do not currently support nested stacks. If you want to create a stack from a stack template
     * that contains macros <i>and</i> nested stacks, you must create or update the stack directly from the template
     * using the <a>CreateStack</a> or <a>UpdateStack</a> action, and specifying this capability.
     * </p>
     * </note>
     * <p>
     * For more information on macros, see <a
     * href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-macros.html">Using AWS
     * CloudFormation Macros to Perform Custom Processing on Templates</a>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return In some cases, you must explicity acknowledge that your stack template contains certain capabilities in
     *         order for AWS CloudFormation to create the stack.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>CAPABILITY_IAM</code> and <code>CAPABILITY_NAMED_IAM</code>
     *         </p>
     *         <p>
     *         Some stack templates might include resources that can affect permissions in your AWS account; for
     *         example, by creating new AWS Identity and Access Management (IAM) users. For those stacks, you must
     *         explicitly acknowledge this by specifying one of these capabilities.
     *         </p>
     *         <p>
     *         The following IAM resources require you to specify either the <code>CAPABILITY_IAM</code> or
     *         <code>CAPABILITY_NAMED_IAM</code> capability.
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         If you have IAM resources, you can specify either capability.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         If you have IAM resources with custom names, you <i>must</i> specify <code>CAPABILITY_NAMED_IAM</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         If you don't specify either of these capabilities, AWS CloudFormation returns an
     *         <code>InsufficientCapabilities</code> error.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         If your stack template contains these resources, we recommend that you review all permissions associated
     *         with them and edit their permissions if necessary.
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <a
     *         href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-accesskey.html">
     *         AWS::IAM::AccessKey</a>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-group.html">
     *         AWS::IAM::Group</a>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <a href=
     *         "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-instanceprofile.html">
     *         AWS::IAM::InstanceProfile</a>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-policy.html">
     *         AWS::IAM::Policy</a>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-role.html">
     *         AWS::IAM::Role</a>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-user.html">
     *         AWS::IAM::User</a>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <a href=
     *         "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-addusertogroup.html">
     *         AWS::IAM::UserToGroupAddition</a>
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For more information, see <a href=
     *         "http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html#capabilities"
     *         >Acknowledging IAM Resources in AWS CloudFormation Templates</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CAPABILITY_AUTO_EXPAND</code>
     *         </p>
     *         <p>
     *         Some template contain macros. Macros perform custom processing on templates; this can include simple
     *         actions like find-and-replace operations, all the way to extensive transformations of entire templates.
     *         Because of this, users typically create a change set from the processed template, so that they can review
     *         the changes resulting from the macros before actually creating the stack. If your stack template contains
     *         one or more macros, and you choose to create a stack directly from the processed template, without first
     *         reviewing the resulting changes in a change set, you must acknowledge this capability. This includes the
     *         <a href=
     *         "http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/create-reusable-transform-function-snippets-and-add-to-your-template-with-aws-include-transform.html"
     *         >AWS::Include</a> and <a
     *         href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/transform-aws-serverless.html"
     *         >AWS::Serverless</a> transforms, which are macros hosted by AWS CloudFormation.
     *         </p>
     *         <note>
     *         <p>
     *         This capacity does not apply to creating change sets, and specifying it when creating change sets has no
     *         effect.
     *         </p>
     *         <p>
     *         Also, change sets do not currently support nested stacks. If you want to create a stack from a stack
     *         template that contains macros <i>and</i> nested stacks, you must create or update the stack directly from
     *         the template using the <a>CreateStack</a> or <a>UpdateStack</a> action, and specifying this capability.
     *         </p>
     *         </note>
     *         <p>
     *         For more information on macros, see <a
     *         href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-macros.html">Using AWS
     *         CloudFormation Macros to Perform Custom Processing on Templates</a>.
     *         </p>
     *         </li>
     */
    public List<Capability> capabilities() {
        return CapabilitiesCopier.copyStringToEnum(capabilities);
    }

    /**
     * <p>
     * In some cases, you must explicity acknowledge that your stack template contains certain capabilities in order for
     * AWS CloudFormation to create the stack.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>CAPABILITY_IAM</code> and <code>CAPABILITY_NAMED_IAM</code>
     * </p>
     * <p>
     * Some stack templates might include resources that can affect permissions in your AWS account; for example, by
     * creating new AWS Identity and Access Management (IAM) users. For those stacks, you must explicitly acknowledge
     * this by specifying one of these capabilities.
     * </p>
     * <p>
     * The following IAM resources require you to specify either the <code>CAPABILITY_IAM</code> or
     * <code>CAPABILITY_NAMED_IAM</code> capability.
     * </p>
     * <ul>
     * <li>
     * <p>
     * If you have IAM resources, you can specify either capability.
     * </p>
     * </li>
     * <li>
     * <p>
     * If you have IAM resources with custom names, you <i>must</i> specify <code>CAPABILITY_NAMED_IAM</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * If you don't specify either of these capabilities, AWS CloudFormation returns an
     * <code>InsufficientCapabilities</code> error.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If your stack template contains these resources, we recommend that you review all permissions associated with
     * them and edit their permissions if necessary.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-accesskey.html">
     * AWS::IAM::AccessKey</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-group.html">
     * AWS::IAM::Group</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-instanceprofile.html">
     * AWS::IAM::InstanceProfile</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-policy.html">
     * AWS::IAM::Policy</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-role.html">
     * AWS::IAM::Role</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-user.html">
     * AWS::IAM::User</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-addusertogroup.html">
     * AWS::IAM::UserToGroupAddition</a>
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information, see <a
     * href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html#capabilities"
     * >Acknowledging IAM Resources in AWS CloudFormation Templates</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CAPABILITY_AUTO_EXPAND</code>
     * </p>
     * <p>
     * Some template contain macros. Macros perform custom processing on templates; this can include simple actions like
     * find-and-replace operations, all the way to extensive transformations of entire templates. Because of this, users
     * typically create a change set from the processed template, so that they can review the changes resulting from the
     * macros before actually creating the stack. If your stack template contains one or more macros, and you choose to
     * create a stack directly from the processed template, without first reviewing the resulting changes in a change
     * set, you must acknowledge this capability. This includes the <a href=
     * "http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/create-reusable-transform-function-snippets-and-add-to-your-template-with-aws-include-transform.html"
     * >AWS::Include</a> and <a
     * href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/transform-aws-serverless.html"
     * >AWS::Serverless</a> transforms, which are macros hosted by AWS CloudFormation.
     * </p>
     * <note>
     * <p>
     * This capacity does not apply to creating change sets, and specifying it when creating change sets has no effect.
     * </p>
     * <p>
     * Also, change sets do not currently support nested stacks. If you want to create a stack from a stack template
     * that contains macros <i>and</i> nested stacks, you must create or update the stack directly from the template
     * using the <a>CreateStack</a> or <a>UpdateStack</a> action, and specifying this capability.
     * </p>
     * </note>
     * <p>
     * For more information on macros, see <a
     * href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-macros.html">Using AWS
     * CloudFormation Macros to Perform Custom Processing on Templates</a>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return In some cases, you must explicity acknowledge that your stack template contains certain capabilities in
     *         order for AWS CloudFormation to create the stack.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>CAPABILITY_IAM</code> and <code>CAPABILITY_NAMED_IAM</code>
     *         </p>
     *         <p>
     *         Some stack templates might include resources that can affect permissions in your AWS account; for
     *         example, by creating new AWS Identity and Access Management (IAM) users. For those stacks, you must
     *         explicitly acknowledge this by specifying one of these capabilities.
     *         </p>
     *         <p>
     *         The following IAM resources require you to specify either the <code>CAPABILITY_IAM</code> or
     *         <code>CAPABILITY_NAMED_IAM</code> capability.
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         If you have IAM resources, you can specify either capability.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         If you have IAM resources with custom names, you <i>must</i> specify <code>CAPABILITY_NAMED_IAM</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         If you don't specify either of these capabilities, AWS CloudFormation returns an
     *         <code>InsufficientCapabilities</code> error.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         If your stack template contains these resources, we recommend that you review all permissions associated
     *         with them and edit their permissions if necessary.
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <a
     *         href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-accesskey.html">
     *         AWS::IAM::AccessKey</a>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-group.html">
     *         AWS::IAM::Group</a>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <a href=
     *         "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-instanceprofile.html">
     *         AWS::IAM::InstanceProfile</a>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-policy.html">
     *         AWS::IAM::Policy</a>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-role.html">
     *         AWS::IAM::Role</a>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-user.html">
     *         AWS::IAM::User</a>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <a href=
     *         "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-addusertogroup.html">
     *         AWS::IAM::UserToGroupAddition</a>
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For more information, see <a href=
     *         "http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html#capabilities"
     *         >Acknowledging IAM Resources in AWS CloudFormation Templates</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CAPABILITY_AUTO_EXPAND</code>
     *         </p>
     *         <p>
     *         Some template contain macros. Macros perform custom processing on templates; this can include simple
     *         actions like find-and-replace operations, all the way to extensive transformations of entire templates.
     *         Because of this, users typically create a change set from the processed template, so that they can review
     *         the changes resulting from the macros before actually creating the stack. If your stack template contains
     *         one or more macros, and you choose to create a stack directly from the processed template, without first
     *         reviewing the resulting changes in a change set, you must acknowledge this capability. This includes the
     *         <a href=
     *         "http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/create-reusable-transform-function-snippets-and-add-to-your-template-with-aws-include-transform.html"
     *         >AWS::Include</a> and <a
     *         href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/transform-aws-serverless.html"
     *         >AWS::Serverless</a> transforms, which are macros hosted by AWS CloudFormation.
     *         </p>
     *         <note>
     *         <p>
     *         This capacity does not apply to creating change sets, and specifying it when creating change sets has no
     *         effect.
     *         </p>
     *         <p>
     *         Also, change sets do not currently support nested stacks. If you want to create a stack from a stack
     *         template that contains macros <i>and</i> nested stacks, you must create or update the stack directly from
     *         the template using the <a>CreateStack</a> or <a>UpdateStack</a> action, and specifying this capability.
     *         </p>
     *         </note>
     *         <p>
     *         For more information on macros, see <a
     *         href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-macros.html">Using AWS
     *         CloudFormation Macros to Perform Custom Processing on Templates</a>.
     *         </p>
     *         </li>
     */
    public List<String> capabilitiesAsStrings() {
        return capabilities;
    }

    /**
     * <p>
     * The template resource types that you have permissions to work with if you execute this change set, such as
     * <code>AWS::EC2::Instance</code>, <code>AWS::EC2::*</code>, or <code>Custom::MyCustomInstance</code>.
     * </p>
     * <p>
     * If the list of resource types doesn't include a resource type that you're updating, the stack update fails. By
     * default, AWS CloudFormation grants permissions to all resource types. AWS Identity and Access Management (IAM)
     * uses this parameter for condition keys in IAM policies for AWS CloudFormation. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html">Controlling Access
     * with AWS Identity and Access Management</a> in the AWS CloudFormation User Guide.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The template resource types that you have permissions to work with if you execute this change set, such
     *         as <code>AWS::EC2::Instance</code>, <code>AWS::EC2::*</code>, or <code>Custom::MyCustomInstance</code>
     *         .</p>
     *         <p>
     *         If the list of resource types doesn't include a resource type that you're updating, the stack update
     *         fails. By default, AWS CloudFormation grants permissions to all resource types. AWS Identity and Access
     *         Management (IAM) uses this parameter for condition keys in IAM policies for AWS CloudFormation. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html">Controlling
     *         Access with AWS Identity and Access Management</a> in the AWS CloudFormation User Guide.
     */
    public List<String> resourceTypes() {
        return resourceTypes;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of an AWS Identity and Access Management (IAM) role that AWS CloudFormation
     * assumes when executing the change set. AWS CloudFormation uses the role's credentials to make calls on your
     * behalf. AWS CloudFormation uses this role for all future operations on the stack. As long as users have
     * permission to operate on the stack, AWS CloudFormation uses this role even if the users don't have permission to
     * pass it. Ensure that the role grants least privilege.
     * </p>
     * <p>
     * If you don't specify a value, AWS CloudFormation uses the role that was previously associated with the stack. If
     * no role is available, AWS CloudFormation uses a temporary session that is generated from your user credentials.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of an AWS Identity and Access Management (IAM) role that AWS
     *         CloudFormation assumes when executing the change set. AWS CloudFormation uses the role's credentials to
     *         make calls on your behalf. AWS CloudFormation uses this role for all future operations on the stack. As
     *         long as users have permission to operate on the stack, AWS CloudFormation uses this role even if the
     *         users don't have permission to pass it. Ensure that the role grants least privilege.</p>
     *         <p>
     *         If you don't specify a value, AWS CloudFormation uses the role that was previously associated with the
     *         stack. If no role is available, AWS CloudFormation uses a temporary session that is generated from your
     *         user credentials.
     */
    public String roleARN() {
        return roleARN;
    }

    /**
     * <p>
     * The rollback triggers for AWS CloudFormation to monitor during stack creation and updating operations, and for
     * the specified monitoring period afterwards.
     * </p>
     * 
     * @return The rollback triggers for AWS CloudFormation to monitor during stack creation and updating operations,
     *         and for the specified monitoring period afterwards.
     */
    public RollbackConfiguration rollbackConfiguration() {
        return rollbackConfiguration;
    }

    /**
     * <p>
     * The Amazon Resource Names (ARNs) of Amazon Simple Notification Service (Amazon SNS) topics that AWS
     * CloudFormation associates with the stack. To remove all associated notification topics, specify an empty list.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The Amazon Resource Names (ARNs) of Amazon Simple Notification Service (Amazon SNS) topics that AWS
     *         CloudFormation associates with the stack. To remove all associated notification topics, specify an empty
     *         list.
     */
    public List<String> notificationARNs() {
        return notificationARNs;
    }

    /**
     * <p>
     * Key-value pairs to associate with this stack. AWS CloudFormation also propagates these tags to resources in the
     * stack. You can specify a maximum of 50 tags.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Key-value pairs to associate with this stack. AWS CloudFormation also propagates these tags to resources
     *         in the stack. You can specify a maximum of 50 tags.
     */
    public List<Tag> tags() {
        return tags;
    }

    /**
     * <p>
     * The name of the change set. The name must be unique among all change sets that are associated with the specified
     * stack.
     * </p>
     * <p>
     * A change set name can contain only alphanumeric, case sensitive characters and hyphens. It must start with an
     * alphabetic character and cannot exceed 128 characters.
     * </p>
     * 
     * @return The name of the change set. The name must be unique among all change sets that are associated with the
     *         specified stack.</p>
     *         <p>
     *         A change set name can contain only alphanumeric, case sensitive characters and hyphens. It must start
     *         with an alphabetic character and cannot exceed 128 characters.
     */
    public String changeSetName() {
        return changeSetName;
    }

    /**
     * <p>
     * A unique identifier for this <code>CreateChangeSet</code> request. Specify this token if you plan to retry
     * requests so that AWS CloudFormation knows that you're not attempting to create another change set with the same
     * name. You might retry <code>CreateChangeSet</code> requests to ensure that AWS CloudFormation successfully
     * received them.
     * </p>
     * 
     * @return A unique identifier for this <code>CreateChangeSet</code> request. Specify this token if you plan to
     *         retry requests so that AWS CloudFormation knows that you're not attempting to create another change set
     *         with the same name. You might retry <code>CreateChangeSet</code> requests to ensure that AWS
     *         CloudFormation successfully received them.
     */
    public String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * A description to help you identify this change set.
     * </p>
     * 
     * @return A description to help you identify this change set.
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * The type of change set operation. To create a change set for a new stack, specify <code>CREATE</code>. To create
     * a change set for an existing stack, specify <code>UPDATE</code>.
     * </p>
     * <p>
     * If you create a change set for a new stack, AWS Cloudformation creates a stack with a unique stack ID, but no
     * template or resources. The stack will be in the <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-describing-stacks.html#d0e11995">
     * <code>REVIEW_IN_PROGRESS</code> </a> state until you execute the change set.
     * </p>
     * <p>
     * By default, AWS CloudFormation specifies <code>UPDATE</code>. You can't use the <code>UPDATE</code> type to
     * create a change set for a new stack or the <code>CREATE</code> type to create a change set for an existing stack.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #changeSetType}
     * will return {@link ChangeSetType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #changeSetTypeAsString}.
     * </p>
     * 
     * @return The type of change set operation. To create a change set for a new stack, specify <code>CREATE</code>. To
     *         create a change set for an existing stack, specify <code>UPDATE</code>.</p>
     *         <p>
     *         If you create a change set for a new stack, AWS Cloudformation creates a stack with a unique stack ID,
     *         but no template or resources. The stack will be in the <a href=
     *         "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-describing-stacks.html#d0e11995"
     *         > <code>REVIEW_IN_PROGRESS</code> </a> state until you execute the change set.
     *         </p>
     *         <p>
     *         By default, AWS CloudFormation specifies <code>UPDATE</code>. You can't use the <code>UPDATE</code> type
     *         to create a change set for a new stack or the <code>CREATE</code> type to create a change set for an
     *         existing stack.
     * @see ChangeSetType
     */
    public ChangeSetType changeSetType() {
        return ChangeSetType.fromValue(changeSetType);
    }

    /**
     * <p>
     * The type of change set operation. To create a change set for a new stack, specify <code>CREATE</code>. To create
     * a change set for an existing stack, specify <code>UPDATE</code>.
     * </p>
     * <p>
     * If you create a change set for a new stack, AWS Cloudformation creates a stack with a unique stack ID, but no
     * template or resources. The stack will be in the <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-describing-stacks.html#d0e11995">
     * <code>REVIEW_IN_PROGRESS</code> </a> state until you execute the change set.
     * </p>
     * <p>
     * By default, AWS CloudFormation specifies <code>UPDATE</code>. You can't use the <code>UPDATE</code> type to
     * create a change set for a new stack or the <code>CREATE</code> type to create a change set for an existing stack.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #changeSetType}
     * will return {@link ChangeSetType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #changeSetTypeAsString}.
     * </p>
     * 
     * @return The type of change set operation. To create a change set for a new stack, specify <code>CREATE</code>. To
     *         create a change set for an existing stack, specify <code>UPDATE</code>.</p>
     *         <p>
     *         If you create a change set for a new stack, AWS Cloudformation creates a stack with a unique stack ID,
     *         but no template or resources. The stack will be in the <a href=
     *         "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-describing-stacks.html#d0e11995"
     *         > <code>REVIEW_IN_PROGRESS</code> </a> state until you execute the change set.
     *         </p>
     *         <p>
     *         By default, AWS CloudFormation specifies <code>UPDATE</code>. You can't use the <code>UPDATE</code> type
     *         to create a change set for a new stack or the <code>CREATE</code> type to create a change set for an
     *         existing stack.
     * @see ChangeSetType
     */
    public String changeSetTypeAsString() {
        return changeSetType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(stackName());
        hashCode = 31 * hashCode + Objects.hashCode(templateBody());
        hashCode = 31 * hashCode + Objects.hashCode(templateURL());
        hashCode = 31 * hashCode + Objects.hashCode(usePreviousTemplate());
        hashCode = 31 * hashCode + Objects.hashCode(parameters());
        hashCode = 31 * hashCode + Objects.hashCode(capabilitiesAsStrings());
        hashCode = 31 * hashCode + Objects.hashCode(resourceTypes());
        hashCode = 31 * hashCode + Objects.hashCode(roleARN());
        hashCode = 31 * hashCode + Objects.hashCode(rollbackConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(notificationARNs());
        hashCode = 31 * hashCode + Objects.hashCode(tags());
        hashCode = 31 * hashCode + Objects.hashCode(changeSetName());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(changeSetTypeAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateChangeSetRequest)) {
            return false;
        }
        CreateChangeSetRequest other = (CreateChangeSetRequest) obj;
        return Objects.equals(stackName(), other.stackName()) && Objects.equals(templateBody(), other.templateBody())
                && Objects.equals(templateURL(), other.templateURL())
                && Objects.equals(usePreviousTemplate(), other.usePreviousTemplate())
                && Objects.equals(parameters(), other.parameters())
                && Objects.equals(capabilitiesAsStrings(), other.capabilitiesAsStrings())
                && Objects.equals(resourceTypes(), other.resourceTypes()) && Objects.equals(roleARN(), other.roleARN())
                && Objects.equals(rollbackConfiguration(), other.rollbackConfiguration())
                && Objects.equals(notificationARNs(), other.notificationARNs()) && Objects.equals(tags(), other.tags())
                && Objects.equals(changeSetName(), other.changeSetName()) && Objects.equals(clientToken(), other.clientToken())
                && Objects.equals(description(), other.description())
                && Objects.equals(changeSetTypeAsString(), other.changeSetTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CreateChangeSetRequest").add("StackName", stackName()).add("TemplateBody", templateBody())
                .add("TemplateURL", templateURL()).add("UsePreviousTemplate", usePreviousTemplate())
                .add("Parameters", parameters()).add("Capabilities", capabilitiesAsStrings())
                .add("ResourceTypes", resourceTypes()).add("RoleARN", roleARN())
                .add("RollbackConfiguration", rollbackConfiguration()).add("NotificationARNs", notificationARNs())
                .add("Tags", tags()).add("ChangeSetName", changeSetName()).add("ClientToken", clientToken())
                .add("Description", description()).add("ChangeSetType", changeSetTypeAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StackName":
            return Optional.ofNullable(clazz.cast(stackName()));
        case "TemplateBody":
            return Optional.ofNullable(clazz.cast(templateBody()));
        case "TemplateURL":
            return Optional.ofNullable(clazz.cast(templateURL()));
        case "UsePreviousTemplate":
            return Optional.ofNullable(clazz.cast(usePreviousTemplate()));
        case "Parameters":
            return Optional.ofNullable(clazz.cast(parameters()));
        case "Capabilities":
            return Optional.ofNullable(clazz.cast(capabilitiesAsStrings()));
        case "ResourceTypes":
            return Optional.ofNullable(clazz.cast(resourceTypes()));
        case "RoleARN":
            return Optional.ofNullable(clazz.cast(roleARN()));
        case "RollbackConfiguration":
            return Optional.ofNullable(clazz.cast(rollbackConfiguration()));
        case "NotificationARNs":
            return Optional.ofNullable(clazz.cast(notificationARNs()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "ChangeSetName":
            return Optional.ofNullable(clazz.cast(changeSetName()));
        case "ClientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "ChangeSetType":
            return Optional.ofNullable(clazz.cast(changeSetTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateChangeSetRequest, T> g) {
        return obj -> g.apply((CreateChangeSetRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudFormationRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateChangeSetRequest> {
        /**
         * <p>
         * The name or the unique ID of the stack for which you are creating a change set. AWS CloudFormation generates
         * the change set by comparing this stack's information with the information that you submit, such as a modified
         * template or different parameter input values.
         * </p>
         * 
         * @param stackName
         *        The name or the unique ID of the stack for which you are creating a change set. AWS CloudFormation
         *        generates the change set by comparing this stack's information with the information that you submit,
         *        such as a modified template or different parameter input values.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stackName(String stackName);

        /**
         * <p>
         * A structure that contains the body of the revised template, with a minimum length of 1 byte and a maximum
         * length of 51,200 bytes. AWS CloudFormation generates the change set by comparing this template with the
         * template of the stack that you specified.
         * </p>
         * <p>
         * Conditional: You must specify only <code>TemplateBody</code> or <code>TemplateURL</code>.
         * </p>
         * 
         * @param templateBody
         *        A structure that contains the body of the revised template, with a minimum length of 1 byte and a
         *        maximum length of 51,200 bytes. AWS CloudFormation generates the change set by comparing this template
         *        with the template of the stack that you specified.</p>
         *        <p>
         *        Conditional: You must specify only <code>TemplateBody</code> or <code>TemplateURL</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder templateBody(String templateBody);

        /**
         * <p>
         * The location of the file that contains the revised template. The URL must point to a template (max size:
         * 460,800 bytes) that is located in an S3 bucket. AWS CloudFormation generates the change set by comparing this
         * template with the stack that you specified.
         * </p>
         * <p>
         * Conditional: You must specify only <code>TemplateBody</code> or <code>TemplateURL</code>.
         * </p>
         * 
         * @param templateURL
         *        The location of the file that contains the revised template. The URL must point to a template (max
         *        size: 460,800 bytes) that is located in an S3 bucket. AWS CloudFormation generates the change set by
         *        comparing this template with the stack that you specified.</p>
         *        <p>
         *        Conditional: You must specify only <code>TemplateBody</code> or <code>TemplateURL</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder templateURL(String templateURL);

        /**
         * <p>
         * Whether to reuse the template that is associated with the stack to create the change set.
         * </p>
         * 
         * @param usePreviousTemplate
         *        Whether to reuse the template that is associated with the stack to create the change set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder usePreviousTemplate(Boolean usePreviousTemplate);

        /**
         * <p>
         * A list of <code>Parameter</code> structures that specify input parameters for the change set. For more
         * information, see the <a>Parameter</a> data type.
         * </p>
         * 
         * @param parameters
         *        A list of <code>Parameter</code> structures that specify input parameters for the change set. For more
         *        information, see the <a>Parameter</a> data type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameters(Collection<Parameter> parameters);

        /**
         * <p>
         * A list of <code>Parameter</code> structures that specify input parameters for the change set. For more
         * information, see the <a>Parameter</a> data type.
         * </p>
         * 
         * @param parameters
         *        A list of <code>Parameter</code> structures that specify input parameters for the change set. For more
         *        information, see the <a>Parameter</a> data type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameters(Parameter... parameters);

        /**
         * <p>
         * A list of <code>Parameter</code> structures that specify input parameters for the change set. For more
         * information, see the <a>Parameter</a> data type.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Parameter>.Builder} avoiding the need to
         * create one manually via {@link List<Parameter>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Parameter>.Builder#build()} is called immediately and its
         * result is passed to {@link #parameters(List<Parameter>)}.
         * 
         * @param parameters
         *        a consumer that will call methods on {@link List<Parameter>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #parameters(List<Parameter>)
         */
        Builder parameters(Consumer<Parameter.Builder>... parameters);

        /**
         * <p>
         * In some cases, you must explicity acknowledge that your stack template contains certain capabilities in order
         * for AWS CloudFormation to create the stack.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>CAPABILITY_IAM</code> and <code>CAPABILITY_NAMED_IAM</code>
         * </p>
         * <p>
         * Some stack templates might include resources that can affect permissions in your AWS account; for example, by
         * creating new AWS Identity and Access Management (IAM) users. For those stacks, you must explicitly
         * acknowledge this by specifying one of these capabilities.
         * </p>
         * <p>
         * The following IAM resources require you to specify either the <code>CAPABILITY_IAM</code> or
         * <code>CAPABILITY_NAMED_IAM</code> capability.
         * </p>
         * <ul>
         * <li>
         * <p>
         * If you have IAM resources, you can specify either capability.
         * </p>
         * </li>
         * <li>
         * <p>
         * If you have IAM resources with custom names, you <i>must</i> specify <code>CAPABILITY_NAMED_IAM</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * If you don't specify either of these capabilities, AWS CloudFormation returns an
         * <code>InsufficientCapabilities</code> error.
         * </p>
         * </li>
         * </ul>
         * <p>
         * If your stack template contains these resources, we recommend that you review all permissions associated with
         * them and edit their permissions if necessary.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-accesskey.html">
         * AWS::IAM::AccessKey</a>
         * </p>
         * </li>
         * <li>
         * <p>
         * <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-group.html">
         * AWS::IAM::Group</a>
         * </p>
         * </li>
         * <li>
         * <p>
         * <a
         * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-instanceprofile.html">
         * AWS::IAM::InstanceProfile</a>
         * </p>
         * </li>
         * <li>
         * <p>
         * <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-policy.html">
         * AWS::IAM::Policy</a>
         * </p>
         * </li>
         * <li>
         * <p>
         * <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-role.html">
         * AWS::IAM::Role</a>
         * </p>
         * </li>
         * <li>
         * <p>
         * <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-user.html">
         * AWS::IAM::User</a>
         * </p>
         * </li>
         * <li>
         * <p>
         * <a href=
         * "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-addusertogroup.html">
         * AWS::IAM::UserToGroupAddition</a>
         * </p>
         * </li>
         * </ul>
         * <p>
         * For more information, see <a
         * href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html#capabilities"
         * >Acknowledging IAM Resources in AWS CloudFormation Templates</a>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CAPABILITY_AUTO_EXPAND</code>
         * </p>
         * <p>
         * Some template contain macros. Macros perform custom processing on templates; this can include simple actions
         * like find-and-replace operations, all the way to extensive transformations of entire templates. Because of
         * this, users typically create a change set from the processed template, so that they can review the changes
         * resulting from the macros before actually creating the stack. If your stack template contains one or more
         * macros, and you choose to create a stack directly from the processed template, without first reviewing the
         * resulting changes in a change set, you must acknowledge this capability. This includes the <a href=
         * "http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/create-reusable-transform-function-snippets-and-add-to-your-template-with-aws-include-transform.html"
         * >AWS::Include</a> and <a
         * href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/transform-aws-serverless.html"
         * >AWS::Serverless</a> transforms, which are macros hosted by AWS CloudFormation.
         * </p>
         * <note>
         * <p>
         * This capacity does not apply to creating change sets, and specifying it when creating change sets has no
         * effect.
         * </p>
         * <p>
         * Also, change sets do not currently support nested stacks. If you want to create a stack from a stack template
         * that contains macros <i>and</i> nested stacks, you must create or update the stack directly from the template
         * using the <a>CreateStack</a> or <a>UpdateStack</a> action, and specifying this capability.
         * </p>
         * </note>
         * <p>
         * For more information on macros, see <a
         * href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-macros.html">Using AWS
         * CloudFormation Macros to Perform Custom Processing on Templates</a>.
         * </p>
         * </li>
         * </ul>
         * 
         * @param capabilities
         *        In some cases, you must explicity acknowledge that your stack template contains certain capabilities
         *        in order for AWS CloudFormation to create the stack.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>CAPABILITY_IAM</code> and <code>CAPABILITY_NAMED_IAM</code>
         *        </p>
         *        <p>
         *        Some stack templates might include resources that can affect permissions in your AWS account; for
         *        example, by creating new AWS Identity and Access Management (IAM) users. For those stacks, you must
         *        explicitly acknowledge this by specifying one of these capabilities.
         *        </p>
         *        <p>
         *        The following IAM resources require you to specify either the <code>CAPABILITY_IAM</code> or
         *        <code>CAPABILITY_NAMED_IAM</code> capability.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        If you have IAM resources, you can specify either capability.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If you have IAM resources with custom names, you <i>must</i> specify <code>CAPABILITY_NAMED_IAM</code>
         *        .
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If you don't specify either of these capabilities, AWS CloudFormation returns an
         *        <code>InsufficientCapabilities</code> error.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        If your stack template contains these resources, we recommend that you review all permissions
         *        associated with them and edit their permissions if necessary.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <a href=
         *        "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-accesskey.html">
         *        AWS::IAM::AccessKey</a>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <a
         *        href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-group.html">
         *        AWS::IAM::Group</a>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <a href=
         *        "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-instanceprofile.html"
         *        > AWS::IAM::InstanceProfile</a>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <a
         *        href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-policy.html">
         *        AWS::IAM::Policy</a>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-role.html">
         *        AWS::IAM::Role</a>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-user.html">
         *        AWS::IAM::User</a>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <a href=
         *        "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-addusertogroup.html"
         *        > AWS::IAM::UserToGroupAddition</a>
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        For more information, see <a href=
         *        "http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html#capabilities"
         *        >Acknowledging IAM Resources in AWS CloudFormation Templates</a>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CAPABILITY_AUTO_EXPAND</code>
         *        </p>
         *        <p>
         *        Some template contain macros. Macros perform custom processing on templates; this can include simple
         *        actions like find-and-replace operations, all the way to extensive transformations of entire
         *        templates. Because of this, users typically create a change set from the processed template, so that
         *        they can review the changes resulting from the macros before actually creating the stack. If your
         *        stack template contains one or more macros, and you choose to create a stack directly from the
         *        processed template, without first reviewing the resulting changes in a change set, you must
         *        acknowledge this capability. This includes the <a href=
         *        "http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/create-reusable-transform-function-snippets-and-add-to-your-template-with-aws-include-transform.html"
         *        >AWS::Include</a> and <a
         *        href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/transform-aws-serverless.html"
         *        >AWS::Serverless</a> transforms, which are macros hosted by AWS CloudFormation.
         *        </p>
         *        <note>
         *        <p>
         *        This capacity does not apply to creating change sets, and specifying it when creating change sets has
         *        no effect.
         *        </p>
         *        <p>
         *        Also, change sets do not currently support nested stacks. If you want to create a stack from a stack
         *        template that contains macros <i>and</i> nested stacks, you must create or update the stack directly
         *        from the template using the <a>CreateStack</a> or <a>UpdateStack</a> action, and specifying this
         *        capability.
         *        </p>
         *        </note>
         *        <p>
         *        For more information on macros, see <a
         *        href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-macros.html">Using AWS
         *        CloudFormation Macros to Perform Custom Processing on Templates</a>.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capabilitiesWithStrings(Collection<String> capabilities);

        /**
         * <p>
         * In some cases, you must explicity acknowledge that your stack template contains certain capabilities in order
         * for AWS CloudFormation to create the stack.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>CAPABILITY_IAM</code> and <code>CAPABILITY_NAMED_IAM</code>
         * </p>
         * <p>
         * Some stack templates might include resources that can affect permissions in your AWS account; for example, by
         * creating new AWS Identity and Access Management (IAM) users. For those stacks, you must explicitly
         * acknowledge this by specifying one of these capabilities.
         * </p>
         * <p>
         * The following IAM resources require you to specify either the <code>CAPABILITY_IAM</code> or
         * <code>CAPABILITY_NAMED_IAM</code> capability.
         * </p>
         * <ul>
         * <li>
         * <p>
         * If you have IAM resources, you can specify either capability.
         * </p>
         * </li>
         * <li>
         * <p>
         * If you have IAM resources with custom names, you <i>must</i> specify <code>CAPABILITY_NAMED_IAM</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * If you don't specify either of these capabilities, AWS CloudFormation returns an
         * <code>InsufficientCapabilities</code> error.
         * </p>
         * </li>
         * </ul>
         * <p>
         * If your stack template contains these resources, we recommend that you review all permissions associated with
         * them and edit their permissions if necessary.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-accesskey.html">
         * AWS::IAM::AccessKey</a>
         * </p>
         * </li>
         * <li>
         * <p>
         * <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-group.html">
         * AWS::IAM::Group</a>
         * </p>
         * </li>
         * <li>
         * <p>
         * <a
         * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-instanceprofile.html">
         * AWS::IAM::InstanceProfile</a>
         * </p>
         * </li>
         * <li>
         * <p>
         * <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-policy.html">
         * AWS::IAM::Policy</a>
         * </p>
         * </li>
         * <li>
         * <p>
         * <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-role.html">
         * AWS::IAM::Role</a>
         * </p>
         * </li>
         * <li>
         * <p>
         * <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-user.html">
         * AWS::IAM::User</a>
         * </p>
         * </li>
         * <li>
         * <p>
         * <a href=
         * "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-addusertogroup.html">
         * AWS::IAM::UserToGroupAddition</a>
         * </p>
         * </li>
         * </ul>
         * <p>
         * For more information, see <a
         * href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html#capabilities"
         * >Acknowledging IAM Resources in AWS CloudFormation Templates</a>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CAPABILITY_AUTO_EXPAND</code>
         * </p>
         * <p>
         * Some template contain macros. Macros perform custom processing on templates; this can include simple actions
         * like find-and-replace operations, all the way to extensive transformations of entire templates. Because of
         * this, users typically create a change set from the processed template, so that they can review the changes
         * resulting from the macros before actually creating the stack. If your stack template contains one or more
         * macros, and you choose to create a stack directly from the processed template, without first reviewing the
         * resulting changes in a change set, you must acknowledge this capability. This includes the <a href=
         * "http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/create-reusable-transform-function-snippets-and-add-to-your-template-with-aws-include-transform.html"
         * >AWS::Include</a> and <a
         * href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/transform-aws-serverless.html"
         * >AWS::Serverless</a> transforms, which are macros hosted by AWS CloudFormation.
         * </p>
         * <note>
         * <p>
         * This capacity does not apply to creating change sets, and specifying it when creating change sets has no
         * effect.
         * </p>
         * <p>
         * Also, change sets do not currently support nested stacks. If you want to create a stack from a stack template
         * that contains macros <i>and</i> nested stacks, you must create or update the stack directly from the template
         * using the <a>CreateStack</a> or <a>UpdateStack</a> action, and specifying this capability.
         * </p>
         * </note>
         * <p>
         * For more information on macros, see <a
         * href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-macros.html">Using AWS
         * CloudFormation Macros to Perform Custom Processing on Templates</a>.
         * </p>
         * </li>
         * </ul>
         * 
         * @param capabilities
         *        In some cases, you must explicity acknowledge that your stack template contains certain capabilities
         *        in order for AWS CloudFormation to create the stack.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>CAPABILITY_IAM</code> and <code>CAPABILITY_NAMED_IAM</code>
         *        </p>
         *        <p>
         *        Some stack templates might include resources that can affect permissions in your AWS account; for
         *        example, by creating new AWS Identity and Access Management (IAM) users. For those stacks, you must
         *        explicitly acknowledge this by specifying one of these capabilities.
         *        </p>
         *        <p>
         *        The following IAM resources require you to specify either the <code>CAPABILITY_IAM</code> or
         *        <code>CAPABILITY_NAMED_IAM</code> capability.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        If you have IAM resources, you can specify either capability.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If you have IAM resources with custom names, you <i>must</i> specify <code>CAPABILITY_NAMED_IAM</code>
         *        .
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If you don't specify either of these capabilities, AWS CloudFormation returns an
         *        <code>InsufficientCapabilities</code> error.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        If your stack template contains these resources, we recommend that you review all permissions
         *        associated with them and edit their permissions if necessary.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <a href=
         *        "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-accesskey.html">
         *        AWS::IAM::AccessKey</a>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <a
         *        href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-group.html">
         *        AWS::IAM::Group</a>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <a href=
         *        "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-instanceprofile.html"
         *        > AWS::IAM::InstanceProfile</a>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <a
         *        href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-policy.html">
         *        AWS::IAM::Policy</a>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-role.html">
         *        AWS::IAM::Role</a>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-user.html">
         *        AWS::IAM::User</a>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <a href=
         *        "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-addusertogroup.html"
         *        > AWS::IAM::UserToGroupAddition</a>
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        For more information, see <a href=
         *        "http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html#capabilities"
         *        >Acknowledging IAM Resources in AWS CloudFormation Templates</a>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CAPABILITY_AUTO_EXPAND</code>
         *        </p>
         *        <p>
         *        Some template contain macros. Macros perform custom processing on templates; this can include simple
         *        actions like find-and-replace operations, all the way to extensive transformations of entire
         *        templates. Because of this, users typically create a change set from the processed template, so that
         *        they can review the changes resulting from the macros before actually creating the stack. If your
         *        stack template contains one or more macros, and you choose to create a stack directly from the
         *        processed template, without first reviewing the resulting changes in a change set, you must
         *        acknowledge this capability. This includes the <a href=
         *        "http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/create-reusable-transform-function-snippets-and-add-to-your-template-with-aws-include-transform.html"
         *        >AWS::Include</a> and <a
         *        href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/transform-aws-serverless.html"
         *        >AWS::Serverless</a> transforms, which are macros hosted by AWS CloudFormation.
         *        </p>
         *        <note>
         *        <p>
         *        This capacity does not apply to creating change sets, and specifying it when creating change sets has
         *        no effect.
         *        </p>
         *        <p>
         *        Also, change sets do not currently support nested stacks. If you want to create a stack from a stack
         *        template that contains macros <i>and</i> nested stacks, you must create or update the stack directly
         *        from the template using the <a>CreateStack</a> or <a>UpdateStack</a> action, and specifying this
         *        capability.
         *        </p>
         *        </note>
         *        <p>
         *        For more information on macros, see <a
         *        href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-macros.html">Using AWS
         *        CloudFormation Macros to Perform Custom Processing on Templates</a>.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capabilitiesWithStrings(String... capabilities);

        /**
         * <p>
         * In some cases, you must explicity acknowledge that your stack template contains certain capabilities in order
         * for AWS CloudFormation to create the stack.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>CAPABILITY_IAM</code> and <code>CAPABILITY_NAMED_IAM</code>
         * </p>
         * <p>
         * Some stack templates might include resources that can affect permissions in your AWS account; for example, by
         * creating new AWS Identity and Access Management (IAM) users. For those stacks, you must explicitly
         * acknowledge this by specifying one of these capabilities.
         * </p>
         * <p>
         * The following IAM resources require you to specify either the <code>CAPABILITY_IAM</code> or
         * <code>CAPABILITY_NAMED_IAM</code> capability.
         * </p>
         * <ul>
         * <li>
         * <p>
         * If you have IAM resources, you can specify either capability.
         * </p>
         * </li>
         * <li>
         * <p>
         * If you have IAM resources with custom names, you <i>must</i> specify <code>CAPABILITY_NAMED_IAM</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * If you don't specify either of these capabilities, AWS CloudFormation returns an
         * <code>InsufficientCapabilities</code> error.
         * </p>
         * </li>
         * </ul>
         * <p>
         * If your stack template contains these resources, we recommend that you review all permissions associated with
         * them and edit their permissions if necessary.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-accesskey.html">
         * AWS::IAM::AccessKey</a>
         * </p>
         * </li>
         * <li>
         * <p>
         * <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-group.html">
         * AWS::IAM::Group</a>
         * </p>
         * </li>
         * <li>
         * <p>
         * <a
         * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-instanceprofile.html">
         * AWS::IAM::InstanceProfile</a>
         * </p>
         * </li>
         * <li>
         * <p>
         * <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-policy.html">
         * AWS::IAM::Policy</a>
         * </p>
         * </li>
         * <li>
         * <p>
         * <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-role.html">
         * AWS::IAM::Role</a>
         * </p>
         * </li>
         * <li>
         * <p>
         * <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-user.html">
         * AWS::IAM::User</a>
         * </p>
         * </li>
         * <li>
         * <p>
         * <a href=
         * "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-addusertogroup.html">
         * AWS::IAM::UserToGroupAddition</a>
         * </p>
         * </li>
         * </ul>
         * <p>
         * For more information, see <a
         * href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html#capabilities"
         * >Acknowledging IAM Resources in AWS CloudFormation Templates</a>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CAPABILITY_AUTO_EXPAND</code>
         * </p>
         * <p>
         * Some template contain macros. Macros perform custom processing on templates; this can include simple actions
         * like find-and-replace operations, all the way to extensive transformations of entire templates. Because of
         * this, users typically create a change set from the processed template, so that they can review the changes
         * resulting from the macros before actually creating the stack. If your stack template contains one or more
         * macros, and you choose to create a stack directly from the processed template, without first reviewing the
         * resulting changes in a change set, you must acknowledge this capability. This includes the <a href=
         * "http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/create-reusable-transform-function-snippets-and-add-to-your-template-with-aws-include-transform.html"
         * >AWS::Include</a> and <a
         * href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/transform-aws-serverless.html"
         * >AWS::Serverless</a> transforms, which are macros hosted by AWS CloudFormation.
         * </p>
         * <note>
         * <p>
         * This capacity does not apply to creating change sets, and specifying it when creating change sets has no
         * effect.
         * </p>
         * <p>
         * Also, change sets do not currently support nested stacks. If you want to create a stack from a stack template
         * that contains macros <i>and</i> nested stacks, you must create or update the stack directly from the template
         * using the <a>CreateStack</a> or <a>UpdateStack</a> action, and specifying this capability.
         * </p>
         * </note>
         * <p>
         * For more information on macros, see <a
         * href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-macros.html">Using AWS
         * CloudFormation Macros to Perform Custom Processing on Templates</a>.
         * </p>
         * </li>
         * </ul>
         * 
         * @param capabilities
         *        In some cases, you must explicity acknowledge that your stack template contains certain capabilities
         *        in order for AWS CloudFormation to create the stack.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>CAPABILITY_IAM</code> and <code>CAPABILITY_NAMED_IAM</code>
         *        </p>
         *        <p>
         *        Some stack templates might include resources that can affect permissions in your AWS account; for
         *        example, by creating new AWS Identity and Access Management (IAM) users. For those stacks, you must
         *        explicitly acknowledge this by specifying one of these capabilities.
         *        </p>
         *        <p>
         *        The following IAM resources require you to specify either the <code>CAPABILITY_IAM</code> or
         *        <code>CAPABILITY_NAMED_IAM</code> capability.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        If you have IAM resources, you can specify either capability.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If you have IAM resources with custom names, you <i>must</i> specify <code>CAPABILITY_NAMED_IAM</code>
         *        .
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If you don't specify either of these capabilities, AWS CloudFormation returns an
         *        <code>InsufficientCapabilities</code> error.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        If your stack template contains these resources, we recommend that you review all permissions
         *        associated with them and edit their permissions if necessary.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <a href=
         *        "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-accesskey.html">
         *        AWS::IAM::AccessKey</a>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <a
         *        href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-group.html">
         *        AWS::IAM::Group</a>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <a href=
         *        "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-instanceprofile.html"
         *        > AWS::IAM::InstanceProfile</a>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <a
         *        href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-policy.html">
         *        AWS::IAM::Policy</a>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-role.html">
         *        AWS::IAM::Role</a>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-user.html">
         *        AWS::IAM::User</a>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <a href=
         *        "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-addusertogroup.html"
         *        > AWS::IAM::UserToGroupAddition</a>
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        For more information, see <a href=
         *        "http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html#capabilities"
         *        >Acknowledging IAM Resources in AWS CloudFormation Templates</a>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CAPABILITY_AUTO_EXPAND</code>
         *        </p>
         *        <p>
         *        Some template contain macros. Macros perform custom processing on templates; this can include simple
         *        actions like find-and-replace operations, all the way to extensive transformations of entire
         *        templates. Because of this, users typically create a change set from the processed template, so that
         *        they can review the changes resulting from the macros before actually creating the stack. If your
         *        stack template contains one or more macros, and you choose to create a stack directly from the
         *        processed template, without first reviewing the resulting changes in a change set, you must
         *        acknowledge this capability. This includes the <a href=
         *        "http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/create-reusable-transform-function-snippets-and-add-to-your-template-with-aws-include-transform.html"
         *        >AWS::Include</a> and <a
         *        href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/transform-aws-serverless.html"
         *        >AWS::Serverless</a> transforms, which are macros hosted by AWS CloudFormation.
         *        </p>
         *        <note>
         *        <p>
         *        This capacity does not apply to creating change sets, and specifying it when creating change sets has
         *        no effect.
         *        </p>
         *        <p>
         *        Also, change sets do not currently support nested stacks. If you want to create a stack from a stack
         *        template that contains macros <i>and</i> nested stacks, you must create or update the stack directly
         *        from the template using the <a>CreateStack</a> or <a>UpdateStack</a> action, and specifying this
         *        capability.
         *        </p>
         *        </note>
         *        <p>
         *        For more information on macros, see <a
         *        href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-macros.html">Using AWS
         *        CloudFormation Macros to Perform Custom Processing on Templates</a>.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capabilities(Collection<Capability> capabilities);

        /**
         * <p>
         * In some cases, you must explicity acknowledge that your stack template contains certain capabilities in order
         * for AWS CloudFormation to create the stack.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>CAPABILITY_IAM</code> and <code>CAPABILITY_NAMED_IAM</code>
         * </p>
         * <p>
         * Some stack templates might include resources that can affect permissions in your AWS account; for example, by
         * creating new AWS Identity and Access Management (IAM) users. For those stacks, you must explicitly
         * acknowledge this by specifying one of these capabilities.
         * </p>
         * <p>
         * The following IAM resources require you to specify either the <code>CAPABILITY_IAM</code> or
         * <code>CAPABILITY_NAMED_IAM</code> capability.
         * </p>
         * <ul>
         * <li>
         * <p>
         * If you have IAM resources, you can specify either capability.
         * </p>
         * </li>
         * <li>
         * <p>
         * If you have IAM resources with custom names, you <i>must</i> specify <code>CAPABILITY_NAMED_IAM</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * If you don't specify either of these capabilities, AWS CloudFormation returns an
         * <code>InsufficientCapabilities</code> error.
         * </p>
         * </li>
         * </ul>
         * <p>
         * If your stack template contains these resources, we recommend that you review all permissions associated with
         * them and edit their permissions if necessary.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-accesskey.html">
         * AWS::IAM::AccessKey</a>
         * </p>
         * </li>
         * <li>
         * <p>
         * <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-group.html">
         * AWS::IAM::Group</a>
         * </p>
         * </li>
         * <li>
         * <p>
         * <a
         * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-instanceprofile.html">
         * AWS::IAM::InstanceProfile</a>
         * </p>
         * </li>
         * <li>
         * <p>
         * <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-policy.html">
         * AWS::IAM::Policy</a>
         * </p>
         * </li>
         * <li>
         * <p>
         * <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-role.html">
         * AWS::IAM::Role</a>
         * </p>
         * </li>
         * <li>
         * <p>
         * <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-user.html">
         * AWS::IAM::User</a>
         * </p>
         * </li>
         * <li>
         * <p>
         * <a href=
         * "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-addusertogroup.html">
         * AWS::IAM::UserToGroupAddition</a>
         * </p>
         * </li>
         * </ul>
         * <p>
         * For more information, see <a
         * href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html#capabilities"
         * >Acknowledging IAM Resources in AWS CloudFormation Templates</a>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CAPABILITY_AUTO_EXPAND</code>
         * </p>
         * <p>
         * Some template contain macros. Macros perform custom processing on templates; this can include simple actions
         * like find-and-replace operations, all the way to extensive transformations of entire templates. Because of
         * this, users typically create a change set from the processed template, so that they can review the changes
         * resulting from the macros before actually creating the stack. If your stack template contains one or more
         * macros, and you choose to create a stack directly from the processed template, without first reviewing the
         * resulting changes in a change set, you must acknowledge this capability. This includes the <a href=
         * "http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/create-reusable-transform-function-snippets-and-add-to-your-template-with-aws-include-transform.html"
         * >AWS::Include</a> and <a
         * href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/transform-aws-serverless.html"
         * >AWS::Serverless</a> transforms, which are macros hosted by AWS CloudFormation.
         * </p>
         * <note>
         * <p>
         * This capacity does not apply to creating change sets, and specifying it when creating change sets has no
         * effect.
         * </p>
         * <p>
         * Also, change sets do not currently support nested stacks. If you want to create a stack from a stack template
         * that contains macros <i>and</i> nested stacks, you must create or update the stack directly from the template
         * using the <a>CreateStack</a> or <a>UpdateStack</a> action, and specifying this capability.
         * </p>
         * </note>
         * <p>
         * For more information on macros, see <a
         * href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-macros.html">Using AWS
         * CloudFormation Macros to Perform Custom Processing on Templates</a>.
         * </p>
         * </li>
         * </ul>
         * 
         * @param capabilities
         *        In some cases, you must explicity acknowledge that your stack template contains certain capabilities
         *        in order for AWS CloudFormation to create the stack.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>CAPABILITY_IAM</code> and <code>CAPABILITY_NAMED_IAM</code>
         *        </p>
         *        <p>
         *        Some stack templates might include resources that can affect permissions in your AWS account; for
         *        example, by creating new AWS Identity and Access Management (IAM) users. For those stacks, you must
         *        explicitly acknowledge this by specifying one of these capabilities.
         *        </p>
         *        <p>
         *        The following IAM resources require you to specify either the <code>CAPABILITY_IAM</code> or
         *        <code>CAPABILITY_NAMED_IAM</code> capability.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        If you have IAM resources, you can specify either capability.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If you have IAM resources with custom names, you <i>must</i> specify <code>CAPABILITY_NAMED_IAM</code>
         *        .
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If you don't specify either of these capabilities, AWS CloudFormation returns an
         *        <code>InsufficientCapabilities</code> error.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        If your stack template contains these resources, we recommend that you review all permissions
         *        associated with them and edit their permissions if necessary.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <a href=
         *        "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-accesskey.html">
         *        AWS::IAM::AccessKey</a>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <a
         *        href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-group.html">
         *        AWS::IAM::Group</a>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <a href=
         *        "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-instanceprofile.html"
         *        > AWS::IAM::InstanceProfile</a>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <a
         *        href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-policy.html">
         *        AWS::IAM::Policy</a>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-role.html">
         *        AWS::IAM::Role</a>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-user.html">
         *        AWS::IAM::User</a>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <a href=
         *        "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-addusertogroup.html"
         *        > AWS::IAM::UserToGroupAddition</a>
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        For more information, see <a href=
         *        "http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html#capabilities"
         *        >Acknowledging IAM Resources in AWS CloudFormation Templates</a>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CAPABILITY_AUTO_EXPAND</code>
         *        </p>
         *        <p>
         *        Some template contain macros. Macros perform custom processing on templates; this can include simple
         *        actions like find-and-replace operations, all the way to extensive transformations of entire
         *        templates. Because of this, users typically create a change set from the processed template, so that
         *        they can review the changes resulting from the macros before actually creating the stack. If your
         *        stack template contains one or more macros, and you choose to create a stack directly from the
         *        processed template, without first reviewing the resulting changes in a change set, you must
         *        acknowledge this capability. This includes the <a href=
         *        "http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/create-reusable-transform-function-snippets-and-add-to-your-template-with-aws-include-transform.html"
         *        >AWS::Include</a> and <a
         *        href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/transform-aws-serverless.html"
         *        >AWS::Serverless</a> transforms, which are macros hosted by AWS CloudFormation.
         *        </p>
         *        <note>
         *        <p>
         *        This capacity does not apply to creating change sets, and specifying it when creating change sets has
         *        no effect.
         *        </p>
         *        <p>
         *        Also, change sets do not currently support nested stacks. If you want to create a stack from a stack
         *        template that contains macros <i>and</i> nested stacks, you must create or update the stack directly
         *        from the template using the <a>CreateStack</a> or <a>UpdateStack</a> action, and specifying this
         *        capability.
         *        </p>
         *        </note>
         *        <p>
         *        For more information on macros, see <a
         *        href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-macros.html">Using AWS
         *        CloudFormation Macros to Perform Custom Processing on Templates</a>.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capabilities(Capability... capabilities);

        /**
         * <p>
         * The template resource types that you have permissions to work with if you execute this change set, such as
         * <code>AWS::EC2::Instance</code>, <code>AWS::EC2::*</code>, or <code>Custom::MyCustomInstance</code>.
         * </p>
         * <p>
         * If the list of resource types doesn't include a resource type that you're updating, the stack update fails.
         * By default, AWS CloudFormation grants permissions to all resource types. AWS Identity and Access Management
         * (IAM) uses this parameter for condition keys in IAM policies for AWS CloudFormation. For more information,
         * see <a
         * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html">Controlling
         * Access with AWS Identity and Access Management</a> in the AWS CloudFormation User Guide.
         * </p>
         * 
         * @param resourceTypes
         *        The template resource types that you have permissions to work with if you execute this change set,
         *        such as <code>AWS::EC2::Instance</code>, <code>AWS::EC2::*</code>, or
         *        <code>Custom::MyCustomInstance</code>.</p>
         *        <p>
         *        If the list of resource types doesn't include a resource type that you're updating, the stack update
         *        fails. By default, AWS CloudFormation grants permissions to all resource types. AWS Identity and
         *        Access Management (IAM) uses this parameter for condition keys in IAM policies for AWS CloudFormation.
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html"
         *        >Controlling Access with AWS Identity and Access Management</a> in the AWS CloudFormation User Guide.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceTypes(Collection<String> resourceTypes);

        /**
         * <p>
         * The template resource types that you have permissions to work with if you execute this change set, such as
         * <code>AWS::EC2::Instance</code>, <code>AWS::EC2::*</code>, or <code>Custom::MyCustomInstance</code>.
         * </p>
         * <p>
         * If the list of resource types doesn't include a resource type that you're updating, the stack update fails.
         * By default, AWS CloudFormation grants permissions to all resource types. AWS Identity and Access Management
         * (IAM) uses this parameter for condition keys in IAM policies for AWS CloudFormation. For more information,
         * see <a
         * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html">Controlling
         * Access with AWS Identity and Access Management</a> in the AWS CloudFormation User Guide.
         * </p>
         * 
         * @param resourceTypes
         *        The template resource types that you have permissions to work with if you execute this change set,
         *        such as <code>AWS::EC2::Instance</code>, <code>AWS::EC2::*</code>, or
         *        <code>Custom::MyCustomInstance</code>.</p>
         *        <p>
         *        If the list of resource types doesn't include a resource type that you're updating, the stack update
         *        fails. By default, AWS CloudFormation grants permissions to all resource types. AWS Identity and
         *        Access Management (IAM) uses this parameter for condition keys in IAM policies for AWS CloudFormation.
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html"
         *        >Controlling Access with AWS Identity and Access Management</a> in the AWS CloudFormation User Guide.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceTypes(String... resourceTypes);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of an AWS Identity and Access Management (IAM) role that AWS CloudFormation
         * assumes when executing the change set. AWS CloudFormation uses the role's credentials to make calls on your
         * behalf. AWS CloudFormation uses this role for all future operations on the stack. As long as users have
         * permission to operate on the stack, AWS CloudFormation uses this role even if the users don't have permission
         * to pass it. Ensure that the role grants least privilege.
         * </p>
         * <p>
         * If you don't specify a value, AWS CloudFormation uses the role that was previously associated with the stack.
         * If no role is available, AWS CloudFormation uses a temporary session that is generated from your user
         * credentials.
         * </p>
         * 
         * @param roleARN
         *        The Amazon Resource Name (ARN) of an AWS Identity and Access Management (IAM) role that AWS
         *        CloudFormation assumes when executing the change set. AWS CloudFormation uses the role's credentials
         *        to make calls on your behalf. AWS CloudFormation uses this role for all future operations on the
         *        stack. As long as users have permission to operate on the stack, AWS CloudFormation uses this role
         *        even if the users don't have permission to pass it. Ensure that the role grants least privilege.</p>
         *        <p>
         *        If you don't specify a value, AWS CloudFormation uses the role that was previously associated with the
         *        stack. If no role is available, AWS CloudFormation uses a temporary session that is generated from
         *        your user credentials.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleARN(String roleARN);

        /**
         * <p>
         * The rollback triggers for AWS CloudFormation to monitor during stack creation and updating operations, and
         * for the specified monitoring period afterwards.
         * </p>
         * 
         * @param rollbackConfiguration
         *        The rollback triggers for AWS CloudFormation to monitor during stack creation and updating operations,
         *        and for the specified monitoring period afterwards.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rollbackConfiguration(RollbackConfiguration rollbackConfiguration);

        /**
         * <p>
         * The rollback triggers for AWS CloudFormation to monitor during stack creation and updating operations, and
         * for the specified monitoring period afterwards.
         * </p>
         * This is a convenience that creates an instance of the {@link RollbackConfiguration.Builder} avoiding the need
         * to create one manually via {@link RollbackConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link RollbackConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #rollbackConfiguration(RollbackConfiguration)}.
         * 
         * @param rollbackConfiguration
         *        a consumer that will call methods on {@link RollbackConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #rollbackConfiguration(RollbackConfiguration)
         */
        default Builder rollbackConfiguration(Consumer<RollbackConfiguration.Builder> rollbackConfiguration) {
            return rollbackConfiguration(RollbackConfiguration.builder().applyMutation(rollbackConfiguration).build());
        }

        /**
         * <p>
         * The Amazon Resource Names (ARNs) of Amazon Simple Notification Service (Amazon SNS) topics that AWS
         * CloudFormation associates with the stack. To remove all associated notification topics, specify an empty
         * list.
         * </p>
         * 
         * @param notificationARNs
         *        The Amazon Resource Names (ARNs) of Amazon Simple Notification Service (Amazon SNS) topics that AWS
         *        CloudFormation associates with the stack. To remove all associated notification topics, specify an
         *        empty list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notificationARNs(Collection<String> notificationARNs);

        /**
         * <p>
         * The Amazon Resource Names (ARNs) of Amazon Simple Notification Service (Amazon SNS) topics that AWS
         * CloudFormation associates with the stack. To remove all associated notification topics, specify an empty
         * list.
         * </p>
         * 
         * @param notificationARNs
         *        The Amazon Resource Names (ARNs) of Amazon Simple Notification Service (Amazon SNS) topics that AWS
         *        CloudFormation associates with the stack. To remove all associated notification topics, specify an
         *        empty list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notificationARNs(String... notificationARNs);

        /**
         * <p>
         * Key-value pairs to associate with this stack. AWS CloudFormation also propagates these tags to resources in
         * the stack. You can specify a maximum of 50 tags.
         * </p>
         * 
         * @param tags
         *        Key-value pairs to associate with this stack. AWS CloudFormation also propagates these tags to
         *        resources in the stack. You can specify a maximum of 50 tags.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * Key-value pairs to associate with this stack. AWS CloudFormation also propagates these tags to resources in
         * the stack. You can specify a maximum of 50 tags.
         * </p>
         * 
         * @param tags
         *        Key-value pairs to associate with this stack. AWS CloudFormation also propagates these tags to
         *        resources in the stack. You can specify a maximum of 50 tags.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * Key-value pairs to associate with this stack. AWS CloudFormation also propagates these tags to resources in
         * the stack. You can specify a maximum of 50 tags.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Tag>.Builder} avoiding the need to create
         * one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        /**
         * <p>
         * The name of the change set. The name must be unique among all change sets that are associated with the
         * specified stack.
         * </p>
         * <p>
         * A change set name can contain only alphanumeric, case sensitive characters and hyphens. It must start with an
         * alphabetic character and cannot exceed 128 characters.
         * </p>
         * 
         * @param changeSetName
         *        The name of the change set. The name must be unique among all change sets that are associated with the
         *        specified stack.</p>
         *        <p>
         *        A change set name can contain only alphanumeric, case sensitive characters and hyphens. It must start
         *        with an alphabetic character and cannot exceed 128 characters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder changeSetName(String changeSetName);

        /**
         * <p>
         * A unique identifier for this <code>CreateChangeSet</code> request. Specify this token if you plan to retry
         * requests so that AWS CloudFormation knows that you're not attempting to create another change set with the
         * same name. You might retry <code>CreateChangeSet</code> requests to ensure that AWS CloudFormation
         * successfully received them.
         * </p>
         * 
         * @param clientToken
         *        A unique identifier for this <code>CreateChangeSet</code> request. Specify this token if you plan to
         *        retry requests so that AWS CloudFormation knows that you're not attempting to create another change
         *        set with the same name. You might retry <code>CreateChangeSet</code> requests to ensure that AWS
         *        CloudFormation successfully received them.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * A description to help you identify this change set.
         * </p>
         * 
         * @param description
         *        A description to help you identify this change set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The type of change set operation. To create a change set for a new stack, specify <code>CREATE</code>. To
         * create a change set for an existing stack, specify <code>UPDATE</code>.
         * </p>
         * <p>
         * If you create a change set for a new stack, AWS Cloudformation creates a stack with a unique stack ID, but no
         * template or resources. The stack will be in the <a href=
         * "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-describing-stacks.html#d0e11995">
         * <code>REVIEW_IN_PROGRESS</code> </a> state until you execute the change set.
         * </p>
         * <p>
         * By default, AWS CloudFormation specifies <code>UPDATE</code>. You can't use the <code>UPDATE</code> type to
         * create a change set for a new stack or the <code>CREATE</code> type to create a change set for an existing
         * stack.
         * </p>
         * 
         * @param changeSetType
         *        The type of change set operation. To create a change set for a new stack, specify <code>CREATE</code>.
         *        To create a change set for an existing stack, specify <code>UPDATE</code>.</p>
         *        <p>
         *        If you create a change set for a new stack, AWS Cloudformation creates a stack with a unique stack ID,
         *        but no template or resources. The stack will be in the <a href=
         *        "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-describing-stacks.html#d0e11995"
         *        > <code>REVIEW_IN_PROGRESS</code> </a> state until you execute the change set.
         *        </p>
         *        <p>
         *        By default, AWS CloudFormation specifies <code>UPDATE</code>. You can't use the <code>UPDATE</code>
         *        type to create a change set for a new stack or the <code>CREATE</code> type to create a change set for
         *        an existing stack.
         * @see ChangeSetType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ChangeSetType
         */
        Builder changeSetType(String changeSetType);

        /**
         * <p>
         * The type of change set operation. To create a change set for a new stack, specify <code>CREATE</code>. To
         * create a change set for an existing stack, specify <code>UPDATE</code>.
         * </p>
         * <p>
         * If you create a change set for a new stack, AWS Cloudformation creates a stack with a unique stack ID, but no
         * template or resources. The stack will be in the <a href=
         * "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-describing-stacks.html#d0e11995">
         * <code>REVIEW_IN_PROGRESS</code> </a> state until you execute the change set.
         * </p>
         * <p>
         * By default, AWS CloudFormation specifies <code>UPDATE</code>. You can't use the <code>UPDATE</code> type to
         * create a change set for a new stack or the <code>CREATE</code> type to create a change set for an existing
         * stack.
         * </p>
         * 
         * @param changeSetType
         *        The type of change set operation. To create a change set for a new stack, specify <code>CREATE</code>.
         *        To create a change set for an existing stack, specify <code>UPDATE</code>.</p>
         *        <p>
         *        If you create a change set for a new stack, AWS Cloudformation creates a stack with a unique stack ID,
         *        but no template or resources. The stack will be in the <a href=
         *        "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-describing-stacks.html#d0e11995"
         *        > <code>REVIEW_IN_PROGRESS</code> </a> state until you execute the change set.
         *        </p>
         *        <p>
         *        By default, AWS CloudFormation specifies <code>UPDATE</code>. You can't use the <code>UPDATE</code>
         *        type to create a change set for a new stack or the <code>CREATE</code> type to create a change set for
         *        an existing stack.
         * @see ChangeSetType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ChangeSetType
         */
        Builder changeSetType(ChangeSetType changeSetType);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CloudFormationRequest.BuilderImpl implements Builder {
        private String stackName;

        private String templateBody;

        private String templateURL;

        private Boolean usePreviousTemplate;

        private List<Parameter> parameters = DefaultSdkAutoConstructList.getInstance();

        private List<String> capabilities = DefaultSdkAutoConstructList.getInstance();

        private List<String> resourceTypes = DefaultSdkAutoConstructList.getInstance();

        private String roleARN;

        private RollbackConfiguration rollbackConfiguration;

        private List<String> notificationARNs = DefaultSdkAutoConstructList.getInstance();

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private String changeSetName;

        private String clientToken;

        private String description;

        private String changeSetType;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateChangeSetRequest model) {
            super(model);
            stackName(model.stackName);
            templateBody(model.templateBody);
            templateURL(model.templateURL);
            usePreviousTemplate(model.usePreviousTemplate);
            parameters(model.parameters);
            capabilitiesWithStrings(model.capabilities);
            resourceTypes(model.resourceTypes);
            roleARN(model.roleARN);
            rollbackConfiguration(model.rollbackConfiguration);
            notificationARNs(model.notificationARNs);
            tags(model.tags);
            changeSetName(model.changeSetName);
            clientToken(model.clientToken);
            description(model.description);
            changeSetType(model.changeSetType);
        }

        public final String getStackName() {
            return stackName;
        }

        @Override
        public final Builder stackName(String stackName) {
            this.stackName = stackName;
            return this;
        }

        public final void setStackName(String stackName) {
            this.stackName = stackName;
        }

        public final String getTemplateBody() {
            return templateBody;
        }

        @Override
        public final Builder templateBody(String templateBody) {
            this.templateBody = templateBody;
            return this;
        }

        public final void setTemplateBody(String templateBody) {
            this.templateBody = templateBody;
        }

        public final String getTemplateURL() {
            return templateURL;
        }

        @Override
        public final Builder templateURL(String templateURL) {
            this.templateURL = templateURL;
            return this;
        }

        public final void setTemplateURL(String templateURL) {
            this.templateURL = templateURL;
        }

        public final Boolean getUsePreviousTemplate() {
            return usePreviousTemplate;
        }

        @Override
        public final Builder usePreviousTemplate(Boolean usePreviousTemplate) {
            this.usePreviousTemplate = usePreviousTemplate;
            return this;
        }

        public final void setUsePreviousTemplate(Boolean usePreviousTemplate) {
            this.usePreviousTemplate = usePreviousTemplate;
        }

        public final Collection<Parameter.Builder> getParameters() {
            return parameters != null ? parameters.stream().map(Parameter::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder parameters(Collection<Parameter> parameters) {
            this.parameters = ParametersCopier.copy(parameters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameters(Parameter... parameters) {
            parameters(Arrays.asList(parameters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameters(Consumer<Parameter.Builder>... parameters) {
            parameters(Stream.of(parameters).map(c -> Parameter.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setParameters(Collection<Parameter.BuilderImpl> parameters) {
            this.parameters = ParametersCopier.copyFromBuilder(parameters);
        }

        public final Collection<String> getCapabilitiesAsStrings() {
            return capabilities;
        }

        @Override
        public final Builder capabilitiesWithStrings(Collection<String> capabilities) {
            this.capabilities = CapabilitiesCopier.copy(capabilities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder capabilitiesWithStrings(String... capabilities) {
            capabilitiesWithStrings(Arrays.asList(capabilities));
            return this;
        }

        @Override
        public final Builder capabilities(Collection<Capability> capabilities) {
            this.capabilities = CapabilitiesCopier.copyEnumToString(capabilities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder capabilities(Capability... capabilities) {
            capabilities(Arrays.asList(capabilities));
            return this;
        }

        public final void setCapabilitiesWithStrings(Collection<String> capabilities) {
            this.capabilities = CapabilitiesCopier.copy(capabilities);
        }

        public final Collection<String> getResourceTypes() {
            return resourceTypes;
        }

        @Override
        public final Builder resourceTypes(Collection<String> resourceTypes) {
            this.resourceTypes = ResourceTypesCopier.copy(resourceTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceTypes(String... resourceTypes) {
            resourceTypes(Arrays.asList(resourceTypes));
            return this;
        }

        public final void setResourceTypes(Collection<String> resourceTypes) {
            this.resourceTypes = ResourceTypesCopier.copy(resourceTypes);
        }

        public final String getRoleARN() {
            return roleARN;
        }

        @Override
        public final Builder roleARN(String roleARN) {
            this.roleARN = roleARN;
            return this;
        }

        public final void setRoleARN(String roleARN) {
            this.roleARN = roleARN;
        }

        public final RollbackConfiguration.Builder getRollbackConfiguration() {
            return rollbackConfiguration != null ? rollbackConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder rollbackConfiguration(RollbackConfiguration rollbackConfiguration) {
            this.rollbackConfiguration = rollbackConfiguration;
            return this;
        }

        public final void setRollbackConfiguration(RollbackConfiguration.BuilderImpl rollbackConfiguration) {
            this.rollbackConfiguration = rollbackConfiguration != null ? rollbackConfiguration.build() : null;
        }

        public final Collection<String> getNotificationARNs() {
            return notificationARNs;
        }

        @Override
        public final Builder notificationARNs(Collection<String> notificationARNs) {
            this.notificationARNs = NotificationARNsCopier.copy(notificationARNs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder notificationARNs(String... notificationARNs) {
            notificationARNs(Arrays.asList(notificationARNs));
            return this;
        }

        public final void setNotificationARNs(Collection<String> notificationARNs) {
            this.notificationARNs = NotificationARNsCopier.copy(notificationARNs);
        }

        public final Collection<Tag.Builder> getTags() {
            return tags != null ? tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagsCopier.copyFromBuilder(tags);
        }

        public final String getChangeSetName() {
            return changeSetName;
        }

        @Override
        public final Builder changeSetName(String changeSetName) {
            this.changeSetName = changeSetName;
            return this;
        }

        public final void setChangeSetName(String changeSetName) {
            this.changeSetName = changeSetName;
        }

        public final String getClientToken() {
            return clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getChangeSetTypeAsString() {
            return changeSetType;
        }

        @Override
        public final Builder changeSetType(String changeSetType) {
            this.changeSetType = changeSetType;
            return this;
        }

        @Override
        public final Builder changeSetType(ChangeSetType changeSetType) {
            this.changeSetType(changeSetType.toString());
            return this;
        }

        public final void setChangeSetType(String changeSetType) {
            this.changeSetType = changeSetType;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateChangeSetRequest build() {
            return new CreateChangeSetRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
