/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudformation.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The input for the <a>GetTemplateSummary</a> action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetTemplateSummaryRequest extends CloudFormationRequest implements
        ToCopyableBuilder<GetTemplateSummaryRequest.Builder, GetTemplateSummaryRequest> {
    private static final SdkField<String> TEMPLATE_BODY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetTemplateSummaryRequest::templateBody)).setter(setter(Builder::templateBody))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TemplateBody").build()).build();

    private static final SdkField<String> TEMPLATE_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetTemplateSummaryRequest::templateURL)).setter(setter(Builder::templateURL))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TemplateURL").build()).build();

    private static final SdkField<String> STACK_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetTemplateSummaryRequest::stackName)).setter(setter(Builder::stackName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StackName").build()).build();

    private static final SdkField<String> STACK_SET_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetTemplateSummaryRequest::stackSetName)).setter(setter(Builder::stackSetName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StackSetName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TEMPLATE_BODY_FIELD,
            TEMPLATE_URL_FIELD, STACK_NAME_FIELD, STACK_SET_NAME_FIELD));

    private final String templateBody;

    private final String templateURL;

    private final String stackName;

    private final String stackSetName;

    private GetTemplateSummaryRequest(BuilderImpl builder) {
        super(builder);
        this.templateBody = builder.templateBody;
        this.templateURL = builder.templateURL;
        this.stackName = builder.stackName;
        this.stackSetName = builder.stackSetName;
    }

    /**
     * <p>
     * Structure containing the template body with a minimum length of 1 byte and a maximum length of 51,200 bytes. For
     * more information about templates, see <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html">Template Anatomy</a>
     * in the AWS CloudFormation User Guide.
     * </p>
     * <p>
     * Conditional: You must specify only one of the following parameters: <code>StackName</code>,
     * <code>StackSetName</code>, <code>TemplateBody</code>, or <code>TemplateURL</code>.
     * </p>
     * 
     * @return Structure containing the template body with a minimum length of 1 byte and a maximum length of 51,200
     *         bytes. For more information about templates, see <a
     *         href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html">Template
     *         Anatomy</a> in the AWS CloudFormation User Guide.</p>
     *         <p>
     *         Conditional: You must specify only one of the following parameters: <code>StackName</code>,
     *         <code>StackSetName</code>, <code>TemplateBody</code>, or <code>TemplateURL</code>.
     */
    public String templateBody() {
        return templateBody;
    }

    /**
     * <p>
     * Location of file containing the template body. The URL must point to a template (max size: 460,800 bytes) that is
     * located in an Amazon S3 bucket. For more information about templates, see <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html">Template Anatomy</a>
     * in the AWS CloudFormation User Guide.
     * </p>
     * <p>
     * Conditional: You must specify only one of the following parameters: <code>StackName</code>,
     * <code>StackSetName</code>, <code>TemplateBody</code>, or <code>TemplateURL</code>.
     * </p>
     * 
     * @return Location of file containing the template body. The URL must point to a template (max size: 460,800 bytes)
     *         that is located in an Amazon S3 bucket. For more information about templates, see <a
     *         href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html">Template
     *         Anatomy</a> in the AWS CloudFormation User Guide.</p>
     *         <p>
     *         Conditional: You must specify only one of the following parameters: <code>StackName</code>,
     *         <code>StackSetName</code>, <code>TemplateBody</code>, or <code>TemplateURL</code>.
     */
    public String templateURL() {
        return templateURL;
    }

    /**
     * <p>
     * The name or the stack ID that is associated with the stack, which are not always interchangeable. For running
     * stacks, you can specify either the stack's name or its unique stack ID. For deleted stack, you must specify the
     * unique stack ID.
     * </p>
     * <p>
     * Conditional: You must specify only one of the following parameters: <code>StackName</code>,
     * <code>StackSetName</code>, <code>TemplateBody</code>, or <code>TemplateURL</code>.
     * </p>
     * 
     * @return The name or the stack ID that is associated with the stack, which are not always interchangeable. For
     *         running stacks, you can specify either the stack's name or its unique stack ID. For deleted stack, you
     *         must specify the unique stack ID.</p>
     *         <p>
     *         Conditional: You must specify only one of the following parameters: <code>StackName</code>,
     *         <code>StackSetName</code>, <code>TemplateBody</code>, or <code>TemplateURL</code>.
     */
    public String stackName() {
        return stackName;
    }

    /**
     * <p>
     * The name or unique ID of the stack set from which the stack was created.
     * </p>
     * <p>
     * Conditional: You must specify only one of the following parameters: <code>StackName</code>,
     * <code>StackSetName</code>, <code>TemplateBody</code>, or <code>TemplateURL</code>.
     * </p>
     * 
     * @return The name or unique ID of the stack set from which the stack was created.</p>
     *         <p>
     *         Conditional: You must specify only one of the following parameters: <code>StackName</code>,
     *         <code>StackSetName</code>, <code>TemplateBody</code>, or <code>TemplateURL</code>.
     */
    public String stackSetName() {
        return stackSetName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(templateBody());
        hashCode = 31 * hashCode + Objects.hashCode(templateURL());
        hashCode = 31 * hashCode + Objects.hashCode(stackName());
        hashCode = 31 * hashCode + Objects.hashCode(stackSetName());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetTemplateSummaryRequest)) {
            return false;
        }
        GetTemplateSummaryRequest other = (GetTemplateSummaryRequest) obj;
        return Objects.equals(templateBody(), other.templateBody()) && Objects.equals(templateURL(), other.templateURL())
                && Objects.equals(stackName(), other.stackName()) && Objects.equals(stackSetName(), other.stackSetName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GetTemplateSummaryRequest").add("TemplateBody", templateBody())
                .add("TemplateURL", templateURL()).add("StackName", stackName()).add("StackSetName", stackSetName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TemplateBody":
            return Optional.ofNullable(clazz.cast(templateBody()));
        case "TemplateURL":
            return Optional.ofNullable(clazz.cast(templateURL()));
        case "StackName":
            return Optional.ofNullable(clazz.cast(stackName()));
        case "StackSetName":
            return Optional.ofNullable(clazz.cast(stackSetName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetTemplateSummaryRequest, T> g) {
        return obj -> g.apply((GetTemplateSummaryRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudFormationRequest.Builder, SdkPojo, CopyableBuilder<Builder, GetTemplateSummaryRequest> {
        /**
         * <p>
         * Structure containing the template body with a minimum length of 1 byte and a maximum length of 51,200 bytes.
         * For more information about templates, see <a
         * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html">Template
         * Anatomy</a> in the AWS CloudFormation User Guide.
         * </p>
         * <p>
         * Conditional: You must specify only one of the following parameters: <code>StackName</code>,
         * <code>StackSetName</code>, <code>TemplateBody</code>, or <code>TemplateURL</code>.
         * </p>
         * 
         * @param templateBody
         *        Structure containing the template body with a minimum length of 1 byte and a maximum length of 51,200
         *        bytes. For more information about templates, see <a
         *        href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html">Template
         *        Anatomy</a> in the AWS CloudFormation User Guide.</p>
         *        <p>
         *        Conditional: You must specify only one of the following parameters: <code>StackName</code>,
         *        <code>StackSetName</code>, <code>TemplateBody</code>, or <code>TemplateURL</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder templateBody(String templateBody);

        /**
         * <p>
         * Location of file containing the template body. The URL must point to a template (max size: 460,800 bytes)
         * that is located in an Amazon S3 bucket. For more information about templates, see <a
         * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html">Template
         * Anatomy</a> in the AWS CloudFormation User Guide.
         * </p>
         * <p>
         * Conditional: You must specify only one of the following parameters: <code>StackName</code>,
         * <code>StackSetName</code>, <code>TemplateBody</code>, or <code>TemplateURL</code>.
         * </p>
         * 
         * @param templateURL
         *        Location of file containing the template body. The URL must point to a template (max size: 460,800
         *        bytes) that is located in an Amazon S3 bucket. For more information about templates, see <a
         *        href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html">Template
         *        Anatomy</a> in the AWS CloudFormation User Guide.</p>
         *        <p>
         *        Conditional: You must specify only one of the following parameters: <code>StackName</code>,
         *        <code>StackSetName</code>, <code>TemplateBody</code>, or <code>TemplateURL</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder templateURL(String templateURL);

        /**
         * <p>
         * The name or the stack ID that is associated with the stack, which are not always interchangeable. For running
         * stacks, you can specify either the stack's name or its unique stack ID. For deleted stack, you must specify
         * the unique stack ID.
         * </p>
         * <p>
         * Conditional: You must specify only one of the following parameters: <code>StackName</code>,
         * <code>StackSetName</code>, <code>TemplateBody</code>, or <code>TemplateURL</code>.
         * </p>
         * 
         * @param stackName
         *        The name or the stack ID that is associated with the stack, which are not always interchangeable. For
         *        running stacks, you can specify either the stack's name or its unique stack ID. For deleted stack, you
         *        must specify the unique stack ID.</p>
         *        <p>
         *        Conditional: You must specify only one of the following parameters: <code>StackName</code>,
         *        <code>StackSetName</code>, <code>TemplateBody</code>, or <code>TemplateURL</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stackName(String stackName);

        /**
         * <p>
         * The name or unique ID of the stack set from which the stack was created.
         * </p>
         * <p>
         * Conditional: You must specify only one of the following parameters: <code>StackName</code>,
         * <code>StackSetName</code>, <code>TemplateBody</code>, or <code>TemplateURL</code>.
         * </p>
         * 
         * @param stackSetName
         *        The name or unique ID of the stack set from which the stack was created.</p>
         *        <p>
         *        Conditional: You must specify only one of the following parameters: <code>StackName</code>,
         *        <code>StackSetName</code>, <code>TemplateBody</code>, or <code>TemplateURL</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stackSetName(String stackSetName);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CloudFormationRequest.BuilderImpl implements Builder {
        private String templateBody;

        private String templateURL;

        private String stackName;

        private String stackSetName;

        private BuilderImpl() {
        }

        private BuilderImpl(GetTemplateSummaryRequest model) {
            super(model);
            templateBody(model.templateBody);
            templateURL(model.templateURL);
            stackName(model.stackName);
            stackSetName(model.stackSetName);
        }

        public final String getTemplateBody() {
            return templateBody;
        }

        @Override
        public final Builder templateBody(String templateBody) {
            this.templateBody = templateBody;
            return this;
        }

        public final void setTemplateBody(String templateBody) {
            this.templateBody = templateBody;
        }

        public final String getTemplateURL() {
            return templateURL;
        }

        @Override
        public final Builder templateURL(String templateURL) {
            this.templateURL = templateURL;
            return this;
        }

        public final void setTemplateURL(String templateURL) {
            this.templateURL = templateURL;
        }

        public final String getStackName() {
            return stackName;
        }

        @Override
        public final Builder stackName(String stackName) {
            this.stackName = stackName;
            return this;
        }

        public final void setStackName(String stackName) {
            this.stackName = stackName;
        }

        public final String getStackSetName() {
            return stackSetName;
        }

        @Override
        public final Builder stackSetName(String stackSetName) {
            this.stackSetName = stackSetName;
            return this;
        }

        public final void setStackSetName(String stackSetName) {
            this.stackSetName = stackSetName;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetTemplateSummaryRequest build() {
            return new GetTemplateSummaryRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
